P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                    MACHIN.H                                */P /******************************************************************************/P /*                                                                            */P /* WARNING: DO NOT ADD ANY PROGRAM DEPENDENT DEFINITIONS.                     */P /*                                                                            */P /* This module (machin.h and machin.c) contains definitions and objects       */P /* whose values depends directly on the compilation and execution             */P /* environment, but are otherwise independent from any particular computer    */P /* program.                                                                   */P /*                                                                            */P /* The only difference between the purpose of this module and the "environ"   */P /* module is that the "environ" module contains the "essentials" whereas this */P /* module contains extra machine specific definitions and objects that will   */P /* not be required by most user modules.                                      */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_FWMACHIN  #define DONE_FWMACHIN   P /******************************************************************************/   #include <time.h>  #include "style.h"  P /******************************************************************************/  P /* Machine Alignment Constraints                                              */P /* -----------------------------                                              */P /* Some machines require that objects of particular lengths be aligned in     */P /* memory. For example, the 68000 will trap any attempt to access a word      */P /* (16 bits or an int in THINK C) at an odd address. It is important that C   */P /* programs that deal with memory at a low level be aware of such             */P /* constraints. As the constraints are always at a power of two, we defined   */P /* ALIGN_POWER to be the minimum power of two at which it is both safe and    */P /* efficient to operate.                                                      */  P /* The Macintosh requires words and longs to be aligned on word boundaries.   */P /* The PC is not fussy about alignment, but operates more efficiently at word */P /* boundaries.                                                                */ #if MAC | PC #define ALIGN_POWER (1L) #endif  P /* The Sun requires objects to be aligned on longword boundaries (=2^2).      */P /* The VMS VAX doesn't care about alignment, but operates more efficiently on */P /* longword boundaries.                                                       */
 #if SUN | VMS  #define ALIGN_POWER (2L) #endif  P /******************************************************************************/  P /* Filenames                                                                  */P /* ---------                                                                  */P /* The length and structure of filenames varies from machine to machine. The  */P /* differences addressed here are:                                            */P /*    1) The character used to separate directory specs from filenames.       */P /*    2) The maximum length of a filename.                                    */  P /* FN_DELIM must contain the character that separates directory specs from    */P /* filenames. Notice that in the VMS case, it is "]", not "."                 */   #if MAC  #define FN_DELIM ':' #endif   #if SUN  #define FN_DELIM '/' #endif   #if VAX  #define FN_DELIM ']' #endif   #if PC #define FN_DELIM '\\'  #endif  P /* The rest of this section shouldn't have to be changed, unless you          */P /* encounter a funny with your system's definition of FILENAME_MAX.           */  P /* FILENAME_MAX tells the maximum number of characters allowed in a filename  */P /* on the target machine. This symbol is supposed to be defined in stdio.h    */P /* (ANSI S7.9.1) so we don't want to override that. However, if it isn't, we  */P /* need to define a safe default length.                                      */ #ifndef FILENAME_MAX #define FILENAME_MAX 300 #endif  P /* Some VAX compilers define FILENAME_MAX to be 39, which is the maximum      */P /* length of the NAME part of a VMS filename. This is not appropriate, so we  */P /* override it.                                                               */ #if VMS  #undef FILENAME_MAX P #define FILENAME_MAX 255        /* Should really be NAM$C_MAXRSS              */ #endif  P /* Now we can use the constant to define a filename type.                     */P /* Note: For a while I defined "typedef fn_t *p_fn_t". However, this is a     */P /* pointer to an array rather than (char *) and it caused no end of problems. */" typedef char fn_t[FILENAME_MAX+1]; typedef char *p_fn_t;   P /******************************************************************************/  P /* Command Lines                                                              */P /* -------------                                                              */P /* The maximum length of command line varies from machine to machine and we   */P /* define symbols to reflect this. The reason why we don't just set this to a */P /* high value and forget about it is that FunnelWeb sometimes places          */P /* command line variables on the stack, and some machines (e.g. MAC under     */P /* THINK-C don't provide much stack space. So we have to minimize this        */P /* variable on those machines.                                                */  P /* We choose a small maximum command line on the Macintosh so as to avoid     */P /* chewing up stack space when command lines have to be pushed.               */ #if MAC  #define COMLINE_MAX 300  #endif  A /* On the Sun, 1024 is a normal command line and 2048 is safe. */  #if SUN  #define COMLINE_MAX 2048 #endif  + /* On the VMS, 1024 is usually adequate. */  #if VMS  #define COMLINE_MAX 1024 #endif  ( /* On a PC, we assume this is enough. */ #if PC #define COMLINE_MAX 300  #endif  . /* Make sure that the value is not too low. */= /* The value 300 is guaranteed by the command interpreter. */  #if COMLINE_MAX < 300 +    #error COMLINE_MAX must be at least 300.  #endif  P /* Now define a type for command lines.                                       */P /* Note: For a while I defined "typedef cl_t *p_cl_t". However, this is a     */P /* pointer to an array rather than (char *) and it caused no end of problems. */! typedef char cl_t[COMLINE_MAX+1];  typedef char *p_cl_t;   P /******************************************************************************/  P /* Line Termination                                                           */P /* ----------------                                                           */  P /* FunnelWeb has special-case code to make reading input files faster on      */P /* machines where the format of text files corresponds to the internal C      */P /* text stream model. The UNIX_EOL #define should be activated if and only    */P /* the host environment has text files consisting of a stream of bytes with   */P /* a single LF (ASCII,decimal-10,hex-0A) character being used to terminate    */P /* each line, and no special character to indicate end of file.               */P /* This is the same format as is used in the Unix operating system.           */P /* If you are in doubt about this, play it safe and define your environment   */P /* to be non-Unix, as non-Unix will work on ALL systems (including Unix).     */   #if MAC | VMS | PC) /* These systems do NOT use Unix EOLs. */  #define UNIX_EOL 0 #endif   #if SUN P /* This should really be 1 on a SUN, but I haven't got around to debugging    */P /* FunnelWeb with UNIX_EOL==1.                                                */ #define UNIX_EOL 0 #endif  P /******************************************************************************/  P /* MIssing Prototypes                                                         */P /* ----------------                                                           */P /* Compilers that are fussy about prototypes sometimes complain about calls   */P /* to the standard libraries. These declarations solve this problem.          */   #if SUN # int     fclose  P_((FILE *stream)); 2 int     fputs   P_((const char *s, FILE *stream));* int     fputc   P_((int c, FILE *stream));# int     fflush  P_((FILE *stream)); + int     remove  P_((const char *filename)); ? int     rename  P_((const char *oldname, const char *newname));  int     toupper P_((int)); int     sscanf  P_(());  int     fprintf P_(());  int     _filbuf P_(()); 3 void    *memcpy P_((void *s1, void *s2, size_t n)); 3 void    *memset P_((void *s,     int c, size_t n)); 3 int     memcmp  P_((void *s1, void *s2, size_t n)); H size_t  fread   P_((void *ptr, size_t size, size_t nobj, FILE *stream));N size_t  fwrite  P_((const void *ptr, size_t size, size_t nobj, FILE *stream)); clock_t clock   P_((void)); ! time_t  time    P_((time_t *tp));  int     printf  P_(());  #endif  P /******************************************************************************/  ' EXPORT void fn_ins P_((p_fn_t,char *)); P /* - The name stands for FileName INSert.                                     */P /* - The first argument must be a pointer to an object of type fn_t           */P /*   (containing an ordinary C character string).                             */P /* - The second argument must be a pointer to an ordinary C character string. */P /* - Both arguments must contain a full, partial, or empty filename spec.     */P /* - We will refer to the arguments as f1 and f2.                             */P /* - If there is a syntax error in either spec, fn_ins does nothing.          */P /* - Otherwise, it:                                                           */P /*      1. Analyses the two filename specifications into filename field .     */P /*      2. Replaces each field in f1 by the corresponding field in f2, but    */P /*         only if the corresponding field in f2 is non-empty.                */P /*      3. Optionally [concession to VMS] it may then replace blank fields    */P /*         in the resulting file spec in f1 by fields from the current        */P /*         global "default" directory spec.                                   */P /* The structure and fields of filenames will vary from machine to machine    */P /* and so this is not important. However, every implementation must structure */P /* the filename so that it will at least RECOGNISE a file extension           */P /* (e.g. ".lis") field.                                                       */  P /******************************************************************************/  . EXPORT void getcline P_((int,char **,char *));P /* Operating system environments vary a lot in the way in which their command */P /* language interfaces are set up. The approach taken in FunnelWeb is to      */P /* define a "standard" Unix-like command line syntax and then insist that     */P /* other environments deliver such a command line as a single string.         */P /* This function getcline must extract such a standard command line from its  */P /* environment and copy it as a single string of not more than COMLINE_MAX    */P /* characters into its third argument. A description of the "standard"        */P /* command line can be found in the options package.                          */P /* The first  argument is given to getcline and is argc from main().          */P /* The second argument is given to getcline and is argv from main().          */P /* These two arguments are given in case getcline needs them to assemble the  */P /* command line (as opposed to calling e.g. VMS CLI routines).                */P /* The third argument is the string into which the result should be placed.   */  P /******************************************************************************/  ! EXPORT float tim_real P_((void)); P /* Returns the number of seconds between the present and an unspecified, but  */P /* statically fixed time in the past.                                         */P /* Returns 0.0 if this information is unavailable                             */    EXPORT float tim_cpu P_((void));P /* Returns the number of CPU seconds consumed between the present and an      */P /* unspecified, but statically fixed time in the past.                        */P /* Returns 0.0 if this information is unavailable                             */  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                                End of MACHIN.H                             */P /******************************************************************************/