P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                  MAPPER.H                                  */P /******************************************************************************/P /*                                                                            */P /* The mapper is the first of FunnelWeb's four front end processors: (mapper, */P /* scanner, parser, analyser). The sole task of the mapper is, given the      */P /* name of a file, to create an image of that file in memory. This approach   */P /* is not wasteful of memory at all because FunnelWeb requires random access  */P /* to each input file at all times anyway so it can scramble the text around. */P /*                                                                            */P /******************************************************************************/   #include "style.h"  P /******************************************************************************/  3 EXPORT char *map_file P_((char *,char **,ulong *)); P /* Allocates a block of memory and places a Unix text stream representation   */P /* (with EOL marking end of line and no character marking end of file) of the */P /* file 'p_name' in the block of memory. Returns a pointer to the address and */P /* len of the file in the mem block in the parameters (pp_mem and p_length).  */P /* Returns NULL upon success or a pointer to an error message string upon     */P /* failure. Note: Parameters are: p_name, pp_mem, p_length.                   */P /* Note: Allocates enough memory so that there is guaranteed to be at least   */P /* two extra bytes of spare memory at the end of the mapped file. The         */P /* scanner uses this space to put EOL and EOF characters.                     */P /* Note: The mapper grabs its memory using mm_temp, so it can be recycled     */P /* as part of a call to mm_zapt.                                              */  P /******************************************************************************/P /*                               End of MAPPER.H                              */P /******************************************************************************/