P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                  MEMORY.C                                  */P /******************************************************************************/P /*                                                                            */P /* Implementation Overview                                                    */P /* -----------------------                                                    */P /* One of the tasks of this Memory Management (MM) package is to keep track   */P /* of the memory that it has allocated so that it can all be deallocated      */P /* later, in one go. To do this, the package keeps a linked list whose        */P /* elements describe the blocks allocated. Two linked lists are kept, one for */P /* temporary blocks and one for permanent blocks. Only the list for the       */P /* temporary blocks is used for deallocation. Permanent blocks are arranged   */P /* in a list so that the code for temporary blocks is also applicable.        */P /*                                                                            */P /* In order to avoid many calls to malloc() for small blocks of memory        */P /* (legend has it that some implementations of malloc() are very slow in this */P /* case), the MM package keeps a spare temporary and permanent block of       */P /* length MM_BLOCK from which it allocates small blocks. Small is defined as  */P /* <=MM_BLOCK/16. A separate malloc call is made for "Large" blocks greater   */P /* than MM_BLOCK bytes. "Large" blocks less than MM_BLOCK bytes may or may    */P /* not be allocated from a buffer block, depending on how much space is       */P /* available. See the code for the full details.                              */P /*                                                                            */P /******************************************************************************/   #include "style.h"   #include "as.h"  #include "machin.h"  #include "memory.h"   P /******************************************************************************/  P /* The environ.h file contains a definition for ALIGN_POWER which is the      */P /* exponent of the power of two corresponding to the machine's alignment      */P /* requirements. The following two constants convert that constant to more    */P /* useful forms. These definitions should never need to be changed.           */$ #define ALIGN_SIZE (1L<<ALIGN_POWER)! #define ALIGN_MASK (ALIGN_SIZE-1)   P /* Because standard malloc() can be slow on some systems for large numbers of */P /* calls requesting small blocks of memory, FunnelWeb's memory management     */P /* package MM_* allocates memory in sizeable blocks and then allocates        */P /* smaller blocks from these big blocks without reference to malloc(). The    */P /* following #define tells the MM package how big the sizeable allocated      */P /* blocks should be. The rule is then: if the requested block is greater than */P /* MM_BLOCK/16, allocate it directly using malloc(), otherwise peel off some  */P /* memory from the latest sizeable block allocated.                           */P /* In practice, MM_BLOCK should be chosen to be about 1/10 to 1/20 of the     */P /* memory available to FunnelWeb. The disadvantage of making it big is that   */P /* when memory is tight, MM will be unable to allocate a full block and about */P /* half a block of memory will be unusable. The disadvantage of making it too */P /* small is that the linked lists tracking memory allocations will grow long  */P /* and it will take a long time to free up memory between invocations of      */P /* FunnelWeb proper. The value is not critical. A value of 31K should work    */P /* well on most systems. 31K is chosen instead of 32K just to be on the safe  */P /* side of 16 bits (so who's paranoid?).                                      */ #define MM_BLOCK (31L*1024L)  P /* This definition provides the definition of the size of a "big" block; that */P /* is, one that should possibly be treated differently from the others.       */P /* The rule we use is that a big block is 1/16 of the standard block size.    */P /* This results in a maximum memory wastage of 1/16 or about 7%.              */ #define MM_BIG (MM_BLOCK >> 4)  2 /* Magic numbers help us to detect corruptions. */ #define MAGIC_HEAD  (83716343L)  #define MAGIC_TAIL  (11172363L)   : /* Set MEMTRACE to TRUE to trace all memory operations. */ #define MEMTRACE FALSE  P /******************************************************************************/  P /* The following structures define a type for the linked lists that keep      */P /* track of the allocated blocks.                                             */ typedef struct mm_t_   { P    ulong         mm_mhead; /* Magic number protecting beginning of record.    */P    ubyte_       *mm_pblok; /* Pointer to the allocated block.                 */P    ubyte_       *mm_pfree; /* Pointer to next free byte in block (ALIGNED).   */P    ulong         mm_nfree; /* Number of unused bytes available in the block.  */P    struct mm_t_ *mm_pnext; /* Pointer to the header for the next block.       */P    ulong         mm_mtail; /* Magic number protecting end of record.          */	   } mm_t;   P typedef mm_t *p_mm_t;      /* Handy to have a pointer type too.               */  P /* The following two local variables point to the head of the temporary and   */P /* permanent block lists. The first block in each list is that list's buffer. */ LOCVAR p_mm_t p_perm = NULL; LOCVAR p_mm_t p_temp = NULL;  P /******************************************************************************/  ! LOCAL void mm_check P_((p_mm_t));  LOCAL void mm_check(p_mm) D /* Checks the magic numbers in the specified block header object. */ p_mm_t p_mm; { /  as_cold(p_mm!=NULL,"mm_check: Null pointer."); C  as_cold(p_mm->mm_mhead==MAGIC_HEAD,"mm_check: Corrupted header."); D  as_cold(p_mm->mm_mtail==MAGIC_TAIL,"mm_check: Corrupted trailer."); }   P /******************************************************************************/  ! LOCAL void mm_align P_((p_mm_t));  LOCAL void mm_align(p_mm) P /* Some machines are very fussy about the memory alignment of allocated       */P /* objects. To solve this problem, the mm_pfree pointer is always kept at an  */P /* "aligned" address. This function accepts a pointer to the header of a      */P /* block whose mm_pfree pointer is possibly unaligned and consumes bytes      */P /* until mm_pfree is aligned.                                                 */ p_mm_t p_mm; {   ubyte bump;  ubyte consume;     mm_check(p_mm);  L  /* Work out how many bytes are sticking out over the alignment boundary. */.  bump = ((ulong) p_mm->mm_pfree) & ALIGN_MASK;  .  /* Return if the block is already aligned. */  if (bump==0) return;   P  /* Otherwise work out how many bytes we have to consume to become realigned. */  consume=ALIGN_SIZE-bump;   P  /* If there are not enough bytes left in the block to allow the free pointer */P  /* to be aligned, then simply set the available bytes to zero and return. It */P  /* doesn't matter if we don't achieve alignment in this case as if           */P  /* mm_nfree==0, nothing can ever be allocated at the misaligned address.     */8  if (consume>p_mm->mm_nfree) {p_mm->mm_nfree=0; return;}  <  /* Consume the bytes required to align the free pointer. */  p_mm->mm_pfree += consume;   p_mm->mm_nfree -= consume;   <  /* Check that we have properly aligned the free pointer. */4  as_cold((((ulong) p_mm->mm_pfree) & ALIGN_MASK)==0,'          "mm_align: Failed to align.");  }   P /******************************************************************************/  $ LOCAL p_mm_t mm_newblk P_((size_t)); LOCAL p_mm_t mm_newblk(blk_len) P /* Creates a new block containing (after alignment) at least blk_len bytes.   */P /* Returns a pointer to the header for the block.                             */ size_t blk_len;  {   p_mm_t  p_mm;  ubyte_ *p_bl;  P  /* Allocate the header and the block itself. Because we are guaranteeing     */P  /* that the resultant block will have at least blk_len bytes free, we have   */P  /* to take into account alignment and add in ALIGN_SIZE when requesting mem. */7  p_mm=(p_mm_t  ) malloc((size_t)         sizeof(mm_t)); 7  p_bl=(ubyte_ *) malloc((size_t) (blk_len+ALIGN_SIZE));   if (p_mm==NULL || p_bl==NULL)    {2     fprintf(stderr,"mm_newblk: Out of memory!\n");P     fprintf(stderr,"FunnelWeb doesn't cope well when it runs out of memory.\n");G     fprintf(stderr,"It falls in a heap just as it is about to now.\n"); 7     as_bomb("Stand by for an ungraceful termination!");     }  .  /* Fill in the fields of the block header. */  p_mm->mm_mhead = MAGIC_HEAD;   p_mm->mm_pblok = p_bl;   p_mm->mm_pfree = p_bl; %  p_mm->mm_nfree = blk_len+ALIGN_SIZE;   p_mm->mm_pnext = NULL;   p_mm->mm_mtail = MAGIC_TAIL;   2  /* Align the free pointer in the header block. */  mm_align(p_mm);  7  /* Return a pointer to the header block we created. */ 
  return p_mm;  }   P /******************************************************************************/  , LOCAL p_void mm_alloc P_((p_mm_t *,size_t));" LOCAL p_void mm_alloc(pp_mm,bytes)P /* 'pp_mm' must be a pointer to either p_perm or p_temp.                      */P /* 'bytes' is the number of bytes required.                                   */P /* Allocates the required memory and returns an aligned pointer to it.        */P /* Bombs the program if the memory is not available.                          */ p_mm_t *pp_mm;
 size_t bytes;  { P  p_mm_t p_from;    /* Pointer to header for block from which we finally alloc.*/P  ubyte_ *p_result; /* The result pointer returned to the caller.              */  P  /* If the list is empty, create a "buffer block" and put it in the list.     */7  if (*pp_mm==NULL) *pp_mm=mm_newblk((size_t) MM_BLOCK);   P  /* If there is room in the current buffer block, we can allocate directly.   */P  /* Note that we may be allocating a "big" block here, but as long as it fits */P  /* into the free space of the current buffer block, we don't care.           */C  if ((*pp_mm)->mm_nfree >= bytes) {p_from = *pp_mm; goto dole_out;}   P  /* At this point we know that there is not enough space in the current       */P  /* buffer block. This could mean that we have an extra big allocation on our */P  /* hands in which case, we should malloc up a block specially for this       */P  /* request. It could also mean that we are running out of space in our       */P  /* buffer block in which case a new one must be allocated.                   */  if (bytes >= MM_BIG)     {P     /* If the request is BIG, allocate a special block for it and insert the  */P     /* block in the block list just after the buffer block, leaving the       */P     /* buffer block the first in the block list.                              */"     p_mm_t p_tmp=mm_newblk(bytes);'     p_tmp->mm_pnext=(*pp_mm)->mm_pnext;      (*pp_mm)->mm_pnext=p_tmp;      p_from=p_tmp;     }  else     {P     /* If the request is not big, our buffer block is probably too empty and  */P     /* so it is time to create a new one. Allocate a new buffer block and     */P     /* make it the new head of this block list. Note that by giving up on the */P     /* previous buffer, we waste at most 1/16 of the block we are giving up   */P     /* on. This cost is reasonable in exchange for all the speed this gives.  */.     p_mm_t p_tmp=mm_newblk((size_t) MM_BLOCK);     p_tmp->mm_pnext=(*pp_mm);      (*pp_mm)=p_tmp;      p_from=p_tmp;     }  
  dole_out:?  /* Jump here to dole out 'bytes' bytes from block 'p_from'. */   p_result=p_from->mm_pfree;   p_from->mm_pfree += bytes;   p_from->mm_nfree -= bytes;   mm_align(p_from);  B  /* Ensure that the pointer being returned is properly aligned. */.  as_cold((((ulong) p_result) & ALIGN_MASK)==0,,          "mm_alloc: Result is misaligned.");    /* Return the result. */   return (p_void) p_result; }   P /******************************************************************************/   EXPORT p_void mm_perm(bytes)
 size_t bytes;  {  #if MEMTRACEF  printf("TRACE: mm_perm: Allocating %lu bytes of permanent memory.\n", (ulong) bytes);  #endif   return mm_alloc(&p_perm,bytes); }   P /******************************************************************************/   EXPORT p_void mm_temp(bytes)
 size_t bytes;  {  #if MEMTRACEF  printf("TRACE: mm_temp: Allocating %lu bytes of temporary memory.\n", (ulong) bytes);  #endif   return mm_alloc(&p_temp,bytes); }   P /******************************************************************************/   EXPORT void mm_zapt() P /* This function frees all the memory blocks recorded in the temporary        */P /* memory list. We choose to free them rather than merely re-using them       */P /* directly because they may not all be the same size, and we want to give    */P /* the built-in memory manager a chance to smooth out the heap.               */ {  #if MEMTRACEI  printf("TRACE: mm_zapt: Attempting to release all temporary memory.\n");  #endif    while (p_temp != NULL)     {     p_mm_t p_mm=p_temp;      mm_check(p_temp);  #if MEMTRACEN     printf("TRACE: mm_zapt: Deallocating a big chunk of temporary memory.\n"); #endif     free(p_temp->mm_pblok);      p_temp=p_temp->mm_pnext;     free(p_mm);     } }   P /******************************************************************************/P /*                             End of MEMORY.C                                */P /******************************************************************************/