P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                  MEMORY.H                                  */P /******************************************************************************/P /*                                                                            */P /* Introduction                                                               */P /* ------------                                                               */P /* This package provides a memory management facility for FunnelWeb.          */P /* The conventional MALLOC does not suit the needs of FunnelWeb. The          */P /* following notes give an idea of why:                                       */P /*                                                                            */P /* 1. At the times where FunnelWeb requires memory, it is nearly always       */P /*    the case that failure to provide the memory should result in a bomb.    */P /*    It therefore makes sense to wrap MALLOC up inside another function      */P /*    that, at the very least, checks the status from malloc and bombs        */P /*    the program if the requested memory is not available.                   */P /*                                                                            */P /* 2. Because FunnelWeb proper can be invoked an indefinite number of         */P /*    times from the FunnelWeb command interpreter, it is very important      */P /*    to reclaim all the memory used by each invocation. This could be        */P /*    done by explicitly tearing apart the data structures constructed        */P /*    for each run. However, this is very messy, requiring detailed           */P /*    knowledge of the data structures. A far simpler, safer scheme is to     */P /*    arrange for a memory manager to keep track of all the memory that it    */P /*    allocates and to provide a single call to free it all. This facility    */P /*    is provided by this package.                                            */P /*                                                                            */P /* 3. In addition to the TEMPORARY memory allocations described in (2) above, */P /*    it should also be possible to make permanent allocations.               */P /*                                                                            */P /* 4. FunnelWeb uses linked lists a lot and hence will make many requests     */P /*    for small chunks of memory (e.g 10 bytes). Legend has it that some      */P /*    malloc libraries are very inefficient in this case, and that it is      */P /*    better to use malloc to allocate a large chunk of memory and dole it    */P /*    out yourself. This package does this too.                               */P /*                                                                            */P /* For all these reasons, FunnelWeb memory management has been handed over to */P /* this package which provides services that satisfy the conditions outlined  */P /* above.                                                                     */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_MEMORY  #define DONE_MEMORY   P /******************************************************************************/   #include "style.h"  P /******************************************************************************/  # EXPORT p_void mm_perm P_((size_t)); P /* Allocates a block of memory of the specified size (specified in bytes) and */P /* returns a pointer to the new block of memory. Bombs the program if the     */P /* memory is not available. Memory allocated using mm_perm is permanently     */P /* allocated and cannot be freed.                                             */  # EXPORT p_void mm_temp P_((size_t)); P /* Allocates a block of memory of the specified size (specified in bytes) and */P /* returns a pointer to the new block of memory. Bombs the program if the     */P /* memory is not available. Memory allocated using this function can later be */P /* freed in its entirely by making a call to mm_zapt.                         */   EXPORT void mm_zapt P_((void)); P /* This function can be called at any time. Its effect is to free up all the  */P /* memory allocated using mm_temp since the last call to mm_zapt or the start */P /* of the program, whichever is the more recent.                              */  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                               End of MEMORY.H                              */P /******************************************************************************/