P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                    MISC.H                                  */P /******************************************************************************/P /*                                                                            */P /* This package contains a ragbag of FunnelWeb-specific functions that didn't */P /* seem to have a home anywhere else.                                         */P /*                                                                            */P /******************************************************************************/   #include "style.h"   #include "data.h"   P /******************************************************************************/  P /* The following functions each write a string to one or more output streams. */P /* The code is as follows:                                                    */P /*    wr - means write the string only.                                       */P /*    wl - means write the string followed by a '\n'.                         */P /*     s - The f_s output stream (the console/screen).                        */P /*     j - The f_j output stream (the journal file).                          */P /*     l - The f_l output stream (the listing file).                          */P /* These functions are hard wired to the f_s, f_j, and f_l global variables.  */   EXPORT void wr_s P_((char *)); EXPORT void wr_j P_((char *)); EXPORT void wr_l P_((char *));   EXPORT void wl_s P_((char *)); EXPORT void wl_j P_((char *)); EXPORT void wl_l P_((char *));   EXPORT void wr_sj P_((char *));  EXPORT void wl_sj P_((char *));     EXPORT void wr_sjl P_((char *));  EXPORT void wl_sjl P_((char *));  P /******************************************************************************/    EXPORT char *chabbrev P_((int));P /* If the argument is non-printable in the range [0,127], returns a pointer   */P /* to a constant string containing the mnemonic abbreviation for the          */P /* character (e.g. 10="LF"). Otherwise returns the empty string.              */  P /******************************************************************************/   EXPORT sign signof P_((long));- /* Returns -1 if its argument is negative. */ - /* Returns  0 if its argument is zero.     */ - /* Returns  1 if its argument is positive. */   P /******************************************************************************/  2 EXPORT char * eq_files P_((char *,char *,bool *));P /* Performs an exact binary comparison of the files named name1 and name2.    */P /* If there is no error during the comparison, returns NULL and the boolean   */P /* parameter carries the result of the comparison with TRUE=>Files identical. */P /* If there is an error during the comparison, the boolean parameter is set   */P /* to FALSE and the function returns a pointer to a string describing the     */P /* error in terms of "the first file" and "the second file".                  */  P /******************************************************************************/  ! EXPORT bool fexists P_((char *)); P /* Returns TRUE iff a file of the name given in the parameter exists.         */P /* (Does this by attempting to open the file. If it succeeds, it closes it    */P /* again).                                                                    */  P /******************************************************************************/    EXPORT char *fn_temp P_((void));P /* Creates a filename (not containing a directory component) for which there  */P /* is no corresponding file in the current directory.                         */P /* Returns a pointer to a static array containing the filename.               */P /* Each time this function is called, the new filename overwrites the old.    */P /* This function was created after it was discovered that, on some systems,   */P /* the standard library function "tmpnam" returns the name of a file in the   */P /* /tmp partition. This would not be a problem were it not for the fact that  */P /* generally, files cannot be renamed across partitions!                      */  P /******************************************************************************/  " EXPORT void strupper P_((char *));P /* Converts all lower case letters in the argument string to upper case.      */  P /******************************************************************************/P /*                                End of MISC.H                               */P /******************************************************************************/