P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                  OPTION.H                                  */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_OPTION  #define DONE_OPTION   P /******************************************************************************/   #include "style.h"   #include "machin.h"  #include "help.h"   P /******************************************************************************/  P /* THE B7 OPTION                                                              */P /* -------------                                                              */P /* When FunnelWeb was first ported to different machines and the regression   */P /* testing was activated, a most irritating occurance was the failure of the  */P /* results of tests on different machines to compare, because of minor        */P /* differences in implementation. For example, error messages that contained  */P /* file names would differ because the directory name on different machines   */P /* was different. Another example was error messages that quoted              */P /* implementation limits. This problem was solved by creating the B7 option   */P /* which instructs FunnelWeb to suppress all output that is                   */P /* non-deterministic, machine specific, or which in any other way would cause */P /* an unncessary failure of the test suite.                                   */  P /* The following symbol provides a simple replacement for filenames in error  */P /* messages.                                                                  */! #define SUPPNAME "<<Suppressed>>" ! #define SUPPVAL  "<<Suppressed>>"   P /******************************************************************************/  P /* The following structure stores all the information that can be             */P /* communicated in one or more command lines. An important aspect of the      */P /* structure is that it is totally self contained; it does not contain any    */P /* pointers to outside structures such as command lines.                      */P /* The rather strange field names are explained as follows:                   */P /*    1) Local names must be distinct to 8 characters (for portability).      */P /*    2) All structure field names should be unique (for portability).        */P /*       Some of the older compilers use a single field structure name space. */P /*    3) The op_ is used as a prefix for entities in this whole package.      */P /*    4) The next letter is the option letter itself. It is not intended that */P /*       the command line option names be tightly bound to the internal       */P /*       identifier names -- the command line names are just convenient.      */P /*    5) The next letter gives the type: [B]oolean, [S]tring, [I]nteger.      */   typedef struct   { '    bool  op_f_b;  /* The input file. */     fn_t  op_f_s;  )    bool  op_j_b;  /* The journal file. */     fn_t  op_j_s;  /    fn_t  op_i_s;  /* Include file (default). */   0    bool  op_o_b;  /* Product files (default). */    fn_t  op_o_s;  /    bool  op_t_b;  /* Typeset file (default). */     fn_t  op_t_s;  /    bool  op_l_b;  /* Listing file (default). */     fn_t  op_l_s;  B    bool  op_d_b;  /* Delete output files that have not changed? */  ?    uword op_c_i;  /* Lines of error context in listing file. */   L    bool  op_q_b;  /* Quiet mode. Console chatter suppressed if turned on. */  I    bool  op_s_b;  /* Send errors to the screen with specified context. */     uword op_s_i;  A    bool  op_w_b;  /* Set maximum line length of product files. */     uword op_w_i;  B    bool  op_x_b;  /* Execute specified file in FunnelWeb shell. */    fn_t  op_x_s;  4    bool  op_k_b;  /* Interactive (keyboard) mode. */  .                   /* Dump flags:            */.    bool  op_b1_b; /* Dump input file image. */.    bool  op_b2_b; /* Dump line list.        */.    bool  op_b3_b; /* Dump token list.       */.    bool  op_b4_b; /* Dump macro table.      */.    bool  op_b5_b; /* Dump document list.    */.    bool  op_b6_b; /* Dump time summary.     */I    bool  op_b7_b; /* Don't write anything non-deterministic or machine */ I                   /*    specific. This option is designed to assist in */ I                   /*    regression testing.                            */      &    bool  op_h_b;  /* Help messages. */    hn_t  op_h_s;	   } op_t;    typedef op_t *p_op_t;   P /******************************************************************************/    EXPORT void op_ini P_((p_op_t));P /* Initializes the specified options structure with default values.           */P /* This includes ALL the fields of the structure. If, for example, the        */P /* default value of op_l_b is FALSE, op_l_s will be set to the empty string.  */  8 EXPORT bool op_add P_((p_op_t,p_cl_t,void (*)(char *)));P /* Parses the specified command line and places the information given in the  */P /* command line into specific fields of the options structure. The options    */P /* structure should be entirely defined upon entry, as this parsing function  */P /* only ADDS information present in the command line. Call op_ini if you      */P /* don't want to initialize all the fields manually.                          */P /* The comline string should start with the leading command (e.g. "fw").      */P /* However, he leading command is ignored.                                    */P /* Returns FALSE: One or more syntax errors have been detected. One or error  */P /*                messages have been written using the funtion argument.      */P /*                *p_op unchanged.                                            */P /* Returns TRUE : No syntax errors. Comline information placed in *p_op.      */  1 EXPORT void op_wri P_((p_op_t,void (*)(char *))); P /* Writes a text representation of the specified options record using the     */P /* function argument.                                                         */  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                              End of OPTION.H                               */P /******************************************************************************/  