P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                   SCANNER.C                                */P /******************************************************************************/P /*                                                                            */P /* Introduction                                                               */P /* ------------                                                               */P /* The FunnelWeb scanner is a little messy because it deals with two          */P /* structures at the same time while attempting to be efficient. On the one   */P /* hand it is busy constructing the line list. This means that it has to keep */P /* an eye out for end of line characters ('\n'=EOL) so that it can add a line */P /* record whenever it sees one. On the other hand, it has to scan the input   */P /* file into a token stream consisting of text tokens and special tokens      */P /* which usually have no regard for end of lines. It is tempting to divide    */P /* these two functions up (into perhaps a LINER and a TOKENIZER). However,    */P /* the presence of the include file facility would make this messy. Also, the */P /* tokenizer has to count end of line markers so that it can generate         */P /* correctly positioned diagnostics.                                          */P /*                                                                            */P /* The long and short of it all is that the best way to do the scanning seems */P /* to be to run a liner and a tokenizer as parallel layers. The liner         */P /* extracts characters from the input file and hands them to the tokenizer.   */P /* It also keeps an eye out for newline characters, sending a line record off */P /* whenever it sees one, and counting lines. The tokenizer receives the       */P /* characters from the liner and performs the tokenize operation.             */P /*                                                                            */P /* Notes                                                                      */P /* -----                                                                      */P /* - Currently FunnelWeb recognises only two characters as whitespace.        */P /*   These are ' ' and EOL.                                                   */P /*                                                                            */P /******************************************************************************/   #include <ctype.h> #include <limits.h>  #include "style.h"   #include "as.h"  #include "clock.h" #include "data.h"  #include "dump.h"  #include "list.h"  #include "lister.h"  #include "machin.h"  #include "mapper.h"  #include "memory.h"  #include "misc.h"  #include "option.h"  #include "scanner.h"  P /******************************************************************************/  P /* The "special" character is the character that is used to introduce a       */P /* "special sequence". FunnelWeb allows the user to change this character so  */P /* as to cater for documents where the "default" character is common. This    */P /* definition defines what the default character is.                          */ #define CH_DSPE ('@')   P /* FunnelWeb allows include files which are handled by the scanner by placing */P /* recursive calls to scan_file. A maximum is placed on the level of nested   */P /* includes. This acts as a good sanity check as well as catching recursive   */P /* include files which are never a sensible construct in FunnelWeb as         */P /* FunnelWeb does not provide any conditional construct.                      */ #define MAX_INCL (10)   P /* FunnelWeb is very conservative about what characters it will allow in its  */P /* input and output files. Currently the only characters allowed are          */P /* printables and end of lines. When FunnelWeb does spot an illegal character */P /* it needs to be able to draw the user's attention to the character. The     */P /* best way to do this is to point to it in the listing file. However, if the */P /* character is banned, it cannot appear in the listing file! The problem is  */P /* solved by having the scanner replace all illegal characters in each mapped */P /* file by the following character. This eliminates further problems.         */ #define CENSORCH ('?')  P /* Following the Unix convention, mapped in files are not terminated with an  */P /* end-of-file character. However, the presence of such a character at the    */P /* end of the mapped file simplifies scanning and so we add one. This         */P /* definition defines what the character is to be. It doesn't matter what the */P /* character is, so long as it cannot legally appear in the file. A control   */P /* character is a good choice as these are filtered out by the liner (see     */P /* above).                                                                    */P /* We undef EOF (from <stdio.h>) because it is too dangerously close to EOFCH.*/P /* (EOF wasn't redefined as that might confuse readers used to <stdio.h>.     */P /* However, we still use EOF as an acronym for End Of File.                   */ #define EOFCH (26)
 #undef EOF  P /* Tokens have a field for a general attribute which has meaning for some     */P /* token kinds. For other kinds, it has no meaning. This constant is used to  */P /* indicate a "don't care" value.                                             */ #define DONTCARE 0  P /* A nominal maximum value for the maximum length of an input line.           */ #define INMAXINF (ULONG_MAX)  P /******************************************************************************/  P /* The following type is used in the suite of pragma routines for parsing.    */ typedef 	    struct       {P       ps_t  pt_ps;    /* Position of the start of this argument.              */P       char *pt_pstr;  /* Pointer to a string containing the argument.         */P       char *pt_pinl;  /* Pointer to first byte of the argument in commndline. */      } pt_t; typedef pt_t *p_pt_t;   P /******************************************************************************/  P                         /* Variables Instantiated Over The Entire Scan        */P                         /* -------------------------------------------        */P LOCVAR p_ck_t p_mapp;   /* Pointer to mapper's clock.                         */P LOCVAR p_ck_t p_scan;   /* Pointer to scanner's clock.                        */P LOCVAR ulong globalno;  /* Global line number of line being scanned.          */P LOCVAR ulong inclevel;  /* Include level of current file. Top file is zero.   */P LOCVAR bool  seenind;   /* TRUE iff we have seen an indentation pragma.       */P LOCVAR ps_t  ps_ind;    /* seenind==TRUE => ps_ind is position of pragma.     */P LOCVAR bool  seentyp;   /* TRUE iff we have seen a typesetter pragma.         */P LOCVAR ps_t  ps_typ;    /* seentyp==TRUE => ps_typ is position of pragma.     */P LOCVAR bool  seenlimo;  /* TRUE iff we have seen an out lin len limit pragma. */P LOCVAR ps_t  ps_limo;   /* seenlimo==TRUE => ps_limo is position of pragma.   */  P                         /* Variables Instantiated Over The Current File       */P                         /* --------------------------------------------       */P LOCVAR ulong inln_max;  /* Maximum permitted length of an input line.         */P LOCVAR char  specialch; /* Current special (escape) character.                */P LOCVAR char  *p_eof;    /* Pointer to EOFCH byte at the end of current file.  */P LOCVAR ulong  localno;  /* Local line number of line being scanned.           */  P                         /* Variables Instantiated Over The Current Line       */P                         /* --------------------------------------------       */P LOCVAR char  *p_sol;    /* Pointer to Start (first char) Of current Line.     */P LOCVAR char  *p_ch;     /* Pointer to current character in current line.      */P LOCVAR char   ch;       /* *p_ch.                                             */  P /******************************************************************************/P /*                          Line Processing Layer                             */P /******************************************************************************/P /*                                                                            */P /* This mini-section contains the two routines (prepline and NEXTCH) that     */P /* take care of the line based-scanning and feed characters to the            */P /* token-based scanner routines which have the top level of control.          */P /* After mapping in a file to be read, place a call to prepline passing the   */P /* address of the first byte of the mapped file as an argument. At that       */P /* point the current position will be the first byte on the first line and    */P /* the "variables instantiated over the current line" will be well defined.   */P /* Calls to NEXTCH then move the position through the mapped file one byte at */P /* a time, stopping at the end of file at which point calls will not move the */P /* marker which will point to the EOF character.                              */P /*                                                                            */P /******************************************************************************/  ! LOCAL void prepline P_((char *));  LOCAL void prepline(p_line) P /* This function should be called at the end of each line to prepare the next */P /* line for scanning. The user of the liner mini-package should place a       */P /* single call to this function at the start of scanning a mapped file.       */P /* The user should then place calls to NEXTCH (which calls prepline when      */P /* necessary).                                                                */P /* This function serves two purposes:                                         */P /*    1. It looks at the next line and converts all non-printables into       */P /*       CENSORCH and issues errors for each non-printable.                   */P /*    2. It initializes the line scanning variables for the next line.        */P /* The argument is a pointer to the first byte of the next line.              */
 char *p_line;  { P  char *p;  /* Scans through the line and winds up sitting on the EOL.         */  P  /* Test to see if the "line" we have been given is the end of file marker.   */P  /* We have to be careful here because the byte we are using to mark the end  */P  /* of file could appear as an illegal unprintable. This is the reason for    */P  /* the test p_line==p_eof.                                                   */%  if (*p_line==EOFCH && p_line==p_eof)     {H     /* The line we have to process is in fact the end of file marker. */     p_sol = p_line;      p_ch  = p_line;      ch    = EOFCH;     return;     }  P  /* At this point we know that we are faced with a run of bytes terminated by */P  /* an EOL character (we know this cos we put an EOL before EOF earlier on).  */P  /* We know that we have a line, so we can now bump up the line counters.     */  globalno++;  localno++;   P  /* Run through the line checking for non-printables and issuing errors.      */  p = p_line;  while (*p != EOL)     { P      /* The following test tests to see if the character is a printable in    */P      /* seven bit ascii. FunnelWeb is not currently designed to work with     */P      /* any character set other than seven-bit ascii and so we flag and       */P      /* convert all out-of-range characters here before they are exposed to   */P      /* the rest of the scanner code which assumes that each line that it is  */P      /* handed consists entirely of printables except for the EOL char on the */P      /* end and possibly an EOF char at the "Start" of a line.                */O      /* In particular, the NEXTCH macro will fail on machines with siged     */ P      /* chars if non-printables are not removed. It goes into an infinite     */P      /* loop.                                                                 */P      /* Note: I don't use library function "isprint" here because on the vax  */P      /* it's definition is too loose (seems to accept characters with the top */P      /* bit set as printable).                                                */<      if (!isascprn(*p))  /* If not a printable character. */        {         ps_t ps;         char c = *p;$         ubyte_ uc = *((ubyte_ *) p);          ps.ps_line   = globalno;"         ps.ps_column = p-p_line+1;#         if (strlen(chabbrev(c))==0)             sprintf(linet1,T               "Non printable character (Sym=<none>, Dec=%03u, Hex=%02X, Oct=%03o).",9               (unsigned) uc,(unsigned) uc,(unsigned) uc);          else            sprintf(linet1,P               "Non printable character (Sym=%s, Dec=%03u, Hex=%02X, Oct=%03o).",J                    chabbrev(c),(unsigned) uc,(unsigned) uc,(unsigned) uc);         lr_err(&ps,linet1);          *p=CENSORCH;        }	      p++;      } B  /* Assert: p_line points to the start of the current line.     */B  /* Assert: p points to the EOL at the end of the current line. */  +  /* Check that the line is not too long. */   if ((p-p_line)>inln_max)     {     ps_t ps;     ps.ps_line   = globalno;     ps.ps_column = inln_max+1;Q     lr_err(&ps,"Input line is too long (this character is the first offender)."); P     sprintf(linet1,"Currently, the maximum allowable input line length is %lu.",-                    (unsigned long) inln_max);      lr_mes(&ps,linet1); K     lr_mes(&ps,"Note: You can change this using a pragma directive (@p).");     }  %  /* Now check for trailing spaces. */ &  if ((p != p_line) && (*(p-1) == ' '))    {     ps_t ps;     ps.ps_line   = globalno;     ps.ps_column = p-p_line;K     lr_war(&ps,"Line has trailing spaces up to and including this space.");     }  F  /* Construct a line record and append the record to the line list. */F  /* Note that the line scrap encompasses the trailing EOL.          */  {   ln_t line;#   line.ln_global        = globalno; "   line.ln_local         = localno;!   line.ln_body.sc_first = p_line;    line.ln_body.sc_last  = p;@   /* Note: We do not set sc_white as it is not used in lines. */   ls_add(line_list,PV &line);   }  I  /* Finally, set the line scanning variables to the start of the line. */ I  /* We can't do this earlier in case the start of the line was a       */ I  /* non-printable and got substituted (ch might pick it up).           */   p_sol =  p_line;   p_ch  =  p_line;   ch    = *p_line;    } /* End of prepline. */  P /* NEXTCH can be called continuously after an initializing call to prepline.  */P /* After a call to NEXTCH, p_sol, p_ch, ch are all well-defined. p_sol points */P /* to the start of the current line, p_ch points to the current character,    */P /* and ch contains *p_ch. NEXTCH can be called repeatedly forever. When it    */P /* hits the EOF character, it sticks on it and returns it forever.            */P /* Note: The "ch<' '" is an optimized form of "(ch==EOL)||(ch=EOFCH)". Speed  */P /* is very important here as this macro is called in scanning tightloops.     */P /* This line of code is a little tricky so read it carefully.                 */P /* WARNING: The ch<' ' will cause an infinite loop if a character appears     */P /* that satisfies this condition without being EOF or EOL (e.g. a control     */P /* char (meant to be filtered out earlier) or a top-bit-set character on      */P /* machines with signed character type.                                       */O #define NEXTCH {if (ch<' ') {if (ch==EOL) prepline(p_ch+1);} else ch= *++p_ch;}   P /******************************************************************************/P /*                           Scanner Support Routines                         */P /******************************************************************************/   LOCAL ps_t *psofch P_((void)); LOCAL ps_t *psofch()P /* Returns a pointer to an internal static ps structure holding the line and  */P /* column number of the current character ch.                                 */ {m  STAVAR ps_t chps;  chps.ps_line   = globalno;#  chps.ps_column = p_ch-p_sol+1;#  return &chps; }#  P /******************************************************************************/  ! LOCAL void grabchps P_((p_ps_t));  LOCAL void grabchps(p_ps)NP /* Writes the position of the current ch into the argument position struct.   */ p_ps_t p_ps; {*  p_ps->ps_line   = globalno;   p_ps->ps_column = p_ch-p_sol+1; }   P /******************************************************************************/  . LOCAL void sendspec P_((p_ps_t,tk_k_t,ubyte));* LOCAL void sendspec(p_tkps,tk_kind,tk_gen)P /* Appends a non-text token of kind tk_kind to the end of the token list.     */P /* p_ps is a pointer to a position structure giving the position of the       */P /* first character of the token. tk_gen is the general token attribute.       */ p_ps_t p_tkps; tk_k_t tk_kind;u ubyte  tk_gen; {h  tk_t token;   token.tk_kind        = tk_kind;  ASSIGN(token.tk_ps,*p_tkps);e  token.tk_sc.sc_first = NULL;s  token.tk_sc.sc_last  = NULL;o  token.tk_sc.sc_white = TRUE;e  token.tk_gen         = tk_gen;   ls_add(token_list,PV &token); }   P /******************************************************************************/  4 LOCAL void sendtext P_((p_ps_t,char *,char *,bool));3 LOCAL void sendtext(p_tkps,p_first,p_last,is_white)mP /* Appends a text token to the end of the token list.                         */P /* IN: p_ps is a pointer to a position structure giving the position of the   */P /*     first character of the token.                                          */P /* IN: p_first and p_last point to the first and last byte of the text scrap. */P /* IN: is_white should be set to TRUE iff scrap is entirely whitespace.       */ p_ps_t p_tkps; char  *p_first;h char  *p_last; bool   is_white; {s  tk_t token;  3  /* Empty text scraps should never be generated. */ A  as_cold(p_first<=p_last,"sendtext: Text scrap bounds are bad.");a  G  /* If ch=EOL then we should be scanning more text, not shipping it! */tF  as_cold(ch!=EOL,"senttext: Shipping text while still more to scan.");    /* Send the text token. */    token.tk_kind        = TK_TEXT;  ASSIGN(token.tk_ps,*p_tkps);    token.tk_sc.sc_first = p_first;  token.tk_sc.sc_last  = p_last; !  token.tk_sc.sc_white = is_white; !  token.tk_gen         = DONTCARE;*  ls_add(token_list,PV &token); }n  P /******************************************************************************/   LOCAL void add_eof P_((void)); LOCAL void add_eof()P /* This function adds terminators to the line and token list.                 */P /*    1. It adds a TK_EOF token to the end of the token list.                 */P /*    2. It adds a visible <eof> line to the end of the line list.            */P /* This assists the parser by allowing it to point diagnostic messages to a   */P /* visible EOF marker rather than pointing vaguely to the end of the last     */P /* line of the input file which (by the way) may not even exist!              */ {*)  STAVAR char *eofstr = "<End-Of-File>\n";*  ln_t line;*	  ps_t ps;a  P  /* When the liner mini package encounters an end of file marker, it stops    */P  /* dead on the marker and returns EOFCH forever. scan_file() eventually gets */P  /* the message and drops out. However, in all of this, the line numbers are  */P  /* not incremented to indicate that we have moved to an EOF line. This is    */P  /* intended, as we do not want EOFs to appear in the listing for include     */P  /* files; only at the end of the main input file. Thus, here we effectively  */P  /* perform the liner function of moving from the last line of the input file */P  /* to the imaginary line containing the EOF marker. This is done by          */P  /* incrementing the line numbers. Note that the fact that these line number  */P  /* variables are incorrect from the point of detection of the final EOF to   */P  /* here doesn't matter as no tokens or diagnostics are ever added after an   */P  /* EOF is detected.                                                          */  globalno++;  localno++;c  .  /* Add a line to represent the EOF marker. */"  line.ln_global        = globalno;!  line.ln_local         = localno;i   line.ln_body.sc_first = eofstr;1  line.ln_body.sc_last  = eofstr+strlen(eofstr)-1;p?  /* Note: We do not set sc_white as it is not used in lines. */   ls_add(line_list,PV &line);  7  /* Add a TK_EOF token to the end of the token list. */a  ps.ps_line   = globalno;t  ps.ps_column = 1;  sendspec(&ps,TK_EOF,DONTCARE);* }l  P /******************************************************************************/P /*                              The Scanner Proper                            */P /******************************************************************************/    LOCAL void skiptoeol P_((void)); LOCAL void skiptoeol() {a  while (ch != EOL)     NEXTCH;g }   P /******************************************************************************/  L /* The incl_fil function calls this, so we have to declare it in advance. */" LOCAL void scan_file P_((char *));  ! LOCAL void incl_fil P_((p_ps_t));o LOCAL void incl_fil(p_ps)tP /* Upon entry, the current character is the "i" of an "@i" sequence. Our task */P /* is first to see if the sequence occurred at the start of a line (the only  */P /* point at which it is legal) and issue an error if it isn't. If it is legal,*/P /* we have to read in the specified file and scan that. The included file     */P /* replaces exactly the line starting with the "@i" command and we return     */P /* to the "calling" file with the current position being the EOL character of */P /* the include line.                                                          */ p_ps_t p_ps; {NH  /* Complain if the include directive was not at the start of a line. */  if (p_ch-1 != p_sol)*    {H     lr_err(p_ps,"Include sequence must be at the beginning of a line.");$     lr_mes(p_ps,"Include ignored.");     skiptoeol();     return;t    }  L  /* The include command should be followed by a blank. Get the next char. */  NEXTCH;  5  /* Complain if the next character is not a blank. */;  if (ch != ' ')i    {     ps_t ps;     ASSIGN(ps,*p_ps);      ps.ps_column+=2;E     lr_err(&ps,"Include sequence (@i) must be followed by a blank.");*1     lr_mes(&ps,"Example include: @i macros.fwi"); #     lr_mes(&ps,"Include ignored.");E     skiptoeol();     return;     }  1  /* Complain if the include level is too high. */-  if (inclevel == MAX_INCL)    {T     lr_err(p_ps,"This include file is nested too deeply. It's probably recursive.");A     sprintf(linet1,"The maximum level of nested includes is %u.",g(                    (unsigned) MAX_INCL);     lr_mes(p_ps,linet1);$     lr_mes(p_ps,"Include ignored.");     skiptoeol();     return;i    }  D  {/* This construct does the work of the include.                 */D   /* Warning: The following variables MUST be declared automatic. */   char   *p_filename;    char   *p_tempname;t   ulong  length;   char  *p;a   ulong xinln_max;   char  xspecial;p   char  *xp_eof;   ulong  xlocalno;   char  *xp_sol;   char  *xp_ch; 
   char   xch;e  B   /* We save stack space by sticking this filename in the heap. */K   p_filename=mm_temp((size_t) FILENAME_MAX+1+10); /* 10 is for paranoia. */ K   p_tempname=mm_temp((size_t) FILENAME_MAX+1+10); /* 10 is for paranoia. */   E   /* The rest of the line is supposed to hold a filename. Copy it. */-	   NEXTCH;/   p=p_tempname;l   length=0;x   while (ch!=EOL)t     { !      if (++length > FILENAME_MAX)         {         lr_err(p_ps,B         "This include command's file specification is too long.");         if (option.op_b7_b) K            sprintf(linet1,"The maximum file name length is %s characters.",i                       SUPPVAL);          elseK            sprintf(linet1,"The maximum file name length is %u characters.", /                       (unsigned) FILENAME_MAX);-         lr_mes(p_ps,linet1);(         lr_mes(p_ps,"Include ignored.");         skiptoeol();         return;*        }
      *p++=ch;u      NEXTCH;     }r	   *p=EOS; K   /* Note: Current position is now on the EOL at the end of the @i line. */   :   /* Complain if the user has not specified a filename. */   if (strlen(p_tempname) ==0)/     { A      lr_err(psofch(),"Expecting the name of a file to include.");       return;     }*  P   /* Perform the necessary filename inheritance.                              */   strcpy(p_filename,"");#   fn_ins(p_filename,option.op_f_s);/   fn_ins(p_filename,".fwi");#   fn_ins(p_filename,option.op_i_s);C    fn_ins(p_filename,p_tempname);  C   /* Include the included file by calling scan_file recursively. */nC   /* Save and restore all variables in instantiation scope.      */    xinln_max = inln_max;    xspecial  = specialch;   xp_eof    = p_eof;   xlocalno  = localno;   xp_sol    = p_sol;   xp_ch     = p_ch;r   xch       = ch; 
   inclevel++;t   scan_file(p_filename);
   inclevel--;e   ch        = xch;   p_ch      = xp_ch;   p_sol     = xp_sol;    localno   = xlocalno;    p_eof     = xp_eof;C   specialch = xspecial;t   inln_max  = xinln_max;  } }l  P /******************************************************************************/  ! LOCAL void do_ascii P_((p_ps_t));p LOCAL void do_ascii(p_psspec) P /* Upon entry, the current character is the '^' of a @^ sequence. The task is */P /* to parse the following ascii code and generate a text token.               */ p_ps_t p_psspec; {*P  ubyte  base;             /* Base of the number we are scanning.              */P  ubyte  digits;           /* Number of digits expected.                       */P  uword  val;              /* Value of target character.                       */P  ubyte  i;                /* Looping variable.                                */P  STAVAR char alphab[256]; /* Static alphabet array to which to point scraps.  */P  STAVAR bool init=FALSE;  /* Tells if alphab has been initialized.            */  P  /* Establish an array containing the ascii character set. Later on we can    */P  /* point the sc_first and sc_last pointers to particular characters.         */I  if (!init) {uword i; for (i=0;i<256;i++) alphab[i]=(char) i; init=TRUE;}   2  /* Make sure that the base character is legal. */  NEXTCH;  switch(toupper(ch))    {'     case 'B': base= 2; digits=8; break;e
     case 'O': '     case 'Q': base= 8; digits=3; break;/'     case 'D': base=10; digits=3; break;t
     case 'H': '     case 'X': base=16; digits=2; break;eF     default : lr_err(psofch(),"Expecting one of 'B', 'Q', 'D', 'H'.");P               lr_mes(psofch(),"(For Binary, Octal, Decimal, and Hexadecimal).");               base=10;               goto trouble;f    }  !  /* Parse opening parenthesis. */   NEXTCH;
  if (ch!='(') 4    {lr_err(psofch(),"Expecting '('.");goto trouble;}    val=0;{  for (i=0;i<digits;i++)     {
     char uch;      ubyte d;       NEXTCH;      uch=toupper(ch);!     if (('0'<=uch) && (uch<='9'))C        d=uch-'0';      else         if ('A'<=uch && uch<='F')           d=10+uch-'A';         else            d=100;     if (d>=base)8       {lr_err(psofch(),"Illegal digit."); goto trouble;}     val = base*val + d;s    }  !  /* Parse closing parenthesis. */   NEXTCH;
  if (ch!=')')o4    {lr_err(psofch(),"Expecting ')'.");goto trouble;}  N  /* Make sure that the number is not too big (this is possible in decimal). */
  if (val>255)n    {6     lr_err(psofch(),"Character number is too large.");P     lr_mes(psofch(),"Character number must be in the range [0,255] (decimal).");     goto trouble;e    }  5  /* Success! Now we can parcel it up into a scrap! */ A  sendtext(p_psspec,&alphab[val],&alphab[val],ch==' ' || ch==EOL);s  return;  	  trouble: K  /* Jump here after a specific diagnostic to give the user a reminder of */ K  /* how to specify an ascii character constant.                          */   switch (base)     { 
      case  2:          lr_mes(psofch(),O         "A binary character representation takes the form \"@^B(dddddddd)\".");g         lr_mes(psofch(),C         "(exactly 8 digits) where each digit d is either 0 or 1.");          break;
      case  8:          lr_mes(psofch(),\         "An octal character representation takes the form \"@^Q(ddd)\" (or \"@^O(ddd)\").");         lr_mes(psofch(),G         "(exactly 3 digits) where each digit d is in the range 0..7.");          break;
      case 10:          lr_mes(psofch(),K         "A decimal character representation takes the form \"@^D(ddd)\".");          lr_mes(psofch(),G         "(exactly 3 digits) where each digit d is in the range 0..9.");p         break;
      case 16:s         lr_mes(psofch(),_         "A hexadecimal character representation takes the form \"@^X(dd)\" (or \"@^H(dd)\").");a         lr_mes(psofch(),L         "(exactly 2 digits) where each digit d is in the range 0..9,A..F.");         break;B      default: as_bomb("do_ascii: trouble base switch defaulted.");     }( }=  P /******************************************************************************/    LOCAL void do_name P_((p_ps_t)); LOCAL void do_name (p_psspec) P /* Upon entry, the current character is the # of a @#. The task is to parse   */P /* it and transmit a name token.                                              */ p_ps_t p_psspec; { 1  as_cold(ch=='#',"do_name: character is wrong.");_  NEXTCH;  if ((ch==EOL) || (ch==' '))B     {lr_err(psofch(),"Expecting a printable character."); return;}    /* Transmit a name token. */h'  sendspec(p_psspec,TK_NAME,(ubyte) ch);  }   P /******************************************************************************/  ' LOCAL void do_pgind P_((uword,p_pt_t));  LOCAL void do_pgind(numarg,arg)s" /* Parse an indentation pragma. */
 uword numarg;c
 p_pt_t   arg;  {}  bool pragind;
  ps_t psprag;s  8  /* Make sure that there are exactly three arguments. */5  if (numarg != 3)  /* "indentation"  "none|blank". */u    {     lr_err(&arg[0].pt_ps,iI            "This indentation pragma has the wrong number of arguments.");s     goto help;    }  4  /* Make sure that the second argument is an "=". */%  if (0 != strcmp(arg[2].pt_pstr,"="))     {-     lr_err(&arg[2].pt_ps,"Expecting \"=\".");      goto help;    }     /* Check the third argument. */;       if (strcmp(arg[3].pt_pstr,"none" )==0) pragind=FALSE;;:  else if (strcmp(arg[3].pt_pstr,"blank")==0) pragind=TRUE;  else     {D     lr_err(&arg[3].pt_ps,"Expecting either \"none\" or \"blank\".");     goto help;    }  9  /* Construct a shorthand for the start of the pragma. */t  ASSIGN(psprag,arg[0].pt_ps);/  G  /* Make sure that the pragma does not contradict an earlier pragma. */p$  if (seenind && (tgindent!=pragind))    {G     sprintf(linet1,"This pragma is opposed by the pragma at line %lu.",n3                    (unsigned long) psprag.ps_line);*     lr_mes(&ps_ind,linet1);lA     sprintf(linet1,"This pragma opposes the pragma at line %lu.",f3                    (unsigned long) ps_ind.ps_line);e     lr_err(&psprag,linet1);*L     lr_mes(&psprag,"You can have as many indentation pragmas as you like,");8     lr_mes(&psprag,"but they all have to be the same!");&     lr_mes(&psprag,"Pragma ignored.");     return;     }  .  /* Success: Record the pragma information. */@  seenind  = TRUE;       /* Record that we have seen a pragma. */@  tgindent = pragind;    /* Record what the pragma said.       */@  ASSIGN(ps_ind,psprag); /* Record where the pragma was.       */  return;    help:     lr_mes(&arg[0].pt_ps,hF            "The correct format is: \"@p indentation = none|blank\".");,     lr_mes(&arg[0].pt_ps,"Pragma ignored.");     return;  }   P /******************************************************************************/  ' LOCAL void do_pginl P_((uword,p_pt_t));E LOCAL void do_pginl(numarg,arg)+/ /* Parse a maximum input line length pragma. */*
 uword numarg;*
 p_pt_t   arg;* {*  char  *numstr;   uword spn;   8  /* Make sure that there are exactly three arguments. *//  if (numarg != 3)  /* "max..length = <num>". */*    {K     lr_err(&arg[0].pt_ps,"This pragma has the wrong number of arguments.");)     goto help;    }  2   /* Make sure that the second argument is "=". */%  if (0 != strcmp(arg[2].pt_pstr,"=")) 9    {lr_err(&arg[2].pt_ps,"Expecting \"=\"."); goto help;}A    /* Set up an abbreviation. */  numstr=arg[3].pt_pstr;   &  /* See if the value is "infinity". */"  if (strcmp(numstr,"infinity")==0)    {inln_max=INMAXINF; return;}*  H  /* Calculate length of longest prefix containing all decimal digits. */H  /* Check that there are no illegal digits.                           */!  spn=strspn(numstr,"0123456789");_  if (spn != strlen(numstr))_    {     ps_t ps;     ASSIGN(ps,arg[3].pt_ps);     ps.ps_column+=spn;P     lr_err(&ps,"Illegal digit. Value must consist entirely of decimal digits.");;     lr_mes(&ps,"You can also use the value \"infinity\".");a"     lr_mes(&ps,"Pragma ignored.");     return;     }  -  /* Check that the number is not too long. */s  if (strlen(numstr)>8)    {C     lr_err(&arg[3].pt_ps,"Too many digits. The maximum is eight.");l,     lr_mes(&arg[3].pt_ps,"Pragma ignored.");     return;u    }  ,  /* Convert the argument into an integer. */  {   ulong val;
   int result;pI   /* Note: Should really be %lu, but the Vax doesn't know about the %u */oI   /* in sscanf and so we make do with %ld.                             */(#   result=sscanf(numstr,"%ld",&val);*/   as_cold(result==1,"do_pginl:sscanf failed.");*   inln_max=val;*  }  return;    help:     lr_mes(&arg[0].pt_ps,*Q     "The correct format is: \"@p maximum_input_line_length = <num>|infinity\".");o,     lr_mes(&arg[0].pt_ps,"Pragma ignored.");     return;/ }*  P /******************************************************************************/  ' LOCAL void do_pgotl P_((uword,p_pt_t));  LOCAL void do_pgotl(numarg,arg) 6 /* Parse a maximum product file line length pragma. */
 uword numarg;s
 p_pt_t   arg;: {_  char  *numstr;e  uword spn;   ulong val;r
  ps_t psprag;     /* Set up an abbreviation. */  ASSIGN(psprag,arg[0].pt_ps);   8  /* Make sure that there are exactly three arguments. */3  if (numarg != 3)  /* "max..length" "=" "value". */e    {K     lr_err(&arg[0].pt_ps,"This pragma has the wrong number of arguments.");m     goto help;    }  5   /* Make sure that the second argument is an "=". */ %  if (0 != strcmp(arg[2].pt_pstr,"="))t9    {lr_err(&arg[2].pt_ps,"Expecting \"=\"."); goto help;}o    /* Set up an abbreviation. */  numstr=arg[3].pt_pstr;k  &  /* See if the value is "infinity". */"  if (strcmp(numstr,"infinity")==0)!    {val=TGMAXINF; goto gotvalue;}e  H  /* Calculate length of longest prefix containing all decimal digits. */H  /* Check that there are no illegal digits.                           */!  spn=strspn(numstr,"0123456789");   if (spn != strlen(numstr))o    {     ps_t ps;     ASSIGN(ps,arg[3].pt_ps);     ps.ps_column+=spn;P     lr_err(&ps,"Illegal digit. Value must consist entirely of decimal digits.");;     lr_mes(&ps,"You can also use the value \"infinity\".");s"     lr_mes(&ps,"Pragma ignored.");     return;     }  -  /* Check that the number is not too long. */e  if (strlen(numstr)>8)    {C     lr_err(&arg[3].pt_ps,"Too many digits. The maximum is eight."); ,     lr_mes(&arg[3].pt_ps,"Pragma ignored.");     return;"    }  ,  /* Convert the argument into an integer. */  {'   int result=sscanf(numstr,"%ld",&val);t/   as_cold(result==1,"do_pgotl:sscanf failed.");E  }  
  gotvalue:G  /* Make sure that the pragma does not contradict an earlier pragma. */l!  if (seenlimo && (tglinmax!=val))     {G     sprintf(linet1,"This pragma is opposed by the pragma at line %lu.",/3                    (unsigned long) psprag.ps_line);h     lr_mes(&ps_limo,linet1);A     sprintf(linet1,"This pragma opposes the pragma at line %lu.",f4                    (unsigned long) ps_limo.ps_line);     lr_err(&psprag,linet1);pF     lr_mes(&psprag,"You can have as many output line length pragmas");E     lr_mes(&psprag,"as you like, but they all have to be the same!");f&     lr_mes(&psprag,"Pragma ignored.");     return;o    }  M  /* If we got this far then the pragma is just the same as an earlier one. */nM  /* We don't want to set the pragma position to the later pragma so we     */ M  /* return now.                                                            */+  if (seenlimo) return;  "  /* Success. Set the variables. */  tglinmax=val;  seenlimo=TRUE;.  ASSIGN(ps_limo,psprag);  return;    help:     lr_mes(&arg[0].pt_ps,bR     "The correct format is: \"@p maximum_output_line_length = <num>|infinity\".");,     lr_mes(&arg[0].pt_ps,"Pragma ignored.");     return;  }   P /******************************************************************************/  ' LOCAL void do_pgnpg P_((uword,p_pt_t));) LOCAL void do_pgnpg(numarg,arg)*+ /* Parse a newpage typesetter directive. */*
 uword numarg; 
 p_pt_t   arg;  { 4  /* Make sure that there is exactly one argument. */"  if (numarg > 1)  /* "new_page" */    {L     lr_err(&arg[2].pt_ps,"The new_page directive does not take arguments.");/     lr_mes(&arg[2].pt_ps,"Directive ignored.");      return;     }*  sendspec(&arg[0].pt_ps,TK_NPAG,DONTCARE); }*  P /******************************************************************************/  ' LOCAL void do_pgtoc P_((uword,p_pt_t));a LOCAL void do_pgtoc(numarg,arg)d5 /* Parse a table of contents typesetter directive. */*P uword numarg;  /* Number of arguments to table of contents directive.         */P p_pt_t   arg;  /* Array describing arguments.                                 */ {i4  /* Make sure that there is exactly one argument. */+  if (numarg > 1)  /* "table_of_contents" */h    {     lr_err(&arg[2].pt_ps,hG            "The table_of_contents directive does not take arguments.");i/     lr_mes(&arg[2].pt_ps,"Directive ignored.");g     return;h    }*  sendspec(&arg[0].pt_ps,TK_TOCS,DONTCARE); }t  P /******************************************************************************/  ' LOCAL void do_pgvsk P_((uword,p_pt_t));e LOCAL void do_pgvsk(numarg,arg)i) /* Parse a vskip typesetter directive. */rP uword numarg;  /* Number of arguments to indentation directive.               */P p_pt_t   arg;  /* Array describing arguments.                                 */ {n  char  *numstr;w  uword spn;.  8  /* Make sure that there are exactly three arguments. */(  if (numarg != 3)  /* "vskip" n "mm". */    {N     lr_err(&arg[0].pt_ps,"This directive has the wrong number of arguments.");     goto help;    }  2   /* Make sure that the third argument is "mm". */&  if (0 != strcmp(arg[3].pt_pstr,"mm")):    {lr_err(&arg[3].pt_ps,"Expecting \"mm\"."); goto help;}    /* Set up an abbreviation. */  numstr=arg[2].pt_pstr;.  H  /* Calculate length of longest prefix containing all decimal digits. */H  /* Check that there are no illegal digits.                           */!  spn=strspn(numstr,"0123456789");   if (spn != strlen(numstr))n    {     ps_t ps;     ASSIGN(ps,arg[2].pt_ps);     ps.ps_column+=spn;!     lr_err(&ps,"Illegal digit.");uA     lr_mes(&ps,"Value must consist entirely of decimal digits."); %     lr_mes(&ps,"Directive ignored.");w     return;     }  -  /* Check that the number is not too long. */   if (strlen(numstr)>3)    {C     lr_err(&arg[2].pt_ps,"Too many digits. The maximum is three.");h/     lr_mes(&arg[2].pt_ps,"Directive ignored.");;     return;_    }  ,  /* Convert the argument into an integer. */  {   ulong val;
   int result; #   result=sscanf(numstr,"%ld",&val);E/   as_cold(result==1,"do_pginl:sscanf failed.");e   if (val>255)     { >      lr_err(&arg[2].pt_ps,"Value too large. Maximum is 255.");0      lr_mes(&arg[2].pt_ps,"Directive ignored.");      return;     } .   sendspec(&arg[0].pt_ps,TK_SKIP,(ubyte) val);  }  return;    help:J     lr_mes(&arg[0].pt_ps,"The correct format is: \"@t vskip <num> mm\".");/     lr_mes(&arg[0].pt_ps,"Directive ignored.");      return;n }_  P /******************************************************************************/  ' LOCAL void do_pgtit P_((uword,p_pt_t));  LOCAL void do_pgtit(numarg,arg)T) /* Parse a title typesetter directive. */sP uword numarg;  /* Number of arguments to title directive.                     */P p_pt_t   arg;  /* Array describing arguments.                                 */ { 
  uword align;*  uword font;  char *p_sot,*p_eot;  9  /* Make sure that there are at least three arguments. */e6  if (numarg < 4)  /* "title <font> <align> <text>". */N    {lr_err(&arg[0].pt_ps,"This directive has too few arguments."); goto help;}    /* Check the font argument. */ C       if (strcmp(arg[2].pt_pstr,"normalfont"    )==0) font=FT_NORM;aC  else if (strcmp(arg[2].pt_pstr,"titlefont"     )==0) font=FT_TITL;fC  else if (strcmp(arg[2].pt_pstr,"smalltitlefont")==0) font=FT_STIT;m  else"    {     lr_err(&arg[2].pt_ps,_?     "Expecting one of {titlefont,smalltitlefont,normalfont}.");u/     lr_mes(&arg[2].pt_ps,"Directive ignored.");      return;e    }  $  /* Check the alignment argument. */<       if (strcmp(arg[3].pt_pstr,"left"  )==0) align=LR_LEFT;<  else if (strcmp(arg[3].pt_pstr,"right" )==0) align=LR_RIGH;<  else if (strcmp(arg[3].pt_pstr,"centre")==0) align=LR_CENT;  elsef    {B     lr_err(&arg[3].pt_ps,"Expecting one of {left,right,centre}.");+     if (strcmp(arg[3].pt_pstr,"center")==0)l       {_I        lr_mes(&arg[3].pt_ps,"Note: Centre is spelt centRE, not centER."); \        lr_mes(&arg[3].pt_ps,"      This is my revenge for years of getting error messages");j        lr_mes(&arg[3].pt_ps,"      from TeX whenever I accidentally wrote \\centreline - Ross Williams.");       }@/     lr_mes(&arg[3].pt_ps,"Directive ignored.");w     return;e    }  K  /* Now make sure that the remainder of the line is delimited by quotes. */   p_sot=arg[4].pt_pinl;  p_eot=p_sot+strlen(p_sot)-1; 0  if (*p_sot!='"' || *p_eot!='"' || p_sot==p_eot)    {N     lr_err(&arg[4].pt_ps,"Text argument must be delimited by double quotes.");/     lr_mes(&arg[4].pt_ps,"Directive ignored.");      return;*    }  p_sot++; p_eot--;  9  /* Ship out a token whose fields are all fully laden. */i  {
   tk_t token; !   token.tk_kind        = TK_TITL; #   ASSIGN(token.tk_ps,arg[0].pt_ps);h;   token.tk_sc.sc_first = p_sol+ (3+(p_sot-arg[1].pt_pinl));c;   token.tk_sc.sc_last  = p_sol+ (3+(p_eot-arg[1].pt_pinl));    token.tk_sc.sc_white = FALSE;i.   token.tk_gen         = LRFT_PACK*font+align;   ls_add(token_list,PV &token);i  }  return;    help:     lr_mes(&arg[0].pt_ps,rB     "The correct format is: \"@t title <font> <align> <text>\".");     lr_mes(&arg[0].pt_ps,eC     "   where <font>  = titlefont | smalltitlefont | normalfont.");=     lr_mes(&arg[0].pt_ps,a1     "   and   <align> = left | centre | right.");'     lr_mes(&arg[0].pt_ps,k;     "   and   <text>  = text delimited by double quotes."); /     lr_mes(&arg[0].pt_ps,"Directive ignored.");      return;, }c  P /******************************************************************************/  ' LOCAL void do_pgtyp P_((uword,p_pt_t));N LOCAL void do_pgtyp(numarg,arg)r  /* Parse a typesetter pragma. */
 uword numarg;l
 p_pt_t   arg;; {i  tr_k_t pragtyp;  ps_t   psprag;   8  /* Make sure that there are exactly three arguments. */1  if (numarg != 3)  /* "typesetter" "=" "name". */l    {     lr_err(&arg[0].pt_ps,FH            "This typesetter pragma has the wrong number of arguments.");     goto help;    }  1  /* Make sure that the second argument is "=". */a%  if (0 != strcmp(arg[2].pt_pstr,"="))     {-     lr_err(&arg[2].pt_ps,"Expecting \"=\".");r     goto help;    }     /* Check the third argument. */<       if (strcmp(arg[3].pt_pstr,"none")==0) pragtyp=TR_NONE;;  else if (strcmp(arg[3].pt_pstr,"tex" )==0) pragtyp=TR_TEX;m  elset    {B     lr_err(&arg[3].pt_ps,"Expecting either \"none\" or \"tex\".");     goto help;    }  9  /* Construct a shorthand for the start of the pragma. */   ASSIGN(psprag,arg[0].pt_ps);(  G  /* Make sure that the pragma does not contradict an earlier pragma. */b&  if (seentyp && (tr_codes != pragtyp))    {G     sprintf(linet1,"This pragma is opposed by the pragma at line %lu.",e3                    (unsigned long) psprag.ps_line);s     lr_mes(&ps_typ,linet1); A     sprintf(linet1,"This pragma opposes the pragma at line %lu.",t3                    (unsigned long) ps_typ.ps_line);p     lr_err(&psprag,linet1); K     lr_mes(&psprag,"You can have as many typesetter pragmas as you like,");88     lr_mes(&psprag,"but they all have to be the same!");&     lr_mes(&psprag,"Pragma ignored.");     return;d    }  .  /* Success: Record the pragma information. */@  seentyp  = TRUE;       /* Record that we have seen a pragma. */@  tr_codes = pragtyp;    /* Record what the pragma said.       */@  ASSIGN(ps_typ,psprag); /* Record where the pragma was.       */  return;    help:     lr_mes(&arg[0].pt_ps, C            "The correct format is: \"@p typesetter = none|tex\".");s,     lr_mes(&arg[0].pt_ps,"Pragma ignored.");     return;a }t  P /******************************************************************************/  ' LOCAL void do_pragma P_((p_ps_t,bool)); ! LOCAL void do_pragma(p_ps,is_typ).P /* Upon entry, the current character is:                                      */P /* is_typ=FALSE => The P of a @p.                                             */P /* is_typ=TRUE  => The T of a @t.                                             */P /* This function processes these contructs.                                   */ p_ps_t p_ps; bool is_typ; {nP #define MAXPARG     10         /* Maximum recorded arguments to a pragma.     */P #define PRAGMA_MAX 100         /* Maximum length of a pragma.                 */P  char  praglin[PRAGMA_MAX+1];  /* Array to hold pragma as a complete line.    */P  char  pragstr[PRAGMA_MAX+1];  /* Array to hold pragma as strings.            */P  pt_t  pragarg[MAXPARG+1];     /* Array of pragma arguments.                  */P  uword length;                 /* Helps prevent scanning overrun.             */P  char  *p,*q;                  /* Temporary.                                  */P  uword numarg,na;              /* Number of arguments seen so far.            */  F  /* Complain if the pragma directive is not at the start of a line. */  if (p_ch-1 != p_sol)s    {     if (is_typ)        { N        lr_err(p_ps,"Typesetter directive @t must be at the start of a line.");=        lr_mes(p_ps,"The rest of this line will be ignored.");        }      else       {sI        lr_err(p_ps,"Pragma sequence @p must be at the start of a line.");t=        lr_mes(p_ps,"The rest of this line will be ignored.");E       }      skiptoeol();     goto help;    }  L  /* The include command should be followed by a blank. Get the next char. */  NEXTCH;  5  /* Complain if the next character is not a blank. */   if (ch != ' ')t    {J     /* Note: If we position this error correctly, it gets put after the */J     /*       help message!                                              */     if (is_typ)iK        lr_err(p_ps,"Typesetter directive @t must be followed by a blank.");      elseF        lr_err(p_ps,"Pragma sequence @p must be followed by a blank.");     skiptoeol();     goto help;    }  6  /* Copy the rest of the line to the pragma arrays. */  NEXTCH;  p = &praglin[0];r  q = &pragstr[0];r
  length=0;  while (ch!=EOL)    {?     if (++length > PRAGMA_MAX-3)  /* 3 is for "@p " or "@t " */a       {o        if (is_typ)
          {D           lr_err(p_ps,"This typestter directive line is too long.");Z           sprintf(linet1,"The maximum typesetter directive line length is %u characters.",,                      (unsigned) PRAGMA_MAX);           lr_mes(p_ps,linet1);
          }        elser
          {7           lr_err(p_ps,"This pragma line is too long.");_L           sprintf(linet1,"The maximum pragma line length is %u characters.",,                      (unsigned) PRAGMA_MAX);           lr_mes(p_ps,linet1);
          }        skiptoeol();*        goto help;*       }*     *p++=ch;     *q++=ch;     NEXTCH;t    }  *p=EOS;  *q=EOS;J  /* Note: Current position is now on the EOL at the end of the @p line. */J  /* That is the way we want to leave it for the scanspec() routine.     */  P  /* So far we have copied the body of the pragma line into two arrays. The    */P  /* next lump of code parses that line into a sequence of non-blank arguments.*/P  /* The result is an array of pt_t objects each of which contains the         */P  /* position of each argument, a pointer to the first character of each       */P  /* argument in praglin, and also a pointer to a string containing the arg.   */P  /* The string resides in the array pragstr which is the same as praglin      */P  /* except that some blanks have been replaced by EOSs so as to allow us to   */P  /* point into it to form strings. All this probably seems rather overdone    */P  /* for the analysis of a "simple" pragma, but I have found that pulling the  */P  /* different kinds of pragma lines apart separately is very messy. Far       */P  /* better to suffer here in what is at least reasonably neat code than       */P  /* later in the specific pragma routines.                                    */
  numarg=0;  p= &praglin[0];  q= &pragstr[0];
  while (TRUE)t    {,     /* Skip whitespace between arguments. */     while (*p==' ') {p++;q++;}  2     /* Exit if we have hit the end of the line. */.     if ((numarg==MAXPARG) || (*p==EOS)) break;  )     /* We have found another argument! */ 
     numarg++;        /* Record the argument. */(     ASSIGN(pragarg[numarg].pt_ps,*p_ps);2     pragarg[numarg].pt_ps.ps_column=4+(p-praglin);     pragarg[numarg].pt_pinl=p;     pragarg[numarg].pt_pstr=q;  *     /* Skip to the end of the argument. */)     while (*p!=' ' && *p!=EOS) {p++;q++;}r  M     /* Drop a null in the string array to complete string rep of argument. */m     *q=EOS;e    }  P  /* At this point numarg is MIN(arguments,MAXPARG), and pragargs contains an  */P  /* entry for each of the numarg arguments.                                   */  C  /* It is handy to have the position of the pragma itself handy. */u   ASSIGN(pragarg[0].pt_ps,*p_ps);  B  /* CHECK: Make sure that the line and string arrays square up. */  {
   uword i;   for (i=1;i<=numarg;i++)r     { 
      uword j; (      uword t=strlen(pragarg[i].pt_pstr);      for (j=0;j<t;j++)        {=         as_cold(pragarg[i].pt_pstr[j]==pragarg[i].pt_pinl[j],/D                 "do_pragma: String and line arrays are not equal.");K         as_cold((pragarg[i].pt_pstr-pragstr)==(pragarg[i].pt_pinl-praglin),MG                 "do_pragma: String and line arrays are out of synch.");.        }     }   }  1  /* Complain if there are no arguments at all. */   if (numarg==0)b    {     if (is_typ)=M        lr_err(p_ps,"Typesetter directive @t must be followed by a keyword.");"     elseH        lr_err(p_ps,"Pragma sequence @p must be followed by a keyword.");     skiptoeol();     goto help;    }  C  /* Branch off to specific routines based on the first argument. */ !  p=pragarg[1].pt_pstr; na=numarg;9  if (is_typ)    {I     if (0==strcmp(p,"new_page"          )) {do_pgnpg(na,pragarg);return;}_I     if (0==strcmp(p,"table_of_contents" )) {do_pgtoc(na,pragarg);return;} I     if (0==strcmp(p,"title"             )) {do_pgtit(na,pragarg);return;}.I     if (0==strcmp(p,"vskip"             )) {do_pgvsk(na,pragarg);return;}h    }  else     {Q     if (0==strcmp(p,"indentation"               )) {do_pgind(na,pragarg);return;}gQ     if (0==strcmp(p,"maximum_input_line_length" )) {do_pginl(na,pragarg);return;}eQ     if (0==strcmp(p,"maximum_output_line_length")) {do_pgotl(na,pragarg);return;}nQ     if (0==strcmp(p,"typesetter"                )) {do_pgtyp(na,pragarg);return;}t    }    help:  if (is_typ)    {F     lr_err(p_ps,"Unrecognised typesetter directive. Legal ones are:");"     lr_mes(p_ps,"   @t new_page");+     lr_mes(p_ps,"   @t table_of_contents");%7     lr_mes(p_ps,"   @t title <font> <align> <string>");)(     lr_mes(p_ps,"   @t vskip <num> mm");?     lr_mes(p_ps,"The blanks between arguments are important."); 1     lr_mes(p_ps,"Typesetter directive ignored.");     }  elseg    {D     lr_err(p_ps,"Unrecognised pragma. Possible legal pragmas are:");4     lr_mes(p_ps,"   @p indentation = none | blank");E     lr_mes(p_ps,"   @p maximum_input_line_length  = <num>|infinity");eE     lr_mes(p_ps,"   @p maximum_output_line_length = <num>|infinity"); 1     lr_mes(p_ps,"   @p typesetter = none | tex");e?     lr_mes(p_ps,"The blanks between arguments are important.");w#     lr_mes(p_ps,"Pragma ignored.");     } }   P /******************************************************************************/   LOCAL void chksol P_((void));S LOCAL void chksol() P /* This function is called when the current character is the character after  */P /* an @. The function checks to see if the @ was at the start of a line and   */P /* issues a error message if it isn't.                                        */ {*	  ps_t ps;*  grabchps(&ps);   if (ps.ps_column != 2)(    {     ps.ps_column--;dC     sprintf(linet1,"@%c is legal only at the start of a line.",ch);      lr_err(&ps,linet1);a    } }   P /******************************************************************************/   LOCAL void scanspec P_((void));s LOCAL void scanspec()eP /* Upon entry the current character is the special character (usually '@').   */P /* The task is to scan the special sequence. Upon exit, the current character */P /* is the character following the special sequence.                           */ {gP  ps_t  ps_spec;                   /* Position of start of special sequence.   */  8  /* Make a note of where the special sequence starts. */  grabchps(&ps_spec);  H  /* Move onto the character following the special (escape) character. */  NEXTCH;  P  /* Now react to the character. In most cases, the special sequence is simply */P  /* a marker in the input and we can simply transmit it. The nasty special    */P  /* case sequences are left until the end of the switch statement.            */P  /* Purists will complain about how all the case options are hardwired and    */P  /* say that symbols should have been used. They once were, but were taken    */P  /* out when it was discovered that the symbols had cryptic names (because of */P  /* the portability eight-character rule) and were only used here anyway.     */  switch (toupper(ch))e    {9     case '<': sendspec(&ps_spec,TK_ONAM,DONTCARE); break; 9     case '>': sendspec(&ps_spec,TK_CNAM,DONTCARE); break; 9     case '{': sendspec(&ps_spec,TK_ODEF,DONTCARE); break;t9     case '}': sendspec(&ps_spec,TK_CDEF,DONTCARE); break;/9     case '(': sendspec(&ps_spec,TK_OPAR,DONTCARE); break;d9     case ')': sendspec(&ps_spec,TK_CPAR,DONTCARE); break;l9     case ',': sendspec(&ps_spec,TK_COMA,DONTCARE); break; 9     case '"': sendspec(&ps_spec,TK_QUOT,DONTCARE); break;[9     case '/': sendspec(&ps_spec,TK_EMPH,DONTCARE); break; <     case 'A': sendspec(&ps_spec,TK_NSEC,1); chksol(); break;<     case 'B': sendspec(&ps_spec,TK_NSEC,2); chksol(); break;<     case 'C': sendspec(&ps_spec,TK_NSEC,3); chksol(); break;<     case 'D': sendspec(&ps_spec,TK_NSEC,4); chksol(); break;<     case 'E': sendspec(&ps_spec,TK_NSEC,5); chksol(); break;2     case '1': sendspec(&ps_spec,TK_PARM,1); break;2     case '2': sendspec(&ps_spec,TK_PARM,2); break;2     case '3': sendspec(&ps_spec,TK_PARM,3); break;2     case '4': sendspec(&ps_spec,TK_PARM,4); break;2     case '5': sendspec(&ps_spec,TK_PARM,5); break;2     case '6': sendspec(&ps_spec,TK_PARM,6); break;2     case '7': sendspec(&ps_spec,TK_PARM,7); break;2     case '8': sendspec(&ps_spec,TK_PARM,8); break;2     case '9': sendspec(&ps_spec,TK_PARM,9); break;9     case 'M': sendspec(&ps_spec,TK_MANY,DONTCARE); break; 9     case 'Z': sendspec(&ps_spec,TK_ZERO,DONTCARE); break;>C     case 'O': sendspec(&ps_spec,TK_FDEF,DONTCARE); chksol(); break;2C     case '$': sendspec(&ps_spec,TK_MDEF,DONTCARE); chksol(); break;;
     case EOL:dP        lr_err(&ps_spec,"<special><endofline> is not a legal special sequence.");
        break;o
     case ' '::L        lr_err(&ps_spec,"<special><space> is not a legal special sequence.");
        break;_
     case '@':*L        /* @ instructs FunnelWeb to replace the special construct with the */L        /* special character. Luckily one appears just before the @ !!     */L        /* Note: FALSE is OK because space is not a legal specialch.       */.        sendtext(&ps_spec,p_ch-1,p_ch-1,FALSE);
        break; 
     case '-':mI        /* - instructs FunnelWeb to suppress the following end of line. */         if (*(p_ch+1) == EOL)           NEXTCH        else            lr_err(&ps_spec,N                  "Suppress EOL sequence is legal only at the end of a line.");
        break;t
     case '+':sP        /* + instructs FunnelWeb to insert an EOL. We can't look to the end of */P        /* the previous line to find an EOL as this might be the first line.   */P        /* Running ahead to the end of the line is expensive, and having the   */P        /* liner mini-package maintain a variable for it would be extra        */P        /* housekeeping. Instead of all this, we just point to a static.       */"        {STAVAR char stateol = EOL;3         sendtext(&ps_spec,&stateol,&stateol,TRUE);}a
        break;l
     case '=':gP       /* = instructs FunnelWeb to change the special character to the         */P       /* character following the <special>= sequence.                         */
       NEXTCH;e       if (ch == ' ')	         {"M          lr_err(&ps_spec,"You cannot set the special character to <space>!");36          lr_mes(&ps_spec,"Special sequence ignored.");	         }e       else if (ch == EOL) 	         {g          lr_err(&ps_spec,rH                 "You cannot set the special character to <endofline>!");6          lr_mes(&ps_spec,"Special sequence ignored.");	         }s
       else          specialch=ch;       break;
     case '!': N        /* ! instructs FunnelWeb to ignore the rest of the line (a comment). */        skiptoeol();e
        break;(
     case 'I': 5        /* i instructs FunnelWeb to include a file. */         incl_fil(&ps_spec);
        break; 
     case '^':uH        /* ^ instructs FunnelWeb to insert a specific ascii character. */        do_ascii(&ps_spec);
        break;o
     case '#':eI        /* # instructs FunnelWeb to transmit a two character name "#c". */         do_name(&ps_spec);n
        break;t
     case 'P':.1        /* P is used as a miscellaneous PRAGMA. */c!        do_pragma(&ps_spec,FALSE);3
        break;p
     case 'T':o;        /* T introduces a one-line typesetting directive. */A         do_pragma(&ps_spec,TRUE);
        break;      default:4        lr_err(&ps_spec,"Unknown special sequence.");
        break;t    }  M  /* The switch statment absorbs the special sequence and its effects.      */ M  /* This NEXTCH places us on the character following the special sequence. */   NEXTCH; }n  P /******************************************************************************/   LOCAL void scantext P_((void));  LOCAL void scantext()_P /* Upon entry, we know that the current character is not EOF and that it is   */P /* not the special character. Our task is to parse as much text as we can and */P /* ship it off as a text token. The scanner will probably spend most of its   */P /* time in the loops in this function so it is important that they be         */P /* efficient. That is why two loops are used to deal with detecting           */P /* whitespace rather than a flag.                                             */P /* Upon return, the current character is the character following the text     */P /* sequence. This is guaranteed to be the special character or an EOF.        */ { P  ps_t ps_start;        /* Position of first character of text sequence.       */P  char *p_first = p_ch; /* Pointer  to first character of text sequence.       */  1  /* Grab a copy of the position of this token. */R  grabchps(&ps_start);     /* Scan whitespace. */e  while (ch==' ' || ch==EOL)x     NEXTCH;o  1  /* If we hit something that ends a text token */t1  /* then we can transmit a white text token.   */)   if (ch==specialch || ch==EOFCH)6     {sendtext(&ps_start,p_first,p_ch-1,TRUE); return;}  <  /* Otherwise we have some more (non-white) text to scan. */<  /* We can then send a non-white text token.              */#  while (ch!=specialch && ch!=EOFCH)      NEXTCH;s*  sendtext(&ps_start,p_first,p_ch-1,FALSE); }   P /******************************************************************************/   LOCAL void scan_file(p_fname) P /* This function scans a single file. It's argument is the name of the file   */P /* to be scanned. scan_file calls the mapper to map in the file and then      */P /* scans the text of the mapped file using the liner mini-package. The result */P /* of the scan is additions to the line and token list, and diagnostics sent  */P /* to the lister package. If an include directive is encountered, this        */P /* function is called recursively.                                            */ char *p_fname; {oP  char  *p_mapped;  /* Pointer to the mapped file.                             */P  ulong  length;    /* Number of bytes in the mapped file.                     */P  char  *errstr;    /* Error string returned by mapper.                        */P  bool   addedeol;  /* Did we have to add an EOL to the end of the last line?  */  '  /* Check to see if the file exists. */=  if (!fexists(p_fname))     {     if (inclevel==0)       { =        /* Failure to find the main file is a severe error. */         if (option.op_b7_b)I           sprintf(linet1,"S: Error opening input file \"%s\".",SUPPNAME);         elsepH           sprintf(linet1,"S: Error opening input file \"%s\".",p_fname);        wl_l(linet1);P        /* Although strictly speaking we should suppress this error from the   */P        /* screen stream unless option.op_s_b is set, absence of an input file */P        /* is such an important error, that we write it out anyway.            */        /* if (option.op_s_b) */;        wl_sj(linet1);         num_sev++;         return;       };     else       { B        /* Failure to find an include file is an ordinary error. */        ps_t ps;p        ps.ps_line   = globalno;         ps.ps_column = 4;1        lr_err(&ps,"Error opening include file.");         if (option.op_b7_b)           sprintf(linet1, F              "The include file's expanded name was \"%s\".",SUPPNAME);        else            sprintf(linet1,eE              "The include file's expanded name was \"%s\".",p_fname);_        lr_mes(&ps,linet1);        return;       }     }  P  /* Map the specified file into memory. We need to change from the scanner    */P  /* clock to the mapper clock to keep the time accounting correct here.       */  ck_stop(p_scan);   ck_start(p_mapp);,  errstr=map_file(p_fname,&p_mapped,&length);  ck_stop(p_mapp);e  ck_start(p_scan);  -  /* Abort if the mapping was not possible. */   if (errstr != NULL)     if (inclevel==0)       { <        /* Failure to map the main file is a severe error. */        if (option.op_b7_b)I           sprintf(linet1,"S: Error reading input file \"%s\".",SUPPNAME);r        elseeH           sprintf(linet1,"S: Error reading input file \"%s\".",p_fname);6        wl_l(linet1); if (option.op_s_b) wl_sj(linet1);6        wl_l(errstr); if (option.op_s_b) wl_sj(errstr);        num_sev++;         return;       }      else       {gB        /* Failure to find an include file is an ordinary error. */        ps_t ps;P        ps.ps_line   = globalno;r        ps.ps_column = 4;1        lr_err(&ps,"Error reading include file.");T        lr_mes(&ps,errstr);        if (option.op_b7_b)H           sprintf(linet1,"The include file's expanded name was \"%s\".",                   SUPPNAME);        elseGH           sprintf(linet1,"The include file's expanded name was \"%s\".",                   p_fname);T        lr_mes(&ps,linet1);        return;       }i  )  /* Dump the mapped file if requested. */a  if (option.op_b1_b)    {     if (option.op_b7_b)X>        sprintf(linet1,"Dump of mapped file \"%s\".",SUPPNAME);     else=        sprintf(linet1,"Dump of mapped file \"%s\".",p_fname);H     wl_l(linet1); !     dm_mem(&f_l,p_mapped,length);n    }  P  /* If the file is absolutely empty, we have to warn the user. Also, this is  */P  /* a special case we can do without, and so we return here if file is empty. */  if (length==0)o    {     ps_t ps;P     /* The empty file could be the main file or an include file.              */P     /* If the empty file is the main file, we want the diagnostic to point to */P     /*    the EOF marker which will appear as line 1.                         */P     /* If the empty file is an include file, we wish to point the diagnostic  */P     /*    to the line containing the include command. This is globalno.       */P     /* In both cases, we want the diagnostic to point to column 1.            */     ps.ps_column=1;f     if (inclevel==0)       {s        ps.ps_line=1;?        lr_war(&ps,"Input file is empty (not a byte in syte)!");        }i     else       {f        ps.ps_line=globalno;pA        lr_war(&ps,"Include file is empty (not a byte in syte)!");r       }      return;e    }  P  /* Scanning is considerably simplified if we can guarantee that we will not  */P  /* run into an EOF without first hitting an EOL. The following code takes    */P  /* care of this by tacking one on the end if necessary and also adds an      */P  /* EOF character on the end, which also simplifies the scanning. We can get  */P  /* away with all this because the mapper purposefully leaves at least two    */P  /* bytes free for us at the end of the mapped file.                          */  addedeol=FALSE;  if (p_mapped[length-1] != EOL)n,     {p_mapped[length++]=EOL; addedeol=TRUE;}  p_mapped[length]=EOFCH;  B  /* Initialize the variables "instantiated over a single file". */  inln_max  = 80;  specialch = CH_DSPE;h  localno   = 0;   p_eof     = &p_mapped[length];*  C  /* Crank up the line subscanner system with a call to prepline. */PC  /* Then enter the main scanning loop.                           */aC  /* All input consists of alternating special and text sequences */hC  /* terminated by EOF.                                           */p  prepline(p_mapped);  while (ch!=EOFCH)     if (ch==specialch)        scanspec();     else        scantext();  P  /* Now that we are at the end of the scanned file and the scanning markers   */P  /* are all sitting on the end of the file, it is a good time to issue        */P  /* diagnostics about problems at the end of the file.                        */  if (addedeol)    {     ps_t ps;P     /* We want the diagnostic to point to the EOF line. Hence "global+1".     */     ps.ps_line   = globalno+1;     ps.ps_column = 1;      if (inclevel==0)L        lr_war(&ps,"The last line of the input file was terminated by EOF.");     elseN        lr_war(&ps,"The last line of the include file was terminated by EOF.");C     lr_mes(&ps,"An EOL was inserted at the end of the last line.");     } }o  P /******************************************************************************/  $ EXPORT void scanner(p_amapp,p_ascan)P /* This is the scanner's main routine and the only exported function.         */0 p_ck_t p_amapp; /* Mapper's clock (stopped).  */0 p_ck_t p_ascan; /* Scanner's clock (running). */ { @  /* Copy the arguments into globals where we can get at them. */  p_mapp=p_amapp;  p_scan=p_ascan;  P  /* Apart from diagnostic messages sent to the lister, the only output of     */P  /* the scanner is two global lists holding a list of lines and a list of     */P  /* tokens. The scanner creates these lists simultaneously.                   */P  /* We have to initialize them here before we get into 'scan_file' which      */P  /* calls itself recursively if an include file command is encountered.       */!  line_list =ls_cre(sizeof(ln_t));e!  token_list=ls_cre(sizeof(tk_t));r  P  /* Initialize all the variables instantiated throughout the entire scan.     */  globalno  = 0;n  inclevel  = 0;s  seenind   = FALSE;o  seentyp   = FALSE;)  seenlimo  = FALSE;   P  /* We also have to initialize localno in case the input file is empty and    */P  /* it never gets initialized before being sucked into being used as the      */P  /* local number for the end of file marker.                                  */  localno=0;a  C  /* Initialize the global indentation flag to the default value. */h  tgindent=TRUE;y  L  /* Initialize the global product line length limit to the default value. */
  tglinmax=80;   B  /* Initialize the global typesetter flag to the default value. */  tr_codes=TR_NONE;  P  /* Scan the top level file whose name is obtained from the command line.     */*  as_cold(option.op_f_b,"scanner: -F!!!!");  3  /* Work out what the input file name should be. */o  {
   fn_t fname;iP   strcpy(fname,"");              /* Start with an empty string.               */   fn_ins(fname,".fw");   fn_ins(fname,option.op_f_s);   scan_file(fname);*  }  P  /* The scan_file function scans the main input file and all of its included  */P  /* files, but it does not append a TK_EOF token to the end. This call does   */P  /* this and also adds a line to the line list for EOF.                       */  add_eof();  }   P /******************************************************************************/P /*                              End of SCANNER.C                              */P /******************************************************************************/