P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                    STYLE.H                                 */P /******************************************************************************/P /*                                                                            */P /* WARNING: DO NOT ADD ANY MACHINE OR PROGRAM DEPENDENT DEFINITIONS.          */P /*                                                                            */P /* This style.h file contains program-independent, machine-independent        */P /* definitions that assist C programming in general. Nothing in this file     */P /* should require modification if this file is moved to a new machine or used */P /* in a new computer program. However, it may use abstracted second-order     */P /* definitions from the machine-dependent, program independent module         */P /* "environ".                                                                 */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_STYLE #define DONE_STYLE  P /******************************************************************************/  P /* System File Inclusions                                                     */P /* ----------------------                                                     */P /* In order to support a readable programming style, symbols such as TRUE and */P /* NULL are essential. However, environments differ as to whether and where   */P /* these symbols are defined. This can lead to multiple definition errors     */P /* where (say) this style.h file is included in a .C file before <stdlib.h>.  */P /* I did a quick survey of all the .C FunnelWeb modules and found the         */P /* following:                                                                 */P /*                                                                            */P /*    Total files     = 54                                                    */P /*    Number .C files = 22                                                    */P /*    Number .H files = 32                                                    */P /*    Used <stdlib.h> = 19                                                    */P /*    Used <stdio.h>  = 16                                                    */P /*    Used <string.h> = 12                                                    */P /*    Used <ctype.h>  =  6                                                    */P /*    Used <stddef.h> =  4                                                    */P /*    Used <limits.h> =  2                                                    */P /*    Used <setjmp.h> =  1                                                    */P /*                                                                            */P /* Most of these inclusions were in the .C files.                             */P /* It therefore seemed sensible to include some very commonly used system     */P /* header files here and header files that cause problems if not included     */P /* before style.h (<stddef.h>).                                               */   #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <stddef.h>   P /******************************************************************************/  P /* Although this file is machine independent, it still needs some generic     */P /* definitions whose values vary from machine to machine (see above).         */ #include "environ.h"  P /******************************************************************************/  P /* The following types provide a clear and consistent collection of names for */P /* C's arithmetic types. Each name describes only the portable range that the */P /* underlying type supports. As in C, there are no guarantees about the       */P /* MAXIMUM size of each underlying type and these types can provide no        */P /* guarantees either. In the normal case, they translate to the most speed    */P /* efficient type that will support the specified range. However, to support  */P /* the situations where space efficiency is required, types ending in         */P /* underscores have been defined that strive to conserve memory.              */P /* Note: The signedness of a type does not change when an _ is added.         */P /*                                                                            */P /* The following terminology may be a touch vaxcentric, but it works for me.  */P /*    A BYTE is an  8 bit quantity.                                           */P /*    A WORD is a  16 bit quantity.                                           */P /*    A LONG is a  32 bit quantity.                                           */  P typedef unsigned        ubyte  ; /* Unsigned, [0,255].                        */P typedef unsigned char   ubyte_ ; /* Unsigned, [0,255].         Space first.   */P typedef int             word   ; /* Signed  , [-32767,+32767].                */P typedef short           word_  ; /* Signed  , [-32767,+32767]. Space first.   */P typedef unsigned        uword  ; /* Unsigned, [0,65535].                      */P typedef unsigned short  uword_ ; /* Unsigned, [0,+65535].      Space first.   */P typedef unsigned long   ulong  ; /* Unsigned, [0,(2^32)-1].                   */  P typedef unsigned        bool   ; /* Unsigned, [0,1].                          */P typedef unsigned char   bool_  ; /* Unsigned, [0,1].           Space first.   */  P typedef int             sign   ; /* Signed  , [-1,0,1].                       */  P /******************************************************************************/  P /* C overloads the attribute keyword "static" horribly giving it meaning on   */P /* both the scoping and lifetime dimensions.  This section gives definitions  */P /* that clarify its use. If these macros are used, there should be no need    */P /* for the keyword "static" in programs using this style file.                */  P /* The following macros assist in making the scope of functions clearer. In   */P /* deciding on the names of these macros, I chose from the following lists:   */P /*    file    scope: PRIVATE, LOCAL, HIDDEN.                                  */P /*    program scope: EXPORT, PUBLIC, GLOBAL.                                  */P /* In the end I chose LOCAL and EXPORT. Note: I didn't want to allow more     */P /* than one form as that would have created too much confusion.               */ #define LOCAL  static  #define EXPORT  P /* It is desirable to use separate keywords for variables. This makes it      */P /* easier to search for them without stopping at every function. There are    */P /* four classes of variable that we wish to tag, along the two dimensions     */P /* scope:(local,global) and lifetime:(permanent,temporary). In C, all         */P /* variables declared outside of functions have permanent lifetime and so     */P /* the following two names (which should be used only to tag variables not    */P /* declared within a function) have been designed to emphasise the scope      */P /* dimension which is the principal concern for these variables.              */ #define LOCVAR static  #define GLOVAR  P /* Variables local to functions always have local scope and so the dimension  */P /* to emphasise is the lifetime. Automatic variables are the most common in   */P /* C and it would be messy to declare them all using a keyword. Far better    */P /* just to tag static local variables, emphasising their lifetime (STAtic).   */ #define STAVAR static   P /******************************************************************************/  P /* The following definitions are useful for dealing with void.                */P /* The typedefed definition "p_void" should always be used instead of         */P /* "void *" so as to improve portability.                                     */P /* The definition of "void" and "p_void" come from environ.h                  */ typedef p_void *p_p_void;  #define PV     (p_void)  #define PPV    (p_p_void)   P /******************************************************************************/  P /* The following symbols are more mnemonic than character escape sequences.   */ #define EOS '\0' #define EOL '\n'  P /******************************************************************************/  P /* The ANSI library functions use many different techniques for returning     */P /* status information. For example, fopen returns NULL upon failure, but      */P /* fclose returns EOF upon failure. The result is that it is hard to          */P /* proofread calls to these routines without constantly referring to the      */P /* library manual. To avoid this problem, we define symbols with helpful      */P /* names for the different values returned. This makes the code obvious.      */  P /* 07-Feb-1992: During porting I ran into a problem here with FPUTS_S. I had  */P /* defined it to be zero, as stated in the THINK C V4 ANSI library guide.     */P /* However, it turned out that fputs() returns EOF (-1) on failure and the    */P /* value that it returns on success is non negative! (See ANSI (7.9.7.4)).    */P /* Caught by an overspecification by the THINK C people! The lesson is that   */P /* it is very important to make sure that each function's status check symbol */P /* is defined on the "right" side (success or failure) - that is, the side    */P /* for which a single value for that status is guaranteed portably.           */P /* The following values have all been checked for this.                       */  P /* Note: _F=Failure, _S=Success, _FE=Failure or End of File.                  */   #define FOPEN_F  (NULL)  #define FSEEK_S     (0)  #define FTELL_F   (-1L)  #define FGETC_FE  (EOF)  #define FGETS_FE (NULL)  #define FPUTC_F   (EOF)  #define FPUTS_F   (EOF)  #define FFLUSH_S    (0)  #define FCLOSE_F  (EOF)  #define REMOVE_S    (0)  #define RENAME_S    (0)  #define MALLOC_F (NULL)   P /******************************************************************************/  P /* The following macro functions are handy. However, be sure not to hand them */P /* an argument with a non-idempotent side effect!!! (e.g. MAX(a++,b)).        */& #define MIN(A,B) ((A)<(B) ? (A) : (B))& #define MAX(A,B) ((A)>(B) ? (A) : (B))  P /******************************************************************************/  P /* Some environments don't define some stuff we need so we do it here.        */P /* Cautiously!                                                                */  
 #ifndef FALSE  #define FALSE (0)  #endif   #ifndef TRUE #define TRUE (1) #endif   #ifndef EXIT_FAILURE #define EXIT_FAILURE (-1)  #endif   #ifndef EXIT_SUCCESS #define EXIT_SUCCESS (0) #endif  P /******************************************************************************/  P /* The standard library macro/function "isprint" can be too loose in some     */P /* circumstances on some machines and it is convenient to define a macro      */P /* that provides a more strict 7-bit ASCII definition of "printable".         */- #define isascprn(ch) ((' '<=ch) && (ch<='~'))   P /******************************************************************************/  P /* Some compilers (GCC at least) complain about characters as a type in a     */P /* function argument. The following typedef is a quick hack that lets me say  */P /* that I really wanted the function argument to be a character, while        */P /* actually supplying an integer.                                             */ typedef int intchar;  P /******************************************************************************/P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                                End of STYLE.H                              */P /******************************************************************************/  