P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                   TABLE.C                                  */P /******************************************************************************/P /*                                                                            */P /* Notes                                                                      */P /* -----                                                                      */P /* - There are few comments at the start of each function. As definitions     */P /*   appear in the .H file, and it is dangerous to duplicate definitions, I   */P /*   have simply omitted them here.                                           */P /*                                                                            */P /* About The Cache                                                            */P /* ---------------                                                            */P /* A typical usage sequence for tables is for the user to first call tb_itb   */P /* to see if a key is in the table and then call either tb_loo or tb_ins      */P /* to lookup the value or to add a new (key,value) pair to the table.         */P /* In order to avoid performing TWO searches down the binary tree in such     */P /* cases, a CACHE is maintained in the table data structure between calls.    */P /*                                                                            */P /* ca_valid stores whether the cache contents are valid. If TRUE then:        */P /* ca_p_key points to a key.                                                  */P /* ca_p_node points to the node in the tree containing the key, or contains   */P /*    NULL if no such node exists.                                            */P /* ca_p_parent points to the node in the tree that is the parent of the node  */P /*    ca_p_node in the tree, or (if ca_p_node==NULL) WOULD BE the parent if a */P /*    node containing the key were inserted in the tree. If the tree is       */P /*    currently empty, ca_p_parent will be NULL.                              */P /*                                                                            */P /******************************************************************************/   #include "style.h"   #include "as.h"  #include "machin.h"  #include "memory.h"   P /******************************************************************************/  P /* In order to catch uninitialized and corrupted tables, the first and last   */P /* fields of legitimate table objects contain magic numbers. The following    */P /* #defines give the values of these numbers. The first thing that each       */P /* function of this package does is to check the two magic number fields of   */P /* the table it has just been passed, and bomb the package if the fields have */P /* the wrong values. This technique is likely to pick uninitialized tables,   */P /* as well as tables that have been partially overwritten.                    */% #define MAGIC_HEAD_VALUE  (53456839L) % #define MAGIC_TAIL_VALUE  (28434290L)   P /* Comparing keys is messy and so we define a macro to help us out.           */5 #define key_compare(a,b) ((*(p_tb->p_kycm))((a),(b)))   P /******************************************************************************/  P /* The functions of the table abstraction pass keys and values exclusively    */P /* using pointers. These two definitions define types for these pointers.     */P /* Although the two types are both 'p_void', the different types are useful   */P /* to indicate what is expected in each position of the parameter lists.      */ typedef p_void p_tbky_t; typedef p_void p_tbvl_t;  P /* Define a type for a function to compare two keys. Such functions are       */P /* needed to organize the storage of (key,value) pairs inside the table.      */P /* Given the arguments are (a,b), the function should return:                 */P /*    -1 if a<b                                                               */P /*     0 if a==b                                                              */P /*     1 if a>b                                                               */P /* The user must create such a function and hand it to the 'tb_create'        */P /* function when creating new a new table.                                    */1 typedef sign (*p_kycm_t) P_((p_tbky_t,p_tbky_t));   P /* The (key,value) pairs in the table are stored in a binary tree. The tree   */P /* is ordered by the key ordering function passed in at table creation.       */ typedef struct node_t_   {     struct node_t_ *p_left;    struct node_t_ *p_right;     struct node_t_ *p_parent;    p_tbky_t        p_key;     p_tbvl_t        p_value;    } 	   node_t;  typedef node_t *p_node_t;   N /* The type tb_t (table type) defines the root table data record. This      */N /* record stores attributes of the table along with the main binary tree of */N /* (key,value) pairs.                                                       */ typedef struct   { N    ulong     magic_head;       /* Magic number to allow corruption checks.  */N    size_t    key_bytes;        /* Number of bytes in a key.                 */N    size_t    value_bytes;      /* Number of bytes in a value.               */N    p_kycm_t  p_kycm;           /* Pointer to function to compare keys.      */N    p_node_t  tree;             /* Ptr to root of (key,value) binary tree.   */N    ulong     num_keys;         /* Number of (k,v) pairs in the table.       */N    bool      ca_valid;         /* Cache: TRUE iff cache contents are valid. */N    p_tbky_t  ca_p_key;         /* Cache: Key value cache contents refer to. */N    p_node_t  ca_p_node;        /* Cache: Pointer to node in binary tree.    */N    p_node_t  ca_p_parent;      /* Cache: Pointer to parent of ca_p_node.    */N    p_node_t  p_read_next;      /* Pointer to next node to be read.          */N    ulong     magic_tail;       /* Magic number to allow corruption checks.  */	   } tb_t;   N typedef tb_t *p_tb_t;           /* Pointer to main table record.            */  6 /* Defining INTABLEC hides the abstract definition. */ #define INTABLEC #include "table.h"  P /******************************************************************************/P /*                              PRIVATE FUNCTIONS                             */P /******************************************************************************/  7 LOCAL p_node_t new_node P_((p_tb_t,p_tbky_t,p_tbvl_t)); + LOCAL p_node_t new_node(p_tb,p_tbky,p_tbvl) P /* Creates a new tree node and returns a pointer to it.                       */P /* p_tb is the table for which the new node is to be created.                 */P /* p_tbky and p_tbvl point to the key and value to go in the new node.        */P /* Assumes that a tb_check(p_tb) has already been performed by the caller.    */ p_tb_t   p_tb; p_tbky_t p_tbky; p_tbvl_t p_tbvl; {   p_node_t p_node;   +  p_node=(p_node_t) mm_temp(sizeof(node_t));     p_node->p_left   = NULL;   p_node->p_right  = NULL;   p_node->p_parent = NULL; /  p_node->p_key    = mm_temp(p_tb->key_bytes  ); /  p_node->p_value  = mm_temp(p_tb->value_bytes);   2  memcpy(p_node->p_key  ,p_tbky,p_tb->key_bytes  );2  memcpy(p_node->p_value,p_tbvl,p_tb->value_bytes);    return p_node;  }   P /******************************************************************************/  ! LOCAL void tb_check P_((p_tb_t));  LOCAL void tb_check(p_tb) P /* Accepts a pointer to a table and performs a series of checks to make sure  */P /* that the table has not been corrupted in some way.                         */ p_tb_t p_tb; { 8  as_cold(p_tb!=NULL,"tb_check: Table pointer is NULL.");,  as_cold(p_tb->magic_head==MAGIC_HEAD_VALUE,C          "tb_check: Magic number at head of record is incorrect."); ,  as_cold(p_tb->magic_tail==MAGIC_TAIL_VALUE,C          "tb_check: Magic number at tail of record is incorrect.");  }   P /******************************************************************************/  ' LOCAL p_node_t min_leaf P_((p_node_t));  LOCAL p_node_t min_leaf(p_node) P /* Returns a pointer to the node that is leftmost (has the smallest value     */P /* according to the ordering function) in the specified node's subtree.       */ p_node_t p_node; {   if (p_node==NULL)     return NULL;  while (p_node->p_left != NULL)      p_node=p_node->p_left;  return p_node;  }   P /******************************************************************************/  ( LOCAL p_node_t next_node P_((p_node_t));  LOCAL p_node_t next_node(p_node)P /* Give a pointer to a node in the binary tree, returns a pointer to the next */P /* node (in sequence defined by the order function) or NULL if the given node */P /* is the last node in the ordered sequence.                                  */ p_node_t p_node; { P  /* If there is a right subtree, we need the minimum node of that subtree.    */  if (p_node->p_right != NULL) %     return min_leaf(p_node->p_right);   =  /* Otherwise go up as far as possible through right arcs. */ D  while (p_node->p_parent!=NULL && p_node->p_parent->p_right==p_node)     p_node=p_node->p_parent;  return p_node->p_parent;  }   P /******************************************************************************/  + LOCAL void tb_search P_((p_tb_t,p_tbky_t)); ! LOCAL void tb_search(p_tb,p_tbky) P /* Calling this function with a particular key value results in the cache     */P /* becoming valid and containing the specified key.                           */ p_tb_t   p_tb; p_tbky_t p_tbky; {   p_node_t p,p_parent;     tb_check(p_tb);  1  /* Return if the cache is already up to date. */   if (p_tb->ca_valid)/    if (key_compare(p_tbky,p_tb->ca_p_key) == 0) 
       return;      p_parent=NULL;   p=p_tb->tree;    while (p != NULL) )      switch(key_compare(p_tbky,p->p_key))         {1         case -1: p_parent=p; p=p->p_left;  break; 1         case  1: p_parent=p; p=p->p_right; break;          case  0: goto found;         default:M            as_bomb("tb_search: Key comparison function returned bad value.");         }   found:   p_tb->ca_valid    = TRUE; 0   memcpy(p_tb->ca_p_key,p_tbky,p_tb->key_bytes);   p_tb->ca_p_node   = p;   p_tb->ca_p_parent = p_parent;  }   P /******************************************************************************/  # LOCAL void des_tree P_((p_node_t));  LOCAL void des_tree(p_root)  p_node_t p_root; {   if (p_root==NULL)     return;   des_tree(p_root->p_left);  des_tree(p_root->p_right);   P  /* This is what we would need if it wasn't for the MM watermark system.      */  /* DEALLOCATE(PV p_root); */  }   P /******************************************************************************/P /*                              EXPORTED FUNCTIONS                            */P /******************************************************************************/  2 EXPORT p_tb_t tb_cre(key_bytes,value_bytes,p_kycm) size_t   key_bytes;  size_t   value_bytes;  p_kycm_t p_kycm; { 
  p_tb_t p_tb;   4  p_tb              = (p_tb_t) mm_temp(sizeof(tb_t));&  p_tb->magic_head  = MAGIC_HEAD_VALUE;  p_tb->key_bytes   = key_bytes; !  p_tb->value_bytes = value_bytes;   p_tb->p_kycm      = p_kycm;  p_tb->tree        = NULL;  p_tb->num_keys    = 0;   p_tb->ca_valid    = FALSE; 3  p_tb->ca_p_key    = (p_tbky_t) mm_temp(key_bytes); L  p_tb->ca_p_node   = NULL; /* This initialization not strictly necessary. */L  p_tb->ca_p_parent = NULL; /* This initialization not strictly necessary. */  p_tb->p_read_next = NULL;&  p_tb->magic_tail  = MAGIC_TAIL_VALUE;  
  return p_tb;  }   P /******************************************************************************/   EXPORT bool tb_itb(p_tb,p_tbky)  p_tb_t   p_tb; p_tbky_t p_tbky; {   tb_check(p_tb);    tb_search(p_tb,p_tbky);   return p_tb->ca_p_node != NULL; }   P /******************************************************************************/  & EXPORT void tb_loo(p_tb,p_tbky,p_tbvl) p_tb_t   p_tb; p_tbky_t p_tbky; p_tbvl_t p_tbvl; {   tb_check(p_tb);    tb_search(p_tb,p_tbky);C  as_cold(p_tb->ca_p_node!=NULL,"tb_loo: Requested key is absent."); ;  memcpy(p_tbvl,p_tb->ca_p_node->p_value,p_tb->value_bytes);  }   P /******************************************************************************/  & EXPORT void tb_ins(p_tb,p_tbky,p_tbvl) p_tb_t   p_tb; p_tbky_t p_tbky; p_tbvl_t p_tbvl; {   p_node_t p_new;    tb_check(p_tb);  E  /* Validate the cache. Note: tb_search does it's own cache check. */   tb_search(p_tb,p_tbky);  >  /* Ensure that the table does not already contain the key. */N  as_cold(p_tb->ca_p_node==NULL,"tb_ins: Key is already present in the p_tb.");    /* Create the new node. */ $  p_new=new_node(p_tb,p_tbky,p_tbvl);  )  /* Insert the new node into the tree. */   if (p_tb->ca_p_parent==NULL)      p_tb->tree=p_new;   else 8     switch(key_compare(p_tbky,p_tb->ca_p_parent->p_key))       { 8        case -1: p_tb->ca_p_parent->p_left =p_new; break;8        case  1: p_tb->ca_p_parent->p_right=p_new; break;L        default: as_bomb("tb_ins: Key comparison function is inconsistent.");       } #  p_new->p_parent=p_tb->ca_p_parent;   A  /* Need to fiddle cache to make it correct, and inc num_keys. */   p_tb->ca_p_node=p_new;   p_tb->num_keys++; }   P /******************************************************************************/   EXPORT ulong tb_len(p_tb)  p_tb_t p_tb; {   tb_check(p_tb);  return p_tb->num_keys;  }   P /******************************************************************************/   EXPORT void tb_fir(p_tb) p_tb_t p_tb; {   tb_check(p_tb);  (  p_tb->p_read_next=min_leaf(p_tb->tree); }   P /******************************************************************************/  & EXPORT bool tb_rea(p_tb,p_tbky,p_tbvl) p_tb_t    p_tb;  p_tbky_t  p_tbky;  p_tbvl_t  p_tbvl;  {   tb_check(p_tb);    if (p_tb->p_read_next == NULL)      return FALSE;   =  memcpy(p_tbky,p_tb->p_read_next->p_key  ,p_tb->key_bytes  ); =  memcpy(p_tbvl,p_tb->p_read_next->p_value,p_tb->value_bytes);   0  p_tb->p_read_next=next_node(p_tb->p_read_next);  
  return TRUE;  }   P /******************************************************************************/  	 #if FALSE  EXPORT void tb_des(p_tb) p_tb_t p_tb; { ?  /* This routine now unused because of the watermark system. */   return;    /* tb_check(p_tb); */  M  /* Zap the magic numbers in case the memory is re-used in same alignment. */   /* p_tb->magic_head=0; */  /* p_tb->magic_tail=0; */  P  /* This is what we would need if it wasn't for the MM watermark system.      */8  /* des_tree(p_tb->tree); */  /* Zap the binary tree. */8  /* DEALLOCATE(PV p_tb);  */  /* Zap the node itself. */ }  #endif  P /******************************************************************************/P /*                                   TABLE.C                                  */P /******************************************************************************/  