P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                   TABLE.H                                  */P /******************************************************************************/P /*                                                                            */P /* Introduction                                                               */P /* ------------                                                               */P /* This table package (table.h and table.c) implements a table abstraction.   */P /*                                                                            */P /* Facts about Tables                                                         */P /* ------------------                                                         */P /* - A TABLE stores zero or more (KEY,VALUE) PAIRS.                           */P /* - The user decides the types of keys and values and provides a             */P /*   COMPARISON FUNCTION providing a complete ordering of the set of keys.    */P /* - The comparison function must be consistent between calls.                */P /* - Tables store pairs in key order.                                         */P /* - A table cannot store more than one pair with the same key.               */P /* - Pairs can be added, but not deleted.                                     */P /* - A table can return the value corresponding to a given key.               */P /* - The pairs in a table can be read sequentially in key order. At all       */P /*   times, the table has an imaginary MARKER positioned on one of its pairs  */P /*   (or after the last pair). You can move the marker to the first pair and  */P /*   you can move the marker to the next pair, reading the pair as you go.    */P /*   Upon table creation, a table's marker is at the end-of-table position.   */P /* - If you try to perform an illegal operation on a table, the table package */P /*   will call "error" to write out an error message and bomb the program.    */P /* - Tables store copies of (key,value) pairs. They do not hold pointers to   */P /*   outside data (unless your keys or values are pointers themselves).       */P /* - If the keys are pointers themselves and point to other data which is     */P /*   used by the comparison function, then that data must not be modified     */P /*   in a way that will change the order of pairs in the table.               */P /* - A table can hold from zero to about 2^31 pairs.                          */P /* - The identifier "tb" is used as an abbreviation for "table".              */P /* - The identifier "ky" is used as an abbreviation for "key".                */P /* - The identifier "vl" is used as an abbreviation for "value".              */P /* - The author would like to use longer names, but has chosen to use the     */P /*   abbreviations so as to enhance the portability of the code.              */P /* - IMPORTANT: Tables get all their memory using mm_temp calls.              */P /*                                                                            */P /* How To Use This Table Package                                              */P /* -----------------------------                                              */P /* 1. Include this .H file in your program file.                              */P /* 2. Identify the key and value types that you are going to use.             */P /* 3. Define a function (having two parameters being pointers to keys)        */P /*    that compares two keys and returns [-1,0,1] accordingly.                */P /* 4. Define a variable of type p_tb as a view to a table.                    */P /* 5. Use the tb_* functions to perform the desired operations.               */P /*    Start with a call to tb_cre and (optionally) end with a call to tb_des. */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_TABLE #define DONE_TABLE  P /******************************************************************************/   #include <stddef.h>  #include "style.h"  P /******************************************************************************/  P /* Hide the exported abstract definition of a table from the table.c package. */P /* Table.c defines INTABLEC so as to prevent itself from seeing the following */P /* definitions. It defines its own more concrete definitions.                 */ #ifndef INTABLEC  P /* The functions of the table abstraction pass keys and values exclusively    */P /* using pointers. These two definitions define types for these pointers.     */P /* Although the two types are both 'p_void', the different types are useful   */P /* to indicate what is expected in each position of the parameter lists.      */ typedef p_void p_tbky_t; typedef p_void p_tbvl_t;  P /* Define a type for a function to compare two keys. Such functions are       */P /* needed to organize the storage of (key,value) pairs inside the table.      */P /* Given the arguments are (a,b), the function should return:                 */P /*    -1 if a<b                                                               */P /*     0 if a==b                                                              */P /*     1 if a>b                                                               */P /* The user must create such a function and hand it to the 'tb_create'        */P /* function when creating new a new table.                                    */1 typedef sign (*p_kycm_t) P_((p_tbky_t,p_tbky_t));   P /* Users manipulate tables through pointers to tables. Here the actual table  */P /* internals are hidden from the user.                                        */8 typedef struct {word NEVER_USE_THIS_FIELD_UQJTKC;} tb_t; typedef tb_t *p_tb_t;    #endif  P /******************************************************************************/  P /* General Notes About These Functions                                        */P /* -----------------------------------                                        */P /* - All tables, keys, and values are passed by pointer. Whether a parameter  */P /*   is read or written is determined by it's functions description.          */P /* - Each function (except tb_cre) accepts a single pointer to a table and    */P /*   each function's description is assumed to be referring to the table.     */P /* - "Raising an error" means calling the external function "error" to        */P /*   write out a message and bomb the program.                                */P /* - You must create a table using tb_cre before performing any operations    */P /*   upon it. The table operations will usually raise an error if they are    */P /*   handed a pointer that does not point to a properly CREated table.        */  P /* The Functions                                                              */P /* -------------                                                              */2 EXPORT p_tb_t tb_cre P_((size_t,size_t,p_kycm_t));P /* CREate. This function creates a new table and returns a pointer to the     */P /* table. The user must supply 1) the size in bytes of keys, 2) the size in   */P /* bytes of values, 3) a pointer to a function that compares two keys.        */  ) EXPORT bool tb_itb P_((p_tb_t,p_tbky_t)); P /* InTaBle. Returns TRUE iff the given key is in the table.                   */  2 EXPORT void tb_loo P_((p_tb_t,p_tbky_t,p_tbvl_t));P /* LOOkup. Feed this function a table and a key and it will return (in the    */P /* p_tbvl_t parameter) the value corresponding to the key. The function       */P /* raises an error if the table does not contain the key.                     */  2 EXPORT void tb_ins P_((p_tb_t,p_tbky_t,p_tbvl_t));P /* INSert. Inserts the (key,value) pair into the table. Raises an error if    */P /* the key is already in the table.                                           */  ! EXPORT ulong tb_len P_((p_tb_t)); 7 /* LENgth. Returns the number of pairs in the table. */     EXPORT void tb_fir P_((p_tb_t));P /* FIRst. Set's the table's marker to the first pair in the table (or the end */P /* of table position if the table is empty.                                   */  2 EXPORT bool tb_rea P_((p_tb_t,p_tbky_t,p_tbvl_t));P /* REAd. Returns in (p_tbky_t,p_tbvl_t) the (key,value) pair corresponding to */P /* the marker and them moves the marker onto the next pair.                   */P /* Returns TRUE  => Returned a pair.                                          */P /* Returns FALSE => Did not return a pair. No more pairs left.                */P /* of key) to be read from the table. Returns TRUE if it returns a pair       */P /* This function will not raise an error if it is called more than once with  */P /* the marker at the end of the table (it just keeps returning FALSE).        */  	 #if FALSE  void tb_des P_((p_tb_t)); P /* DEStroy. Destroys a table, deallocating all its memory.                    */ #endif  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                                 End of TABLE.H                             */P /******************************************************************************/