P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                  TEXHEAD.H                                 */P /******************************************************************************/P /*                                                                            */P /* TEX HEADER PACKAGE                                                         */P /* ==================                                                         */P /* This package contains a single function that writes the TeX header         */P /* (containing all the Weave macros) to the specified stream. The package     */P /* consists of:                                                               */P /*                                                                            */P /* texhead.tex - The header file ("source code" for texhead.ctx).             */P /* texhead.ctx - C code automatically generated by texhead.tex.               */P /* texhead.h   - This file, containing a function definition.                 */P /* texhead.c   - Contains a function body.                                    */P /*                                                                            */P /* The first version of FunnelWeb (1986) generated TeX output files that used */P /* a collection of macros to neaten and simplify the bulk of the TeX output   */P /* file. For example, the macro \fwbtx provided a simple way to specify       */P /* verbatim text. This system worked extremely well, the only inconvenience   */P /* being that each FunnelWeb TeX output file had to "\input" the TeX header   */P /* file containing all the macros. At the time, this seemed a sensible        */P /* factorization of the macros, and, within the limited environment in which  */P /* FunnelWeb was operating, worked well.                                      */P /*                                                                            */P /* In NEW, IMPROVED FunnelWeb, "\input"ing the header file has the potential  */P /* to cause lots of problems, the major ones being:                           */P /*                                                                            */P /* - The header file would have to be installed as part of the FunnelWeb      */P /*   system. Currently this means that it would be the ONLY other file        */P /*   necessary apart from the FunnelWeb executable. It would be far more      */P /*   desirable to avoid having to install the header file.                    */P /*                                                                            */P /* - The header file would have to be referred to somehow by the TeX file.    */P /*   As it makes sense to have only one copy of the header file on a machine, */P /*   TeX files would have to refer to that copy. This would require one of a  */P /*   number of messy machine-specific mechanisms such as (VMS) logical name   */P /*   translation or environment variable translation.                         */P /*                                                                            */P /* - TeX files could not be easily moved to other machines (particularly      */P /*   those not running FunnelWeb themselves) without also sending the header  */P /*   file.                                                                    */P /*                                                                            */P /* - If FunnelWeb and the header file were ever jointly modified, the dynamic */P /*   binding of old TeX files would mean that they may no longer be printable.*/P /*                                                                            */P /* For all these reasons, the decision was made to write the library of TeX   */P /* macros at the start of each TeX output file, thus making each TeX output   */P /* file entirely self-contained. To do this, the header file had to be        */P /* converted into a sequence of C output statments. To this end, a new        */P /* FunnelWeb shell command CODIFY was added that performs this transformation.*/P /* CODIFY could have been a separate utility program, but if it was, it might */P /* somehow be separated from the rest of FunnelWeb during distribution. By    */P /* building CODIFY into FunnelWeb itself, this possibility is eliminated.     */P /*                                                                            */P /* This package encapsulates the automatically generated C code. This header  */P /* file defines a function that writes it to a specified stream. The package  */P /* body texhead.c contains the body of the function which consists mainly of  */P /* a #include of the automatically generated C code in texhead.ctx.           */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_TEXH  #define DONE_TEXH   P /******************************************************************************/   #include "style.h"   #include "writfile.h"   P /******************************************************************************/  " EXPORT void tex_head P_((p_wf_t));C /* Writes the FunnelWeb TeX header block to the argument stream. */   P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                             End of TEXHEAD.H                               */P /******************************************************************************/