P /*##############################################################################   FUNNNELWEB COPYRIGHT ====================7 FunnelWeb is a literate-programming macro preprocessor.   $ Copyright (C) 1992 Ross N. Williams.      Ross N. Williams     ross@spam.adelaide.edu.au5    16 Lerwick Avenue, Hazelwood Park 5066, Australia.   D This program is free software; you can redistribute it and/or modifyD it under the terms of Version 2 of the GNU General Public License as* published by the Free Software Foundation.  J This program is distributed WITHOUT ANY WARRANTY; without even the implied@ warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.A See Version 2 of the GNU General Public License for more details.   F You should have received a copy of Version 2 of the GNU General PublicE License along with this program. If not, you can FTP the license from ? prep.ai.mit.edu/pub/gnu/COPYING-2 or write to the Free Software 9 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   C Section 2a of the license requires that all changes to this file be B recorded prominently in this file. Please record all changes here.   Programmers:3    RNW  Ross N. Williams  ross@spam.adelaide.edu.au    Changes:C    07-May-1992  RNW  Program prepared for release under GNU GPL V2.   P ##############################################################################*/    P /******************************************************************************/P /*                                   WRITFILE.H                               */P /******************************************************************************/P /*                                                                            */P /* Introduction                                                               */P /* ------------                                                               */P /* This package performs all of FunnelWeb's file output.                      */P /* FunnelWeb performs lots of output to lots of different files:              */P /*                                                                            */P /*    - Standard output (to write to the screen).                             */P /*    - The journal file.                                                     */P /*    - The listing file.                                                     */P /*    - The tangle output files.                                              */P /*    - The weave output file.                                                */P /*                                                                            */P /* Error Detection                                                            */P /* ---------------                                                            */P /* As we are serious about detecting errors, every call to every IO function  */P /* must have its status checked. Unfortunately this makes everything very     */P /* messy. Having to check result statuses and react to them can be very       */P /* awkward in deeply nested pieces of code, particularly as C does not have   */P /* exceptions. As a result, the policy adopted in FunnelWeb is to RECORD when */P /* an error occurs on an output stream and silently shut down that stream.    */P /* Then later, at a convenient time, the error status of the stream can be    */P /* checked, and an error message issued.                                      */P /*                                                                            */P /* The C libraries make an effort to be helpful here by providing the ferror  */P /* function. However, it is not useful here for two reasons:                  */P /*                                                                            */P /*    1. Some calls (e.g. fwrite) are not listed as setting the error status. */P /*    2. It is not guaranteed that IO calls to a stream with error status     */P /*       will not cause a crash.                                              */P /*    3. Even if ferror were used, it may not be supported by older compilers.*/P /*                                                                            */P /* This package was created to take care of the vexing problems of IO errors  */P /* in output streams. It is a layer above the ANSI file library that provides */P /* the elementary calls for writing. It differs in that if an error occurs,   */P /* the package records that fact and simply ignores all further operations    */P /* on the file. At any time, it is possible to find out whether a file is in  */P /* normal mode or error mode. All this means that a piece of code can use     */P /* this package to create and write to a file without worrying about errors.  */P /* Then later, when the dust settles, the package can check the status  of    */P /* the file, and take appropriate action if an error has been detected.       */P /*                                                                            */P /* Text vs Binary                                                             */P /* --------------                                                             */P /* This package translates all '\n' (contained in the data it has been given  */P /* to write) into the appropriate environment specific representation.        */P /*                                                                            */P /* Facts About WF Objects                                                     */P /* ----------------------                                                     */P /* - A WF object is either in NORMAL or ERROR mode.                           */P /* - A WF object in NORMAL mode is also either in OPEN or CLOSED mode.        */P /* - The term "raise an error" means bomb the program with a message.         */P /* - The comments attached to the functions given below are meant to be read  */P /*   sequentially with each action or check being performed before the next.  */P /* - This package can not guarantee to detect uninitialized WF objects. The   */P /*   reason is that policing is performed using magic number mechanism and it */P /*   is possible that a piece of random memory may contain just the right     */P /*   numbers to fool the package.                                             */P /*                                                                            */P /******************************************************************************/  P /* Ensure that the body of this header file is included at most once.         */ #ifndef DONE_WRITFILE  #define DONE_WRITFILE   P /******************************************************************************/   #include "style.h"  P /******************************************************************************/  P /* We really don't want to show all the guts of this record here, but as      */P /* users of the package have to be able to declare objects of this type and   */P /* make them the right size, it seems as if we have no choice.                */ typedef struct   { P    ulong  wf_mhead;   /* Helps detect uninitialized and corrupted records.    */P    bool   wf_iserr;   /* TRUE=>ERROR,   FALSE=>NORMAL.                        */P    bool   wf_isope;   /* TRUE=>OPEN,    FALSE=>CLOSED.                        */P    bool   wf_istxt;   /* TRUE=>TEXT,    FALSE=>BINARY.                        */P    FILE  *wf_pfile;   /* Pointer to the file object.                          */P    ulong  wf_mtail;   /* Helps detect uninitialized and  corrupted records.   */	   } wf_t;    typedef wf_t *p_wf_t;   P /******************************************************************************/  % EXPORT void wf_ini P_((p_wf_t,bool)); P /* Initializes a WF to a well defined state in accordance with the boolean.   */P /*    FALSE => State=(ERROR).                                                 */P /*    TRUE  => State=(NORMAL,CLOSED).                                         */P /* wf_ini must be applied to a WF before any other operation.                 */P /* It can be re-applied repeatedly.                                           */  ' EXPORT void wf_att P_((p_wf_t,FILE *)); P /* If WF is uninitialized, raises an error (probably).                        */P /* If WF is in ERROR mode, returns with no effect.                            */P /* If WF is OPEN, raises an error.                                            */P /* Attaches an already opened output file to the specified FW object.         */P /* Changes the WF to the OPEN state.                                          */P /* The memory that the second parameter points to must be stable.             */  ' EXPORT void wf_ope P_((p_wf_t,char *)); P /* If WF is uninitialized, raises an error (probably).                        */P /* If WF is in ERROR mode, returns with no effect.                            */P /* If WF is OPEN, raises an error.                                            */P /* Creates an output file of the specified name and prepares it for writing.  */P /* Changes the WF to the OPEN state.                                          */P /* Sets the WF to the ERROR state if the file cannot be opened for writing.   */  ( EXPORT void wf_chr P_((p_wf_t,intchar));P /* If WF is uninitialized, raises an error (probably).                        */P /* If WF is in ERROR mode, returns with no effect.                            */P /* If WF is CLOSED, raises an error.                                          */P /* Writes the specified character to the output file associated with WF.      */P /* Sets WF to the ERROR state if an error occurs during the write.            */  & EXPORT void wf_wr P_((p_wf_t,char *));P /* Same as wf_chr except that it writes an entire string.                     */  & EXPORT void wf_wl P_((p_wf_t,char *));P /* Same as wf_wr except that appends a '\n'.                                  */  . EXPORT void wf_blk P_((p_wf_t,char *,size_t));P /* Same as wf_wr but writes a block of bytes whose address is given by the    */P /* second parameter and whose length (in bytes) is given by the third         */P /* parameter.                                                                 */    EXPORT void wf_clo P_((p_wf_t));P /* If WF is uninitialized, raises an error (probably).                        */P /* If WF is in ERROR mode, returns with no effect.                            */P /* If WF is CLOSED, raises an error.                                          */P /* Flushes and closes the output file attached to WF.                         */P /* Sets WF to the CLOSED state.                                               */P /* Sets WF to the ERROR state if an error occurs during the close.            */    EXPORT bool wf_err P_((p_wf_t));P /* If WF is uninitialized, raises an error (probably).                        */P /* Returns TRUE iff WF is in the ERROR state, otherwise FALSE.                */P /* This function can be called at any time so long as the WF is initialized.  */  P /******************************************************************************/  P /* For #ifndef preventing multiple inclusion of the body of this header file. */ #endif  P /******************************************************************************/P /*                              End of WRITFILE.H                             */P /******************************************************************************/