  IMPLEMENTATION MODULE DVIReader;  # (* Author:         Andrew Trevorrow I    Implementation: University of Hamburg Modula-2 under VAX/VMS version 4     Date Started:   August, 1984       Description: M    Implements routines and data structures for use in a TeX82 DVI translator. I    Much of the code in DVIReader is based on DVITYPE 2.7 by Donald Knuth. K    DVITYPE is a program for verifying a DVI file and also serves as a model K    for other DVI-reading programs.  See the "TeXWARE" manual by Knuth for a ?    complete description of DVITYPE and the format of DVI files. N    For efficiency reasons we assume the given DVI file is formatted correctly;6    it is the job of DVITYPE to diagnose bad DVI files.      Revised:     August, 1986 H  - PSDVI requires that MoveToDVIPage no longer assumes InterpretPage has4    been called after any previous MoveTo... routine.      December, 1986 >  - Initialize fontexists flag to FALSE when reading postamble.  1    June--August, 1988 (while at Aston University) F  - Import hoffset and voffset from Options to handle shifting of page. *)   FROM SYSTEM IMPORT-    ADDRESS,                (* byte address *) 
    ADR, BYTE;    FROM Storage IMPORT 9    ALLOCATE, DEALLOCATE;   (* need for NEW and DISPOSE *)    FROM VMS IMPORT 0    SYS$OPEN, SYS$CRMPSC, SYS$DASSGN, SYS$DELTVA;   FROM SSDefinitions IMPORT     SS$_ENDOFFILE;    FROM SECDefinitions IMPORT    SEC$V_EXPREG;   FROM RMS IMPORT     FAB, InitFab,    FOPset, FOPtype,     FACset, FACtype,     SHRset, SHRtype;    (* DEBUG= (* DVIReader will only do terminal output while debugging. *)  FROM TermOut IMPORT :    Write, WriteString, WriteLn, WriteInt, WriteCard, Halt; GUBED *)   FROM Options IMPORT     hoffset, voffset;    P (*******************************************************************************1    DECLARATIONS FOR RANDOMLY ACCESSING A DVI FILE   I    A DVI file is considered to be an array of 8-bit bytes, ending with at >    least 4 223 bytes and having a total length divisible by 4.M    Under VAX/VMS a DVI file has fixed-length, 512-byte records (1 per block). E    The last record/s will be padded with 223 bytes to ensure that the G    above conditions hold.  We will be randomly positioning to DVI bytes M    by setting DVIoffset, and reading bytes via GetDVIByte, SignedDVIByte etc.  *)   TYPEA    (* DVI file should never have more than MAX(INTEGER) bytes! *) 0    DVIfile    = ARRAY [0..MAX(INTEGER)] OF BYTE;P    DVIpointer = POINTER TO DVIfile;                       (* never allocated! *)   VAR P    vas : ARRAY [0..1] OF ADDRESS;      (* start and end virtual addresses     *)    DVIstart : DVIpointer; P    DVIoffset : CARDINAL;               (* current byte offset in DVIfile      *)P    channel : CARDINAL;                 (* fab.STV returned by SYS$OPEN        *)P    gsdnam : ARRAY [0..42] OF CHAR;     (* unused argument in SYS$CRPMSC       *)    status : CARDINAL; 
    fab : FAB; P    postpostid : CARDINAL;              (* offset of postpost's id byte        *)  P (******************************************************************************)  - PROCEDURE OpenDVIFile (name : ARRAY OF CHAR);   H (* If the given file can be opened and is a valid TeX82 DVI file then weD    process the postamble and initialize currDVIpage and currTeXpage. *)   VAR i : CARDINAL;    BEGIN 9 InitFab(fab);                        (* initialize fab *)  WITH fab DO 8    FNA := ADR(name);                 (* DVI file name *)=    FNS := BYTE(LEN(name));           (* bytes in file name *) 4    FAC := FACset{FAC$BRO,FAC$GET};   (* read-only *)H    SHR := SHRset{SHR$GET};           (* share file with other readers *)>    FOP := FOPset{FOP$UFO};           (* need for SYS$CRMPSC *)E    RTV := BYTE(-1);                  (* for more efficient mapping *)  END;8 status := SYS$OPEN(ADR(fab),0,0);    (* open the file *) IF ODD(status) THEN     WITH fab DOH       channel := STV;                (* channel on which file is open *)    END; ;    (* now map entire DVI file into virtual address space *)     vas[0] := 0;     vas[1] := 0;     status := SYS$CRMPSC H                  (ADR(vas),          (* starting and ending addresses *)=                   ADR(vas),          (* addresses returned *)                    0,P                   {SEC$V_EXPREG},    (* pages mapped into 1st available space *)                   gsdnam,0,0, P                   channel,           (* channel on which file has been opened *)                   0,0,0,H                   36                 (* large page fault cluster size *)                  ); !    IF status = SS$_ENDOFFILE THEN >       DVIErrorRoutine(DVIempty);     (* given file is empty *)    ELSIF NOT ODD(status) THEN        (* DEBUGF          WriteString('SYS$CRMPSC failed! status='); WriteCard(status);          WriteLn; Halt(2);       GUBED *)&       DVIErrorRoutine(DVIcatastrophe);    ELSE J       (* Now that the entire DVI file is mapped into virtual memory we canE          access any DVI byte as an offset from the address in vas[0].        *)       DVIstart := vas[0]; !       (* move to last DVI byte *) A       DVIoffset := CARDINAL(ADDRESS(vas[1]) - ADDRESS(DVIstart)); @       (* check for trailing NULs first in case DVI file has come!          from non-VMS environment        *)G       WHILE (DVIoffset > 0) AND (CARDINAL(DVIstart^[DVIoffset]) = 0) DO 8          DEC(DVIoffset);             (* skip NUL byte *)
       END;I       WHILE (DVIoffset > 0) AND (CARDINAL(DVIstart^[DVIoffset]) = 223) DO 8          DEC(DVIoffset);             (* skip 223 byte *)
       END;G       postpostid := DVIoffset;       (* remember position of id byte *)        IF GetDVIByte() <> 2 THEN           (* DEBUG D             WriteString('Bad DVI file! id byte is not 2.'); WriteLn;             Halt(2);          GUBED *) E          DVIErrorRoutine(DVIbadid);  (* not a valid TeX82 DVI file *) 
       ELSEF          ProcessPostamble;           (* get DVImag, totalpages, etc *)I          ProcessFontDefs;            (* build and initialize font list *) J          currDVIpage := 0;           (* we haven't processed a page yet *)          FOR i := 0 TO 9 DO               currTeXpage[i] := 0;
          END; 
       END;    END;  ELSEI    DVIErrorRoutine(DVIunopened);     (* given file could not be opened *)  END; END OpenDVIFile;  P (******************************************************************************)  : (* Here are the functions used to get byte/s from DVIfile.:    They are essentially the same as those used in DVITYPE. *)  " PROCEDURE GetDVIByte () : INTEGER;  < (* Returns the value (unsigned) of the byte at DVIoffset and.    advances DVIoffset for the next GetDVIByte. *)   VAR b : CARDINAL;    BEGIN 6 b := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);	 RETURN b;  END GetDVIByte;   P (******************************************************************************)  F PROCEDURE SignedDVIByte () : INTEGER;      (* the next byte, signed *)   VAR b : CARDINAL;    BEGIN 6 b := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset); IF b < 128 THEN     RETURN b; ELSE    RETURN b - 256; END; END SignedDVIByte;  P (******************************************************************************)  K PROCEDURE GetTwoDVIBytes () : INTEGER;     (* the next 2 bytes, unsigned *)    VAR a, b : CARDINAL;   BEGIN 6 a := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);6 b := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset); RETURN a * 256 + b;  END GetTwoDVIBytes;   P (******************************************************************************)  I PROCEDURE SignedDVIPair () : INTEGER;      (* the next 2 bytes, signed *)    VAR a, b : CARDINAL;   BEGIN 6 a := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);6 b := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset); IF a < 128 THEN     RETURN a * 256 + b; ELSE    RETURN (a - 256) * 256 + b; END; END SignedDVIPair;  P (******************************************************************************)  K PROCEDURE GetThreeDVIBytes () : INTEGER;   (* the next 3 bytes, unsigned *)    VAR a, b, c : CARDINAL;    BEGIN 6 a := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);6 b := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);6 c := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset); RETURN (a * 256 + b) * 256 + c;  END GetThreeDVIBytes;   P (******************************************************************************)  I PROCEDURE SignedDVITrio () : INTEGER;      (* the next 3 bytes, signed *)    VAR a, b, c : CARDINAL;    BEGIN 6 a := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);6 b := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);6 c := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset); IF a < 128 THEN "    RETURN (a * 256 + b) * 256 + c; ELSE*    RETURN ((a - 256) * 256 + b) * 256 + c; END; END SignedDVITrio;  P (******************************************************************************)  I PROCEDURE SignedDVIQuad () : INTEGER;      (* the next 4 bytes, signed *)    VAR a, b, c, d : CARDINAL;   BEGIN 6 a := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);6 b := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);6 c := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset);6 d := CARDINAL(DVIstart^[DVIoffset]);   INC(DVIoffset); IF a < 128 THEN .    RETURN ((a * 256 + b) * 256 + c) * 256 + d; ELSE6    RETURN (((a - 256) * 256 + b) * 256 + c) * 256 + d; END; END SignedDVIQuad;  P (******************************************************************************)   PROCEDURE ProcessPostamble;   A (* Having successfully opened the DVI file, we find the postamble )    and initialize these global variables: 3    lastbop, num, den, DVImag, maxstack, totalpages. 4    The font definitions are read by ProcessFontDefs. *)  @ VAR postamblepos, postamble, pagehtplusdp, pagewidth : CARDINAL;   BEGIN  DVIoffset    := postpostid - 4; F postamblepos := SignedDVIQuad();   (* get post_post's postamble ptr *) DVIoffset    := postamblepos;  postamble    := GetDVIByte();   lastbop      := SignedDVIQuad();  num          := SignedDVIQuad();  den          := SignedDVIQuad();  DVImag       := SignedDVIQuad();  pagehtplusdp := SignedDVIQuad();  pagewidth    := SignedDVIQuad();  maxstack     := SignedDVIPair();  totalpages   := SignedDVIPair(); IF maxstack > maxstacksize THEN     (* DEBUG <       WriteString('Stack capacity exceeded!   maxstack = ');       WriteCard(maxstack);H       WriteString(' but maxstacksize only = '); WriteCard(maxstacksize);       WriteLn;       Halt(2);    GUBED *) %    DVIErrorRoutine(DVIstackoverflow); ?    (* now we don't need to test for stack overflow in DoPush *)  END; (* DEBUGJ    WriteString('postamble opcode     ='); WriteInt(postamble);    WriteLn;J    WriteString('postion of last bop  ='); WriteInt(lastbop);      WriteLn;J    WriteString('num                  ='); WriteInt(num);          WriteLn;J    WriteString('den                  ='); WriteInt(den);          WriteLn;J    WriteString('DVI mag              ='); WriteInt(DVImag);       WriteLn;J    WriteString('ht+dp of tallest page='); WriteInt(pagehtplusdp); WriteLn;J    WriteString('width of widest page ='); WriteInt(pagewidth);    WriteLn;J    WriteString('max stack depth      ='); WriteInt(maxstack);     WriteLn;J    WriteString('total # of pages     ='); WriteInt(totalpages);   WriteLn; GUBED *) END ProcessPostamble;   P (******************************************************************************)   PROCEDURE ProcessFontDefs;  H (* Read the fntdef commands in the postamble (fntdef commands in the DVIE    pages will be skipped) and store the information in the font list. N    (Note that complete fontspecs are NOT built here because DVIReader does notE    want to know about the format or naming conventions of font files; D    the client module must handle all this in its PixelTableRoutine.)H    Since ProcessPostamble ended by reading the totalpages parameter, the5    next GetDVIByte should return nop or first fntdef.  *)  A VAR f, c, s, d, a, l : INTEGER;      (* hold fntdef parameters *) F     i : INTEGER;   ch : CHAR;        (* for getting farea and fname *)J     farea, fname : fontstring;       (* a and l bytes long respectively *)   BEGIN 7 totalfonts := 0;     (* number of nodes in font list *)  fontlist   := NIL; REPEAT    DVIcommand := GetDVIByte();@    IF (DVIcommand >= fntdef1) AND (DVIcommand <= fntdef1+3) THEN"       CASE DVIcommand - fntdef1 OF           0 : f := GetDVIByte() |$          1 : f := GetTwoDVIBytes() |&          2 : f := GetThreeDVIBytes() |!          3 : f := SignedDVIQuad()I
       END;7       c := SignedDVIQuad();   (* checksum; ignore it *)V/       s := SignedDVIQuad();   (* scaled size *)D/       d := SignedDVIQuad();   (* design size *) 7       a := GetDVIByte();      (* length of font area *)f7       l := GetDVIByte();      (* length of font name *)        farea := '';<       FOR i := 0 TO a-1 DO    (* read and store font area *)!          ch := CHR(GetDVIByte()); 4          IF i < maxfontspec THEN farea[i] := ch END;
       END;       fname := '';<       FOR i := 0 TO l-1 DO    (* read and store font name *)!          ch := CHR(GetDVIByte());t4          IF i < maxfontspec THEN fname[i] := ch END;
       END;       NEW(currfont);       WITH currfont^ DOf          fontused    := FALSE;          fontnum     := f;          scaledsize  := s;          designsize  := d;:          fontarea    := farea; fontarealen := CARDINAL(a);:          fontname    := fname; fontnamelen := CARDINAL(l);          fontspec    := '';SJ          fontspeclen := 0;        (* fontspec has to be built by client *)N          fontexists  := FALSE;    (* becomes TRUE if fontspec can be opened *)          totalchars  := 0;F          charlist    := NIL;      (* first node allocated in DoFont *)L          chartail    := NIL;      (* nodes are added to tail of char list *)K          pixelptr    := NIL;      (* allocated once per font; see DoFont *)M!          nextfont    := fontlist;e
       END;D       fontlist := currfont;       (* add new font to head of list *)       INC(totalfonts);    ELSIF DVIcommand = nop THEN7       (* nop commands can occur between DVI commands *) #    ELSIF DVIcommand = postpost THEN3,       (* we have reached end of postamble *)    ELSEd       (* DEBUG?          WriteString('Unexpected DVI command in postamble = ');l(          WriteCard(DVIcommand); WriteLn;          Halt(2);        GUBED *)&       DVIErrorRoutine(DVIcatastrophe);    END;V UNTIL DVIcommand = postpost; END ProcessFontDefs;    P (*******************************************************************************)    DECLARATIONS FOR GETTING TO A DVI PAGE   A    The user can select a particular page by specifying a DVI pageiD    number (from 1 to totalpages), or a TeX page number (based on theM    values of \count0,\count1,...,\count9), or simply requesting the next pagerF    in the DVI file (which depends on whether we are ascending or not).K    We will often need to follow the DVI backpointers to locate the bop byte     of a selected page. *)   VARgP    curreop,                     (* position of eop byte of current page       *)P    currbop,                     (* position of bop byte of current page       *)P    lastbop : CARDINAL;          (* position of last bop byte                  *)I    prevbop : INTEGER;           (* position of bop byte of previous page; P                                    note that prevbop of first page = -1       *)  P (******************************************************************************)  / PROCEDURE MoveToNextPage (ascending : BOOLEAN);   L (* Move to next DVI page; whether we can will depend on the current DVI page)    and if we are ascending or descending.L *)   BEGIN F IF (currDVIpage = 1) AND (NOT ascending) THEN         (* do nothing *)
    RETURN;F ELSIF (currDVIpage = totalpages) AND ascending THEN   (* do nothing *)
    RETURN;B ELSIF currDVIpage = 0 THEN   (* we haven't processed a page yet *)1    IF ascending THEN         (* get first page *)p       ReadFirstBop;s0    ELSE                      (* get last page *)       currbop := lastbop;W       DVIoffset := currbop + 1;         currDVIpage := totalpages;    END;o ELSE    IF ascending THENJ       (* currently positioned after eop of currDVIpage, so get next bop *)       ReadNextBop;    ELSEC;       (* move to bop pointed to by currbop's backpointer *)e       currbop := prevbop; G       DVIoffset := currbop + 1;   (* move to byte after previous bop *)        DEC(currDVIpage);C    END;} END;9 ReadBopParameters;   (* update currTeXpage and prevbop *)  END MoveToNextPage;   P (******************************************************************************)   PROCEDURE ReadFirstBop;   O (* Read first bop by skipping past preamble; update currbop and currDVIpage. *)    VAR k, i, dummy : CARDINAL;T   BEGIN D DVIoffset := 14;            (* position of preamble's k parameter *)7 k := GetDVIByte();          (* length of x parameter *)g FOR i := 1 TO k DO7    dummy := GetDVIByte();   (* skip preamble comment *); END;( REPEAT   (* skip any nops and fntdefs *)    DVIcommand := GetDVIByte();3    IF (DVIcommand = nop) OR (DVIcommand = bop) THENr       (* do nothing *)C    ELSIF (DVIcommand >= fntdef1) AND (DVIcommand <= fntdef1+3) THEN '       SkipFntdef(DVIcommand - fntdef1);o    ELSE        (* DEBUG          WriteLn;AC          WriteString('Unexpected DVI command before first bop = '); (          WriteCard(DVIcommand); WriteLn;          Halt(2);n       GUBED *)&       DVIErrorRoutine(DVIcatastrophe);    END;V UNTIL DVIcommand = bop;DC currbop := DVIoffset - 1;   (* position in DVI file of first bop *)N currDVIpage := 1;I END ReadFirstBop;R  P (******************************************************************************)  ( PROCEDURE SkipFntdef (which : CARDINAL);  9 (* Read past a fntdef command without interpreting it. *)    VAR dummy, a, l, i : CARDINAL;   BEGINU2 CASE which OF   (* which = DVIcommand - fntdef1 *)    0 : dummy := GetDVIByte() |"    1 : dummy := GetTwoDVIBytes() |$    2 : dummy := GetThreeDVIBytes() |    3 : dummy := SignedDVIQuad()  END; dummy := SignedDVIQuad();; dummy := SignedDVIQuad();o dummy := SignedDVIQuad();P3 a := GetDVIByte();        (* length of directory *)n3 l := GetDVIByte();        (* length of font name *)e FOR i := 0 TO l+a-1 DO    dummy := GetDVIByte();  END; END SkipFntdef;   P (******************************************************************************)   PROCEDURE ReadNextBop;  I (* We are currently positioned after an eop byte which we know is not the*G    last.  This routine positions us after the next bop byte and updatesr    currbop and currDVIpage.y *)   BEGINf( REPEAT   (* skip any nops and fntdefs *)    DVIcommand := GetDVIByte();3    IF (DVIcommand = nop) OR (DVIcommand = bop) THENl       (* do nothing *)C    ELSIF (DVIcommand >= fntdef1) AND (DVIcommand <= fntdef1+3) THEN)'       SkipFntdef(DVIcommand - fntdef1);R    ELSEs       (* DEBUG          WriteLn;;F          WriteString('Unexpected DVI command between eop and bop = ');(          WriteCard(DVIcommand); WriteLn;          Halt(2);d       GUBED *)&       DVIErrorRoutine(DVIcatastrophe);    END;  UNTIL DVIcommand = bop;=B currbop := DVIoffset - 1;   (* position in DVI file of this bop *) INC(currDVIpage);E END ReadNextBop;  P (******************************************************************************)   PROCEDURE ReadBopParameters;  E (* We should now be positioned after the bop of desired page, so read*:    the 10 TeX counters and update currTeXpage and prevbop.O    At the end of this routine we will be at the byte after currbop's parametersf    and ready to InterpretPage. *)   VAR i : CARDINAL;*   BEGIN* FOR i := 0 TO 9 DO%    currTeXpage[i] := SignedDVIQuad();* END;H prevbop := SignedDVIQuad();   (* position of previous bop in DVI file *) END ReadBopParameters;  P (******************************************************************************)  ' PROCEDURE MoveToDVIPage (n : CARDINAL);   9 (* Move to nth DVI page; n should be in 1..totalpages. *)-   BEGIN56 IF (n < 1) OR (n > totalpages) THEN   (* do nothing *)
    RETURN; END;
 IF n = 1 THEN*J    (* Note that this test must come before next ELSIF so that we avoid any1       problems when currDVIpage initially = 0. *)D    ReadFirstBop;L (* We have removed the ELSIF code because it assumes InterpretPage is calledM    after every MoveTo... routine (which PSDVI does NOT call when locating theI.    first and final pages of a given subrange). ELSIF n = currDVIpage + 1 THEN    ReadNextBop;* *) ELSE    IF n < currDVIpage THENN       currbop := prevbop;   (* start searching backwards from previous page *)       DEC(currDVIpage);     ELSIF n > currDVIpage THENCJ       currbop := lastbop;   (* start searching backwards from last page *)        currDVIpage := totalpages;    ELSE(>       (* n = currDVIpage so we'll just move back to currbop *)    END;*D    (* n is now <= currDVIpage so search by following backpointers *)    LOOPN       IF n = currDVIpage THEN*H          DVIoffset := currbop + 1;      (* move to byte after currbop *)          EXIT;
       ELSEM          DVIoffset := currbop + 41;     (* move to location of backpointer *)EK          currbop := SignedDVIQuad();    (* get location of previous page *)V          DEC(currDVIpage);
       END;    END;I END;9 ReadBopParameters;   (* update currTeXpage and prevbop *)a END MoveToDVIPage;  P (******************************************************************************)  A PROCEDURE MoveToTeXPage (VAR newTeXpage : TeXpageinfo)   (* in *) "                         : BOOLEAN;  - (* Return TRUE iff the given TeX page exists.*2    If so then we move to the lowest matching page. *)  , VAR savecurrbop, savecurrDVIpage : CARDINAL;     nextbop : INTEGER;     i : CARDINAL;v     atleastone : BOOLEAN;,   BEGINm- (* save away current page and DVI position *)i savecurrDVIpage := currDVIpage; G IF currDVIpage <> 0 THEN           (* only if we've processed a page *)     savecurrbop := currbop;9    (* note that curreop is saved in last InterpretPage *)t END;E (* search backwards through all DVI pages for lowest matching page *)D atleastone := FALSE; nextbop := lastbop;;! FOR i := totalpages TO 1 BY -1 DO     DVIoffset := nextbop + 1;G    ReadBopParameters;              (* update currTeXpage and prevbop *)a%    IF CurrMatchesNew(newTeXpage) THENk       currbop := nextbop;o       currDVIpage := i;i       atleastone := TRUE;k    END;     nextbop := prevbop; END;I IF NOT atleastone THEN             (* no match, so restore currDVIpage *) "    currDVIpage := savecurrDVIpage;J    IF currDVIpage <> 0 THEN        (* restore page and positioning info *)       currbop := savecurrbop;t       DVIoffset := currbop + 1;tH       ReadBopParameters;           (* restore currTeXpage and prevbop *)       DVIoffset := curreop + 1;rD       (* we should now be after the eop byte of the original page *)    END;I    RETURN FALSE;F ELSE                               (* we found lowest matching page *)    DVIoffset := currbop + 1; END;9 ReadBopParameters;   (* update currTeXpage and prevbop *)i RETURN TRUE; END MoveToTeXPage;  P (******************************************************************************)  B PROCEDURE CurrMatchesNew (VAR newTeXpage : TeXpageinfo) : BOOLEAN;  5 (* Return TRUE iff currTeXpage matches newTeXpage. *)c   VAR i : [0..9];r   BEGINx WITH newTeXpage DO    FOR i := 0 TO lastvalue DOg9       IF present[i] AND (value[i] <> currTeXpage[i]) THEN           RETURN FALSE;
       END;    END;* END; RETURN TRUE; END CurrMatchesNew;*    P (*******************************************************************************+    DECLARATIONS FOR INTERPRETING A DVI PAGEw  N    The commands between the bop and eop bytes for a particular page need to beO    translated (based on the method used by DVITYPE) before we can determine the L    the position and shape of all rules on that page, as well as the position4    of all characters and which fonts they belong to. *)   CONST P    (* Use symbolic names for the opcodes of DVI commands:                     *)P    setchar0 = 0;         (* setchar1..setchar127 = 1..127                     *)P    set1     = 128;       (* set2,set3,set4 = 129,130,131                      *)    setrule  = 132;P    put1     = 133;       (* put2,put3,put4 = 134,135,136                      *)    putrule  = 137;    nop      = 138;    bop      = 139;    eop      = 140;    push     = 141;    pop      = 142;L    right1   = 143;  w0 = 147;  x0 = 152;  down1 = 157;  y0 = 161;  z0 = 166;L    right2   = 144;  w1 = 148;  x1 = 153;  down2 = 158;  y1 = 162;  z1 = 167;L    right3   = 145;  w2 = 149;  x2 = 154;  down3 = 159;  y2 = 163;  z2 = 168;L    right4   = 146;  w3 = 150;  x3 = 155;  down4 = 160;  y3 = 164;  z3 = 169;L                     w4 = 151;  x4 = 156;                y4 = 165;  z4 = 170;P    fntnum0  = 171;       (* fntnum1..fntnum63 = 172..234                      *)P    fnt1     = 235;       (* fnt2,fnt3,fnt4 = 236,237,238                      *)P    xxx1     = 239;       (* xxx2,xxx3,xxx4 = 240,241,242                      *)P    fntdef1  = 243;       (* fntdef2,fntdef3,fntdef4 = 244,245,246             *)    pre      = 247;    post     = 248;    postpost = 249;&    (* undefined commands = 250..255 *)  P    maxint       = 2147483647;        (* SYSDEP: 2^31 - 1                      *)P    maxstacksize = 100;               (* maximum stack size for state values   *)P    maxdrift     = 2;                 (* prevent hh & vv from drifting too far *)   VAR P    DVIcommand : [0..255];            (* holds next DVI command                *)P    maxstack,                         (* max pushes over pops in DVI file      *)P    num,                              (* DVI numerator                         *)P    den : CARDINAL;                   (* DVI denominator                       *)P    conv : REAL;                      (* converts DVI units to pixels          *)P    h, v,                             (* current pos on page in DVI units      *)P    w, x,                             (* horizontal increments in DVI units    *)P    y, z,                             (* vertical increments in DVI units      *)P    hh, vv,                           (* h and v in pixels                     *)P    hhh, vvv : INTEGER;               (* h and v rounded to nearest pixel      *)P    hstack, vstack,                   (* push down stacks for state values     *)    wstack, xstack,    ystack, zstack,;    hhstack, vvstack : ARRAY [0..maxstacksize-1] OF INTEGER;lG    stackpos : [0..maxstacksize];     (* stacks empty when stackpos = 0, P                                         i.e., top of stacks = stackpos - 1    *)P    fontspace  : INTEGER;             (* used in DoRight and DoDown            *)P    thisrule   : ruleinfoptr;         (* temporary pointer to node in rulelist *)P    thischar   : charinfoptr;         (* temporary pointer to node in charlist *)  P (******************************************************************************)  E PROCEDURE SetConversionFactor (resolution, magnification : CARDINAL);o  P (* Client module must help calculate conv, the number of pixels per DVI unit. *)   BEGIN < conv := FLOAT(num)/254000.0 * FLOAT(resolution)/FLOAT(den) *'            FLOAT(magnification)/1000.0;  END SetConversionFactor;  P (******************************************************************************)   PROCEDURE InterpretPage;  I (* When this routine is called we are positioned after the bytes of a bopuJ    command (i.e., at currbop + 45).  At the end of this routine we will beK    positioned after the eop byte for the current page.  In between we carry*I    out the important task of translating the DVI description of this page D    and filling in the various data structures exported by DVIReader. *)   VAR param : INTEGER;   BEGIN  InitStateValues;	 InitPage;F REPEAT    DVIcommand := GetDVIByte();M    (* For efficiency reasons the most frequent commands should be tested 1st.aI       The following order is the result of frequency testing on "typical"(F       DVI files.  Note that the most frequent commands in the DVI file?       generated by TeX 1.3 for the Dec. 1983 LaTeX manual were: J       <set1, w0, right3, push/pop, x0, w3, y0, fntnum25, right2, fntnum31,F       down3, x2, right4, w2, x3, down4, z0, fntnum8, setrule, y3, etc.    *)NH    IF DVIcommand < set1       THEN DoSetChar(DVIcommand);   (* 0..127 *).    ELSIF DVIcommand = w0      THEN DoRight(w);<    ELSIF DVIcommand = right3  THEN DoRight(SignedDVITrio());*    ELSIF DVIcommand = push    THEN DoPush;)    ELSIF DVIcommand = pop     THEN DoPop; .    ELSIF DVIcommand = x0      THEN DoRight(x);D    ELSIF DVIcommand = w3      THEN w := SignedDVITrio(); DoRight(w);-    ELSIF DVIcommand = y0      THEN DoDown(y);*  L    ELSIF (DVIcommand > z4) AND (DVIcommand < fnt1)   (* fntnum0..fntnum63 *)@                               THEN DoFont(DVIcommand - fntnum0);  2    (* catch all the remaining movement commands *);    ELSIF (DVIcommand > pop) AND (DVIcommand < fntnum0) THEN ?       IF DVIcommand = right2     THEN DoRight(SignedDVIPair()); ?       ELSIF DVIcommand = right4  THEN DoRight(SignedDVIQuad());eG       ELSIF DVIcommand = x2      THEN x := SignedDVIPair(); DoRight(x);GG       ELSIF DVIcommand = x3      THEN x := SignedDVITrio(); DoRight(x); >       ELSIF DVIcommand = down3   THEN DoDown(SignedDVITrio());>       ELSIF DVIcommand = down4   THEN DoDown(SignedDVIQuad());G       ELSIF DVIcommand = w2      THEN w := SignedDVIPair(); DoRight(w);x0       ELSIF DVIcommand = z0      THEN DoDown(z);F       ELSIF DVIcommand = y3      THEN y := SignedDVITrio(); DoDown(y);F       ELSIF DVIcommand = z3      THEN z := SignedDVITrio(); DoDown(z);>       ELSIF DVIcommand = down2   THEN DoDown(SignedDVIPair());L       (* the next DVI commands are used very rarely (by TeX 1.3 at least) *)G       ELSIF DVIcommand = w1      THEN w := SignedDVIByte(); DoRight(w);nG       ELSIF DVIcommand = w4      THEN w := SignedDVIQuad(); DoRight(w);eG       ELSIF DVIcommand = x1      THEN x := SignedDVIByte(); DoRight(x); G       ELSIF DVIcommand = x4      THEN x := SignedDVIQuad(); DoRight(x);:F       ELSIF DVIcommand = y1      THEN y := SignedDVIByte(); DoDown(y);F       ELSIF DVIcommand = y2      THEN y := SignedDVIPair(); DoDown(y);F       ELSIF DVIcommand = y4      THEN y := SignedDVIQuad(); DoDown(y);F       ELSIF DVIcommand = z1      THEN z := SignedDVIByte(); DoDown(z);F       ELSIF DVIcommand = z2      THEN z := SignedDVIPair(); DoDown(z);F       ELSIF DVIcommand = z4      THEN z := SignedDVIQuad(); DoDown(z);?       ELSIF DVIcommand = right1  THEN DoRight(SignedDVIByte()); >       ELSIF DVIcommand = down1   THEN DoDown(SignedDVIByte());       ELSE  (* DEBUGG                (* will only occur if we've missed a movement command *)DO                WriteLn; WriteString('Bug in InterpretPage!'); WriteLn; Halt(2);=             GUBED *),             DVIErrorRoutine(DVIcatastrophe);
       END;  N    ELSIF DVIcommand = setrule THEN DoSetRule(SignedDVIQuad(),SignedDVIQuad());N    ELSIF DVIcommand = putrule THEN DoPutRule(SignedDVIQuad(),SignedDVIQuad());  =    ELSIF (DVIcommand >= put1) AND (DVIcommand <= put1+3) THENp       CASE DVIcommand - put1 OFd&          0 : DoPutChar(GetDVIByte()) |*          1 : DoPutChar(GetTwoDVIBytes()) |,          2 : DoPutChar(GetThreeDVIBytes()) |'          3 : DoPutChar(SignedDVIQuad())t
       END;  =    ELSIF (DVIcommand >= set1) AND (DVIcommand <= set1+3) THEN*       CASE DVIcommand - set1 OF*&          0 : DoSetChar(GetDVIByte()) |*          1 : DoSetChar(GetTwoDVIBytes()) |,          2 : DoSetChar(GetThreeDVIBytes()) |'          3 : DoSetChar(SignedDVIQuad())a
       END;  =    ELSIF (DVIcommand >= fnt1) AND (DVIcommand <= fnt1+3) THENa       CASE DVIcommand - fnt1 OFt#          0 : DoFont(GetDVIByte()) | '          1 : DoFont(GetTwoDVIBytes()) | )          2 : DoFont(GetThreeDVIBytes()) |I$          3 : DoFont(SignedDVIQuad())
       END;  =    ELSIF (DVIcommand >= xxx1) AND (DVIcommand <= xxx1+3) THEN        CASE DVIcommand - xxx1 OF*$          0 : param := GetDVIByte() |(          1 : param := GetTwoDVIBytes() |*          2 : param := GetThreeDVIBytes() |%          3 : param := SignedDVIQuad() 
       END;9       (* Pass current pixel position, number of bytes and;2          byte grabbing function for client to use.D          We use IgnoreSpecial if client does not assign a procedure.       *)0       SpecialRoutine(hh, vv, param, GetDVIByte);  E    (* skip fntdef command since we've got this info from postamble *)y>    ELSIF (DVIcommand >= fntdef1) AND (DVIcommand <= fntdef1+3)D                               THEN SkipFntdef(DVIcommand - fntdef1);  3    ELSIF DVIcommand = nop     THEN (* do nothing *)V3    ELSIF DVIcommand = eop     THEN (* do nothing *)c    ELSEw       (* DEBUG          WriteLn;EJ          WriteString('Unexpected DVI command while interpreting page = ');(          WriteCard(DVIcommand); WriteLn;          Halt(2);V       GUBED *)&       DVIErrorRoutine(DVIcatastrophe);    END;  UNTIL DVIcommand = eop; 8 (* save position of eop byte for use in MoveToTeXPage *) curreop := DVIoffset - 1;  IF stackpos <> 0 THENr    (* DEBUG*6       WriteString('Stack not empty at eop!'); WriteLn;       Halt(2);    GUBED *)E#    DVIErrorRoutine(DVIcatastrophe);: END;6 pageempty := (minhp = maxint) AND (minvp = maxint) ANDM              (maxhp = -maxint) AND (maxvp = -maxint);   (* InitPage values *)  END InterpretPage;  P (******************************************************************************)   PROCEDURE InitStateValues;  , (* Initialize the state values and stack. *)   BEGIN*? hh := hoffset;         (* 0 if no horizontal shift specified *) = vv := voffset;         (* 0 if no vertical shift specified *)  IF hoffset >= 0 THEN-    h :=   TRUNC(FLOAT(hoffset) / conv + 0.5);v ELSE2    h := - TRUNC(FLOAT(ABS(hoffset)) / conv + 0.5); END; IF voffset >= 0 THEN-    v :=   TRUNC(FLOAT(voffset) / conv + 0.5);t ELSE2    v := - TRUNC(FLOAT(ABS(voffset)) / conv + 0.5); END; w := 0; x := 0;a y := 0; z := 0;c stackpos  := 0;cH fontspace := 0;        (* for DoRight and DoDown before a DoFont call *) END InitStateValues;  P (******************************************************************************)   PROCEDURE InitPage;e  N (* Initialize page structures so there are no fonts, no chars and no rules. *)   BEGINaJ (* page edges will change if there is at least one char or rule on page *) minhp := maxint; minvp := maxint; maxhp := -maxint;u maxvp := -maxint;p currfont := fontlist;o WHILE currfont <> NIL DO    WITH currfont^ DOL       IF fontused THEN        (* only reset those fonts used in last page *)          fontused := FALSE;h          totalchars := 0; O          (* deallocate char list completely; DoFont will allocate first node *)r!          WHILE charlist <> NIL DO !             thischar := charlist;V+             charlist := thischar^.nextchar;t             DISPOSE(thischar);
          END;o          chartail := NIL;r,          (* pixel table remains allocated *)
       END;       currfont := nextfont;D    END;T END;N currfont   := NIL;            (* current font is undefined at start of page *) totalrules := 0;I (* deallocate rule information except for one node (for DoSet/PutRule) *)  WHILE rulelist <> ruletail DO;    thisrule := rulelist;"    rulelist := thisrule^.nextrule;    DISPOSE(thisrule);  END;9 rulelist^.rulecount := 0;     (* no rules in this node *)A rulelist^.nextrule  := NIL;T
 END InitPage;n  P (******************************************************************************)  $ PROCEDURE DoSetChar (ch : CARDINAL);  < (* Add char info to current chartable, update our horizontal1    position on the page and check the page edges.N *)   BEGIN* WITH currfont^ DO*    IF ch > maxTeXchar THEN"       DVIErrorRoutine(DVIbadchar);9       RETURN;                             (* ignore ch *)e    END;     WITH chartail^ DOH       IF charcount = chartablesize THEN   (* allocate a new chartable *)P          NEW(nextchar);                   (* add new node to end of char list *)?          nextchar^.charcount := 0;        (* reset charcount *)f$          nextchar^.nextchar  := NIL;          chartail := nextchar;
       END;    END;sD    WITH chartail^ DO                      (* may be new chartable *)"       WITH chartable[charcount] DO          hp := hh;          vp := vv;          code := ch;
       END;       WITH pixelptr^[ch] DO &          (* do page edges increase? *)6          IF vv - yo < minvp THEN minvp := vv - yo END;6          IF hh - xo < minhp THEN minhp := hh - xo END;L          IF vv + (ht - yo - 1) > maxvp THEN maxvp := vv + (ht - yo - 1) END;L          IF hh + (wd - xo - 1) > maxhp THEN maxhp := hh + (wd - xo - 1) END;E          (* the above checks ensure that page edges include all black2K             pixels in glyph, but we also want to include reference point *)3,          IF hh < minhp THEN minhp := hh END;,          IF vv < minvp THEN minvp := vv END;,          IF hh > maxhp THEN maxhp := hh END;,          IF vv > maxvp THEN maxvp := vv END;>          (* add pixel width calculated in PixelTableRoutine *)          hh := hh + pwidth; I          (* use hhh and maxdrift to prevent hh drifting too far from h *)2'          hhh := PixelRound(h + dwidth);4)          IF ABS(hhh - hh) > maxdrift THEN4             IF hhh > hh THEN$                hh := hhh - maxdrift;             ELSE$                hh := hhh + maxdrift;             END;
          END; <          (* add DVI width calculated in PixelTableRoutine *)          h := h + dwidth;a
       END;       INC(totalchars);       INC(charcount);;    END;  END; END DoSetChar;  P (******************************************************************************)  $ PROCEDURE DoPutChar (ch : CARDINAL);  D (* Exactly the same as DoSetChar, but we DON'T update the horizontal>    position on the page.  (We still have to check page edges.) *)   BEGIN  WITH currfont^ DOC    IF ch > maxTeXchar THEN"       DVIErrorRoutine(DVIbadchar);9       RETURN;                             (* ignore ch *)I    END;     WITH chartail^ DOH       IF charcount = chartablesize THEN   (* allocate a new chartable *)P          NEW(nextchar);                   (* add new node to end of char list *)?          nextchar^.charcount := 0;        (* reset charcount *) $          nextchar^.nextchar  := NIL;          chartail := nextchar;
       END;    END; D    WITH chartail^ DO                      (* may be new chartable *)"       WITH chartable[charcount] DO          hp := hh;          vp := vv;          code := ch;
       END;       WITH pixelptr^[ch] DOt&          (* do page edges increase? *)6          IF vv - yo < minvp THEN minvp := vv - yo END;6          IF hh - xo < minhp THEN minhp := hh - xo END;L          IF vv + (ht - yo - 1) > maxvp THEN maxvp := vv + (ht - yo - 1) END;L          IF hh + (wd - xo - 1) > maxhp THEN maxhp := hh + (wd - xo - 1) END;E          (* the above checks ensure that page edges include all blacklK             pixels in glyph, but we also want to include reference point *)c,          IF hh < minhp THEN minhp := hh END;,          IF vv < minvp THEN minvp := vv END;,          IF hh > maxhp THEN maxhp := hh END;,          IF vv > maxvp THEN maxvp := vv END;
       END;       INC(totalchars);       INC(charcount);     END;  END; END DoPutChar;  P (******************************************************************************)  4 PROCEDURE PixelRound (DVIunits : INTEGER) : INTEGER;  E (* Return the nearest number of pixels in the given DVI dimension. *)    BEGINP IF DVIunits > 0 THEN0    RETURN   TRUNC(conv * FLOAT(DVIunits) + 0.5); ELSE5    RETURN - TRUNC(conv * FLOAT(ABS(DVIunits)) + 0.5);f END; END PixelRound;e  P (******************************************************************************)   PROCEDURE DoPush;     (* Push state values onto stack.C    No need to test for stack overflow since we compare maxstack andb$    maxstacksize in ProcessPostamble. *)   BEGIN / hstack[stackpos] := h;   vstack[stackpos] := v;n/ wstack[stackpos] := w;   xstack[stackpos] := x;t/ ystack[stackpos] := y;   zstack[stackpos] := z; 1 hhstack[stackpos] := hh; vvstack[stackpos] := vv;y@ INC(stackpos);   (* stackpos = next vacant position in stacks *) END DoPush;i  P (******************************************************************************)   PROCEDURE DoPop;  ) (* Pop state values from top of stack. *)t   BEGIN  (* DEBUG    IF stackpos = 0 THEN4+       WriteString('Stack empty!'); WriteLn;I       Halt(2);    END;  GUBED *) DEC(stackpos);/ h := hstack[stackpos];   v := vstack[stackpos];H/ w := wstack[stackpos];   x := xstack[stackpos];N/ y := ystack[stackpos];   z := zstack[stackpos]; 1 hh := hhstack[stackpos]; vv := vvstack[stackpos]; 
 END DoPop;  P (******************************************************************************)  % PROCEDURE DoRight (amount : INTEGER);S  G (* Move the reference point horizontally by given amount (usually +ve).(4    When the amount is small, like a kern, hh changesO    by rounding the amount; but when the amount is large, hh changes by roundingeE    the true position h so that accumulated rounding errors disappear.n *)   BEGINT: IF (amount < fontspace) AND (amount > -4 * fontspace) THEN"    hh  := hh + PixelRound(amount);C    (* use hhh and maxdrift to prevent hh drifting too far from h *) !    hhh := PixelRound(h + amount);i#    IF ABS(hhh - hh) > maxdrift THEN        IF hhh > hh THEN          hh := hhh - maxdrift;
       ELSE          hh := hhh + maxdrift;
       END;    END;  ELSE     hh := PixelRound(h + amount); END; h := h + amount; END DoRight;  P (******************************************************************************)  $ PROCEDURE DoDown (amount : INTEGER);  E (* Move the reference point vertically by given amount (usually +ve). G    Rounding is done similarly to DoRight but with the threshold between26    small and large amounts increased by a factor of 5. *)   BEGINu# IF ABS(amount) < 5 * fontspace THEN !    vv := vv + PixelRound(amount); C    (* use vvv and maxdrift to prevent vv drifting too far from v *) !    vvv := PixelRound(v + amount);i#    IF ABS(vvv - vv) > maxdrift THEN        IF vvv > vv THEN          vv := vvv - maxdrift;
       ELSE          vv := vvv + maxdrift;
       END;    END;  ELSE     vv := PixelRound(v + amount); END; v := v + amount; END DoDown;L  P (******************************************************************************)  . PROCEDURE DoSetRule (height, width : INTEGER);  I (* Add rule information to current ruletable, update page edges, h and hh *    (but only if width and height are > 0). *)   BEGINo$ IF (height > 0) AND (width > 0) THEN    WITH ruletail^ DOH       IF rulecount = ruletablesize THEN   (* allocate a new ruletable *)P          NEW(nextrule);                   (* add new node to end of rule list *)?          nextrule^.rulecount := 0;        (* reset rulecount *)e$          nextrule^.nextrule  := NIL;          ruletail := nextrule;
       END;    END;tD    WITH ruletail^ DO                      (* may be new ruletable *)"       WITH ruletable[rulecount] DO          hp := hh;          vp := vv;!          wd := RulePixels(width);E"          ht := RulePixels(height);&          (* do page edges increase? *)B          IF vv - (ht - 1) < minvp THEN minvp := vv - (ht - 1) END;B          IF hh + (wd - 1) > maxhp THEN maxhp := hh + (wd - 1) END;8          (* ref pt of rule is bottom left black pixel *),          IF vv > maxvp THEN maxvp := vv END;,          IF hh < minhp THEN minhp := hh END;          hh := hh + wd;eI          (* use hhh and maxdrift to prevent hh drifting too far from h *) &          hhh := PixelRound(h + width);)          IF ABS(hhh - hh) > maxdrift THEN              IF hhh > hh THEN$                hh := hhh - maxdrift;             ELSE$                hh := hhh + maxdrift;             END;
          END;E          h := h + width;
       END;       INC(totalrules);       INC(rulecount);1    END;( END; END DoSetRule;  P (******************************************************************************)  . PROCEDURE DoPutRule (height, width : INTEGER);  D (* Exactly the same as DoSetRule, but we DON'T update the horizontal>    position on the page.  (We still have to check page edges.) *)   BEGIN2$ IF (height > 0) AND (width > 0) THEN    WITH ruletail^ DOH       IF rulecount = ruletablesize THEN   (* allocate a new ruletable *)P          NEW(nextrule);                   (* add new node to end of rule list *)?          nextrule^.rulecount := 0;        (* reset rulecount *) #          nextrule^.nextrule := NIL;I          ruletail := nextrule;
       END;    END;hD    WITH ruletail^ DO                      (* may be new ruletable *)"       WITH ruletable[rulecount] DO          hp := hh;          vp := vv;!          wd := RulePixels(width);n"          ht := RulePixels(height);&          (* do page edges increase? *)B          IF vv - (ht - 1) < minvp THEN minvp := vv - (ht - 1) END;B          IF hh + (wd - 1) > maxhp THEN maxhp := hh + (wd - 1) END;8          (* ref pt of rule is bottom left black pixel *),          IF vv > maxvp THEN maxvp := vv END;,          IF hh < minhp THEN minhp := hh END;
       END;       INC(totalrules);       INC(rulecount);)    END;  END; END DoPutRule;  P (******************************************************************************)  4 PROCEDURE RulePixels (DVIunits : INTEGER) : INTEGER;  E (* Return the number of pixels in the given height or width of a rulen+    using the method recommended in DVITYPE.a *)   VAR n : INTEGER;   BEGINu# n := TRUNC(conv * FLOAT(DVIunits));*I IF FLOAT(n) < conv * FLOAT(DVIunits) THEN RETURN n + 1 ELSE RETURN n END;  END RulePixels;t  P (******************************************************************************)  % PROCEDURE DoFont (externf : INTEGER);i  @ (* Search font list for externf, setting currfont and fontspace.H    If this is the first time we've seen this font (on current page) then+    we need to allocate the first chartable.oE    If this is the first time we've seen this font used at all then we/?    allocate a pixeltable and call client routine to fill it in.+ *)   BEGIN  currfont := fontlist;0= WHILE (currfont <> NIL) AND (currfont^.fontnum <> externf) DOi"    currfont := currfont^.nextfont; END; IF currfont = NIL THEN    (* DEBUG*G       WriteLn; WriteString('Failed to find font #'); WriteInt(externf);D       WriteLn; Halt(2);i    GUBED *)r#    DVIErrorRoutine(DVIcatastrophe);r END; WITH currfont^ DOI    IF fontused THENlF       (* do nothing since we've already used this font on this page *)    ELSE        fontused := TRUE;i=       NEW(charlist);           (* allocate first chartable *)t       WITH charlist^ DOo6          charcount := 0;       (* for DoSet/PutChar *);          nextchar  := NIL;     (* this node is also last *) 
       END;       chartail := charlist;lN       IF pixelptr = NIL THEN   (* first time we've seen this font requested *)          NEW(pixelptr); M          PixelTableRoutine;    (* call client routine to build pixel table *) 
       END;    END;s"    fontspace  := scaledsize DIV 6;'    (* See DVITYPE; a 3-unit thin space.e>       Note that a thin space is 1/6 of a quad, where a quad isB       1 em in the current font and usually equals the design size.    *)  END; END DoFont;o  P (******************************************************************************)  C PROCEDURE IgnoreSpecial(xpos, ypos,                        (* in *)lC                         specialbytes : INTEGER;            (* in *).C                         GetNextByte  : GetByteFunction);   (* in *)   P (* Default SpecialRoutine simply skips bytes given to TeX's \special command. *)   VAR i, unused : INTEGER;   BEGIN  FOR i := 1 TO specialbytes DO*    unused := GetNextByte();r END; END IgnoreSpecial;  P (******************************************************************************)  ? PROCEDURE SortFonts (VAR unusedlist : fontinfoptr);   (* out *);  2 (* Sort fontlist in order of ascending totalchars.:    Fonts with least characters can then be accessed first.L    Since the number of fonts used on a typical page is quite small, a simpleM    sorting algorithm should be good enough.  Note that unused fonts are movedaG    to the end of the list and unusedlist points to the first such node.: *)  > VAR newfontlist, prevfont, largest, prevlargest : fontinfoptr;     mostchars : CARDINAL;    BEGINm newfontlist  := NIL;L (* go thru fontlist once and move all unused fonts to head of newfontlist *) prevfont := NIL; currfont := fontlist;I WHILE currfont <> NIL DO    WITH currfont^ DO       IF fontused THEN@          prevfont := currfont;      (* remember previous node *)          currfont := nextfont;
       ELSE:          (* move node from fontlist to head of newfontlist%             and don't change prevfont)          *)           IF prevfont = NIL THEN G             fontlist := nextfont;   (* remove first node in fontlist *) $             nextfont := newfontlist;$             newfontlist := currfont;!             currfont := fontlist;=
          ELSE +             prevfont^.nextfont := nextfont; $             nextfont := newfontlist;$             newfontlist := currfont;+             currfont := prevfont^.nextfont;t
          END;e
       END;    END;h END;L (* unusedlist will be last unused font moved to newfontlist.  It will be NIL3    if either fontlist is NIL or all fonts are used.  *) unusedlist := newfontlist;E (* Now go thru fontlist repeatedly moving node with max totalchars tox3    head of newfontlist until fontlist is exhausted.m *) WHILE fontlist <> NIL DO    prevfont := NIL;     currfont := fontlist;    prevlargest := NIL;    largest     := fontlist;a    mostchars   := 0;A    WHILE currfont <> NIL DO   (* search for largest totalchars *)a       WITH currfont^ DO*'          IF totalchars > mostchars THEN*$             prevlargest := prevfont;$             largest     := currfont;&             mostchars   := totalchars;
          END;           prevfont := currfont;          currfont := nextfont;
       END;    END;r?    (* move largest node from fontlist to head of newfontlist *)b    WITH largest^ DON       IF prevlargest = NIL THENiD          fontlist := nextfont;   (* remove first node in fontlist *)
       ELSE+          prevlargest^.nextfont := nextfont; 
       END;       nextfont := newfontlist;       newfontlist := largest;     END;x END;N fontlist := newfontlist;   (* used fonts now sorted and unused fonts at end *) END SortFonts;  P (******************************************************************************)   PROCEDURE CloseDVIFile;)  O (* Close the currently open DVI file and deallocate dynamic data structures. *)    BEGIN=* status := SYS$DELTVA(ADR(vas),ADR(vas),0); IF NOT ODD(status) THENd    (* DEBUG C       WriteString('SYS$DELTVA failed! status='); WriteCard(status);I       WriteLn; Halt(2);n    GUBED *) #    DVIErrorRoutine(DVIcatastrophe);> END; status := SYS$DASSGN(channel); IF NOT ODD(status) THEN(    (* DEBUG>C       WriteString('SYS$DASSGN failed! status='); WriteCard(status);h       WriteLn; Halt(2);e    GUBED *) #    DVIErrorRoutine(DVIcatastrophe);b END; WHILE fontlist <> NIL DO    currfont := fontlist;    WITH currfont^ DO;       WHILE charlist <> NIL DO   (* deallocate char list *)           thischar := charlist;(          charlist := thischar^.nextchar;          DISPOSE(thischar); 
       END;       IF pixelptr <> NIL THEN =          DISPOSE(pixelptr);      (* deallocate pixel table *)*
       END;       fontlist := nextfont;*    END;)B    DISPOSE(currfont);            (* deallocate font information *) END;H (* Deallocate rule information except for one node (in case client opens    another DVI file).R *) WHILE rulelist <> ruletail DO0    thisrule := rulelist;"    rulelist := thisrule^.nextrule;    DISPOSE(thisrule);u END; END CloseDVIFile;*  P (******************************************************************************)   BEGINs totalrules := 0;; NEW(rulelist);                     (* for first InitPage *)a. ruletail := rulelist;              (* ditto *)? fontlist := NIL;                   (* safer for CloseDVIFile *)=< SpecialRoutine := IgnoreSpecial;   (* client can reassign *) END DVIReader.