! IMPLEMENTATION MODULE FontReader;   # (* Author:         Andrew Trevorrow I    Implementation: University of Hamburg Modula-2 under VAX/VMS version 4     Date Started:   May, 1985      Description: F    This module can extract font information from PXL, PK or TFM files.I    (GF files are not handled; it is assumed that sites with GF files will 7    decide to convert them to PK files sooner or later!) F    Each type of font file is considered to be an array of 8-bit bytes.K    Only one font file is open at any time.  We move to byte positions using F    byteoffset and read bytes and words using GetByte, SignedQuad, etc.      Revised: 
    June, 1985   - Use Halt(2) instead of HALT.       August, 1985 (  - Use ScreenIO routines when debugging.      September, 19858  - Added GetPXLGlyph and associated glyph cacheing code.      October, 1985>  - Removed above cacheing stuff!  Now use SYS$CRMPSC to map anP    entire PXL file into virtual memory where it is treated as an array of bytes.      March, 1986J  - Amendments to Modula-2 language required a few minor syntactic changes.      November, 1986 <  - PXLReader has been expanded and is now called FontReader.E    All font-dependent code has been moved out of PSDVI's main module. F    A new font format can be handled just by adding code to FontReader.N  - Reduced page fault cluster size from 36 to 16 because PK files are smaller.M  - Always start fontspec with fontdir; fontarea is really only for TFM files.       December, 1986 I  - GetBitmap now called LoadBitmap and uses Put routines from PSWriter to 7    send bitmap and metric info directly to output file.   0    November, 1987 (while at The Open University)F  - Added charsperline code to LoadBitmap routines so that output lines    don't get too long.J  - Added code to handle PostScript fonts (for which only TFM files exist).L    BuildFontSpec now checks for a fontname beginning with "PS-" and sets theE    font's psfont flag.  If TRUE then we must construct a TFM filespec G    (starting with tfmdir or fontarea if fontarealen > 0) and later fill @    the font's pixeltable with character info from that TFM file.'  - Renamed ConvertTFMWidth to FixToDVI. A  - PXL/PKFillPixelTable now call TFMFillPixelTable if the font is 8    a PostScript font (and its TFM file could be opened).  1    June--August, 1988 (while at Aston University) :  - Now use /psprefix value to check for a PostScript font.H  - Changed BuildFontSpec so that the fontsize substring no longer has to(    be the same length in all font files. *)   FROM SYSTEM IMPORT    ADDRESS, ADR, BYTE, WORD;   FROM VMS IMPORT 0    SYS$OPEN, SYS$CRMPSC, SYS$DASSGN, SYS$DELTVA;   FROM SECDefinitions IMPORT    SEC$V_EXPREG;   FROM RMS IMPORT     FAB, InitFab,    FOPset, FOPtype,     FACset, FACtype,     SHRset, SHRtype;    FROM FileSystem IMPORT    File, Open, Done, Close;    FROM Options IMPORT >    psprefix, tfmdir, fontdir, dummyfont, mag, resolution, Cap;   FROM DVIReader IMPORT     (* CONST *)    maxfontspec, maxTeXchar, 
    (* TYPE *) %    fontstring, fontinfo, fontinfoptr,     pixeltable, pixeltableptr,     (* VAR *)    currfont,    (* PROCEDURE *)    PixelRound;   FROM PSWriter IMPORT#    Put, PutString, PutInt, PutCard;    FROM TermOut IMPORT 3    WriteString, WriteCard, WriteInt, WriteLn, Halt;    CONST E    NULL = 0C;    (* SYSDEP: used to terminate a string if not full *) )    CR   = 15C;   (* used in LoadBitmap *)    TYPEC    (* font files should never have more than MAX(INTEGER) bytes! *) 1    fontfile    = ARRAY [0..MAX(INTEGER)] OF BYTE; P    filepointer = POINTER TO fontfile;                     (* never allocated! *)   VAR P    vas : ARRAY [0..1] OF ADDRESS;      (* start and end virtual addresses     *)P    filestart : filepointer;            (* pointer to starting address of file *)P    byteoffset,                         (* byte offset from start of file      *)P    channel : CARDINAL;                 (* fab.STV returned by SYS$OPEN        *)P    gsdnam : ARRAY [0..42] OF CHAR;     (* unused argument in SYS$CRPMSC       *)    status : CARDINAL; 
    fab : FAB; P    psprefixlen,                        (* length of psprefix string           *)P    fontdirlen,                         (* length of fontdir string            *)P    dummyfontlen : CARDINAL;            (* length of dummyfont string          *)P    formatstr : ARRAY [0..2] OF CHAR;   (* PXL or PK                           *)P    formatlen : CARDINAL;               (* 3   or 2                            *)P    xfactor : REAL;                     (* resolution/200 or resolution/1000   *)P    hexdigs : ARRAY [0..15] OF CHAR;    (* 0..9ABCDEF for LoadBitmap           *)P    gpower : ARRAY [0..8] OF BITSET;    (* 0,1,11,111,1111,...,11111111        *)P    CompleteFontSpec :                  (* used by BuildFontSpec               *)       PROCEDURE (fontinfoptr,                   CARDINAL,                  CARDINAL,)                  VAR CARDINAL) : BOOLEAN;   P (******************************************************************************)   PROCEDURE InitFontReader;   @ (* Assign font-dependent routines to various procedure variables=    according to information present in fontdir and dummyfont:   I    - The last character in dummyfont defines the font format (PXL or PK). 9      All font files are assumed to be in the same format. F      Note that the Options module has prefixed dummyfont with fontdir.  O    - The last two characters in fontdir define the structure of each file spec. K      If ".]" then all font files are assumed to reside in subdirectories of A      fontdir, and the name of each subdirectory is the font size. K      A typical dummyfont value would be TEX_DISK:[TEX.PXL.][1500]CMR10.PXL. H      This is the storage scheme used in K&S's old VMS TeX distributions.J      If not ".]" then all font files are assumed to be in kept in fontdir,4      and the font size is included in the file type.E      A typical dummyfont value would be TEX_DISK:[TEX.PK]CMR10.300PK. E      This type of scheme is used in the latest VMS TeX distributions.   B    - The dummyfont must contain a font size substring representingH      an unmagnified font.  Its value, along with /RESOLUTION, is used toD      decide how to calculate the font sizes in all other font files. *)   VAR     i, A    fontsizelen,                (* length of n...n in dummyfont *) @    dummyfontsize : CARDINAL;   (* value of n...n in dummyfont *)   BEGIN F hexdigs := "0123456789ABCDEF";                    (* for LoadBitmap *) dummyfontlen := LEN(dummyfont); N IF dummyfontlen = 0 THEN dummyfontlen := 1 END;   (* last char will be NULL *)P CASE Cap(dummyfont[dummyfontlen-1]) OF            (* last char defines format *)!    'L' : formatstr      := 'pxl';           formatlen      := 3; -          FillPixelTable := PXLFillPixelTable; )          LoadBitmap     := PXLLoadBitmap;    | 'K' : formatstr      := 'pk';          formatlen      := 2; ,          FillPixelTable := PKFillPixelTable;(          LoadBitmap     := PKLoadBitmap;          gpower[0] := {};           FOR i := 1 TO 8 DO L             gpower[i] := gpower[i-1] + {i-1};     (* used in PKLoadBitmap *)
          END;  ELSEH    WriteString('/DUMMY_FONT value should end with PXL or PK.'); WriteLn;    Halt(2);  END; psprefixlen := LEN(psprefix);  fontdirlen := LEN(fontdir); 9 IF (fontdirlen > 1) AND (fontdir[fontdirlen-2] = '.') AND :                         (fontdir[fontdirlen-1] = ']') THEN=    (* assume font files are kept in subdirectories of fontdir D       and have fontspecs like TEX_DISK:[TEX.subdir.][n...n]CMR10.fmt    *) #    CompleteFontSpec := OldFontSpec; =    i := fontdirlen + 1;               (* first n after .][ *)  ELSE/    (* assume font files are all kept in fontdir A       and have fontspecs like TEX_DISK:[TEX.subdir]CMR10.n...nfmt     *) #    CompleteFontSpec := NewFontSpec; >    i := fontdirlen;                   (* first char after ] *)8    WHILE (i < dummyfontlen) AND (dummyfont[i] <> '.') DO
       INC(i);     END; =    INC(i);                            (* first n after '.' *)  END; fontsizelen := 0;  dummyfontsize := 0; O WHILE (i < dummyfontlen) AND (dummyfont[i] >= '0') AND (dummyfont[i] <= '9') DO     INC(fontsizelen);H    dummyfontsize := dummyfontsize * 10 + (ORD(dummyfont[i]) - ORD('0'));
    INC(i); END; IF fontsizelen > 0 THEN L    (* The xfactor used to calculate fontsize in BuildFontSpec depends on the@       fontsize in dummyfont (assumed to be an unmagnified font).    *) 9    IF FLOAT(dummyfontsize) / FLOAT(resolution) > 1.0 THEN J       xfactor := FLOAT(resolution) / 200.0;    (* old naming convention *)    ELSE J       xfactor := FLOAT(resolution) / 1000.0;   (* new naming convention *)    END;  ELSEI    WriteString('/DUMMY_FONT value does not contain font size!'); WriteLn;     Halt(2);  END; END InitFontReader;   P (******************************************************************************)  N PROCEDURE BuildFontSpec (fontptr : fontinfoptr; VAR firstn, lastn : CARDINAL);   VAR     f : File;:    i, j, next, fontsize, tempsize, tempsizelen : CARDINAL;   BEGIN  WITH fontptr^ DOO    (* first check for a PostScript font; following code will set psfont to TRUE J       if psprefixlen = 0 --- ALL fonts will be considered PostScript fonts    *)     psfont := TRUE;
    i := 0;    LOOP '       IF i = psprefixlen THEN EXIT END; 2       IF Cap(fontname[i]) <> Cap(psprefix[i]) THEN          psfont := FALSE;           EXIT;
       END;
       INC(i);     END;     IF psfont THEN @       BuildTFMSpec(fontptr);           (* build TFM file spec *)
       RETURN;     END; 
    i := 0;    next := fontdirlen;	    REPEAT H       fontspec[i] := fontdir[i];       (* start fontspec with fontdir *)
       INC(i); )    UNTIL (i = next) OR (i > maxfontspec);     IF next >= maxfontspec THEN!       fontspeclen := maxfontspec; ?       RETURN;                          (* fontspec truncated *)     END; J    fontsize := TRUNC( FLOAT(mag) * (FLOAT(scaledsize) / FLOAT(designsize))3                                  * xfactor + 0.5 );     IF fontsize = 0 THEN D       INC(fontsize);                   (* allow for subtracting 1 *)    END;     tempsize := fontsize;
    i := 1;    LOOP 3       (* Complete rest of fontspec starting at next =          and return the position of first digit for fontsize. ?          We have to try fontsize +/- 1 before giving up because G          rounding problems can occur in the above fontsize calculation.        *)       j := tempsize;       tempsizelen := 0;        WHILE j > 0 DO          INC(tempsizelen);          j := j DIV 10; 
       END;F       IF NOT CompleteFontSpec(fontptr, next, tempsizelen, firstn) THEN?          RETURN;                       (* fontspec truncated *) 
       END;(       lastn := firstn + tempsizelen - 1;5       (* put tempsize into fontspec[firstn..lastn] *) '       FOR j := lastn TO firstn BY -1 DO :          fontspec[j] := CHR(ORD('0') + (tempsize MOD 10));%          tempsize := tempsize DIV 10; 
       END;P       IF i > 3 THEN                    (* original fontsize has been restored *)D          RETURN;                       (* could not open fontspec *)
       END;L       Open(f,fontspec,FALSE);          (* SYSDEP: try to open for reading *)       IF Done() THEN          Close(f);<          fontexists := TRUE;           (* fontspec exists *)          RETURN;       ELSIF i = 1 THEN=          tempsize := fontsize - 1;     (* try fontsize - 1 *)        ELSIF i = 2 THEN=          tempsize := fontsize + 1;     (* try fontsize + 1 *) 
       ELSEF          tempsize := fontsize;         (* restore original fontsize *)
       END;
       INC(i);     END;  END; END BuildFontSpec;  P (******************************************************************************)  / PROCEDURE BuildTFMSpec (fontptr : fontinfoptr);   @ (* Build a complete TFM file specification in fontptr^.fontspec.I    This will only be done once per font; fontspeclen will no longer be 0. >    fontptr^.fontexists becomes TRUE if the file can be opened. *)  # VAR f : File;   i, next : CARDINAL;    BEGIN  WITH fontptr^ DO
    i := 0;    IF fontarealen > 0 THEN       next := fontarealen;       REPEATI          fontspec[i] := fontarea[i];   (* start fontspec with fontarea *)           INC(i);,       UNTIL (i = next) OR (i > maxfontspec);    ELSE 7       next := LEN(tfmdir);             (* assume > 0 *)i       REPEATG          fontspec[i] := tfmdir[i];     (* start fontspec with tfmdir *)h          INC(i);,       UNTIL (i = next) OR (i > maxfontspec);    END;t    IF next >= maxfontspec THEN!       fontspeclen := maxfontspec;c?       RETURN;                          (* fontspec truncated *)s    END;a@    (* next is current length of fontspec; append fontname.tfm *)
    i := 0;6    WHILE (i < fontnamelen) AND (next < maxfontspec) DO<       fontspec[next] := fontname[i];   (* append fontname *)
       INC(i);r       INC(next);    END;n8    IF next + 4 <= maxfontspec THEN     (* append .tfm *)'       fontspec[next] := '.'; INC(next);9'       fontspec[next] := 't'; INC(next); '       fontspec[next] := 'f'; INC(next);i'       fontspec[next] := 'm'; INC(next);d    ELSEr!       fontspeclen := maxfontspec;A?       RETURN;                          (* fontspec truncated *)n    END;     fontspeclen := next;e-    (* SYSDEP: terminate fontspec with NULL *)aG    IF fontspeclen < maxfontspec THEN fontspec[fontspeclen] := NULL END;eL    Open(f,fontspec,FALSE);             (* SYSDEP: try to open for reading *)    IF Done() THEN        Close(f); <       fontexists := TRUE;              (* fontspec exists *)    END;o END; END BuildTFMSpec;   P (******************************************************************************)  - PROCEDURE OldFontSpec (fontptr : fontinfoptr;p'                        next : CARDINAL; .                        fontsizelen : CARDINAL;8                        VAR firstn : CARDINAL) : BOOLEAN;  B (* Return TRUE if we can append "[n...n]fontname.fmt" to fontspec.K    Such a scheme is used in old TeX distributions from Kellerman and Smith.  *)   VAR i : CARDINAL;w   BEGIN  WITH fontptr^ DOI    firstn := next + 1;                            (* position of 1st n *)rF    IF next + fontsizelen + 1 < maxfontspec THEN   (* append [n...n] *)       fontspec[next] := '[';B       INC(next,fontsizelen + 1);                  (* skip n...n *)       fontspec[next] := ']';       INC(next);    ELSE !       fontspeclen := maxfontspec;(J       RETURN FALSE;                               (* fontspec truncated *)    END;y
    i := 0;6    WHILE (i < fontnamelen) AND (next < maxfontspec) DOG       fontspec[next] := fontname[i];              (* append fontname *)b
       INC(i);t       INC(next);    END; C    IF next + formatlen < maxfontspec THEN         (* append .fmt *) '       fontspec[next] := '.'; INC(next);D
       i := 0;S       REPEAT(          fontspec[next] := formatstr[i];          INC(i);          INC(next);e       UNTIL i = formatlen;    ELSES!       fontspeclen := maxfontspec; J       RETURN FALSE;                               (* fontspec truncated *)    END;u    fontspeclen := next; -    (* SYSDEP: terminate fontspec with NULL *) G    IF fontspeclen < maxfontspec THEN fontspec[fontspeclen] := NULL END;n    RETURN TRUE;x END; END OldFontSpec;  P (******************************************************************************)  - PROCEDURE NewFontSpec (fontptr : fontinfoptr;M'                        next : CARDINAL;r.                        fontsizelen : CARDINAL;8                        VAR firstn : CARDINAL) : BOOLEAN;  @ (* Return TRUE if we can append "fontname.n...nfmt" to fontspec.9    Such a scheme is used in the latest TeX distributions.  *)   VAR i : CARDINAL;.   BEGING WITH fontptr^ DO
    i := 0;6    WHILE (i < fontnamelen) AND (next < maxfontspec) DOM       fontspec[next] := fontname[i];                    (* append fontname *)t
       INC(i);        INC(next);    END;iO    firstn := next + 1;                                  (* position of 1st n *) N    IF next + fontsizelen + formatlen < maxfontspec THEN (* append .n...nfmt *)       fontspec[next] := '.';H       INC(next,fontsizelen + 1);                        (* skip n...n *)
       i := 0;        REPEAT(          fontspec[next] := formatstr[i];          INC(i);          INC(next);        UNTIL i = formatlen;    ELSE !       fontspeclen := maxfontspec; P       RETURN FALSE;                                     (* fontspec truncated *)    END;     fontspeclen := next;n-    (* SYSDEP: terminate fontspec with NULL *)2G    IF fontspeclen < maxfontspec THEN fontspec[fontspeclen] := NULL END;R    RETURN TRUE;  END; END NewFontSpec;  P (******************************************************************************)  = PROCEDURE OpenFontFile (VAR fspec : ARRAY OF CHAR) : BOOLEAN;9  N (* Return TRUE iff given file can be opened and mapped into virtual memory. *)   BEGIN19 InitFab(fab);                        (* initialize fab *)  WITH fab DOb=    FNA := ADR(fspec);                (* file specification *) =    FNS := BYTE(LEN(fspec));          (* bytes in file name *) 4    FAC := FACset{FAC$BRO,FAC$GET};   (* read-only *)H    SHR := SHRset{SHR$GET};           (* share file with other readers *)>    FOP := FOPset{FOP$UFO};           (* need for SYS$CRMPSC *)E    RTV := BYTE(-1);                  (* for more efficient mapping *)d END;8 status := SYS$OPEN(ADR(fab),0,0);    (* open the file *) IF ODD(status) THENXH    channel := fab.STV;               (* channel on which file is open *)    vas[0] := 0;O    vas[1] := 0; N    status := SYS$CRMPSC              (* map file into virtual address space *)H                  (ADR(vas),          (* starting and ending addresses *)=                   ADR(vas),          (* addresses returned *)                    0,P                   {SEC$V_EXPREG},    (* pages mapped into 1st available space *)                   gsdnam,0,0,sP                   channel,           (* channel on which file has been opened *)                   0,0,0,B                   16                 (* page fault cluster size *)                  );A    IF NOT ODD(status) THEN       (* DEBUGC          WriteString('SYS$CRMPSC failed in OpenFontFile! status=');V-          WriteCard(status); WriteLn; Halt(2);s       GUBED *)       RETURN FALSE;s    ELSE @       (* The entire file is mapped into virtual memory so we canA          access any byte as an offset from the address in vas[0].        *)       filestart := vas[0];       RETURN TRUE;    END;h ELSE    RETURN FALSE; END; END OpenFontFile;R  P (******************************************************************************)  > (* Here are the functions used to get byte/s from fontfile. *)    PROCEDURE GetByte () : CARDINAL;  H (* Return the value (unsigned) of the byte at byteoffset in fontfile and+    advance byteoffset for the next GetByte.n *)   VAR b : CARDINAL;r   BEGIN 9 b := CARDINAL(filestart^[byteoffset]);   INC(byteoffset);P	 RETURN b;= END GetByte;  P (******************************************************************************)  " PROCEDURE SignedByte () : INTEGER;  , (* Return the next byte, possibly signed. *)   VAR b : CARDINAL;P   BEGINa9 b := CARDINAL(filestart^[byteoffset]);   INC(byteoffset);  IF b < 128 THENw    RETURN b; ELSE    RETURN b - 256; END; END SignedByte;   P (******************************************************************************)  $ PROCEDURE GetTwoBytes () : CARDINAL;  ( (* Return the next 2 bytes, unsigned. *)   VAR a, b : CARDINAL;   BEGINf9 a := CARDINAL(filestart^[byteoffset]);   INC(byteoffset);f9 b := CARDINAL(filestart^[byteoffset]);   INC(byteoffset);r RETURN a * 256 + b;i END GetTwoBytes;  P (******************************************************************************)  " PROCEDURE SignedPair () : INTEGER;  / (* Return the next 2 bytes, possibly signed. *)*   VAR a, b : CARDINAL;   BEGIN 9 a := CARDINAL(filestart^[byteoffset]);   INC(byteoffset);_9 b := CARDINAL(filestart^[byteoffset]);   INC(byteoffset);e IF a < 128 THEN     RETURN a * 256 + b; ELSE    RETURN (a - 256) * 256 + b; END; END SignedPair;f  P (******************************************************************************)  & PROCEDURE GetThreeBytes () : CARDINAL;  ( (* Return the next 3 bytes, unsigned. *)   VAR a, b, c : CARDINAL;e   BEGINu9 a := CARDINAL(filestart^[byteoffset]);   INC(byteoffset);n9 b := CARDINAL(filestart^[byteoffset]);   INC(byteoffset);u9 c := CARDINAL(filestart^[byteoffset]);   INC(byteoffset);> RETURN (a * 256 + b) * 256 + c;t END GetThreeBytes;  P (******************************************************************************)  " PROCEDURE SignedQuad () : INTEGER;  F (* Return the value (possibly signed) of the 4 bytes at byteoffset and    advance byteoffset by 4.i *)   VAR overlay : RECORD!                  CASE :BOOLEAN OF/)                     TRUE  : i : INTEGER |E*                     FALSE : a,b,c,d : BYTE                  END;                END;   BEGIN) WITH overlay DOt@    (* SYSDEP: on a VAX, d is at least significant end of word *)2    d := filestart^[byteoffset];   INC(byteoffset);2    c := filestart^[byteoffset];   INC(byteoffset);2    b := filestart^[byteoffset];   INC(byteoffset);2    a := filestart^[byteoffset];   INC(byteoffset);    RETURN i; END; END SignedQuad;   P (******************************************************************************)   PROCEDURE CloseFontFile;  ) (* Close the currently open font file. *)T   BEGINi* status := SYS$DELTVA(ADR(vas),ADR(vas),0); IF NOT ODD(status) THENC    (* DEBUG]A       WriteString('SYS$DELTVA failed in CloseFontFile! status=');I*       WriteCard(status); WriteLn; Halt(2);    GUBED *)E END; status := SYS$DASSGN(channel); IF NOT ODD(status) THENe    (* DEBUGEA       WriteString('SYS$DASSGN failed in CloseFontFile! status='); *       WriteCard(status); WriteLn; Halt(2);    GUBED *)t END; END CloseFontFile;  P (******************************************************************************)P (* Here are the routines for reading PXL files:                               *)P (******************************************************************************)   PROCEDURE PXLFillPixelTable;  B (* Fill the pixeltable for currfont^ using the font directory info"    in the currently open PXL file. *)  ? VAR i, b0, b1, b2, b3 : CARDINAL;    (* 4 bytes in TFM width *)i   BEGIN  WITH currfont^ DOm     IF psfont AND fontexists THENC       TFMFillPixelTable;                 (* use TFM file instead *) 
       RETURN;a    END; F    (* to find font directory we first move to last byte in PXL file *)@    byteoffset := CARDINAL(ADDRESS(vas[1]) - ADDRESS(filestart));#    (* skip back over any 0 bytes *) G    WHILE (byteoffset > 0) AND (CARDINAL(filestart^[byteoffset]) = 0) DO        DEC(byteoffset);    END;F4    (* move to byte at start of last non-zero word *)!    WHILE byteoffset MOD 4 <> 0 DO(       DEC(byteoffset);    END;N    IF SignedQuad() <> 1001 THENi       WriteLn;4       WriteString('Bad PXL file! id word <> 1001.');       WriteLn; Halt(2);s    END;DK    DEC(byteoffset,4);                    (* SignedQuad will have added 4 *)sN    DEC(byteoffset,516 * 4);              (* starting byte of font directory *)     FOR i := 128 TO maxTeXchar DOL       pixelptr^[i].mapadr := 0;          (* PXL files only have 128 chars *)#       pixelptr^[i].loaded := FALSE;)    END;     FOR i := 0 TO 127 DOo       WITH pixelptr^[i] DO!          wd     := GetTwoBytes(); !          ht     := GetTwoBytes();o           xo     := SignedPair();           yo     := SignedPair();H          loaded := FALSE;                (* bitmap not yet downloaded *)F          mapadr := SignedQuad();         (* word offset in PXL file *)%          IF (wd = 0) OR (ht = 0) THEN;L             mapadr := 0;                 (* in case PXL file is incorrect *)
          END;lA          b0     := GetByte();            (* should be 0 or 255 *)*          b1     := GetByte();R          b2     := GetByte();           b3     := GetByte();m)          dwidth := FixToDVI(b0,b1,b2,b3);nJ          pwidth := PixelRound(dwidth);   (* convert DVI units to pixels *)
       END;    END;o END; END PXLFillPixelTable;  P (******************************************************************************)  9 PROCEDURE FixToDVI (b0, b1, b2, b3 : CARDINAL) : INTEGER;   @ (* Convert the given fixword (made up of 4 bytes) into DVI units+    using the method recommended in DVITYPE.I *)  - VAR alpha, beta : CARDINAL;   temp : INTEGER;    BEGIN  WITH currfont^ DOf    alpha := 16 * scaledsize;    beta  := 16;E0    WHILE scaledsize >= 40000000B DO   (* 2^23 *)%       scaledsize := scaledsize DIV 2;C       beta := beta DIV 2;)    END;m,    temp := (((((b3 * scaledsize) DIV 400B) +1                    (b2 * scaledsize)) DIV 400B) + 3                        (b1 * scaledsize)) DIV beta;d    IF b0 > 0 THEN(       IF b0 = 255 THEN&          RETURN temp - INTEGER(alpha);
       ELSE          WriteLn;e>          WriteString('Bad fixword! 1st byte='); WriteCard(b0);          WriteLn; Halt(2);
       END;    ELSE        RETURN temp;    END;I END;
 END FixToDVI;s  P (******************************************************************************)  A PROCEDURE PXLLoadBitmap (fontptr : fontinfoptr; code : CARDINAL);)  > (* Download bitmap using raster information starting at mapadr    in currently open PXL file. *)  E VAR b, r, thisbyte, bytesperrow, usedperrow, charsperline : CARDINAL;s   BEGIN   WITH fontptr^.pixelptr^[code] DOB bytesperrow := ((wd + 31) DIV 32) * 4;     (* words per row * 4 *)N usedperrow := (wd + 7) DIV 8;              (* not all bytes might be needed *) charsperline := 0; PutString('[<');L (* output (ht * usedperrow * 2) hex digits, starting at top row of bitmap *)E byteoffset := mapadr * 4;                  (* mapadr = word offset *)*G b := 0;                                    (* byte count for one row *)F: r := 0;                                    (* row count *) LOOP    INC(charsperline,2);     IF charsperline >= 72 THEN        Put(CR);       charsperline := 0;    END;LI    thisbyte := GetByte();                  (* and increment byteoffset *) #    Put(hexdigs[ thisbyte DIV 16 ]);i#    Put(hexdigs[ thisbyte MOD 16 ]); 
    INC(b);    IF b = usedperrow THENI
       INC(r); (       IF r = CARDINAL(ht) THEN EXIT END;J       INC(byteoffset,bytesperrow - b);     (* move to start of next row *)A       b := 0;                              (* reset byte count *)N    END;n END; Put('>'); Put(CR);" PutCard(usedperrow * 8); Put(' '); PutInt(ht); Put(' ');  PutInt(xo); Put(' '); N PutInt(yo); Put(' ');                      (* offset of origin from top row *) PutInt(pwidth);r PutString('] '); PutCard(code); PutString(' dc'); Put(CR); END; (* WITH *)t END PXLLoadBitmap;  P (******************************************************************************)P (* Here are the routines for reading PK files:                                *)P (******************************************************************************)   PROCEDURE PKFillPixelTable;r  B (* Fill the pixeltable for currfont^ using the font directory info!    in the currently open PK file.e *)   CONSTp    pkid   =  89;    pkpost = 245;    pknoop = 246;    pkpre  = 247;   VAR)    i, j, flagbyte, flagpos, :    chcode,                      (* assumed to be <= 255 *)    packetlen, endofpacket,:    b0, b1, b2, b3 : CARDINAL;   (* 4 bytes in TFM width *)   BEGIN  WITH currfont^ DO*     IF psfont AND fontexists THENE       TFMFillPixelTable;                   (* use TFM file instead *)n
       RETURN;p    END; C    byteoffset := 0;                        (* move to first byte *)l    IF GetByte() <> pkpre THEN        WriteLn;)       WriteString('Bad pre command in ');i.       WriteString(fontspec); WriteLn; Halt(2);    END;     IF GetByte() <> pkid THEN       WriteLn;%       WriteString('Bad id byte in ');G.       WriteString(fontspec); WriteLn; Halt(2);    END;)B    j := GetByte();                         (* length of comment *)F    INC(byteoffset,j + 16);                 (* skip rest of preamble *)    FOR i := 0 TO maxTeXchar DO       WITH pixelptr^[i] DOK          mapadr := 0;                      (* all chars absent initially *)xJ          loaded := FALSE;                  (* bitmap not yet downloaded *)
       END;    END;1    LOOP N       flagpos  := byteoffset;              (* remember position of flagbyte *)       flagbyte := GetByte();J       IF flagbyte < 240 THEN               (* read character definition *)G          flagbyte := flagbyte MOD 8;       (* value of bottom 3 bits *) D          IF flagbyte < 4 THEN              (* short char preamble *)4             packetlen := flagbyte * 256 + GetByte();#             chcode    := GetByte();N2             endofpacket := packetlen + byteoffset;%             WITH pixelptr^[chcode] DO*#                b1     := GetByte();*#                b2     := GetByte();R#                b3     := GetByte();A=                dwidth := FixToDVI(0,b1,b2,b3);   (* b0 = 0 *)o#                pwidth := GetByte(); #                wd     := GetByte(); #                ht     := GetByte();I&                xo     := SignedByte();&                yo     := SignedByte();             END;M          ELSIF flagbyte < 7 THEN           (* extended short char preamble *)(@             packetlen := (flagbyte - 4) * 65536 + GetTwoBytes();#             chcode    := GetByte();s2             endofpacket := packetlen + byteoffset;%             WITH pixelptr^[chcode] DOo#                b1     := GetByte();t#                b2     := GetByte(); #                b3     := GetByte();X=                dwidth := FixToDVI(0,b1,b2,b3);   (* b0 = 0 *) '                pwidth := GetTwoBytes();='                wd     := GetTwoBytes(); '                ht     := GetTwoBytes();)&                xo     := SignedPair();&                yo     := SignedPair();             END;C          ELSE                              (* long char preamble *) &             packetlen := SignedQuad();&             chcode    := SignedQuad();2             endofpacket := packetlen + byteoffset;%             WITH pixelptr^[chcode] DOa#                b0     := GetByte();,#                b1     := GetByte(); #                b2     := GetByte(); #                b3     := GetByte();t/                dwidth := FixToDVI(b0,b1,b2,b3);YE                pwidth := SignedQuad() DIV 65536;   (* dx in pixels *))@                INC(byteoffset,4);                  (* skip dy *)&                wd     := SignedQuad();&                ht     := SignedQuad();&                xo     := SignedQuad();&                yo     := SignedQuad();             END;
          END;;"          WITH pixelptr^[chcode] DO(             IF (wd = 0) OR (ht = 0) THEN:                mapadr := 0;                (* no bitmap *)             ELSEE                mapadr := flagpos;          (* position of flagbyte *)B             END;
          END;hA          byteoffset := endofpacket;        (* skip raster info *)v
       ELSE          CASE flagbyte OF              240..243 : i := 0;P                        FOR j := 240 TO flagbyte DO i := 256 * i + GetByte() END;G                        INC(byteoffset,i);  (* skip special parameter *)*J           | 244      : INC(byteoffset,4);  (* skip numspecial parameter *);           | pknoop   :                     (* do nothing *) N           | pkpost   : EXIT;               (* no more character definitions *)
          ELSE              WriteLn;-             WriteString('Bad flag byte in ');*4             WriteString(fontspec); WriteLn; Halt(2);
          END; 
       END;%    END; (* LOOP; flagbyte = pkpost *)b END; END PKFillPixelTable;b  P (******************************************************************************)  @ (* Routines to unpack raster info need some global variables: *)   VAR+6    turnon : BOOLEAN;       (* is current run black? *)9    dynf,                   (* dynamic packing variable *)DF    repeatcount,            (* how many times to repeat the next row *)7    inputbyte,              (* the current input byte *)(K    bitweight : CARDINAL;   (* for getting bits or nybbles from inputbyte *)f  P (******************************************************************************)  @ PROCEDURE PKLoadBitmap (fontptr : fontinfoptr; code : CARDINAL);  H (* Download bitmap using information from character definition at mapadr    in currently open PK file.  *)  ( VAR i, j, flagbyte, bitpos, bytesperrow,7     rowsleft, hbit, count, rp, charsperline : CARDINAL;b     byte : BITSET;P     row : ARRAY [0..400] OF BYTE;      (* SYSDEP: max glyph width = 3200 bits *)   BEGINe  WITH fontptr^.pixelptr^[code] DO= bytesperrow := (wd + 7) DIV 8;         (* bytes in one row *) P byteoffset := mapadr;                  (* mapadr = flagbyte offset in PK file *)9 flagbyte := GetByte();                 (* assume < 240 *)  dynf := flagbyte DIV 16;@ turnon := (flagbyte MOD 16) >= 8;      (* is 1st pixel black? *)C flagbyte := flagbyte MOD 8;            (* value of bottom 3 bits *) E IF flagbyte < 4 THEN                   (* skip short char preamble *)     INC(byteoffset,10);N ELSIF flagbyte < 7 THEN                (* skip extended short char preamble *)    INC(byteoffset,16);D ELSE                                   (* skip long char preamble *)    INC(byteoffset,36); END; charsperline := 0;@ PutString('[<');                       (* start of hex string *)A bitweight := 0;                        (* to get 1st inputbyte *)  IF dynf = 14 THEN*N    (* raster info is a string of bits in the next (wd * ht + 7) DIV 8 bytes *)     FOR i := 1 TO CARDINAL(ht) DOL       byte := {};                                    (* set all bits to 0 *)G       bitpos := 7;                                   (* leftmost bit *)a#       FOR j := 1 TO CARDINAL(wd) DO           IF bitweight = 0 THEN<             (* next 2 lines equal inputbyte := GetByte(); *):             inputbyte := CARDINAL(filestart^[byteoffset]);             INC(byteoffset);             bitweight := 8;C
          END;i?          DEC(bitweight);                             (* 7..0 *)*/          IF bitweight IN BITSET(inputbyte) THEN*B             INCL(byte,bitpos);                       (* set bit *)
          END;           IF bitpos > 0 THEN*C             DEC(bitpos);                             (* next bit *)*
          ELSE               INC(charsperline,2);&             IF charsperline >= 72 THEN                Put(CR); !                charsperline := 0;              END;F             Put(hexdigs[ CARDINAL(byte) DIV 16 ]);   (* high nybble *)E             Put(hexdigs[ CARDINAL(byte) MOD 16 ]);   (* low nybble *)              byte := {};e             bitpos := 7;
          END;o
       END;       IF bitpos < 7 THEN          INC(charsperline,2);t#          IF charsperline >= 72 THEN              Put(CR);             charsperline := 0;
          END;(/          Put(hexdigs[ CARDINAL(byte) DIV 16 ]);e/          Put(hexdigs[ CARDINAL(byte) MOD 16 ]); 
       END;    END;t ELSE8    (* raster info is encoded as run and repeat counts *)    rowsleft := ht;    hbit := wd;    repeatcount := 0;    rp := 1;     bitpos := 8;     byte := {};    WHILE rowsleft > 0 DO       count := PackedNum();)       WHILE count > 0 DO4          IF (count < bitpos) AND (count < hbit) THEN             IF turnon THENF                byte := byte + gpower[bitpos] - gpower[bitpos - count];             END;             DEC(hbit,count);             DEC(bitpos,count);             count := 0; 8          ELSIF (count >= hbit) AND (hbit <= bitpos) THEN             IF turnon THENE                byte := byte + gpower[bitpos] - gpower[bitpos - hbit];t             END;"             row[rp] := BYTE(byte);D             (* end of current row, so send it repeatcount+1 times *)(             FOR i := 0 TO repeatcount DO+                FOR j := 1 TO bytesperrow DO &                   INC(charsperline,2);,                   IF charsperline >= 72 THEN                      Put(CR);i'                      charsperline := 0;b                   END;:                   Put(hexdigs[ CARDINAL(row[j]) DIV 16 ]);:                   Put(hexdigs[ CARDINAL(row[j]) MOD 16 ]);                END;i             END;*             DEC(rowsleft,repeatcount + 1);             repeatcount := 0;              rp := 1;             byte := {};X             bitpos := 8;             DEC(count,hbit);             hbit := wd;*
          ELSE*=             IF turnon THEN byte := byte + gpower[bitpos] END; "             row[rp] := BYTE(byte);J             INC(rp);                   (* we assume rp never overflows! *)             byte := {};              DEC(count,bitpos);             DEC(hbit,bitpos);              bitpos := 8;
          END;6
       END;       turnon := NOT turnon;     END;) END; Put('>'); Put(CR);# PutCard(bytesperrow * 8); Put(' ');V PutInt(ht); Put(' ');  PutInt(xo); Put(' ');)J PutInt(yo); Put(' ');                  (* offset of origin from top row *) PutInt(pwidth);* PutString('] '); PutCard(code); PutString(' dc'); Put(CR); END; (* WITH *)R END PKLoadBitmap;R  P (******************************************************************************)  " PROCEDURE PackedNum () : CARDINAL;  G (* Return next run count using algorithm given in section 23 of PKtype.iE    A possible side-effect is to set the global repeatcount value used*     to duplicate the current row. *)   VAR i, j : CARDINAL;   BEGIN  i := GetNyb();
 IF i = 0 THENa-    REPEAT j := GetNyb(); INC(i) UNTIL j <> 0;a5    WHILE i > 0 DO j := j * 16 + GetNyb(); DEC(i) END;h+    RETURN j - 15 + (13 - dynf) * 16 + dynf;  ELSIF i <= dynf THEN    RETURN i; ELSIF i < 14 THENO4    RETURN (i - dynf - 1) * 16 + GetNyb() + dynf + 1; ELSE    IF i = 14 THENw3       repeatcount := PackedNum();   (* recursive *)h    ELSEe5       repeatcount := 1;             (* nybble = 15 *)h    END;e3    RETURN PackedNum();              (* recursive *)) END; END PackedNum;  P (******************************************************************************)   PROCEDURE GetNyb () : CARDINAL;w  $ (* Return next nybble in PK file. *)   BEGIN( IF bitweight = 0 THEN 3    (* next 2 lines equal inputbyte := GetByte(); *) 1    inputbyte := CARDINAL(filestart^[byteoffset]);L    INC(byteoffset);y;    bitweight := 16;           (* for next call of GetNyb *)t/    RETURN inputbyte DIV 16;   (* high nybble *)h ELSE;    bitweight := 0;            (* for next call of GetNyb *)N.    RETURN inputbyte MOD 16;   (* low nybble *) END; END GetNyb;s  P (******************************************************************************)P (* Here are the declarations and routines for reading TFM files:              *)P (******************************************************************************)   VAR)$    lf, lh, bc, ec, nw, nh : INTEGER;"    charinfo    : ARRAY [0..255] OF                     RECORD;                        wdindex, htindex, dpindex : INTEGER;*                     END;"    charmetrics : ARRAY [0..255] OF                     RECORDM                                               (* 4 bytes making up fixword *) F                        width, height, depth : ARRAY [0..3] OF INTEGER;                     END;  P (******************************************************************************)   PROCEDURE TFMFillPixelTable;  8 (* Fill the pixeltable for currfont^ (a PostScript font)4    using information in the currently open TFM file. *)  2 VAR c, dheight, pheight, ddepth, pdepth : INTEGER;   BEGIN : ReadTFMIntegers;                         (* read lf..nh *)B ReadTFMCharInfo;                         (* fill charinfo array *)E ReadTFMCharMetrics;                      (* fill charmetrics array *)a WITH currfont^ DO     FOR c := 0 TO bc - 1 DOE       pixelptr^[c].mapadr := 0;          (* chars < bc don't exist *)     END;t    FOR c := ec + 1 TO 255 DOE       pixelptr^[c].mapadr := 0;          (* chars > ec don't exist *)i    END;     FOR c := bc TO ec DO;       WITH pixelptr^[c] DO       WITH charmetrics[c] DOB          dwidth  := FixToDVI(width[0],width[1],width[2],width[3]);F          dheight := FixToDVI(height[0],height[1],height[2],height[3]);B          ddepth  := FixToDVI(depth[0],depth[1],depth[2],depth[3]);*          (* convert DVI units to pixels *)'          pwidth  := PixelRound(dwidth); (          pheight := PixelRound(dheight);'          pdepth  := PixelRound(ddepth);tK          (* Since we don't have access to bitmap info for a PostScript fontdB             we will have to use the TFM width/height/depth info to'             approximate wd, ht, xo, yo.           *))          wd := pwidth;C          DEC(wd,wd DIV 8);               (* better approximation *)d           ht := pheight + pdepth;          xo := 0;           yo := pheight - 1;*%          IF (wd = 0) OR (ht = 0) THEN L             mapadr := 0;                 (* char all-white or not in font *)
          ELSE =             mapadr := 1;                 (* anything but 0 *)e
          END;eB          loaded := FALSE;                (* no bitmap available *)
       END;
       END;    END;  END; END TFMFillPixelTable;  P (******************************************************************************)   PROCEDURE ReadTFMIntegers;  N (* Read the first 6 16-bit integers in the TFM file.  See TFtoPL section 8. *)   BEGIN B byteoffset := 0;       (* start reading at 1st byte in TFM file *) lf := GetTwoBytes(); lh := GetTwoBytes(); bc := GetTwoBytes(); ec := GetTwoBytes(); nw := GetTwoBytes(); nh := GetTwoBytes(); END ReadTFMIntegers;  P (******************************************************************************)   PROCEDURE ReadTFMCharInfo;  6 (* Read the charinfo array.  See TFtoPL section 11. *)   VAR c, i : INTEGER;    BEGIN A byteoffset := 24 + (lh * 4);       (* offset of charinfo array *)  FOR c := bc TO ec DO    WITH charinfo[c] DOI       wdindex := GetByte() * 4;    (* offset from start of width array *)GN       i       := GetByte();        (* 2nd byte contains htindex and dpindex *)J       htindex := (i DIV 16) * 4;   (* offset from start of height array *)I       dpindex := (i MOD 16) * 4;   (* offset from start of depth array *) I       INC(byteoffset,2);           (* skip itindex and remainder bytes *)     END;  END; END ReadTFMCharInfo;  P (******************************************************************************)   PROCEDURE ReadTFMCharMetrics;t  ? (* Read the charmetrics array using the indices in charinfo. *)   + VAR wdbase, htbase, dpbase, b, c : INTEGER;o   BEGIN,H wdbase := 24 + lh * 4 + (ec - bc + 1) * 4;   (* offset of width array *)I htbase := wdbase + nw * 4;                   (* offset of height array *) H dpbase := htbase + nh * 4;                   (* offset of depth array *) FOR c := bc TO ec DO    WITH charinfo[c] DO    WITH charmetrics[c] DOe%       byteoffset := wdbase + wdindex;D3       FOR b := 0 TO 3 DO width[b] := GetByte() END;F%       byteoffset := htbase + htindex; 4       FOR b := 0 TO 3 DO height[b] := GetByte() END;%       byteoffset := dpbase + dpindex;a3       FOR b := 0 TO 3 DO depth[b] := GetByte() END;     END;     END;D END; END ReadTFMCharMetrics;f  P (******************************************************************************)   BEGIN4 END FontReader. 