 IMPLEMENTATION MODULE Options;  # (* Author:         Andrew Trevorrow I    Implementation: University of Hamburg Modula-2 under VAX/VMS version 4     Date Started:   August, 1986       Description: B    This module uses CLI routines to extract the DVI file parameter4    and qualifier values from the PSDVI command line.      Revised: 0    November, 1987 (while at The Open University)4  - Added /TFM_DIRECTORY and /CONSERVE_VM qualifiers.  1    June--August, 1988 (while at Aston University) A  - Added /PSPREFIX, /INCREMENT, /HOFFSET and /VOFFSET qualifiers.  *)  $ FROM CommandLanguageInterface IMPORT    CLI$PRESENT,     CLI$GET_VALUE;    FROM Conversions IMPORT $    StringToCard, StringToReal, Done;   FROM TermOut IMPORT %    Write, WriteString, WriteLn, Halt;    CONST ;    NULL = 0C;             (* SYSDEP: terminates a string *)    VAR 0    value : stringvalue;   (* temporary string *)  P (******************************************************************************)   PROCEDURE GetDVIFile;   * (* Get DVI file name from command line. *)   VAR i, status : CARDINAL;    BEGIN  DVIname := '';L status := CLI$GET_VALUE('FILESPEC',DVIname);   (* CLD ensures it is there *) i := HIGH(DVIname); K WHILE (i > 0) AND (DVIname[i] = ' ') DO        (* remove trailing blanks *) K    DVIname[i] := NULL;                         (* SYSDEP: pad with NULLs *) 
    DEC(i); END;H IF DVIname[i] = ':' THEN                       (* assume logical name *)    (* no need to translate *)  ELSE!    INC(i);   (* = LEN(DVIname) *) @    IF NOT ExplicitExt(DVIname) THEN            (* append .DVI *)$       IF i + 3 <= HIGH(DVIname) THEN          DVIname[i]   := '.';           DVIname[i+1] := 'D';           DVIname[i+2] := 'V';           DVIname[i+3] := 'I'; :       ELSE   (* user has given a mighty long file spec! *)E          WriteString('DVI file specification is too long!'); WriteLn; '          WriteString(DVIname); WriteLn;           Halt(2); 
       END;    END;  END;; (* bad DVIname will be detected upon open in main module *)  END GetDVIFile;   P (******************************************************************************)  8 PROCEDURE ExplicitExt (fname : ARRAY OF CHAR) : BOOLEAN;  L (* SYSDEP: VAX/VMS files have an extension of the form ".xxx", also known asI    the file type.  If given file specification contains an extension then %    TRUE is returned, otherwise FALSE.  *)    VAR pos : CARDINAL;   ch : CHAR;   BEGIN  pos := LEN(fname);E WHILE pos > 0 DO       (* search backwards looking for . or : or ] *)     DEC(pos);    ch := fname[pos];    IF ch = '.' THEN        RETURN TRUE I    ELSIF (ch = ':') OR (ch = ']') THEN   (* don't need to look further *)        RETURN FALSE    END;  END;
 RETURN FALSE;  END ExplicitExt;  P (******************************************************************************)  D PROCEDURE GetCardinal (qualifier : ARRAY OF CHAR; VAR n : CARDINAL);  G (* Check if qualifier is present.  If so, then make sure given value is G    a positive integer, and return via n.  If not present then return 0.  *)   VAR i, status : CARDINAL;    BEGIN P IF ODD(CLI$PRESENT(qualifier)) THEN             (* CLD ensures it has a value *),    status := CLI$GET_VALUE(qualifier,value);    i := HIGH(value);L    WHILE (i > 0) AND (value[i] = ' ') DO        (* remove trailing blanks *)L       value[i] := NULL;                         (* SYSDEP: pad with NULLs *)
       DEC(i);     END;     n := StringToCard(value);    IF Done() AND (n > 0) THEN        (* return *)    ELSE 3       WriteString('Bad /'); WriteString(qualifier); ;       WriteString(' value: '); WriteString(value); WriteLn; :       WriteString('Specify a positive integer.'); WriteLn;       Halt(2);    END;  ELSEK    n := 0;                                      (* qualifier not present *)  END; END GetCardinal;  P (******************************************************************************)  M PROCEDURE GetPosDimension (qualifier : ARRAY OF CHAR; VAR pixels : CARDINAL);   G (* Check if qualifier is present.  If so, then make sure given value is =    a valid positive dimension, convert and return via pixels. K    A valid positive dimension consists of a positive integer or real number -    followed by a two-letter unit in any case.  *)   VAR     i, status : CARDINAL;    r : REAL;    ch1, ch2 : CHAR;     units : validunits;   BEGIN P IF ODD(CLI$PRESENT(qualifier)) THEN             (* CLD ensures it has a value *),    status := CLI$GET_VALUE(qualifier,value);    i := HIGH(value);L    WHILE (i > 0) AND (value[i] = ' ') DO        (* remove trailing blanks *)L       value[i] := NULL;                         (* SYSDEP: pad with NULLs *)
       DEC(i);     END;     IF i = 0 THEN i := 1 END;    (* extract units *)?    IF    (Cap(value[i-1]) = 'I') AND (Cap(value[i]) = 'N') THEN        units := in;?    ELSIF (Cap(value[i-1]) = 'C') AND (Cap(value[i]) = 'M') THEN        units := cm;?    ELSIF (Cap(value[i-1]) = 'M') AND (Cap(value[i]) = 'M') THEN        units := mm;?    ELSIF (Cap(value[i-1]) = 'P') AND (Cap(value[i]) = 'C') THEN        units := pc;?    ELSIF (Cap(value[i-1]) = 'P') AND (Cap(value[i]) = 'T') THEN        units := pt;?    ELSIF (Cap(value[i-1]) = 'B') AND (Cap(value[i]) = 'P') THEN        units := bp;?    ELSIF (Cap(value[i-1]) = 'P') AND (Cap(value[i]) = 'X') THEN        units := px;    ELSE <       WriteString('Bad units in /'); WriteString(qualifier);?       WriteString(' dimension: '); WriteString(value); WriteLn; N       WriteString('Last two letters should be IN, CM, MM, PC, PT, BP or PX.');       WriteLn;       Halt(2);    END; A    ch1 := value[i-1];             (* remember letters in units *)     ch2 := value[i]; 4    value[i]   := NULL;            (* remove units *)    value[i-1] := NULL;    r := StringToReal(value);;    IF Done() AND (r > 0.0) THEN   (* convert r to pixels *)        CASE units OF <          in : pixels := TRUNC(r * FLOAT(resolution) + 0.5) |E          cm : pixels := TRUNC((r / 2.54) * FLOAT(resolution) + 0.5) | E          mm : pixels := TRUNC((r / 25.4) * FLOAT(resolution) + 0.5) | M          pc : pixels := TRUNC((r / 72.27) * 12.0 * FLOAT(resolution) + 0.5) | F          pt : pixels := TRUNC((r / 72.27) * FLOAT(resolution) + 0.5) |E          bp : pixels := TRUNC((r / 72.0) * FLOAT(resolution) + 0.5) | &          px : pixels := TRUNC(r + 0.5)
       END;    ELSE 5       value[i-1] := ch1;          (* restore units *)        value[i]   := ch2;3       WriteString('Bad /'); WriteString(qualifier); ;       WriteString(' value: '); WriteString(value); WriteLn; <       WriteString('Specify a positive dimension.'); WriteLn;       Halt(2);    END;  ELSE=    pixels := 0;                   (* qualifier not present *)  END; END GetPosDimension;  P (******************************************************************************)  I PROCEDURE GetDimension (qualifier : ARRAY OF CHAR; VAR pixels : INTEGER);   G (* Check if qualifier is present.  If so, then make sure given value is 4    a valid dimension, convert and return via pixels.N    A valid dimension consists of an integer or real number (possibly negative)-    followed by a two-letter unit in any case.  *)   VAR     i, status : CARDINAL;    r : REAL;    ch1, ch2 : CHAR;     units : validunits;   BEGIN P IF ODD(CLI$PRESENT(qualifier)) THEN             (* CLD ensures it has a value *),    status := CLI$GET_VALUE(qualifier,value);    i := HIGH(value);L    WHILE (i > 0) AND (value[i] = ' ') DO        (* remove trailing blanks *)L       value[i] := NULL;                         (* SYSDEP: pad with NULLs *)
       DEC(i);     END;     IF i = 0 THEN i := 1 END;    (* extract units *)?    IF    (Cap(value[i-1]) = 'I') AND (Cap(value[i]) = 'N') THEN        units := in;?    ELSIF (Cap(value[i-1]) = 'C') AND (Cap(value[i]) = 'M') THEN        units := cm;?    ELSIF (Cap(value[i-1]) = 'M') AND (Cap(value[i]) = 'M') THEN        units := mm;?    ELSIF (Cap(value[i-1]) = 'P') AND (Cap(value[i]) = 'C') THEN        units := pc;?    ELSIF (Cap(value[i-1]) = 'P') AND (Cap(value[i]) = 'T') THEN        units := pt;?    ELSIF (Cap(value[i-1]) = 'B') AND (Cap(value[i]) = 'P') THEN        units := bp;?    ELSIF (Cap(value[i-1]) = 'P') AND (Cap(value[i]) = 'X') THEN        units := px;    ELSE <       WriteString('Bad units in /'); WriteString(qualifier);?       WriteString(' dimension: '); WriteString(value); WriteLn; N       WriteString('Last two letters should be IN, CM, MM, PC, PT, BP or PX.');       WriteLn;       Halt(2);    END; A    ch1 := value[i-1];             (* remember letters in units *)     ch2 := value[i]; 4    value[i]   := NULL;            (* remove units *)    value[i-1] := NULL;    r := StringToReal(value);;    IF Done() THEN                 (* convert r to pixels *)        CASE units OF A          in : pixels := TRUNC(ABS(r) * FLOAT(resolution) + 0.5) | H          cm : pixels := TRUNC((ABS(r)/2.54) * FLOAT(resolution) + 0.5) |H          mm : pixels := TRUNC((ABS(r)/25.4) * FLOAT(resolution) + 0.5) |P          pc : pixels := TRUNC((ABS(r)/72.27) * 12.0 * FLOAT(resolution) + 0.5) |I          pt : pixels := TRUNC((ABS(r)/72.27) * FLOAT(resolution) + 0.5) | H          bp : pixels := TRUNC((ABS(r)/72.0) * FLOAT(resolution) + 0.5) |+          px : pixels := TRUNC(ABS(r) + 0.5) 
       END;,       IF r < 0.0 THEN pixels := -pixels END;    ELSE 5       value[i-1] := ch1;          (* restore units *)        value[i]   := ch2;3       WriteString('Bad /'); WriteString(qualifier); ;       WriteString(' value: '); WriteString(value); WriteLn; 9       WriteString('Specify a valid dimension.'); WriteLn;        Halt(2);    END;  ELSE=    pixels := 0;                   (* qualifier not present *)  END; END GetDimension;   P (******************************************************************************)  ! PROCEDURE Cap (ch : CHAR) : CHAR;   ) (* Hamburg's CAP is stupid; do my own. *)    BEGIN   IF (ch < 'a') OR (ch > 'z') THEN
    RETURN ch;  ELSE    RETURN CAP(ch); END; END Cap;  P (******************************************************************************)  / PROCEDURE GetString (qualifier : ARRAY OF CHAR; 0                      VAR s     : ARRAY OF CHAR);  J (* Check if qualifier is present.  If so, then get value and return via s.5    If qualifier not present then return empty string.  *)   VAR i, status : CARDINAL;    BEGIN M IF ODD(CLI$PRESENT(qualifier)) THEN          (* CLD ensures it has a value *) (    status := CLI$GET_VALUE(qualifier,s);    i := HIGH(s);I    WHILE (i > 0) AND (s[i] = ' ') DO         (* remove trailing blanks *) I       s[i] := NULL;                          (* SYSDEP: pad with NULLs *) 
       DEC(i);     END;  ELSEK    s[0] := NULL;                             (* SYSDEP: LEN(s) will be 0 *)  END;= (* the main module will detect bad s value sooner or later *)  END GetString;  P (******************************************************************************)  > PROCEDURE Append (VAR s1 : ARRAY OF CHAR; s2 : ARRAY OF CHAR);   (* Append s2 to s1. *)   VAR i, j : CARDINAL;   BEGIN D i := LEN(s1);   (* SYSDEP: assumes s1 ends with NULL, unless full *) j := 0; @ WHILE (i <= HIGH(s1)) AND (j <= HIGH(s2)) AND (s2[j] <> NULL) DO    s1[i] := s2[j];
    INC(i);
    INC(j); END; (* DEBUG> IF (i > HIGH(s1)) AND (j <= HIGH(s2)) AND (s2[j] <> NULL) THEN?    WriteString('No room to append '); WriteString(s2); WriteLn;     Halt(2);  END; GUBED *)( IF i <= HIGH(s1) THEN s1[i] := NULL END; END Append;   P (******************************************************************************)   PROCEDURE GetUnits;   D (* Check if /UNITS is present.  If so, then make sure given value is    valid and set units.  *)  , VAR i, status : CARDINAL;   ch1, ch2 : CHAR;   BEGIN P IF ODD(CLI$PRESENT('UNITS')) THEN               (* CLD ensures it has a value *)*    status := CLI$GET_VALUE('UNITS',value);    i := HIGH(value);L    WHILE (i > 0) AND (value[i] = ' ') DO        (* remove trailing blanks *)L       value[i] := NULL;                         (* SYSDEP: pad with NULLs *)
       DEC(i);     END;     ch1 := Cap(value[0]);    ch2 := Cap(value[1]);)    IF    (ch1 = 'I') AND (ch2 = 'N') THEN        units := in;)    ELSIF (ch1 = 'C') AND (ch2 = 'M') THEN        units := cm;)    ELSIF (ch1 = 'M') AND (ch2 = 'M') THENs       units := mm;)    ELSIF (ch1 = 'P') AND (ch2 = 'C') THENe       units := pc;)    ELSIF (ch1 = 'P') AND (ch2 = 'T') THEN        units := pt;)    ELSIF (ch1 = 'B') AND (ch2 = 'P') THENl       units := bp;)    ELSIF (ch1 = 'P') AND (ch2 = 'X') THEN1       units := px;    ELSEsE       WriteString('Bad /UNITS value: '); WriteString(value); WriteLn;AD       WriteString('Specify IN, CM, MM, PC, PT, BP or PX.'); WriteLn;       Halt(2);    END;  ELSE-    units := px;   (* if /UNITS not present *)O END;
 END GetUnits;   P (******************************************************************************)   PROCEDURE GetPages;   A (* Check if /PAGES is present.  If so then subrange will be TRUE. K    /PAGES can accept any value of the form "first:final" where first and/or K    final can be a DVI page (positive integer), or TeX page ([i0. ... .i9]),*G    or empty.  If first empty then firstDVIpage = 1; if final empty then =    finalDVIpage = MAX(CARDINAL).  If ":final" is omitted thenI    finalDVIpage = firstDVIpage.$E    If first/final is a TeX page specification (i.e., starts with '[')GJ    then first/finalDVIpage is set to 0 and first/finalTeXpage contains the9    given string (and parsing is done by the main module).  *)  ! VAR i, j, status, len : CARDINAL;i   BEGIN P IF ODD(CLI$PRESENT('PAGES')) THEN               (* CLD ensures it has a value *)*    status := CLI$GET_VALUE('PAGES',value);    i := HIGH(value);L    WHILE (i > 0) AND (value[i] = ' ') DO        (* remove trailing blanks *)L       value[i] := NULL;                         (* SYSDEP: pad with NULLs *)
       DEC(i);     END;aE    len := i + 1;                                (* length of value *)h    firstTeXpage := '';    finalTeXpage := '';
    i := 0;H    WHILE (i < len) AND (value[i] <> ':') DO     (* extract first page *)"       firstTeXpage[i] := value[i];
       INC(i);     END;NJ    IF value[0] = ':' THEN                       (* first page not given *)       firstDVIpage := 1;D    ELSIF firstTeXpage[0] = '[' THEN             (* TeX page given *)       firstDVIpage := 0;D    ELSE                                         (* DVI page given *)1       firstDVIpage := StringToCard(firstTeXpage); .       IF NOT Done() OR (firstDVIpage = 0) THEN7          WriteString('/PAGES error! Bad first page: ');),          WriteString(firstTeXpage); WriteLn;          Halt(2);;
       END;    END; O    IF i = len THEN                              (* no colon; /PAGES=n or [t] *)p#       IF firstTeXpage[0] = '[' THENUC          finalTeXpage := firstTeXpage;          (* [t] = [t]:[t] *)o          finalDVIpage := 0;F
       ELSE=          finalDVIpage := firstDVIpage;          (* n = n:n *)*
       END;D    ELSE                                         (* value[i] = ':' *)
       INC(i);r
       j := 0;RH       WHILE i < len DO                          (* extract final page *)%          finalTeXpage[j] := value[i];n          INC(i); INC(j);
       END;G       IF j = 0 THEN                             (* no page after ':' *)I'          finalDVIpage := MAX(CARDINAL);CD       ELSIF finalTeXpage[0] = '[' THEN          (* TeX page given *)          finalDVIpage := 0; D       ELSE                                      (* DVI page given *)4          finalDVIpage := StringToCard(finalTeXpage);1          IF NOT Done() OR (finalDVIpage = 0) THEND:             WriteString('/PAGES error! Bad final page: ');/             WriteString(finalTeXpage); WriteLn;r             Halt(2);
          END; 
       END;    END; ?    subrange := TRUE;    (* main module will check page range *)i ELSE3    subrange := FALSE;   (* if /PAGES not present *)  END;
 END GetPages;   P (******************************************************************************)  G (* SYSDEP: CLD file must supply some qualifiers with default values. *)*   BEGIN)E GetDVIFile;                                  (* initialize DVIname *)CD GetString('OUTPUT',PSname);                  (* initialize PSname *)H IF LEN(PSname) = 0 THEN                      (* /OUTPUT not specified *)    PSname := 'OUT.PS';C    (* It would be nicer to use DVIname with .PS instead of .DVI butoL       things get messy if DVIname is a logical name or includes a directory.?       Note that PSPRINT.COM specifies an explicit /OUTPUT file.I    *)O END;H GetCardinal('MAGNIFICATION',mag);            (* 0 if no /MAG override *)O GetCardinal('RESOLUTION',resolution);        (* get resolution BEFORE dimens *))! GetPosDimension('XSIZE',paperwd);r! GetPosDimension('YSIZE',paperht);uA GetDimension('HOFFSET',hoffset);             (* 0 if not given *) 8 GetDimension('VOFFSET',voffset);             (* ditto *)M GetString('HEADER',header);                  (* empty string if no /HEADER *)) GetString('PSPREFIX',psprefix);S" GetString('TFM_DIRECTORY',tfmdir);$ GetString('FONT_DIRECTORY',fontdir); GetString('DUMMY_FONT',value);P dummyfont := fontdir;                        (* prefix dummyfont with fontdir *) Append(dummyfont,value);C GetUnits;                                    (* initialize units *))K GetPages;                                    (* initialize subrange etc. *)]E GetCardinal('INCREMENT',increment);          (* 0 if /INC not used *)(K IF increment = 0 THEN increment := 1 END;    (* do normal page selection *) # stats := ODD(CLI$PRESENT('STATS'));i' reverse := ODD(CLI$PRESENT('REVERSE'));t. conserveVM := ODD(CLI$PRESENT('CONSERVE_VM')); END Options.