
 MODULE PSDVI;   # (* Author:         Andrew Trevorrow I    Implementation: University of Hamburg Modula-2 under VAX/VMS version 4     Date Started:   August, 1986 0    Released:       September, 1986 (version 1.0)      Description: J    PSDVI reads a TeX DVI file and creates a corresponding PostScript file.C    This output file needs to be prefixed with some PostScript code. >    The /HEADER option can be used to include any desired file.@    PSDVI can be used by itself (see PSDVI.HLP) or as part of the@    PSPRINT system (see the PSPRINT User Guide and System Guide).4    Much of the code has been borrowed from DVItoVDU.  	    Notes: >  - Debugging code is bracketed by (* DEBUG *) ... (* GUBED *).;    This code will be disabled in the final working version. =  - System-dependent code is indicated by the string "SYSDEP". L  - Uncertain or unfinished code is indicated by the strings "???" and "!!!".I  - Procedures are defined in a top-down manner: each procedure is usually 3    defined as soon as possible after its first use. A  - The above notes also apply to the local modules used by PSDVI.       Revised:     December, 1986 E  - PXLReader has become FontReader and can handle other font formats. :    All font-dependent code has been moved into FontReader.E  - Use LoadBitmap from FontReader instead of LoadPSChar from PSWriter 7    to output PostScript code for each character bitmap. K    Unlike DVItoVDU, PSDVI does not need to store each bitmap for later use. (  - Released version 1.1 in January, 1987  0    November, 1987 (while at The Open University)J  - Import tfmdir (for display in ShowOptions) and conserveVM from Options.-  - Import SaveVM and RestoreVM from PSWriter. A  - Import SetPostScriptChar from PSWriter; it is used (instead of H    SetBitmapChar) to typeset characters from a resident PostScript font.?  - Use conserveVM flag to call a different sequence of PSWriter 9    routines if the user wants to conserve virtual memory. F  - Use psfont flag (set in BuildFontSpec in FontReader) to control the?    sequence of PSWriter routines for resident PostScript fonts. K  - Added ShowPtSize routine to show requested pt size for PostScript fonts. J  - Added PSDVI banner line to start of ShowOptions showing version number.)  - Released version 2.0 in December, 1987   1    June--August, 1988 (while at Aston University) L  - Added /psprefix qualifier so that sites have some flexibility in choosing/    the prefix that indicates a PostScript font. L  - Added /increment qualifier to enhance page selection for duplex printing.D  - Added /hoffset and /voffset qualifiers to allow shifting of page.F  - Removed "Creating ..." message due to changes in *_PRINT.COM files.2  - No longer use StartLn/WriteBuffer/pagesperline.-    Page numbers now appear on separate lines. '  - Released version 3.0 in August, 1988  *)     FROM Storage IMPORT 4    ALLOCATE, DEALLOCATE;   (* for NEW and DISPOSE *)    E (* SYSDEP: Modula-2 avoids the problem of system dependence by simply G    not providing any input/output routines etc.  The above importations     are highly system-dependent.   D    The following modules are kept with the file you are now reading.K    See the .DEF files for details on how the imported identifiers should be M    used; implementation details can be found in the corresponding .MOD files.  *)    ; (* The TermOut module is used to do all terminal output. *)  FROM TermOut IMPORT :    Write, WriteString, WriteInt, WriteCard, WriteLn, Halt;    E (* The Options module carries out the task of reading the DCL command =    line and extracting the DVI file parameter and qualifiers.  *) FROM Options IMPORT     validunits, units,     reverse, stats, conserveVM,D    subrange, firstTeXpage, finalTeXpage, firstDVIpage, finalDVIpage,B    increment, resolution, mag, paperwd, paperht, hoffset, voffset,A    psprefix, tfmdir, fontdir, dummyfont, header, PSname, DVIname;     K (* PSDVI uses the routines and data structures defined in DVIReader to move 9    about randomly in the DVI file and to interpret pages. G    The reference points of characters and rules on a page are stored as 6    pairs of horizontal and vertical pixel coordinates.A    The coordinate scheme is described in detail in DVIREADER.DEF.  *) FROM DVIReader IMPORT 9    ruletablesize, chartablesize, maxfontspec, maxTeXchar,     ruleinfo, ruleinfoptr, %    fontstring, fontinfo, fontinfoptr, 4    charinfo, charinfoptr, pixeltable, pixeltableptr,    TeXcounters, TeXpageinfo,"    DVIerrorcodes, GetByteFunction,"    DVImag, totalpages, totalfonts,    currDVIpage, currTeXpage,6    rulelist, ruletail, totalrules, fontlist, currfont,)    minhp, minvp, maxhp, maxvp, pageempty, 6    DVIErrorRoutine, SpecialRoutine, PixelTableRoutine,C    OpenDVIFile, SetConversionFactor, MoveToDVIPage, CurrMatchesNew, 6    PixelRound, InterpretPage, SortFonts, CloseDVIFile;    < (* PSDVI gets character metrics and bitmaps from font files.H    The FontReader module can handle a variety of different font formats.=    No more than one font file will be open at any given time.  *) FROM FontReader IMPORT    FillPixelTable, LoadBitmap,!    InitFontReader, BuildFontSpec,     OpenFontFile, CloseFontFile;     E (* The PSWriter routines are used to create an output file containing #    the appropriate PostScript code.  *) FROM PSWriter IMPORT6    OpenOutput, OutputHeader, BeginPage, NewBitmapFont,,    OutputPage, specialstring, OutputSpecial,2    SaveVM, BeginPostScriptFont, SetPostScriptChar,6    BeginBitmapFont, SetBitmapChar, EndFont, RestoreVM,!    SetRule, EndPage, CloseOutput;     P (*******************************************************************************    GLOBAL DECLARATIONS *)   CONST K    NULL = 0C;           (* SYSDEP: NULL terminates a string, unless full *) I    warning = 0;         (* SYSDEP: Halt parameter to set VMS $SEVERITY *) #    success = 1;         (* ditto *) #    error   = 2;         (* ditto *)    TYPE+    specialinfoptr = POINTER TO specialinfo;     specialinfo    = RECORD/                        special : specialstring; )                        hp, vp  : INTEGER; 4                        nextspecial : specialinfoptr;                     END;   VAR B    speciallist : specialinfoptr;   (* for storing \special info *)    papertop,
    paperleft,     paperbottom, L    paperright : INTEGER;           (* these define the edges of the paper *)C    warncount,                      (* count of problems detected *) G    pagecount : CARDINAL;           (* count of pages actually output *) M    unusedfont : fontinfoptr;       (* first unused font in sorted fontlist *)     P (******************************************************************************)   PROCEDURE TopLevel;   K (* Note that the implementation blocks of all imported modules have already M    been executed.  In particular, the Options module has read the DCL command D    line and initialized the DVI file parameter and qualifier values. *)   VAR i : CARDINAL;    BEGIN  Initialize; E DVIErrorRoutine := MyDVIErrorRoutine;       (* called by DVIReader *) F OpenDVIFile(DVIname);                       (* and read DVImag etc. *)M IF mag = 0 THEN mag := DVImag END;          (* no /MAG value so use DVImag *) ? SetConversionFactor(resolution,mag);        (* for DVIReader *) I SpecialRoutine    := MySpecialRoutine;      (* called by InterpretPage *) I PixelTableRoutine := MyPixelTableRoutine;   (* called by InterpretPage *) P InitFontReader;                             (* assign font-dependent routines *) IF stats THEN ShowOptions END;P CheckPageRange;                             (* set firstDVIpage, finalDVIpage *) IF OpenOutput(PSname) THEN    (* DEBUG     WriteString('Creating ');    WriteString(PSname);     WriteLn;     GUBED *)  ELSE.    WriteString("Couldn't open output file: ");    WriteString(PSname);     WriteLn;     Halt(error);  END;J IF LEN(header) > 0 THEN                     (* output header file first *)#    IF NOT OutputHeader(header) THEN 1       WriteString("Couldn't open header file: ");        WriteString(header);       WriteLn;       Halt(error);    END;  END;P IF increment > 1 THEN                       (* finalDVIpage may need reducing *);    WHILE (finalDVIpage - firstDVIpage) MOD increment > 0 DO        DEC(finalDVIpage);    END;  END; IF reverse THEN I    MoveToDVIPage(finalDVIpage);             (* start with finalDVIpage *) K    finalDVIpage := firstDVIpage;            (* and end with firstDVIpage *)  ELSEI    MoveToDVIPage(firstDVIpage);             (* start with firstDVIpage *)  END; LOOPF    DoPage;                                  (* do at least one page *)#    IF stats THEN ShowPageStats END; /    IF currDVIpage = finalDVIpage THEN EXIT END;     IF reverse THEN-       MoveToDVIPage(currDVIpage - increment);     ELSE -       MoveToDVIPage(currDVIpage + increment);     END;  END;! IF stats THEN ShowFinalStats END; 
 CloseDVIFile;  CloseOutput; IF warncount > 0 THEN     Halt(warning);  ELSE    Halt(success);  END;
 END TopLevel;   P (******************************************************************************)   PROCEDURE Initialize;    BEGIN J (* we don't bother checking for crazy resolution/paperht/paperwd values *)4 (* top left corner of paper is fixed at (-1",-1") *)$ papertop    := -INTEGER(resolution);$ paperleft   := -INTEGER(resolution);0 paperbottom := papertop  + INTEGER(paperht) - 1;0 paperright  := paperleft + INTEGER(paperwd) - 1; warncount := 0;  pagecount := 0; 6 speciallist := NIL;   (* for first MySpecialRoutine *) END Initialize;   P (******************************************************************************)  7 PROCEDURE MyDVIErrorRoutine (DVIerror : DVIerrorcodes);   7 (* DVIErrorRoutine for DVIReader; see DVIREADER.DEF. *)    BEGIN  CASE DVIerror OFI (* these errors are detected in OpenDVIFile; they are considered fatal *)     DVIunopened      : .       WriteString("Couldn't open DVI file: ");$       WriteString(DVIname); WriteLn;       Halt(error);  |     DVIempty         :        WriteString(DVIname); )       WriteString(' is empty!'); WriteLn;        Halt(error);  |     DVIbadid         :        WriteString(DVIname); 8       WriteString(' is not a valid DVI file!'); WriteLn;       Halt(error);  |     DVIstackoverflow : 7       WriteString('Stack capacity exceeded!'); WriteLn;        PleaseReport;        Halt(error);  | H (* this error is detected in InterpretPage; we warn user but continue *)    DVIbadchar       :        WITH currfont^ DO 9          WriteString('Ignoring unknown character from '); +          WriteString(fontspec); Write('!');           WriteLn;        END;          | $ (* this error should never happen *)    DVIcatastrophe   :        WriteLn;<       WriteString('Something awful has happened!'); WriteLn;       PleaseReport;        Halt(error); ELSE:    (* this will only happen if we've missed a DVI error *)    WriteLn; 5    WriteString('Bug in MyDVIErrorRoutine!'); WriteLn;     PleaseReport;    Halt(error);  END; END MyDVIErrorRoutine;  P (******************************************************************************)   PROCEDURE PleaseReport;    BEGIN : WriteString('Please tell your local TeXnician.'); WriteLn; END PleaseReport;   P (******************************************************************************)  ' PROCEDURE MySpecialRoutine (hpos, vpos, 2                             totalbytes  : INTEGER;;                             NextDVIByte : GetByteFunction);   M (* DVIReader has seen a \special command while interpreting the current page. K    It will call this routine and pass the current page position, the number O    of bytes in the command and a function to return their values one at a time. K    Instead of calling OutputSpecial directly, we have to save the necessary (    info away for later use (see DoPage). *)  0 VAR i, flush : INTEGER;   temp : specialinfoptr;   BEGIN 
 NEW(temp);
 WITH temp^ DO C    special := '';                     (* SYSDEP: fill with NULLs *)      FOR i := 0 TO totalbytes-1 DO        IF i <= HIGH(special) THEN*          special[i] := CHR(NextDVIByte());
       END;    END; >    (* DVIReader demands that we read ALL the \special bytes *))    IF totalbytes > HIGH(special) + 1 THENo       INC(warncount);r4       WriteString('\special command is too long: ');       WriteString(special);        WriteLn;"       WriteString('Truncating: ');7       FOR i := 1 TO totalbytes - (HIGH(special) + 1) DOIG          Write(CHR(NextDVIByte()));   (* display the truncated bytes *)i
       END;       WriteLn;    END;t    hp := hpos;    vp := vpos;    nextspecial := speciallist; END;H speciallist := temp;                  (* add new info to head of list *) END MySpecialRoutine;s  P (******************************************************************************)  + PROCEDURE ShowDimension (pixels : INTEGER);i  7 (* Show the given pixel dimension in terms of units. *)i  * VAR realdim : REAL;   fracpart : CARDINAL;   BEGIN 
 CASE units OFd6    in : realdim := FLOAT(pixels) / FLOAT(resolution) |=    cm : realdim := FLOAT(pixels) / FLOAT(resolution) * 2.54 |!=    mm : realdim := FLOAT(pixels) / FLOAT(resolution) * 25.4 |eE    pc : realdim := FLOAT(pixels) / FLOAT(resolution) * 72.27 / 12.0 | >    pt : realdim := FLOAT(pixels) / FLOAT(resolution) * 72.27 |=    bp : realdim := FLOAT(pixels) / FLOAT(resolution) * 72.0 | 4    px : WriteInt(pixels); WriteString('px'); RETURN; END;4 (* show realdim to an accuracy of 1 decimal place *) IF ABS(realdim) < 0.05 THENn    WriteString('0.0'); ELSE    IF realdim < 0.0 THEN       Write('-');h       realdim := ABS(realdim);    END;VC    realdim := realdim + 0.05;     (* round up to 1 decimal place *)s2    WriteCard(TRUNC(realdim));     (* whole part *)    Write('.');?    fracpart := TRUNC((realdim - FLOAT(TRUNC(realdim))) * 10.0);r    (* fracpart is now 0..9 *)a    WriteCard(fracpart);S END;
 ShowUnits; END ShowDimension;  H (**********************************************************************)   PROCEDURE ShowUnits;   BEGINn
 CASE units OFe    in : WriteString('in') |t    cm : WriteString('cm') |u    mm : WriteString('mm') |n    pc : WriteString('pc') |e    pt : WriteString('pt') |t    bp : WriteString('bp') |l    px : WriteString('px') |  END; END ShowUnits;  P (******************************************************************************)   PROCEDURE MyPixelTableRoutine;  L (* PixelTableRoutine for DVIReader which has just allocated a new pixeltableG    for currfont^.  DVIReader calls this routine from InterpretPage only 3    ONCE per font (the first time the font is used).fJ    We get the pixeltable information from the font file given by fontspec.M    If fontspec does not exist then dummyfont is used and fontid is undefined.A9    We don't output any PostScript for non-existent fonts.p *)  - VAR i, fontsizelen, firstn, lastn : CARDINAL;s   BEGINNE (* Initialize currfont^.fontspec and return start and end of fontsizeg'    (unless psfont flag is set to TRUE). -    currfont^.fontexists may also become TRUE.  *)% BuildFontSpec(currfont,firstn,lastn);C WITH currfont^ DOn!    IF OpenFontFile(fontspec) THEN-1       (* only need fontid for a bitmapped font *)        IF NOT psfont THEN          fontid := fontname;+          fontsizelen := lastn - firstn + 1;n8          IF fontnamelen + fontsizelen < maxfontspec THEN.             (* append ".fontsize" to fontid *)'             fontid[fontnamelen] := '.';h(             FOR i := 1 TO fontsizelen DOC                fontid[fontnamelen + i] := fontspec[firstn + i - 1];t             END;?             IF fontnamelen + fontsizelen + 1 < maxfontspec THENt=                fontid[fontnamelen + fontsizelen + 1] := NULL;s             END;
          ELSEeP             (* in the unlikely event that there is no room to append ".fontsize"H                we simply leave fontid = fontname and hope it's unique *)O             WriteString("fontname too long: "); WriteString(fontname); WriteLn;,G             WriteString("Increase maxfontspec in DVIReader."); WriteLn;p
          END;,          IF NOT conserveVM THENm"             NewBitmapFont(fontid);
          END;t
       END;       (* DEBUGM       WriteString('Reading font data from '); WriteString(fontspec); WriteLn;T       GUBED *)%    ELSIF OpenFontFile(dummyfont) THENr9       (* fontid is left undefined; it will not be used *)r       INC(warncount);nO       WriteString("Couldn't open font file: "); WriteString(fontspec); WriteLn; '       (* use dummy font info instead *)p    ELSEXH       WriteString("Couldn't open dummy font: "); WriteString(dummyfont);       WriteLn; Halt(error);i    END;     FillPixelTable;    CloseFontFile;i END; END MyPixelTableRoutine;  P (******************************************************************************)   PROCEDURE ShowOptions;  D (* Show DVI file name and qualifier values set in Options module. *)   BEGINi* WriteString('This is PSDVI, version 3.0'); WriteLn; WriteLn;e: WriteString('DVI file          = '); WriteString(DVIname); WriteLn;9 WriteString('PostScript file   = '); WriteString(PSname);  WriteLn;9 WriteString('Header file       = '); WriteString(header);n WriteLn;; WriteString('Resolution        = '); WriteCard(resolution);   WriteString(' pixels per inch'); WriteLn;4 WriteString('Magnification     = '); WriteCard(mag); IF mag <> DVImag THENt3    WriteString(' (DVI mag of '); WriteCard(DVImag);P#    WriteString(' was overridden)');n ELSE    WriteString(' (DVI mag)');o END; WriteLn;9 WriteString('TFM directory     = '); WriteString(tfmdir);a WriteLn;; WriteString('PS font prefix    = '); WriteString(psprefix);c WriteLn;: WriteString('Font directory    = '); WriteString(fontdir); WriteLn;< WriteString('Dummy font        = '); WriteString(dummyfont); WriteLn;< WriteString('Horizontal offset = '); ShowDimension(hoffset); WriteLn;< WriteString('Vertical offset   = '); ShowDimension(voffset); WriteLn;< WriteString('Paper width       = '); ShowDimension(paperwd); WriteLn;< WriteString('Paper height      = '); ShowDimension(paperht); WriteLn;/ WriteString('Units             = '); ShowUnits;  WriteLn;$ WriteString('Reverse           = ');B IF reverse THEN WriteString('true') ELSE WriteString('false') END; WriteLn;$ WriteString('Stats             = ');@ IF stats THEN WriteString('true') ELSE WriteString('false') END; WriteLn;$ WriteString('Conserve VM       = ');E IF conserveVM THEN WriteString('true') ELSE WriteString('false') END;p WriteLn;$ WriteString('Pages             = '); IF subrange THEN    IF firstDVIpage = 0 THENt        WriteString(firstTeXpage);    ELSE        WriteCard(firstDVIpage);    END;e    Write(':');    IF finalDVIpage = 0 THEN(        WriteString(finalTeXpage);    ELSEu       WriteCard(finalDVIpage);    END;s ELSE    WriteString('all pages'); END; IF increment > 1 THEN*.    WriteString(', but with an increment of ');    WriteCard(increment); END; WriteLn; WriteLn; END ShowOptions;  P (******************************************************************************)   PROCEDURE CheckPageRange;n  F (* If user requested a page subrange then we make sure it is valid. *)   VAR newTeXpage : TeXpageinfo;    BEGINi7 IF NOT subrange THEN          (* translate all pages *)e    firstDVIpage := 1;n    finalDVIpage := totalpages; ELSEA    IF firstDVIpage = 0 THEN   (* parse and locate firstTeXpage *) 3       IF ParseTeXPage(firstTeXpage,newTeXpage) THENo          MoveToDVIPage(1);?          (* go forwards until newTeXpage matches currTeXpage *) 
          LOOPy.             IF CurrMatchesNew(newTeXpage) THEN+                firstDVIpage := currDVIpage;                 EXIT;/             ELSIF currDVIpage = totalpages THENrF                WriteString('First TeX page does not exist!'); WriteLn;                Halt(error);V             ELSE.                MoveToDVIPage(currDVIpage + 1);             END;
          END;W
       ELSE:          WriteString('Error in first TeX page!'); WriteLn;          Halt(error);l
       END;    END;gA    IF finalDVIpage = 0 THEN   (* parse and locate finalTeXpage *)03       IF ParseTeXPage(finalTeXpage,newTeXpage) THEN #          MoveToDVIPage(totalpages);E@          (* go backwards until newTeXpage matches currTeXpage *)
          LOOP;.             IF CurrMatchesNew(newTeXpage) THEN+                finalDVIpage := currDVIpage;                 EXIT;&             ELSIF currDVIpage = 1 THENF                WriteString('Final TeX page does not exist!'); WriteLn;                Halt(error);              ELSE.                MoveToDVIPage(currDVIpage - 1);             END;
          END;t
       ELSE:          WriteString('Error in final TeX page!'); WriteLn;          Halt(error); 
       END;    END; &    IF firstDVIpage > finalDVIpage THEND       WriteString('First page > final page!'); WriteLn; Halt(error);'    ELSIF firstDVIpage > totalpages THENVO       WriteString('First page > total number of pages!'); WriteLn; Halt(error);r    END; 5    (* allow user to give a final page > totalpages *) D    IF finalDVIpage > totalpages THEN finalDVIpage := totalpages END; END; END CheckPageRange;   P (******************************************************************************)  7 PROCEDURE ParseTeXPage (VAR pagestring : ARRAY OF CHAR;*5                         VAR newTeXpage : TeXpageinfo) !                        : BOOLEAN;k  L (* Return TRUE if TeX page specification in pagestring is valid.  If so thenJ    newTeXpage will contain the appropriate information for CurrMatchesNew.N    The syntax of a TeX page specification is [n{.n}] where n is any integer asN    defined by GetInteger.  Up to 10 integers may be given and are separated byL    periods, even if absent.  Trailing periods may be omitted.  Spaces beforeN    and after integers and periods are skipped.  The 10 positions correspond toM    the \count0, \count1, ... ,\count9 values that TeX stores with every page.i *)   VAR pos, len : CARDINAL;   BEGIN  WITH newTeXpage DO    pos := 0;!    IF pagestring[pos] <> '[' THENl*       WriteString('[ expected!'); WriteLn;       RETURN FALSE;r    END;(    lastvalue := 0;    len := LEN(pagestring);    LOOP        INC(pos);aO       present[lastvalue] := GetInteger(pagestring, len, pos, value[lastvalue]);S;       (* pos now at len, space, period, non-digit or ']' *)I6       WHILE (pos < len) AND (pagestring[pos] = ' ') DO;          INC(pos);                    (* skip any spaces *)e
       END;=       IF pos = len THEN               (* check this first! *)d-          WriteString('] expected!'); WriteLn;a          RETURN FALSE;
       END;I       IF pagestring[pos] = ']' THEN   (* end of TeX page specification *)           EXIT;
       END;       IF lastvalue < 9 THENg          INC(lastvalue);
       ELSE?          WriteString("] expected after 10 integers!"); WriteLn;N          RETURN FALSE;
       END;$       IF pagestring[pos] <> '.' THEN@          WriteString('Period, integer or ] expected!'); WriteLn;          RETURN FALSE;
       END;    END;a8    WHILE (lastvalue > 0) AND (NOT present[lastvalue]) DO       DEC(lastvalue);W    END;  END; RETURN TRUE; END ParseTeXPage;e  P (******************************************************************************)  9 PROCEDURE GetInteger (VAR str  : ARRAY OF CHAR;  (* in *)*9                       strlen   : CARDINAL;       (* in *)r=                       VAR pos  : CARDINAL;       (* in/out *)l:                       VAR n    : INTEGER         (* out *)!                      ) : BOOLEAN;)  ; (* Extract an integer from given str starting at given pos. =    pos is also used to return the position after the integer.eI    If no integer is found then set n to 0 and return FALSE (pos will onlyw*    change if leading spaces were skipped).0    If ABS(n) > limit then set n to sign * limit.=    Valid syntax is  +{digit}  or  -{digit}  or  digit{digit}. 9    Note that a + or - by itself is valid and sets n to 0.n *)  0 CONST limit = 2147483647;         (* 2^31 - 1 *)8       threshold = limit DIV 10;   (* nearing overflow *)   VAR   absval, last : CARDINAL;       sign : INTEGER;e       inttoobig : BOOLEAN;   BEGIN'D WHILE (pos < strlen) AND (str[pos] = ' ') DO   (* skip any spaces *)    INC(pos); END;$ absval := 0; sign := 1; last := pos; inttoobig := FALSE;N IF pos < strlen THEN    IF str[pos] = '-' THENa       sign := -1; INC(last);    ELSIF str[pos] = '+' THEN       INC(last);    END;1    WHILE (last < strlen) AND5          (str[last] >= '0') AND (str[last] <= '9') DO M       IF (absval > threshold) OR ((absval = threshold) AND (str[last] > '7'));
          THEN=          inttoobig := TRUE;i
       ELSE=          absval := absval * 10 + (ORD(str[last]) - ORD('0'));d
       END;       INC(last);    END;  END; IF pos = last THEN
    n := 0;    RETURN FALSE; ELSE    pos := last; )    IF inttoobig THEN absval := limit END;d    n := sign * INTEGER(absval);     RETURN TRUE;s END; END GetInteger;*  P (******************************************************************************)   PROCEDURE DoPage;)  J (* Interpret the current DVI page and fill in DVIReader's data structures.>    PSWriter routines are called at appropriate times to output2    the PostScript description of the current page. *)   BEGIN  INC(pagecount);/? WriteCard(currDVIpage);         (* show the current DVI page *)F2 Write('/'); ShowTeXPage;        (* and TeX page *) WriteLn;   BeginPage(currDVIpage);/M InterpretPage;                  (* MyPixelTableRoutine calls NewBitmapFont *)  IF pageempty THENpK    OutputPage(currDVIpage);     (* must be called even if no chars/rules *)p    DoSpecials; ELSE=    (* check that the page edges are within the paper edges *)d3    IF (minhp < paperleft)  OR (minvp < papertop) OR 8       (maxhp > paperright) OR (maxvp > paperbottom) THEN       PageOffPaper;V    END;d6    (* Sort fonts in order of increasing totalchars andF       return pointer to first unused font (for LoadFonts and DoFonts).    *)a    SortFonts(unusedfont);L    IF NOT conserveVM THEN)       LoadFonts;    END;.    OutputPage(currDVIpage);)    DoSpecials;    DoFonts;w    DoRules;  END;G EndPage(currDVIpage);           (* final PostScript for current page *)C END DoPage;t  P (******************************************************************************)   PROCEDURE ShowTeXPage;  ' (* Show current TeX page counter(s). *)p   VAR i, lastnonzero : CARDINAL;   BEGINn Write('[');  lastnonzero := 9;p= WHILE (lastnonzero > 0) AND (currTeXpage[lastnonzero] = 0) DO*G    DEC(lastnonzero);        (* find last counter with non-zero value *)e END;< (* always show \count0 but don't show trailing 0 counters *) FOR i := 0 TO lastnonzero DO    WriteInt(currTeXpage[i]);    IF i <> lastnonzero THENo       Write('.');o    END;i END; Write(']');s END ShowTeXPage;  P (******************************************************************************)   PROCEDURE PageOffPaper;t  = (* One or more page edges do not fall within the paper edges.r,    We show user just how bad the problem is. *)   BEGINs INC(warncount);N) WriteString('Page off paper (paper is ');t1 ShowDimension(paperwd); WriteString(' wide by ');e. ShowDimension(paperht); WriteString(' high)'); WriteLn; IF minhp < paperleft THEN '    WriteString('Beyond left edge by ');I$    ShowDimension(paperleft - minhp);    WriteLn;- END; IF maxhp > paperright THEN(    WriteString('Beyond right edge by ');%    ShowDimension(maxhp - paperright);     WriteLn;n END; IF minvp < papertop THEN%    WriteString('Above top edge by ');n#    ShowDimension(papertop - minvp);o    WriteLn;n END; IF maxvp > paperbottom THENl(    WriteString('Below bottom edge by ');&    ShowDimension(maxvp - paperbottom);    WriteLn;: END; END PageOffPaper;]  P (******************************************************************************)   PROCEDURE LoadFonts;  I (* For each bitmapped font that is used (and exists) on the current page, J    go thru charlist and call LoadBitmap for each character that hasn't yetF    been downloaded.  BeginBitmapFont will only be called if necessary. *)   VAR E    thisfontinfo : fontinfoptr;    (* current font info in fontlist *)eE    thischarinfo : charinfoptr;    (* current char info in charlist *)iL    thischar     : CARDINAL;       (* current index into current chartable *)G    fontopen     : BOOLEAN;        (* is thisfontinfo^.fontspec open? *)r   BEGINi thisfontinfo := fontlist;S# WHILE thisfontinfo <> unusedfont DOE6 (* SortFonts makes sure we only consider used fonts *) WITH thisfontinfo^ DO;O    (* do nothing if resident PostScript font or bitmapped font doesn't exist *)n&    IF (NOT psfont) AND fontexists THENL       fontopen := FALSE;              (* avoid opening font unnecessarily *)       thischarinfo := charlist;WO       WHILE thischarinfo <> NIL DO    (* process unloaded chars in chartable *);          WITH thischarinfo^ DO             thischar := 0;)             WHILE thischar < charcount DO**                WITH chartable[thischar] DO&                WITH pixelptr^[code] DOK                   IF (NOT loaded) AND (mapadr > 0) THEN   (* load bitmap *)s)                      IF NOT fontopen THEN /                         OpenFont(thisfontinfo);D0                         BeginBitmapFont(fontid);N                         fontopen := TRUE;                 (* only open once *)                      END;;3                      LoadBitmap(thisfontinfo,code);lN                      loaded := TRUE;                      (* only load once *)                   END;                END;T                END;'                INC(thischar);a             END;%             thischarinfo := nextchar;e
          END;a
       END;)       IF fontopen THEN CloseFontFile END;=    END;e    thisfontinfo := nextfont; END; (* WITH *)t END; (* WHILE *) END LoadFonts;  P (******************************************************************************)  0 PROCEDURE OpenFont (thisfontinfo : fontinfoptr);   BEGINt WITH thisfontinfo^ DOn!    IF OpenFontFile(fontspec) THENn       (* DEBUG-       WriteString("Loading characters for ");S       WriteString(fontspec);       WriteLn;       GUBED *)    ELSESL       (* this should never happen since we avoid loading dummy font chars *)       WriteLn;8       WriteString('Bug in OpenFont!  Could not open: ');       WriteString(fontspec);       WriteLn; Halt(error);r    END;r END;
 END OpenFont;E  P (******************************************************************************)   PROCEDURE DoSpecials;   D (* Call OutputSpecial for each \special command on the current page.G    (The speciallist is built by MySpecialRoutine during InterpretPage.)E *)   VAR temp : specialinfoptr;   BEGIN  WHILE speciallist <> NIL DO     WITH speciallist^ DOtL       (* The \special bytes are treated as a file name, possibly followed by0          a space and additional PostScript text.N          PSWriter will read this file and copy it verbatim to the output file.F          The optional text is prefixed to the file as a separate line.       *).       IF NOT OutputSpecial(special,hp,vp) THEN          INC(warncount);6          WriteString("Couldn't open \special file: ");=          WriteString(special);   (* includes optional text *)*          WriteLn;c       ELSIF stats THEN.          WriteString('\special command at (');'          ShowDimension(hp); Write(',');e/          ShowDimension(vp); WriteString('): ');*'          WriteString(special); WriteLn; 
       END;       temp := speciallist;!       speciallist := nextspecial; B       DISPOSE(temp);   (* speciallist must be NIL for next page *)    END;e END; END DoSpecials;M  P (******************************************************************************)   PROCEDURE DoFonts;  ? (* For each font that is used (and exists) on the current page,gB    call the appropriate sequence of PSWriter routines depending onE    the conserveVM flag and whether the font is bitmapped or resident.      See PSWRITER.DEF for details. *)   VARrE    thisfontinfo : fontinfoptr;    (* current font info in fontlist *);E    thischarinfo : charinfoptr;    (* current char info in charlist *)rL    thischar     : CARDINAL;       (* current index into current chartable *)   BEGIN  thisfontinfo := fontlist;p# WHILE thisfontinfo <> unusedfont DO 7 (* SortFonts makes sure we only consider used fonts! *)  WITH thisfontinfo^ DOeM    IF fontexists THEN                          (* won't be dummy font info *)        IF psfont THEN6          BeginPostScriptFont(fontname,scaledsize,mag);
       ELSE/          IF conserveVM THEN SaveVM(fontid) END;I!          BeginBitmapFont(fontid); 
       END;  E       IF conserveVM AND (NOT psfont) THEN      (* download bitmaps *))           OpenFont(thisfontinfo);"          thischarinfo := charlist;I          WHILE thischarinfo <> NIL DO          (* process unique chars *)n!             WITH thischarinfo^ DO                 thischar := 0; ,                WHILE thischar < charcount DO-                   WITH chartable[thischar] DO;)                   WITH pixelptr^[code] DOgN                      IF (NOT loaded) AND (mapadr > 0) THEN   (* load bitmap *)6                         LoadBitmap(thisfontinfo,code);P                         loaded := TRUE;                      (* but only once *)                      END;                    END;                   END;                    INC(thischar);                END;)(                thischarinfo := nextchar;             END;
          END;           CloseFontFile;:8          (* reset loaded flags to FALSE for next page *)+          FOR thischar := 0 TO maxTeXchar DOt0             pixelptr^[thischar].loaded := FALSE;
          END;r
       END;         IF psfont THEN"          thischarinfo := charlist;%          WHILE thischarinfo <> NIL DOe!             WITH thischarinfo^ DO                 thischar := 0; ,                WHILE thischar < charcount DO-                   WITH chartable[thischar] DOe)                   WITH pixelptr^[code] DOpG                      IF mapadr > 0 THEN               (* char exists *)t4                         SetPostScriptChar(CHR(code),K                                           hp,vp,      (* reference point *)tI                                           pwidth);    (* advance width *)E                      END;l                   END;                   END;                    INC(thischar);                END;I(                thischarinfo := nextchar;             END;
          END;s
       ELSE"          thischarinfo := charlist;%          WHILE thischarinfo <> NIL DO !             WITH thischarinfo^ DO                 thischar := 0; ,                WHILE thischar < charcount DO-                   WITH chartable[thischar] DOg)                   WITH pixelptr^[code] DO G                      IF mapadr > 0 THEN               (* char exists *)a0                         SetBitmapChar(CHR(code),K                                       hp,vp,          (* reference point *)WI                                       pwidth);        (* advance width *)S                      END;g                   END;                   END;                    INC(thischar);                END;T(                thischarinfo := nextchar;             END;
          END;[
       END;       EndFont;  8       IF conserveVM AND (NOT psfont) THEN RestoreVM END;    END;*    thisfontinfo := nextfont; END; (* WITH *)* END; (* WHILE *) END DoFonts;  P (******************************************************************************)   PROCEDURE DoRules;  5 (* Call SetRule for each rule on the current page. *)    VAR thisrule : CARDINAL;     thisruleinfo : ruleinfoptr;    BEGINu thisruleinfo := rulelist;) WHILE thisruleinfo <> NIL DO    WITH thisruleinfo^ DO       thisrule := 0;#       WHILE thisrule < rulecount DOi$          WITH ruletable[thisrule] DO<             SetRule(wd,ht,    (* width and height of rule *)>                     hp,vp);   (* bottom left corner of rule *)
          END;o          INC(thisrule);s
       END;       thisruleinfo := nextrule;i    END;  END; END DoRules;  P (******************************************************************************)   PROCEDURE ShowPageStats;  ; (* Show rule/font/character statistics for current page. *)C   VAR fontcount : CARDINAL;R     thisfontinfo : fontinfoptr;    BEGINHE WriteString('Total rules on current page = '); WriteCard(totalrules);I WriteLn;& WriteString('Fonts on current page:'); WriteLn; fontcount := 0;F thisfontinfo := fontlist;t WHILE thisfontinfo <> NIL DO    WITH thisfontinfo^ DO       IF fontused THEN          WriteString(fontspec);I3          IF psfont THEN ShowPtSize(scaledsize) END;NF          IF NOT fontexists THEN WriteString('   DOES NOT EXIST!') END;          INC(fontcount);J          WriteString('   total chars = '); WriteCard(totalchars); WriteLn;
       END;       thisfontinfo := nextfont;'    END;  END;D WriteString('Total fonts on current page = '); WriteCard(fontcount); WriteLn; WriteLn; END ShowPageStats;  P (******************************************************************************)   PROCEDURE ShowFinalStats;t  # (* Show some overall statistics. *)*  ? VAR fontsused, c, loadcount, loadtotal, bitmapbytes : CARDINAL;a     thisfontinfo : fontinfoptr;D   BEGINn  WriteString('Summary'); WriteLn;  WriteString('======='); WriteLn; WriteLn;; WriteString('Total pages output = '); WriteCard(pagecount);e WriteLn;A WriteString('Total pages in DVI file = '); WriteCard(totalpages);  WriteLn;A WriteString('Total fonts in DVI file = '); WriteCard(totalfonts);X WriteLn;2 (* go thru fontlist showing info for EVERY font *) fontsused := 0;  loadtotal := 0;u bitmapbytes := 0;p thisfontinfo := fontlist;p WHILE thisfontinfo <> NIL DO    WITH thisfontinfo^ DO       IF fontspeclen > 0 THENe          WriteString(fontspec);e3          IF psfont THEN ShowPtSize(scaledsize) END;n          IF fontexists THENp             INC(fontsused);p5             IF (NOT conserveVM) AND (NOT psfont) THENP                loadcount := 0;*                FOR c := 0 TO maxTeXchar DO&                   WITH pixelptr^[c] DO4                      IF loaded AND (mapadr > 0) THEN'                         INC(loadcount); A                         INC(bitmapbytes, ht * ((wd + 7) DIV 8) );l                      END;s                   END;                END;fG                WriteString('   loaded chars = '); WriteCard(loadcount);*(                INC(loadtotal,loadcount);             END;
          ELSEh.             WriteString('   DOES NOT EXIST!');
          END;,
       ELSE          WriteString(fontname);)!          WriteString(' scaled ');n&          WriteCard(TRUNC( FLOAT(mag) *G                           FLOAT(scaledsize)/FLOAT(designsize) + 0.5 ));o"          WriteString(' not used');
       END;       WriteLn;       thisfontinfo := nextfont;t    END;O END;B WriteString('Total fonts actually used = '); WriteCard(fontsused); WriteLn; IF NOT conserveVM THENC    WriteString('Total characters loaded = '); WriteCard(loadtotal);*    WriteLn;*N    WriteString('Hex digits in loaded bitmaps = 2 * '); WriteCard(bitmapbytes);    WriteLn;h END; END ShowFinalStats;   P (******************************************************************************)  , PROCEDURE ShowPtSize (scaledsize : INTEGER);  O (* Show given font size (in DVI units) in terms of (possibly magnified) pts. *)   * VAR realdim : REAL;   fracpart : CARDINAL;   BEGINe WriteString(' at ');G realdim := (FLOAT(scaledsize) / FLOAT(10000H)) * (FLOAT(mag) / 1000.0);p4 (* show realdim to an accuracy of 1 decimal place *) IF ABS(realdim) < 0.05 THENp    WriteString('0'); ELSE    IF realdim < 0.0 THEN       Write('-');'       realdim := ABS(realdim);    END;pC    realdim := realdim + 0.05;     (* round up to 1 decimal place *) 2    WriteCard(TRUNC(realdim));     (* whole part *)L    fracpart := TRUNC((realdim - FLOAT(TRUNC(realdim))) * 10.0);   (* 0..9 *)    IF fracpart > 0 THEN*       Write('.');*       WriteCard(fracpart);    END;D END; WriteString('pt'); END ShowPtSize;t  P (******************************************************************************)   BEGIN 	 TopLevel;t
 END PSDVI.