 MODULE PSPRINT;   # (* Author:         Andrew Trevorrow K    Implementation: University of Hamburg Modula-2 under VAX/VMS version 4.x     Date Started:   July, 1986 0    Released:       September, 1986 (version 1.0)      Description: G    PSPRINT can print a variety of file formats on a range of PostScript K    printers.  See the PSPRINT User Guide and System Guide for more details. L    Much of the command line parsing is done by DCL according to PSPRINT.CLD.M    Most of the semantic checking is done here.  If everything seems okay then )    we run a device-specific command file.   D    If /DEVICE=LW then we do @TEX_PS:LW_PRINT P1 P2 P3 P4 P5 P6 P7 P8    where&       P1 = complete file specification9       P2 = file format (DVI or PS or TEXT or TWO or WIDE)        P3 = options for PSDVI       P4 = options for PRINT'       P5 = /NOTE value ("" if not used) (       P6 = /COPIES value (1 if not used))       P7 = /OUTPUT value ("" if not used) C       P8 = "bbbb" where b = Y or N and represents the status of the G            boolean qualifiers /DELETE, /LANDSCAPE, /BANNER, /MANUALFEED   H    If /DEVICE=PS40 then we do @TEX_PS:PS40_PRINT P1 P2 P3 P4 P5 P6 P7 P8"    where P1 to P7 are as above butA       P8 = "bb" where b = Y or N and represents the status of the 1            boolean qualifiers /DELETE, /LANDSCAPE   H    If /DEVICE=LINO then we do @TEX_PS:LINO_PRINT P1 P2 P3 P4 P5 P6 P7 P8"    where P1 to P7 are as above butF       P8 = "bbbbsss" where b = Y or N and represents the status of theE            boolean qualifiers /DELETE, /LANDSCAPE, /CUTMARKS, /LOWRES O            and sss = /SIZE value (PSPRINT.CLD defines legal values and default)   2    Note that DCL allows a maximum of 8 parameters.      Revised:     January, 1987J  - The /REVERSE qualifier is no longer used.  The order in which DVI pagesD    are translated (by PSDVI) is best left specified in the COM file.;    (Note that /NOREVERSE on PSPRINT never actually worked!) (  - Released version 1.1 in January, 1987  0    November, 1987 (while at The Open University)J  - Added /DEVICE qualifier.  PSPRINT needs to run a different command file;    for each type of PostScript printer currently supported. K  - Added /CONSERVE_VM and /NOCONSERVE_VM qualifiers.  If neither is present D    then a default setting is used that depends on the /DEVICE value.D  - Added Linotronic-specific qualifiers (/CUTMARKS, /LOWRES, /SIZE).;    These are simply ignored if /DEVICE does not equal LINO. )  - Released version 2.0 in December, 1987   1    June--August, 1988 (while at Aston University) ?  - Added /QUEUE qualifier for sites with more than one printer. 5  - Added /NOBANNER and /MANUALFEED qualifiers for LW. %  - Added /TWO and /WIDE text formats. L  - Added /OUTPUT qualifer so user can save PostScript output in a given file(    rather than send it to a print queue.M  - The /REVERSE qualifier is back in again!  It is treated like /CONSERVE_VM. >  - Added /INCREMENT qualifier to simplify both-sided printing.I  - Added /FONT_DIRECTORY qualifier to allow users to override the default I    font directory used by PSDVI.  This could be handy for Metafont users. C  - Added more PSDVI qualifiers: /HOFFSET, /VOFFSET, /XSIZE, /YSIZE, :    /RESOLUTION, /PSPREFIX, /TFM_DIRECTORY and /DUMMY_FONT.2    Most users will never need to use any of these.D  - All these new qualifiers have required some reorganisation of the4    parameters passed into the various command files.'  - Released version 3.0 in August, 1988  *)   FROM VMS IMPORT     SYS$EXIT;  $ FROM CommandLanguageInterface IMPORT    CLI$PRESENT, CLI$GET_VALUE;  ' FROM CommonInputOutputProcedures IMPORT     LIB$DO_COMMAND;   FROM FileSystem IMPORT!    File, Open, Name, Done, Close;    FROM InOut IMPORT     Write, WriteString, WriteLn;      CONST :    NULL = 0C;   (* SYSDEP: terminates a non-full string *)   TYPE"    string = ARRAY [0..79] OF CHAR;   VAR )    filespec, ext, device, value : string;     status  : CARDINAL;    f       : File;$    command : ARRAY [0..255] OF CHAR;8    format  : (dvifile,psfile,textfile,twofile,widefile);    printer : (LINO,LW,PS40);    P (******************************************************************************)  . PROCEDURE GetValue (qualifier : ARRAY OF CHAR;9                     VAR s     : ARRAY OF CHAR) : BOOLEAN;   I (* GetValue should only be called for those qualifiers that have a value. C    If given qualifier is present then we get value and return TRUE,     otherwise FALSE.  *)   VAR i, status : CARDINAL;    BEGIN # IF ODD(CLI$PRESENT(qualifier)) THEN J    status := CLI$GET_VALUE(qualifier,s);   (* PSPRINT.CLD ensures value *)    i := HIGH(s);G    WHILE (i > 0) AND (s[i] = ' ') DO       (* remove trailing blanks *) G       s[i] := NULL;                        (* SYSDEP: pad with NULLs *) 
       DEC(i);     END;     RETURN TRUE;  ELSE    s[0] := NULL;    RETURN FALSE; END;
 END GetValue;   P (******************************************************************************)  / PROCEDURE ExplicitExt (fname   : ARRAY OF CHAR; :                        VAR ext : ARRAY OF CHAR) : BOOLEAN;  L (* SYSDEP: VAX/VMS files have an extension of the form ".xxx...xxx;version".=    If the given file specification contains an extension then J    TRUE is returned (and ext will be string after '.' but before any ';'). *)  & VAR i, l, pos : CARDINAL;   ch : CHAR;   BEGIN  pos := LEN(fname);	 l := pos;  ext[0] := NULL; E WHILE pos > 0 DO       (* search backwards looking for . or : or ] *)     DEC(pos);    ch := fname[pos];.    IF ch = '.' THEN    (* extract extension *)
       i := 0;        INC(pos);         WHILE (pos <= HIGH(fname))?             AND (fname[pos] <> NULL) AND (fname[pos] <> ';') DO           ext[i] := fname[pos];          INC(i); INC(pos);
       END;0       IF i <= HIGH(ext) THEN ext[i] := NULL END;       RETURN TRUE;I    ELSIF (ch = ':') OR (ch = ']') THEN   (* don't need to look further *)        RETURN FALSE;     END;  END;
 RETURN FALSE;  END ExplicitExt;  P (******************************************************************************)  > PROCEDURE Append (VAR s1 : ARRAY OF CHAR; s2 : ARRAY OF CHAR);   (* Append s2 to s1. *)   VAR i, j : CARDINAL;   BEGIN 
 i := LEN(s1);  j := 0; @ WHILE (i <= HIGH(s1)) AND (j <= HIGH(s2)) AND (s2[j] <> NULL) DO    s1[i] := s2[j];
    INC(i);
    INC(j); END; (* check for overflow *)> IF (i > HIGH(s1)) AND (j <= HIGH(s2)) AND (s2[j] <> NULL) THEN?    WriteString('No room to append '); WriteString(s2); WriteLn; 
    ErrorHalt;  END;( IF i <= HIGH(s1) THEN s1[i] := NULL END; END Append;   P (******************************************************************************)  C PROCEDURE Equal (s1 : ARRAY OF CHAR; s2 : ARRAY OF CHAR) : BOOLEAN;    (* Return TRUE iff s1 = s2. *)   VAR i : CARDINAL;    BEGIN  i := 0;  LOOP@    IF (i > HIGH(s1)) OR (s1[i] = NULL) THEN      (* end of s1 *).       RETURN (i > HIGH(s2)) OR (s2[i] = NULL);@    ELSIF (i > HIGH(s2)) OR (s2[i] = NULL) THEN   (* end of s2 *)       RETURN s1[i] = NULL;    ELSIF s1[i] <> s2[i] THEN       RETURN FALSE;     END; 
    INC(i); END;
 END Equal;  P (******************************************************************************)   PROCEDURE ErrorHalt;  G (* Call SYS$EXIT with a magic number that will set ERROR status without $    causing any spurious CLI message. *)   VAR dummy : CARDINAL;    BEGIN  dummy := SYS$EXIT(10000002H);  END ErrorHalt;  P (******************************************************************************)   PROCEDURE AppendFilespec;    BEGIN % IF GetValue('FILESPEC',filespec) THEN P    IF NOT ExplicitExt(filespec,ext) THEN   (* assume DVI file if no extension *)<       Append(filespec,'.DVI');             (* append .DVI *)       format := dvifile;    ELSIF Equal(ext,'DVI') THEN       format := dvifile;    ELSIF Equal(ext,'PS') THEN @       format := psfile;                    (* PostScript file *)    ELSE C       format := textfile;                  (* ordinary text file *)     END;     Open(f,filespec,FALSE);B    IF Done() THEN                          (* given file exists *)H       Name(f,filespec);                    (* full file specification *)       Append(command,filespec);        Close(f);     ELSE $       WriteString("Couldn't open ");1       WriteString(filespec); Write('!'); WriteLn;        ErrorHalt;    END;  ELSEF    (* PSPRINT.CLD should prevent this ever happening, but play safe *)+    WriteString('File not given!'); WriteLn; 
    ErrorHalt;  END; END AppendFilespec;   P (******************************************************************************)   PROCEDURE AppendFormat;   I (* /DVI, /PS, /TEXT, /TWO or /WIDE can override the implicit file format. ?    PSPRINT.CLD should ensure that only one of these is allowed.  *)   BEGIN  IF ODD(CLI$PRESENT('DVI')) THEN     format := dvifile; ! ELSIF ODD(CLI$PRESENT('PS')) THEN     format := psfile;# ELSIF ODD(CLI$PRESENT('TEXT')) THEN     format := textfile;" ELSIF ODD(CLI$PRESENT('TWO')) THEN    format := twofile; # ELSIF ODD(CLI$PRESENT('WIDE')) THEN     format := widefile; END; CASE format OF%    dvifile  : Append(command,' DVI'); $  | psfile   : Append(command,' PS');&  | textfile : Append(command,' TEXT');%  | twofile  : Append(command,' TWO'); &  | widefile : Append(command,' WIDE'); ELSE5    WriteString('BUG! Unknown file format!'); WriteLn; 
    ErrorHalt;  END; END AppendFormat;   P (******************************************************************************)  * PROCEDURE DVIcheck (qual : ARRAY OF CHAR);  : (* The given qualifier is only allowed with a DVI file. *)   BEGIN  IF format <> dvifile THEN     WriteString(qual); =    WriteString(' is only allowed with a DVI file!'); WriteLn; 
    ErrorHalt;  END;
 END DVIcheck;   P (******************************************************************************)   PROCEDURE AppendPSDVIoptions;   < (* Check for the PSDVI qualifiers allowed by PSPRINT.CLD. *)   BEGIN  Append(command,' "');  IF GetValue('PAGES',value) THEN J    DVIcheck('/PAGES');   Append(command,'/PAG=');   Append(command,value); END;# IF GetValue('INCREMENT',value) THEN J    DVIcheck('/INC');     Append(command,'/INC=');   Append(command,value); END;' IF GetValue('MAGNIFICATION',value) THEN J    DVIcheck('/MAG');     Append(command,'/MAG=');   Append(command,value); END; IF GetValue('UNITS',value) THEN J    DVIcheck('/UNITS');   Append(command,'/UN=');    Append(command,value); END;! IF GetValue('HOFFSET',value) THEN J    DVIcheck('/HOFF');    Append(command,'/HOFF=');  Append(command,value); END;! IF GetValue('VOFFSET',value) THEN J    DVIcheck('/VOFF');    Append(command,'/VOFF=');  Append(command,value); END; IF GetValue('XSIZE',value) THEN J    DVIcheck('/XSIZE');   Append(command,'/XSIZ=');  Append(command,value); END; IF GetValue('YSIZE',value) THEN J    DVIcheck('/YSIZE');   Append(command,'/YSIZ=');  Append(command,value); END;' IF GetValue('TFM_DIRECTORY',value) THEN J    DVIcheck('/TFM');     Append(command,'/TFM=');   Append(command,value); END;" IF GetValue('PSPREFIX',value) THENJ    DVIcheck('/PSPRE');   Append(command,'/PSPR=');  Append(command,value); END;( IF GetValue('FONT_DIRECTORY',value) THENJ    DVIcheck('/FONT');    Append(command,'/FONT=');  Append(command,value); END;$ IF GetValue('DUMMY_FONT',value) THENJ    DVIcheck('/DUMMY');   Append(command,'/DUMM=');  Append(command,value); END;$ IF GetValue('RESOLUTION',value) THENJ    DVIcheck('/RES');     Append(command,'/RES=');   Append(command,value); END;! IF ODD(CLI$PRESENT('STATS')) THEN /    DVIcheck('/STATS');   Append(command,'/ST');  END;' IF ODD(CLI$PRESENT('CONSERVE_VM')) THEN 1    DVIcheck('/CONS');    Append(command,'/CONS'); , ELSIF ODD(CLI$PRESENT('NOCONSERVE_VM')) THEN3    DVIcheck('/NOCONS');  Append(command,'/NOCONS');  ELSE;    (* default setting is different for different devices *)     IF printer = LINO THEN C       Append(command,'/CONS');         (* default for Linotronic *)     ELSE K       Append(command,'/NOCONS');       (* default for LaserWriter & PS40 *)     END;  END;# IF ODD(CLI$PRESENT('REVERSE')) THEN 0    DVIcheck('/REV');     Append(command,'/REV');( ELSIF ODD(CLI$PRESENT('NOREVERSE')) THEN2    DVIcheck('/NOREV');   Append(command,'/NOREV'); ELSE;    (* default setting is different for different devices *)d    IF printer = LW THENoD       Append(command,'/REV');          (* default for LaserWriter *)    ELSEsD       Append(command,'/NOREV');        (* default for Lino & PS40 *)    END;  END; Append(command,'"'); END AppendPSDVIoptions;   P (******************************************************************************)   PROCEDURE AppendPRINToptions;N   BEGIN  Append(command,' "');h> IF ODD(CLI$PRESENT('NOTIFY')) THEN         (* /NOTIFY given *)    Append(command,'/NOTI');e ELSE    Append(command,'/NONOTI');X END;E IF GetValue('FORM',value) THEN             (* /FORM=formtype given *)i    Append(command,'/FORM=');    Append(command,value);O END;C IF GetValue('QUEUE',value) THEN            (* /QUEUE=qname given *)     Append(command,'/QUE=');     Append(command,value);v END; Append(command,'"'); END AppendPRINToptions;   P (******************************************************************************)   PROCEDURE AppendNote;r   VAR i : INTEGER;   BEGINR Append(command,' "');  IF GetValue('NOTE',value) THEN    IF printer = PS40 THEN6F       (* PrintServer 40 handles any (,),\ characters in /NOTE value *)       Append(command,value);    ELSE /       (* For LaserWriter and Linotronic we must @          make sure that any (,),\ characters are prefixed with \E          otherwise we'll probably get a PostScript error when storingeL          the /NOTE value into a string.  This kludge should not be necessaryD          for the other string values that appear on the banner page.       *)#       FOR i := 0 TO LEN(value)-1 DOu          CASE value[i] OFl'             '(' : Append(command,'\(');s'           | ')' : Append(command,'\)');u'           | '\' : Append(command,'\\');w+          ELSE     Append(command,value[i]);i
          END;c
       END;    END;. END; Append(command,'"'); END AppendNote;c  P (******************************************************************************)   PROCEDURE AppendCopies;    BEGIN/  IF GetValue('COPIES',value) THEN    Append(command,' ');     Append(command,value);o ELSE    Append(command,' 1'); END; END AppendCopies;E  P (******************************************************************************)   PROCEDURE AppendOutput;h   BEGIN   IF GetValue('OUTPUT',value) THEN    Append(command,' ');     Append(command,value);a ELSE    Append(command,' ""');  END; END AppendOutput;a  P (******************************************************************************)   PROCEDURE AppendLWFlags;   BEGINi Append(command,' "');p" IF ODD(CLI$PRESENT('DELETE')) THEN8    Append(command,'Y');                    (* /DELETE *) ELSE    Append(command,'N');a END;% IF ODD(CLI$PRESENT('LANDSCAPE')) THEN ;    Append(command,'Y');                    (* /LANDSCAPE *)/ ELSE    Append(command,'N');a END;" IF ODD(CLI$PRESENT('BANNER')) THEN8    Append(command,'Y');                    (* /BANNER *) ELSE    Append(command,'N');a END;& IF ODD(CLI$PRESENT('MANUALFEED')) THEN<    Append(command,'Y');                    (* /MANUALFEED *) ELSE    Append(command,'N');S END; Append(command,'"'); END AppendLWFlags;  P (******************************************************************************)   PROCEDURE AppendLINOFlags;   BEGINl Append(command,' "');a" IF ODD(CLI$PRESENT('DELETE')) THEN8    Append(command,'Y');                    (* /DELETE *) ELSE    Append(command,'N');s END;% IF ODD(CLI$PRESENT('LANDSCAPE')) THEN;;    Append(command,'Y');                    (* /LANDSCAPE *)$ ELSE    Append(command,'N');u END;$ IF ODD(CLI$PRESENT('CUTMARKS')) THEN:    Append(command,'Y');                    (* /CUTMARKS *) ELSE    Append(command,'N');e END;" IF ODD(CLI$PRESENT('LOWRES')) THEN8    Append(command,'Y');                    (* /LOWRES *) ELSE    Append(command,'N');  END;< IF GetValue('SIZE',value) THEN             (* /SIZE value *)    Append(command,value);  ELSEP    Append(command,'???');                  (* PSPRINT.CLD should prevent this *) END; Append(command,'"'); END AppendLINOFlags;  P (******************************************************************************)   PROCEDURE AppendPS40Flags;   BEGIN  Append(command,' "'); " IF ODD(CLI$PRESENT('DELETE')) THEN8    Append(command,'Y');                    (* /DELETE *) ELSE    Append(command,'N');  END;% IF ODD(CLI$PRESENT('LANDSCAPE')) THENl;    Append(command,'Y');                    (* /LANDSCAPE *)u ELSE    Append(command,'N');D END; Append(command,'"'); END AppendPS40Flags;  P (******************************************************************************)   BEGINA! IF GetValue('DEVICE',device) THENt    IF Equal(device,'LW') THEN:       printer := LW;%       command := '@TEX_PS:LW_PRINT '; "    ELSIF Equal(device,'LINO') THEN       printer := LINO;'       command := '@TEX_PS:LINO_PRINT ';l"    ELSIF Equal(device,'PS40') THEN       printer := PS40;'       command := '@TEX_PS:PS40_PRINT ';     ELSExI       (* PSPRINT.CLD should prevent this ever happening, but play safe *)R0       WriteString('Unexpected /DEVICE value: ');#       WriteString(device); WriteLn;i       ErrorHalt;    END;s ELSEF    (* PSPRINT.CLD should prevent this ever happening, but play safe *)6    WriteString('/DEVICE value not present!'); WriteLn;
    ErrorHalt;  END;% AppendFilespec;              (* P1 *) % AppendFormat;                (* P2 *) % AppendPSDVIoptions;          (* P3 *)f% AppendPRINToptions;          (* P4 *) % AppendNote;                  (* P5 *)(% AppendCopies;                (* P6 *) % AppendOutput;                (* P7 *)I8 CASE printer OF              (* P8 is device-specific *)    LW   : AppendLWFlags; |  LINO : AppendLINOFlags; |  PS40 : AppendPS40Flags; END; (* DEBUG WriteString(command); WriteLn; GUBED *)" status := LIB$DO_COMMAND(command); (* we should never get here *)= WriteString('BUG! Error in DO_COMMAND!'); WriteLn; ErrorHalt;N END PSPRINT.