#ifndef _global_h
#	include "global.h"
#endif

#ifndef _cannon_h
#	include "cannon.h"
#endif
#ifndef _ball_h
#	include "ball.h"
#endif
#ifndef _wall_h
#	include "wall.h"
#endif
#ifndef _graph_h
#	include "graph.h"
#endif
#ifndef _mover_h
#	include "mover.h"
#endif

//
// Voreinstellungen
//

Cannon::Cannon(double wx, double wy) :
Billard(wx,wy)
{
	w1 = w2 = r = 0;

	InitArea( TableWidth, TableHeight );
	SelectTable(-1);
	red_col		= AddBallColor( "red4" );
	white_col	= AddBallColor( "bisque" );
	yellow_col	= AddBallColor( "DarkGoldenrod1" );
}

Cannon::~Cannon() {
	if (w1)		delete w1;
	if (w2)		delete w2;
	if (r)		delete r;
}

const Real & Cannon::GetNormalBallSize() const {
	return BallRadius;
}



void Cannon::InitPlayground() {

	Billard::InitPlayground();
	BallRadius = m->GetActRadius();
	Billard::InitTable();			// Wandbegrenzung

	w1 = new Ball( AreaOffX()+AreaWidth()*0.25, AreaOffY()+AreaHeight()/2.0, 0, 0, BallRadius );
	w1->state = new BallState( m, white_col, w1->P() );
	w2 = new Ball( AreaOffX()+AreaWidth()*0.25, AreaOffY()+AreaHeight()/4.0, 0, 0, BallRadius );
	w2->state = new BallState( m, yellow_col, w2->P() );
	r  = new Ball( AreaOffX()+AreaWidth()*0.75, AreaOffY()+AreaHeight()/2.0, 0, 0, BallRadius );
	r->state = new BallState( m, red_col, r->P() );
}

void Cannon::DrawBackground() const {
	Billard::DrawBackground();
	SetBgColor(table_line_col);
	FillCircle( AreaOffX()+AreaWidth()*0.25, AreaOffY()+AreaHeight()*0.25, 1.0 );
	FillCircle( AreaOffX()+AreaWidth()*0.25, AreaOffY()+AreaHeight()*0.50, 1.0 );
	FillCircle( AreaOffX()+AreaWidth()*0.25, AreaOffY()+AreaHeight()*0.75, 1.0 );
	FillCircle( AreaOffX()+AreaWidth()*0.50, AreaOffY()+AreaHeight()*0.50, 1.0 );
	FillCircle( AreaOffX()+AreaWidth()*0.75, AreaOffY()+AreaHeight()*0.50, 1.0 );
}
