
extern Pixmap	pointer_pmap;							// aus Modul graph.C ...
extern int		pointer_off_x, pointer_off_y;		//    dto.

#ifndef _cursor_h
#	include "cursor.h"
#endif

PBall::PBall( PBallType type, char *disp_name ) :
	PBallTop( type )
{
//
// Remote Display ffnen
//
	rem_dpy = XOpenDisplay( disp_name );
	if (!rem_dpy) {
		fprintf( stderr, "ERROR: can't open display '%s'.\n", disp_name );
		exit(0);
	}
	scr=DefaultScreen(rem_dpy);
//
// Cursor berdefinieren
//
Cursor	cursor;
Pixmap	pixmap;
XColor	col1;
	pixmap = XCreateBitmapFromData(rem_dpy,
					RootWindow( rem_dpy, scr ),
					cursor_bits, cursor_width, cursor_height );
	XParseColor(rem_dpy,DefaultColormap(rem_dpy,scr), "black", &col1 );
	cursor = XCreatePixmapCursor( rem_dpy, pixmap, pixmap, &col1, &col1,
							cursor_x_hot, cursor_y_hot );
	XGrabPointer( rem_dpy, RootWindow( rem_dpy, scr ),
			False, (unsigned)(ButtonPressMask|ButtonReleaseMask|PointerMotionMask),
			GrabModeAsync, GrabModeAsync, None, cursor, CurrentTime );

//
// Transformation festlegen
//
	w2n_x = DisplayWidth( rem_dpy,scr)/world_x;
	w2n_y = DisplayHeight(rem_dpy,scr)/world_y;
//
// Pointer auf Bildschirm initialisieren.
//
	x_old = -20;	// ausserhalb des Bildschirms (wegen erstem CopyArea)
	y_old = -20;

	XFreePixmap( rem_dpy, pixmap );
	XFreeCursor( rem_dpy, cursor );
}

PBall::~PBall() {
//
// Pointer vom Bildschirm lschen
//
	XCopyArea( dpy, pointer_pmap, win, gc_cursor, 0, 0, 16, 16,
					x_old-pointer_off_x, y_old-pointer_off_y );

	XSync( rem_dpy, 0 );
	XCloseDisplay( rem_dpy );
}

void PBall::Update() {
XEvent	event;

	while (XEventsQueued( rem_dpy, QueuedAfterFlush )) {
		XNextEvent( rem_dpy, &event );
		switch( event.xany.type ) {
		case MotionNotify:
			while( XCheckMaskEvent( rem_dpy, PointerMotionMask, &event ));
			PointerMoveTo(Vec2(Real(event.xmotion.x)/w2n_x,
												Real(event.xmotion.y)/w2n_y));
			break;
		case ButtonPress:
			Press( event.xbutton.button );
			break; // case ButtonPress

		case ButtonRelease:
			Release( event.xbutton.button );
		} // switch(event.type)
	}

	PBallTop::Update();
}


void PBall::Warp( const Vec2 &dest ) {
XEvent	event;

	XWarpPointer( rem_dpy, None, RootWindow( rem_dpy, scr ),
			0,0,0,0 ,
			(int)(dest.X()*w2n_x),
			(int)(dest.Y()*w2n_y) );

	if (mode&UsingTool)	MoveAimingTool();

	XSync( rem_dpy, 0 );
	while( XCheckMaskEvent( rem_dpy, PointerMotionMask, &event ));
}


void PBall::RedrawPointer() {
	XCopyArea( dpy, pointer_pmap, win, gc_cursor, 0, 0, 16, 16,
					x_old-pointer_off_x, y_old-pointer_off_y );
}

void PBall::SetPointer( int x, int y ) {
	XCopyArea( dpy, pointer_pmap, win, gc_cursor, 0, 0, 16, 16,
					x_old-pointer_off_x, y_old-pointer_off_y );
	x_old = x;
	y_old = y;
//	RedrawPointer:
	XCopyArea( dpy, pointer_pmap, win, gc_cursor, 0, 0, 16, 16,
					x_old-pointer_off_x, y_old-pointer_off_y );
}
