$!-----------------------------------------------------------------------------
$! HTTPD80.COM
$!
$! A DCL "wrapper" for the HTTPd image
$!
$! 22-JUN-98  MGD  minor modification for v5.1
$! 07-FEB-98  MGD  modified for v5.0
$! ??-???-??  MGD  long unrecorded pre-history :^)
$!-----------------------------------------------------------------------------
$!
$! SET VERIFY
$ SET NOCONTROL=Y
$ SET NOON
$ NODENAME = F$GETSYI("NODENAME")
$ PORT = 80
$!
$! (only needed if multiple servers different within the one system/cluster)
$! DEFINE /JOB HTTPD$AUTH HTTPD$AUTH'PORT'
$! DEFINE /JOB HTTPD$CONFIG HTTPD$CONFIG'PORT'
$! DEFINE /JOB HTTPD$MAP HTTPD$MAP'PORT'
$! DEFINE /JOB HTTPD$MSG HTTPD$MSG'PORT'
$!
$ DEFINE /PROCESS HTTPD$LOG "HT_LOGS:''NODENAME'_''PORT'_ACCESS.LOG"
$!
$ HTTPD = "$HTTPD$EXE"
$ ERROR_COUNT = 0
$ HTTPD_LOOP:
$    WRITE SYS$OUTPUT F$TIME()
$!   (umcomment the appropriate qualifier if using SYSUAF authentication)
$    HTTPD /PRIORITY=4 /PORT='PORT' !/SYSUAF!=(SSL,ID) !/PROFILE
$!   (non-error exit, must be a restart, loop immediately)
$    IF $STATUS THEN GOTO HTTPD_LOOP
$!   (error exit, gradually extend the period before restarting the server)
$    ERROR_COUNT = ERROR_COUNT + 1
$    WAIT_HH = ERROR_COUNT / 3600
$    WAIT_MM = (ERROR_COUNT - (WAIT_HH * 3600)) / 60
$    WAIT_SS = ERROR_COUNT - (WAIT_HH * 3600) - (WAIT_MM * 60)
$    WAIT 00:'WAIT_MM':'WAIT_SS'
$    GOTO HTTPD_LOOP
$!END_HTTPD_LOOP:
$!
$ STOP/ID=0
$!-----------------------------------------------------------------------------
