$!-----------------------------------------------------------------------------
$! STARTUP.COM
$!
$! WASD (HFRD) VMS Hypertext Services, Copyright (c) 1996-1998 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it
$! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! Example WASD HTTPd server startup procedure.
$! This may do most of what is needed for a "vanilla" installation.
$! Use it as such or just as a template.
$! The first section contains some booleans that can be modified.
$!
$! If both UCX and NETLIB are available defaults to UCX unless explicitly set.
$! If an SSL image is available executes that unless explicitly set.
$! Detects VMS V7.n and uses SYS$TIMEZONE_DIFFERENTIAL for GMT unless set.
$! HT_ROOT logical is generated from the location of this procedure.
$!
$! If the procedure STARTUP_LOCAL.COM exists in the same directory as this
$! procedure then it is executed after all this procedure's setup and
$! immediately before the server is actually started.  Local setup can be
$! customized in that procedure leaving this one virtual or completely intact.
$! For instance, the local startup should be used for defining local logicals,
$! installing local scripts, etc.
$!
$! 27-JUN-98  MGD  modified for v5.1
$! 07-FEB-98  MGD  modified for v5.0
$! ??-???-??  MGD  long unrecorded pre-history :^)
$!-----------------------------------------------------------------------------
$!
$ SAY = "WRITE SYS$OUTPUT"
$ PROCEDURE = F$ENVIRONMENT("PROCEDURE")
$ PROC_DEVICE = F$PARSE(PROCEDURE,,,"DEVICE","NO_CONCEAL")
$ PROC_DIRECTORY = F$PARSE(PROCEDURE,,,"DIRECTORY","NO_CONCEAL")
$!
$ SAY "%HTTPD-I-STARTUPROC, begin"
$!
$!(uncomment/set the following symbol if both UCX and NETLIB are available)
$!! USE_NETLIB = 1
$!
$!(uncomment and set the following symbol to explicitly specify one or other)
$!! PROVIDE_SSL = 0
$!(it is recommended a site-specific certificate be generated and placed into)
$!(HT_ROOT:[LOCAL], the local startup can redefine the HTTPD$SSL_CERT logical)
$!(to point at this site certificate)
$ SSL_SERVER_CERTIFICATE = "HT_ROOT:[EXAMPLE]HTTPD.PEM"
$!
$!(uncomment and set the following symbol to explicitly set HT_ROOT logical)
$!! HT_ROOT = "device:[dir.dir.]"
$!
$!(uncomment and set the following symbol to explicitly set HTTPD$GMT logical)
$!(this should be done if the system is not using VMS V7.n)
$!(to override startup messages and use SYS$TIMEZONE_DIFFERENTIAL set to "")
$!! HTTPD_GMT = "+09:30"
$!
$!(change to 1 to start the DECnet/OSU scripting)
$ PROVIDE_DECNET = 0
$!
$! -----------------
$! CHECK TCPIP AGENT
$! -----------------
$!
$ IF F$TYPE(USE_NETLIB) .EQS. ""
$ THEN
$    IF F$TRNLNM("UCX$DEVICE","LNM$SYSTEM") .NES. "" .AND. -
        F$TRNLNM("NETLIB_SHR","LNM$SYSTEM") .EQS. "" -
        THEN USE_NETLIB = 0
$    IF F$TRNLNM("NETLIB_SHR","LNM$SYSTEM") .NES. "" .AND. -
        F$TRNLNM("UCX$DEVICE","LNM$SYSTEM") .EQS. "" -
        THEN USE_NETLIB = 1
$ ENDIF
$ IF F$TYPE(USE_NETLIB) .EQS. ""
$ THEN
$    USE_NETLIB = 0
$    SAY "%HTTPD-I-STARTUPROC, both UCX and NETLIB available, defaulting to UCX"
$ ENDIF
$!
$! -------------------------
$! START NETLIB IF NECESSARY
$! -------------------------
$!
$ IF USE_NETLIB .AND. F$TRNLNM("NETLIB_SHRXFR") .EQS. "" -
     THEN @SYS$STARTUP:NETLIB_STARTUP.COM
$!
$! ---------------------
$! DEFINE HTTPd LOGICALS
$! ---------------------
$!
$ IF F$TYPE(HT_ROOT) .EQS. ""
$ THEN
$!   (derive from location of this procedure, assumes it's in HT_ROOT tree!)
$    HT_ROOT = PROC_DEVICE +-
        (PROC_DIRECTORY --
         F$EXTRACT(F$LOCATE("HT_ROOT",PROC_DIRECTORY),999,PROC_DIRECTORY)) +-
        "HT_ROOT.]"
$ ENDIF
$ DEFINE /NOLOG /SYSTEM /EXEC /TRANSLATION=CONCEALED HT_ROOT 'HT_ROOT'
$ IF F$SEARCH("HT_ROOT:[000000]*.*") .EQS. ""
$ THEN
$    SAY "%HTTPD-E-STARTUPROC, problem with HT_ROOT logical"
$    EXIT
$ ENDIF
$!
$ SCRIPT_ROOT = HT_ROOT - ".]" + ".SCRIPT.]"
$ DEFINE /NOLOG /SYSTEM /EXEC HT_SCRIPT HT_ROOT:[SCRIPT]
$ SCRIPT_LOCAL_ROOT = HT_ROOT - ".]" + ".SCRIPT_LOCAL.]"
$ DEFINE /NOLOG /SYSTEM /EXEC HT_SCRIPT_LOCAL HT_ROOT:[SCRIPT_LOCAL]
$ JAVA_ROOT = HT_ROOT - ".]" + ".JAVA.]"
$ DEFINE /NOLOG /SYSTEM /EXEC HT_JAVA HT_ROOT:[JAVA]
$!
$ IF F$GETSYI("ARCH_NAME") .EQS. "VAX"
$ THEN
$    DEFINE /NOLOG /SYSTEM /EXEC HT_EXE HT_ROOT:[VAX]
$    EXE_ROOT = HT_ROOT - ".]" + ".VAX.]"
$ ELSE
$    DEFINE /NOLOG /SYSTEM /EXEC HT_EXE HT_ROOT:[AXP]
$    EXE_ROOT = HT_ROOT - ".]" + ".AXP.]"
$ ENDIF
$ DEFINE /NOLOG /SYSTEM /EXEC HT_AXP HT_ROOT:[AXP]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_VAX HT_ROOT:[VAX]
$!
$ DEFINE /NOLOG /SYSTEM /EXEC /TRANSLATION=(CONCEALED) -
         CGI-BIN 'EXE_ROOT','SCRIPT_LOCAL_ROOT','SCRIPT_ROOT','JAVA_ROOT'
$!
$ DEFINE /NOLOG /SYSTEM /EXEC HT_AUTH HT_ROOT:[LOCAL]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_LOCAL HT_ROOT:[LOCAL]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_LOGS HT_ROOT:[LOG]
$ DEFINE /NOLOG /SYSTEM /EXEC HT_SERVER_LOGS HT_ROOT:[LOG.SERVER]
$!
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$AUTH HT_ROOT:[LOCAL]HTTPD$AUTH.CONF
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$CONFIG HT_ROOT:[LOCAL]HTTPD$CONFIG.CONF
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$MAP HT_ROOT:[LOCAL]HTTPD$MAP.CONF
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$MSG HT_ROOT:[LOCAL]HTTPD$MSG.CONF
$!
$ IF F$TYPE(HTTPD_GMT) .EQS. ""
$ THEN
$    IF F$EXTRACT(1,1,F$GETSYI("VERSION")) .LT. 7
$    THEN
$       SAY "%HTTPD-E-STARTUPROC, unreliable UTC time (set HTTPD_GMT symbol)"
$       EXIT
$    ENDIF
$ ELSE
$    IF HTTPD_GMT .NES. "" -
        THEN DEFINE /NOLOG /SYSTEM /EXEC HTTPD$GMT "''HTTPD_GMT'"
$ ENDIF
$!
$! --------------------
$! DECNET/OSU SCRIPTING
$! --------------------
$!
$ IF PROVIDE_DECNET
$ THEN
$!
$    SAY "%HTTPD-I-STARTUPROC, DECnet/OSU scripting"
$!
$!   (ensure netserver.log files can be created in the HTTPd server directory)
$    SET SECURITY HT_ROOT:[000000]HTTP$SERVER.DIR -
         /ACL=((IDENT=HTTP$SERVER,ACCESS=R+W+E, OPTIONS=DEFAULT), -
               (IDENT=HTTP$SERVER,ACCESS=R+W+E), -
               (IDENT=*,ACCESS=NONE, OPTIONS=DEFAULT), -
               (IDENT=*,ACCESS=NONE))
$!
$!   (derive from the location of this procedure)
$    STARTUP_DECNET = PROC_DEVICE + PROC_DIRECTORY + "STARTUP_DECNET.COM"
$    @'STARTUP_DECNET'
$!
$ ENDIF
$!
$! -----------------------
$! ENSURE HTTPd LOG ACCESS
$! -----------------------
$!
$ SET SECURITY HT_ROOT:[LOG]SERVER.DIR -
      /ACL=((IDENT=HTTP$SERVER,ACCESS=R+W+E, OPTIONS=DEFAULT), -
            (IDENT=HTTP$SERVER,ACCESS=R+W+E), -
            (IDENT=*,ACCESS=NONE, OPTIONS=DEFAULT), -
            (IDENT=*,ACCESS=NONE))
$!
$! ------------------------
$! INSTALL PRIVILEGED IMAGE
$! ------------------------
$!
$ IF F$TYPE(PROVIDE_SSL) .EQS. ""
$ THEN
$!   (not otherwise specified, default to using an SSL image if present)
$    IF USE_NETLIB
$    THEN
$       IF F$SEARCH("HT_EXE:HTTPD_SSL_NETLIB.EXE") .EQS. ""
$          THEN PROVIDE_SSL = 0
$          ELSE PROVIDE_SSL = 1
$       ENDIF
$    ELSE
$       IF F$SEARCH("HT_EXE:HTTPD_SSL.EXE") .EQS. ""
$          THEN PROVIDE_SSL = 0
$          ELSE PROVIDE_SSL = 1
$       ENDIF
$    ENDIF
$    IF PROVIDE_SSL THEN SAY "%HTTPD-I-STARTUPROC, using SSL image"
$ ENDIF
$!
$ HTTPD_EXE = "HT_EXE:HTTPD"
$ IF PROVIDE_SSL THEN HTTPD_EXE = HTTPD_EXE + "_SSL"
$ IF USE_NETLIB THEN HTTPD_EXE = HTTPD_EXE + "_NETLIB"
$ HTTPD_EXE = HTTPD_EXE + ".EXE"
$!
$ SET SECURITY 'HTTPD_EXE' -
      /ACL=((IDENT=HTTP$SERVER,ACCESS=R+E),(IDENT=*,ACCESS=NONE))
$ INSTALL = "$SYS$SYSTEM:INSTALL/COMMAND_MODE"
$ DEFINE /USER SYS$OUTPUT NL:
$ DEFINE /USER SYS$ERROR NL:
$ INSTALL REMOVE 'HTTPD_EXE'
$ INSTALL ADD 'HTTPD_EXE' /PRIVILEGE=(ALTPRI,SYSPRV,SYSNAM,PRMMBX,PSWAPM)
$!
$ DEFINE /NOLOG /SYSTEM /EXEC HTTPD$EXE 'HTTPD_EXE'
$!
$! ----------------
$! SSL REQUIREMENTS
$! ----------------
$!
$ IF PROVIDE_SSL
$ THEN
$    DEFINE /NOLOG /SYSTEM /EXEC HTTPD$SSL_CERT 'SSL_SERVER_CERTIFICATE'
$ ENDIF
$!
$! -------------
$! LOCAL STARTUP
$! -------------
$!
$!(derive from the location of this procedure)
$ STARTUP_LOCAL = PROC_DEVICE + PROC_DIRECTORY + "STARTUP_LOCAL.COM"
$ IF F$SEARCH(STARTUP_LOCAL) .NES. "" THEN @'STARTUP_LOCAL'
$!
$! ------------------
$! START HTTPd SERVER
$! ------------------
$!
$ SUBMIT /QUEUE=SYS$BATCH /USER=HTTP$SERVER /NOLOG /NOPRINT -
         HT_ROOT:[HTTP$SERVER]HTTPD_BATCH.COM /PARAM="80"
$!
$ SAY "%HTTPD-I-STARTUPROC, end"
$!
$!-----------------------------------------------------------------------------
