$!-----------------------------------------------------------------------------
$! INSTALL.COM
$!
$! WASD (HFRD) VMS Hypertext Services, Copyright (c) 1996-1998 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it
$! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! Install the WASD Hypertext Services Package.
$!
$! 03-SEP-98  MGD  version 5.2
$! 28-JUL-98  MGD  allow for enabled disk quotas
$! 27-JUN-98  MGD  initial, v5.1 (and some would say long overdue!)
$!-----------------------------------------------------------------------------
$!
$ set noverify
$!
$ INSTALL_VERSION = "v5.2"
$!
$ currentProcedure = f$environment("PROCEDURE")
$ procDevice = f$parse(currentProcedure,,,"DEVICE","NO_CONCEAL")
$ procDirectory = f$parse(currentProcedure,,,"DIRECTORY","NO_CONCEAL")
$!
$ if f$trnlnm("HT_ROOT","LNM$JOB") .eqs. ""
$ then
$!   (subprocess to do the actual work, define local logicals)
$    htRoot = procDevice +-
        (procDirectory --
         f$extract(f$locate("HT_ROOT",procDirectory),999,procDirectory)) +-
        "HT_ROOT.]"
$    define /job /nolog /translation=concealed HT_ROOT 'htRoot'
$    archName = f$edit(f$getsyi("ARCH_NAME"),"UPCASE")
$    if archName .eqs. "ALPHA" then archName = "AXP"
$    htExe = "HT_ROOT:[''archName']"
$    define /job /nolog HT_EXE 'htExe'
$!   (spawn a subprocess to do the actual install ensures job logical deletion)
$    spawn /wait @'currentProcedure' -
           "''P1'" "''P2'" "''P3'" "''P4'" "''P5'" "''P6'" "''P7'" "''P8'"
$    deassign /job HT_ROOT
$    deassign /job HT_EXE
$    exit
$ endif
$!
$ say = "write sys$command"
$ copy = "copy/log/prot=w:re"
$ currentDefault = f$environment("DEFAULT")
$!
$!-----------------------------------------------------------------------------
$!
$ type SYS$INPUT

WASD (HFRD) VMS Hypertext Services, Copyright (c) 1996-1998 Mark G.Daniel.
This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.

$ say "--- INSTALL WASD VMS HYPERTEXT SERVICES ''INSTALL_VERSION' ---"
$ type SYS$INPUT

All sections may be individually declined before making any modifications.
In this sense the install may be undertaken step-by-step or sections repeated.
The first section is LINKING, after which you will be able to quit.
In a mixed architecture cluster (including both Alpha and VAX systems)
the link section must be done on both!
$!
$!-----------------------------------------------------------------------------
$!
$ if f$trnlnm("HT_ROOT","LNM$SYSTEM") .nes. "" .and. -
     P1 .nes. "INSTALL"
$ then
$    type SYS$INPUT

  ****************************************
  *  "HT_ROOT" logical name detected.    *
  *  This does not look like an install! *
  ****************************************

$    exit
$ endif
$!
$ if f$search("HT_ROOT:[000000]*.*") .eqs. ""
$ then
$    type SYS$INPUT

  *********************************************************
  *  Appears to be a problem with the "HT_ROOT" logical!  *
  *********************************************************

$    exit
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type SYS$INPUT

--- LINK EXECUTABLES ---

$ tcpipAgent = ""
$!
$ if f$trnlnm("UCX$DEVICE","LNM$SYSTEM") .nes. "" .and. -
     f$trnlnm("NETLIB_SHR","LNM$SYSTEM") .eqs. ""
$ then
$ type SYS$INPUT
|  "UCX$DEVICE" logical detected, "NETLIB_SHR" logical not detected.
|  UCX (Digital TCP/IP Services)?
|
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if response then tcpipAgent = "UCX"
$ endif
$!
$ if f$trnlnm("NETLIB_SHR","LNM$SYSTEM") .nes. "" .and. -
     f$trnlnm("UCX$DEVICE","LNM$SYSTEM") .eqs. ""
$ then
$ type SYS$INPUT
|  "NETLIB_SHR" logical detected, "UCX$DEVICE" logical not detected.
|  Mad-Goat NETLIB?
|
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if response then tcpipAgent = "NETLIB"
$ endif
$!
$ if tcpipAgent .eqs. ""
$ then
$    tcpipAgentLoop:
$       type SYS$INPUT
|  TCP/IP agent is not obvious.
|  Choices:  UCX (Digital TCP/IP Services) or NETLIB or NONE.
|  Link object code for which?
|
$       response = ""
$       read sys$command response /prompt="[UCX]: "
$       if response .eqs. "" then response = "UCX"
$       response = f$edit(response,"UPCASE")
$       if response .eqs. "UCX" .or. -
           response .eqs. "NETLIB" .or. -
           response .eqs. "NONE" -
           then goto endTcpipAgentLoop
$    endTcpipAgentLoop:
$    tcpipAgent = response
$    if tcpipAgent .eqs. "NONE" then tcpipAgent = ""
$ endif
$!
$ if tcpipAgent .nes. ""
$ then
$    say "|"
$    say "|  Link all executables (using ''tcpipAgent' where appropriate)?"
$    say "|"
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if response
$    then
$       set default HT_ROOT:[SRC]
$       @LINK_ALL 'tcpipAgent'
$!      'f$verify(0)
$       set default 'currentDefault'
$    endif
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- SERVER QUICK-CHECK ---

|  This executes the package demonstration procedure,
|  allowing the basic package to be evaluated or checked.
|  You may run this at any time to again check the package for
|  basic functionality using @HT_ROOT:[000000]FREEWARE_DEMO.COM
|  Execute the demonstration procedure?
|
$ response = ""
$ read sys$command response /prompt="[No]: "
$ if response
$ then
$    @HT_ROOT:[000000]FREEWARE_DEMO.COM
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- CONTINUE INSTALLATION? ---

$ response = ""
$ read sys$command response /prompt="[No]: "
$ if .not. response
$ then
$    say ""
$    exit
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- DIRECTORY PROTECTIONS ---

$ htRootDirFile = procDevice + procDirectory
$ htRootDirFile = htRootDirFile - ".][000000]" - "]" + ".-]HT_ROOT.DIR"
$ htRootDirFile = f$search(htRootDirFile)
$ htRootDirFileWorldPro = f$element(4,"=",f$file(htRootDirFile,"PRO"))
$ say "|  ''htRootDirFile' has protection ..."
$ say "|    (''f$file(htRootDirFile,"PRO")')"
$ if htRootDirFileWorldPro .eqs. "RE"
$ then
$    say "|  This indicates the entire HT_ROOT:[000000] should be correct!"
$ else
$    type sys$input
|  These protections do not look correct!
|  This may prevent access by the server account.
|  Set all HT_ROOT:[000000] tree directories to (S:RWED,O:RWED,G:RE,W:RE)?
|
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if response
$    then
$       SET PROTECTION=(S:RWED,O:RWED,G:RE,W:RE) 'htRootDirFile'
$       SET PROTECTION=(S:RWED,O:RWED,G:RE,W:RE) HT_ROOT:[000000...]*.DIR;*
$    endif
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- CREATE SERVER ACCOUNT ---
$ getAccountUICLoop:
$    type sys$input

|  The server account, "HTTP$SERVER", must have
|  a unique UIC, preferably in a group of it's own.
|  DO NOT choose the SYSTEM group ([1,*]) or other privileged group!
|  The default [367,1] is merely a suggestion.
|  You will be shown whether the entered UIC exists before continuing.
|  *** Entering NONE skips account creation ***
|
$    response = ""
$    read sys$command response /prompt="[367,1]: "
$    if response .eqs. "" then response = "[367,1]"
$    response = f$edit(response,"UPCASE")
$    accountUIC = response
$    if accountUIC .eqs. "NONE" then accountUIC = ""
$    if accountUIC .eqs. "" then goto endGetAccountUICLoop
$    if f$extract(0,1,accountUIC) .nes. "[" -
        then accountUIC = "[" + accountUIC + "]"
$    set default SYS$SYSTEM
$    set noon
$    say ""
$    mcr AUTHORIZE show /brief 'accountUIC'
$    set on
$    set default 'currentDefault'
$    type sys$input

|  If no user matched the specification then the UIC is available!
|  Choices: Yes, create the account using this UIC.  No, select another.
|
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if .not. response then goto getAccountUICLoop
$ endGetAccountUICLoop:
$!
$ if accountUIC .nes. ""
$ then
$    set default SYS$SYSTEM
$    mcr AUTHORIZE add HTTP$SERVER /UIC='accountUIC'
$    mcr AUTHORIZE modify HTTP$SERVER -
/OWNER="WASD HTTPd" -
/CLI=DCL -
/CLITABLES=DCLTABLES -
/DEVICE=HT_ROOT: -
/DIRECTORY=[HTTP$SERVER] -
/LGICMD=LOGIN
$    mcr AUTHORIZE modify HTTP$SERVER -
/FLAGS=(RESTRICTED,DISNEWMAIL,NODISUSER)-
/NETWORK/BATCH/NOLOCAL/NODIALUP/NOINTERACTIVE -
/PRIVILEGES=(TMPMBX,NETMBX) -
/DEFPRIVILEGES=(TMPMBX,NETMBX)
$    mcr AUTHORIZE modify HTTP$SERVER -
/MAXJOBS=0 -
/MAXACCTJOBS=0 -
/MAXDETACH=0 -
/PRCLM=100 -
/PRIO=4 -
/QUEPRIO=0 -
/CPU=0
$    mcr AUTHORIZE modify HTTP$SERVER -
/FILLM=300 -
/SHRFILLM=0 -
/BIOLM=512 -
/DIOLM=512 -
/ASTLM=600 -
/TQELM=100 -
/ENQLM=512
$    mcr AUTHORIZE modify HTTP$SERVER -
/BYTLM=300000 -
/PBYTLM=0 -
/JTQUOTA=1024 -
/WSDEF=1000 -
/WSQUO=2000 -
/WSEXTENT=20000 -
/PGFLQUO=200000
$!
$    mcr AUTHORIZE show HTTP$SERVER
$!
$    say ""
$    set file /log HT_ROOT:[000000]HTTP$SERVER.DIR -
         /owner=HTTP$SERVER -
         /protection=(S:WRED,O:WRED,G:RE,W:RE)
$!
$    set file /log HT_ROOT:[000000]LOG.DIR -
         /owner=HTTP$SERVER -
         /protection=(S:WRED,O:WRED,G:RE,W:RE)
$!
$    set file /log HT_ROOT:[LOG]SERVER.DIR -
         /owner=HTTP$SERVER -
         /protection=(S:WRED,O:WRED,G:RE,W:RE)
$!
$    set default 'currentDefault'
$!
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- CHECKING DISK QUOTA ---

$ set noon
$ show quota /disk=HT_ROOT: /user=HTTP$SERVER
$ quotaStatus = $STATUS
$ set on
$ if quotaStatus .eq. %x00003e4
$ then
$    mcr SYS$SYSTEM:DISKQUOTA
use HT_ROOT:
add HTTP$SERVER /PERMQUOTA=10000
$    say ""
$    say "  Added an ambit quota of 10,000 blocks for HTTP$SERVER on " +-
         f$parse("HT_ROOT:",,,"DEVICE","NO_CONCEAL")
$    say "  Review this entry against local requirements!"
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- HTTPD SUPPORT FILES ---

|  Copies files from HT_ROOT:[EXAMPLE]
|  * HTTPD_BATCH.COM, HTTPD80.COM, LOGIN.COM  -->  HT_ROOT:[HTTP$SERVER]
|  * STARTUP.COM, STARTUP_DECNET.COM, STARTUP_LOCAL.COM  -->  HT_ROOT:[LOCAL]
|  * HTTPD$AUTH.CONF, HTTPD$CONFIG.CONF,
|      HTTPD$MAP.CONF, HTTPD$MSG.CONF  -->  HT_ROOT:[LOCAL]
|  Copy the files?
|
$ response = ""
$ read sys$command response /prompt="[No]: "
$ if response
$ then
$    say ""
$    copy HT_ROOT:[EXAMPLE]HTTPD_BATCH.COM HT_ROOT:[HTTP$SERVER]
$    copy HT_ROOT:[EXAMPLE]HTTPD80.COM HT_ROOT:[HTTP$SERVER]
$    copy HT_ROOT:[EXAMPLE]LOGIN.COM HT_ROOT:[HTTP$SERVER]
$    copy HT_ROOT:[EXAMPLE]STARTUP.COM HT_ROOT:[LOCAL]
$    copy HT_ROOT:[EXAMPLE]STARTUP_DECNET.COM HT_ROOT:[LOCAL]
$    copy HT_ROOT:[EXAMPLE]STARTUP_LOCAL.COM HT_ROOT:[LOCAL]
$    copy HT_ROOT:[EXAMPLE]HTTPD$AUTH.CONF HT_ROOT:[LOCAL]
$    copy HT_ROOT:[EXAMPLE]HTTPD$CONFIG.CONF HT_ROOT:[LOCAL]
$    copy HT_ROOT:[EXAMPLE]HTTPD$MAP.CONF HT_ROOT:[LOCAL]
$    copy HT_ROOT:[EXAMPLE]HTTPD$MSG.CONF HT_ROOT:[LOCAL]
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- INSTALL COMPLETE ---

$!
$!-----------------------------------------------------------------------------
