$!-----------------------------------------------------------------------------
$! BUILD_ALL.COM
$! BRUTE-FORCE build procedure for all WASD VMS Hypertext applications
$!
$! P1 == "BUILD" to compile and link all applications
$! P1 == "LINK" to only re-link all applications
$! P2 == "UCX" or P2 == "NETLIB" depending on requirements
$! P3 == "SSL" to build/link SSL-version HTTPd executable
$!
$! 27-JUN-98  MGD  modified for v5.1
$! ??-???-??  MGD  long unrecorded pre-history :^)
$!-----------------------------------------------------------------------------
$!
$ set noverify
$!
$ if P1 .nes. "BUILD" .and. P1 .nes. "COMPILE" .and. P1 .nes. "LINK" .and. -
     P2 .nes. "UCX" .and. P2 .nes. "NETLIB" .and. -
     (P3 .nes. "" .and. P3 .nes. "SSL")
$ then
$    say "Usage: @BUILD_ALL LINK|BUILD UCX|NETLIB [SSL]"
$    exit
$ endif
$!
$!(look for local HT_ROOT environment used when building)
$ if f$trnlnm("HT_ROOT","LNM$JOB") .eqs. ""
$ then
$!   (subprocess to do the actual work, define local logicals)
$    currentProcedure = f$environment("PROCEDURE")
$    procDevice = f$parse(currentProcedure,,,"DEVICE","NO_CONCEAL")
$    procDirectory = f$parse(currentProcedure,,,"DIRECTORY","NO_CONCEAL")
$!   (derive from the location of this procedure, assumes HT_ROOT tree!)
$    htRoot = procDevice +-
        (procDirectory --
         f$extract(f$locate("HT_ROOT",procDirectory),999,procDirectory)) +-
        "HT_ROOT.]"
$    define /job /nolog /translation=concealed HT_ROOT 'htRoot'
$    archName = f$edit(f$getsyi("ARCH_NAME"),"UPCASE")
$    if archName .eqs. "ALPHA" then archName = "AXP"
$    htExe = "HT_ROOT:[''archName']"
$    define /job /nolog HT_EXE 'htExe'
$!   (spawn a subprocess to do the actual build ensures job logical deletion)
$    spawn /wait @'currentProcedure' -
           "''P1'" "''P2'" "''P3'" "''P4'" "''P5'" "''P6'" "''P7'" "''P8'"
$    deassign /job HT_ROOT
$    deassign /job HT_EXE
$    exit
$ endif
$!
$ say = "write sys$command"
$ copy = "copy/log/prot=w:re"
$!
$ set noon
$ set control=Y
$ say = "write sys$output"
$ bell[0,8] = 7
$ currentDefault = f$environment("DEFAULT")
$!
$ set default HT_ROOT:[SRC]
$!
$!-----------------------------------------------------------------------------
$!
$ say ""
$ say "--- HTTPD ---"
$ set default [.HTTPD]
$ @BUILD_HTTPD "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- CGIPLUS ---"
$ set default [.CGIPLUS]
$ @BUILD_CGIPLUS "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- CONAN ---"
$ set default [.CONAN]
$ @BUILD_CONAN "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- DBIV ---"
$ set default [.DBIV]
$ @BUILD_DBIV "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- EXTRACT ---"
$ set default [.EXTRACT]
$ @BUILD_EXTRACT "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- GIFT ---"
$ set default [.GIFT]
$ @BUILD_GIFT "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- HPRINTS ---"
$ set default [.HPRINTS]
$ @BUILD_HPRINTS "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- HWP ---"
$ set default [.HWP]
$ @BUILD_HWP "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- HYPERREADER ---"
$ set default [.HYPERREADER]
$ @BUILD_HYPERREADER "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- HYPERSHELF ---"
$ set default [.HYPERSHELF]
$ @BUILD_HYPERSHELF "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- HYPERSPI ---"
$ set default [.HYPERSPI]
$ @BUILD_HYPERSPI$AGENT "''P1'" "''P2'" "''P3'"
$ @BUILD_HYPERSPI "''P1'" "''P2'" "''P3'"
$!'F$VERIFY(0)
$ set default [-]
$!
$ say ""
$ say "--- MISC(ellaneous) ---"
$ set default [.MISC]
$ @BUILD_MISC "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- MXMAILINGLIST ---"
$ set default [.MXMAILINGLIST]
$ @BUILD_MXMAILINGLIST "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- OSU ---"
$ set default [.OSU]
$ @BUILD_OSU "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- QUERY ---"
$ set default [.QUERY]
$ @BUILD_QUERY "''P1'" "''P2'" "''P3'"
$ set default [-]
$!
$ say ""
$ say "--- UTILITIES ---"
$ set default [.UTILS]
$ @BUILD_HTTPDMON "''P1'" "''P2'" "''P3'"
$ @BUILD_STREAMLF "''P1'" "''P2'" "''P3'"
$ @BUILD_WWWRKOUT "''P1'" "''P2'" "''P3'" 
$ set default [-]
$!
$ set default 'currentDefault'
$!
$!-----------------------------------------------------------------------------
$!
$ say "''bell'''bell'''bell'''bell'''bell'''bell'"
$ say "-------------------------------------------------------"
$ say "Finished!"
$ say "(might be a good idea to purge HT_EXE: when confident!)"
$ say "-------------------------------------------------------"
$!
$!-----------------------------------------------------------------------------
