/*****************************************************************************/
/*
                             CGIplusLoop.c

A skeletal program serving as a template for CGIplus-capable scripts.
CGIplus only!  Has simple loop, blocking while waiting for requests, and then
obtaining CGIplus variables.


08-JUN-97  MGD  v1.0.0, initial development
*/
/*****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

int  IsCgiPlus = 0;
char  *CgiPlusEofPtr = NULL;

/*****************************************************************************/
/*
*/

main ()

{
#  define CGIPLUS_LINE_SIZE 1024

   int  Count = 0;
   char  *cptr;
   char  Line [CGIPLUS_LINE_SIZE],
         RemoteHost [128];
   FILE  *SysCommand;

   IsCgiPlus = ((CgiPlusEofPtr = getenv("CGIPLUSEOF")) != NULL);

   if (!IsCgiPlus)
   {
      fprintf (stdout,
"Content-Type: text/html\n\
\n\
Sorry! &nbsp;CGIplus only!\n");
      exit (1);
   }

   if ((SysCommand = fopen (getenv("CGIPLUSIN"), "r")) == NULL)
      return (vaxc$errno);

   for (;;)
   {
      /* will block waiting for subsequent requests */
      for (;;)
      {
         if (fgets (Line, sizeof(Line), SysCommand) == NULL) exit (vaxc$errno);
         /* first empty line signals the end of CGIplus variables */
         if (Line[0] == '\n') break;
         /* remove the trailing newline */
         if ((cptr = strchr(Line, '\n')) != NULL) *cptr = '\0';

         /* select only the variable(s) we are interested in */
         if (!strncmp (Line, "WWW_REMOTE_HOST=", 16))
            strcpy (RemoteHost, Line+16);
      }

      fprintf (stdout,
"Content-Type: text/html\n\
Expires: Thu, 01 Jan 1970 00:00:01 GMT\n\
\n\
%d. <B>Hello world</B> ... well the \
<FONT SIZE=+1>&nbsp;<TT>%s</TT>&nbsp;</FONT> part of it anyway!\n",
               ++Count, RemoteHost);

      /* record-oriented <stdout>, no need to flush, write end-of-output line */
      if (IsCgiPlus) fprintf (stdout, "%s\n", CgiPlusEofPtr);
   }

   exit (1);
}

/*****************************************************************************/

