/*****************************************************************************/
/*
                              CGIplusTest.c

Script for testing the relative efficiencies of CGI and CGIplus.

This script can detect whether it is in a CGI or CGIplus environment and
adjust behaviour accordingly.  Call using the WWWRKOUT utility in both
environments to test throughput and response latency performance in both.
This script re-opens <stdout> in binary mode, hence the full HTTP response.

Can also be used as example code for working in both environments.
Demonstrates the alternative mechanism for accessing CGIplus variable values,
reading from <stdin> and parsing each line for required variables.  Also see
CGIplusSkeleton.c for the more spohisticated, general-purpose function.


08-JUN-97  MGD  v1.0.0, initial development
*/
/*****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [] = "CGIPLUSTEST AXP-1.0.0";
#else
   char SoftwareID [] = "CGIPLUSTEST VAX-1.0.0";
#endif

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>

int  Debug,
     IsCgiPlus;

char  *CgiPlusEofPtr;

char  Utility [] = "CGIPLUSTEST",
      Line80Chars [] =
"ABCDEFGHIJKLMNOPQRSTUVWXYZ\
abcdefghijklmnopqrstuvwxyz\
0123456789\
!@#$%^&*()_+-=<>,\n";

/*****************************************************************************/
/*
*/

main ()

{
   register char  *cptr;

   int  RequestedCount;

   /*********/
   /* begin */
   /*********/

   if (getenv ("CGIPLUSTEST$DBUG") != NULL) Debug = 1;

   if (Debug)
      system ("show sym *");
   else
   {
      /* reopen output stream so that the '\r' and '\n' are not filtered */
#ifdef __DECC
      if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "ctx=bin")) == NULL)
         exit (vaxc$errno);
#else
      if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "rfm=udf")) == NULL)
         exit (vaxc$errno);
#endif
   }

   IsCgiPlus = ((CgiPlusEofPtr = getenv("CGIPLUSEOF")) != NULL);

   /* do once for standard CGI, multiple times for CGIplus */

   do {

      if (IsCgiPlus)
      {
         /* called as a CGIplus script */
         RequestedCount = CgiPlusCount ();
      }
      else
      {
         /* called as a standard CGI script */
         if ((cptr = getenv ("WWW_QUERY_STRING")) == NULL)
            RequestedCount = -1;
         else
         if (isdigit(*cptr))
            RequestedCount = atoi(cptr);
         else
            RequestedCount = -1;
      }

      fprintf (stdout,
"HTTP/1.0 200 ok\r\n\
Server: %s\r\n\
Expires: Thu, 01-Jan-1970 00:00:01\r\n\
Content-Type: text/html\r\n\
\r\n",
         SoftwareID);

      if (RequestedCount < 0)
      {
         fprintf (stdout,
"<U><B>Usage:</B></U> supply a URL with the query string \
an integer representing the number of 80 character lines \
to be returned during the test.\n",
            SoftwareID);
      }
      else
      {
         while (RequestedCount--)
            fputs (Line80Chars, stdout);
      }

      if (IsCgiPlus)
      {
         /* the CGIplus EOF must be an independant I/O record */
         fflush (stdout);
         fprintf (stdout, "%s", CgiPlusEofPtr);
         fflush (stdout);
      }

   } while (IsCgiPlus);

   exit (1);
}

/*****************************************************************************/
/*
Use a simple loop to read lines from standard input.  Detect specific CGI
variables by checking the leading section of these lines for the required
variable name.  The value may then be extracted from the remaining section.
*/

int CgiPlusCount ()

{
#  define CGIPLUS_LINE_SIZE 1024

   register char  *cptr;

   int  Count;
   char  Line [CGIPLUS_LINE_SIZE];
   FILE  *SysCommand;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "CgiPlusCount()\n");

   Count = -1;

   if ((SysCommand = fopen (getenv("CGIPLUSIN"), "r")) == NULL)
      exit (vaxc$errno);

   for (;;)
   {
      if (fgets (Line, sizeof(Line), SysCommand) == NULL) exit (vaxc$errno);
      if (Debug) fprintf (stdout, "Line |%s|\n", Line);
      /* first empty line signals the end of CGIplus variables */
      if (Line[0] == '\n') break;
      /* remove the trailing newline */
      if ((cptr = strchr(Line, '\n')) != NULL) *cptr = '\0';

      if (!strncmp (Line, "WWW_QUERY_STRING=", 17))
         if (isdigit(Line[17])) Count = atoi(Line+17);
   }

   fclose (SysCommand);

   return (Count);
}

/*****************************************************************************/

