/*****************************************************************************/
/*
                                   Gift.h

*/
/*****************************************************************************/

#define boolean int
#define true 1
#define false 0

#define MaxGraphicWidth 1000
#define MaxGraphicHeight 1000
#define MaxPointWidth 32
#define DefaultButtonColour "grey"
#define DefaultButtonFontPoints 12
#define DefaultGraphicWidth 200
#define DefaultGraphicHeight 200
#define DefaultProgressBarWidth 500
#define DefaultProgressBarHeight 30
#define DefaultBorderColour "black"
#define DefaultBorderWidth 1
#define DefaultGraphicColourBg "white"
#define DefaultGraphicColourFg "black"
#define DefaultGraphicWidthFg 1
#define DefaultProgressBarColour "green"
#define DefaultProgressBarAlertColour "red"

struct GraphicFontStruct
{
   boolean  Bold,
            Double,
            Inverse,
            Italic,
            UnderLine;
   int  CharWidth,
        CharHeight,
        Colour,
        FirstChar,
        NumberOfChar,
        PointSize,
        XbmHeight,
        XbmWidth;
   char  *Bits;
};

/***********************/
/* function prototypes */
/***********************/

/* higher level functions */

int GiftButton (char*, char*, int);
int GiftUsageBar (int, int, char*);
int GiftTestColours ();
int GiftTestGraphics ();
int GiftTestFonts ();

/* lower level functions */

int GiftNewGraphic (int, int, int);
int GiftBackground (int);
int GiftInitGraphic ();
int GiftColour (char *ColourString);
int GiftGraphicErrorReport (char *ErrorMessage);
int GiftCheckFont (int GraphicFontPoints);
int GiftInitFonts ();
int GiftDrawString (int, int, char*, struct GraphicFontStruct *FontPtr);
int GiftDrawChar (int, int, int, struct GraphicFontStruct *FontPtr);
int GiftDrawPoint (int, int, int, int);
int GiftDrawLine (int, int, int, int, int, int);
int GiftDrawRect (int, int, int, int, int, int);
int GiftDrawBlock (int, int, int, int, int);
int GiftDrawBorder (int, int);
int GiftDrawBar (int, int);
int GiftDrawButton (int, char*, struct GraphicFontStruct *FontPtr);
int GiftParseParameters (char*, int);
int GiftCopyTextFromUrl (char*, char*, int);
int GiftParseError (char*, int, int);
int GiftImage ();
int GiftNextPixel ();
int GiftCompress (int);
int GiftPackBits (int, int);

/*
extern int  GraphicBackground,
            GraphicBitsPerPixel,
            GraphicByteCount,
            GraphicColourBorder,
            GraphicColourBg,
            GraphicColourCount,
            GraphicColourFg,
            GraphicHeight,
            GraphicHttpOutFd,
            GraphicFontPoints,
            GraphicPixelCount,
            GraphicTransparencyColour,
            GraphicWidth,
            GraphicWidthBorder,
            GraphicWidthFg;

extern unsigned char  *GraphicPtr;

extern struct GraphicFontStruct  Font [];
*/

/*****************************************************************************/
