$!-----------------------------------------------------------------------------
$! BUILD_HTTPD.COM
$!
$! P1 ... P3  "UCX" or "NETLIB" or "TCPWARE" to specify IP
$! P1 ... P3  "SSL" to build with SSL (SSLeay)
$! P1 ... P3  "LINK" to link only
$! P1 ... P3  "DBUG" compiles with debug statements
$!
$! 03-JUL-98  MGD  SSLeay v0.9.0b,
$!                 build for TCPware in UCX compatibility mode
$! 14-MAY-98  MGD  add defines for __VMS_VER, __CRTL_VER, __VMS_V6_SOURCE
$!                 (ensure v7.1 compilations can be executed on v6.n),
$!                 distributing as .OBJ ... need UCX and NETLIB object files
$! 07-JAN-98  MGD  HTTPd version 5
$!                 added SSL (SSLeay) build support
$!                 removed optimization, seemed to be inducing problems
$! 07-SEP-97  MGD  modified to support DBUG and to retain NETLIB objects
$! 23-JUL-97  MGD  MultiNet dropped in favour of NETLIB 2.1
$! 01-FEB-97  MGD  HTTPd version 4
$! 06-JAN-96  MGD  build for either UCX or MultiNet
$! 01-DEC-95  MGD  HTTPd version 3
$! 24-MAY-95  MGD  build for AXP systems
$! 20-DEC-94  MGD  multi-threaded server
$! 20-JUN-94  MGD  single-threaded server
$!-----------------------------------------------------------------------------
$!
$ IP = ""
$ IF P1 .EQS. "NETLIB" .OR. P2 .EQS. "NETLIB" .OR. P3 .EQS. "NETLIB"
$ THEN
$    IP = "NETLIB"
$    IP_EXE = "_NETLIB"
$    IP_OBJ = "_NETLIB"
$ ENDIF
$ IF P1 .EQS. "TCPWARE" .OR. P2 .EQS. "TCPWARE" .OR. P3 .EQS. "TCPWARE"
$ THEN
$!   (TCPware in UCX compatibility mode)
$    IP = "TCPWARE"
$    IP_EXE = ""
$    IP_OBJ = ""
$ ENDIF
$ IF IP .EQS. ""
$ THEN
$    IP = "UCX"
$    IP_EXE = ""
$    IP_OBJ = ""
$ ENDIF
$ IF P1 .EQS. "SSL" .OR. P2 .EQS. "SSL" .OR. P3 .EQS. "SSL"
$ THEN
$    SESOLA = "SESOLA"
$    SESOLA_EXE = "_SSL"
$    SESOLA_OBJ = "_SSL"
$    SESOLA_INCLUDED = "with SSL"
$    IF F$SEARCH("HT_ROOT:[SRC]SSLEAY-0_8_1.DIR") .NES. "" -
        THEN SSLEAYDIR = "HT_ROOT:[SRC.SSLEAY-0_8_1"
$    IF F$SEARCH("HT_ROOT:[SRC]SSLEAY-0_9_0B.DIR") .NES. "" -
        THEN SSLEAYDIR = "HT_ROOT:[SRC.SSLEAY-0_9_0B"
$    IF F$TYPE(SSLEAYDIR) .EQS. ""
$    THEN
$       TYPE SYS$INPUT

  ********************************
  *  SSLEAY directory not found  *
  ********************************

$       EXIT
$    ENDIF
$ ELSE
$    SESOLA = ""
$    SESOLA_EXE = ""
$    SESOLA_OBJ = ""
$    SESOLA_INCLUDED = "without SSL"
$ ENDIF
$ IF P1 .EQS. "DBUG" .OR. P2 .EQS. "DBUG" .OR. P3 .EQS. "DBUG"
$ THEN
$    DBUG = "DBUG"
$ ELSE
$    DBUG = ""
$ ENDIF
$!
$ DEFINES = "_VMS_V6_SOURCE=1,__VMS_VER=60000000,__CRTL_VER=6000000"
$ IF IP .NES. "" THEN DEFINES = DEFINES + ","
$ DEFINES = DEFINES + "IP_" + IP
$ IF DBUG .NES. "" THEN DEFINES = DEFINES + ","
$ DEFINES = DEFINES + DBUG
$ IF SESOLA .NES. "" THEN DEFINES = DEFINES + ","
$ DEFINES = DEFINES + SESOLA
$!
$ WRITE SYS$OUTPUT "Building for ""''F$GETSYI("ARCH_NAME")'"" architecture" + -
                   ", ""''IP'"" TCP/IP'', ''SESOLA_INCLUDED'."
$!
$ IF F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE") .EQS. "VAX"
$ THEN
$    OBJ_DIR = "[.OBJ_VAX]"
$    IF F$SEARCH("OBJ_VAX.DIR") .EQS. "" THEN CREATE /DIR 'OBJ_DIR'
$    CC_OPTIONS = "/DECC /STAND=VAXC /NOOPTIMIZE /DEF=(''DEFINES') /NODEBUG"
$    LINK_OPTIONS = "[]HTTPD_VAX'IP_EXE'.OPT /OPTIONS"
$ ELSE
$    OBJ_DIR = "[.OBJ_AXP]"
$    IF F$SEARCH("OBJ_AXP.DIR") .EQS. "" THEN CREATE /DIR 'OBJ_DIR'
$    CC_OPTIONS = "/STAND=VAXC /NOOPTIMIZE /DEF=(''DEFINES') /NODEBUG"
$    LINK_OPTIONS = "[]HTTPD_AXP'IP_EXE'.OPT /OPTIONS"
$ ENDIF
$!
$ IF P1 .NES. "LINK" .AND. P2 .NES. "LINK" .AND. P3 .NES. "LINK"
$ THEN
$    SET NOON
$    SET VERIFY
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Admin'IP_OBJ'    Admin
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Auth'IP_OBJ'     Auth
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Basic'IP_OBJ'    Basic
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Cache'IP_OBJ'    Cache
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'CGI'IP_OBJ'      CGI
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'CLI'IP_OBJ'      CLI
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Config'IP_OBJ'   Config
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Control'IP_OBJ'  Control
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Dcl'IP_OBJ'      Dcl
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'DECnet'IP_OBJ'      DECnet
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Descr'IP_OBJ'    Descr
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Dir'IP_OBJ'      Dir
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Digest'IP_OBJ'   Digest
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Error'IP_OBJ'    Error
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'File'IP_OBJ'     File
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Graph'IP_OBJ'    Graph
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'HTAdmin'IP_OBJ'  HTAdmin
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'HTTPd'IP_OBJ'    HTTPd
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'IsMap'IP_OBJ'    IsMap
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Logging'IP_OBJ'  Logging
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'MapUrl'IP_OBJ'   MapUrl
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'MD5'IP_OBJ'      MD5
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Menu'IP_OBJ'     Menu
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Msg'IP_OBJ'      Msg
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Net'IP_OBJ'      Net
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Put'IP_OBJ'      Put
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Request'IP_OBJ'  Request
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'SSI'IP_OBJ'      SSI
$    IF SESOLA .EQS. ""
$    THEN
$       CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'SeSoLa'SESOLA_OBJ''IP_OBJ' SeSoLa
$    ELSE
$       DEFINE /USER DECC$USER_INCLUDE 'SSLEAYDIR'...]
$       CC 'CC_OPTIONS' /NOWARN /OBJECT='OBJ_DIR'SeSoLa'SESOLA_OBJ''IP_OBJ' SeSoLa
$    ENDIF
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'StmLF'IP_OBJ'    StmLF
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Support'IP_OBJ'  Support
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'Upd'IP_OBJ'      Upd
$    CC 'CC_OPTIONS' /OBJECT='OBJ_DIR'VM'IP_OBJ'       VM
$!   'F$VERIFY(0)
$ ENDIF
$!
$ IF F$EDIT(F$GETSYI("ARCH_NAME"),"UPCASE") .EQS. "VAX"
$ THEN
$    SSL_LIBRARY = "''SSLEAYDIR'.SSL]SSL-VAX.OLB/LIBRARY," +-
                   "''SSLEAYDIR'.CRYPTO]CRYPTO-VAX.OLB/LIBRARY,"
$ ELSE
$    SSL_LIBRARY = "''SSLEAYDIR'.SSL]SSL-AXP.OLB/LIBRARY," +-
                   "''SSLEAYDIR'.CRYPTO]CRYPTO-AXP.OLB/LIBRARY,"
$ ENDIF
$ IF SESOLA .EQS. "" THEN SSL_LIBRARY = ""
$!
$ SET ON
$ SET VERIFY
$!
$ LINK /NOTRACE /EXECUTABLE=HT_EXE:HTTPD'SESOLA_EXE''IP_EXE'.EXE -
  'OBJ_DIR'Admin'IP_OBJ', -
  'OBJ_DIR'Auth'IP_OBJ', -
  'OBJ_DIR'Basic'IP_OBJ', -
  'OBJ_DIR'Cache'IP_OBJ', -
  'OBJ_DIR'CGI'IP_OBJ', -
  'OBJ_DIR'CLI'IP_OBJ', -
  'OBJ_DIR'Config'IP_OBJ', -
  'OBJ_DIR'Control'IP_OBJ', -
  'OBJ_DIR'Dcl'IP_OBJ', -
  'OBJ_DIR'DECnet'IP_OBJ', -
  'OBJ_DIR'Descr'IP_OBJ', -
  'OBJ_DIR'Dir'IP_OBJ', -
  'OBJ_DIR'Digest'IP_OBJ', -
  'OBJ_DIR'Error'IP_OBJ', -
  'OBJ_DIR'File'IP_OBJ', -
  'OBJ_DIR'Graph'IP_OBJ', -
  'OBJ_DIR'HTAdmin'IP_OBJ', -
  'OBJ_DIR'HTTPd'IP_OBJ', -
  'OBJ_DIR'IsMap'IP_OBJ', -
  'OBJ_DIR'Logging'IP_OBJ', -
  'OBJ_DIR'MapUrl'IP_OBJ', -
  'OBJ_DIR'MD5'IP_OBJ', -
  'OBJ_DIR'Menu'IP_OBJ', -
  'OBJ_DIR'Msg'IP_OBJ', -
  'OBJ_DIR'Net'IP_OBJ', -
  'OBJ_DIR'Put'IP_OBJ', -
  'OBJ_DIR'Request'IP_OBJ', -
  'OBJ_DIR'SSI'IP_OBJ', -
  'OBJ_DIR'SeSoLa'SESOLA_OBJ''IP_OBJ', -
  'OBJ_DIR'StmLF'IP_OBJ', -
  'OBJ_DIR'Support'IP_OBJ', -
  'OBJ_DIR'Upd'IP_OBJ', -
  'OBJ_DIR'VM'IP_OBJ', -
  'SSL_LIBRARY' -
  'LINK_OPTIONS'
$!
$ PURGE /LOG 'OBJ_DIR' /KEEP=3
$ SET PROTECTION=W:E HT_EXE:HTTPD'SESOLA_EXE''IP_EXE'.EXE;*
$!'F$VERIFY(0)
$!-----------------------------------------------------------------------------
