/*****************************************************************************/
/*
                                   Graph.h

01-AUG-97  MGD  new for v4.3
*/
/*****************************************************************************/

#define boolean int
#define true 1
#define false 0

/* must correspond to the colours in GraphicRgbRed[], Blue[], Green[] */
#define COLOUR_BLACK 0
#define COLOUR_RED 1
#define COLOUR_GREEN 2
#define COLOUR_BLUE 3
#define COLOUR_YELLOW 4
#define COLOUR_MAGENTA 5
#define COLOUR_CYAN 6
#define COLOUR_WHITE 7
#define COLOUR_GREY 8
#define COLOUR_DRED 9
#define COLOUR_DGREEN 10
#define COLOUR_DBLUE 11
#define COLOUR_DYELLOW 12
#define COLOUR_DMAGENTA 13
#define COLOUR_DCYAN 14
#define COLOUR_DWHITE 15

/* minimum expected compression ratio from LZW algorithm in GIF processor */
#define GIF_EXPECTED_COMPRESSION 8
#define GIF_OVERHEAD 128

#define GRAPH_XAXIS_TOP 1
#define GRAPH_XAXIS_BOTTOM 2
#define GRAPH_YAXIS_LEFT 1
#define GRAPH_YAXIS_RIGHT 2

/*******************/
/* data structures */
/*******************/

struct GraphStruct
{
   boolean  PreExpired;

   int  BitsPerPixel,
        ColourBg,
        ColourFg,
        ColourTr,
        GifBufferLength,
        GifContentLength,
        GifColourBg,
        Height,
        PixelCount,
        Width,
        WidthFg;

   char  *ErrorTextPtr;

   unsigned char  *GifBufferPtr,
                  *GifBufferEndPtr,
                  *GifPtr,
                  *PlotBufferPtr;
};

/***********************/
/* function prototypes */
/***********************/

unsigned long GraphActivityDataIdx (unsigned long, unsigned long);
int GraphActivityDataScan (int, int, int, int, boolean,
                           unsigned int*, unsigned int*,
                           unsigned long*, unsigned long*);
int GraphActivityGifStream (struct RequestStruct*);
int GraphActivityInit ();
int GraphActivityIncrement (struct RequestStruct*);
int GraphActivityMaxima (unsigned int*, unsigned int*);
int GraphActivityOffsetTime (int, unsigned long*, unsigned long*);
char* GraphActivityOnMouseOver (unsigned long*, int);
int GraphActivityPlotBegin (struct RequestStruct*, void*);
int GraphActivityPlotEnd (struct RequestStruct*);
int GraphActivityReport (struct RequestStruct*, void*);

char* GraphCompress (struct GraphStruct*, int);
char* GraphDrawBlock (struct GraphStruct*, int, int, int, int, int);
char* GraphDrawBorder (struct GraphStruct*, int, int);
char* GraphDrawLine (struct GraphStruct*, int, int, int, int, int, int);
char* GraphDrawPoint (struct GraphStruct*, int, int, int, int);
char* GraphDrawRect (struct GraphStruct*, int, int, int, int, int, int);
char* GraphGifImage (struct GraphStruct*);
char* GraphGraduateXAxis (struct GraphStruct*, int, int, int, int);
char* GraphGraduateYAxis (struct GraphStruct*, int, int, int, int);
char* GraphNew (struct RequestStruct*, struct GraphStruct*, int, int, int);

/*****************************************************************************/
