/*****************************************************************************/
/*
                                  msg.h

Defines a macro and number 1..n for all of the messages used in the server.
Also calculates the number of messages so created for sizing of data
structures, looping purposes, etc. In true C fashion this could break horribly
if the __BASE, __MAX and NUMBER_OF_GROUPS macros are not properly adjusted
when the number of defined messages is altered!  The __BASE number (and
pointer array index) is reserved for storing the group name in language one for
reporting purposes.


12-MAR-98  MGD  additional messages for v5.0
25-OCT-97  MGD  changes around MsgFor() when no request structure available
31-AUG-97  MGD  added MSG_DIR_INDEX_OF and MSG_DIR_TREE_OF (an oversight)
09-AUG-97  MGD  initial
*/
/*****************************************************************************/

#define  MSG_AUTH__BASE                 0
#define  MSG_AUTH_REQUIRED              MSG_AUTH__BASE+1
#define  MSG_AUTH_ACCESS_DENIED         MSG_AUTH__BASE+2
#define  MSG_AUTH_FAILED                MSG_AUTH__BASE+3
#define  MSG_AUTH_SCHEME                MSG_AUTH__BASE+4
#define  MSG_AUTH_USER                  MSG_AUTH__BASE+5
#define  MSG_AUTH_DATABASE              MSG_AUTH__BASE+6
#define  MSG_AUTH_DATABASE_VMS          MSG_AUTH__BASE+7
#define  MSG_AUTH_USERNAME_LENGTH       MSG_AUTH__BASE+8
#define  MSG_AUTH_PASSWORD_LENGTH       MSG_AUTH__BASE+9
#define  MSG_AUTH__MAX                  9

#define  MSG_DIR__BASE                  MSG_AUTH__BASE+MSG_AUTH__MAX+1
#define  MSG_DIR_COLUMN_HEADINGS        MSG_DIR__BASE+1
#define  MSG_DIR_PARENT                 MSG_DIR__BASE+2
#define  MSG_DIR_SUB                    MSG_DIR__BASE+3
#define  MSG_DIR_LAYOUT                 MSG_DIR__BASE+4
#define  MSG_DIR_INDEX_OF               MSG_DIR__BASE+5
#define  MSG_DIR_TREE_OF                MSG_DIR__BASE+6
#define  MSG_DIR__MAX                   6

#define  MSG_GENERAL__BASE              MSG_DIR__BASE+MSG_DIR__MAX+1
#define  MSG_GENERAL_SANITY             MSG_GENERAL__BASE+1
#define  MSG_GENERAL_INTERNAL           MSG_GENERAL__BASE+2
#define  MSG_GENERAL_OVERFLOW           MSG_GENERAL__BASE+3
#define  MSG_GENERAL_HEAP               MSG_GENERAL__BASE+4
#define  MSG_GENERAL_CALLOC             MSG_GENERAL__BASE+5
#define  MSG_GENERAL_REQUEST_CALLOC     MSG_GENERAL__BASE+6
#define  MSG_GENERAL_TOO_BUSY           MSG_GENERAL__BASE+7
#define  MSG_GENERAL_ACCESS_DENIED      MSG_GENERAL__BASE+8
#define  MSG_GENERAL_DISABLED           MSG_GENERAL__BASE+9
#define  MSG_GENERAL_NO_WILDCARD        MSG_GENERAL__BASE+10
#define  MSG_GENERAL_FILE               MSG_GENERAL__BASE+11
#define  MSG_GENERAL_DOCUMENT           MSG_GENERAL__BASE+12
#define  MSG_GENERAL_DIRECTORY          MSG_GENERAL__BASE+13
#define  MSG_GENERAL__MAX               13

#define  MSG_HTADMIN__BASE              MSG_GENERAL__BASE+MSG_GENERAL__MAX+1
#define  MSG_HTADMIN_DATABASE           MSG_HTADMIN__BASE+1
#define  MSG_HTADMIN_PWD_INCORRECT      MSG_HTADMIN__BASE+2
#define  MSG_HTADMIN_PWD_INCOMPLETE     MSG_HTADMIN__BASE+3
#define  MSG_HTADMIN_PWD_VERIFY         MSG_HTADMIN__BASE+4
#define  MSG_HTADMIN_PWD_IDENTICAL      MSG_HTADMIN__BASE+5
#define  MSG_HTADMIN_PWD_ERROR          MSG_HTADMIN__BASE+6
#define  MSG_HTADMIN_PWD_NOT_FOUND      MSG_HTADMIN__BASE+7
#define  MSG_HTADMIN_PWD_DATABASE       MSG_HTADMIN__BASE+8
#define  MSG_HTADMIN_PWD_CHANGE         MSG_HTADMIN__BASE+9
#define  MSG_HTADMIN__MAX               9

#define  MSG_ISMAP__BASE                MSG_HTADMIN__BASE+MSG_HTADMIN__MAX+1
#define  MSG_ISMAP_CONFUSED             MSG_ISMAP__BASE+1
#define  MSG_ISMAP_COORDINATE           MSG_ISMAP__BASE+2
#define  MSG_ISMAP_DEFAULT              MSG_ISMAP__BASE+3
#define  MSG_ISMAP_INCOMPLETE           MSG_ISMAP__BASE+4
#define  MSG_ISMAP_INCORRECT            MSG_ISMAP__BASE+5
#define  MSG_ISMAP_LIMIT                MSG_ISMAP__BASE+6
#define  MSG_ISMAP_REGION               MSG_ISMAP__BASE+7
#define  MSG_ISMAP__MAX                 7

#define  MSG_MAPPING__BASE              MSG_ISMAP__BASE+MSG_ISMAP__MAX+1
#define  MSG_MAPPING_DENIED_NO_RULES    MSG_MAPPING__BASE+1
#define  MSG_MAPPING_DENIED_INTERNAL    MSG_MAPPING__BASE+2
#define  MSG_MAPPING_DENIED_RULE        MSG_MAPPING__BASE+3
#define  MSG_MAPPING_DENIED_DEFAULT     MSG_MAPPING__BASE+4
#define  MSG_MAPPING__MAX               4

#define  MSG_PUT__BASE                  MSG_MAPPING__BASE+MSG_MAPPING__MAX+1
#define  MSG_PUT_MULTIPART              MSG_PUT__BASE+1
#define  MSG_PUT_MULTIPART_MIXED        MSG_PUT__BASE+2
#define  MSG_PUT_MULTIPART_FILENAME     MSG_PUT__BASE+3
#define  MSG_PUT_MULTIPART_FIELD        MSG_PUT__BASE+4
#define  MSG_PUT_MULTIPART_UPLOAD       MSG_PUT__BASE+5
#define  MSG_PUT_DIR_NAME               MSG_PUT__BASE+6
#define  MSG_PUT_DIR_EXISTS             MSG_PUT__BASE+7
#define  MSG_PUT_DELETE_NO_FILENAME     MSG_PUT__BASE+8
#define  MSG_PUT_CREATED                MSG_PUT__BASE+9
#define  MSG_PUT_SUPERCEDED             MSG_PUT__BASE+10
#define  MSG_PUT_DELETED                MSG_PUT__BASE+11
#define  MSG_PUT__MAX                   11

#define  MSG_REQUEST__BASE              MSG_PUT__BASE+MSG_PUT__MAX+1
#define  MSG_REQUEST_FORMAT             MSG_REQUEST__BASE+1
#define  MSG_REQUEST_METHOD             MSG_REQUEST__BASE+2
#define  MSG_REQUEST_BODY_READ          MSG_REQUEST__BASE+3
#define  MSG_REQUEST_BODY_MAX           MSG_REQUEST__BASE+4
#define  MSG_REQUEST_REDIRECTION        MSG_REQUEST__BASE+5
#define  MSG_REQUEST_URL_ENC            MSG_REQUEST__BASE+6
#define  MSG_REQUEST_URL_FORM           MSG_REQUEST__BASE+7
#define  MSG_REQUEST__MAX               7

#define  MSG_SCRIPT__BASE               MSG_REQUEST__BASE+MSG_REQUEST__MAX+1
#define  MSG_SCRIPT_NOT_FOUND           MSG_SCRIPT__BASE+1
#define  MSG_SCRIPT_HARD_LIMIT          MSG_SCRIPT__BASE+2
#define  MSG_SCRIPT_PRAGMA              MSG_SCRIPT__BASE+3
#define  MSG_SCRIPT_COOKIE              MSG_SCRIPT__BASE+4
#define  MSG_SCRIPT_IPC                 MSG_SCRIPT__BASE+5
#define  MSG_SCRIPT_SPAWN               MSG_SCRIPT__BASE+6
#define  MSG_SCRIPT_DCL_ENVIRONMENT     MSG_SCRIPT__BASE+7
#define  MSG_SCRIPT_CGIPLUS_VARIABLES   MSG_SCRIPT__BASE+8
#define  MSG_SCRIPT__MAX                8

#define  MSG_SSI__BASE                  MSG_SCRIPT__BASE+MSG_SCRIPT__MAX+1
#define  MSG_SSI_ERROR                  MSG_SSI__BASE+1
#define  MSG_SSI_LINE                   MSG_SSI__BASE+2
#define  MSG_SSI_ACCESS_DISABLED        MSG_SSI__BASE+3
#define  MSG_SSI_STATEMENT              MSG_SSI__BASE+4
#define  MSG_SSI_STATEMENT_UNKNOWN      MSG_SSI__BASE+5
#define  MSG_SSI_TAG_UNKNOWN            MSG_SSI__BASE+6
#define  MSG_SSI_TAG_VALUE              MSG_SSI__BASE+7
#define  MSG_SSI_DCL_DISABLED           MSG_SSI__BASE+8
#define  MSG_SSI_DCL_UNSUPPORTED        MSG_SSI__BASE+9
#define  MSG_SSI_DCL_NOT_SYSTEM         MSG_SSI__BASE+10
#define  MSG_SSI_DCL_NOT_WORLD          MSG_SSI__BASE+11
#define  MSG_SSI_INCLUDE_NOT_TEXT       MSG_SSI__BASE+12
#define  MSG_SSI_INCLUDE_ACCESS         MSG_SSI__BASE+13
#define  MSG_SSI_DATE_TIME              MSG_SSI__BASE+14
#define  MSG_SSI_RECURSION              MSG_SSI__BASE+15
#define  MSG_SSI_VARIABLE               MSG_SSI__BASE+16
#define  MSG_SSI_VARIABLE_NOT_FOUND     MSG_SSI__BASE+17
#define  MSG_SSI_FLOW_CONTROL           MSG_SSI__BASE+18
#define  MSG_SSI__MAX                   18

#define  MSG_STATUS__BASE               MSG_SSI__BASE+MSG_SSI__MAX+1
#define  MSG_STATUS_SUCCESS             MSG_STATUS__BASE+1
#define  MSG_STATUS_ERROR               MSG_STATUS__BASE+2
#define  MSG_STATUS_REPORTED_BY_SERVER  MSG_STATUS__BASE+3
#define  MSG_STATUS_DOC_NOT_FOUND       MSG_STATUS__BASE+4
#define  MSG_STATUS_FILE_NOT_FOUND      MSG_STATUS__BASE+5
#define  MSG_STATUS_DOC_PROTECTION      MSG_STATUS__BASE+6
#define  MSG_STATUS_FILE_PROTECTION     MSG_STATUS__BASE+7
#define  MSG_STATUS_NO_INFORMATION      MSG_STATUS__BASE+8
#define  MSG_STATUS_ADVISE_NOSUCHFILE   MSG_STATUS__BASE+9
#define  MSG_STATUS_ADVISE_PRV          MSG_STATUS__BASE+10
#define  MSG_STATUS_ADVISE_NOPRIV       MSG_STATUS__BASE+11
#define  MSG_STATUS_ADVISE_SYNTAX       MSG_STATUS__BASE+12
#define  MSG_STATUS_ADVISE_FLK          MSG_STATUS__BASE+13
#define  MSG_STATUS_ADVISE_CORRECT      MSG_STATUS__BASE+14
#define  MSG_STATUS_REPORT              MSG_STATUS__BASE+15
#define  MSG_STATUS_INFO                MSG_STATUS__BASE+16
#define  MSG_STATUS__MAX                16

#define  MSG_UPD__BASE                  MSG_STATUS__BASE+MSG_STATUS__MAX+1
#define  MSG_UPD_FILENAME               MSG_UPD__BASE+1
#define  MSG_UPD_DIRECTORY              MSG_UPD__BASE+2
#define  MSG_UPD_QUERY_FIELD            MSG_UPD__BASE+3
#define  MSG_UPD_FILTER                 MSG_UPD__BASE+4
#define  MSG_UPD_SRC_FILENAME           MSG_UPD__BASE+5
#define  MSG_UPD_DST_FILENAME           MSG_UPD__BASE+6
#define  MSG_UPD_CUR_FILENAME           MSG_UPD__BASE+7
#define  MSG_UPD_NEW_FILENAME           MSG_UPD__BASE+8
#define  MSG_UPD_RENAME_SAME            MSG_UPD__BASE+9
#define  MSG_UPD_ACTION                 MSG_UPD__BASE+10
#define  MSG_UPD_NOT_TEXT_FILE          MSG_UPD__BASE+11
#define  MSG_UPD_PARENT_DIRECTORY       MSG_UPD__BASE+12
#define  MSG_UPD_NAVIGATE               MSG_UPD__BASE+13
#define  MSG_UPD_CREATE                 MSG_UPD__BASE+14
#define  MSG_UPD_DELETE                 MSG_UPD__BASE+15
#define  MSG_UPD_RENAME                 MSG_UPD__BASE+16
#define  MSG_UPD_COPY                   MSG_UPD__BASE+17
#define  MSG_UPD_EDIT                   MSG_UPD__BASE+18
#define  MSG_UPD_PROTECTION_LIST        MSG_UPD__BASE+19
#define  MSG_UPD_PROTECTION             MSG_UPD__BASE+20
#define  MSG_UPD_RENAMED                MSG_UPD__BASE+21
#define  MSG_UPD__MAX                   21

/*
#define  MSG_?__BASE                    MSG_!__BASE+MSG_!__MAX+1
#define  MSG_?_                         MSG_?__BASE+
#define  MSG_?__MAX                     0
*/

#define NUMBER_OF_GROUPS 12

#define  MSG_TOTAL  MSG_AUTH__MAX + \
                    MSG_DIR__MAX + \
                    MSG_GENERAL__MAX + \
                    MSG_HTADMIN__MAX + \
                    MSG_ISMAP__MAX + \
                    MSG_MAPPING__MAX + \
                    MSG_PUT__MAX + \
                    MSG_REQUEST__MAX + \
                    MSG_SCRIPT__MAX + \
                    MSG_SSI__MAX + \
                    MSG_STATUS__MAX + \
                    MSG_UPD__MAX

#define MSG_RANGE MSG_TOTAL+NUMBER_OF_GROUPS

#define MAX_LANGUAGES 4

struct MsgStruct
{
   int  LanguageNumber;
   char  LanguageName [32];
   char  *HostListPtr;
   char  *TextPtr [MSG_RANGE+1];
};

struct MsgDbStruct
{
   int  LanguageCount,
        LanguageDefault,
        LineNumber,
        ProblemCount,
        ProblemReportLength;
   char  *LinePtr,
         *ProblemReportPtr;
   char  LoadFileName [256];
   unsigned long  LoadBinTime [2],
                  RevBinTime [2];

   struct MsgStruct  *Msgs[MAX_LANGUAGES+1];

   /* only used when reporting or changing configuration */
   void  *RequestPtr;
};

char* MsgCreate (char*);
char* MsgFor (struct RequestStruct*, int);
char* MsgForNoRequest (char*, char*, int);

MsgLoad (struct MsgDbStruct*);
MsgReport (struct RequestStruct*, void*, boolean);
MsgReportNow (struct RequestStruct*, struct MsgDbStruct*);
MsgReportProblem (struct MsgDbStruct*, char*, int);
MsgUnload (struct MsgDbStruct*);

/*****************************************************************************/
