/*****************************************************************************/
/*
                                   Net.h

Function prototypes for TCP/IP networking module.

*/
/*****************************************************************************/

/***********************/
/* function prototypes */
/***********************/

#ifdef IP_UCX
   NetAccessDenied (unsigned short, char*, char*);
   NetDirectWrite (unsigned short, char*, int);
   NetDummyRead (unsigned short);
   NetDummyReadAst (unsigned short);
   NetShutdownSocketUcx (unsigned short, void*, boolean);
   NetCloseSocketUcx (unsigned short);
   NetTooBusy (unsigned short, char*, char*);
#endif

#ifdef IP_NETLIB
   NetAccessDenied (unsigned long*, char*, char*);
   NetDirectWrite (unsigned long*, char*, int);
   NetDummyRead (unsigned long*);
   NetDummyReadAst (unsigned long*);
   NetShutdownSocketNetLib (unsigned long*, void*, boolean);
   NetCloseSocketNetLib (unsigned long*);
   NetTooBusy (unsigned long*, char*, char*);
#endif

int NetWriteBuffered (struct RequestStruct*, void*, char*, int);
int NetWriteDefered (struct RequestStruct*, void*, char*, int);
int NetWriteDeferedBuffers (struct RequestStruct*);
NetAccept (struct ServiceStruct*);
NetAcceptAst (struct ServiceStruct*);
NetCreateService ();
NetGetService ();
NetGetServerHostName ();
NetHostLookup ();
NetListen ();
NetServerShutdown (unsigned short);
NetResponseHeaderAst (struct RequestStruct*);
NetShutdownSocket (struct RequestStruct*, void*, boolean);
NetCloseSocket (struct RequestStruct*);
int NetRead (struct RequestStruct*, void*, char*, int);
int NetWrite (struct RequestStruct*, void*, char*, int);

/*****************************************************************************/

