/*****************************************************************************/
/*
                                 Vm.h

Function for virtual memory management module.

*/
/*****************************************************************************/

VmGeneralInit ();
char* VmGet (unsigned long);
VmFree (char*);
char* VmRealloc (char*, unsigned long);

VmHeapInit ();
char* VmGetHeap (struct RequestStruct*, unsigned long);
VmFreeHeap (struct RequestStruct*);
VmFreeFromHeap (struct RequestStruct*, char*);
char* VmReallocHeap (struct RequestStruct*, char*, unsigned long);

VmRequestInit ();
struct RequestStruct* VmGetRequest ();
VmFreeRequest (struct RequestStruct*);

VmCacheInit (int, int);
char* VmGetCache (unsigned long);
VmFreeCache (char*);

VmReport (struct RequestStruct*, void*);
VmWrite (struct dsc$descriptor*, struct RequestStruct*);

/*****************************************************************************/

