/*****************************************************************************
/*
                                  WASD.h

Main header file for WASD VMS HTTP daemon.


VERSION HISTORY
---------------
14-APR-98  MGD  v5.0.1, XSSI extensions
07-JAN-98  MGD  v5.0.0, HTTPd version 5 (Secure Sockets Layer, using SSLeay)
05-OCT-97  MGD  v4.5.0, file cache
06-SEP-97  MGD  v4.4.0, multiple server host names and ports
08-JUN-97  MGD  v4.2.0, CGIplus
01-FEB-97  MGD  v4.0.0, version 4 :^)
01-AUG-96  MGD  v3.3.0, quite a few changes since 3.0.n
01-DEC-95  MGD  v3.0.0, HTTPd version 3
20-DEC-94  MGD  v2.0.0, multi-threaded version
20-JUN-94  MGD  v1.0.0, single-threaded version
*/
/*****************************************************************************/

#include <descrip.h>
#include <rms.h>
#include <ssdef.h>
#include <stsdef.h>
#include <rmsdef.h>

#ifndef WASD_AUTH_H
#include "auth.h"
#endif

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/**********/
/* macros */
/**********/

/* IP_NONE  is defined when compiling MapUrl.c for stand-alone use */
#ifndef IP_NONE
/* if not NETLIB then UCX! */
#ifndef IP_NETLIB
#  undef IP_UCX
#  define IP_UCX 1
#endif
#endif

#define boolean int
#define true 1
#define false 0

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) (!((x) & STS$M_SUCCESS))

#define FI_LI __FILE__, __LINE__

#define AuthConfigFileName "HTTPD$AUTH"
#define ConfigFileName "HTTPD$CONFIG"
#define MapFileName "HTTPD$MAP"
#define MsgFileName "HTTPD$MSG"

/* this value must also include connections in a "keep-alive" state */
#define DefaultMaxConcurrentConnections 20

#define DefaultInputTimeoutMinutes 1
#define DefaultOutputTimeoutMinutes 10
#define DefaultKeepAliveTimeoutSeconds 0

#define DefaultDclSysOutputSize 4096
#define DefaultFileBufferSize 1024
#define DefaultNetReadBufferSize 2048
#define DefaultOutputBufferSize 4096

#define HttpdInternalScriptEcho "/echo"
#define HttpdInternalScriptTree "/tree"
#define HttpdInternalScriptUpd "/upd"
#define HttpdInternalScriptWhere "/where"
#define HttpdInternalScriptXray "/xray"

#define HttpdInternalPasswordChange "/httpd/-/change/"

#define HttpdInternal "/httpd/-/"

#define HttpdInternalAdmin "/httpd/-/admin/"

#define HttpdInternalControl "/httpd/-/admin/control/"
#define HttpdInternalControlRestart "/httpd/-/admin/control/restart"
#define HttpdInternalControlRestartNow "/httpd/-/admin/control/restartNOW"
#define HttpdInternalControlExit "/httpd/-/admin/control/exit"
#define HttpdInternalControlExitNow "/httpd/-/admin/control/exitNOW"
#define HttpdInternalControlLogOn "/httpd/-/admin/control/logon"
#define HttpdInternalControlLogOff "/httpd/-/admin/control/logoff"
#define HttpdInternalControlLogFlush "/httpd/-/admin/control/logflush"
#define HttpdInternalControlCacheOn "/httpd/-/admin/control/cacheon"
#define HttpdInternalControlCacheOff "/httpd/-/admin/control/cacheoff"
#define HttpdInternalControlCachePurge "/httpd/-/admin/control/cachepurge"

#define HttpdInternalGraphic "/httpd/-/admin/graphic/"
#define HttpdInternalGraphicActivity "/httpd/-/admin/graphic/activity"

#define HttpdInternalReport "/httpd/-/admin/report/"
#define HttpdInternalReportActivity "/httpd/-/admin/report/activity"
#define HttpdInternalReportCache "/httpd/-/admin/report/cache"
#define HttpdInternalReportRules "/httpd/-/admin/report/rules"
#define HttpdInternalReportSSL "/httpd/-/admin/report/SSL"

#define HttpdInternalRevise "/httpd/-/admin/revise/"
#define HttpdInternalReviseAuth "/httpd/-/admin/revise/auth/"
#define HttpdInternalReviseConfig "/httpd/-/admin/revise/config"
#define HttpdInternalReviseMessages "/httpd/-/admin/revise/messages"
#define HttpdInternalRevisePaths "/httpd/-/admin/revise/paths"
#define HttpdInternalReviseRules "/httpd/-/admin/revise/rules"

/* helps ensure a client doesn't get into an infinite loop */
#define MaxKeepAliveCount 100

/*
   Attempt to reduce dynamic memory fragmentation within C RTL by
   maintaining a minimum size chunk to be allocated.  Hopefully this
   will prevent lots of small chunks having to be garbage-collected
   or otherwise processed (as has sometimes been observed ... at least
   this is the best explanation I can come up with).
*/
#define HEAP_MIN_CHUNK_SIZE 256

/* control pre-expired responses */
#define PRE_EXPIRE_ADMIN 1
#define PRE_EXPIRE_DELETE_ON_CLOSE 1
#define PRE_EXPIRE_INDEX_OF 0
#define PRE_EXPIRE_MENU 1
#define PRE_EXPIRE_PUT 1
#define PRE_EXPIRE_SSI 0
#define PRE_EXPIRE_UPD 1
#define PRE_EXPIRE_UPD_TREE_OF 1

/* constants used to identify HTTP methods */
#define HTTP_METHOD_DELETE 0x00000001
#define HTTP_METHOD_GET 0x00000002
#define HTTP_METHOD_HEAD 0x00000004
#define HTTP_METHOD_POST 0x00000008
#define HTTP_METHOD_PUT 0x00000010

/* constants for controlling logging */
#define LOGGING_BEGIN 1
#define LOGGING_END 2
#define LOGGING_OPEN 3
#define LOGGING_CLOSE 4
#define LOGGING_FLUSH 5
#define LOGGING_ENTRY 6

/* constants used by HTTPd supervisor timer functionality */
#define TIMER_INPUT 1
#define TIMER_OUTPUT 2
#define TIMER_KEEPALIVE 3

/* constants used by the description module */
#define DESCRIPTION_ALL 0x01
#define DESCRIPTION_TEXT_PLAIN 0x02
#define DESCRIPTION_TEXT_HTML 0x04
/* this is returned in the first character the file type contains none */
#define DESCRIPTION_IMPOSSIBLE 0xff

/* default directory listing layout */
#define DEFAULT_DIR_LAYOUT "I__L__R__S__D"

/* "http:" or "https:" service and request */
#define SCHEME_HTTP  1
#define SCHEME_HTTPS 2

/* if non-zero then imposes a maximum byte count on a request body */
#define MaxContentLength 0

/* maximum Kbytes (1024) that can be in a body to be POSTed or PUTted */
#define DefaultPutMaxKbytes 250
/* number of versions retained for files POSTed or PUTed */
#define DefaultPutVersionLimit 3

/* header fields for HTTP/1.0 keep alive response */
#define KeepAliveHttpHeader "Connection: Keep-Alive\r\nKeep-Alive:\r\n"

/* if true, stops HTTPd server account with SYSPRV PUT(etc)ing - DANGEROUS */
#define PUT_DISALLOW_SYSPRV 0

#define MaxConfigHomePages 16
#define MaxConfigReadMeFiles 16
#define MaxConfigScriptRunTimes 16

#define SCRIPT_NAME_SIZE 128
#define METHOD_NAME_SIZE 16

/* W:RE,G:RE,O:RWED,S:RWED */
#define PUT_DEFAULT_FILE_PROTECTION 0xaa00

/*************/
/* durations */
/*************/

/* 1000 = 1mS, 100 = 100uS, 10 = 10Us, 1 = 1uS (for really fast systems :^) */
#define DURATION_UNITS_USECS 1000

#if DURATION_UNITS_USECS == 1
#  define DURATION_DECIMAL_PLACES 6
#elif DURATION_UNITS_USECS == 10
#  define DURATION_DECIMAL_PLACES 5
#elif DURATION_UNITS_USECS == 100
#  define DURATION_DECIMAL_PLACES 4
#else
   /* defaults to milliseconds */
#  undef DURATION_UNITS_USECS
#  define DURATION_UNITS_USECS 1000
#  define DURATION_DECIMAL_PLACES 3
#endif

#define USECS_IN_A_SECOND 1000000

/*********************/
/* functional macros */
/*********************/

/* is it linear-white-space? (avoids the call overhead of an isspace()) */
#define ISLWS(c) (c == ' ' || c == '\t')

/* end of CR or LF terminated line? */
#define EOL(c) (c == '\r' || c == '\n' || !*cptr)
#define NOTEOL(c) (c != '\r' && c != '\n' && *cptr)

#define STRCPY(src,dst,errfunc) \
   cptr = src; \
   zptr = (sptr = dst) + sizeof(src); \
   while (*cptr && sptr < zptr) *sptr++ = *cptr++; \
   if (sptr >= zptr) \
   { \
      ErrorGeneralOverflow (rqptr, FI_LI); \
      errfunc (rqptr); \
      return; \
   } \
   *sptr = '\0';

#define STRCPYLEN(src,dst,dstlen,errfunc) \
   cptr = src; \
   zptr = (sptr = dst) + sizeof(src); \
   while (*cptr && sptr < zptr) *sptr++ = *cptr++; \
   if (sptr >= zptr) \
   { \
      ErrorGeneralOverflow (rqptr, FI_LI); \
      errfunc (rqptr); \
      return; \
   } \
   *sptr = '\0'; \
   dstlen = sptr - dst;

/*************************************************/
/* macros for development timing in microseconds */
/*************************************************/

/* 0..9 timers available */

#define USEC_TIMER_STORAGE \
   unsigned long  uSecSubx2 = 2, \
                  uSecEdiv10 = 10; \
   unsigned long  uSecResult, \
                  uSecDuration, \
                  uSecRemainder; \
   unsigned long  uSecBeginQuad [10][2], \
                  uSecEndQuad [10][2];

#define USEC_TIMER_STORAGE_EXTERN \
   extern unsigned long  uSecSubx2, \
                         uSecEdiv10; \
   extern unsigned long  uSecResult, \
                         uSecDuration, \
                         uSecRemainder; \
   extern unsigned long  uSecBeginQuad [10][2], \
                         uSecEndQuad [10][2];

#define USEC_TIMER_BEGIN(IDX) \
{ \
   sys$gettim (&uSecBeginQuad[IDX]); \
}

#define USEC_TIMER_END(IDX,WHERE) \
{ \
   sys$gettim (&uSecEndQuad[IDX]); \
   lib$subx (&uSecEndQuad[IDX], &uSecBeginQuad[IDX], &uSecResult, &uSecSubx2); \
   lib$ediv (&uSecEdiv10, &uSecResult, &uSecDuration, &uSecRemainder); \
   fprintf (stdout, "%s uS: %d\n", WHERE, uSecDuration); \
}

/*******************/
/* data structures */
/*******************/

# pragma member_alignment __save
# pragma nomember_alignment

struct VmsItem
{
   unsigned short  buf_len;
   unsigned short  item;
   unsigned char   *buf_addr;
   unsigned short  *ret_len;
};

struct AnExitHandler
{
   unsigned long  Flink;
   unsigned long  HandlerAddress;
   unsigned long  ArgCount;
   unsigned long  ExitStatusPtr;
};

struct AnIOsb
{
   unsigned short  Status;
   unsigned short  Count;
   unsigned long  Unused;
};

struct MbxSenseIOsb
{
   unsigned short  Status;
   unsigned short  MessageCount;
   unsigned long  MessageBytes;
};

#pragma member_alignment __restore

/*
   Store these structures naturally-aligned on AXP.
   Uses a bit more storage but makes access as efficient as possible.
*/

#ifdef __ALPHA
#   pragma member_alignment __save
#   pragma member_alignment
#endif

/* per-request memory heap */
struct HeapStruct
{
   struct HeapStruct  *PrevPtr;
   struct HeapStruct  *NextPtr;
   unsigned int  ChunkSize;
   /* the actual data follows immediately after the length */
};

/*
This structure is used to both store and to point at the various components
depending on the context.
*/

struct ContentTypeStruct
{
   struct ContentTypeStruct  *NextPtr,
                             *HashCollisionPtr;
   boolean  ContentTypeUnknown;
   char  *SuffixPtr;
   char  *ContentTypePtr;
   char  *AutoScriptNamePtr;
   char  *ContentDescriptionPtr;
   char  *IconPtr;
   /* string data is stored here */
};

/*
This structure is used to both store and to point at the various components
depending on the context.
*/

struct IconStruct
{
   struct IconStruct  *NextPtr,
                      *HashCollisionPtr;
   /* string data is stored here */
};

struct  ListEntryStruct
{
   struct ListEntryStruct  *PrevPtr;
   struct ListEntryStruct  *NextPtr;
};

struct  ListHeadStruct
{
   struct ListEntryStruct  *HeadPtr;
   struct ListEntryStruct  *TailPtr;
   int  EntryCount;
};

/* these macros operate on the list head */
#define LIST_HEAD(lp) ((char*)((struct ListHeadStruct*)lp)->HeadPtr)
#define LIST_TAIL(lp) ((char*)((struct ListHeadStruct*)lp)->TailPtr)
#define LIST_COUNT(lp) (((struct ListHeadStruct*)lp)->EntryCount)
#define LIST_EMPTY(lp) (!((struct ListHeadStruct*)lp)->EntryCount)

/* these macros operate on list entries */
#define LIST_DATA(lp) ((char*)((char*)lp+sizeof(struct ListEntryStruct)))
#define LIST_PREV(lp) (((struct ListEntryStruct*)lp)->PrevPtr)
#define LIST_NEXT(lp) (((struct ListEntryStruct*)lp)->NextPtr)
#define LIST_HAS_PREV(lp) ((((struct ListEntryStruct*)lp)->PrevPtr) != NULL)
#define LIST_HAS_NEXT(lp) ((((struct ListEntryStruct*)lp)->NextPtr) != NULL)

/************************/
/* file cache structure */
/************************/

struct CacheStruct
{
   struct ListEntryStruct  CacheListEntry;

   struct CacheStruct  *HashCollisionNextPtr,
                       *HashCollisionPrevPtr;

   boolean  /* cache is currently being loaded for this path/file */
            CacheLoading,
            /* data load completed OK */
            CacheLoadValid,
            /* cache entry has been invalidated to scavenge memory */
            CacheScavenged,
            /* data in cache is valid and can be use for requests */
            CacheValid,
            /* remove allocated data buffer as soon as not in use */
            Purge,
            /* also remove cache entry */
            PurgeCompletely;

   unsigned short /* first free byte in end-of-file VBN */
                  FirstFreeByte,
                  /* first free byte in end-of-file VBN when validating */
                  ValidateFirstFreeByte;

   unsigned long  /* size of the block pointed to by 'ContentPtr' */
                  CacheSize,
                  /* number of times current allocated buffer been reused */
                  ContentBufferUsedCount,
                  /* number of times buffer has been reallocated */
                  ContentBufferReallocatedCount,
                  /* length of data (file contents) pointed to 'ContentPtr' */
                  ContentLength,
                  /* length of "dev:" in file name */
                  DeviceNameLength,
                  /* virtual block number of end-of-file */
                  EndOfFileVbn,
                  /* length of "dev:[dir]name.type;" */
                  FileNameLength,
                  /* hash value of characters in path */
                  HashValue,
                  /* number of times cache used */
                  HitCount,
                  /* number of times cache hit but file unmodified */
                  HitNotModifiedCount,
                  /* cache entry is in use and should not be modified */
                  InUseCount,
                  /* length of "name.type" in file name */
                  NameTypeLength,
                  /* length of path */
                  PathLength,
                  /* virtual block number of end-of-file when validating */
                  ValidateEndOfFileVbn,
                  /* number of times the entry has been validated */
                  ValidatedCount;

   unsigned long  /* last hit quadword */
                  HitBinaryTime [2],
                  /* when cache data loaded quadword */
                  LoadBinaryTime [2],
                  /* last modified quadword */
                  ModifiedBinaryTime [2],
                  /* last validated quadword */
                  ValidateBinaryTime [2],
                  /* last validated quadword */
                  ValidateModifiedBinaryTime [2];

   unsigned char  /* 6 byte directory id field from the NAM block */
                  FileNam_did [6];

   unsigned char  /* points to file contents */
                  *ContentPtr,
                  /* points to file's MIME content type */
                  *ContentTypePtr,
                  /* points to "dev:" in file name */
                  *DeviceNamePtr,
                  /* points to "[dir]name,type" in file name */
                  *NameTypePtr;

   char  /* path representing the cached file */
         Path [128],
         /* RMS file name */
         FileName [128];
};

/**********************************/
/* request history data structure */
/**********************************/

/* 256 bytes (a somewhat arbitrary quantity) */
struct  RequestHistoryStruct
{
   struct  ListEntryStruct  HistoryListEntry;
   unsigned long  BinaryTime [2];
   unsigned long  BytesRx,
                  BytesTx,
                  ResponseDuration;
   int  RequestScheme,
        ResponseStatusCode;
   char  *RequestPtr;
   boolean  Truncated;
   char  ClientAndRequest [256-12-8-4-4-4-4-4-4];
};

/**********************************/
/* server configuration structure */
/**********************************/

/* must be powers of two! */
#define  CONTENT_TYPE_HASH_TABLE_SIZE  128
#define  CONTENT_TYPE_HASH_TABLE_MASK  CONTENT_TYPE_HASH_TABLE_SIZE-1
#define  ICON_HASH_TABLE_SIZE  64
#define  ICON_HASH_TABLE_MASK  ICON_HASH_TABLE_SIZE-1

struct ConfigStruct
{
   boolean  AuthBasicEnabled,
            AuthDigestEnabled,
            CacheEnabled,
            DclFullRequest,
            DclSpawnAuthPriv,
            DirAccess,
            DirAccessSelective,
            DirNoImpliedWildcard,
            DirNoPrivIgnore,
            DirOwnerEnabled,
            DirPreExpired,
            DirReadMeBottom,
            DirReadMeTop,
            DirWildcardEnabled,
            DnsLookup,
            ErrorRecommend,
            ErrorSourceInfo,
            IncludeCommentedInfo,
            LoggingEnabled,
            LogPerService,
            MonitorEnabled,
            SsiEnabled,
            SsiAccessesEnabled,
            SsiExecEnabled;

   int  AcceptHostsLength,
        ActivityNumberOfDays,
        AuthCacheMinutes,
        AuthDigestNonceGetLifeTime,
        AuthDigestNoncePutLifeTime,
        AuthFailureLimit,
        AuthRevalidateUserMinutes,
        Busy,
        CacheEntriesMax,
        CacheChunkKBytes,
        CacheFileKBytesMax,
        CacheFrequentHits,
        CacheFrequentSeconds,
        CacheHashTableEntries,
        CacheTotalKBytesMax,
        CacheValidateSeconds,
        DclCgiPlusLifeTime,
        DclSubprocessHardLimit,
        DclSubprocessSoftLimit,
        DclZombieLifeTime,
        DECnetConnectListMax,
        DECnetReuseLifeTime,
        DirDescriptionLines,
        HomePageCount,
        InputTimeoutMinutes,
        KeepAliveTimeoutSeconds,
        LogExcludeHostsLength,
        OutputTimeoutMinutes,
        PutMaxKbytes,
        PutVersionLimit,
        ReadMeFileCount,
        RejectHostsLength,
        RequestHistory,
        ScriptRunTimeCount,
        ServerPort,
        ServiceLength,
        StreamLfConversionMaxKbytes,
        StreamLfPathsLength;

   int  ScriptRunTimeLengthArray [MaxConfigScriptRunTimes];

   struct ContentTypeStruct  
      *ContentTypeHashTable [CONTENT_TYPE_HASH_TABLE_SIZE];
   struct IconStruct *IconHashTable [ICON_HASH_TABLE_SIZE];

   char  DefaultDirLayout [32],
         KeywordSearch [128],
         LogFileName [128],
         LogFormat [128],
         LogNaming [32],
         LogPeriod [32];

   char  *AcceptHostsPtr,
         *DefaultPost,
         *LogExcludeHostsPtr,
         *RejectHostsPtr,
         *ServicePtr,
         *StreamLfPathsPtr;

   char  *HomePageArray [MaxConfigHomePages],
         *ReadMeFileArray [MaxConfigReadMeFiles],
         *ScriptRunTimeArray [MaxConfigScriptRunTimes];

   struct ContentTypeStruct  *ContentTypeListHeadPtr,
                             *ContentTypeListTailPtr;
   char  *ContentTypeDefaultPtr;
   int  ContentTypeStructOverhead;

   struct IconStruct  *IconListHeadPtr,
                      *IconListTailPtr;
   int  IconStructOverhead;

   /* only used while reading configuration from file */
   int  LineNumber,
        ProblemCount,
        ProblemReportLength;
   char  *ProblemReportPtr;
   char  DirectiveName [32],
         LoadFileName [256];
   unsigned long  LoadBinTime [2],
                  RevBinTime [2];

   /* only used when reporting or changing configuration */
   void  *RequestPtr;
};

/*********************/
/* service structure */
/*********************/

/* Internet-related header files */
#ifdef IP_UCX
#   include <socket.h>
#   include <in.h>
#   include <netdb.h>
#   include <inet.h>
#   ifdef IP_TCPWARE
#      include "tcpware_include:ucx$inetdef.h"
#   else
#      include <ucx$inetdef.h>
#   endif
#endif

#ifdef IP_NETLIB
#   include "netlibdef.h"
#endif

struct ServiceStruct
{
   struct ServiceStruct  *NextPtr;

   boolean  LogFileOpen,
            LogFileError;
   int  ConnectCount,
        LogFileNameLength,
        RequestScheme,
        ServerHostNameLength,
        ServerPort;
   unsigned long  ClientInternetAddress32bit,
                  ServerInternetAddress32bit;
   char  *RequestSchemeNamePtr;
   char  ClientHostName [128],
         ClientInternetAddress [32],
         LogFileName [256],
         LogHostName [64],
         ServerHostName [128],
         ServerHostPort [128],
         ServerInternetAddress [32],
         ServerPortString [16];
   struct AnIOsb  ServerIOsb;

   struct dsc$descriptor  LogFileNameDsc;
   
   struct FAB  LogFileFab;
   struct RAB  LogFileRab;

#ifdef IP_UCX

   unsigned short  ClientChannel,
                   ServerChannel;

   struct sockaddr_in  ServerSocketName,
                       ClientSocketName;

   struct hostent  *HostEntryPtr;

   struct {
      unsigned int  Length;
      char  *Address;
   } ServerSocketNameItem;

   int  ClientSocketNameLength;
   struct {
      unsigned int  Length;
      char  *Address;
      unsigned int  *LengthPtr;
   } ClientSocketNameItem;

#endif

#ifdef IP_NETLIB

   unsigned long  ClientNetLibSocket,
                  ServerNetLibSocket;

   struct SINDEF  ServerNetLibName,
                  ClientNetLibName;

   struct INADDRDEF NetLibAddressList [16];

   unsigned long  NetLibReturnedLength;
   struct dsc$descriptor  ClientInternetAddressDsc;
   struct dsc$descriptor  ServerHostNameDsc;
   struct dsc$descriptor  ServerInternetAddressDsc;

#endif

};

/*************************/
/* per-server accounting */
/*************************/

/* as of v4.4 this structure is now > 255 bytes requiring two logicals */

struct AccountingStruct
{
   /* this is used to check for changes in HTTPd version requiring zeroing */
   unsigned long  AccountingVersion;
   /* this MUST be the first member (or so) to allow zeroing of the rest */
   unsigned long  ZeroedCount;

   unsigned long  AuthBasicCount,
                  AuthAuthorizedCount,
                  AuthDigestCount,
                  AuthHtDatabaseCount,
                  AuthNotAuthenticatedCount,
                  AuthNotAuthorizedCount,
                  AuthVmsCount,
                  CacheHitCount,
                  CacheHitNotModifiedCount,
                  CacheLoadCount,
                  ConnectAcceptedCount,
                  ConnectCount,
                  ConnectSslCount,
                  ConnectCurrent,
                  ConnectPeak,
                  ConnectRejectedCount,
                  ConnectTooBusyCount,
                  DclCgiPlusReusedCount,
                  DclSpawnCount,
                  DoAutoScriptCount,
                  DoCgiPlusScriptCount,
                  DoDclCommandCount,
                  DoDECnetCount,
                  DoDECnetReuseCount,
                  DoDECnetCgiCount,
                  DoDECnetCgiReuseCount,
                  DoDECnetOsuCount,
                  DoDECnetOsuReuseCount,
                  DoDirectoryCount,
                  DoIsMapCount,
                  DoScriptCount,
                  DoFileCount,
                  DoFileNotModifiedCount,
                  DoMenuCount,
                  DoPutCount,
                  DoServerAdminCount,
                  DoSsiCount,
                  DoUpdateCount,
                  LastExitStatus,
                  MethodDeleteCount,
                  MethodGetCount,
                  MethodHeadCount,
                  MethodPostCount,
                  MethodPutCount,
                  MethodTraceCount,
                  RedirectLocalCount,
                  RedirectRemoteCount,
                  RequestTotalCount,
                  RequestErrorCount,
                  RequestForbiddenCount,
                  RequestKeepAliveCount,
                  RequestKeepAliveMax,
                  RequestParseCount,
                  RequestPragmaNoCacheCount,
                  RequestProxyCount,
                  ResponseDurationCount,
                  ResponseDurationMax,
                  ResponseDurationMin,
                  StartupCount,
                  StreamLfConversionCount;

   unsigned long  QuadBytesRx [2],
                  QuadBytesTx [2],
                  QuadResponseDuration [2];

   unsigned long  ResponseStatusCodeCountArray [6];
};

/***********************/
/* graph/gif structure */
/***********************/

struct GraphTaskStruct
{
   /* the structure in actually defined in Graph.c */
   void  *GraphPtr;

   /* pointer a request using this graph structure */
   struct RequestStruct  *rqptr;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/************************/
/* DCL module structure */
/************************/

struct DclTaskStruct
{
   /* */
   struct  ListEntryStruct  DclListEntry;

   boolean  /* add a newline to each record from a script subprocess */
            AddNewline,
            /* record-by-record output from DCL, flush immediately */
            BufferRecords,
            /* this is a "standard" CGI script */
            CgiScript,
            /* this is a "CGI-plus" script */
            CgiPlusScript,
            /* script read variables (i.e. became active) */
            CgiScriptActivated,
            /* script provided response (i.e. sent some output) */
            CgiScriptResponded,
            /* output is text (plain or html) */
            ContentTypeText,
            /* this is merely a DCL command (from SSI) */
            IsDclCommand,
            /* when the task completes the subprocess is deleted */
            IsMarkedForDelete;
            
   int  /* number of times the CGIplus script has been used */
        CgiPlusUsageCount,
        /* remaining content in POST script */
        ContentLength,
        /* length of the DCL EOF string */
        DclEofLength,
        /* used by the DclSupervisor() */
        LifeTimeCount,
        /* count of I/Os CGIplus variables reads still outstanding */
        QueuedCgiPlusIn,
        /* count of HTTP$INPUT reads still outstanding */
        QueuedHttpInput,
        /* count of I/Os between subprocess and HTTPd still outstanding */
        QueuedSysCommand,
        /* when the count of I/Os is considered task finished */
        QueuedSysCommandAllowed,
        /* count of I/Os between subprocess and HTTPd still outstanding */
        QueuedSysOutput,
        /* size of DCL subprocess' SYS$OUTPUT buffer */
        SysOutputSize,
        /* total number of times the task slot was used */
        TotalUsageCount,
        /* number of subprocess has been a zombie */
        ZombieCount;

   unsigned short  /* channel to subprocess' CGIPLUSIN mailbox */
                   CgiPlusInChannel,
                   /* channel to subprocess' HTTP$INPUT mailbox */
                   HttpInputChannel,
                   /* channel to subprocess' SYS$INPUT mailbox */
                   SysCommandChannel,
                   /* channel to subprocess' SYS$OUTPUT mailbox */
                   SysOutputChannel;

   unsigned long  /* subprocess' exit status */
                  SubprocessCompletionStatus,
                  /* subprocess' PID */
                  SubprocessPid;

   unsigned long  /* last time CGIplus script was used */
                  LastUsedBinaryTime [2];

   unsigned char  /* content pointer in POST script */
                  *ContentPtr,
                  /* heap storage for buffering subprocess' SYS$OUTPUT */
                  *SysOutputPtr;
                  
   unsigned char  /* device name of subprocess' CGIPLUSIN mailbox */
                  CgiPlusInDevName [64],
                  /* the name of the script file being executed */
                  CgiFileName [256],
                  /* DCL command (from SSI) */
                  DclCommand [256],
                  /* DCL EOF string */
                  DclEof [64],
                  /* device name of subprocess' HTTP input mailbox */
                  HttpInputDevName [64],
                  /* script name */
                  ScriptName [SCRIPT_NAME_SIZE],
                  /* device name of subprocess' input mailbox */
                  SysCommandDevName [64],
                  /* device name of subprocess' output mailbox */
                  SysOutputDevName [64];

   struct AnIOsb  CgiPlusInIOsb,
                  HttpInputIOsb,
                  SysCommandIOsb,
                  SysOutputIOsb;

   /* string descriptors for the various mailbox device names */
   struct dsc$descriptor_s  CgiPlusInDevNameDsc;
   struct dsc$descriptor_s  HttpInputDevNameDsc;
   struct dsc$descriptor_s  SysCommandDevNameDsc;
   struct dsc$descriptor_s  SysOutputDevNameDsc;

   /* pointer a request using this DCL task structure */
   struct RequestStruct  *rqptr;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/*********************/
/* DECnet connection */
/*********************/

struct DECnetConnectStruct
{
   struct  /* allows a list of these to be constructed */
           ListEntryStruct  DclListEntry;

   boolean  /* when the current request is finished disconnect from the task */
            IsMarkedForDisconnect,
            /* task has indicated it is capable of reusing the connection */
            ReuseConnection;

   unsigned short  /* zero if no current channel, or channel number */
                  DECnetChannel;

   int  /* number of minutes still to live */
        LifeTimeCount,
        /* number of times it has been reused */
        ReUsageCount,
        /* number of times it has been used */
        UsageCount;

   char  /* node::"task=whatever" */
         ConnectString [64];

   unsigned long  /* last used binary time ;^) */
                  LastUsedBinaryTime[2];

   /* NULL if no associated request, or pointer to assosciated request */
   struct RequestStruct  *rqptr;
};

/***************************/
/* DECnet module structure */
/***************************/

struct DECnetTaskStruct
{
   boolean  /* */
            AddNewline,
            /* an  <DNETCGI> was set by the script */
            OsuDnetCgi,
            /* an  <DNETRECMODE> was set by the script */
            OsuDnetRecMode,
            /* the script generated some output */
            ScriptResponded;
    

   int  /* */
        CgiDialogState,
        /* */
        ConnectStringLength,
        /* */
        ContentCount,
        /* */
        ContentCountZero,
        /* */
        DECnetEofLength,
        /* */
        FindScriptCount,
        /* */
        FindScriptLength,
        /* */
        FindScriptTotalLength,
        /* */
        QueuedDECnetIO,
        /* */
        QueuedDcl,
        /* */
        OsuDialogState,
        /* */
        ScriptType;

   unsigned short  DECnetChannel,
                   DECnetMbxChannel;

   char  /* */
         *ContentPtr,
         /* */
         *FindScriptTypePtr,
         /* current position when sending request header */
         *OsuDnetHdrPtr,
         /* */
         *RunTimePtr,
         /* */
         *ScriptPtr;

   char  /* node::"task=whatever" */
         ConnectString [64],
         /* buffer for DCL commands */
         DclCommand [256],
         /* unsique string used to indicate end of script output */
         DECnetEof [48],
         /* VMS file script name used for searching */
         FindScript [256],
         /* VMS file script name */
         MappedScript [256],
         /* DCL required to execute the script */
         CgiScriptDcl [256],
         /* the above command being set up as a foreign verb, if necessary */
         CgiScriptForeignVerb [256];

   struct AnIOsb  DECnetConnectIOsb,
                  DECnetReadIOsb,
                  DECnetWriteIOsb,
                  DECnetMbxIOsb;

   /* pointer a request using this DCL task structure */
   struct RequestStruct  *rqptr;

   /* pointer to the DECnet connection */
   struct DECnetConnectStruct  *cnptr;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/********************************/
/* description module structure */
/********************************/

struct DescrTaskStruct
{
   boolean  /* SYSUAF authenticated user has been checked to have access */
            AuthVmsUserHasAccess,
            /* getting description from HTML, inside <TITLE></TITLE> tag */
            DescriptionInside,
            /* a <TITLE></TITLE> description has been retrieved from HTML */
            DescriptionRetrieved;

   int  /* internal description, number of lines checked from each file */
        DescriptionLineCount,
        /* internal description, number of "<" encountered */
        DescriptionClosingTagCount,
        /* internal description, number of ">" encountered */
        DescriptionOpeningTagCount,
        /* */
        FileNameLength,
        /* */
        SizeOfDescriptionBuffer,
        /* buffer for most recent task status */
        TaskStatusBuffer;

   unsigned char  /* pointer */
                  *DescriptionPtr,
                  /* pointer */
                  *DescriptionBufferPtr;

   char  /* space for generating file's description */
         Description [256],
         /* */
         FileName [256],
         /* */
         FilePath [256],
         /* */
         ReadBuffer [256];

   struct FAB  FileFab;
   struct RAB  FileRab;

   struct DescrTaskStruct  *DescrTaskPtr;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/******************************/
/* directory module structure */
/******************************/

struct DirTaskStruct
{
   struct ListEntryStruct  DirTaskList;

   boolean  /* query string directive */
            AsIfNopFound,
            /* query string directive */
            AsIfNosFound,
            /* SYSUAF authenticated user has been checked to have access */
            AuthVmsUserHasAccess,
            /* disables auto-scripting appending version */
            AutoScriptEnabled,
            /* present a directory listing ("Index of") in a VMS-style */
            FormatLikeVms,
            /* the original specification's file/type/version was not empty */
            DirSpecIncludedFilePart,
            /* query string directive */
            IncludeAnyReadme,
            /* make the file description a link */
            MakeDescriptionLink,
            /* HTTP header generated by directory lisitng, i.e. not embedded */
            ResponseHeaderSent,
            /* RMS parse is in use, free before finishing */
            ParseInUse;

   int  /* header, footer, both, none */
        Delimit,
        /* count of directories in listing */
        DirectoryCount,
        /* */
        LayoutFaoLength, 
        /* */
        LayoutHeadingLength, 
        /* */
        DirSpecLength,
        /* */
        FieldWidthCdt,
        /* */
        FieldWidthDescription,
        /* */
        FieldWidthName,
        /* */
        FieldWidthOwner,
        /* */
        FieldWidthProtection,
        /* */
        FieldWidthRdt,
        /* */
        FieldWidthSize,
        /* count of number of files in listing */
        FileCount,
        /* */
        ReadMeFileIndex,
        /* */
        SizeKilo,
        /* buffer for most recent task status */
        TaskStatusBuffer;

   unsigned long  /* for directory module, file's allocated blocks */
                  TotalAllocatedBlocks,
                  /* for directory module, file's used blocks */
                  TotalUsedBlocks;

   unsigned char  /* pointer to heap storage URL equivalent of directory */
                  *DirectoryPathPtr,
                  /* pointer to column headings string */
                  *LayoutHeadingPtr,
                  /* pointer to directory layout string */
                  *LayoutPtr,
                  /* pointer to sys$fao() directive string */
                  *LayoutFaoPtr,
                  /* pointer to message string describing subdirectory */
                  *MsgSubDirPtr,
                  /* pointer to request specified content-type */
                  *QueryContentTypePtr;
                  
   char  /* */
         Description [256],
         /* directory part of file specification */
         DirectoryPart [128],
         /* directory specification */
         DirPath [256],
         /* directory path specification */
         DirSpec [256],
         /* */
         ExpandedFileName [256],
         /* file part of file specification */
         FilePart [128],
         /* query string for directory module */
         QueryString [128],
         /* only when specified as "/dir1/dir2" this contains "./dir2/" */
         RelativePath [128],
         /* */
         ResultantFileName [256],
         /* prepended script name */
         ScriptName [SCRIPT_NAME_SIZE];

   /* */
   struct ContentTypeStruct  ContentType;

   /* RMS structures */
   struct FAB  FileFab;
   struct RAB  FileRab;
   struct NAM  FileNam;
   struct FAB  SearchFab;
   struct NAM  SearchNam;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/*************************/
/* file module structure */
/*************************/

struct FileTaskStruct
{
   boolean  /* SYSUAF authenticated user has been checked to have access */
            AuthVmsUserHasAccess,
            /* some parse structures may need freeing */
            ParseInUse,
            /* to be read record-by-record, or by block I/O (from ACP QIO) */
            RecordIO,
            /* when true a file's contents are enclosed in <PRE></PRE> tags */
            PreTagFileContents,
            /* when a file's contents have been <PRE>ed, end with </PRE> tag */
            PreTagEndFileContents,
            /* when true HTML-forbidden characters are escaped */
            EscapeHtml;

   int  /* size of buffer for escaping HTML */
        EscapeHtmlSize,
        /* */
        FileNameLength,
        /* buffer for most recent task status */
        TaskStatusBuffer;

   unsigned short /* first free byte in end-of-file VBN */
                  FirstFreeByte;

   unsigned long  /* virtual block number of end-of-file */
                  EndOfFileVbn,
                  /* (from ACP QIO) */
                  SizeInBytes;

   unsigned long  /* 64 bit VMS time when file was modified (from ACP QIO) */
                  ModifiedBinaryTime [2];

   char  /* */
         ExpandedFileName [256],
         /* */
         FileName [256];

   unsigned char  /* pointer to MIME content-type */
                  *ContentTypePtr,
                  /* pointer to buffer used to escape HTML-forbidden chars */
                  *EscapeHtmlPtr;

   /* RMS structures */
   struct FAB  FileFab;
   struct RAB  FileRab;
   struct NAM  FileNam;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/****************************/
/* HTAdmin module structure */
/****************************/

struct HTAdminTaskStruct
{
   struct HTAdminTaskStruct  *HTAdminTaskPtr;

   boolean  /* */
            BriefList,
            /* */
            ParseInUse;

   int  /* */
        FileCount,
        /* */
        FileNameLength,
        /* */
        RecordCount,
        /* */
        UserCount,
        /* */
        UserListCount,
        /* */
        UserListLength;

   char  /* */
         AuthFileName [64],
         /* */
         AuthFileSpec [64],
         /* */
         ExpandedFileName [256],
         /* */
         ResultantFileName [256];

   char  /* */
         *UserListPtr;

   struct AuthHtRecordStruct  AuthHtRecord;

   /* RMS structures */
   struct FAB  FileFab;
   struct RAB  FileRab;
   struct NAM  FileNam;
   struct XABDAT  FileXabDat;
   struct XABFHC  FileXabFhc;
   struct FAB  SearchFab;
   struct NAM  SearchNam;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/**************************/
/* IsMap module structure */
/**************************/

struct IsMapTaskStruct
{
   boolean  /* SYSUAF authenticated user has been checked to have access */
            AuthVmsUserHasAccess;

   int  /* */
        FileNameLength,
        /* character number currently being parsed (for error information) */
        IsMapCharNumber,
        /* line number in current line (for error information) */
        IsMapLineNumber,
        /* buffer for most recent task status */
        TaskStatusBuffer;

   double  /* keeps track of closest 'point x,y' (if any) */
           IsMapClosestPoint,
           /* stores the numeric equivalent of the browser x,y click point */
           IsMapClickCoord [2];

   char  /* */
         FileName [256],
         /* */
         ReadBuffer [256];

   /* RMS structures */
   struct FAB  FileFab;
   struct RAB  FileRab;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/*************************/
/* menu module structure */
/*************************/

struct MenuTaskStruct
{
   boolean  /* SYSUAF authenticated user has been checked to have access */
            AuthVmsUserHasAccess,
            /* */
            ParseInUse;

   int  /* */
        FileNameLength,
        /* used to count consecutive blank lines */
        MenuBlankLineCount,
        /* used to count consecutive non-blank lines */
        MenuLineCount,
        /* used to track current section number */
        MenuSectionNumber;

   unsigned char  /* pointer to heap storage of dynamic record buffer */
                  *MenuBufferPtr;

   char  /* */
         Description [256],
         /* sys$parse(), sys$search() storage */
         ExpandedFileName [256],
         /* */
         FileName [256],
         /* */
         ReadBuffer [256],
         /* sys$parse(), sys$search() storage */
         ResultantFileName [256];

   /* RMS structures */
   struct FAB  FileFab;
   struct RAB  FileRab;
   struct NAM  FileNam;
   struct XABDAT  FileXabDat;
   struct FAB  SearchFab;
   struct NAM  SearchNam;

   /* pointer to function, used for specifying the next task */
   void (*MenuAstFunctionPtr)(struct RequestStruct*);

   struct MenuTaskStruct  *MenuTaskPtr;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/************************/
/* put module structure */
/************************/

struct PutTaskStruct
{
   boolean  /* SYSUAF authenticated user has been checked to have access */
            AuthVmsUserHasAccess,
            /* a file has been created by this request */
            FileCreated,
            /* document posted is "text/..." */
            ContentTypeText,
            /* document posted is URL-encoded */
            ContentTypeUrlEncoded,
            /* used when un-encoding URL-encoded posts */
            UrlEncodedInsideFormName;

   int  /* length of file contents pointed to in buffer */
        ContentFileLength,
        /* */
        FileCount,
        /* */
        FileSizeBytes,
        /* length of MIME boundary used to delimit mixed subparts in buffer */
        MultipartBoundaryLength,
        /* */
        FileContentLength,
        /* */
        FileNameLength;

   unsigned long  /* when creating files and directories */
                  ProtectionMask;

   char  /* */
         ExpandedFileName [256],
         /* */
         FileName [256],
         /* */
         TemporaryFileName [256],
         /* */
         TemporaryFilePath [256];

   unsigned char  /* points to start of file contents in buffer */
                  *ContentFilePtr,
                  /* used as pointer into buffer */
                  *FileContentPtr,
                  /* used as pointer into buffer */
                  *FileContentTypePtr,
                  /* */
                  *FileNamePtr,
                  /* MIME boundary used to delimit mixed subparts in buffer */
                  *MultipartBoundaryPtr,
                  /* pointer to dynamic storage of directory files created in */
                  *MultipartDirectoryPtr,
                  /* */
                  *MultipartFileNamePtr,
                  /* */
                  *MultipartActionPtr;

   /* RMS structures */
   struct FAB  FileFab;
   struct RAB  FileRab;
   struct NAM  FileNam;
   struct XABDAT  FileXabDat;
   struct XABPRO  FileXabPro;

   struct PutTaskStruct  *PutTaskPtr;

   /* pointer to function used for specifying AST function following */
   void (*NextFunctionPtr)(struct RequestStruct*);

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);

   /* pointer to function used for specifying AST function following */
   void (*WriteFileNextFunction)(struct RequestStruct*);
};

/*************************/
/* SSI module structures */
/*************************/

/* essentially depth of if-else-endif nesting */
#define SSI_MAX_FLOW_CONTROL 8

struct SsiVarStruct
{
   struct  ListEntryStruct  SsiVarList;
   int  NameLength,
        Size,
        ValueLength;
   char  *NamePtr,
         *ValuePtr;
   char  Data[1];
};

struct SsiTaskStruct
{
   struct ListEntryStruct  SsiTaskList;

   boolean  /* SYSUAF authenticated user has been checked to have access */
            AuthVmsUserHasAccess,
            /* an SSI error message was generated */
            SsiProblemEncountered,
            /* trace on or off */
            TraceState;

   boolean  /* indexed by 'FlowControlIndex', flow has executed */
            FlowControlHasExecuted [SSI_MAX_FLOW_CONTROL],
            /* indexed by 'FlowControlIndex', flow is executing */
            FlowControlIsExecuting [SSI_MAX_FLOW_CONTROL],
            /* currently inside an "<--#ssi" statement */
            InsideSsiStatement,
            /* output occured in flow control (for carriage-control) */
            PageHasBeenOutput,
            /* suppress blank lines result of flow control directive lines */
            SuppressLine,
            /* a variable has been output (for carriage-control) */
            TraceHasBeenOutput;

   int  /* */
        FileNameLength,
        /* line number currently being parsed (for error information) */
        LineNumber,
        /* index into flow-control nesting arrays */
        FlowControlIndex,
        /* buffer for logical value */
        NetWriteBufferedEscapeHtml,
        /* line number where current directive began */
        StatementLineNumber,
        /* length of SSI statement ;^) */
        StatementLength,
        /* buffer for most recent task status */
        TaskStatusBuffer;
        
   int  /* indexed by 'FlowControlIndex', series of flow control states */
        FlowControlState [SSI_MAX_FLOW_CONTROL];

   char  /* buffer for SSI statement */
         Statement [1024],
         /* */
         FileName [256],
         /* */
         ReadBuffer [256];

   char  /* points to the list of CGI variables */
         *CgiBufferPtr,
         /* message string when generating an SSI error */
         *ErrMsgPtr,
         /* current character position when parsing lines */
         *LineParsePtr,
         /* pointer to storage allocated for size format string */
         *SizeFmtPtr,
         /* current character position in SSI statement buffer */
         *StatementPtr,
         /* pointer to storage allocated for time format string */
         *TimeFmtPtr;
                                    
   struct FAB  FileFab;
   struct NAM  FileNam;
   struct RAB  FileRab;
   struct XABDAT  FileXabDat;
   struct XABPRO  FileXabPro;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);

   /* user variable list */
   struct ListHeadStruct  SsiVarList;
};

/***************************/
/* update module structure */
/***************************/

struct UpdTaskStruct
{
   struct UpdTaskStruct  *UpdTaskPtr;

   boolean  /* SYSUAF authenticated user has been checked to have access */
            AuthVmsUserHasAccess,
            /* */
            BrowserFormHasOwnLineBreak,
            /* */
            BrowserSupportsFileUpload,
            /* */
            ConfigurationEdit,
            /* */
            FileExists,
            /* */
            ParseInUse,
            /* */
            RuleCheckAvailable,
            /* */
            UpdateTree;

   int  /* */
        Cols,
        /* */
        FileCount,
        /* */
        FileNameLength,
        /* */
        FilePathSize,
        /* */
        NavigateSize,
        /* */
        Rows,
        /* */
        TreeLevel;

   unsigned long  /* when creating files and directories */
                  ProtectionMask;

   char  /* */
         AsPath [256],
         /* */
         CxR [16],
         /* */
         ExpandedFileName [256],
         /* */
         FileName [256],
         /* tree processing, contains any name, type, version */
         FileNamePart [128],
         /* */
         FilePath [256],
         /* */
         HtmlEscapedTitle [256],
         /* used to store language-specific strings while in use */
         MsgString [256],
         /* MUST be 512 bytes (one block) for file copy purposes */
         ReadBuffer [512],
         /* */
         ResultantFileName [256];

   char  /* pointer to MIME content-type */
         *ContentTypePtr,
         /* current position during use of language-specific string */
         *MsgStringPtr;

   /* RMS structures */
   struct FAB  FileFab;
   struct RAB  FileRab;
   struct NAM  FileNam;
   struct XABDAT  FileXabDat;
   struct XABFHC  FileXabFhc;
   struct FAB  SearchFab;
   struct NAM  SearchNam;

   struct UpdTreeStruct  *TreeHeadPtr,
                         *TreeNodePtr;

   /* pointer to function, used for specifying the next task */
   void (*NextTaskFunction)(struct RequestStruct*);
};

/********************************/
/* update module tree structure */
/********************************/

struct UpdTreeStruct
{
   struct UpdTreeStruct  *PrevTreeNodePtr,
                         *NextTreeNodePtr;

   boolean  /* SYSUAF authenticated user has been checked to have access */
            AuthVmsUserHasAccess;

   int  /* */
        FileNameLength;

   char  /* */
         ExpandedFileName [256],
         /* */
         FileName [256],
         /* */
         ResultantFileName [256];

   /* RMS structures */
   struct FAB  SearchFab;
   struct NAM  SearchNam;
};

/*****************************/
/* per-thread data structure */
/*****************************/

struct RequestStruct
{
   /***************************/
   /* general purpose storage */
   /***************************/

   /*
      Storage areas at the beginning of this structure, specifically
      above the field 'RetainAboveZeroBelow', are retained between
      successive requests during persistent connections.
      When a "keep-alive" connection is reinitialized ready for a
      potential new request all of this structure below (and including)
      that field are zeroed, effectively allowing a new request.
   */

   /* for maintaining the list of request structures */
   struct  ListEntryStruct  RequestListEntry;

   /* pointer to service structure of host/port etc of service connected to */
   struct ServiceStruct  *ServicePtr;

   int  /* counter for input timeout */
        TimerInputCount,
        /* counter for keep-alive timeout */
        TimerKeepAliveCount,
        /* counter for output timeout */
        TimerOutputCount;

   unsigned long  /* zone ID for request heap's virtual memory management */
                  VmHeapZoneId;

#ifdef IP_UCX
   unsigned short  /* channel to client's TCP/IP device */
                   ClientChannel;
#endif

#ifdef IP_NETLIB
   unsigned long  /* socket for client's TCP/IP device */
                  ClientNetLibSocket;
#endif

   boolean  /* when the socket has been explicitly shutdown (before close) */
            ClientSocketShutdown,
            /* timers expired and the client socket has been shut/closed */
            TimerTerminated;

   struct AnIOsb  /* used, of course, for socket shutdown status */
                  NetShutdownIOsb;

   unsigned long  /* client's binary IP address */
                  ClientInternetAddress32bit;

   unsigned char  /* internet host/domain name of client */
                  ClientHostName [128],
                  /* numeric host/domain address of client */
                  ClientInternetAddress [32];

   int  /* count of how many times the TCP/IP connection is reused */
        KeepAliveCount;

   /* make it easy on ourselves, make the SSL structure pointer typeless! */
   void  *SeSoLaPtr;
   /* "http:" or "https:" (SSL) */
   int  RequestScheme;
   /* pointer to either "http:" or "https:" */
   char  *RequestSchemeNamePtr;

   /* the rest of this structure can be zeroed with persistent connections */
   unsigned long  RetainAboveZeroBelow;

   boolean  /* authentication will be done by script */
            AuthExternal,
            /* cache is currently being loaded for this path/file */
            CacheLoading,
            /* */
            CgiAddNewline,
            /* */
            CgiBufferRecords,
            /* */
            CgiCheckedHeader,
            /* */
            CgiContentTypeText,
            /* */
            CgiScript,
            /* */
            CgiPlusScript,
            /* "temporary" file, delete it on close */
            DeleteOnClose,
            /* true if a mapping rule identifies this as a "CGIplus" script */
            IsCgiPlusScript,
            /* this request has a "Connection: Keep-Alive" token */
            KeepAliveRequest,
            /* the server has responded with "keep-alive" */
            KeepAliveResponse,
            /* this persistent connection has timed out */
            KeepAliveTimeout,
            /* escapes HTML-forbidden characters as sent to client */
            NetWriteBufferedEscapeHtml,
            /* response header has been sent to client */
            ResponseHeaderSent,
            /* response include an "Expires:" the same as "Last-Modified:" */
            ResponsePreExpired,
            /* "Pragma: no-cache" HTTP request header line encountered */
            PragmaNoCache,
            /* an "Xray" returns full response as plain-text (diagnostic) */
            Xray;


   int  /* counter representing request activity has be incremented */
        AccountingDone,
        /* could not have come from cache, could have but didn't, did! */
        CacheInvolvement,
        /* multi-purpose, when loading and reading cache */
        CacheContentCount,
        /* length of mapped path */
        CacheMappedPathLength,
        /* length of heap memory pointed to by CgiBufferPtr */
        CgiBufferLength,
        /* remaining space in heap memory pointed to by CgiBufferPtr */
        CgiBufferRemaining,
        /* length of script end-of-file string */
        CgiEofLength,
        /* how many attempts have been made to restart a CGI script */
        CgiScriptRetryCount,
        /* count of bytes received so far in a POSTed or PUTed body */
        ContentCount,
        /* "Content-Length:" value */
        ContentLength,
        /* "Content-Type:" length */
        ContentTypeLength,
        /* size of buffer space for sys$output from DCL subprocess */
        *DclSysOutputSize,
        /* processing request header, count to find first blank line */
        HeaderConsecutiveNewLineCount,
        /* "Accept:" length */
        HttpAcceptLength,
        /* "Accept-Charset:" length */
        HttpAcceptCharsetLength,
        /* "Accept-Language:" length */
        HttpAcceptLangLength,
        /* "Forwarded:" line(s) length */
        HttpForwardedLength,
        /* length of error message */
        ErrorMessageLength,
        /* value representation of request HTTP method */
        HttpMethod,
        /* length of request header field */
        HttpAuthorizationLength,
        /* length of request header field */
        HttpRefererLength,
        /* length of request header field */
        HttpUserAgentLength,
        /* interge representing prefered message language */
        MsgLanguage,
        /* size of network read buffer */
        NetReadBufferSize,
        /* length of path from HTTP header */
        PathInfoLength,
        /* length of query string from HTTP header */
        QueryStringLength,
        /* lenth of resource (path plus query string) from HTTp header */
        ResourceLength,
        /* number of characters up until the blank line */
        RequestHeaderLength,
        /* count of home page file names tried */
        RequestHomePageIndex,
        /* used during HEAD method to determine when header ends */
        ResponseHeaderNewlineCount,
        /* buffer for data length */
        ResponseHeaderDataLength,
        /* length of reponse header */
        ResponseHeaderLength,
        /* numeric equivalent of the "200", "302", etc., HTTP status code */
        ResponseStatusCode,
        /* avoid redirection loops by keeping track of the number */
        RedirectionCount,
        /* VMS status of most recent task */
        TaskStatus;

   unsigned long  /* count of total bytes received from the client */
                  BytesRx,
                  /* count of total bytes sent to the client */
                  BytesTx,
                  /* buffer for hash value used when caching */
                  CacheHashValue,
                  /* response duration */
                  ResponseDuration;

   unsigned long  /* 64 bit VMS internal time, start of request processing */
                  BinaryTime [2],
                  /* 64 bit VMS time from "If-Modified-Since:" header */
                  IfModifiedSinceBinaryTime [2],
                  /* length paramater from "If-Modified-Since:" header */
                  IfModifiedSinceLength;

   unsigned short  /* component equivalent of 'BinaryTime' */
                   NumericTime [7];

   unsigned char  /* pointer to mapped path */
                  *CacheMappedPathPtr,
                  /* multi-purpose, when loading and reading cache */
                  *CacheContentPtr,
                  /* points into cache buffer when loading via record IO */
                  *CacheContentCurrentPtr,
                  /* heap memory in which the CGI variables are generated */
                  *CgiBufferPtr,
                  /* current position in CGI variable buffer */
                  *CgiBufferCurrentPtr,
                  /* script end-of-file string */
                  *CgiEofPtr,
                  /* points to dynamic buffer for body POSTed, PUT, etc. */
                  *ContentBufferPtr,
                  /* used as pointer into above buffer */
                  *ContentPtr,
                  /* buffer space for sys$output from DCL subprocess */
                  *DclSysOutputPtr,
                  /* pointer to error buffer sent to client */
                  *ErrorBufferPtr,
                  /* pointer to error message */
                  *ErrorMessagePtr,
                  /* pointer to explanation when generating error report */
                  *ErrorTextPtr,
                  /* pointer to hidden explanation (often file name) */
                  *ErrorHiddenTextPtr,
                  /* "Accept:" header lines */
                  *HttpAcceptPtr,
                  /* "Accept-Charset:" header lines */
                  *HttpAcceptCharsetPtr,
                  /* "Accept-Language:" header lines */
                  *HttpAcceptLangPtr,
                  /* pointer to heap storage of "Authorization:" field */
                  *HttpAuthorizationPtr,
                  /* stream's MIME content type */
                  *HttpContentTypePtr,
                  /* "Cookie:" request header encountered */
                  *HttpCookiePtr,
                  /* "Forwarded:" header line */
                  *HttpForwardedPtr,
                  /* "Host:" header line */
                  *HttpHostPtr,
                  /* pointer to heap storage of "If-Modified-Since:" field */
                  *HttpIfModifiedSincePtr,
                  /* "Pragma:" request header encountered */
                  *HttpPragmaPtr,
                  /* pointer to heap storage of "Referer:" field */
                  *HttpRefererPtr,
                  /* pointer to heap storage of "User-Agent:" field */
                  *HttpUserAgentPtr,
                  /* pointer to heap storage of redirection location path */
                  *LocationPtr,
                  /* pointer to heap storage client-read network buffering */
                  *NetReadBufferPtr,
                  /* pointer to heap storage of request path */
                  *PathInfoPtr,
                  /* pointer to heap storage of request query string */
                  *QueryStringPtr,
                  /* pointer to requested resource (path and query string) */
                  *ResourcePtr,
                  /* pointer to request header */
                  *RequestHeaderPtr,
                  /* pointer to response header */
                  *ResponseHeaderPtr,
                  /* buffer for data pointer */
                  *ResponseHeaderDataPtr;

   unsigned char  /* GMT-adjusted string equivalent of 'BinaryTime' */
                  GmDateTime [48],
                  /* string reqpresenting the request's HTTP method */
                  HttpMethodName [METHOD_NAME_SIZE],
                  /* authenticated user name from "Authorization:" */
                  RemoteUser [MaxAuthUserNameLength+1],
                  /* storage when authenticating remote user */
                  RemoteUserPassword [MaxAuthPasswordLength+1],
                  /* parsed path storage */
                  RequestFileName [256],
                  /* mapped script name */
                  ScriptName [SCRIPT_NAME_SIZE];

   /* request is being used to fill a cache entry */
   struct CacheStruct  *CachePtr;

   /* AST function */
   void (*ResponseHeaderAstAddress)(struct RequestStruct*);
   void (*ErrorMessageAstAddress)(struct RequestStruct*);

   /* storage for maintaining the thread's heap storage */
   struct HeapStruct  *HeapHeadPtr;
   struct HeapStruct  *HeapTailPtr;
   int  HeapSize;

   /* */
   struct ContentTypeStruct  ContentType;

   /* I/O status blocks */
   struct AnIOsb  NetReadIOsb,
                  NetWriteIOsb;

   /* RMS structures used for various file processing purposes */
   struct FAB  RequestParseFab;
   struct NAM  RequestParseNam;

   /**************/
   /* task lists */
   /**************/

   /* these two modules can have multiple, concurrent instances */
   struct  ListHeadStruct  DirTaskList,
                           SsiTaskList;

   /* these modules can only have one total or multiple serially */
   struct  DclTaskStruct      *DclTaskPtr;
   struct  DECnetTaskStruct   *DECnetTaskPtr;
   struct  DescrTaskStruct    *DescrTaskPtr;
   struct  DirTaskStruct      *DirTaskPtr;
   struct  FileTaskStruct     *FileTaskPtr;
   struct  GraphTaskStruct    *GraphTaskPtr;
   struct  HTAdminTaskStruct  *HTAdminTaskPtr;
   struct  IsMapTaskStruct    *IsMapTaskPtr;
   struct  MenuTaskStruct     *MenuTaskPtr;
   struct  PutTaskStruct      *PutTaskPtr;
   struct  SsiTaskStruct      *SsiTaskPtr;
   struct  UpdTaskStruct      *UpdTaskPtr;

   /****************************************/
   /* storage specific to output buffering */
   /****************************************/

   /* the head of the output buffer list */
   struct ListHeadStruct  OutputBufferList;

   /* pointer to heap storage structure for output buffering */
   struct ListEntryStruct  *OutputBufferStructPtr,
                           *OutputBufferNowStructPtr;

   /* pointer to any AST function */
   void  *OutputBufferAstFunctionPtr;

   boolean  /* all output buffers must be written to network */
            OutputBufferFlush;

   int  /* count of all data in all output buffers */
        OutputBufferCount,
        /* bytes still available in the current output buffer */
        OutputBufferRemaining;

   unsigned char  /* pointer to the start of the current buffer */
                  *OutputBufferPtr,
                  /* pointer used to point into 'OutputBuffer' storage */
                  *OutputBufferCurrentPtr;

   /****************************************************/
   /* storage specific to authentication/authorization */
   /****************************************************/

   boolean  /* user may change SYSUAF password */
            AuthCanChangeSysUafPwd,
            /* authenticated user may only access via https: (SSL) */
            AuthHttpsOnly,
            /* the user was authenticated from the SYSUAF */
            AuthSysUafAuthenticated;

   unsigned short  /* length of the user profile pointed to */
                   AuthVmsUserProfileLength;

   unsigned long  /* value representation of scheme being used for challenge */
                  AuthChallengeScheme,
                  /* the capability flags of the authorization path */
                  AuthGroupCan,
                  /* the capability flags of the request (ACT ON THESE!) */
                  AuthRequestCan,
                  /* value representation of scheme being used for request */
                  AuthScheme,
                  /* the capability flags of the remote user */
                  AuthUserCan,
                  /* what everybody else can do on that path */
                  AuthWorldCan;

   unsigned char  /* BASIC challenge response header field */
                  *AuthBasicChallengePtr,
                  /* DIGEST challenge response header field */
                  *AuthDigestChallengePtr,
                  /* when digest authenticating, the client-supplied nonce */
                  *AuthDigestNoncePtr,
                  /* when digest authenticating, the client-supplied digest */
                  *AuthDigestResponsePtr,
                  /* when digest authenticating, the client-supplied URI */
                  *AuthDigestUriPtr,
                  /* pointer to authorization group name */
                  *AuthGroupPtr,
                  /* pointer to authorization realm name */
                  *AuthRealmPtr,
                  /* pointer to string of IP-address/username masks */
                  *AuthRestrictListPtr,
                  /* user profile is used by sys$check_access() */
                  *AuthVmsUserProfilePtr,
                  /* pointer to string of IP-address/username masks */
                  *AuthWorldRestrictListPtr;

   char  /* basic, digest, etc. */
         AuthType [16];


   /***************/
   /* zeroed end! */
   /***************/

   unsigned long  ZeroedEnd;
};

#ifdef __ALPHA
#   pragma member_alignment __restore
#endif

/*****************************************************************************/
