/*****************************************************************************/
/*
                                  hWP.c

CGI-compliant script to (attempt to) display WordPerfect source files as 
hypertext documents.  WordPerfect internal format does not appear to be 
document anywhere, so this rather imperfect program was created by dumping 
WordPerfect document and attempting to deduce the internal structure.  Hence 
it works (just) for simple documents but may be grossly inadequite for 
anything else!

Page colouration may be specified via the appropriate command-line qualifiers
(or corresponding logical name). Defaults for any not specified.  Specifiy as
/WHATEVER="" to NOT specify the corresponding colour (i.e. leave it to the
browser). See "Qualifiers" section below, and also about the logical name
"HWP$PARAM".

Here is an example of changing the button labels (possibly to non-English):

  /BUTTON="Help;Get Source Document;Reveal Codes;Dump Codes"

An example of changing the page colour to white and the banner to red!

  /PBGCOLOR="#ffffff" /PHBGCOLOR="#ff0000"


CGI VARIABLE NAMES
------------------
WWW_PATH_INFO           the URL path component
WWW_HTTP_REFERER        the document containing the anchor to this script
WWW_SCRIPT_NAME         the name of the script being executed
WWW_SERVER_NAME         the server TCP/IP host name
WWW_SERVER_PORT         the server TCP/IP port number

WWW_FORM_DO             specifies the function
WWW_FORM_HWP            non-empty, indicates it came from DocumentNotSpecified()
WWW_FORM_REVEAL         reveal WP formatting "C"odes, or "D"dump codes
WWW_FORM_TOPICINDEX     if "NO" or "FALSE" then do not generate a topic index


LOGICAL NAMES
-------------
HWP$DBUG                turns on all "if (Debug)" statements
HWP$PARAM               equivalent to (overrides) the command line
                        parameters/qualifiers (define as a system-wide logical)


QUALIFIERS
----------
/BUTTONS=       string containing button names
/HELP=          URL of help HTML file (optional)
/PBACKGROUND=   <body> background image path
/PBGCOLOR=      <body> background colour
/PBBGCOLOR=     button background color
/PBBORDER=      width of button border
/PHBGCOLOR=     heading background color
/PHBORDER=      width of heading and button-bar border
/PHLOCAL=       local information to be included in header
/PHTEXT=        heading text colour
/PLAYOUT=       *** not fully implemented by this script ***
/PLINK=         <body> link colour
/PTEXT=         <body> text colour
/PVLINK=        <body> visited link colour


BUILD
-----
See BUILD_HWP.COM


VERSION HISTORY
---------------
This may never get to version 1.n.n unless some technical information on the
structure of WordPerfect files comes to light!

24-JUL-98  MGD  v0.1.3, suppress table background colours if empty
20-MAY-98  MGD  v0.1.2, quickly cleaned up (and removed) some functionality,
                        cosmetic changes
24-JUL-96  MGD  v0.1.1, modified table generating code slightly
26-SEP-95  MGD  v0.1.0, initial development
*/
/*****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [] = "HWP AXP-0.1.3";
#else
   char SoftwareID [] = "HWP VAX-0.1.3";
#endif

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <unixio.h>
#include <file.h>

#include <descrip.h>
#include <rms.h>
#include <ssdef.h>
#include <stsdef.h>

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))

#define boolean int
#define true 1
#define false 0

/* macro provides NULL pointer if CGI variable does not exist */
#define GetCgiVarIfExists(CharPointer,CgiVariableName) \
   CharPointer = getenv(CgiVariableName)

/* macro provides pointer to empty string even if CGI variable does not exist */
#define GetCgiVar(CharPointer,CgiVariableName) \
   if ((CharPointer = getenv(CgiVariableName)) == NULL) \
       CharPointer = ""; \
   if (Debug) fprintf (stdout, "%s |%s|\n", CgiVariableName, CharPointer);

#define DEFAULT_HELP_PATH "/hwp/-/hwphelp.html"

#define DEFAULT_BUTTONS "Help;Get Source Document;Reveal Codes;Dump Codes"

/* this macro just plugs in some script-specific code into ButtonBar() */
#define SCRIPT_SPECIFIC_BUTTON_CODE \
   ButtonInternal[0] = HelpPathPtr; \
   { \
      static char  String [256]; \
      sprintf (ButtonInternal[1] = String, "%s;0", CgiPathInfoPtr); \
   } \
   if (ProvideRevealCodes) \
   { \
      static char  String1 [256], \
                   String2 [256]; \
      sprintf (ButtonInternal[2] = String1, "%s%s?reveal=codes", \
               CgiScriptNamePtr, CgiPathInfoPtr); \
      sprintf (ButtonInternal[3] = String2, "%s%s?reveal=dump", \
               CgiScriptNamePtr, CgiPathInfoPtr); \
   } \
   else \
      ButtonInternal[2] = ButtonInternal[3] = "";

#define DEFAULT_PS_BGCOLOR        "#ffffff"
#define DEFAULT_PS_TEXT           "#000000"
#define DEFAULT_PS_LINK           "#0000ff"
#define DEFAULT_PS_VLINK          "#0000ff"
#define DEFAULT_PS_HEADBGCOLOR    "#cccccc"
#define DEFAULT_PS_HEADBORDER     "0"
#define DEFAULT_PS_HEADTEXT       "#000000"
#define DEFAULT_PS_BUTTONBGCOLOR  "#ffffff"
#define DEFAULT_PS_BUTTONBORDER   "1"

#define PS_BACKGROUND     0
#define PS_BGCOLOR        1
#define PS_TEXT           2
#define PS_LINK           3
#define PS_VLINK          4
#define PS_HEADBGCOLOR    5
#define PS_HEADTEXT       6
#define PS_HEADBORDER     7
#define PS_BUTTONBGCOLOR  8
#define PS_BUTTONBORDER   9
#define PS_BODYTAG       10
#define PS_LAYOUT        11
#define PS_HEADLOCAL     12
#define PS_HEADPADDING   13

char  *PageScheme [16];

#define WP_READ_CHUNK 16384

char  Utility [] = "HWP";

char  Http200Header [] =
"HTTP/1.0 200 Document follows.\r\n\
Content-Type: text/html\r\n\
\r\n";

char  Http404Header [] =
"HTTP/1.0 404 Error report follows.\r\n\
Content-Type: text/html\r\n\
\r\n";

char ErrorMemoryAllocation [] = "Memory allocation failed!";

boolean  AnchorText,
         BuildTopicIndex,
         Debug,
         HttpHasBeenOutput,
         DocumentText,
         ProvideRevealCodes = false,
         RevealCodes,
         RevealDump,
         RomanPageNumbers,
         WildCardDocument;

int  AnchorTextCount,
     BoldCount,
     CentreCount,
     DocumentByteCount,
     DocumentCount,
     ItalicCount,
     MarkNumber,
     PageNumber,
     PreviousPageNumber,
     TableCount,
     SectionNumber,
     UnderlineCount,
     WpFileFd;

char  *ButtonPtr = DEFAULT_BUTTONS,
      *CgiFormDoPtr,
      *CgiFormRefererPtr,
      *CgiFormRevealPtr,
      *CgiFormTopicIndexPtr,
      *CgiHttpRefererPtr,
      *CgiPathInfoPtr,
      *CgiPathTranslatedPtr,
      *CgiScriptNamePtr,
      *CgiServerNamePtr,
      *CgiServerPortPtr,
      *DocCharPtr,
      *HelpPathPtr = DEFAULT_HELP_PATH,
      *PageTitlePtr;

unsigned char  *DocumentPtr;
      
char *CurrentPageNumber ();

/*****************************************************************************/
/*
*/

main ()

{
   register char  *cptr, *sptr;

   /*********/
   /* begin */
   /*********/

   if (getenv ("HWP$DBUG") != NULL) Debug = true;

   GetParameters ();

   if (Debug)
      system ("show sym *");
   else
   {
      /* reopen output stream so that the '\r' and '\n' are not filtered */
#ifdef __DECC
      if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "ctx=bin")) == NULL)
         exit (vaxc$errno);
#else
      if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "rfm=udf")) == NULL)
         exit (vaxc$errno);
#endif
   }

   SetPageScheme ();

   /*********************/
   /* get CGI variables */
   /*********************/

   GetCgiVar (CgiScriptNamePtr, "WWW_SCRIPT_NAME");
   if (CgiScriptNamePtr == NULL) CgiScriptNamePtr = "";

   GetCgiVar (CgiPathInfoPtr, "WWW_PATH_INFO");
   GetCgiVar (CgiPathTranslatedPtr, "WWW_PATH_TRANSLATED");

   GetCgiVar (CgiFormRevealPtr, "WWW_FORM_REVEAL");
   if (toupper(CgiFormRevealPtr[0]) == 'C')
      RevealCodes = true;
   else
   if (toupper(CgiFormRevealPtr[0]) == 'D')
      RevealCodes = RevealDump = true;
   else
      RevealCodes = RevealDump = false;

   GetCgiVar (CgiFormTopicIndexPtr, "WWW_FORM_TOPICINDEX");

   GetCgiVar (PageTitlePtr, "WWW_FORM_TITLE");

   GetCgiVar (CgiFormDoPtr, "WWW_FORM_DO");

   /***********************/
   /* execute the request */
   /***********************/

   ProcessDocumentFile ();

   exit (SS$_NORMAL);
}

/*****************************************************************************/
/*
Get "command-line" parameters, whether from the command-line or from a
configuration logical containing the equivalent.
*/

GetParameters ()

{
   static char  CommandLine [256];
   static unsigned long  Flags = 0;

   register char  *aptr, *cptr, *clptr, *sptr;

   int  status;
   unsigned short  Length;
   char  ch;
   $DESCRIPTOR (CommandLineDsc, CommandLine);

   /*********/
   /* begin */
   /*********/

   if ((clptr = getenv ("HWP$PARAM")) == NULL)
   {
      /* get the entire command line following the verb */
      if (VMSnok (status =
          lib$get_foreign (&CommandLineDsc, 0, &Length, &Flags)))
         exit (status);
      (clptr = CommandLine)[Length] = '\0';
   }

   aptr = NULL;
   ch = *clptr;
   for (;;)
   {
      if (aptr != NULL) *aptr = '\0';
      if (!ch) break;

      *clptr = ch;
      if (Debug) fprintf (stdout, "clptr |%s|\n", clptr);
      while (*clptr && isspace(*clptr)) *clptr++ = '\0';
      aptr = clptr;
      if (*clptr == '/') clptr++;
      while (*clptr && !isspace (*clptr) && *clptr != '/')
      {
         if (*clptr != '\"')
         {
            clptr++;
            continue;
         }
         cptr = clptr;
         clptr++;
         while (*clptr)
         {
            if (*clptr == '\"')
               if (*(clptr+1) == '\"')
                  clptr++;
               else
                  break;
            *cptr++ = *clptr++;
         }
         *cptr = '\0';
         if (*clptr) clptr++;
      }
      ch = *clptr;
      if (*clptr) *clptr = '\0';
      if (Debug) fprintf (stdout, "aptr |%s|\n", aptr);
      if (!*aptr) continue;

      if (strsame (aptr, "/DBUG", -1))
      {
         Debug = true;
         continue;
      }
      if (strsame (aptr, "/BUTTONS=", 4))
      {
         for (cptr = aptr; *cptr && *cptr != '='; cptr++);
         if (*cptr) cptr++;
         ButtonPtr = cptr;
         continue;
      }
      if (strsame (aptr, "/HELP=", 4))
      {
         for (cptr = aptr; *cptr && *cptr != '='; cptr++);
         if (*cptr) cptr++;
         HelpPathPtr = cptr;
         continue;
      }
      if (GetPageParameter (aptr)) continue;

      if (*aptr != '/')
      {
         fprintf (stdout, "%%%s-E-MAXPARM, too many parameters\n \\%s\\\n",
                  Utility, aptr);
         exit (STS$K_ERROR | STS$M_INHIB_MSG);
      }
      else
      {
         fprintf (stdout, "%%%s-E-IVQUAL, unrecognized qualifier\n \\%s\\\n",
                  Utility, aptr+1);
         exit (STS$K_ERROR | STS$M_INHIB_MSG);
      }
   }
}

/*****************************************************************************/
/*
Get command-line parameters associated with page scheme.
*/

boolean GetPageParameter (char *aptr)

{
   register char  *cptr;

   /*********/
   /* begin */
   /*********/

   if (strsame (aptr, "/PBACKGROUND=", 4))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_BACKGROUND] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PBGCOLOR=", 4))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_BGCOLOR] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PBBGCOLOR=", 5))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_BUTTONBGCOLOR] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PBBORDER=", 5))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_BUTTONBORDER] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PHBGCOLOR=", 5))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_HEADBGCOLOR] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PHBORDER=", 5))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_HEADBORDER] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PHTEXT=", 4))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_HEADTEXT] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PLAYOUT=", 4))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_LAYOUT] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PLINK=", 4))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_LINK] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PHLOCAL=", 4))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_HEADLOCAL] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PTEXT=", 4))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_TEXT] = cptr;
      return (true);
   }
   if (strsame (aptr, "/PVLINK=", 4))
   {
      for (cptr = aptr; *cptr && *cptr != '='; cptr++);
      if (*cptr) cptr++;
      PageScheme[PS_VLINK] = cptr;
      return (true);
   }
   return (false);
}

/*****************************************************************************/
/*
Set the page layout and colouration.
*/

SetPageScheme ()

{
   int  size;
   char  *sptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SetPageScheme()\n");

   if (PageScheme[PS_LAYOUT] == NULL)
      PageScheme[PS_LAYOUT] = "1";

   if (PageScheme[PS_BACKGROUND] == NULL)
      PageScheme[PS_BACKGROUND] = "";

   if (PageScheme[PS_HEADLOCAL] == NULL)
      PageScheme[PS_HEADLOCAL] = "";

   if (PageScheme[PS_LAYOUT][0] == '2')
   {
      if (PageScheme[PS_BGCOLOR] == NULL) PageScheme[PS_BGCOLOR] = "";
      if (PageScheme[PS_TEXT] == NULL) PageScheme[PS_TEXT] = "";
      if (PageScheme[PS_LINK] == NULL) PageScheme[PS_LINK] = "";
      if (PageScheme[PS_VLINK] == NULL) PageScheme[PS_VLINK] = "";
      if (PageScheme[PS_HEADBGCOLOR] == NULL) PageScheme[PS_HEADBGCOLOR] = "";
      if (PageScheme[PS_HEADBORDER] == NULL) PageScheme[PS_HEADBORDER] = "";
      if (PageScheme[PS_HEADTEXT] == NULL) PageScheme[PS_HEADTEXT] = "";
      if (PageScheme[PS_BUTTONBGCOLOR] == NULL) PageScheme[PS_BUTTONBGCOLOR] = "";
      if (PageScheme[PS_BUTTONBORDER] == NULL) PageScheme[PS_BUTTONBORDER] = "";
   }
   else
   {
      if (PageScheme[PS_BGCOLOR] == NULL)
         PageScheme[PS_BGCOLOR] = DEFAULT_PS_BGCOLOR;
      if (PageScheme[PS_TEXT] == NULL)
         PageScheme[PS_TEXT] = DEFAULT_PS_TEXT;
      if (PageScheme[PS_LINK] == NULL)
         PageScheme[PS_LINK] = DEFAULT_PS_LINK;
      if (PageScheme[PS_VLINK] == NULL)
         PageScheme[PS_VLINK] = DEFAULT_PS_VLINK;
      if (PageScheme[PS_HEADBGCOLOR] == NULL)
         PageScheme[PS_HEADBGCOLOR] = DEFAULT_PS_HEADBGCOLOR;
      if (PageScheme[PS_HEADBORDER] == NULL)
         PageScheme[PS_HEADBORDER] = DEFAULT_PS_HEADBORDER;
      if (PageScheme[PS_HEADTEXT] == NULL)
         PageScheme[PS_HEADTEXT] = DEFAULT_PS_HEADTEXT;
      if (PageScheme[PS_BUTTONBGCOLOR] == NULL)
         PageScheme[PS_BUTTONBGCOLOR] = DEFAULT_PS_BUTTONBGCOLOR;
      if (PageScheme[PS_BUTTONBORDER] == NULL)
         PageScheme[PS_BUTTONBORDER] = DEFAULT_PS_BUTTONBORDER;
   }

   /* <BODY> tag attributes */
   size = strlen(PageScheme[PS_BACKGROUND]) +
          strlen(PageScheme[PS_BGCOLOR]) +
          strlen(PageScheme[PS_TEXT]) +
          strlen(PageScheme[PS_LINK]) +
          strlen(PageScheme[PS_VLINK]);
   if (size)
   {
      if ((sptr = calloc (1, size+64)) == NULL) exit (vaxc$errno);
      PageScheme[PS_BODYTAG] = sptr;
      if (PageScheme[PS_BACKGROUND][0])
         sptr += sprintf (sptr, " BACKGROUND=\"%s\"", PageScheme[PS_BACKGROUND]);
      if (PageScheme[PS_BGCOLOR][0])
         sptr += sprintf (sptr, " BGCOLOR=\"%s\"", PageScheme[PS_BGCOLOR]);
      if (PageScheme[PS_TEXT][0])
         sptr += sprintf (sptr, " TEXT=\"%s\"", PageScheme[PS_TEXT]);
      if (PageScheme[PS_LINK][0])
         sptr += sprintf (sptr, " LINK=\"%s\"", PageScheme[PS_LINK]);
      if (PageScheme[PS_VLINK][0])
         sptr += sprintf (sptr, " VLINK=\"%s\"", PageScheme[PS_VLINK]);
   }
   else
      PageScheme[PS_BODYTAG] = "";

   if (PageScheme[PS_HEADBGCOLOR][0])
   {
      if ((sptr = calloc (1, strlen(PageScheme[PS_HEADBGCOLOR])+16)) == NULL)
         exit (vaxc$errno);
      sprintf (sptr, " BGCOLOR=\"%s\"", PageScheme[PS_HEADBGCOLOR]);
      PageScheme[PS_HEADBGCOLOR] = sptr;
      PageScheme[PS_HEADPADDING] = "10";
   }
   else
      PageScheme[PS_HEADPADDING] = "0";

   if (PageScheme[PS_BUTTONBGCOLOR][0])
   {
      if ((sptr = calloc (1, strlen(PageScheme[PS_BUTTONBGCOLOR])+16)) == NULL)
         exit (vaxc$errno);
      sprintf (sptr, " BGCOLOR=\"%s\"", PageScheme[PS_BUTTONBGCOLOR]);
      PageScheme[PS_BUTTONBGCOLOR] = sptr;
   }
}

/*****************************************************************************/
/*
Provides a divider for top and bottom of the content of the page. This can be
a coloured bar (using <TABLE>) or a horizontal rule depending on the page
layout. "Buttons" providing script-internal and/or additional user-specified
links ('ButtonPtr' string) can be placed with(in) this bar. All button labels
are derived from 'ButtonPtr', with script-internal buttons using link-paths
set up via 'ButtonInternal[]' array, or any user-specified path depending on
requirement. An empty path (i.e. PathPtr[0] == '\0') obviously does not have a
link created, it just displays the button label. For a button-bar at the top
of the document use 1, bottom of the document use 2, and for just a bar with
no buttons at all use 0.
*/

ButtonBar (int Top1Bottom2)

{
#define MAX_BUTTON_COUNT 8

   static int  ButtonCount = -1;
   static char  *ButtonInternal [MAX_BUTTON_COUNT],
                *ButtonLabel [MAX_BUTTON_COUNT],
                *ButtonPath [MAX_BUTTON_COUNT];

   int  idx;
   char  *PathPtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ButtonBar() %d\n", Top1Bottom2);

   if (ButtonCount == -1)
   {
      register char  *cptr, *sptr;

      if (Debug) fprintf (stdout, "|%s|\n", ButtonPtr);
      cptr = ButtonPtr;
      for (ButtonCount = 0;
           ButtonCount < MAX_BUTTON_COUNT && *cptr;
           ButtonCount++)
      {
         for (sptr = cptr; *sptr && *sptr != '=' && *sptr != ';'; sptr++)
            if (*sptr == '\\') memcpy (sptr, sptr+1, strlen(sptr));
         if (*sptr == '=') *sptr++ = '\0';
         ButtonLabel[ButtonCount] = cptr;
         cptr = sptr;
         for (sptr = cptr; *sptr && *sptr != ';'; sptr++)
            if (*sptr == '\\') memcpy (sptr, sptr+1, strlen(sptr));
         if (*sptr) *sptr++ = '\0';
         ButtonPath[ButtonCount] = cptr;
         cptr = sptr;
      }
   }

   if (Top1Bottom2)
   {
      /***********************************/
      /* set up script-specified buttons */
      /***********************************/

      SCRIPT_SPECIFIC_BUTTON_CODE
   }

   if (PageScheme[PS_LAYOUT][0] == '2')
   {
      /************/
      /* format 2 */
      /************/

      if (Top1Bottom2 == 2 || !Top1Bottom2)
      {
         fprintf (stdout, "<HR ALIGN=left SIZE=2 WIDTH=90%%>\n");
         if (!Top1Bottom2) return;
      }

      fprintf (stdout, "<FONT SIZE=-1><NOBR>\n");
      for (idx = 0; idx < ButtonCount; idx++)
      {
         if (ButtonInternal[idx] == NULL)
            PathPtr = ButtonPath[idx];
         else
         if (ButtonInternal[idx][0])
            PathPtr = ButtonInternal[idx];
         else
            continue;
         if (idx) fprintf (stdout, "&nbsp;");
         if (PathPtr[0])
            fprintf (stdout, "[<A HREF=\"%s\">%s</A>]\n",
                     PathPtr, ButtonLabel[idx]);
         else
            fprintf (stdout, "[%s]\n", ButtonLabel[idx]);
      }
      fprintf (stdout, "</NOBR></FONT>\n");

      if (Top1Bottom2 == 1)
         fprintf (stdout, "<HR ALIGN=left SIZE=2 WIDTH=90%%>\n");
   }
   else
   {
      /************/
      /* format 1 */
      /************/

      fprintf (stdout,
"<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>\
<TR><TD HEIGHT=2></TD></TR>\
</TABLE>\n\
<TABLE BORDER=%s CELLPADDING=%s CELLSPACING=0 WIDTH=100%%>\n\
<TR><TD%s>\n",
         PageScheme[PS_HEADBORDER],
         PageScheme[PS_HEADBORDER],
         PageScheme[PS_HEADBGCOLOR]);

      if (ButtonCount == 0 || !Top1Bottom2)
         fprintf (stdout, "&nbsp;\n");
      else
      {
         fprintf (stdout,
"<TABLE BORDER=%s CELLPADDING=1 CELLSPACING=0>\n",
            PageScheme[PS_BUTTONBORDER]);

         for (idx = 0; idx < ButtonCount; idx++)
         {
            if (ButtonInternal[idx] == NULL)
               PathPtr = ButtonPath[idx];
            else
            if (ButtonInternal[idx][0])
               PathPtr = ButtonInternal[idx];
            else
               continue;
            if (PathPtr[0])
               fprintf (stdout,
"<TD ALIGN=center%s><FONT SIZE=-1>\
<NOBR>&nbsp;&nbsp;<A HREF=\"%s\">%s</A>&nbsp;&nbsp;</NOBR></FONT></TD>\n",
                  PageScheme[PS_BUTTONBGCOLOR], PathPtr, ButtonLabel[idx]);
            else
               fprintf (stdout,
"<TD ALIGN=center%s><FONT SIZE=-1>\
<NOBR>&nbsp;&nbsp;%s&nbsp;&nbsp;</NOBR></FONT></TD>\n",
                  PageScheme[PS_BUTTONBGCOLOR], ButtonLabel[idx]);
         }

         fprintf (stdout, "</TR></TABLE>\n");
      }

      fprintf (stdout,
"</TD></TR>\n\
</TABLE>\n\
<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>\
<TR><TD HEIGHT=2></TD></TR>\
</TABLE>\n");
   }
}

/*****************************************************************************/
/*
Open the specified WordPerfect file, load it into dynamic memory, close the 
file.  Document is now pointed at by 'DocumentPtr', and contains 
'DocumentByteCount' bytes.
*/ 

ProcessDocumentFile ()

{
   int  ByteCount;

   /*********/
   /* begin */
   /*********/

   if (Debug)
      fprintf (stdout, "ProcessDocumentFile() |%s|\n", CgiPathTranslatedPtr);

   WpFileFd = open (CgiPathTranslatedPtr, O_RDONLY, 0, "ctx=stm", "shr=get");
   if (WpFileFd == -1)
   {
       ErrorVmsStatus (vaxc$errno, CgiPathInfoPtr, CgiPathTranslatedPtr,
                       __FILE__, __LINE__);
       exit (SS$_NORMAL);
   }

   DocumentPtr = NULL;
   DocumentByteCount = ByteCount = 0;
   for (;;)
   {
      if ((DocumentPtr =
           realloc (DocumentPtr, DocumentByteCount + WP_READ_CHUNK)) == NULL)
      {
         ErrorGeneral (ErrorMemoryAllocation, __FILE__, __LINE__);
         exit (SS$_NORMAL);
      }
      ByteCount = read (WpFileFd, DocumentPtr+DocumentByteCount, WP_READ_CHUNK);
      if (ByteCount > 0) DocumentByteCount += ByteCount;
      if (Debug)
         fprintf (stdout, "DocumentByteCount: %d ByteCount: %d\n",
                  DocumentByteCount, ByteCount);
      if (ByteCount < WP_READ_CHUNK) break;
   }

   if (ByteCount < 0)
   {
       ErrorVmsStatus (vaxc$errno, CgiPathInfoPtr, CgiPathTranslatedPtr,
                       __FILE__, __LINE__);
       exit (SS$_NORMAL);
   }

   close (WpFileFd);

   if (Debug) fprintf (stdout, "DocumentByteCount: %d\n", DocumentByteCount);

   ProcessDocument ();

   free (DocumentPtr);

   fclose (stdout);
}

/*****************************************************************************/
/*
*/ 

int ProcessDocument ()

{
   register unsigned char  *cptr, *zptr;

   int  HeaderLength;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ProcessDocument()\n");

   zptr = (cptr = DocumentPtr) + DocumentByteCount - 1;

   if (cptr[0] != 0xff || cptr[1] != 'W' || cptr[2] != 'P' || cptr[3] != 'C')
   {
      ErrorGeneral ("Does not appear to be a WordPerfect document!",
                    __FILE__, __LINE__);
      exit (SS$_NORMAL);
   }

   if (!PageTitlePtr[0]) PageTitlePtr = CgiPathInfoPtr;

   HeaderLength = *((unsigned long*)(cptr+4));
   if (HeaderLength)
   {
      if (DocumentPtr + HeaderLength > zptr)
      {
         ErrorGeneral ("Header does not make sense!", __FILE__, __LINE__);
         exit (SS$_NORMAL);
      }
      else
         cptr += HeaderLength;
   }

   fprintf (stdout,
"%s\
<HTML>\n\
<HEAD>\n\
<META NAME=\"generator\" CONTENT=\"%s\">\n\
<META NAME=\"file\" CONTENT=\"%s\">\n\
<META NAME=\"bytes\" CONTENT=\"%d\">\n\
<META NAME=\"header\" CONTENT=\"%d\">\n\
<TITLE>hyper~WordPerfect - %s</TITLE>\n\
</HEAD>\n\
<BODY%s>\n\
<TABLE BORDER=0 CELLPADDING=%s CELLSPACING=0 WIDTH=100%%%s>\n\
<TR><TD>\n\
<FONT COLOR=\"%s\" SIZE=+2><B>\n\
%s\n\
</B></FONT>\n\
<BR>\n\
<FONT COLOR=\"%s\" SIZE=-1>\n\
&nbsp;<SUP>*</SUP><U>hyper~WordPerfect</U>\n\
</FONT>\n\
</TD>%s</TR>\n\
</TABLE>\n",
      Http200Header,
      SoftwareID,
      CgiPathTranslatedPtr, DocumentByteCount, HeaderLength,
      PageTitlePtr,
      PageScheme[PS_BODYTAG],
      PageScheme[PS_HEADPADDING],
      PageScheme[PS_HEADBGCOLOR],
      PageScheme[PS_HEADTEXT],
      PageTitlePtr,
      PageScheme[PS_HEADTEXT],
      PageScheme[PS_HEADLOCAL]);
   HttpHasBeenOutput = true;

   ButtonBar (1);

   if (RevealCodes)
      fprintf (stdout, "<BR><TT>%s</TT><BR>\n", CgiPathTranslatedPtr);

   DocumentText = false;

   if (toupper(CgiFormTopicIndexPtr[0]) != 'N' &&
       toupper(CgiFormTopicIndexPtr[0]) != 'F') 
      BuildTopicIndex = true;
   else
      BuildTopicIndex = false;

   if (toupper(CgiFormTopicIndexPtr[0]) != 'N' &&
       toupper(CgiFormTopicIndexPtr[0]) != 'F') 
   {
      BuildTopicIndex = true;
      ProcessDocumentBody (cptr, zptr);
   }

   BuildTopicIndex = false;
   ProcessDocumentBody (cptr, zptr);

   ButtonBar (2);
}

/*****************************************************************************/
/*
*/ 

int ProcessDocumentBody
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   static char  KludgeString [] = "?";

   register int  ccnt;

   /*********/
   /* begin */
   /*********/

   PageNumber = 1;
   MarkNumber = PreviousPageNumber = SectionNumber = 0;
   RomanPageNumbers = true;
   ccnt = 0;

   while (dptr <= zptr)
   {
      if (*dptr > 31 && *dptr < 127)
      {
         /***********************/
         /* printable character */
         /***********************/

         if (PageNumber != PreviousPageNumber) NewPage ();

         if (DocumentText || AnchorText)
         {
            if (AnchorText) AnchorTextCount++;
            switch (*dptr)
            {
               /* escape relevant HTML-forbidden characters */
               case '<' : fputs ("&lt;", stdout); break;
               case '>' : fputs ("&gt;", stdout); break;
               case '&' : fputs ("&amp;", stdout); break;
               default :
                  /* fputc() seems to cause problems, hence this kludge! */
                  *KludgeString = *dptr;
                  fputs (KludgeString, stdout);
            }
            if (ccnt++ > 80 && isspace(*dptr)) 
            {
               fputs ("\n", stdout);
               ccnt = 0;
            }
         }
         dptr++;
         continue;
      }
      ccnt = 0;

      switch (*dptr)
      {
         /***************************/
         /* non-printable character */
         /***************************/

         case 0x09 :

            /* tab */
            if (DocumentText)
            {
               fputs (" ", stdout);
               if (RevealCodes) fputs ("<TT>[tab]</TT>\n", stdout);
               if (RevealDump)
                  fprintf (stdout, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x0b :

            /* soft-page */
            PageNumber++;
            if (DocumentText)
            {
               if (RevealCodes) fputs ("<TT>[SPg]</TT>\n", stdout);
               if (RevealDump)
                  fprintf (stdout, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x0c :

            /* hard-page */
            PageNumber++;
            if (DocumentText)
            {
               if (RevealCodes) fputs ("<TT>[HPg]</TT>\n", stdout);
               if (RevealDump)
                  fprintf (stdout, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x0a :

            /* hard-return */
            if (DocumentText)
            {
               fputs ("<BR>\n", stdout);
               if (RevealCodes) fputs ("<TT>[HRt]</TT>\n", stdout);
               if (RevealDump)
                  fprintf (stdout, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x0d :

            /* soft-return */
            if (DocumentText)
            {
               fputs (" ", stdout);
               if (RevealCodes) fputs ("<TT>[SRt]</TT>\n", stdout);
               if (RevealDump)
                  fprintf (stdout, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x83 :

            /* ETX */
            if (DocumentText)
            {
               if (RevealCodes) fputs ("<TT><I>[etx]</I></TT>\n", stdout);
               if (RevealDump)
                  fprintf (stdout, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x8c :

            /* soft-page */
            PageNumber++;
            if (DocumentText)
            {
               if (RevealCodes) fputs ("<TT>[SPg]</TT>\n", stdout);
               if (RevealDump)
                  fprintf (stdout, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0xa9 :

            /* hyphen */
            if (DocumentText)
            {
               fputs ("-", stdout);
               if (RevealCodes) fputs ("<TT>[-]</TT>", stdout);
               if (RevealDump)
                  fprintf (stdout, "<TT>{\%%%02.02x}</TT>", *dptr);
            }
            dptr++;
            break;

         case 0xc0 :

            dptr += Process0xc0 (dptr, zptr);
            break;

         case 0xc1 :

            dptr += Process0xc1 (dptr, zptr);
            break;

         case 0xc2 :

            dptr += Process0xc2 (dptr, zptr);
            break;

         case 0xc3 :

            dptr += Process0xc3 (dptr, zptr);
            break;

         case 0xc4 :

            dptr += Process0xc4 (dptr, zptr);
            break;

         case 0xc5 :

            dptr += Process0xc5 (dptr, zptr);
            break;

         case 0xc6 :

            dptr += Process0xc6 (dptr, zptr);
            break;

         case 0xc7 :
         case 0xc8 :
         case 0xc9 :
         case 0xca :
         case 0xcb :
         case 0xcc :
         case 0xcd :
         case 0xce :
         case 0xcf :

            dptr += Process0xcX (dptr, zptr);
            break;

         case 0xd0 :

            dptr += Process0xd0 (dptr, zptr);
            break;

         case 0xd1 :

            dptr += Process0xd1 (dptr, zptr);
            break;

         case 0xd2 :

            dptr += Process0xd2 (dptr, zptr);
            break;

         case 0xd3 :

            dptr += Process0xd3 (dptr, zptr);
            break;

         case 0xd4 :

            dptr += Process0xd4 (dptr, zptr);
            break;

         case 0xd5 :

            dptr += Process0xd5 (dptr, zptr);
            break;

         case 0xd7 :

            dptr += Process0xd7 (dptr, zptr, false);
            break;

         case 0xd8 :

            dptr += Process0xd8 (dptr, zptr);
            break;

         case 0xd9 :

            dptr += Process0xd9 (dptr, zptr);
            break;

         case 0xda :

            dptr += Process0xda (dptr, zptr);
            break;

         case 0xdb :

            dptr += Process0xdb (dptr, zptr);
            break;

         case 0xdc :

            dptr += Process0xdc (dptr, zptr);
            break;

         case 0xd6 :
         case 0xdd :
         case 0xde :
         case 0xdf :

            dptr += Process0xdX (dptr, zptr);
            break;

         default :

            if (DocumentText)
               if (RevealCodes) fprintf (stdout, "<TT>[%02.02x]</TT>", *dptr);
            dptr++;

      }  /* switch */

   } /* for(;;) */

   if (BuildTopicIndex)
   {
      if (MarkNumber) fputs ("</TABLE>\n", stdout);
   }
   else
   if (DocumentText)
      fputs ("\n</BLOCKQUOTE>\n", stdout);
}

/*****************************************************************************/
/*
*/ 

NewPage ()

{
   static int  LastPageNumber = 0;

   /*********/
   /* begin */
   /*********/

   PreviousPageNumber = PageNumber;

   if (BuildTopicIndex) return;

   DocumentText = true;
   if (LastPageNumber && PageNumber != LastPageNumber)
      fprintf (stdout, "</BLOCKQUOTE>\n");
   LastPageNumber = PageNumber;

   fprintf (stdout,
"<P>\n\
<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0 WIDTH=95%%>\n\
<TR><TD%s>\n\
<FONT COLOR=\"%s\"><NOBR>\
&nbsp;&nbsp;Page &nbsp;%s\
</NOBR></FONT>\n\
</TD></TR>\n\
</TABLE>\n\
<BLOCKQUOTE>\n",
      PageScheme[PS_HEADBGCOLOR],
      PageScheme[PS_HEADTEXT],
      CurrentPageNumber());
}

/*****************************************************************************/
/*
*/ 

char *CurrentPageNumber ()

{
   static char  *RomanUnits[] =
      { "","i","ii","iii","iv","v","vi","vii","viii","ix" };
   static char  *RomanTens[] =
      { "","x","xx","xxx","xl","l","lx","lxx","lxxx","xc" };
   static char  *RomanHundreds[] =
      { "","c","cc","ccc","cd","d","dc","dcc","dccc","cm" };
   static char  String [32];

   /*********/
   /* begin */
   /*********/

   if (SectionNumber > 1) RomanPageNumbers = false;
   if (RomanPageNumbers)
      sprintf (String, "%s%s%s",
               RomanHundreds[PageNumber/100],
               RomanTens[PageNumber/10],
               RomanUnits[PageNumber%10]);
      else
         sprintf (String, "%d", PageNumber);
   return (String);
}

/*****************************************************************************/
/*
Unknown 0xc? code.  Take a punt!  Most codes end in the same code they start
with, try and find it ... might break - but surely will otherwise!
*/ 

int Process0xcX
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   register unsigned char  *sptr;

   for (sptr = dptr; *sptr != *dptr && dptr < zptr; sptr++);
   if (!DocumentText) return (sptr - dptr);

   if (RevealCodes) fputs ("<TT>[0xdX]</TT>", stdout);
   if (DocumentText)
   {
      fputs ("<TT>[0xc?]</TT>", stdout);
      if (RevealDump) DumpCodes (dptr, sptr-dptr);
   }
   return (sptr - dptr);
}

/*****************************************************************************/
/*
*/ 

int Process0xc0
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (PageNumber != PreviousPageNumber) NewPage ();

   if (DocumentText)
   {
      switch (dptr[1])
      {
         case 0x03 :
            fputs ("* ", stdout);
            break;
         case 0x08 :
            fputs ("_", stdout);
            break;
         default :
            fputs (" ", stdout);
      }
      if (RevealCodes)
         fprintf (stdout, "<TT>[?:%d,%d]</TT>", dptr[2], dptr[1]);
      if (RevealDump) DumpCodes (dptr, 4);
   }
   return (4);
}

/*****************************************************************************/
/*
*/ 

int Process0xc1
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   switch (dptr[1])
   {
      case 0xe0 :
         if (DocumentText)
         {
            fputs (" ", stdout);
            if (RevealCodes) fputs ("<TT>[Centre]</TT>", stdout);
         }
         CentreCount++;
         break;
      default :
         if (DocumentText || AnchorText)
            fputs (" ", stdout);
         if (DocumentText)
            if (RevealCodes) fputs ("<TT>[spacing?]</TT>", stdout);
   }
   if (DocumentText && RevealDump) DumpCodes (dptr, 9);
   return (9);
}

/*****************************************************************************/
/*
*/ 

int Process0xc2
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      fputs (" ", stdout);
      if (RevealCodes) fputs ("<TT>[-&gt;Indent?]</TT>", stdout);
      if (RevealDump) DumpCodes (dptr, 11);
   }
   return (11);
}

/*****************************************************************************/
/*
*/ 

int Process0xc3
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      if (RevealCodes) fputs ("<TT>[font?]</TT>", stdout);
      if (RevealDump) DumpCodes (dptr, 3);
   }
   return (3);
}

/*****************************************************************************/
/*
*/ 

int Process0xc4
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      if (RevealDump) DumpCodes (dptr, 3);
      switch (dptr[1])
      {
         case 0x02 :
            if (RevealCodes) fputs ("<TT>[large]</TT>", stdout);
            break;
         case 0x08 :
            if (ItalicCount)
            {
               ItalicCount = 0;
               fputs ("</I> ", stdout);
            }
            if (RevealCodes) fputs ("<TT>[italic]</TT>", stdout);
            break;
         case 0x0c :
            if (BoldCount)
            {
               BoldCount = 0;
               fputs ("</B>", stdout);
            }
            if (RevealCodes) fputs ("<TT>[bold]</TT>", stdout);
            break;
         case 0x0e :
            if (UnderlineCount)
            {
               UnderlineCount = 0;
               fputs ("</U>", stdout);
            }
            if (RevealCodes) fputs ("<TT>[und]</TT>", stdout);
            break;
         default :
            if (RevealCodes) fputs ("<TT>[emphasis?]</TT>", stdout);
      }
   }
   return (3);
}

/*****************************************************************************/
/*
*/ 

int Process0xc5
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      fputs (" ", stdout);
      if (RevealCodes) fprintf (stdout, "<TT>[Block Pro:?]</TT>");
      if (RevealDump) DumpCodes (dptr, 5);
   }
   return (5);
}

/*****************************************************************************/
/*
*/ 

int Process0xc6
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      fputs (" ", stdout);
      if (RevealCodes) fprintf (stdout, "<TT>[spacing]</TT>");
      if (RevealDump) DumpCodes (dptr, 6);
   }
   return (6);
}

/*****************************************************************************/
/*
An unknown 0xd? code.  Because 0xd? codes seem to have their length as the 
second short int of the structure calculate the length of this unknown one, 
then skip over it!
*/ 

int Process0xdX
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (DocumentText)
   {
      fputs ("<TT>[0xd?]</TT>", stdout);
      if (RevealDump)
      {
         DumpCodes (dptr, 4);
         fprintf (stdout, "<TT>(%d)</TT>", Length);
         DumpCodes (dptr+4, Length);
      }
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd0
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Tab Set:]</TT>", stdout);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (stdout, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd1
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Font?]</TT>", stdout);
   if (RevealDump)
   {
         DumpCodes (dptr, 4);
         fprintf (stdout, "<TT>(%d)</TT>", Length);
         DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd2
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Par Num Def:]</TT>", stdout);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (stdout, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd3
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   PageNumber = 1;
   SectionNumber++;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Page Num:]</TT>", stdout);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (stdout, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd4
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (DocumentText)
   {
      if (dptr[1])
      {
         switch (dptr[6])
         {
            case 0x7e :
               if (!UnderlineCount++) fputs ("<U>", stdout);
               if (RevealCodes) fputs ("<TT>[UND]</TT>", stdout);
               break;
            case 0x87 :
               if (!ItalicCount++) fputs (" <I>", stdout);
               if (RevealCodes) fputs ("<TT>[ITALIC]</TT>", stdout);
               break;
            case 0x85 :
            case 0xa0 :
               if (!BoldCount++) fputs ("<B>", stdout);
               if (RevealCodes) fputs ("<TT>[BOLD]</TT>", stdout);
               break;
            default :
               if (RevealCodes) fputs ("<TT>[EMPHASIS?]</TT>", stdout);
         }
      }
      else
         if (RevealCodes) fputs ("<TT>[EMPHASIS?]</TT>", stdout);

      if (RevealDump)
      {
         DumpCodes (dptr, 4);
         fprintf (stdout, "<TT>(%d)</TT>", Length);
         DumpCodes (dptr+4, Length);
      }
   }

   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd5
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Header/Footer]</TT>", stdout);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (stdout, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd7
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (dptr[1] == 0x00)
   {
      if (BuildTopicIndex)
      {
         if (!MarkNumber++)
         {
            fputs (
"<P><TABLE BORDER=0 CELLPADDING=2 CELLSPACING=2>\n\
<TR><TH COLSPAN=2><FONT SIZE=+1>Index of Topics</FONT></TH></TR>\n\
<TR><TH ALIGN=left>Topic</TH><TH ALIGN=left>Page</TH></TR>\n",
            stdout);
         }
         fprintf (stdout, "<TR><TD><A HREF=\"#Mark%d\">", MarkNumber);
         AnchorText = true;
         AnchorTextCount = 0;
      }
      else
      {
         if (!DocumentText) return (Length+4);

         fprintf (stdout, "<TR><TD><A NAME=\"Mark%d\">", ++MarkNumber);
         if (RevealDump)
         {
            DumpCodes (dptr, 4);
            fprintf (stdout, "<TT>(%d)</TT>", Length);
            DumpCodes (dptr+4, Length);
         }
         else;
      }
   }
   else
   if (dptr[1] == 0x01)
   {
      if (BuildTopicIndex)
      {
         if (AnchorText)
         {
            if (AnchorTextCount)
               fprintf (stdout, "</A></TD><TH ALIGN=right>%s</TD></TR>\n",
                  CurrentPageNumber());
            else
               fprintf (stdout, 
"<I>(unknown heading)</I></A></TD><TH ALIGN=right>%s</TD></TR>\n",
                  CurrentPageNumber());
            AnchorText = false;
            AnchorTextCount = 0;
         }
         else;
      }
      else
      {
         if (!DocumentText) return (Length+4);

         fputs ("</A></TD></TR>", stdout);
         if (RevealCodes) fputs ("<TT>[Mark end]</TT>", stdout);
         if (RevealDump)
         {
            DumpCodes (dptr, 4);
            fprintf (stdout, "<TT>(%d)</TT>", Length);
            DumpCodes (dptr+4, Length);
         }
         else;
      }
   }
   else
   {
      if (!BuildTopicIndex)
      {
         if (RevealCodes) fputs ("<TT>[Mark?]</TT>", stdout);
         if (RevealDump)
         {
            DumpCodes (dptr, 4);
            fprintf (stdout, "<TT>(%d)</TT>", Length);
            DumpCodes (dptr+4, Length);
         }
      }
   }

   return (Length+4);
}

/*****************************************************************************/
/*
Automatically-numbered paragraphs (bit list a numeric list!)
*/ 

int Process0xd8
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   register unsigned char  *cptr, *sptr;

   int  Count;
   unsigned short  Length;
   unsigned char  String [256];

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Par Num:Auto]</TT>", stdout);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (stdout, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }

/*
   cptr = dptr+4;
   Count = Length;
   while (Count-- && !isdigit(*cptr)) cptr++;
   if (Count < 0) Count = 0;
   sptr = String;
   while (Count-- && *cptr != '.') *sptr++ = *cptr++;
   if (*cptr == '.') *sptr++ = *cptr;
   *sptr++ = ' ';
   *sptr = '\0';
   fputs (String, stdout);
*/
   cptr = dptr+4;
   Count = 0;
   while (Count++ < Length && !isdigit(*cptr)) cptr++;
   sptr = String;
   while (Count++ < Length && *cptr != '.') *sptr++ = *cptr++;
   if (*cptr == '.') *sptr++ = *cptr;
   *sptr++ = ' ';
   *sptr = '\0';
   fputs (String, stdout);

   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd9
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Comment/Outline?]</TT>", stdout);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (stdout, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xda
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Fig Box:]</TT>", stdout);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (stdout, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xdb
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Style...]</TT>", stdout);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (stdout, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xdc
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   static int  ColumnCount = 0,
               RowCount = 0;

   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   switch (dptr[1])
   {
      case 0x00 :
         if (TableCount)
         {
            while (ColumnCount <= dptr[5])
            {
               if (ColumnCount)
                  fputs ("</TD><TD>&nbsp;", stdout);
               else
                  fputs ("<TD>&nbsp;", stdout);
               ColumnCount++;
            }
         }
         if (RevealCodes)
            fprintf (stdout, "<TT>[Cell(%d)]</TT>", dptr[5]);
         break;

      case 0x01 :
         if (!TableCount)
            fputs ("<TABLE BORDER=1 CELLPADDING=3 CELLPSACING=3 NOWRAP>\n",
                   stdout);
         if (TableCount++)
            fputs ("</TD></TR>\n<TR>", stdout);
         else
            fputs ("<TR>", stdout);
         if (RevealCodes) fputs ("\n<BR><TT>[Row]</TT>", stdout);
         RowCount++;
         ColumnCount = 0;
         break;

      case 0x02 :
         if (TableCount)
         {
            fputs ("</TR>\n</TABLE>\n", stdout);
            TableCount = ColumnCount = RowCount = 0;
         }
         if (RevealCodes) fputs ("<TT>[Tbl Off]</TT>", stdout);
         break;

      default :
         if (RevealCodes) fputs ("<TT>[Table?]</TT>", stdout);
   }

   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (stdout, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }

   return (Length+4);
}

/*****************************************************************************/
/*
Display 'ccnt' number of bytes beginning with 'dptr', or if 'ccnt' is less 
than zero dump a null-terminated string beginning at 'dptr'.
*/ 

int DumpCodes
(
register unsigned char *dptr,
register int ccnt
)
{
   fputs ("<TT>", stdout);
   if (ccnt >= 0)
   {
      while (ccnt--)
      {
         fprintf (stdout, "{\%%%02.02x}", *dptr++);
         if (!(ccnt % 16)) fputs ("<BR>\n", stdout);
      }
   }
   else
   {
      ccnt = 0;
      while (*dptr)
      {
         fprintf (stdout, "{\%%%02.02x}", *dptr++);
         if (!(++ccnt % 16)) fputs ("<BR>\n", stdout);
      }
      fprintf (stdout, "{\%%%02.02x}", *dptr);
   }
   fputs ("</TT>", stdout);
}

/*****************************************************************************/
/*
*/

ErrorGeneral
(
char *Text,
char *SourceFileName,
int SourceLineNumber
)
{
   register char  *cptr;

   /*********/
   /* begin */
   /*********/

   /* 
      The source file format provided by the "__FILE__" macro will be
      "device:[directory]name.type;ver".  Reduce that to "name.type".
   */
   for (cptr = SourceFileName; *cptr && *cptr != ';'; cptr++);
   if (*cptr)
   {
      while (*cptr != '.') cptr--;
      *cptr-- = '\0';
   }
   while (*cptr != ']') cptr--;
   cptr++;

   if (!HttpHasBeenOutput) fputs (Http404Header, stdout);
   fprintf (stdout,
"<!-- SoftwareID: %s Module: %s Line: %d -->\n\
<H1>ERROR!</H1>\n\
<P>Reported by server.\n\
<P>%s\n",
   SoftwareID, cptr, SourceLineNumber, Text);
}

/*****************************************************************************/
/*
*/

ErrorVmsStatus
(
int StatusValue,
char *Text,
char *HiddenText,
char *SourceFileName,
int SourceLineNumber
)
{
   static char  Message [256];
   static $DESCRIPTOR (MessageDsc, Message);

   register char  *cptr;
   int  status;
   short int  Length;

   /*********/
   /* begin */
   /*********/

   if (VMSok (status = sys$getmsg (StatusValue, &Length, &MessageDsc, 1, 0))) 
   {
      Message[Length] = '\0';
      Message[0] = toupper(Message[0]);
   }
   else
      exit (status);

   /* 
      The source file format provided by the "__FILE__" macro will be
      "device:[directory]name.type;ver".  Reduce that to "name.type".
   */
   for (cptr = SourceFileName; *cptr && *cptr != ';'; cptr++);
   if (*cptr)
   {
      while (*cptr != '.') cptr--;
      *cptr-- = '\0';
   }
   while (*cptr != ']') cptr--;
   cptr++;

   if (!HttpHasBeenOutput) fputs (Http404Header, stdout);
   fprintf (stdout,
"<!-- SoftwareID: %s Module: %s Line: %d -->\n\
<H1>ERROR!</H1>\n\
<P>Reported by server.\n\
<P>%s ... <TT>%s</TT>\n\
<!-- %%X%08.08X \"%s\" -->\n",
   SoftwareID, cptr, SourceLineNumber, Message, Text, StatusValue, HiddenText);
}

/****************************************************************************/
/*
Does a case-insensitive, character-by-character string compare and returns 
true if two strings are the same, or false if not.  If a maximum number of 
characters are specified only those will be compared, if the entire strings 
should be compared then specify the number of characters as 0.
*/ 

boolean strsame
(
register char *sptr1,
register char *sptr2,
register int  count
)
{
   while (*sptr1 && *sptr2)
   {
      if (toupper (*sptr1++) != toupper (*sptr2++)) return (false);
      if (count)
         if (!--count) return (true);
   }
   if (*sptr1 || *sptr2)
      return (false);
   else
      return (true);
}

/*****************************************************************************/

