// postCGIplus.java
// Compile using: $ javac "postCGIplus.java"
//
// 03-SEP-98  MGD  changes in line with JDK 1.1.6 final release
// 09-DEC-97  MGD  initial
//
// Example of POSTed, "x-www-form-urlencoded" processing.
// Can be invoked using ... http://host/cgiplus-bin/postcgiplus.class

import java.io.*;

public class postcgiplus {

   private static CGIplus cgienv = new CGIplus();
   private static String nameValue = null;

   public static void main (String args[]) {

      /* CGIplus "infinite loop" */
      for (;;) {

         cgienv.begin();

         System.out.println("There are " +
                            cgienv.getCgiVarCount() +
                            " CGI variables ...");
         while ((nameValue = cgienv.nextCgiVar()) != null)
            System.out.print(nameValue);

         System.out.println("");

         if (cgienv.isPOSTedForm()) {

            System.out.print("Content-Type: " +
                             cgienv.getCgiVar("CONTENT_TYPE"));
            System.out.println("");

            System.out.print("Dump of form fields ...");
            while ((nameValue = cgienv.nextFormField()) != null)
               System.out.print(nameValue);
            System.out.println("");

            System.out.print("Field \"hidden1\": " +
                             cgienv.getFormField("hidden1"));
            System.out.print("Field \"hidden2\": " +
                             cgienv.getFormField("hidden2"));
            System.out.print("Field \"hidden3\" (which doesn't exist): " +
                             cgienv.getFormField("hidden3"));
            System.out.print("Field \"userinput\": " +
                             cgienv.getFormField("userinput"));
         }
         else {
            System.out.print("Request was not POSTed!");
         }

         cgienv.end();
      }
   }
}
