/*****************************************************************************/
/*
                                   charset.c

CGI-compliant script to render the ISO Latin 1 character set using HTML
entities.


BUILD
-----
See BUILD_CHARSET.COM


VERSION HISTORY
---------------
20-MAY-98  MGD  v1.1.0, cosmetic changes
07-MAR-96  MGD  v1.0.0, quick hack
*/
/*****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [] = "CHARSET AXP-1.1.0";
#else
   char SoftwareID [] = "CHARSET VAX-1.1.0";
#endif

#include <stdio.h>
#include <errno.h>

char  Utility [] = "CHARSET";

/*****************************************************************************/
/*
*/

main ()

{
   int  Count;
   char  *HttpUserAgentPtr;

   /*********/
   /* begin */
   /*********/

   /* reopen output stream so that the '\r' and '\n' are not filtered */
#ifdef __DECC
   if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "ctx=bin")) == NULL)
      exit (vaxc$errno);
#else
   if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "rfm=udf")) == NULL)
      exit (vaxc$errno);
#endif

   if ((HttpUserAgentPtr = getenv ("WWW_HTTP_USER_AGENT")) == NULL)
      HttpUserAgentPtr = "<I>unknown browser!</I>";

   fprintf (stdout,
"HTTP/1.0 200 Success\r\n\
Content-Type: text/html\r\n\
\r\n\
<HTML>\n\
<HEAD>\n\
<META NAME=\"generator\" CONTENT=\"%s\">\n\
<TITLE>Charset</TITLE>\n\
</HEAD>\n\
<BODY BGCOLOR=\"#ffffff\" TEXT=\"#000000\">\n\
<TABLE BORDER=0 CELLSPACING=2 CELLPADDING=2>\n\
<TH COLSPAN=16>\
%s\
<BR>renders the entity set 1 to 255 in the way you see below\
</TH>\
<TR>\n\
<TD></TD><TD></TD>\n",
      SoftwareID, HttpUserAgentPtr);

   for (Count = 1; Count <= 255; Count++)
   {
      if (!(Count % 8))
      {
         if (Count > 1) fprintf (stdout, "</TR>\n");
         fprintf (stdout, "<TR>\n");
      }
      fprintf (stdout,
"<TD ALIGN=right><TT>&amp;#%d;</TT></TD><TD ALIGN=left>&#%d;&nbsp;</TD>\n",
         Count, Count);
   }

   fprintf (stdout,
"</TR>\n\
</TABLE>\n\
</BODY>\n\
</HTML>\n");

   exit (1);
}

/*****************************************************************************/

