/*****************************************************************************/
/*
                              MXMailingList.c


This HTTP server simply returns the contents of an MX mailing list.

The MX mailing list is not a plain-text file.  Each record has 28 bytes of 
static storage and two word-aligned counted ASCII strings (1 byte count, then 
0 to 255 characters).  The record structure has been deduced from MX source 
code and is shown below.  The forward and backward link longwords, and 
creation and modification date/time quadwords have no purpose in the on-disk 
mailing-list file.  The flags longword is used to store the characteristics of 
the subscriber (/NOCASE, /NOREPRO, etc.).  The first counted ASCII string 
stores the RFC 822 address of the subscriber (e.g. blogss@wasd.dsto.gov.au).  
The second counted ASCII string is the "personal name" of the subscriber (e.g. 
"Fred Bloggs" <bloggs@wasd.dsto.gov.au>).

It can only be speculated that the links and quadword times are stored on-
disk so that a record read from a file does not have to be re-formatted in any 
way before being placed in some in-memory structure by MX during mailing-list 
processing, lending to (slightly?) greater efficiency. 


FROM MX SOURCE FILE "MX_LCLDEFS.R32"
-----------------------------------
This is the definition in BLISS32 of each record in a mailing list.

_DEF (MLE)
        MLE_L_FLINK     = _LONG,
        MLE_L_BLINK     = _LONG,
        MLE_Q_CREDT     = _QUAD,
        MLE_Q_MODDT     = _QUAD,
        MLE_L_FLAGS     = _LONG,
        _OVERLAY (MLE_L_FLAGS)
                MLE_V_NOMAIL    = _BIT,
                MLE_V_NOCASE    = _BIT,
                MLE_V_CONCEAL   = _BIT,
                MLE_V_NOREPRO   = _BIT,
                MLE_V_ACCESS    = _BIT,
        _ENDOVERLAY
        MLE_W_ADDR      = _WORD,
        MLE_T_ADDR      = _BYTES (MLE_S_ADRR),
        _ALIGN(WORD)
        MLE_W_NAME      = _WORD,
        MLE_T_NAME      = _BYTES (MLE_S_ADRR),
_ENDDEF (MLE);

*/

#if 0

The actual format for the mailing list file records in a C-style is more like 
the following:

{
        void  *Flink;               /* no apparent use in list files! */
        void  *Blink;               /* no apparent use in list files! */
        unsigned long  CreDt [2];   /* no apparent use in list files! */
        unsigned long  ModDt [2];   /* no apparent use in list files! */
        unsigned long  Flags;       /* flags are used */
        unsigned char  AddrCount;   /* count of counted string */
        char  Address[0..255];      /* characters in counted ASCII string */
        /* the end of this string must be word aligned */
        unsigned char  NameCount;   /* count of counted string */
        char  Name[0..255];         /* characters in counted ASCII string */
        /* the end of this string must be word aligned */
}

#endif

/* 


QUALIFIERS
----------
/DBUG                   turns on all "if (Debug)" statements
/DIRECTORY=             the directory in which to create the mailing list(s)


BUILD DETAILS
-------------
See BUILD_MXMAILINGLIST.COM


VERSION HISTORY (update SoftwareID as well!)
---------------
01-MAY-97  MGD  v1.2.0, add <TITLE></TITLE>, revert to 'stdout'
19-SEP-95  MGD  v1.1.1, replace <CR><LF> carriage-control with single newline,
                        still acceptable for HTTP, and slightly more efficient
24-MAY-95  MGD  v1.1.0, minor changes for AXP compatibility
11-NOV-94  MGD  v1.0.1, allow for empty list
26-OCT-94  MGD  v1.0.0, initial development
*/
/*****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [] = "MXMAILINGLIST AXP-1.2.0";
#else
   char SoftwareID [] = "MXMAILINGLIST VAX-1.2.0";
#endif

/* standard C header files */
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

/* VMS-related header files */
#include <descrip.h>
#include <rms.h>
#include <ssdef.h>
#include <stsdef.h>

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/***************/
/* definitions */
/***************/

#define boolean int
#define true 1
#define false 0
 
#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))
#define VMSwarning(x) (((x) & 0x7) == STS$K_WARNING)
#define VMSerror(x) (((x) & 0x7) == STS$K_ERROR)
#define VMSinfo(x) (((x) & 0x7) == STS$K_INFO)
#define VMSfatal(x) (((x) & 0x7) == STS$K_SEVERR)
 
#define MxMailListDefault "MX_DEVICE:[MX.MLF.MAILING_LISTS].MAILING_LIST"

/******************/
/* global storage */
/******************/

char  *Utility = "MXMAILINGLIST";

boolean  Debug;

char  ClientHostName [256],
      MxMailListName [256],
      Method [256],
      MxMailListDirectory [256],
      MailListName [256],
      ServiceName [256],
      UriParameter [256];

/***********************/
/* function prototypes */
/***********************/

char* SysGetMsg (int);

/*****************************************************************************/
/*
*/

main (int argc, char *argv[])

{
   register int  acnt;
   register char  *cptr;
   int  status;

   /*********/
   /* begin */
   /*********/

   /* get the command line parameters */
   if (argc >= 2) strcpy (ClientHostName, argv[1]);
   if (argc >= 3) strcpy (Method, argv[2]);
   if (argc >= 4) strcpy (UriParameter, argv[3]);
   for (acnt = 4; acnt < argc; acnt++)
   {
      for (cptr = argv[acnt]; *cptr; cptr++) *cptr = toupper(*cptr);
      if (strstr (argv[acnt], "/DBU")) Debug = true;
   }

   if (getenv("MXMAILINGLIST$DBUG") != NULL) Debug = true;

   if (Debug)
      system ("show sym *");
   else
   {
      /* reopen output stream so that the '\r' and '\n' are not filtered */
#ifdef __DECC
      if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "ctx=bin")) == NULL)
         exit (vaxc$errno);
#else
      if ((stdout = freopen ("SYS$OUTPUT", "w", stdout, "rfm=udf")) == NULL)
         exit (vaxc$errno);
#endif
   }

   MethodGet ();

   exit (SS$_NORMAL);
}

/*****************************************************************************/
/*
Parse the URI parameter, getting service name, file name, and any aidditional 
parameters, then call the Bookreader function to process it.
*/

MethodGet ()

{
   register char  *sptr, *uptr;
   int  status;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "MethodGet() |%s|\n", UriParameter);

   uptr = UriParameter;

   sptr = ServiceName;
   if (*uptr == '/') *sptr++ = *uptr++;
   while (*uptr && *uptr != '/' && *uptr != '&') *sptr++ = *uptr++;
   *sptr = '\0';
   if (Debug) fprintf (stdout, "ServiceName |%s|\n", ServiceName);
   if (*uptr) uptr++;

   sptr = MxMailListName;
   if (*uptr == '/') *sptr++ = *uptr++;
   while (*uptr && *uptr != '?' && *uptr != '&') *sptr++ = tolower(*uptr++);
   *sptr = '\0';
   if (Debug) fprintf (stdout, "MxMailListName |%s|\n", MxMailListName);
   if (*uptr) uptr++;

   while (*uptr)
   {
      if (*uptr == '&') uptr++;
      if (Debug) fprintf (stdout, "uptr |%s|\n", uptr);
   }

   status = ProcessMxMailList (MxMailListName, strlen(MxMailListName));
   if (status == RMS$_FNF)
   {
      fprintf (stdout,
"HTTP/1.0 400 error\r\n\
Content-Type: text/html\r\n\
\r\n\
<HTML>\n\
<TITLE>Error 400</TITLE>\n\
<H2>ERROR!</H2>\n\
<P>\n\
Reported by server.\n\
<P>\n\
Mailing list not found: \"%s\"\n\
</HTML>\n",
      MxMailListName);
   }
   else
   if (VMSnok (status))
   {
      fprintf (stdout,
"HTTP/1.0 400 Error\r\n\
Content-Type: text/html\r\n\
\r\n\
<HTML>\n\
<TITLE>Error 400</TITLE>\n\
<H2>ERROR!</H2>\n\
<P>\n\
Reported by server.\n\
<P>\n\
Error accessing mailing list: \"%s\"\n\
<BR>%s\n\
</HTML>\n",
      MxMailListName, SysGetMsg(status));
   }
}

/*****************************************************************************/
/*
*/ 

ProcessMxMailList
(
char *MxMailListFileName,
int MxMailListFileNameLength
)
{
   register int  ccnt;
   register char  *cptr, *sptr;
   int  status,
        LineCount = 0;
   char  Address [256],
         Name [256];
   unsigned char  MxMailListRecord [28+512];
   struct FAB  MxMailListFAB;
   struct RAB  MxMailListRAB;

   /**************************/
   /* open mailing-list file */
   /**************************/

   if (Debug)
      fprintf (stdout, "ProcessMxMailList() |%s|\n", MxMailListFileName);

   MxMailListFAB = cc$rms_fab;
   MxMailListFAB.fab$l_dna = MxMailListDefault;
   MxMailListFAB.fab$b_dns = strlen(MxMailListDefault);
   MxMailListFAB.fab$b_fac = FAB$M_GET;
   MxMailListFAB.fab$l_fna = MxMailListFileName;  
   MxMailListFAB.fab$b_fns = MxMailListFileNameLength;
   MxMailListFAB.fab$b_shr = FAB$M_SHRGET;

   if (VMSnok (status = sys$open (&MxMailListFAB, 0, 0)))
   {
      if (Debug) fprintf (stdout, "sys$open() %%X%08.08X\n", status);
      return (status);
   }

   MxMailListRAB = cc$rms_rab;
   MxMailListRAB.rab$l_fab = &MxMailListFAB;
   /* 2 buffers, read ahead performance option */
   MxMailListRAB.rab$b_mbf = 2;
   MxMailListRAB.rab$l_rop = RAB$M_RAH;

   if (VMSnok (status = sys$connect (&MxMailListRAB, 0, 0)))
   {
      if (Debug) fprintf (stdout, "sys$connect() %%X%08.08X\n", status);
      sys$close (&MxMailListFAB, 0, 0);
      return (status);
   }

   fprintf (stdout,
"HTTP/1.0 200 Success\r\n\
Content-Type: text/html\r\n\
\r\n\
<HTML>\r\n\
<TITLE>%s</TITLE>\n\
<PLAINTEXT>",
      MxMailListName);

   /***************************************/
   /* loop through mailing-list record(s) */
   /***************************************/

   MxMailListRAB.rab$l_ubf = MxMailListRecord;
   MxMailListRAB.rab$w_usz = sizeof(MxMailListRecord);

   while (VMSok (status = sys$get (&MxMailListRAB, 0, 0)))
   {
      if (!(MxMailListRAB.rab$w_rsz)) continue;

      cptr = MxMailListRecord + 28;

      ccnt = *cptr++;
      sptr = Address;
      while (ccnt--) *sptr++ = *cptr++;
      *sptr = '\0';
      if (Debug) fprintf (stdout, "Address |%s|\n", Address);

      ccnt = *cptr++;
      sptr = Name;
      while (ccnt--) *sptr++ = *cptr++;
      *sptr = '\0';
      if (Debug) fprintf (stdout, "Name |%s|\n", Name);

      if (Name[0])
         fprintf (stdout, "%s <%s>\n", Name, Address);
      else
         fprintf (stdout, "%s\n", Address);

      LineCount++;
   }

   if (Debug) fprintf (stdout, "sys$get() %%X%08.08X\n", status);
   if (status == RMS$_EOF) status = SS$_NORMAL;

   /************/
   /* end loop */
   /************/

   sys$close (&MxMailListFAB, 0, 0);

   if (!LineCount++) fprintf (stdout, "... empty!\n");

   return (status);
}

/*****************************************************************************/
/*
*/
 
char* SysGetMsg (int StatusValue)
 
{
   static char  Message [256];
   short int  Length;
   $DESCRIPTOR (MessageDsc, Message);
 
   sys$getmsg (StatusValue, &Length, &MessageDsc, 0, 0);
   Message[Length] = '\0';
   if (Debug) fprintf (stdout, "SysGetMsg() |%s|\n", Message);
   return (Message);
}
 
/****************************************************************************/
/*
Does a case-insensitive, character-by-character string compare and returns 
true if two strings are the same, or false if not.  If a maximum number of 
characters are specified only those will be compared, if the entire strings 
should be compared then specify the number of characters as 0.
*/ 
 
boolean strsame
(
register char *sptr1,
register char *sptr2,
register int  count
)
{
   while (*sptr1 && *sptr2)
   {
      if (toupper (*sptr1++) != toupper (*sptr2++)) return (false);
      if (count)
         if (!--count) return (true);
   }
   if (*sptr1 || *sptr2)
      return (false);
   else
      return (true);
}
 
/*****************************************************************************/

