$!-----------------------------------------------------------------------------
$! UPDATE.COM
$!
$! WASD (HFRD) VMS Hypertext Services, Copyright (c) 1996-1998 Mark G.Daniel.
$! This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
$! This is free software, and you are welcome to redistribute it
$! under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.
$!
$! Update the WASD Hypertext Services Package.
$!
$! 03-SEP-98  MGD  version 5.2
$! 27-JUN-98  MGD  initial, v5.1 (and some would say long overdue!)
$!-----------------------------------------------------------------------------
$!
$ set noverify
$!
$ UPDATE_VERSION = "v5.2"
$!
$ if f$trnlnm("HT_ROOT","LNM$JOB") .eqs. ""
$ then
$!   (subprocess to do the actual work, define local logicals)
$    currentProcedure = f$environment("PROCEDURE")
$    procDevice = f$parse(currentProcedure,,,"DEVICE","NO_CONCEAL")
$    procDirectory = f$parse(currentProcedure,,,"DIRECTORY","NO_CONCEAL")
$!   (derive from the location of this procedure, assumes HT_ROOT tree!)
$    htRoot = procDevice +-
        (procDirectory --
         f$extract(f$locate("HT_ROOT",procDirectory),999,procDirectory)) +-
        "HT_ROOT.]"
$    define /job /nolog /translation=concealed HT_ROOT 'htRoot'
$    archName = f$edit(f$getsyi("ARCH_NAME"),"UPCASE")
$    if archName .eqs. "ALPHA" then archName = "AXP"
$    htExe = "HT_ROOT:[''archName']"
$    define /job /nolog HT_EXE 'htExe'
$!   (spawn a subprocess to do the actual install ensures job logical deletion)
$    spawn /wait @'currentProcedure' -
           "''P1'" "''P2'" "''P3'" "''P4'" "''P5'" "''P6'" "''P7'" "''P8'"
$    deassign /job HT_ROOT
$    deassign /job HT_EXE
$    exit
$ endif
$!
$ say = "write sys$command"
$ copy = "copy/log/prot=w:re"
$ purge = "purge/log"
$ currentDefault = f$environment("DEFAULT")
$!
$!-----------------------------------------------------------------------------
$!
$ type SYS$INPUT

WASD (HFRD) VMS Hypertext Services, Copyright (c) 1996-1998 Mark G.Daniel.
This package (all associated programs), comes with ABSOLUTELY NO WARRANTY.
This is free software, and you are welcome to redistribute it
under the conditions of the GNU GENERAL PUBLIC LICENSE, version 2.

$ say "--- UPDATE TO WASD VMS HYPERTEXT SERVICES ''UPDATE_VERSION' ---"
$ type SYS$INPUT

All sections making file-system modifications may be individually declined.
In this sense the update may be undertaken step-by-step or sections repeated.
The first section is LINKING, after which you will be able to quit.
In a mixed architecture cluster (including both Alpha and VAX systems)
the link section must be done on both!
$!
$!-----------------------------------------------------------------------------
$!
$ if f$trnlnm("HT_ROOT","LNM$SYSTEM") .eqs. ""
$ then
$    type SYS$INPUT

  *****************************************
  *  "HT_ROOT" logical name not detected. *
  *  This does not look like an update!   *
  *****************************************

$    exit
$ endif
$!
$ if f$search("HT_ROOT:[000000]*.*") .eqs. ""
$ then
$    type SYS$INPUT

  *********************************************************
  *  Appears to be a problem with the "HT_ROOT" logical!  *
  *********************************************************

$    exit
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type SYS$INPUT

--- LINK EXECUTABLES ---

$ tcpipAgent = ""
$!
$ if f$trnlnm("UCX$DEVICE","LNM$SYSTEM") .nes. "" .and. -
     f$trnlnm("NETLIB_SHR","LNM$SYSTEM") .eqs. ""
$ then
$ type SYS$INPUT
|  "UCX$DEVICE" logical detected, "NETLIB_SHR" logical not detected.
|  UCX (Digital TCP/IP Services)?
|
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if response then tcpipAgent = "UCX"
$ endif
$!
$ if f$trnlnm("NETLIB_SHR","LNM$SYSTEM") .nes. "" .and. -
     f$trnlnm("UCX$DEVICE","LNM$SYSTEM") .eqs. ""
$ then
$ type SYS$INPUT
|  "NETLIB_SHR" logical detected, "UCX$DEVICE" logical not detected.
|  Mad-Goat NETLIB?
|
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if response then tcpipAgent = "NETLIB"
$ endif
$!
$ if tcpipAgent .eqs. ""
$ then
$    tcpipAgentLoop:
$       type SYS$INPUT
|  TCP/IP agent is not obvious.
|  Choices: UCX (Digital TCP/IP Services) or NETLIB or NONE
|  Link object code for which?
|
$       response = ""
$       read sys$command response /prompt="[UCX]: "
$       if response .eqs. "" then response = "UCX"
$       response = f$edit(response,"UPCASE")
$       if response .eqs. "UCX" .or. -
           response .eqs. "NETLIB" .or. -
           response .eqs. "NONE" -
           then goto endTcpipAgentLoop
$    endTcpipAgentLoop:
$    tcpipAgent = response
$    if tcpipAgent .eqs. "NONE" then tcpipAgent = ""
$ endif
$!
$ if tcpipAgent .nes. "" .and. -
     P1 .nes. "SSL"
$ then
$    say "|"
$    say "|  Link all executables (using ''tcpipAgent' where appropriate)?"
$    say "|"
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if response
$    then
$       set default HT_ROOT:[SRC]
$       @LINK_ALL 'tcpipAgent'
$!      'f$verify(0)
$       set default 'currentDefault'
$    endif
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ if P1 .eqs. "SSL"
$ then
$    type SYS$INPUT

--- LINK SSL PACKAGE ---

|  Link for SSL version of HTTPd.
|  Link SSLeay applications.
|  This will only work if the SSL package has been installed!
$    say "|  Link SSL executables (using ''tcpipAgent' where appropriate)?"
$    say "|"
$    response = ""
$    read sys$command response /prompt="[No]: "
$    if response
$    then
$       set default HT_ROOT:[SRC.HTTPD]
$       @BUILD_HTTPD LINK 'tcpipAgent' SSL
$!      'f$verify(0)
$       if f$search("HT_ROOT:[SRC]SSLEAY-0_8_1.DIR") .nes. "" -
           then SSLeayDir = "HT_ROOT:[SRC.SSLEAY-0_8_1]"
$       if f$search("HT_ROOT:[SRC]SSLEAY-0_9_0B.DIR") .nes. "" -
           then SSLeayDir = "HT_ROOT:[SRC.SSLEAY-0_9_0B]"
$       set default 'SSLeayDir'
$       @MAKEVMS LINK
$!      'f$verify(0)
$       set default 'currentDefault'
$    endif
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- SERVER QUICK-CHECK ---

|  This executes the package demonstration procedure,
|  allowing the basic package to be evaluated or checked.
|  You may run this at any time to again check the package for
|  basic functionality using @HT_ROOT:[000000]FREEWARE_DEMO.COM
|  Execute the demonstration procedure?
|
$ response = ""
$ read sys$command response /prompt="[No]: "
$ if response
$ then
$    if P1 .eqs. "SSL"
$       then @HT_ROOT:[000000]FREEWARE_DEMO.COM SSL
$       else @HT_ROOT:[000000]FREEWARE_DEMO.COM
$    endif
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ if P1 .eqs. "SSL"
$ then
$    type sys$input

--- SSL UPDATE COMPLETE ---

$    exit
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- CONTINUE UPDATE? ---

$ response = ""
$ read sys$command response /prompt="[No]: "
$ if .not. response
$ then
$    say ""
$    exit
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ if f$search ("HTTPD$MSG") .eqs. ""
$ then
$    type SYS$INPUT

  ********************************************
  *  "HTTPD$MSG" not found and not updated.  *
  *  This logical should be defined!         *
  ********************************************

$ else
$    type SYS$INPUT

--- UPDATE MESSAGE CONFIGURATION FILE ---

|  This version uses the v5.1/v5.2 HTTPD$MSG configuration file.
|  If you are currently using less than v5.1 you will need to update.
|  Update your current version now?
|
$    read sys$command response /prompt="[No]: "
$    if response
$    then
$       say ""
$       copy HT_ROOT:[EXAMPLE]HTTPD$MSG.CONF HT_ROOT:[LOCAL]
$    endif
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ if f$search("HT_ROOT:[000000]UPDATEAFTER.COM") .nes. ""
$ then
$    type sys$input

--- CLEAN UP AFTER PREVIOUS VERSION(S) ---

|  The procedure HT_ROOT:[000000]UPDATEAFTER.COM
|  deletes files from previous versions no longer in use
|  and otherwise cleans up after older versions of WASD.
|  (It is generally fairly conservative, but no guarantees.)
|  Alternatives: Execute the procedure now or later manually.
|  Execute the procedure now?
|
$    read sys$command response /prompt="[No]: "
$    if response
$    then
$       @HT_ROOT:[000000]UPDATEAFTER
$!      'f$verify(0)
$       set default 'currentDefault'
$    endif
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- PURGE OLD FILES ---

|  Performs a purge of the HT_ROOT:[000000] tree, removing replaced versions.
|  Alternatives: Purge now or later manually.
|
$ response = ""
$ read sys$command response /prompt="[No]: "
$ if response
$ then
$    say ""
$    purge HT_ROOT:[000000...]
$ endif
$!
$!-----------------------------------------------------------------------------
$!
$ type sys$input

--- UPDATE COMPLETE ---

$!
$!-----------------------------------------------------------------------------
