#include "think.h"

int selpospiece(int piece, int* outpiece, int* outpos)
{
  int depth,pivpos,pos,pivpiece,piece1,minval,maxval,bestpiece,bestpos;

  if (BOARDSIZE>2*board[NPIECEPOS]) 
    depth=min(2,maxdepth);
  else
    depth=min(maxdepth,BOARDSIZE-board[NPIECEPOS]);
  maxval= -depth*INFINITY; 
  bestpiece= -1; 
  bestpos= -1;

  if (depth==1) {
    for (pivpos=0; pivpos<BOARDSIZE; pivpos++) {
      pos=pivotpos[pivpos];    /* makes computer less predictable */
      if (!(board[pos]&1)) {
	addpiece(piece,pos);
	if (!endgame())
	  if (board[VALPOS]>maxval) {
	    maxval=board[VALPOS];
	    bestpos=pos;
	  }
	removepiece(piece,pos);
      }
    }
    for (pivpiece=0; pivpiece<NPIECES && bestpiece<0; pivpiece++) {
      piece1=pivotpiece[pivpiece];    /* makes computer less predictable */
      if (npiece[piece1]>0 && piece1!=piece)
	bestpiece=piece1;
    }
  } else {
    for (pivpos=0; pivpos<BOARDSIZE; pivpos++) {
      pos=pivotpos[pivpos];    /* makes computer less predictable */
      if (!(board[pos]&1)) {
	addpiece(piece,pos);
	if (!endgame()) 
	  for (pivpiece=0; pivpiece<NPIECES; pivpiece++) {
	    piece1=pivotpiece[pivpiece];    /* makes computer less predictable */
	    if (npiece[piece1]>0) {
	      sppmin(piece1,&minval,maxval,depth-1);
	      if (minval>maxval) {
		maxval=minval;
		bestpiece=piece1;
		bestpos=pos;
	      }
	    }
	  }
	removepiece(piece,pos);
      }
    }
  }
  if (maxval== -depth*INFINITY) return -1;
  *outpiece=bestpiece;
  *outpos=bestpos;
  return 0;
}


static void sppmax(int piece, int* maxval, int refminval, int depth)
{
  int minval,pivpos,pos,pivpiece,piece1;

  *maxval= -depth*INFINITY;
  if (depth==1) {
    for (pivpos=0; pivpos<BOARDSIZE && *maxval<refminval; pivpos++) {
      pos=pivotpos[pivpos];    /* makes computer less predictable */
      if (!(board[pos]&1)) {
	addpiece(piece,pos);
	if (!endgame()) 
	  *maxval=max(*maxval,board[VALPOS]);
	removepiece(piece,pos);
      }
    }
    return;
  }
  for (pivpos=0; pivpos<BOARDSIZE && *maxval<refminval; pivpos++) {
    pos=pivotpos[pivpos];    /* makes computer less predictable */
    if (!(board[pos]&1)) {
      addpiece(piece,pos);
      if (!endgame()) 
	for (pivpiece=0; pivpiece<NPIECES && *maxval<refminval; pivpiece++) {
	  piece1=pivotpiece[pivpiece];    /* makes computer less predictable */
	  if (npiece[piece1]>0) {
	    sppmin(piece1,&minval,*maxval,depth-1);
	    *maxval=max(*maxval,minval);
	  }
	}
      removepiece(piece,pos);
    }
  }
  return;
}



static void sppmin(int piece, int* minval, int refmaxval, int depth)
{
  int maxval,pivpos,pos,pivpiece,piece1;

  *minval=depth*INFINITY;
  if (depth==1) {
    for (pivpos=0; pivpos<BOARDSIZE && *minval>refmaxval; pivpos++) {
      pos=pivotpos[pivpos];    /* makes computer less predictable */
      if (!(board[pos]&1)) {
	addpiece(piece,pos);
	if (!endgame()) 
	  *minval=min(*minval,board[VALPOS]);
	removepiece(piece,pos);
      }
    }
    return;
  }
  for (pivpos=0; pivpos<BOARDSIZE && *minval>refmaxval; pivpos++) {
    pos=pivotpos[pivpos];    /* makes computer less predictable */
    if (!(board[pos]&1)) {
      addpiece(piece,pos);
      if (!endgame()) 
	for (pivpiece=0; pivpiece<NPIECES && *minval>refmaxval; pivpiece++) {
	  piece1=pivotpiece[pivpiece];    /* makes computer less predictable */
	  if (npiece[piece1]>0) {
	    sppmax(piece1,&maxval,*minval,depth-1);
	    *minval=min(*minval,maxval);
	  }
	}
      removepiece(piece,pos);
    }
  }
  return;
}
