#include <stdlib.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#ifndef VMS
#include <X11/xpm.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/Xaw/Box.h>
#include <X11/Xaw/Command.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/MenuButton.h>
#include <X11/Xaw/SimpleMenu.h>
#include <X11/Xaw/SmeBSB.h>
#include <X11/Xaw/SmeLine.h>
#else
#include "xpm.h"
#include <X11Xaw/AsciiText.h>
#include <X11Xaw/Box.h>
#include <X11Xaw/Command.h>
#include <X11Xaw/Form.h>
#include <X11Xaw/MenuButton.h>
#include <X11Xaw/SimpleMenu.h>
#include <X11Xaw/SmeBSB.h>
#include <X11Xaw/SmeLine.h>
#endif

#include "common.h"
#include "xtic.h"

static void InitGame();
static void PieceProc();
static void PosProc();
static void ReadPixmaps();
static void RestartHumanProc();
static void RestartComputerProc();
static void QuitProc();
static void LevelProc();
static void GametypeProc();
static void CreateWidgets();
static void PrepareCallbacks();

XtAppContext  app_cont;
Widget        top;
Widget        topbox;
Widget        menu;
Widget        menubox;
Widget        actions_button,options_button;
Widget        options_line1;
Widget        restart_button_human,restart_button_computer,quit_button;
Widget        level_button[NLEVELS],gametype_button[NGAMETYPES];
Widget        messageform,messagetext;
Widget        posform,pieceform,outpieceform;
Widget        pos[BOARDSIZE],piece[NPIECES],outpiece_command;
Pixmap        piece_normal_pixmap[NPIECES];
Pixmap        piece_highlight_pixmap[NPIECES];
Pixmap        piece_fade_pixmap[NPIECES];
PosPtr*       posp;
PiecePtr*     piecep;
LevelPtr*     levelp;
GametypePtr*  gametypep;
int           outpiece= -1;
int           maxdepth;

int main(int argc,char** argv)
{
  gametype=NORMAL;
  firstplayer=HUMAN;
  maxdepth=3;


/*  XtSetLanguageProc(NULL, NULL, NULL);  */

  top=XtAppInitialize(&app_cont,"xtic",
		      NULL,0,
		      (Cardinal*) &argc,argv,
		      fallback_resources,
		      NULL,0);
/*  top = XtVaOpenApplication(&app_cont, "xtic", NULL, 0, &argc, argv,
			    NULL, sessionShellWidgetClass, NULL);  (X11R6) */
  if (!top) exit(-1);

  CreateWidgets();
  PrepareCallbacks();
  
  XtRealizeWidget(top);
  ReadPixmaps();
  InitGame();
  XtAppMainLoop(app_cont);
  return 0;
}

void CreateWidgets()
{
  int i;

  topbox=XtVaCreateManagedWidget("topbox", boxWidgetClass, top, NULL);
  menubox=XtVaCreateManagedWidget("menubox", boxWidgetClass, topbox, NULL);
  actions_button=XtVaCreateManagedWidget("actions",menuButtonWidgetClass,menubox,NULL);
  menu=XtVaCreatePopupShell("menu",simpleMenuWidgetClass,actions_button,NULL);
  restart_button_human=XtVaCreateManagedWidget("restart_human",smeBSBObjectClass,menu,NULL);
  restart_button_computer=XtVaCreateManagedWidget("restart_computer",smeBSBObjectClass,menu,NULL);
  quit_button=XtVaCreateManagedWidget("quit",smeBSBObjectClass,menu,NULL);
  options_button=XtVaCreateManagedWidget("options",menuButtonWidgetClass,menubox,NULL);
  menu=XtVaCreatePopupShell("menu",simpleMenuWidgetClass,options_button,NULL);
  for (i=0; i<NLEVELS; i++)
    level_button[i]=XtVaCreateManagedWidget(level_name[i],smeBSBObjectClass,menu,NULL);
  options_line1=XtVaCreateManagedWidget("options_line1",smeLineObjectClass,menu,NULL);
  for (i=0; i<NGAMETYPES; i++)
    gametype_button[i]=XtVaCreateManagedWidget(gametype_name[i],smeBSBObjectClass,menu,NULL);
  messageform=XtVaCreateManagedWidget("messageform",formWidgetClass,topbox,NULL);
  messagetext=XtVaCreateManagedWidget("messagetext",asciiTextWidgetClass,messageform,NULL);
  posform=XtVaCreateManagedWidget("posform",formWidgetClass,topbox,NULL);
  pieceform=XtVaCreateManagedWidget("pieceform",formWidgetClass,topbox,NULL);
  outpieceform=XtVaCreateManagedWidget("outpieceform",formWidgetClass,topbox,NULL);
  for (i=0;i<BOARDSIZE;i++)
    pos[i] = XtVaCreateManagedWidget(pos_name[i], commandWidgetClass, posform, NULL);
  for (i=0;i<NPIECES;i++)
    piece[i] = XtVaCreateManagedWidget(piece_name[i],commandWidgetClass,pieceform, NULL);
  outpiece_command=XtVaCreateManagedWidget("outpiece_command",commandWidgetClass,outpieceform, NULL);
}

void PrepareCallbacks()
{  
  int i;

  posp=(PosPtr*)calloc(BOARDSIZE,sizeof(PosPtr));
  piecep=(PiecePtr*)calloc(NPIECES,sizeof(PiecePtr)); 
  levelp=(LevelPtr*)calloc(NLEVELS,sizeof(LevelPtr)); 
  gametypep=(GametypePtr*)calloc(NGAMETYPES,sizeof(GametypePtr)); 
  
  for (i=0; i<BOARDSIZE; i++) {      /* Prepare for argument passing */
    *posp=(PosPtr)calloc(1,sizeof(PosData));
    (*posp)->posno=i;
    (*posp)->outpiece= &outpiece;
    XtAddCallback(pos[i], XtNcallback, PosProc, (XtPointer)(*posp));
    posp++;
  }
  
  for (i=0; i<NPIECES; i++) {       /* Prepare for argument passing */
    *piecep=(PiecePtr)calloc(1,sizeof(PieceData));
    (*piecep)->pieceno=i;
    (*piecep)->outpiece= &outpiece;
    XtAddCallback(piece[i], XtNcallback, PieceProc, (XtPointer)(*piecep));
    piecep++;
  }
  for (i=0; i<NLEVELS; i++) {       /* Prepare for argument passing */
    *levelp=(LevelPtr)calloc(1,sizeof(LevelData));
    (*levelp)->level=i;
    XtAddCallback(level_button[i],XtNcallback,LevelProc,(XtPointer)(*levelp));
    levelp++;
  }
  
  for (i=0; i<NGAMETYPES; i++) {       /* Prepare for argument passing */
    *gametypep=(GametypePtr)calloc(1,sizeof(GametypeData));
    (*gametypep)->gametype=i;
    XtAddCallback(gametype_button[i],XtNcallback,GametypeProc,(XtPointer)(*gametypep));
    gametypep++;
  }
  XtAddCallback(restart_button_human, XtNcallback,RestartHumanProc,(XtPointer)NULL);
  XtAddCallback(restart_button_computer, XtNcallback,RestartComputerProc,(XtPointer)NULL);
  XtAddCallback(quit_button, XtNcallback, QuitProc, (XtPointer)NULL);
}

static void ReadPixmaps()
{
  Display* dpy;
  char *display_name = NULL;
  XpmAttributes xpm_attributes;
  int val,i;

#include "sn.h"  /* Normal pixmaps */
#include "sf.h"  /* Faded pixmaps */
#include "sh.h"  /* Highlighted pixmaps */

  dpy = XOpenDisplay(display_name);
  xpm_attributes.valuemask = XpmSize|XpmReturnPixels|XpmColormap|XpmCloseness;
  xpm_attributes.colormap = XDefaultColormap(dpy,DefaultScreen(dpy));
  xpm_attributes.closeness = 40000;
  for (i=0; i<NPIECES; i++) {
    val=XpmCreatePixmapFromData(XtDisplay(piece[i]),XtWindow(piece[i]),snp_xpm[i],&piece_normal_pixmap[i],NULL,&xpm_attributes);
    val=XpmCreatePixmapFromData(XtDisplay(piece[i]),XtWindow(piece[i]),shp_xpm[i],&piece_highlight_pixmap[i],NULL,&xpm_attributes);
    val=XpmCreatePixmapFromData(XtDisplay(piece[i]),XtWindow(piece[i]),sfp_xpm[i],&piece_fade_pixmap[i],NULL,&xpm_attributes);
  }
  return;
}

static void InitGame()
{
  int i=0,j=0;

  for (i=0; i<BOARDSIZE; i++)   /* initialize board */
    board[i]=0;
  board[NPIECEPOS]=0;
  board[VALPOS]=2*(BOARDLENGTH+1)*NPROPERTIES;

  for (i=0; i<NPIECES; i++)   /* initialize pieces */
    npiece[i]=NPIECE;
  for (i=0; i<2*NPROPERTIES; i++)
    npiece[NPROPPOS+i]=(NPIECE*NPIECES)/2;
  
  srand(time(NULL));          /* generate random pivot position vector */
  for (i=0; i<BOARDSIZE; i++) /* (to make computer less predictable) */
    pivotpos[i]= -1;
  for (i=0; i<BOARDSIZE; ) {
    j=rand()%BOARDSIZE;
    if (pivotpos[j]== -1)
      pivotpos[j]=i++;
  }
                            /* generate random pivot piece vector */
  for (i=0; i<NPIECES; i++) /* (to make computer less predictable) */
    pivotpiece[i]= -1;
  for (i=0; i<NPIECES; ) {
    j=rand()%NPIECES;
    if (pivotpiece[j]== -1)
      pivotpiece[j]=i++;
  }

  for (i=0; i<BOARDSIZE; i++) {
    XtVaSetValues(pos[i],XtNlabel,"",NULL);
    XtVaSetValues(pos[i],XtNbackgroundPixmap,XtUnspecifiedPixmap,NULL);
  }
  for (i=0; i<NPIECES; i++) {
    XtVaSetValues(piece[i],XtNlabel,"",XtNsensitive,True,NULL);
    XtVaSetValues(piece[i],XtNbackgroundPixmap,piece_normal_pixmap[i],NULL);
  }
  XtVaSetValues(outpiece_command,XtNbackgroundPixmap,XtUnspecifiedPixmap,NULL);
  XtVaSetValues(outpiece_command,XtNlabel,"",XtNsensitive,False,NULL);
  for (i=0; i<NLEVELS; i++) {
    if (maxdepth==i+1)
      XtVaSetValues(level_button[i],XtNlabel,chosen_level_label[i],NULL);
    else
      XtVaSetValues(level_button[i],XtNlabel,level_label[i],NULL);
  }
  for (i=0; i<NGAMETYPES; i++) {
    if (gametype==i)
      XtVaSetValues(gametype_button[i],XtNlabel,chosen_gametype_label[i],NULL);
    else
      XtVaSetValues(gametype_button[i],XtNlabel,gametype_label[i],NULL);
  }

  if (firstplayer==HUMAN) {   
    gamestatus=SELPIECE;
    XtVaSetValues(messagetext,XtNstring,"Select a piece.",NULL);
  } else if (firstplayer==COMPUTER) {
    outpiece=pivotpiece[0];
    XtVaSetValues(outpiece_command,XtNbackgroundPixmap,piece_normal_pixmap[outpiece],NULL);
    XtVaSetValues(piece[outpiece],XtNsensitive,False,NULL);
    XtVaSetValues(piece[outpiece],XtNbackgroundPixmap,piece_fade_pixmap[outpiece],NULL);
    gamestatus=SELPOS;
    XtVaSetValues(messagetext,XtNstring,"Select a position.",NULL);
  }    
}

static void PosProc(Widget widget,XtPointer posp,XtPointer call_data)
{
  int inpos=((PosPtr)posp)->posno;
  int* outpiece=((PosPtr)posp)->outpiece;
  long eg;
  int i,j,hipos;

  if (gamestatus!=SELPOS) return;
  if (board[inpos]&1) return;
  XtVaSetValues(pos[inpos],XtNbackgroundPixmap,piece_normal_pixmap[*outpiece],NULL);
  addpiece(*outpiece,inpos);
  XtVaSetValues(outpiece_command,XtNbackgroundPixmap,XtUnspecifiedPixmap,NULL);
  if (eg=endgame()) {
    gamestatus=ENDGAME;
    for (i=0; i<BOARDLENGTH; i++)   /* Check each row */
      if ((eg>>i)&1)
	for (j=0; j<BOARDLENGTH; j++) {
	  hipos=i*BOARDLENGTH+j;
	  XtVaSetValues(pos[hipos],XtNbackgroundPixmap,piece_highlight_pixmap[board[hipos]>>1],NULL);
	}
    for (i=0; i<BOARDLENGTH; i++)   /* Check each col */
      if ((eg>>(i+BOARDLENGTH))&1)
	for (j=0; j<BOARDLENGTH; j++) {
	  hipos=j*BOARDLENGTH+i;
	  XtVaSetValues(pos[hipos],XtNbackgroundPixmap,piece_highlight_pixmap[board[hipos]>>1],NULL);
	}
    for (i=0; i<2*BOARDLENGTH; i++)   /* Check each diag */
      if ((eg>>(i+2*BOARDLENGTH))&1)
	for (j=0; j<BOARDLENGTH; j++) {
	  if (i&1)
	    hipos=j*BOARDLENGTH+((BOARDLENGTH+i/2-j)%BOARDLENGTH);
	  else
	    hipos=j*BOARDLENGTH+((i/2+j)%BOARDLENGTH);
	  XtVaSetValues(pos[hipos],XtNbackgroundPixmap,piece_highlight_pixmap[board[hipos]>>1],NULL);
	}
    
    XtVaSetValues(messagetext,XtNstring,"I win!",NULL);
    return;
  } else if (board[NPIECEPOS]==NPIECES) {
    XtVaSetValues(messagetext,XtNstring,"Draw!",NULL);
    gamestatus=ENDGAME;
    return;
  } else {
    XtVaSetValues(messagetext,XtNstring,"Select a free piece.",NULL);
    gamestatus=SELPIECE;
    return;  
  }
}

static void PieceProc(Widget widget,XtPointer piecep,XtPointer call_data)
{
  int inpiece=((PiecePtr)piecep)->pieceno;
  int* outpiece=((PiecePtr)piecep)->outpiece;
  int i;
  int outpos= -1;

  if (gamestatus!=SELPIECE) return;
  XtVaSetValues(piece[inpiece],XtNsensitive,False,NULL);
  XtVaSetValues(piece[inpiece],XtNbackgroundPixmap,piece_fade_pixmap[inpiece],NULL);
  
/*
  for (i=0; i<NPIECES; i++) 
    XtVaSetValues(piece[i],XtNcursor,XCreateFontCursor(XtDisplay(widget),XC_watch),NULL);
  for (i=0; i<BOARDSIZE; i++) 
    XtVaSetValues(pos[i],XtNcursor,XCreateFontCursor(XtDisplay(widget),XC_watch),NULL); 
  XFlush(XtDisplay(widget));
*/
  if (selpospiece(inpiece,outpiece,&outpos)== -1) {
    XtVaSetValues(messagetext,XtNstring,"You win!",NULL);
    gamestatus=ENDGAME;
    return;
  }
/*
  for (i=0; i<NPIECES; i++) 
    XtVaSetValues(piece[i],XtNcursor,XCreateFontCursor(XtDisplay(widget),XC_top_left_arrow),NULL);
  for (i=0; i<BOARDSIZE; i++) 
    XtVaSetValues(pos[i],XtNcursor,XCreateFontCursor(XtDisplay(widget),XC_top_left_arrow),NULL);
*/
  addpiece(inpiece,outpos);
  XtVaSetValues(pos[outpos],XtNbackgroundPixmap,piece_normal_pixmap[inpiece],NULL);
  if (board[NPIECEPOS]==NPIECES) {
    XtVaSetValues(messagetext,XtNstring,"Draw!",NULL);
    gamestatus=ENDGAME;
    return;
  }
  if (*outpiece>=0 && *outpiece<=NPIECES) {
    XtVaSetValues(outpiece_command,XtNbackgroundPixmap,piece_normal_pixmap[*outpiece],NULL);
    XtVaSetValues(piece[*outpiece],XtNsensitive,False,NULL);
    XtVaSetValues(piece[*outpiece],XtNbackgroundPixmap,piece_fade_pixmap[*outpiece],NULL);
  }
  XtVaSetValues(messagetext,XtNstring,"Select a free position.",NULL);
  gamestatus=SELPOS;
  return;
}

static void RestartHumanProc(Widget widget,XtPointer client_data,XtPointer call_data)
{
  firstplayer=HUMAN;
  InitGame();
}

static void RestartComputerProc(Widget widget,XtPointer client_data,XtPointer call_data)
{
  firstplayer=COMPUTER;
  InitGame();
}

static void QuitProc(Widget widget,XtPointer client_data,XtPointer call_data)
{
  exit(0);
}

static void LevelProc(Widget widget,XtPointer levelp,XtPointer call_data)
{
  int newlevel=((LevelPtr)levelp)->level;
  int i;
  maxdepth=newlevel+1;
  for (i=0; i<NLEVELS; i++) {
    if (maxdepth==i+1)
      XtVaSetValues(level_button[i],XtNlabel,chosen_level_label[i],NULL);
    else
      XtVaSetValues(level_button[i],XtNlabel,level_label[i],NULL);
  }
  return;
}

static void GametypeProc(Widget widget,XtPointer gametypep,XtPointer call_data)
{
  int newgametype=((GametypePtr)gametypep)->gametype;
  int i;
  gametype=newgametype;
  for (i=0; i<NGAMETYPES; i++) {
    if (gametype==i)
      XtVaSetValues(gametype_button[i],XtNlabel,chosen_gametype_label[i],NULL);
    else
      XtVaSetValues(gametype_button[i],XtNlabel,gametype_label[i],NULL);
  }
  InitGame();
  return;
}
