( $ v='f$verify(f$trnlnm("SHARE_VERIFY"))' $! Purpose: J $!	Package a series of files into a multi-part archive, especially encodedI $!	so that it can be mailed across multiple networks without undue damage  $! $! Parameters: $!  	P1 = List of files to scan E $!	P2 = name of share file to generate (will be suffixed by part no.)  $! $! Qualifiers:? $!      /BACKUP			Specify BACKUP as the selection date criteria = $!	/BEFORE[=date]		Specify latest date for file consideration 3 $!	/[NO]COMPRESS[=n]	Try to do compression on files 7 $!	/[NO]CONFIRM		Require confirmation of selected files ; $!	/CREATED		Specify CREATED as the selection date criteria 6 $!	/[NO]DEBUG[=n]		Turn on debugging code [at level n]; $!	/[NO]DIRECTORY		Preserve directory structure in archives * $!	/[NO]EXCLUDE=list	Exclude list of files; $!	/EXPIRED		Specify EXPIRED as the selection date criteria 7 $!	/HELP			Ignore other parameters; display help screen   $!	/[NO]LOG[=n]		Specify logging8 $!	/[NO]LONGLINES		Allow long lines if using later TPU's= $!	/MODIFIED		Specify MODIFIED as the selection date criteria : $!	/[NO]NAME[=ident]	Specify an identifier for the packageJ $!	/[NO]PACKAGE_INDEX[=type] Write part list for file server package files0 $!	/PART_SIZE=NNN		Specify maximum size of parts/ $!	/[NO]SHARE		Request creation of a share file > $!	/SINCE[=date]		Specify earliest date for file consideration< $!	/[NO]SPACE_ENCODE	Specify whether spaces should be quoted6 $!	/[NO]SPLIT[=n]		Process big files in smaller chunks; $!	/TEMPORARY=filename	Specify alternate temporary filename 4 $!	/[NO]VERSION		Preserve version numbers in archive. $!	/WORK[=file]		Specify workfile for TPU code $! $! Environment:  $!	Needs at least VMS 5.0  $! $! Revision History:3 $!	8.0	Andy Harper	September 1992	Extensive rewrite = $!	8.1	Andy Harper	September 1992	Bug fixes following release  $!						&  a few new features ; $!	8.2	Andy Harper	December  1992	New features and bugfixes E $!	8.3	Andy Harper	January   1993  Support for alpha, [000000] bugfix ; $!	8.4	Andy Harper	June      1993  Various new things added > $!	8.5	Andy Harper	May	  1994	Fix bug in unpack space trimming! $!						Fix bug in use of CONVERT # $!						Fix bug with NULL filenames  $!J $! This software is copyright (C) Andy Harper, Kings College London and isG $! supplied free of charge with no warranties expressed or implied. Any L $! problems arising from its use are entirely the responsibility of the userH $! You are free to distribute this software to anyone, provided that all% $! copyright notices remain in place.  $ 
 $! Protection  $ set="set" 
 $ set noon% $ set symbol/scope=(nolocal,noglobal)  $ F $ Facility              = f$parse(f$environment("PROCEDURE"),,,"NAME")( $ em="write sys$error ""%''Facility'"","$ $ SS$_NORMAL            = %X00000001$ $ SS$_ABORT             = %X1000002C# $ status                = SS$_ABORT  $ 9 $ Min_VMS               = "5.0"	! To allow block-IF stuff $ $ IsVAX			= f$getsyi("CPU") .le. 127% $ IsAlpha		= f$getsyi("CPU") .gt. 127 - $ VMS                   = f$getsyi("VERSION") : $ VMSx                  = f$extract(1,f$length(VMS)-1,VMS) $ D $! Check system:  Alpha: Any VMS is OK; VAX: Need at least 'Min_VMS'; $ if (IsAlpha) .or. (VMSx .ges. Min_VMS) then $ goto SYS_ok : $ em "-E-OLD, ", Facility, " not supported on this system"G $ em "-I-REQ, requires at least VMS ", Min_VMS, " on VAX, or any Alpha"  $ goto abort $  $! F $! From here, we can use block-IF stuff as we are on the right version $SYS_ok:! $ Version               = "8.5-1"  $ Max_Share_Length      = 79 $ Def_Part_Size         = 30 $ 2 $ Min_VMS_For_TPU       = "4.4"	! To recognize TPUA $ Min_VMS_For_WorkFile  = "5.2"	! To allow use of /WORK qualifier > $ Min_VMS_For_LongLines = "5.4"	! To allow long records in TPU? $ Max_Line_OldTPU       = 960	! Max line lengths for older TPUs A $ Max_Line_NewTPU       = 65535 ! Max line lengths for newer TPUs  $ G $ Current_Directory     = f$parse(f$environment("DEFAULT"),"[]") - ".;" ? $ Cur_Device            = f$parse(Current_Directory,,,"DEVICE") B $ Cur_Directory         = f$parse(Current_Directory,,,"DIRECTORY") $ 4 $! Define the format for the name of sharefile parts $ format1 = "!AS!#*n-OF-!#ZL"  $ format2 = "!AS!#ZL-OF-!#ZL"  $   $! Set debugging levels/commands5 $ IfDebugRejected   = "if Debugging .ge. 2 then $ em" 5 $ IfDebugShowParams = "if Debugging .ge. 2 then $ em"  $  $! Set logging levels 4 $ IfLogIdent        = "if Logging .ge. 1 then $ em "4 $ IfLogSelected     = "if Logging .ge. 1 then $ em "4 $ IfLogRenameParts  = "if Logging .ge. 1 then $ em "4 $ IfLogPackageIndex = "if Logging .ge. 1 then $ em " $  $! Setup the system defaults  $ gosub Get_Available_Facilities $ gosub Get_Default_Parameters $  $! Set up abort handling  $ on control_y then $ goto abort $  $! Parse parameters  $ gosub Parse_Command_Line $ gosub Break_Out_Options 
 $ if ShowHelp  $   then $     gosub ShowHelp
 $     exit $ endif  $ gosub Break_Out_Parameters $ gosub Check_Parameters $ r $ IfLogIdent "-I-IDENT, ", f$fao("!AS !AS - !3AS, !17%D - !AS",Facility,Version,f$cvtime(,,"WEEKDAY"),0,EmailAddr) $ O $! Write parameters to the parameter file, so the packing code can pick them up  $ gosub Create_Parameter_File  $ if FileCount .eq. 0  $   then) $     em "-E-NOFILES, No files selected."  $     goto abort $ endif P $ IfLogSelected "-I-TOTALCNT, ", f$fao("!8%T, !SL File!%S selected",0,FileCount) $ 8 $ gosub PackFiles			! Go pack the files into the archive< $ gosub Rename_Parts			! Generate part type of ".nnn-of-mmm"B $ gosub Create_Package_Index		! Create the xxx.$PACKAGE index file $  $! Clean up and exit $ status = ss$_normal  $abort: A $ if f$trnlnm("SHARE_PARAMS")  .nes. "" then $ close SHARE_PARAMS B $ if f$trnlnm("SHARE_PACKIDX") .nes. "" then $ close SHARE_PACKIDX: $ if f$search(Tempfile) .nes. "" then $ delete &TempFile;* $ v=f$verify(v) 
 $ exit status  $  $  $! N $! --------------------------------------------------------------------------- $! GET AVAILABLE FACILITIES  $!K $!   Various versions of TPU have additional facilities that can be used to H $!   improve things. Here we determine what facilities are available for $!   use $!N $! --------------------------------------------------------------------------- $Get_Available_Facilities:; $ WorkFileAvailable  = "T"	! TPU recognizes /WORK qualifier ; $ LongLinesAvailable = "T"	! TPU allows records > 960 bytes  $  $! Now check the version $ if IsAlpha then $ return $ ' $ if (VMSx .lts. Min_VMS_For_LongLines)  $   then $      LongLinesAvailable = "F"  $ endif  $ & $ if (VMSx .lts. Min_VMS_For_WorkFile) $   then $      WorkFileAvailable = "F" $ endif  $ return $  $  $! N $! --------------------------------------------------------------------------- $! GET DEFAULT PARAMETERS  $!F $!   Defaults are set by logical names. If no logical exists, then the% $!   built-in system default is used.  $!N $! --------------------------------------------------------------------------- $Get_Default_Parameters:M $! Get parameters from logical names/system; normally these will set defaults = $ Compression=f$edit(f$trnlnm("SHARE_COMPRESS"),      "TRIM") = $ Confirm   = f$edit(f$trnlnm("SHARE_CONFIRM"),       "TRIM") = $ Debugging = f$edit(f$trnlnm("SHARE_DEBUG"),         "TRIM") = $ DirKeep   = f$edit(f$trnlnm("SHARE_DIRECTORY"),     "TRIM") D $ Exclude   = f$edit(f$trnlnm("SHARE_EXCLUDE"),       "TRIM,UPCASE") $ ShowHelp  = "NO"= $ Logging   = f$edit(f$trnlnm("SHARE_LOG"),           "TRIM") = $ LongLines = f$edit(f$trnlnm("SHARE_LONGLINES"),     "TRIM") = $ Name      = f$edit(f$trnlnm("SHARE_NAME"),          "TRIM") = $ PackageIdx= f$edit(f$trnlnm("SHARE_PACKAGE_INDEX"), "TRIM") = $ Part_Size = f$edit(f$trnlnm("SHARE_PART_SIZE"),     "TRIM") = $ Real_Name = f$edit(f$trnlnm("SHARE_REAL_NAME"),     "TRIM") = $ Share     = f$edit(f$trnlnm("SHARE_SHARE"),         "TRIM") = $ SpaceEnc  = f$edit(f$trnlnm("SHARE_SPACE_ENCODE"),  "TRIM") = $ Split     = f$edit(f$trnlnm("SHARE_SPLIT"),         "TRIM") = $ VersKeep  = f$edit(f$trnlnm("SHARE_VERSION"),       "TRIM") = $ TempFile  = f$edit(f$trnlnm("SHARE_TEMP"),          "TRIM") = $ WorkFile  = f$edit(f$trnlnm("SHARE_WORK"),          "TRIM")  $  $ K $! ------------------------------------------------------------------------ 3 $! SET UP THE SHARE FILE IDENT LINE / EMAIL ADDRESS K $! ------------------------------------------------------------------------  $ gosub Get_Email_Address  $ gosub Build_Ident_Line $ K $! ------------------------------------------------------------------------ P $! SET UP THE DEFAULT MAX LINE LENGTH AND MIN TPU VERSIONS ALLOWED FOR UNPACKINGK $! ------------------------------------------------------------------------ K $ Min_VMS_To_Unpack   = Min_VMS_For_TPU	! Default allows any version of TPU N $ Max_TPU_Line_Length = Max_Line_OldTPU ! ... provided we stick to short lines $  $ K $! ------------------------------------------------------------------------ ( $! DEFAULT FILE SELECTION DATES/CRITERIAK $! ------------------------------------------------------------------------ . $ Since    = ""				! Earliest date is anything, $ Before   = ""				! Latest date is anything9 $ Criteria = "RDT"			! Revision (modification) is default  $  $ return $  $  $! N $! --------------------------------------------------------------------------- $! PARSE COMMAND LINE  $!D $!    Parse the parameter list and extract qualifiers and parameters $!N $! --------------------------------------------------------------------------- $Parse_Command_Line:V $ Cmd_Line=f$edit(P1+" "+P2+" "+P3+" "+P4+" "+P5+" "+P6+" "+P7+" "+P8,"TRIM,COMPRESS")	 $ P1 = "" 	 $ P2 = "" 	 $ P3 = "" 	 $ P4 = "" 	 $ P5 = "" 	 $ P6 = "" 	 $ P7 = "" 	 $ P8 = ""  $  $ N=0  $ Qualifiers = ""  $Next_Param: $ if f$length(Cmd_Line) .ne. 0 $   then; $     String = f$extract(0,f$locate(" ",Cmd_Line),Cmd_Line) ( $     Cmd_Line = Cmd_Line - String - " "6 $     Param = f$extract(0,f$locate("/",String),String) $     String = String - Param  $     if Param .nes. ""  $       then $         N=N+1  $         P'N' = Param $     endif & $     qualifiers = qualifiers + String $     goto Next_Param  $ endif  $  $ return $  $  $! N $! --------------------------------------------------------------------------- $! BREAK OUT PARAMETERS  $!6 $!    Check the parameters and break out those we want $!N $! --------------------------------------------------------------------------- $Break_Out_Parameters: $ FileSpec = P1  $ ShareFile= P2  $  $get_filespec:+ $ filespec = f$edit(filespec,"TRIM,UPCASE")  $ if filespec .eqs. "" $   then% $     if f$mode() .nes. "INTERACTIVE"  $       thenG $         em "-E-MISREQPAR, Missing required parameter - list of files"  $         goto abort $     endif Y $     read/end=abort/prompt=".. Enter list of files to be packed : " sys$command filespec  $     goto get_filespec  $ endif  $  $get_share_file:- $ sharefile = f$edit(sharefile,"TRIM,UPCASE")  $ if sharefile .eqs. ""  $   then% $     if f$mode() .nes. "INTERACTIVE"  $       thenP $         em "-E-MISREQPAR, Missing required parameter - output share file name" $         goto abort $     endif Z $     read/end=abort/prompt=".. Enter name of share file         : " sys$command sharefile $     goto get_share_file  $ endif  $  $Check_Output_Dir:  $ if f$parse(sharefile) .eqs. "" $   thenJ $     em "-E-INVOUT, Invalid output file or non-existent output directory" $     goto abort $ endif  $ return $  $  $! N $! --------------------------------------------------------------------------- $! BREAK OUT OPTIONS $!L $!  Scan the qualifier string and set up the various options selected by theH $!  user. Default values for each option should already have been set up* $!  by the get_default_parameters routine. $!  N $! --------------------------------------------------------------------------- $Break_Out_Options:  $ if Qualifiers .nes. "" $   then! $     ThisQual = Qualifiers - "/" = $     ThisQual = f$extract(0,f$locate("/",ThisQual),ThisQual) . $     Qualifiers = Qualifiers - "/" - ThisQual $ @ $   ! First check for negated qualifiers and remember the status' $     if f$locate("NO",ThisQual) .eq. 0  $       then  $         ThisQual=ThisQual-"NO" $         Value="FALSE"  $       else $         Value="TRUE" $     endif  $ D $   ! Extract any equivalence value for parameters which expect them* $     Equiv    = f$element(1,"=",ThisQual)* $     ThisQual = f$element(0,"=",ThisQual) $   $! Detect ambiguous qualifier /B@ $     if f$locate(ThisQual,"B") .eq. 0 then $ goto BOO_AmbigQual $ 
 $! /BACKUPK $     if f$locate(f$extract(0,f$length("BACKUP"),ThisQual),"BACKUP") .eq. 0  $       then3 $         if .not. Value then $ goto BOO_NonNegQual 8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         Criteria = "BDT"  $         goto Break_Out_Options $     endif  $  $! /BEFORE[=date] K $     if f$locate(f$extract(0,f$length("BEFORE"),ThisQual),"BEFORE") .eq. 0  $       then $         Before = "" > $         if Value .and. Equiv .nes. "=" then $ Before = Equiv@ $         if Value .and. Equiv .eqs. "=" then $ Before = "TODAY"  $         goto Break_Out_Options $     endif  $ ! $! Detect ambiguous qualifier /CO A $     if f$locate(ThisQual,"CO") .eq. 0 then $ goto BOO_AmbigQual  $  $! /COMPRESS[=n]O $     if f$locate(f$extract(0,f$length("COMPRESS"),ThisQual),"COMPRESS") .eq. 0  $       then $         Compression = Value I $         if Compression .and. Equiv .nes. "=" then $ Compression = Equiv   $         goto Break_Out_Options $     endif  $  $! /CONFIRM M $     if f$locate(f$extract(0,f$length("CONFIRM"),ThisQual),"CONFIRM") .eq. 0  $       then $         Confirm = Value   $         goto Break_Out_Options $     endif  $  $! /CREATED M $     if f$locate(f$extract(0,f$length("CREATED"),ThisQual),"CREATED") .eq. 0  $       then3 $         if .not. Value then $ goto BOO_NonNegQual 8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         Criteria = "CDT"  $         goto Break_Out_Options $     endif  $   $! Detect ambiguous qualifier /D@ $     if f$locate(ThisQual,"D") .eq. 0 then $ goto BOO_AmbigQual $ 
 $! /DEBUG[=n] I $     if f$locate(f$extract(0,f$length("DEBUG"),ThisQual),"DEBUG") .eq. 0  $       then $         Debugging = Value E $         if Debugging .and. Equiv .nes. "=" then $ Debugging = Equiv   $         goto Break_Out_Options $     endif  $ 
 $! /DIRECTORY Q $     if f$locate(f$extract(0,f$length("DIRECTORY"),ThisQual),"DIRECTORY") .eq. 0  $       then8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         DirKeep = Value   $         goto Break_Out_Options $     endif  $ ! $! Detect ambiguous qualifier /EX A $     if f$locate(ThisQual,"EX") .eq. 0 then $ goto BOO_AmbigQual  $  $! /EXCLUDE M $     if f$locate(f$extract(0,f$length("EXCLUDE"),ThisQual),"EXCLUDE") .eq. 0  $       then $         Exclude = ""? $         if Value .and. Equiv .nes. "=" then $ Exclude = Equiv   $         goto Break_Out_Options $     endif  $  $! /EXPIRED M $     if f$locate(f$extract(0,f$length("EXPIRED"),ThisQual),"EXPIRED") .eq. 0  $       then3 $         if .not. Value then $ goto BOO_NonNegQual 8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         Criteria = "EDT"  $         goto Break_Out_Options $     endif  $  $! /HELPG $     if f$locate(f$extract(0,f$length("HELP"),ThisQual),"HELP") .eq. 0  $       then3 $         if .not. Value then $ goto BOO_NonNegQual 8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         ShowHelp = "YES"  $         goto Break_Out_Options $     endif  $ ! $! Detect ambiguous qualifier /LO A $     if f$locate(ThisQual,"LO") .eq. 0 then $ goto BOO_AmbigQual  $  $! /LOG[=n] E $     if f$locate(f$extract(0,f$length("LOG"),ThisQual),"LOG") .eq. 0  $       then $         Logging = Value ? $         if Logging .and. Equiv .nes. "=" then $ Logging=Equiv   $         goto Break_Out_Options $     endif  $ 
 $! /LONGLINES Q $     if f$locate(f$extract(0,f$length("LONGLINES"),ThisQual),"LONGLINES") .eq. 0  $       then8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         LongLines = Value   $         goto Break_Out_Options $     endif  $  $! /MODIFIEDO $     if f$locate(f$extract(0,f$length("MODIFIED"),ThisQual),"MODIFIED") .eq. 0e $       then3 $         if .not. Value then $ goto BOO_NonNegQual!8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         Criteria = "RDT"  $         goto Break_Out_Options $     endif  $a $! /NAME[=identifier]eG $     if f$locate(f$extract(0,f$length("NAME"),ThisQual),"NAME") .eq. 0	 $       then# $         Name = "="						! /NONAME!A $         if Value .and. Equiv .eqs. "=" then $ Name = ""	! /NAMENG $         if Value .and. Equiv .nes. "=" then $ Name = Equiv	! /NAME=xxc  $         goto Break_Out_Options $     endife $y! $! Detect ambiguous qualifier /PAeA $     if f$locate(ThisQual,"PA") .eq. 0 then $ goto BOO_AmbigQualN $I $! /PACKAGE_INDEXiY $     if f$locate(f$extract(0,f$length("PACKAGE_INDEX"),ThisQual),"PACKAGE_INDEX") .eq. 0e $       then $         PackageIdx = ValueG $         if PackageIdx .and. Equiv .nes. "=" then $ PackageIdx = Equivn  $         goto Break_Out_Options $     endifn $i $! /PART_SIZE=nnnTQ $     if f$locate(f$extract(0,f$length("PART_SIZE"),ThisQual),"PART_SIZE") .eq. 0= $       then3 $         if .not. Value then $ goto BOO_NonNegQual[> $         if equiv .eqs. "=" then $ goto BOO_Qual_Val_Required $         Part_Size = Equiv   $         goto Break_Out_Options $     endifs $e! $! Detect ambiguous qualifier /SPaA $     if f$locate(ThisQual,"SP") .eq. 0 then $ goto BOO_AmbigQuale $r	 $! /SHAREuI $     if f$locate(f$extract(0,f$length("SHARE"),ThisQual),"SHARE") .eq. 0E $       then8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         Share = Value   $         goto Break_Out_Options $     endifo $P $o $! /SINCE[=date]I $     if f$locate(f$extract(0,f$length("SINCE"),ThisQual),"SINCE") .eq. 0a $       then $         Since = ""= $         if Value .and. Equiv .nes. "=" then $ Since = Equivs? $         if Value .and. Equiv .eqs. "=" then $ Since = "TODAY"1  $         goto Break_Out_Options $     endifp $J $! /SPACE_ENCODEW $     if f$locate(f$extract(0,f$length("SPACE_ENCODE"),ThisQual),"SPACE_ENCODE") .eq. 0d $       then8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         SpaceEnc = Value  $         goto Break_Out_Options $     endif  $T $ 
 $! /SPLIT[=n]yI $     if f$locate(f$extract(0,f$length("SPLIT"),ThisQual),"SPLIT") .eq. 0r $       thenF $         if .not. Value                 then $ Split = "0"	! /NOSPLITC $         if Value .and. Equiv .eqs. "=" then $ Split = ""	! /SPLITtJ $         if Value .and. Equiv .nes. "=" then $ Split = Equiv	! /SPLIT=nnn  $         goto Break_Out_Options $     endife $o $! /TEMPORARY=TempfileQ $     if f$locate(f$extract(0,f$length("TEMPORARY"),ThisQual),"TEMPORARY") .eq. 0) $       then3 $         if .not. Value then $ goto BOO_NonNegQual > $         if equiv .eqs. "=" then $ goto BOO_Qual_Val_Required $         TempFile = Equiv  $         goto Break_Out_Options $     endifo $l $! /VERSIONtM $     if f$locate(f$extract(0,f$length("VERSION"),ThisQual),"VERSION") .eq. 02 $       then8 $         if Equiv .nes. "=" then $ goto BOO_QualNoValue $         VersKeep = Value  $         goto Break_Out_Options $     endifS $  $! /WORK[=filename]tG $     if f$locate(f$extract(0,f$length("WORK"),ThisQual),"WORK") .eq. 0  $       then3 $         if .not. Value then $ goto BOO_NonNegQualI> $         if Value .and. Equiv .nes. "=" then $ WorkFile=Equiv; $         if Value .and. Equiv .eqs. "=" then $ WorkFile=""t  $         goto Break_Out_Options $     endif  $s $! Something else ..4 $     em "-E-UNRECQUAL, Invalid qualifier specified"6 $     if .not. Value then $ ThisQual = "NO" + ThisQual* $     write sys$error "  \", ThisQual, "\" $     goto abort $ endifu $ return $i $M $BOO_AmbigQual: 2 $ if .not. value then $ ThisQual = "NO" + ThisQual: $ em "-E-AMBIG, /", ThisQual, " is an ambiguous qualifier" $ goto abort $  $BOO_NonNegQual:@ $ em "-E-NONNEG, /NO", ThisQual, " is not a negatable qualifier" $ goto abort $T $BOO_QualNoValue: D $ em "-E-NOTREQ, ", ThisQual, " does not take a value specification" $ goto abort $  $BOO_Qual_Val_Required:r? $ em "-E-VALREQ, ", Thisqual, " requires a value specification"i $ goto abort $t $  $!#N $! --------------------------------------------------------------------------- $! SHOW HELP) $!	Display a usage summary of the utility  $! $!N $! ---------------------------------------------------------------------------
 $ShowHelp: $ type/nopage sys$input1 VMS_SHARE -- Usage Summary  ;              VMS_SHARE input_files output_file [qualifiers]i  : Input_files:	Comma separated list of wildcarded file specsJ Output file:	Template file name for archive; will be suffixed by -nn-of-mm   Qualifiers:    Selection:K      /BACKUP  /CREATED  /EXPIRED  /MODIFIED	Which date to use for selectiont@      /SINCE[=date]      /BEFORE[=date]		Date range specification%      /EXCLUDE=list				File exclusionsh   Workfiles:"      /TEMPORARY=name    /WORK=name   Archive Options:L      /[NO]COMPRESS[=n]  /[NO]DIRECTORY        /[NO]VERSION    /[NO]LONGLINESH      /[NO]NAME[=ident]  /PACKAGE_INDEX[=type] /PART_SIZE=nn   /[NO]SHARE$      /[NO]SPACE_ENCODE  /[NO]VERSION   Miscellaneous:C      /[NO]CONFIRM       /[NO]LOG[=n]          /[NO]DEBUG[=n]  /HELPF   $ Return $  $  $!nN $! --------------------------------------------------------------------------- $! CHECK PARAMETERST $!G $!   Check that the user supplied parameters have reasonable values and	8 $!   give errors if not. In some cases, set up defaults. $!N $! --------------------------------------------------------------------------- $Check_Parameters:3 $! CONVERT VARIOUS FLAGS TO SUITABLE INTEGER VALUES N $! FALSE becomes numeric 0, TRUE becomes numeric 1; if integer, use that value% $ Compression= f$integer(Compression) # $ Debugging  = f$integer(Debugging)a! $ Logging    = f$integer(Logging)eF $ if DirKeep  .eqs. "" then $ DirKeep  = "T"	! Default is to keep them! $ Dirkeep    = f$integer(DirKeep)-G $ if Share    .eqs. "" then $ Share    = "T"	! Default is to write themV $ Share      = f$integer(Share)iJ $ if SpaceEnc .eqs. "" then $ SpaceEnc = "T"	! Default is to encode spaces" $ SpaceEnc   = f$integer(SpaceEnc)F $ if Verskeep .eqs. "" then $ Verskeep = "T"	! Default is to keep them" $ VersKeep   = f$integer(VersKeep) $c $t$ $! CHECK THE PART SIZE SPECIFICATION8 $ if Part_Size .eqs. "" then $ Part_Size = Def_Part_Size& $ if f$type(Part_Size) .nes. "INTEGER" $   then2 $     em "-E-NONNUMSIZE, Part size is not numeric" $     goto abort $ endifL $ if Part_Size .le. 0  $   then; $     em "-E-NONPOSSIZE, Part size is not a positive value"W $     goto abort $ endifW $F $AO $! CHECK THE SPLIT VALUE, SET A DEFAULT TO A FUNCTION OF WSEXTENT AND PART SIZE- $ if Split .eqs. ""- $   thenC $    ! We deduct two lots of parts as we generally keep 2 in memory 4 $     Split = f$getjpi("","WSQUOTA") - (2*Part_Size)F $     if Split .lt. 1000 then $ Split = 1000	! Use respectable minimum $ endif- $ Split      = f$integer(Split)- $  $tD $! CHECK THE LONG LINES OPTION; ONLY ALLOWED IF THIS VMS SUPPORTS IT $ if LongLines $   then! $     if .not. LongLinesAvailable( $       thenW $         em "-E-NOLONG, Long lines not supported prior to VMS ", Min_VMS_For_LongLinesu $         goto abort $     endifG+ $     Max_TPU_Line_Length = Max_Line_NewTPUt1 $     Min_VMS_To_Unpack   = Min_VMS_For_LongLines  $ endiff $n $( $! MASSAGE THE SHARE FILE NAME8 $ ShareFile = ShareFile - f$parse(ShareFile,,,"VERSION")* $ if f$parse(ShareFile,,,"TYPE") .nes. "." $   then ! non-null extensionL! $     ShareFile = ShareFile + "_" H $   else ! null extension OR a single dot extension; force to single dot? $     if f$extract(f$length(ShareFile)-1,1,ShareFile) .nes. "."n $       then% $         ShareFile = ShareFile + "."$ $     endif( $ endifA $  $)3 $! CHECK THE TEMPORARY FILE/DIRECTORY SPECIFICATIONS $ if f$parse(TempFile) .eqs. ""E $   thenD $     em "-E-INVTEMP, Invalid temporary file spec - '", TempFile,"'" $     goto abort $ endif  $TK $ TempFile = f$parse(TempFile,"SYS$SCRATCH:SHARE_TEMP."+f$getjpi("","PID"))p5 $ TempFile = TempFile - f$parse(TempFile,,,"VERSION")  $  $k $! WORKFILE CHECKING $ if WorkFile .nes. "" $   then $ $ $  ! DO WE ALLOW A WORKFILE SPEC ???  $     if .not. WorkFileAvailable $       thenN $         em "-E-WORKNOTSUP, Workfile specification not supported on this VMS" $         goto abort $     endif- $-0 $  ! CHECK THE WORK FILE/DIRECTORY SPECIFICATION# $     if f$parse(WorkFile) .eqs. ""- $       thenD $         em "-E-INVWORK, Invalid work file spec - '", WorkFile, "'" $         goto abort $     endifL$ $     WorkFile = "/WORK=" + WorkFile $ endif- $- $-/ $! CHECK THE PACKAGE INDEX SUFFIX SPECIFICATIONM( $ if f$extract(0,1,PackageIdx) .nes. "." $   then $     if PackageIdxaK $       then PackageIdx = ".$PACKAGE"	! Set default suffix for "TRUE" value ? $       else PackageIdx = ""		! Set no suffix for "FALSE" value- $     endif- $   else6 $     if f$parse(PackageIdx,,,"TYPE") .nes. PackageIdx $       thenY $         em "-E-INVSUFFIX, Invalid package index file suffix specification ", PackageIdx  $         goto abort $     endif  $ endif  $r $r3 $! SET UP THE DEFAULT ARCHIVE NAME (FROM /NAME=XXX) = $ if Name .eqs. ""  then $ Name = f$parse(ShareFile,,,"NAME")-$ $ if Name .eqs. "=" then $ Name = "" $  $PK $! WE ALLOW DEBUGGING ONLY FOR SYSTEMS PEOPLE, WITH EITHER SYSPRV OR SETPRV ; $! AUTHORIZED (DOESN'T HAVE TO BE ENABLED, JUST AUTHORIZED)- $ x = f$getjpi("","AUTHPRIV")- $ l = f$length(x)dW $ if f$locate("SYSPRV",x) .eq. l .and. f$locate("SETPRV",x) .eq. l then $ Debugging = 0E $) $ ? $! CHECK COMPRESSION VALUE IS WITHIN LIMITS CURRENTLY SUPPORTED"0 $ if Compression .lt. 0  .or. Compression .gt. 2 $   then4 $     em "-E-UNSUPCOM, Unsupported compression type" $     goto abort $ endif0 $l $t% $! CHECK THE SPLIT SIZE SPECIFICATIONi" $ if f$type(Split) .nes. "INTEGER" $   then3 $     em "-E-NONNUMSIZE, Split size is not numeric"= $     goto abort $ endifP $ if Split .le. 0  $   then< $     em "-E-NONPOSSIZE, Split size is not a positive value" $     goto abort $ endift $g $ - $! CHECK THE BEFORE/SINCE DATE SPECIFICATIONS  $ if Before .nes. "" $   then, $     Before = f$cvtime(Before,"COMPARISON") $     if .not. $status $       thenD $         em "-E-INVTIME, Bad /BEFORE time specification - ", Before $         goto abort $     endif- $ endif- $ if Since .nes. ""- $   then+ $     Since  = f$cvtime(Since,"COMPARISON")r $     if .not. $status $       thenB $         em "-E-INVTIME, Bad /SINCE time specification - ", Since $         goto abort $     endifR $ endif  $  $ L $! CONFIRMATION OF EACH FILE SELECTED IS ONLY AVAILABLE IF INTERACTIVE AS WE! $! CAN'T PROMPT ANYONE OTHERWISE. / $ if Confirm .and. f$mode() .nes. "INTERACTIVE"i $   then= $      em "-w-CONFNOTINT, /CONFIRM ignored - not interactive"n $      Confirm = "FALSE" $ endiff $ return $s $!iN $! --------------------------------------------------------------------------- $! GET EMAIL ADDRESS $!O $!    Determine the network name of the system by translating the logical namesmN $!    known to exist under the various network packages. The first one we findH $!    will be appended to the username to form the local e-mail address. $!M $!    If the logical name SHARE_EMAIL_ADDRESS exist, then this is used as the J $!    e-mail address and no attempt is made to determine automatically the $!    e-mail address.i $!N $! --------------------------------------------------------------------------- $Get_Email_Address:-> $ username  = f$edit(f$getjpi("","USERNAME"),"TRIM,LOWERCASE")- $ emailaddr = f$trnlnm("SHARE_EMAIL_ADDRESS")s% $ if emailaddr .nes. "" then $ returnl $lC $! Try each of the known network packages in turn until we find one!? $ sitename = f$trnlnm("MX_NODE_NAME","LNM$SYSTEM")		! MX mailer- $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitename  $     return $ endif  $/I $ sitename = f$trnlnm("PONY$LOCAL_HOST_NAME","LNM$SYSTEM")	! Pony expressu $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitenamef $     return $ endift $sE $ sitename = f$trnlnm("INTERNET_HOST_NAME","LNM$SYSTEM")	! CMU TCP/IPs $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitenameU $     return $ endif  $ J $ sitename = f$trnlnm("MULTINET_HOST_NAME","LNM$SYSTEM")	! Multinet TCP/IP $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitename  $     return $ endifl $e; $ sitename = f$trnlnm("INET$HOST_NAME","LNM$SYSTEM")		! UCXA $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitenameQ: $     sitename = f$trnlnm("INET$DOMAIN_NAME","LNM$SYSTEM")F $     if sitename .nes. "" then emailaddr = emailaddr + "." + sitename $     return $ endif  $ E $ sitename = f$trnlnm("ARPANET_HOST_NAME","LNM$SYSTEM")		! Wollongong! $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitenameE: $     sitename = f$trnlnm("INET_DOMAIN_NAME","LNM$SYSTEM")F $     if sitename .nes. "" then emailaddr = emailaddr + "." + sitename $     return $ endif" $tH $ sitename = f$trnlnm("TCPWARE_SMTP_FROM_DOMAIN","LNM$SYSTEM")	! TCPware $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitenameh $     return $ endif  $ B $ sitename = f$trnlnm("TCPWARE_DOMAINNAME","LNM$SYSTEM")	! TCPware $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitename  $     return $ endifn $nD $ sitename = f$trnlnm("UUCP_DOMAIN_NAME","LNM$SYSTEM")		! DECUS UUCP $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitenameg $     return $ endif, $N8 $ sitename = f$trnlnm("FTP$CONTEXT","LNM$SYSTEM")		! CBS $ if sitename .nes. "" $   then+ $     emailaddr = username + "@" + sitenamec $     return $ endifh $R( $! Can't work out the e-mail address !!! $ return $  $  $!.N $! --------------------------------------------------------------------------- $! BUILD IDENT LINE  $!I $!    This routine builds the originator ident line that is placed at theDL $!    head of the generated archive file. There are several formats for this. $!    line depending on available information. $!L $!    If the logical SHARE_IDENT exist, its translation is used as the ident $!    line.g $!L $!    If the email address is available, then the ident line is generated inH $!    one of these two formats, dependent on whether the SHARE_REAL_NAME1 $!    logical translates to the user's real name:h $!$ $!	1.		Real Name <username@sitename> $!	2.		username@sitename $!M $!    If the email address is not available, then the ident line is generatedOK $!    as one of these two formats, dependent on whether the SHARE_REAL_NAMEl1 $!    logical translates to the user's real name:a $! $!	3.		username (Real Name)l $!	4.		username, $!N $! --------------------------------------------------------------------------- $Build_Ident_Line:% $ IdentLine = f$trnlnm("SHARE_IDENT") % $ if IdentLine .nes. "" then $ returno $ ( $ RealName = f$trnlnm("SHARE_REAL_NAME") $ if Realname .nes. "" $   then $     if emailaddr .nes. ""q $       then7 $         IdentLine = RealName + " <" + EmailAddr + ">"  $       else8 $         IdentLine = UserName + " ( " + RealName + " )" $     endif" $   else $     if emailaddr .nes. ""  $       then $         IdentLine = EmailAddrr $       else $         IdentLine = Username $     endifh $ endif  $ return $V $e $! N $! --------------------------------------------------------------------------- $! CREATE PARAMETER FILE $!P $!   Write a file containing all the parameters, options and filenames which the& $!   Packing routine needs to process. $!N $! --------------------------------------------------------------------------- $Create_Parameter_File:L $ create &TempFile) $ if .not. $status then $ goto CPF_error1 5 $ open/append/error=CPF_error2 SHARE_PARAMS &TempFile . $ write/error=CPF_error2 SHARE_PARAMS FacilityB $ IfDebugShowParams "-I-DBGPARAM, Facility           = ", Facility- $ write/error=CPF_error2 SHARE_PARAMS VersionhA $ IfDebugShowParams "-I-DBGPARAM, Version            = ", Version 7 $ write/error=CPF_error2 SHARE_PARAMS Min_VMS_to_Unpack K $ IfDebugShowParams "-I-DBGPARAM, Min_VMS_To_Unpack  = ", Min_VMS_To_UnpackI9 $ write/error=CPF_error2 SHARE_PARAMS Max_TPU_Line_Length M $ IfDebugShowParams "-I-DBGPARAM, Max_TPU_Line_Length= ", Max_TPU_Line_Length 6 $ write/error=CPF_error2 SHARE_PARAMS Max_Share_LengthJ $ IfDebugShowParams "-I-DBGPARAM, Max_Share_Length   = ", Max_Share_Length/ $ write/error=CPF_error2 SHARE_PARAMS Debugging)C $ IfDebugShowParams "-I-DBGPARAM, Debugging          = ", Debugging - $ write/error=CPF_error2 SHARE_PARAMS Logging A $ IfDebugShowParams "-I-DBGPARAM, Logging            = ", Logging / $ write/error=CPF_error2 SHARE_PARAMS Part_SizetC $ IfDebugShowParams "-I-DBGPARAM, Part_Size          = ", Part_Size 1 $ write/error=CPF_error2 SHARE_PARAMS CompressionmE $ IfDebugShowParams "-I-DBGPARAM, Compression        = ", Compressionh- $ write/error=CPF_error2 SHARE_PARAMS DirKeepqA $ IfDebugShowParams "-I-DBGPARAM, DirKeep            = ", DirKeepa. $ write/error=CPF_error2 SHARE_PARAMS VersKeepB $ IfDebugShowParams "-I-DBGPARAM, VersKeep           = ", VersKeep/ $ write/error=CPF_error2 SHARE_PARAMS IdentLinehC $ IfDebugShowParams "-I-DBGPARAM, IdentLine          = ", IdentLine / $ write/error=CPF_error2 SHARE_PARAMS ShareFile C $ IfDebugShowParams "-I-DBGPARAM, ShareFile          = ", ShareFilea+ $ write/error=CPF_error2 SHARE_PARAMS Sharet? $ IfDebugShowParams "-I-DBGPARAM, Share              = ", Share . $ write/error=CPF_error2 SHARE_PARAMS SpaceEncB $ IfDebugShowParams "-I-DBGPARAM, Space Encoding     = ", SpaceEnc+ $ write/error=CPF_error2 SHARE_PARAMS Split ? $ IfDebugShowParams "-I-DBGPARAM, Split              = ", Split * $ write/error=CPF_error2 SHARE_PARAMS Name> $ IfDebugShowParams "-I-DBGPARAM, Name               = ", Name $c $ FileCount = 0$< $ gosub Scan_For_Files			! Scan directory for matching files $ close SHARE_PARAMS $ return $e $n $CPF_error1:1 $ em "-E-CPFCRE, Unable to create parameter file". $ goto abort $CPF_error2:? $ em "-E-CPFAPP, Unable to append parameters to parameter file"  $ goto abort $  $  $!fN $! --------------------------------------------------------------------------- $! SCAN FOR FILES  $!M $!   Scan the file system for the files specified for the user; then add them ? $!   if required into the parameter list of files to be packed.y $!N $! --------------------------------------------------------------------------- $Scan_For_Files: $Next_File_Spec: $ if filespec .nes. "" $   then- $     pattern     = f$element(0,",",filespec)", $     filespec    = filespec - pattern - ","/ $     File_Device = f$parse(pattern,,,"DEVICE")  $L= $   ! Make sure the syntax of the pattern is a legal filespec/ $     if File_Device .eqs. ""l $       thenA $         em "-E-BADFILE, Bad file specification '", pattern, "'"h $         goto abort $     endif  $o $   ! Action the filespec...3 $     if DirKeep .and. File_Device .nes. Cur_Device  $       thenU $         em "-E-NOTCURDEV, Skipped ", pattern, " : does not refer to current device"f $       else4 $         fileversion = f$parse(pattern,,,"VERSION")K $         searchstring= f$parse(pattern-fileversion,"[]")-";" + fileversion  $         Previous_File = "" $         gosub DoPattern  $     endif  $     goto Next_File_Spec  $ endifl $ return $c $, $DoPattern:K $ File = f$search(searchstring)  $ if File .eqs. "" $   then2 $     em "-W-NOMATCH, No files matching ", pattern $     return $ endift $  $ProcessNextFile:  $ gosub Check_Out_File $ Previous_File = File $ File = f$search(searchstring)OL $ if File .nes. "" .and File .nes. Previous_File then $ goto ProcessNextFile $ return $! N $! --------------------------------------------------------------------------- $! CHECK OUT FILEi $!K $!   Given the latest filename that matches the user's filespec, examine it.I $!   to see if it's a candidate for selection. If it is, record its name, : $!   checksum and record attributes in the parameter file. $! $!   Files are rejected if they, $!      - Are directoriesf $!	- Are not sequential filesaD $!	- Fall outside the range of dates specified by /BEFORE and /SINCE6 $!	- Match one of the exclusion clauses (/EXCLUDE etc)D $!	- Are not in the directory tree starting at the current directory. $!	  (unless the /NODIRECTORY option is given) $!	- Resemble a sharefile part, $!	- Have an unsupported record type or size5 $!	- If they are not confirmed by the user (/CONFIRM)- $!N $! --------------------------------------------------------------------------- $Check_Out_File:0 $! Get the elements of the filename that we need- $ File_Dir      = f$parse(File,,,"DIRECTORY") ( $ File_Name     = f$parse(File,,,"NAME")) $ File_Type     = f$parse(File,,,"TYPE") e+ $ File_Version  = f$parse(File,,,"VERSION")-' $ File_Filename = File_Name + File_TypeA $P $ SubFile       = File $F $	K $! ------------------------------------------------------------------------e $! Ignore directories alwaysK $! ------------------------------------------------------------------------a $ if File_Type .eqs. ".DIR"/ $   thenF $     IfDebugRejected "-I-REJDIR, Skipped ", File, " : is a directory" $     return $ endifI $X $yK $! ------------------------------------------------------------------------l2 $! We can only deal with files that are SEQUENTIALK $! -------------------------------------------------------------------------. $ if f$file_attributes(File,"ORG") .nes. "SEQ" $   then@ $     em "-W-NOTSEQ, Skipped ", File, " : not a SEQUENTIAL file" $     return $ endife $n $ K $! -------------------------------------------------------------------------E $! Scan the exclusions list element by element to find any that matchPI $! this one. An `*' Wildcard may be used to represent a complete field ofbJ $! the file, such as the directory, filename, type, or version. It may not8 $! be used to represent a partial field of any of these.K $! ------------------------------------------------------------------------  $ if Exclude .nes. ""u $   then	 $     N=0  $   Exclude_Loop:g) $     Epattern = f$element(N,",",Exclude)  $     if Epattern .nes. ","o $       then $h2 $         p = f$parse(Epattern,"[*]",,"DIRECTORY")6 $         xdir  = p .eqs. "[*]"  .or. p .eqs. File_Dir+ $         p = f$parse(Epattern,"*",,"NAME")e7 $         xname = p .eqs. "*"    .or. p .eqs. File_Namem, $         p = f$parse(Epattern,".*",,"TYPE")7 $         xtype = p .eqs. ".*"   .or. p .eqs. File_Type./ $         p = f$parse(Epattern,";*",,"VERSION")(: $         xvers = p .eqs. ";*"   .or. p .eqs. File_Version5 $         if xdir .and. xname .and. xtype .and. xversL $           then[ $             ifDebugRejected "-I-REJEXC, Skipped ", File, " : matches /EXCLUDE=", Epatterno $             return $         endifT $L $         N=N+1  $         goto Exclude_Loop  $     endif  $ endif. $. $-K $! ------------------------------------------------------------------------rM $! Date based file selection; Before/Since dates already in COMPARISON format0K $! ------------------------------------------------------------------------i5 $ Date = f$cvtime(f$file(File,Criteria),"COMPARISON") , $ if Before .nes. "" .and. Date .ges. Before $   then` $     IfDebugRejected "-I-REJBEF, Skipped ", File, " : ", Criteria, " date not /BEFORE=", Before $     return $ endif", $ if Since  .nes. "" .and. Date .lts. Since  $  thenn^ $     IfDebugRejected "-I-REJAFT, Skipped ", File, " : ", Criteria, " date not /AFTER=", After $    returni $ endif( $! $SK $! ------------------------------------------------------------------------IK $! If the /DIRECTORY option has been specified, Ensure that the file existsoI $! at or below the current directory tree. This prevents random top levellA $! directories being created when the share file is unpacked. Theh' $! subdirectory structure is preserved.  $!F $! If current directory is the MFD ([000000]) then we should allow anyI $! underlying directory on the same device, otherwise we just allow a subFM $! directory of the current one. In either case, convert it to a subdirectory"	 $! format"K $! ------------------------------------------------------------------------H $ if DirKeep $   then $P: $     Subfile  = SubFile - File_Device	! Strip device name $ A $    ! Massage directory name into a suitable subdirectory format ' $     if Cur_Directory .eqs. "[000000]"  $       then4 $       ! Convert [000000.xxx] and [xxx] into [.xxx]V $         if f$locate("[000000]",SubFile) .eq. 0 then $ SubFile = SubFile - "[000000]"U $         if f$locate("[000000.",SubFile) .eq. 0 then $ SubFile = SubFile - "000000" qU $         if f$extract(0,1,SubFile) .eqs. "[" .and. f$extract(0,2,SubFile) .nes. "[."" $           then. $             SubFile = "[." + (SubFile - "[") $         endifi $       elseI $       ! Strip off the leading current directory to leave a subdirectoryd7 $         if f$locate(Cur_Directory-"]",SubFile) .ne. 0n $           thenQ $             em "-W-NOTINTREE, Skipped ", SubFile, " : not a valid subdirectory"  $             return $         endifi9 $         SubFile = "[" + (SubFile - (Cur_Directory-"]"))a $     endif A $     SubFile = SubFile - "[]"	! Don't need a null directory specf $ endiff $t $ K $! ------------------------------------------------------------------------U $! Get file's record attributes/K $! ------------------------------------------------------------------------ " $ Gosub Get_File_Record_Attributes! $ if (Attributes .eqs. "UNKNOWN")F $   thenk $      em "-W-RFMNOTSUP, Skipped ", Subfile, " : Unsupported record format (RFM=''rfmmode',RAT=''ratmode')"$
 $      returnP $ endif  $ & $ if (Recsiz .ge. Max_TPU_Line_Length) $   then} $      em "-W-RECTOOBIG, Skipped ", Subfile, " : Max Record size of ''Recsiz' exceeds system limit of ''Max_TPU_Line_Length'" 
 $      returnn $ endif. $  $p $sK $! ------------------------------------------------------------------------ N $! Get file checksum; note that the CHECKSUM command is currently undocumentedK $! ------------------------------------------------------------------------s $ define/user sys$output nl: $ define/user sys$error  nl: $ checksum &File $ if .not. $status $   thenJ $     em "-W-RECFMTERR, ", Subfile, " : Record format cannot be processed" $     return $ endifI $A $NK $! ------------------------------------------------------------------------NE $! If the user has requested it, confirm this selection interactively K $! ------------------------------------------------------------------------  $ if Confirm $   thenW $     read /end=NotConfirmed /prompt="Select ''Subfile' ? (Y/N) [N] " sys$command reply " $     if .not. reply then $ return $ endifE $m $pK $! ------------------------------------------------------------------------  $! Log this file as selectedK $! ------------------------------------------------------------------------IC $ IfLogSelected     "-I-SELECTED, ", f$fao("!8%T, !AS", 0, SubFile) N $ IfDebugShowParams "-I-DBGPARAM, ", SubFile, ", Attributes='", Attributes,"'" $" $ K $! -------------------------------------------------------------------------9 $! All checks passed; add new entry to the parameter file K $! ------------------------------------------------------------------------ N $ write SHARE_PARAMS SubFile, " ", CheckSum$CheckSum, " ", """''Attributes'""" $ FileCount = FileCount + 1  $NotConfirmed: $ return $m $  $!sN $! --------------------------------------------------------------------------- $! GET FILE RECORD ATTRIBUTESd $!J $!   The file record attributes are returned, in a form that can be passedJ $!   directly to CONVERT/FDL, so that the record structure of the selected# $!   file can be re-instated later.  $!L $!   TPU, used to encode files, always writes files out in a variable lengthH $!   format with carriage return controls.  If this is the format of theG $!   original file no conversion is needed so we return null attributest $!O $!   A return type of "UNKNOWN" indicates a record type that we do not support.  $!H $!   The record size of a file is also returned so that it can be testedL $!   against the maximum record size supported by this TPU. We can thereforeH $!   reject files with records that are too long early on in the packing
 $!   process.n $!N $! --------------------------------------------------------------------------- $Get_File_Record_Attributes:@ $ rfmmode = f$file_attributes(File,"RFM")	! Get file information) $ recsiz  = f$file_attributes(File,"MRS")O) $ ratmode = f$file_attributes(File,"RAT") ) $ fsz     = f$file_attributes(File,"FSZ")a $ + $! Convert the record format to an FDL spec  $ Format  = ""= $ if rfmmode .eqs. "STMLF" then $ Format = "FORMAT STREAM_LF"s= $ if rfmmode .eqs. "STMCR" then $ Format = "FORMAT STREAM_CR"s: $ if rfmmode .eqs. "STM"   then $ Format = "FORMAT STREAM"F $ if rfmmode .eqs. "FIX"   then $ Format = "FORMAT FIX;SIZE ''recsiz'"< $ if rfmmode .eqs. "VAR"   then $ Format = "FORMAT VARIABLE"L $ if rfmmode .eqs. "VFC"   then $ Format = "FORMAT VFC;CONTROL_FIELD ''fsz'" $ / $! Convert the record attributes to an FDL spec  $ Attributes = ""nD $ if ratmode .eqs. ""    then $ Attributes = "CARRIAGE_CONTROL NONE"O $ if ratmode .eqs. "CR"  then $ Attributes = "CARRIAGE_CONTROL CARRIAGE_RETURN"tE $ if ratmode .eqs. "PRN" then $ Attributes = "CARRIAGE_CONTROL PRINT" G $ if ratmode .eqs. "FTN" then $ Attributes = "CARRIAGE_CONTROL FORTRAN"e $n@ $! Check for unsupported formats; return an unknown FDL if found- $ if Format .eqs. "" .or. Attributes .eqs. ""h $   then $     Attributes = "UNKNOWN" $     return $ endif  $nA $! Return the complete FDL spec; special case the standard format 1 $ if rfmmode .eqs. "VAR" .and. ratmode .eqs. "CR"  $   then $ Attributes = ""1 $   else $ Attributes = Format + ";" + Attributes= $ endif( $ return $, $    S $!	N $! --------------------------------------------------------------------------- $! RENAME PARTSu $!L $!   This routine renames the parts generated by the packing routine so thatK $!   the names have the format   xxx.nnn-OF-mmm. We need to know in advance-" $!   how many parts are generated. $!N $! --------------------------------------------------------------------------- $Rename_Parts: $ if .not. Share then $ return6 $! Get the number of parts written by the packing code2 $ open/read/error=RP_Error1 SHARE_PARAMS &TempFile* $ read/end=RP_Error2 SHARE_PARAMS NumParts $ close SHARE_PARAMS $eM $! OK, make sure that we read a sensible number of parts (in case tpu failed)e% $ if f$type(NumParts) .nes. "INTEGER"e $   thenF $     em "-F-NUMPTSNOTINT, TPU has returned a non integer part count!" $     goto abort $ endif> $ if NumParts .le. 0 $   thenH $     em "-F-NUMPTSNOTPOS, TPU has returned a negative/zero part count!" $     goto abort $ endif  $   $ NumParts = f$integer(NumParts)  $ L=f$length(f$string(NumParts)) $l $! Rename the partsab $ IfLogRenameParts f$fao("-I-RENAMING, !8%T, Renaming parts to "+format1,0,ShareFile,L,L,NumParts) $- $ N = 0-	 $RP_Loop:-	 $ N = N+1- $ if N .le. NumParts $   then7 $     NewPart = f$fao(format2,ShareFile,L,N,L,NumParts)", $     if f$search(ShareFile+"''N'") .eqs. ""> $       then $ em "-E-MISSPART, Unable to find ", ShareFile, N. $       else $ rename 'ShareFile''N' 'NewPart' $     endife $     goto RP_Loop $ endif  $ return $  $RP_Error1:L6 $ em "-F-RPOPEN, Unable to open return parameter file" $ goto abort $RP_Error2:rF $ em "-F-RPREAD, Unable to read part count from return parameter file" $ goto abort $L $! N $! --------------------------------------------------------------------------- $! CREATE PACKAGE INDEX- $!E $!   If selected, we create the package index file suitable for usingfG $!   with a file server that recognizes package files. The package filePE $!   takes its name from the sharefile, with a suffix selected by the-! $!   user (default = ".$PACKAGE")- $!N $! --------------------------------------------------------------------------- $Create_Package_Index:; $ if (PackageIdx .eqs. "") .or. (.not. Share) then $ return= $_C $! Create the package index - remove type field, add package suffixi+ $ l = f$length(f$parse(ShareFile,,,"TYPE"))_G $ PackIndex = f$extract(0,f$length(ShareFile)-l,ShareFile) + PackageIdx X $ IfLogPackageIndex f$fao("-I-CREINDEX, !8%T, Creating package index !AS", 0, PackIndex) $o" $ l = f$length(f$string(NumParts))6 $ open/write/error=CPI_error1 SHARE_PACKIDX &PackIndex $ N=0R $RP_PKIND_LOOP:L $ N=N+1  $ if N .le. NumParts $   then7 $     NewPart = f$fao(format2,ShareFile,L,N,L,NumParts)o^ $     write/error=CPI_error2 SHARE_PACKIDX f$parse(NewPart,,,"NAME"),f$parse(NewPart,,,"TYPE") $     goto RP_PKIND_LOOP $ endifo $ close SHARE_PACKIDXM $ return $  $f	 $! ERRORSr $CPI_Error1:8 $ em "-F-RPPACKCRE, Unable to create package index file" $ goto abort $CPI_Error2:F $ em "-F-RPPACKWRITE, Unable to write part name to package index file" $ goto abort $r $2 $!EN $! ---------------------------------------------------------------------------
 $! PACK FILESt $!L $!   This routine processes the parameter list in file "TempFile", packs theG $!   files specified and produces the multiple parts of the share file.  $!N $! --------------------------------------------------------------------------- $PackFiles:rK $ edit/tpu/nodisplay/nosection/com=sys$input/nojournal'WorkFile'  &TempFile M ! ---------------------------------------------------------------------------oM ! +                                                                         +oM ! +                 O V E R V I E W   O F   V M S _ S H A R E               + M ! +                                                                         +rM ! +                                                                         +EM ! +         To package a series of files into a format that can be          +cM ! +         successfully mailed through most networks without damage.       +PM ! +                                                                         +eM ! +         Characters prone to translation by mailers/networks are         +nM ! +         encoded into a form that will (hopefully) not be altered        +HM ! +         but we cannot recover if they ARE altered despite the           +aM ! +         encoding. A checksum is included so we can at least detect      +aM ! +         corruption.                                                     +-M ! +                                                                         +!M ! +         Files are packaged into a single self-unpacking share file      + M ! +         which is split into multiple parts, each small enough to be     +-M ! +         mailed out without truncation (the part size is configurable)   +oM ! +                                                                         + M ! +                                                                         + M ! +   Version 8.5                Andy Harper                      Jun 1994  + M ! +                                                                         + M ! +                                                                         +oM ! +                                                                         +.M ! +                        R E S T R I C T I O N S                          +eM ! +                                                                         +iM ! +         1. This version does not support the UDF (undefined record)     +rM ! +            format. All other record formats are supported although only + M ! +            the carriage control record attribute is preserved.          + M ! +                                                                         + M ! +         2. Text files are fully supported. Binary files should be       +tM ! +            supported because all non-printing characters are encoded    +eM ! +            to a printable escape sequence. However, it is advisable to  +eM ! +            stick to plain text files where possible.                    +-M ! +                                                                         +eM ! +         3. Because the files are intended to be mailed, the encoding    +iM ! +            relies on the integrity of the underlying mailer and network.+eM ! +            If files are corrupted, we are unable to recover.            +!M ! +                                                                         + M ! +                                                                         + M ! +                            C R E D I T S                                +eM ! +                                                                         +hM ! +         All due credit must go to the following people:                 +tM ! +                                                                         +-M ! +         1.   James Gray for the first version of VMS_SHARE              +fM ! +         2.   Michael Bednarek for the original idea and prototype       +iM ! +                                                                         +eM ! +         Credits are also due to the various people who have submitted   +iM ! +         ideas and code fragments for some of the features of VMS_SHARE  +-M ! +         including the following for major features:                     +-M ! +                                                                         +lM ! +              Mark Pizzolato, for run-length encoding and attributes     +lM ! +              Dick Munroe, for better part name conventions              +-M ! +              Joe Meadows, for various useful updates                    +fM ! +              Wolfgang Moeller, for directory/version stripping          +-M ! +                                                                         +nM ! +-------------------------------------------------------------------------+n  H ! ---------------------------------------------------------------------- ! INITIALIZE GLOBAL CONSTANTS  !l= !     Initialisation routine to set up global constant values  !. !   Globals: !	MANY!				See coder !n !   Inputs:f !	NONE !! !   Outputs: !	NONE !r !   Function Return Value: !	NONE !m !   Side Effects:t !	NONE ! H ! ----------------------------------------------------------------------  $ PROCEDURE InitializeGlobalConstants; LOCAL Ascii_Code;u  @  FAC_unpack          := "UNPACK";	! Facility name of unpack code  F ! Various Logging levels - activate if 'Logging' is at least this highC  LOG_ShowProgress    := 4;	! Log progress of compression - every 3%s:  LOG_ShowNewpart     := 3;	! Log creation of each new partA  LOG_ShowStats       := 2;	! Log statistics of buffer compressione?  LOG_ShowNumparts    := 1;	! Log number of parts written at endtK  LOG_ShowSplit       := 1;	! Log records if preliminary splitting is active"9  LOG_ShowFile        := 1;	! Log filename being processede  F ! Various DEBUG levels - activate if `Debugging' is at least this highE  DEBUG_PackTPU       := 4;	! Shows TPU unpacking code being generatedFB  DEBUG_ShowTrailing  := 4;	! Shows data on trailing blank handlingI  DEBUG_ShowProgress  := 4;	! Shows progress through file as records added J  DEBUG_ShowRecords   := 4;	! Shows records being added to the part buffer =  DEBUG_ShowKeep      := 3;	! Shows keep together flag changese<  DEBUG_ShowBuffersize:= 3;	! Display buffer size computation@  DEBUG_ShowSplit     := 3;	! Show buffer sizes during getsegmentF  DEBUG_PartSplit     := 3;	! Shows sizes of buffers prior to splittingE  DEBUG_AddToPrologue := 2;	! Shows files added to share file prologue,J  DEBUG_Resources     := 1;	! Shows marks/ranges deleted when buffer reused   ! Various COMPRESS techniques ?  COMPRESS_LZW_Complex:= 3;	! Lempel-Ziv-Welch Compression; full K  COMPRESS_LZW_Simple := 2;	! Lempel-Ziv-Welch Compression; within same line 0  COMPRESS_RunLength  := 1;	! Run-length encoding3  COMPRESS_None       := 0;	! No special compressionO  I ! Define separator flags and associated variables, used to separate partse*  Part_Begin         := "-+-+-+-+-+-+-+-+";*  Part_End           := "+-+-+-+-+-+-+-+-";  & ! Define separator lines for user dataG  FAO_Start_Part     := Part_Begin + " START OF PART !UL " + Part_Begin;ME  FAO_End_Part       := Part_End   + "  END  OF PART !UL " + Part_End;s  5 ! Define separator lines for DCL portions of the codeo#  FAO_start_label    := "$PART!UL:";nQ  FAO_end_goto       := "$ GOTO PART!UL";	! Format strings for DCL part separators-   ! Constants-C  MaxHexEnc          := 255;	! Max number encodeable in 2 hex digitseF  EOL                := 3;	! Record length overhead in file, per recordE  FakeEOL_Flag       := "~";	! Used during lzw searches to cross lines0  Initial_Flag       := "X";   Continuation_Flag  := "V";]#  TPU_separators     := "[](),=;>*";[  " ! Flags to mark encoded charactersB  RL_Flag            := "&";	! Flag for run length encoding "&nnhh"@  QU_Flag            := "`";	! Flag for quoted chars        "`hh"B  LZ_Flag            := "\";	! Flag for LZW coded substrings"\bbll"  A ! Set up the ascii code string and the quotable characters string   Quoteable_Chars    := "";  Ascii_Code         := 0;d  LOOPr    EXITIF Ascii_Code > 255;i5      IF (Ascii_Code < 32) OR (Ascii_Code >= 127) THENlR        Quoteable_Chars := Quoteable_Chars + ASCII(Ascii_Code)	! Ones to be escaped      ENDIF; "      Ascii_Code := Ascii_Code + 1;	  ENDLOOP;     H ! Extra printable characters that get munged; treat them as non-printingN  Quoteable_Chars := Quoteable_Chars + "[]^{|}~" + QU_Flag + RL_Flag + LZ_Flag;  " ! Abbreviations to save time later  QuotedBlank        := "`20";-+  QuotedBlankLen     := LENGTH(QuotedBlank);u
 ENDPROCEDURE;- -H ! ---------------------------------------------------------------------- ! CREATE GLOBAL BUFFERS  !fJ !    Part of the Initialisation sequence; creates all the internal buffers !    needed by the program !r
 !    Globals:'9 !	ParamFile	Name of the file containing all the paramters 7 !	ParamBuff	A Buffer into which the parameters are read 1 !	PartBuffer	A Buffer used for building up a parti0 !	Part1Buffer	A Buffer that holds the first part# !	WorkBuffer	General Purpose bufferi6 !	KeptRecords	Special Buffer for non-splittable chunks? !	KeepTogether	Flag to [not] keep records together in same partt ! H ! ---------------------------------------------------------------------- PROCEDURE CreateGlobalBuffers-  5    ParamFile   := GET_INFO(COMMAND_LINE,"FILE_NAME");e5    ParamBuff   := CREATE_BUFFER("{info}", ParamFile);t*    PartBuffer  := CREATE_BUFFER("{part}");,    Part1Buffer := CREATE_BUFFER("{part_1}");*    WorkBuffer  := CREATE_BUFFER("{work}");  1    KeptRecords := CREATE_BUFFER("{keptrecords}");-6    KeepTogether:= 0;		! Start in `ok to separate' mode   ENDPROCEDURE    H ! ---------------------------------------------------------------------- ! FETCH PACKAGING OPTIONS  !hH !     Part of the initialisation sequence; reads in the parameter bufferD !     and extracts the options contained within it. Should leave the= !     buffer containing only the filenames to be be packaged.- !-H ! ---------------------------------------------------------------------- PROCEDURE FetchPackagingOptions-      POSITION(ParamBuff);e  %    Facility            := ERASE_LINE; %    Version_Number      := ERASE_LINE;B%    Min_VMS             := ERASE_LINE;t*    Max_TPU_Line_Length := INT(ERASE_LINE);*    Max_Share_Length    := INT(ERASE_LINE);*    Debugging           := INT(ERASE_LINE);*    Logging             := INT(ERASE_LINE);*    PartSize            := INT(ERASE_LINE);*    Compression         := INT(ERASE_LINE);*    DirKeep             := INT(ERASE_LINE);*    VersKeep            := INT(ERASE_LINE);%    IdentHeader         := ERASE_LINE;-%    Share_File          := ERASE_LINE;-*    Share               := INT(ERASE_LINE);*    SpaceEnc            := INT(ERASE_LINE);*    Split               := INT(ERASE_LINE);%    Archive             := ERASE_LINE;T   ENDPROCEDURE       sH ! +--------------------------------------------------------------------+H ! +                                                                    +H ! +          G E N E R A L   U T I L I T Y   R O U T I N E S           +H ! +                                                                    +H ! +   This section provides a number of miscellaneous simple routines  +H ! +   to assist in the general packing code.                           +H ! +                                                                    +H ! +   Version 8.5           Andy Harper                  Jun 1994      +H ! +                                                                    +H ! +                                                                    +H ! +                                                                    +H ! +                  R O U T I N E   S U M M A R Y                     +H ! +                                                                    +H ! +   Inform      General messages and information a la VMS format     +H ! +                                                                    +H ! +   BufferSIze  Determine size of a buffer, incl ends of lines       +H ! +                                                                    +H ! +   ReuseBuffer Empty a specified buffer and position to it          +H ! +                                                                    +H ! +   StripFile   Parse the file name and remove unwanted bits         +H ! +                                                                    +H ! +--------------------------------------------------------------------+  H ! ---------------------------------------------------------------------- ! INFORM !.L !   Issue a message in standard VMS syntax. The current time is added to the !   text part of the message.w !D !   Globals:. !	Facility			The facility name of this utility !h !   Inputs:r+ !	Xsev				The severity code for the messagen+ !	Xident				The message identification codes" !	Xtext				The text of the message !q !   Outputs: !	NONE !q !   Function Return Value: !	NONE !  !   Side Effects:  !	Message written to the user  !iH ! ----------------------------------------------------------------------  # PROCEDURE Inform(Xsev,Xident,Xtext)!M   MESSAGE( FAO("%!AS-!AS-!AS, !8%T, !AS", Facility, Xsev, Xident, 0, Xtext) )g
 ENDPROCEDURE;t !H ! ----------------------------------------------------------------------
 ! BUFFER SIZE  !tJ !   Returns the number of bytes in a buffer, taking end of line charactersG !   into account. This is important because the LENGTH built-in ignores ; !   end of lines but the built-in MOVE_HORIZONTAL does not.n !a !   Globals: !	NONE !A !   Inputs:e) !	Abuffer			Buffer whose size is requireds !  !   Outputs: !	NONE !! !   Function Return Value: !	Distance between the pointsc !  !   Side Effects:f !	NONE !rH ! ----------------------------------------------------------------------   PROCEDURE BufferSize(Abuffer)  LOCAL B, Records;i      B := LENGTH( Abuffer );/    Records := GET_INFO(Abuffer,"RECORD_COUNT"); '    IF Debugging >= DEBUG_ShowBufferSizea	      THENiD        Inform("D","BUFFSIZE",FAO("Bytes=!SL, Lines=!SL",B,Records));	    ENDIF;!  H ! B + Records added together equates to the buffer length including LF's    RETURN(  B + Records );   ENDPROCEDURE  H ! ---------------------------------------------------------------------- ! REUSE BUFFER !tG !   This routine re-initializes a particular buffer for use by emptying"" !   it and then positioning to it. !eP !   As a safety precaution, to prevent excessive memory usage, all known markersL !   and ranges within the buffer are removed. Hopefully, they will have beenI !   properly removed when used so this is a bit of defensive programming!" !R !   Globals: !	NONE !t !   Inputs:e# !	Xbuffer				The buffer to be resetL !! !   Outputs:B !	Xbuffer                         The reset buffer (done in place) !! !   Function Return Value: !	NONE !e !   Side Effects:  !	NONE !eH ! ----------------------------------------------------------------------   PROCEDURE ReuseBuffer(Xbuffer) LOCAL m,mcount,r,rcount;      ERASE(Xbuffer);    POSITION(Xbuffer);u  K   ! Delete all markers in the buffer, to free the memory resources consumed-    mcount := 0;-+    m := GET_INFO(Xbuffer,"FIRST_MARKER");  (    LOOPx      EXITIF m=0;      DELETE(m);$      mcount :=mcount+1;h*      m := GET_INFO(Xbuffer,"NEXT_MARKER");    ENDLOOP;   J   ! Delete all ranges in the buffer, to free the memory resources consumed    rcount := 0;h*    r := GET_INFO(Xbuffer,"FIRST_RANGE");      LOOP-      EXITIF r=0;      DELETE(r);d      rcount :=rcount+1;o)      r := GET_INFO(Xbuffer,"NEXT_RANGE");n    ENDLOOP;C  ,   ! If debugging, then show what was deleted"    IF Debugging >= DEBUG_Resources	      THEN `        Inform("D","DELTRSRC",FAO("Deleted resources- !SL mark!%S, !SL range!%S",mcount,rcount));	    ENDIF;f  
 ENDPROCEDURE;"   )H ! ---------------------------------------------------------------------- ! STRIP FILE !eH !   This routine implements the optional stripping of directory name andF !   version number from the name stored in the archive file. NOTE thatL !   specifying the keyword DIRECTORY to FILE_PARSE has to be avoided as thisH !   returns the FULL directory spec, not the relative spec that we want. !- !   Globals:3 !	DirKeep				Flag to specify [No] keep of directoryi1 !	VersKeep			Flag to specify [No] keep of versioni !a !   Inputs:h" !	File				Filename to be converted !! !   Outputs: !	NONE !- !   Function Return Value: !	Converted file name- !  !   Side Effects:t !	NONE !lH ! ----------------------------------------------------------------------   PROCEDURE StripFile(File);  %   CASE 2*DirKeep+Verskeep FROM 0 TO 3 B     [0]: File := FILE_PARSE(File,"","",NAME,TYPE);		! /NODIR/NOVERG     [1]: File := FILE_PARSE(File,"","",NAME,TYPE,VERSION);	! /NODIR/VER E     [2]: File := File - FILE_PARSE(File,"","",VERSION);		! /DIR/NOVER      [3]:;							! /DIR/VERu     [OUTRANGE]: Inform("F","BADDIRVER", FAO("StripFile: Bad strip value- DIR=!SL,VERS=!SL",DirKeep,VersKeep)); ABORT; 
   ENDCASE;     RETURN(File); 
 ENDPROCEDURE;c fH ! +--------------------------------------------------------------------+H ! +                                                                    +H ! +           P A R T   S P L I T T I N G   R O U T I N E S            +H ! +                                                                    +H ! +   The share file is constrained to be of a maximum fixed size so   +H ! +   that it can pass unscathed through mailers that truncate long    +H ! +   messages.  These routines deal with splitting the share file     +H ! +   into smaller manageable parts, each of which may be mailed       +H ! +   without corruption.                                              +H ! +                                                                    +H ! +                                                                    +H ! +   8.5                  Andy Harper                       Jun 1994  +H ! +                                                                    +H ! +                                                                    +H ! +                                                                    +H ! +                                                                    +H ! +                   R O U T I N E   S U M M A R Y                    +H ! +                                                                    +H ! +                                                                    +H ! +   InitializePartBuffer                                             +H ! +               Initialize the part buffer for a brand new part      +H ! +                                                                    +H ! +   WritePart   Routine to write a buffer to disk (to specified part)+H ! +                                                                    +H ! +   FlushPart   If the part buffer contains data, flush it to disk   +H ! +               and update the Part Number.                          +H ! +                                                                    +H ! +   CheckPartOverflow                                                +H ! +               See if the part buffer is about to fill up           +H ! +                                                                    +H ! +   AddRecordToPart                                                  +H ! +               Add a record to the part and update size counts      +H ! +                                                                    +H ! +   TerminatePart                                                    +H ! +               Determine the best part separator flags to use; add  +H ! +               them to the part buffer and remaining data, then     +H ! +               empty the part buffer                                +H ! +                                                                    +H ! +   AddBufferToPart                                                  += ! +		  Add a buffer of info to the part but don't split it  + H ! +                                                                    +H ! +   PutRecord   Add a single record to the part buffer, force split  +H ! +               if necessary.                                        +H ! +                                                                    +H ! +   SetKeepTogether                                                  +H ! +               Specify if permissable to separate records by part   +H ! +               split                                                +H ! +                                                                    +H ! +   GetSegment                                                       +H ! +               Locate the buffer segment fitting the start line and +H ! +               size in bytes.                                       +H ! +                                                                    +H ! +   FixupFirstPart                                                   +H ! +               alter info in part 1 based on total part count       +H ! +                                                                    +H ! +   LogTotalParts                                                    +H ! +               Write out part count to user and to file             +H ! +                                                                    +H ! +--------------------------------------------------------------------+0                                                H ! ---------------------------------------------------------------------- ! INITIALIZE PART BUFFER !mG !   Initialize the part buffer; empty it and reset the various counterst1 !   that keep track of how much data it contains.p !r !   Globals:/ !	PartBuffer		Buffer in which new part is builtg7 !	PartBufferRecordCount	Size of part buffer, in recordsL; !	PartBufferDiskBytes	Size of part buffer, in bytes on disk  !!H ! ----------------------------------------------------------------------   PROCEDURE InitializePartBuffer      ReUseBuffer( PartBuffer );;  8    PartBufferRecordCount := 0;		! Records in part bufferF    PartBufferDiskBytes   := 0;		! Number of bytes when written to disk   ENDPROCEDURE cH ! ---------------------------------------------------------------------- ! WRITE PART !i= !   Write the part buffer to disk as the given sharefile part  !o !   Globals:2 !	Share				Flag to indicate [Dont] write sharefile. !	Share_File			Leading part of share file name !S !   Inputs:e( !	APartBuffer			The buffer to be written% !	Part				The part number of the part  !B !   Outputs: !	NONE !S !   Function Return Value: !	NONE !B !   Side Effects: ! !	The specified buffer is clearedo !lH ! ----------------------------------------------------------------------  % PROCEDURE WritePart(APartBuffer,Part)m LOCAL f,r,b;  5 ! Trap any errors writing to a file (disk quota etc.)     ON_ERRORZ?      Inform("E","FILWRERR", "Error writing part to file " + f);Z      ABORT;;    ENDON_ERROR;c      f := Share_File+STR(Part);    ! Log this part, if requestedl     IF Logging >= Log_ShowNewpart	      THENN1        r := GET_INFO(APartBuffer,"RECORD_COUNT");a$        b := BufferSize(APartBuffer);        IF Share_
          THEN=S            Inform("I","WRITPART",FAO("Writing !AS, records !SL, bytes !SL",f,r,b));r
          ELSE W            Inform("I","NOWRIPRT",FAO("!AS Not written, records !SL, bytes !SL",f,r,b));P
        ENDIF;r	    ENDIF;         P ! Write out the buffer    IF Sharep	      THENs!        WRITE_FILE(APartBuffer,f);O	    ENDIF;l
 ENDPROCEDURE;L nH ! ---------------------------------------------------------------------- ! FLUSH PART !oI !   If the part buffer is not empty, update the part number and flush itstC !   contents to disk. Treat part 1 especially as we need to do someeE !   final massaging of its contents, so save it in a separate buffer.i !0 !   Globals:, !	PartBuffer			The part buffer to be flushed- !	Part1Buffer			Buffer holding the first partg& !	PartNo				Number of the current part !  !   Inputs:	 !	NONE !r !   Outputs: !	NONE !" !   Function Return Value: !	NONE !r !   Side Effects: @ !	The contents of the Part1Buffer may be modified; or a new file !	may be written to disk.c !cH ! ----------------------------------------------------------------------   PROCEDURE FlushPart=  ,   IF GET_INFO(PartBuffer,"RECORD_COUNT") > 0	      THENC         PartNo := PartNo + 1;)         IF PartNo = 1e=            THEN POSITION(Part1Buffer); MOVE_TEXT(PartBuffer);p-            ELSE WritePart(PartBuffer,PartNo);          ENDIF;   ENDIF;     InitializePartBuffer;a  
 ENDPROCEDURE;a hH ! ---------------------------------------------------------------------- ! ADD RECORD TO PART ! L !    Add a complete record to the part buffer, making sure that the previous! !    one was properly terminated.u !N
 !    Globals:-& !	PartBuffer		The buffer to be updated7 !	PartBufferRecordCount	Size of part buffer, in recordsR; !	PartBufferDiskBytes	Size of part buffer, in bytes on disk  !  !    Inputs: !	s			The record to be added !r
 !    Outputs:' !	NONE !l !    Function Return Value:  !	NONE !aH ! ----------------------------------------------------------------------   PROCEDURE AddRecordToPart(s)  5  ! Add the record, making sure we start on a new linea    POSITION(PartBuffer);1    IF CURRENT_OFFSET <> 0 THEN SPLIT_LINE; ENDIF;n    COPY_TEXT(s);  /  ! Update the relevant sizes of the part bufferr6    PartBufferRecordCount := PartBufferRecordCount + 1;D    PartBufferDiskBytes   := PartBufferDiskBytes   + LENGTH(s) + EOL;   ENDPROCEDURE  H ! ---------------------------------------------------------------------- ! TERMINATE PART ! I !    Takes steps necessary to terminate the existing part properly, write{! !    it out and start a new part.E !FG !    The type of part separator is determined by looking at the data inKH !    the buffer immediately following the break point. If it starts withG !    '$' then we are splitting the buffer at the DCL code which is part I !    of the unpacking control thus we can use $GOTO and a label.  If not,aJ !    then we are in the midst of user data and should use the special flag !    lines.a !t !    Global Variables: !	PartNo				Current Part numbera4 !	FAO_end_goto			Format of a part terminator for DCL2 !	FAO_start_label			Format of a part begin for DCl5 !	FAO_end_part			Format of a part terminator for datat2 !	FAO_start_part			Format of a part begin for data !  !    Inputs:5 !	NewRec				The next record to be added to the buffer_ !g
 !    Outputs:_ !	NONE !M !    Side Effects:0 !	The part buffer is flushed and re-initialized. !SH ! ----------------------------------------------------------------------   PROCEDURE TerminatePart(NewRec)i! LOCAl EndPartText, StartPartText;D  D  ! Work out the type of part separator to use. If next record startsH  ! with a '$' sign, then it's DCL and we can insert goto; otherwise it's)  ! data and we use the special flag lines      IF (SUBSTR(NewRec,1,1) = "$")9       THEN			! Executable DCL code insert GOTO/label pairR6          EndPartText   := FAO(FAO_end_goto, PartNo+2);9          StartPartText := FAO(FAO_start_label, PartNo+2);-8       ELSE			! User data, insert recognizable separators6          EndPartText   := FAO(FAO_end_part, PartNo+1);8          StartPartText := FAO(FAO_start_part, PartNo+2);    ENDIF;             D ! Add the end of part marker and flush the part (debug if requested)$    IF Debugging >= DEBUG_ShowRecords	      THENp+        Inform("D","PARTENDM", EndPartText);l	    ENDIF;d     AddRecordToPart(EndPartText);
    FlushPart;     3 ! Add the start of part marker (debug if requested) $    IF Debugging >= DEBUG_ShowRecords	      THEN -        Inform("D","PARTSTRT", StartPartText); 	    ENDIF; "    AddRecordToPart(StartPartText);  
 ENDPROCEDURE;   H ! ---------------------------------------------------------------------- ! CHECK PART OVERFLOW  ! @ !    Check if the part buffer would overflow given more data and !    start a new part if so. ! 
 !    Globals: & !	PartBuffer			The current part buffer3 !	PartBufferDiskBytes		Disk size of the part bufferd !f !    Inputs: !	R				Next Record to be added/ !       SizeData			Size of the data to be added  ! 
 !    Outputs:f !	NONE !e !    Function Return Value:e !	NONE !s !    Side Effects:  !	Part buffer may be flushed out ! H ! ----------------------------------------------------------------------' PROCEDURE CheckPartOverflow(R,SizeData)   E   ! if the size of the data is such that it will not fit in the space G   ! remaining in the part buffer, flush that buffer and start a new one 0     IF PartBufferDiskBytes + SizeData > MaxBytes
       THEN         TerminatePart(R);-
     ENDIF;   ENDPROCEDURE -H ! ---------------------------------------------------------------------- ! ADD BUFFER TO PART !.J !    This routine takes a buffer of information and adds it to the currentJ !    part buffer, taking care to keep all the information together and not !    split across two parts. ! @ !    It's an error of the buffer will not fit without splitting! !h !    Globals:	' !	PartBuffer			The buffer to be updatede! !	MaxBytes			Maximum size of part  !	PartNo				Current Part Number	 !EH ! ----------------------------------------------------------------------  . PROCEDURE AddBufferToPart(ABuffer,ABufferSize) LOCAL BufferLines;  G ! Get the linecount of the buffer and update the buffer size to reflecta5 ! its size on disk (add the overhead for each record) 2   BufferLines := GET_INFO(ABuffer,"RECORD_COUNT");3   AbufferSize := AbufferSize + BufferLines*(EOL-1);     H ! If the buffer size is bigger than the size of a single part, we cannot( ! continue because it must not be split.   IF ABufferSize >= MaxBytes     THENp       Inform("F","PARTOOSMA", "Part size too small; increase to " + STR((ABufferSizeSize+511)/512) + " Blocks");       ABORT;   ENDIF;   ! Check part overflowu"   POSITION(BEGINNING_OF(ABuffer));.   CheckPartOverflow(CURRENT_LINE,AbufferSize);  9 ! Finally, copy the specified buffer into the Part Buffer-   POSITION(PartBuffer);D0   IF CURRENT_OFFSET <> 0 THEN SPLIT_LINE; ENDIF;   MOVE_TEXT(ABuffer);;  $ ! Update the Part Buffer size counts=   PartBufferDiskBytes   := PartBufferDiskBytes + ABufferSize;i?   PartBufferRecordCount := PartBufferRecordCount + BufferLines;d   ENDPROCEDURE  H ! ---------------------------------------------------------------------- ! PUT RECORD? !	Place a completed record into the part buffer, starting a new-A !	part if necessary. If the `keepTogether' flag is specified, addh/ !       records to the alternate buffer instead  ! 
 !	Globals:6 !		KeepTogether		Flag to not start new part at present0 !		OutputRecords		Count of records output so far, !		OutputBytes		Count of bytes output so far< !		PartBufferDiskBytes	Approximate size in disk bytes so far, !		MaxBytes		Max. bytes when written to disk !p !	Input Variables: !		s			The record to be addedu !e !	Output Variables:f !		NONE  !e !	Function Return value: !		NONE  !  !	Side Effects:h; !		The existing buffer may be flushed out to disk and a new: !		one started.  !eH ! ----------------------------------------------------------------------   PROCEDURE PutRecord(s) LOCAL RecLen,DiskRecLen;  9 ! So how long is the record, allowing for disk overhead ?T    DiskRecLen := LENGTH(s) + EOL;    N ! If this record must be kept together with previous ones, then save it in the ! alternate buffer."   IF KeepTogether <> 0     THEN  &     ! Add record to the special bufferM       IF Debugging >= DEBUG_ShowRecords THEN Inform("D","KEPTRCRD",s); ENDIF;        POSITION(KeptRecords);4       IF CURRENT_OFFSET <> 0 THEN SPLIT_LINE; ENDIF;       COPY_TEXT(s);O       ELSE  "     ! Check for part size overflow&       CheckPartOverFlow(s,DiskRecLen);  7     ! Add the record and, if requested, trace the eventDM       IF Debugging >= DEBUG_ShowRecords THEN Inform("D","NEWRECRD",s); ENDIF;G       AddRecordToPart(s);        ENDIF;  = ! Update counters of amount of data generated by current fileu-   OutputRecords         := OutputRecords + 1;)4   OutputBytes           := OutputBytes + DiskRecLen;   ENDPROCEDURE -H ! ---------------------------------------------------------------------- ! SET KEEP TOGETHER  !eI !    Certain records must be kept together in the same part (E.G. the TPUfE !    file decoding stuff, any continued DCL lines). This routine sets E !    a flag to specify whether subsequent items must be kept together- ! 
 !    Globals:i, !	KeepTogether		The flag denoting what to do< !	KeptRecords		The buffer to accumlate records kept together !n !    Inputs:' !       KT			New setting of global flagp' !				(1=keep together,0=ok to separate)u ! 
 !    Outputs:e !	NONE !  !    Function Return Value:l !	NONE !- !    Side Effects:A !	A special buffer (KeptRecords) is used to hold the records thati> !	must be kept together. Once the flag indicates that it is OK= !	to separate things again, this buffer is then added to the l* !       current part as a complete entity. !!H ! ----------------------------------------------------------------------   PROCEDURE SetKeepTogether(KT)R  " ! If nothing's changed, do nothing+    IF KT = KeepTogether THEN RETURN; ENDIF;!   ! Save the new setting    KeepTogether := KT;  4 ! Deal with the consequences of changing the setting    IF KeepTogether = 0	      THEN-  F      ! Ok to separate again; Flush accumulated records to current partZ        IF Debugging >= DEBUG_ShowKeep THEN Inform("D","KEEPSEPR", "Keep separate"); ENDIF;=        AddBufferToPart(KeptRecords, BufferSize(KeptRecords));   	      ELSE   A      ! Must keep together now; Prepare to accumulate more records Z        IF Debugging >= DEBUG_ShowKeep THEN Inform("D","KEEPTGHR", "Keep together"); ENDIF;         ReUseBuffer(KeptRecords);  	    ENDIF;h   ENDPROCEDURE  H ! ----------------------------------------------------------------------
 ! GET SEGMENTp !nG !    This routine finds the segment of a buffer within certain size and  !    positioning constraints.  ! 
 !    Globals:  !	NONE !  !    Inputs:0 !	Xbuffer		The name of the buffer to be examined9 !	Segment		The segment number (for logging purposes only)n" !	StartLine	Line at which to start3 !	MaxBytes	The maximum size in bytes to be returned  ! 
 !    Outputs: C !	Xbuffer		The buffer is modified to contain only the found segment  !  !    Function Return Value: 5 !	The range of lines that fit into the specified size  !  !    Side Effects:K !       The buffer is altered to remove parts of the segment not within the ( !	constraints of size and starting point ! H ! ----------------------------------------------------------------------  7 PROCEDURE GetSegment(Xbuffer,Segment,StartLine,MaxSize)f( LOCAL LineCount,BufferBytes,BufferLines;  %    POSITION( BEGINNING_OF(Xbuffer) );p3    BufferLines := GET_INFO(Xbuffer,"RECORD_COUNT");   3  ! We're only interested in lines after `StartLine'     IF StartLine > 0 	      THENw         MOVE_VERTICAL(StartLine);        MOVE_HORIZONTAL(-1); ?        ERASE( CREATE_RANGE(BEGINNING_OF(Xbuffer),MARK(NONE)) );P	    ENDIF;e  C  ! Go to the end of this segment and then remove everything past it 6  ! Make sure we always return with at least one record&    BufferBytes := BufferSize(Xbuffer);"    IF Debugging >= DEBUG_ShowSplit	      THENez        Inform("D","SEGSIZES",FAO("Buffer length=!UL, Buffer size=!UL, Maximum=!UL", LENGTH(Xbuffer),BufferBytes,MaxSize));	    ENDIF;       IF MaxSize <= BufferBytes	      THEN          MOVE_HORIZONTAL(MaxSize);B        MOVE_HORIZONTAL(-CURRENT_OFFSET);	! Return to start of lineJ        IF MARK(NONE) = BEGINNING_OF(Xbuffer) THEN MOVE_VERTICAL(1); ENDIF;9        ERASE( CREATE_RANGE(MARK(NONE),END_OF(Xbuffer)) ); 	    ENDIF;     ! Say where we are ... 1    LineCount := GET_INFO(Xbuffer,"RECORD_COUNT");     ! Log the segment split point    IF Logging >= LOG_ShowSplit	      THEN 9        IF (StartLine > 0) OR (LineCount <= BufferLines-1) 
          THEN             Inform("I","SEGSPLIT",FAO("Segment: !UL, records !UL-!UL of !UL",Segment,StartLine+1,StartLine+LineCount,BufferLines));
        ENDIF;T	    ENDIF;       RETURN(LineCount);   
 ENDPROCEDURE;+  H ! ---------------------------------------------------------------------- ! FIXUP FIRST PART ! L !    At the time of creating the first part, it is not knowwn how many partsI !    are going to be generated. Therefore, part 1 is kept in memory until H !    the end. This routine fixes up the values in that part which depend" !    on the total number of parts. !e
 !    Globals: 4 !	Part1Buffer		Special buffer holding the first part( !	PartNo			The number of parts generated !aH ! ----------------------------------------------------------------------   PROCEDURE FixupFirstPart  N ! Massage the contents of the initial part to accurately reflect the number ofN ! Parts generated and to give the appropriate instructions if more than 1 part  (   POSITION( BEGINNING_OF(Part1Buffer) );&   POSITION( SEARCH( "$!+", FORWARD) );   IF PartNo > 1 C     THEN	! Modify the inital message to state exact number of parts ,        POSITION( SEARCH( "++++", FORWARD) );        ERASE_CHARACTER(4);         COPY_TEXT( STR(PartNo) );B     ELSE	! Erase initial attention message as there's only 1 part!        ERASE_LINE; ERASE_LINE;   ENDIF;    * ! Finally write out the first part to disk   WritePart(Part1Buffer,1);    ENDPROCEDURE  H ! ---------------------------------------------------------------------- ! LOG TOTAL PARTS  ! M !   Write the number of parts created into a file so that the rest of the DCL-I !   based code can pick it up.  Also, log a message to the user about the  !   part count if requested. !- !   Globals:, !	Share			Flag to write/not write share file4 !	WorkBuffer		Used to write the part count to a file !	PartNo			The total part counts# !	ParamFile		The file to be writteneH ! ---------------------------------------------------------------------- PROCEDURE LogTotalParts   K ! Write a value back to the parameter file to indicate how many parts were i ! generated.     ReuseBuffer(WorkBuffer);   COPY_TEXT(STR(PartNo));-$   WRITE_FILE(WorkBuffer, ParamFile);     ! Log number of parts       IF Logging >= Log_ShowNumparts     THEN       IF Share         THENQ           Inform("I","NUMPARTS",FAO("Share file written in !UL part!%S",PartNo));          ELSEU           Inform("I","NUMPARTS",FAO("Share file not written in !UL part!%S",PartNo));-       ENDIF;   ENDIF;   ENDPROCEDURE rO ! -----------------------------------------------------------------------------rO ! +                 B U F F E R    E N C O D I N G                            +eO ! +                                                                           +	O ! +   This module is responsible for encoding the file buffer in the most     +aO ! +   effective way commensurate with the user's stated options.              +-O ! +                                                                           + O ! +   8.5                   Andy Harper                        June 1994      + O ! +                                                                           + O ! +                                                                           + O ! +   WriteBlanks             Write out trailing blanks                       + O ! +                                                                           +uO ! +   WrapLong                Check when to wrap lines                        +rO ! +                                                                           +IO ! +   RightMost               Return rightmost part of a string               +FO ! +                                                                           + O ! +   Quoteable               Check if a character is quoteable               +-O ! +                                                                           +eO ! +   PutN                    Put out N occurences of a single character      + O ! +                                                                           +cO ! +   PutQuoted               Put out the quoted form of a character          +pO ! +                                                                           +oO ! +   PutCompressedRun        Put out the run-length encoded form of a run    +EO ! +                                                                           +oO ! +   PutCompressedString     Put out the LZ compressed form of a substring   + O ! +                                                                           +DO ! +   PutRun                  Encode a run in the most efficient way          + O ! +                                                                           +uO ! +   PutLine                 Encode/put a string, just quoting and wrapping  + O ! +                                                                           +-O ! +   PutString               Encode/put a string, incl. run-length coding    + O ! +                                                                           +vO ! +   PutLZ                   Encode/put a string, incl. LZ compression       +uO ! +                                                                           +aO ! +   PutLZSimple             Scan a line for potential LZ compression        +	O ! +                                                                           +eO ! +   ShowProgress            Display progress through file as a percentage   +-O ! +                                                                           + O ! +   ShowStatistics          Display start and end statsitics on file size   +NO ! +                                                                           + O ! +   EncodeBuffer            Encode buffer for transmission                  +:O ! +                                                                           +-O ! -----------------------------------------------------------------------------  kK ! -------------------------------------------------------------------------u ! WRITE BLANKS !aH !   Output a string of blanks, with the last blank written in its quoted	 !   form.  !t !   Globals:4 !	QuotedBlank			The quoted form of a space character3 !	CurrentRecord			The record being built for outputc !  !   Inputs: ) !	N				The number of blanks to be written  !  !   Outputs: !	NONE !t !   Function Return Value: !	NONE !e !   Side Effects:s !	NONE !aK ! -------------------------------------------------------------------------m   PROCEDURE WriteBlanks(n)       IF N <= 0 THEN RETURN; ENDIF;      IF N > 1		      THEN 8        CurrentRecord := CurrentRecord + ( " " * (n-1) );	    ENDIF;d  0    CurrentRecord := CurrentRecord + QuotedBlank;   ENDPROCEDURE   :K ! -------------------------------------------------------------------------  ! WRAP LONG  !SI !   Checks to see whether a string of a specific length will fit into the-I !   current line.  If not, then the line is split and a continuation lineR !   flag added.e !c !   Globals:2 !	CurrentRecord		The record being built for output< !	PendingBlanks		Number of blanks to insert before next char8 !	Max_Share_Length	The maximum length of the output line8 !	Continuation_Flag	The marker for a continuation record !R !   Inputs:)+ !	N			The length of the string to be outputO- !				(If zero, flush existing pending blanks)A !n !   Outputs: !	None !  !   Function Return Value: !	NONE !, !   Side Effects:  !	Part Buffer may be modifiedg !aK ! -------------------------------------------------------------------------    PROCEDURE WrapLong(n)A LOCAL B,Avail;  =  ! Are we flushing lines out? If so, last byte must be quotedd+   IF n = 0 THEN B := 2; ELSE B := n; ENDIF;e  O  ! Fill up as many complete lines as possible with blanks, always ensuring that)*  ! the very last blank on a line is quoted   LOOP7      Avail := Max_Share_Length - LENGTH(CurrentRecord);f'      EXITIF Avail >= PendingBlanks + B;o  P     ! We have enough blanks to fill the current line and leave at least one over&      IF Debugging > DEBUG_ShowTrailing        THEN \          Inform("D","ENDBLANK", FAO("Avail: !UL, Pend: !UL, N: !UL",Avail,PendingBlanks,N));7          Inform("D","ENDBLANK", "'"+CurrentRecord+"'");v      ENDIF;a  E     ! Work out the maximum number of blanks we can write to this linecF      IF Avail > PendingBlanks		! Have we got more blanks than will fit<        THEN Avail := PendingBlanks;	! No, output all of themD        ELSE Avail := Avail-2;		! YES, output enough to fill the line      ENDIF;o  .      IF Avail > 0			! Don't output ZERO blanks        THEN           WriteBlanks( Avail );0          PendingBlanks := PendingBlanks - Avail;      ENDIF;-	                 PutRecord(CurrentRecord);(      CurrentRecord := Continuation_Flag;  
   ENDLOOP;  M  ! The remaining blanks can be output as is, leaving enough space for the `n'   ! bytes that follow.f   IF (n > 0)c     THEN CurrentRecord := CurrentRecord + ( " "*PendingBlanks );! When something follows the blanks-H     ELSE WriteBlanks( PendingBlanks );	! When nothing follows the blanks   ENDIF;     PendingBlanks := 0;    ENDPROCEDURE     mK ! -------------------------------------------------------------------------h ! RIGHTMOST  !e* !   Returns the rightmost part of a string !  !   Globals: !	NONE !  !   Inputs:o  !	s			The string to be truncated! !	n			The last `n' chars requirede !o !   Outputs: !	NONE !	 !   Function Return Value: !	The truncated string !	 !   Side Effects:- !	NONE !-K ! -------------------------------------------------------------------------B   PROCEDURE RightMost(s,n);f      IF LENGTH(s) > ni
       THEN*          RETURN SUBSTR(s,LENGTH(s)-n+1,n);
       ELSE          RETURN s;	    ENDIF;f   ENDPROCEDURE    K ! -------------------------------------------------------------------------e ! QUOTEABLEs !O, !    Checks whether a character is quoteable !h
 !    Globals:g: !	Quoteable_Chars		Table of characters that must be quoted !  !    Inputs:! !	c			The character to be checkedm !"
 !    Outputs:P !	NONE !o !    Function Return Value6 !	TRUE if the character is a quoteable one, else FALSE !N !    Side Effects: !	None ! K ! -------------------------------------------------------------------------i   PROCEDURE Quoteable(c)  "    IF INDEX(Quoteable_Chars,c) > 0       THEN RETURN (1);       ELSE RETURN (0);	    ENDIF;    ENDPROCEDURE  K ! -------------------------------------------------------------------------i ! PUT N  !PI !   Given a run of a particular character, output that run to the currentcL !   line. However, a sequence of blanks is held back until the next sequenceF !   is output, to allow special checks to be made for trailing blanks. ! 
 !    Globals: * !	CurrentRecord		Output record being built+ !	PendingBlanks		Number of blanks held backd !d !    Inputs:* !	c			The character making up the sequence  !	n			The length of the sequence !n
 !    Outputs:r !	NONE !t !    Function Return Value:r !	NONE !u !    Side Effects:  !	The current record is modified !	K ! -------------------------------------------------------------------------    PROCEDURE PutN(c,n)i  
    IF c = " "a-      THEN PendingBlanks := PendingBlanks + n;	>      ELSE WrapLong(n); CurrentRecord := CurrentRecord + (c*n);	    ENDIF;	   ENDPROCEDURE    K ! -------------------------------------------------------------------------e ! PUT QUOTED !-E !    Given a particular byte, add the quoted form of that byte to theu !    current output line.s !c
 !    Globals:w* !	CurrentRecord		Output record being built- !	QU_Flag			The byte used as the quote escape  !t !    Inputs: !	c			The byte to be outputo !o
 !    Outputs:i !	NONE !  !    Function Return Value:T !	NONE !0 !    Side Effects:  !	The current record is modified ! K ! -------------------------------------------------------------------------    PROCEDURE PutQuoted(c) LOCAL QuotedString;F  5    QuotedString := FAO("!AS!2XL", QU_Flag, ASCII(c)); $    WrapLong( LENGTH(QuotedString) );1    CurrentRecord := CurrentRecord + QuotedString;    ENDPROCEDURE dK ! -------------------------------------------------------------------------  ! PUT COMPRESSED RUN !"G !    Given a run of a specific character, add the run-length compressedr+ !    equivalent to the current output line.u ! K !    Note that, because the encoding scheme allows for a maximum run lengthuH !    of 255, we break up the encoding into several sections, each of 255 !    bytes or less.- !-
 !    Globals: * !	CurrentRecord		Output record being built2 !	RL_Flag			The run-length compression escape flag !f !    Inputs:* !	c			The character making up the sequence$ !	n			Number of occurrences (length) !e
 !    Outputs:  !	NONE !b !    Function Return Value:o !	NONE !e !    Side Effects:  !	The current record is modified !TK ! -------------------------------------------------------------------------N   PROCEDURE PutCompressedRun(c,n)= LOCAL Size, CompressedString;u      LOOPO  8      IF n > 255 THEN Size := 255; ELSE Size := n; ENDIF;  F      CompressedString := FAO("!AS!2XL!2XL", RL_Flag, Size, ASCII(c) );*      WrapLong( LENGTH(CompressedString) );7      CurrentRecord := CurrentRecord + CompressedString;s        n : = n-size;      EXITIF n<=0;l      ENDLOOP;n   ENDPROCEDURE     tK ! -------------------------------------------------------------------------- ! PUT COMPRESSED STRINGT !tO !   Given a substring and a backwards offset, output the string in a compressedR !   format.  !a !   Globals:* !	CurrentRecord		Output record being built5 !	LZ_Flag			The escape flag for the compressed stringe !r !   Inputs:E !	s			The string to be written, !	b			backwards pointer to previous instance !  !   Outputs: !	NONE !S !   Function Return Value: !	NONE !e !   Side Effects:;  !	The current record is modified ! K ! -------------------------------------------------------------------------e  # PROCEDURE PutCompressedString(s,b);  LOCAL LZString;D  9    LZString := FAO("!AS!2XL!2XL", LZ_Flag, b, LENGTH(s));N     WrapLong( LENGTH(LZString) );.    CurrentRecord := CurrentRecord + LZString ;   ENDPROCEDURE       -K ! ------------------------------------------------------------------------- 	 ! PUT RUNe !nH !    Given a sequence of the same character, work out the optimum way toF !    encode the sequence under the currently selected options and then2 !    add that encoding to the current output line. !r. !    Encodings considered by this routine are:$ !	- Encoding of quoteable characters* !	- Compression of long runs of characters ! 
 !    Globals:e !	NONE !m !    Inputs:( !	c			The character forming the sequence  !	N			The length of the sequence !l
 !    Outputs:n !	NONE !i !    Function Return Value:e !	NONE !  !    Side Effects: !	The current line is modified !nK ! --------------------------------------------------------------------------   PROCEDURE PutRun(c,n)-      IF n = 0 THEN RETURN; ENDIF;R  B  ! Longer than 5, always output as the run-length encoded sequence    IF n > 5,	      THEN;        PutCompressedRun(c,n);b        RETURN;	    ENDIF;:  I  ! No more than 5 characters; best form depends on whether quoting needede    IF Quoteable(c)	      THEN   8      ! A run of quoteable chars is best output as a run;        IF N > 1)#          THEN PutCompressedRun(c,n)I          ELSE PutQuoted(c)
        ENDIF;   	      ELSEe  :      ! Short run of non-quoteable characters, output as is        PutN(c,n);r  	    ENDIF;    ENDPROCEDURE     fK ! -------------------------------------------------------------------------E
 ! PUT LINE !rE !    Given a line of text, split it into single characters for simple  !    encoding into the bufferS !)
 !    Globals:  !	NONE !S !    Inputs: !	s				String to be encoded_ !I
 !    Outputs:; !	NONE !V !    Function Return Value:; !	NONE !o !    Side Effects: !	Current Line is modified !(K ! -------------------------------------------------------------------------,   PROCEDURE PutLine(s) LOCAL L,OffSet,c;w  *   ! Initialize to scan the supplied string/      L        := LENGTH(s);	! Record its lengtht9      OffSet   := 0;		! Prepare to step thru string L -> RI  	      LOOP>           OffSet := OffSet + 1;1         EXITIF OffSet > L;          c := SUBSTR(s,OffSet,1);           IF Quoteable(c)f           THEN PutQuoted(c);           ELSE PutN(c,1);)         ENDIF;   
      ENDLOOP;    ENDPROCEDURE  K ! -------------------------------------------------------------------------- ! PUT STRING !-F !   Given a string, output it to the current line, parsing it for runs !s !   Globals: !	NONE !s !   Inputs:i !	s				The string to be output !  !   Outputs: !	NONE !  !   Function Return Value: !	NONE !h !   Side Effects:r !	The current line is modified !uK ! -------------------------------------------------------------------------    PROCEDURE PutString(s)$ LOCAL L, OffSet, Count, PrevChar, C;  *   ! Initialize to scan the supplied string/      L        := LENGTH(s);	! Record its length 9      OffSet   := 0;		! Prepare to step thru string L -> Rr,      Count    := 0;		! Length of current run*      PrevChar := "";		! Previous character  	      LOOP   8       ! Step to next character; exit if at end of string         OffSet := OffSet + 1;N         EXITIF OffSet > L;          c := SUBSTR(s,OffSet,1);  <       ! Check character against previous one to locate a run         IF c <> PrevChar            THEN %               PutRun(PrevChar,Count);l               PrevChar := c ;n               Count    := 1 ;E            ELSEI!               Count := Count + 1;s         ENDIF;  
      ENDLOOP;B  2      PutRun(PrevChar,Count);	! Flush last sequence   ENDPROCEDURE     -K ! -------------------------------------------------------------------------a ! PUTLZe !nE !   Try to output a string in the Compressed Substring format; if not E !   possible, output it as a normal string (deal with trailing blanks. !   separately in this case).l !t !   Globals: !	NONE !i !   Inputs:f% !	SubString			The string to be outputi4 !	Prevtext			Previous text - might contain SubString7 !	MatchPosition			The offset into PrevText of SubString- !- !   Outputs: !	NONE !- !   Function Return Value: !	NONE !r !   Side Effects:  !	Current line is modified !hK ! -------------------------------------------------------------------------(  3 PROCEDURE PutLZ(SubString, PrevText, MatchPosition)   7    IF (MatchPosition = 0)  OR  (LENGTH(SubString) <= 5)s
       THEN          PutString(SubString);
       ELSEI          PutCompressedString(SubString,LENGTH(PrevText)-MatchPosition+1); 	    ENDIF;    ENDPROCEDURE     RK ! -------------------------------------------------------------------------N ! PUT LZ SIMPLEU ! J !   Scan the input string, looking for common substrings. Output unmatchedK !   strings normally; output matched strings as a coded pointer back to the  !   previous occurence.  ! I !   This version only looks for substrings occurring in the same string!!s !d !   Globals: !	NONE !c !   Inputs:e !	s				String to be encoded  !  !   Outputs: !	NONE !e !   Function Return Value: !	NONE !  !   Side Effects:  !	Current line is modified ! K ! -------------------------------------------------------------------------e   PROCEDURE PutLZSimple(s)J LOCAL L, OffSet, c, PrevText, SubString, MatchPosition, PrevMatchPosition;  +    ! Initialize for common substring search       PrevText := "";      SubString:= "";      PrevMatchPosition := 0;  )    ! Initialize to process current record 7      L        := LENGTH(S);	! ... and record its length 7      OffSet   := 0;		! Prepare to step thru line L -> R   	      LOOP   6       ! Step to next character; exit if at end of line         OffSet := OffSet + 1;          EXITIF OffSet > L;          c := SUBSTR(S,OffSet,1);  N       ! Examine the current substring to see if it has previously occurred; ifM       ! not, then output it normally otherwise remember it and try to find a         ! longer substring5         MatchPosition := INDEX(PrevText,SubString+c);          IF MatchPosition > 0           THEN(              SubString := SubString + c;0              PrevMatchPosition := MatchPosition;           ELSE9              PutLZ(SubString,PrevText,PrevMatchPosition); ;              PrevText := RightMost(PrevText+SubString,255);t              SubString := c;$              PrevMatchPosition := 0;         ENDIF;  
      ENDLOOP;   1      PutLZ(SubString,PrevText,PrevMatchPosition);    ENDPROCEDURE dH ! ---------------------------------------------------------------------- ! SHOW PROGRESS  ! G !   Issue an informational message giving the percentage of the current D !   buffer that has been processed so far. The logging level must be, !   sufficient for the display to be output. ! K !   This routine is generally called after each record of the original file  !   has been processed.  !  !   Globals:2 !	LastP				Last percentage at which message issued( !	OrigFileBytes			Bytes in original file0 !	InputBytes			Bytes processed from current file0 !	OutputBytes			Bytes generated for current file !r !   Inputs:  !	NONE !p !   Outputs: !	NONE !n !   Function Return Value: !	NONE !  !   Side Effects:  !	Message written to user  ! H ! ----------------------------------------------------------------------   PROCEDURE ShowProgress LOCAL x,y,p;  #  IF Debugging >= DEBUG_ShowProgress      THEN        IF InputBytes = 0          THEN p := 0; @          ELSE p  := (100*(OutputBytes-InputBytes)) / InputBytes;
        ENDIF; h        Inform("D","PROGRESS", FAO("Input: !UL, Output: !UL, Change !SL%", InputBytes, OutputBytes, p));   ENDIF;     IF Logging >= LOG_ShowProgress      THEN  $     ! Get stats on the buffer length       x := OutputBytes; 4       y := OrigFileBytes + (OutputBytes-InputBytes);       ! Compute the statistics       p := (100*x)/y;        IF p >= Lastp + 3          THENK           Inform("I","ENCDPROG", FAO("Encoded: !3SL% (!UL of !UL)",p,x,y));            LastP := p;        ENDIF;   ENDIF;  
 ENDPROCEDURE;   O ! ------------------------------------------------------------------------------ ! SHOW STATISTICS- !-E !   Display the file size, records and bytes, at start or end of file < !   processing. If end, also show percentage change in size. !i !   Inputs:u% !	DisplayType		0 for start, 1 for enduA !       StartRecords		Number of records in buffer before encoding	7 !	StartBytes		Number of bytes in buffer before encoding	: !	FinalRecords		Number of records in buffer after encoding6 !	FinalBytes		Number of bytes in buffer after encoding !	O ! ------------------------------------------------------------------------------  U PROCEDURE ShowStatistics(DisplayType,StartRecords,StartBytes,FinalRecords,FinalBytes) 
 LOCAL f,c;     IF Logging >= LOG_ShowStatsu     THEN         If (DisplayType = 0)         THEN(           f:="Records: !UL, Bytes: !UL";@           Inform("I","ORIGSIZE",FAO(f,StartRecords,StartBytes));         ELSE  6       ! Compute final size stats and compression ratio7           IF StartBytes = 0		! Compute % change in size              THEN c := 0tG             ELSE c := (1000*(FinalBytes-StartBytes)+5)/(10*StartBytes);            ENDIF;         ! Log the stats 5           f:="Records: !UL, Bytes: !UL, Change !SL%";iB           Inform("I","ENCDSIZE",FAO(f,FinalRecords,FinalBytes,c));       ENDIF;     ENDIF;   ENDPROCEDURE fO ! -----------------------------------------------------------------------------o ! ENCODE BUFFERz !,A !   This routine is the interface to the buffer encoding methods. @ !   It selects the compression technique to be used based on theA !   user specified `compression' value. If selected, it will also-D !   issue statistics after compression to indicate the effectiveness' !   of any selected compression method.f !,G !   Each record in the buffer is removed to a string, processed to form F !   an output string and then added to the part buffer when a complete !   output record is formed. !k !   Globals:
 !	OutputBytes  !	OutputRecords_ !	InputBytes !	InputRecords( !	Compression			Current compression type* !	COMPRESS_None			No compression requested3 !	COMPRESS_RunLength		Run length encoding requested : !	COMPRESS_LZW_Simple		Common substring encoding requested !r !   Inputs:N$ !	Xbuffer				Buffer to be compressed !v !   Outputs:. !	Xbuffer				Compressed buffer (done in place) !n !   Function Return Value: !	NONE !o !   Side Effects:n !	Messages written to the user !sO ! -----------------------------------------------------------------------------    PROCEDURE EncodeBuffer(XBuffer) . LOCAL s,b,l,SaveOutputBytes,SaveOutputRecords;  F ! Unexpected errors, such as insufficient memory, can occur during the5 ! processing of a buffer. Here we trap them and abort 
   ON_ERRORJ     Inform("F","FATALERR","Unexpected error encoding the data - aborted");
     ABORT;   ENDON_ERROR;  : ! Show size of current segment before encoding takes place   b := BufferSize(Xbuffer);g(   l := GET_INFO(Xbuffer,"RECORD_COUNT");%   SaveOutputRecords := OutputRecords;l#   SaveOutputBytes   := OutputBytes;e   ShowStatistics(0,l,b,0,0);  7 ! Encode buffer, using the user's requested compressionL< ! Always quote non-printable chars and wrap lines regardless   LastP :=0;   LOOP'      POSITION( BEGINNING_OF(XBuffer) );m0      EXITIF MARK(NONE) = END_OF(CURRENT_BUFFER);?      s := ERASE_LINE;		! Remove current record to string bufferi@      PendingBlanks :=0;		! Blank characters waiting to be output#      CurrentRecord := Initial_Flag;   1      InputBytes    := InputBytes + LENGTH(s) + 1; '      InputRecords  := InputRecords + 1;	  &      IF Debugging >= DEBUG_ShowRecords        THEN-"          Inform("D","INPUTREC",s);      ENDIF;-  E      IF Compression = COMPRESS_None       THEN PutLine(s);     ENDIF;HE      IF Compression = COMPRESS_Runlength  THEN PutString(s);   ENDIF; E      IF Compression = COMPRESS_LZW_Simple THEN PutLZSimple(s); ENDIF;-  9      WrapLong(0);		! Force out any stored trailing blankseB      PutRecord(CurrentRecord);	! Then write the rest of the record        ShowProgress;
   ENDLOOP;  " ! Display final segment statisticsT   ShowStatistics(1,l,b,OutputRecords-SaveOutputRecords,OutputBytes-SaveOutputBytes);  
 ENDPROCEDURE;o eH ! +--------------------------------------------------------------------+H ! +                                                                    +H ! +     S H A R E   F I L E   H E A D E R S   A N D   T R A I L E R S  +H ! +                                                                    +H ! +                                                                    +H ! +   The share file which is created consists of a mixture of DCL, TPU+H ! +   and user data.  The DCL and TPU code surrounding each file of    +H ! +   user data create a sequence which, when executed, unpacks the    +H ! +   encoded user data to its original format.                        +H ! +                                                                    +H ! +                                                                    +H ! +   8.5              Andy Harper                         Jun 1994    +H ! +                                                                    +H ! +                                                                    +H ! +                                                                    +H ! +               R O U T I N E   S U M M A R Y                        +H ! +                                                                    +H ! +   PackTPU                    Routine to compress lines of TPU code +H ! +                              prior to adding to share file.        +H ! +                                                                    +H ! +   AddPrologueHeader          Create the share file header plus the +H ! +                              start of the UNPACK subroutine        +H ! +                                                                    +H ! +   AddPrologueTPUUnpacker     Create the TPU unpack code            +H ! +                                                                    +H ! +   AddPrologueTrailer         Create the remainder of the unpack    +H ! +                              subroutine                            +H ! +                                                                    +H ! +   AddEpilogue                Create the share file completion code +H ! +                                                                    +H ! +--------------------------------------------------------------------+ mG ! --------------------------------------------------------------------- 
 ! PACK TPU !cG !   The generated share file contains a small program in TPU to performcA !   the unpacking. To save space, this program is created withouti$ !   unnecessary spaces and newlines. !hG !   No line of the program is longer than the maximum share file length I !   and splits are only made after characters in the set `TPU_Separators' K !   (which clearly should NOT contain any characters likely to occur within- !   quotes!- !-E !   This routine adds one line of TPU code to the buffer and picks an=/ !   appropriate place to split it if necessary.  !I !   Globals:+ !	TPUCodeSize			Size of the TPU Code BufferC !r !   Inputs:=( !	NewTPUCode			A line of TPU to be added !; !   Outputs: !	NONE !o !   Function Return Value: !	NONE !: !   Side Effects:o  !	The current buffer is modified !;G ! ----------------------------------------------------------------------   PROCEDURE PackTPU(NewTPUCode)- LOCAL l,s,c;  O ! Append the new TPU code to the end of the current line, trimming blanks firstd   s := NewTPUCode;   EDIT(s,TRIM);r   COPY_TEXT(s);t   l := LENGTH(s);:!   TPUCodeSize := TPUCodeSize + l;i  K ! If it doesn't end in an acceptable separator, then add a space to delimits ! it from the next one added.t   c := SUBSTR(s,l,1);n    IF INDEX(TPU_separators,c) = 0     THEN1       COPY_TEXT(" "); TPUCodeSize:=TPUCodeSize+1;    ENDIF;    ? ! If the current line is now too long, find a point to split it-,   IF LENGTH(CURRENT_LINE) > Max_Share_Length     THEN  6     ! Find a TPU separator character on which to split
       LOOP         MOVE_HORIZONTAL(-1);9         POSITION( SEARCH( ANY(TPU_separators),REVERSE) );r1         EXITIF CURRENT_OFFSET < Max_Share_Length;E       ENDLOOP;                         M     ! Split just past the TPU separator and reposition at the end of the linea       MOVE_HORIZONTAL(1);c       SPLIT_LINE;p.       MOVE_HORIZONTAL( LENGTH(CURRENT_LINE) );L       TPUCodeSize := TPUCodeSize + 3;	! New line increases size by 3 on disk   ENDIF;     IF Debugging >= DEBUG_PackTPUt     THENL       Inform("D","PAKTPUCD","Adding '"+s+"', To give: '" + CURRENT_LINE+"'")   ENDIF;  
 ENDPROCEDURE;s   	H ! ---------------------------------------------------------------------- ! ADD PROLOGUE HEADERe !lF !   The share file contains a prolog consisting of a chunk of DCL codeF !   and some TPU code which, together, form the unpacking and decoding !   routine for a given file.- !-H !   This routine writes in the share file identification, version checksF !   and various initialization tasks, followed by the DCL code forming# !   the start of unpacking routine.  !  !   Globals:/ !	VersKeep			Flag to [Not] keep version numbers + !	FileCount			Count of files to be packagedw !h !   Inputs:e0 !	ArchiveName			Name of archive (null = no name)6 !	IdentLine			Identification of the share file creator% !	PartSize			Max part size, in blocksnB !	FileNameBuffer			Buffer containing names of files to be packaged !  !   Outputs: !	NONE !a !   Function Return Value: !	NONE !t !   Side Effects:F !	NONE !OH ! ----------------------------------------------------------------------K PROCEDURE AddPrologueHeader(ArchiveName,IdentLine,BlockSize,FileNameBuffer)s
 LOCAL m,File;s  G   PutRecord( "$! ------------------ CUT HERE -----------------------");SB   PutRecord( "$ v='f$verify(f$trnlnm(""SHARE_UNPACK_VERIFY""))'");   PutRecord( "$!" );)   PutRecord( "$! This archive created:");e   IF ArchiveName <> "" THENi2   PutRecord( FAO("$!!  Name : !AS", ArchiveName));   ENDIF;0   PutRecord( FAO("$!!  By   : !AS", IdentLine));)   PutRecord( FAO("$!!  Date : !%D", 0) );tr   PutRecord( FAO("$!!  Using: !AS !AS, (C) 1993 Andy Harper, Kings College London UK", Facility, Version_Number));   PutRecord( "$!" );K   PutRecord( "$! Credit is due to these people for their original ideas:"); 4   PutRecord( "$!    James Gray, Michael Bednarek ");   PutRecord( "$!");d,   PutRecord( "$! To unpack this archive:" );j   PutRecord( "$!+   Ensure that all parts are present, (++++ at about "+STR(BlockSize)+" Blocks each)." );J   PutRecord( "$!+   Append all parts together to form one larger file." );_   PutRecord( "$!    Minimum of VMS " + Min_VMS + " (VAX) / OpenVMS 1.0 (Alpha) is required." );uT   PutRecord( "$!    Remove the headers of the first part, up to `cut here' line." );<   PutRecord( "$!    Execute file as a command procedure." );   PutRecord( "$!");-K   PutRecord( "$! The following file(s) will be created after unpacking:" );f    0 ! Add the list of packaged files into the header   FileCount := 0;    LOOP      POSITION(FileNameBuffer);      m := MARK(NONE);='      EXITIF m = END_OF(CURRENT_BUFFER);r      DELETE(m);=  >    ! Extract next filename from list, add it to the partbufferP      File      := StripFile( SUBSTR(CURRENT_LINE,1,INDEX(CURRENT_LINE," ")-1) );       FileCount := FileCount + 1;      MOVE_VERTICAL(1);  (      IF Debugging >= DEBUG_AddToPrologue         THEN?           Inform("D","ADDPROHD","Adding file """ + File +"""");r      ENDIF;T  7      PutRecord( FAO("$!!!8UL. !AS", FileCount, File) );   
   ENDLOOP;       PutRecord( "$!");    PutRecord( "$ set=""set""");6   PutRecord( "$ set symbol/scope=(nolocal,noglobal)");    I ! Define the temporary scratch file name here. Note that it is IMPERATIVE I ! that we default to a scratch file name that has a NULL name part, since-O ! this will cause problems unpacking files with a null name part later, due to r9 ! the sticky action of the DCL commandws COPY and RENAME,eL ! We let the user define their own scratch file if they want but they should$ ! be aware of the potential problem. ! C   PutRecord( "$ f=""SYS$SCRATCH:.""+f$getjpi("""",""PID"")+"";""");t   SetKeepTogether(1);	D   PutRecord( "$ if f$trnlnm(""SHARE_UNPACK"") .nes. """" then $ -");4   PutRecord( " f=f$parse(""SHARE_UNPACK_TEMP"",f)");   SetKeepTogether(0); C   PutRecord( "$ e=""write sys$error  """"%"+FAC_unpack+""""", """);-C   PutRecord( "$ w=""write sys$output """"%"+FAC_unpack+""""", """);iK   PutRecord( "$ if .not. f$trnlnm(""SHARE_UNPACK_LOG"") then $ w = ""!""");NB   PutRecord( "$ if f$getsyi(""CPU"") .gt. 127 then $ goto start");+   PutRecord( "$ ve=f$getsyi(""version"")");oR   PutRecord( "$ if ve-f$extract(0,1,ve) .ges. """+Min_VMS+""" then $ goto start");E   PutRecord( "$ e ""-E-OLDVER, Must run at least VMS "+Min_VMS+"""");e    PutRecord( "$ v=f$verify(v)");   PutRecord( "$ exit 44");  F ! Insert the DCL procedure which unpacks a specific file, restores the/ ! record attributes, and validates the checksumi^   PutRecord( "$unpack:subroutine!P1=file,P2=chksum,P3=attrib,P4=size,P5=fileno,P6=filetotal");  9 ! Insert code to check directory exists and create if notO>   PutRecord( "$ if f$parse(P1) .nes. """" then $ goto dirok");1   PutRecord( "$ dn=f$parse(P1,,,""DIRECTORY"")");-<   PutRecord( "$ w ""-I-CREDIR, Creating directory ''dn'""");"   PutRecord( "$ create/dir 'dn'");/   PutRecord( "$ if $status then $ goto dirok");rK   PutRecord( "$ e ""-E-CREDIRFAIL, Unable to create ''dn' File skipped""");x   PutRecord( "$ delete 'f'*");   PutRecord( "$ exit");    ! Directory now in place   PutRecord( "$dirok:");   ! Check file existence!   PutRecord( "$ x=f$search(P1)");f:   PutRecord( "$ if x .eqs. """" then $ goto file_absent");  L ! If we're not preserving versions, then we can't bomb out if an old versionL ! already exists when we unpack; so alter the check dependent on the setting" ! of the `preserve versions' flag.
   IF VersKeeph     THENB       PutRecord( "$ e ""-W-EXISTS, File ''P1' exists. Skipped""");"       PutRecord( "$ delete 'f'*");       PutRecord( "$ exit");a     ELSEH       PutRecord("$ e ""-W-HIGHVERS, Creating higher version of "", P1");   ENDIF;     PutRecord( "$file_absent:");g   PutRecord( "$ w ""-I-UNPACK, Unpacking "", P5, "" of "", P6, "" - "", P1, "" - "", P4, "" Blocks""");T   PutRecord( "$ n=P1"); .   PutRecord( "$ if P3 .nes. """" then $ n=f");H   PutRecord( "$ if .not. f$verify() then $ define/user sys$output nl:");   ENDPROCEDURE IH ! ---------------------------------------------------------------------- ! ADD PROLOGUE TPU UNPACKER- !-H !   This routine creates the packed TPU code which makes up the heart ofF !   the decoding subroutine in the share file.  To save space, the TPUF !   code is tightly packed in the share file - see packTPU for details !s !   Globals:) !	Compression			Current compression value 5 !	COMPRESS_RunLength		Min compression to run compress 4 !	COMPRESS_LZW_Simple		Min compression to LZW encode1 !	SpaceEnc			Flag to indicate [No] space encodingg !s !   Inputs:i !	NONE !y !   Outputs:1 !	Xbuffer				Buffer in which to write unpack code  !e !   Function Return Value: !	NONE !u !   Side Effects:  !	NONE !	H ! ----------------------------------------------------------------------    PROCEDURE AddPrologueTPUUnpacker LOCAL s;     ReuseBuffer(WorkBuffer);  D   s := "$ EDIT/TPU/NOSEC/NODIS/COM=SYS$INPUT/NOJOURNAL 'f'/OUT='n'";   COPY_TEXT(s); SPLIT_LINE;u   TPUCodeSize := LENGTH(s) + 1;   D ! Insert procedure to extract the next two digits as a hex character$   PackTPU( "PROCEDURE GetHex(s,p)");   PackTPU( "LOCAL x1,x2;"); .   PackTPU( "  x1:=INDEX(t,SUBSTR(s,p,1))-1;");0   PackTPU( "  x2:=INDEX(t,SUBSTR(s,p+1,1))-1;");!   PackTPU( "  RETURN 16*x1+x2;");G   PackTPU( "ENDPROCEDURE;");  * ! Insert procedure to skip part separators$   PackTPU( "PROCEDURE SkipPartsep");   PackTPU( "LOCAL m;" );   PackTPU( "  LOOP");h"   PackTPU( "    m:=MARK(NONE);" );4   PackTPU( "    EXITIF m=END_OF(CURRENT_BUFFER);" );   PackTPU( "    DELETE(m);" );A   PackTPU( "    EXITIF INDEX(ERASE_LINE,"""+Part_Begin+""")=1;");I   PackTPU( "  ENDLOOP;");E   PackTPU( "ENDPROCEDURE;");  N ! Insert procedure to expand complex LZW encoded substrings (that cross lines)- !  IF Compression = COMPRESS_LZW_Complex THEN , !  PackTPU( "PROCEDURE COPY_PREVIOUS(b,n)"); !  PackTPU( "LOCAL m,s,e,r;");4 !  PackTPU( "  m:=MARK(NONE);MOVE_HORIZONTAL(-b);");5 !  PackTPU( "  s:=MARK(NONE);MOVE_HORIZONTAL(n-1);");nN !  PackTPU( "  e:=MARK(NONE);POSITION(m);r:=CREATE_RANGE(s,e);COPY_TEXT(r);");; !  PackTPU( "  DELETE(m);DELETE(s);DELETE(e);DELETE(r);" );g !  PackTPU( "ENDPROCEDURE;"); 	 !  ENDIF;f  A ! Insert procedure to decode the current line back to useful data-$   PackTPU( "PROCEDURE ProcessLine");!   PackTPU( "LOCAL c,s,l,b,n,p;");t!   PackTPU( "  s := ERASE_LINE;");a   IF (NOT SpaceEnc) THEN   PackTPU( "  EDIT(s,TRIM);");   ENDIF;$   PackTPU( "  c := SUBSTR(s,1,1);");   PackTPU( "  s := s-c;");D   PackTPU( "  IF c = """+Initial_Flag+""" THEN SPLIT_LINE; ENDIF;");%   PackTPU( "  MOVE_HORIZONTAL(-1);");o    PackTPU( "  l := LENGTH(s);");   PackTPU( "  p := 1;");   PackTPU( "  LOOP");e    PackTPU( "    EXITIF p > l;");&   PackTPU( "    c := SUBSTR(s,p,1);");   PackTPU( "    p := p+1;");)   PackTPU( "    CASE c FROM ' ' TO '`'");   +   IF Compression = COMPRESS_LZW_Simple THENe   PackTPU( "      ['"+LZ_Flag+"']: b:=GetHex(s,p); n:=GetHex(s,p+2); p:=p+4; COPY_TEXT( SUBSTR(CURRENT_LINE,CURRENT_OFFSET-b+1,n));");   ENDIF;  +   IF Compression >= COMPRESS_RunLength THEN-f   PackTPU( "      ['"+RL_Flag+"']: b:=GetHex(s,p); n:=GetHex(s,p+2); p:=p+4; COPY_TEXT(ASCII(n)*b);");   ENDIF;  L   PackTPU( "      ['"+QU_Flag+"']: COPY_TEXT(ASCII(GetHex(s,p))); p:=p+2;");     IF SpaceEnc THEN#   PackTPU( "      [' ']: p:=p+1;");    ENDIF;  6   PackTPU( "      [INRANGE,OUTRANGE]: COPY_TEXT(c);");   PackTPU( "    ENDCASE;");    PackTPU( "  ENDLOOP;");r   PackTPU( "ENDPROCEDURE;");  6 ! Insert procedure to scan and decode the whole buffer#   PackTPU( "PROCEDURE Decode(b)" );p   PackTPU( "LOCAL m;" );,   PackTPU( "  POSITION(BEGINNING_OF(b));" );   PackTPU( "  LOOP" );"   PackTPU( "    m:=MARK(NONE);" );'   PackTPU( "    EXITIF m=END_OF(b);" );n   PackTPU( "    DELETE(m);" );A   PackTPU( "    IF INDEX(CURRENT_LINE,"""+Part_End+""")=1 THEN");S!   PackTPU( "      SkipPartSep;");q   PackTPU( "    ELSE"); !   PackTPU( "      ProcessLine;");d(   PackTPU( "      MOVE_HORIZONTAL(1);");   PackTPU( "    ENDIF;");n   PackTPU( "  ENDLOOP;" );   PackTPU( "ENDPROCEDURE;" );n  ! ! Start of main program code here 6   PackTPU( "SET(FACILITY_NAME,"""+FAC_unpack+""");" );!   PackTPU( "SET(SUCCESS,OFF);" );R'   PackTPU( "SET(INFORMATIONAL,OFF);" );eH   PackTPU( "t:=""0123456789ABCDEF"";" );	! For decoding hex (see gethex)8   PackTPU( "f:=GET_INFO(COMMAND_LINE,""file_name"");" );&   PackTPU( "o:=CREATE_BUFFER(f,f);" );    ! Call the decoding routinep,   PackTPU( "Decode(o);");			! Procedure callE   PackTPU( "WRITE_FILE(o,GET_INFO(COMMAND_LINE,""output_file""));" );i   PackTPU( "QUIT;" );B    ! Add the TPU to the Part buffer*   AddBufferToPart(WorkBuffer,TPUCodeSize);  
 ENDPROCEDURE;r lH ! ---------------------------------------------------------------------- ! ADD PROLOGUE TRAILER !eD !   Write the share file prologue code containing the subroutines to: !   restore the file format and analyze the file checksum. !I !   Globals: !	NONE !E !   Inputs:N !	NONE !( !   Outputs:+ !	Xbuffer					Buffer in which to write codee !d !   Function Return Value: !	NONE !: !   Side Effects:t !	NONE ! H ! ----------------------------------------------------------------------   PROCEDURE AddPrologueTrailer  5 ! Insert code to Restore the file's record attributesg2   PutRecord( "$ if p3 .eqs. """" then $ goto dl");$   PutRecord( "$ open/write fdl &f");'   PutRecord( "$ write fdl ""RECORD""");    PutRecord( "$ write fdl P3");    PutRecord( "$ close fdl");E   PutRecord( "$ w ""-I-CONVRFM, Converting record format to "", P3");L,   PutRecord( "$ convert/fdl='f' 'f'-1 'f'");8   PutRecord( "$ fa=f$getdvi(f$parse(f),""ALLDEVNAM"")");9   PutRecord( "$ Pa=f$getdvi(f$parse(P1),""ALLDEVNAM"")");e@   PutRecord( "$ if fa .eqs. Pa then $ rename &f 'f$parse(P1)'");>   PutRecord( "$ if fa .nes. Pa then $ copy &f 'f$parse(P1)'");!   PutRecord( "$dl: delete 'f'*");   J ! Insert code to do a checksum and validate the created file; then tidy up    PutRecord( "$ checksum 'P1'");   SetKeepTogether(1); 9   PutRecord( "$ if checksum$checksum .nes. P2 then $ -"); @   PutRecord( "  e ""-E-CHKSMFAIL, Checksum of ''P1' failed.""");   SetKeepTogether(0);    PutRecord( "$ exit");     PutRecord( "$ endsubroutine");   PutRecord( "$start:");   ENDPROCEDURE  H ! ---------------------------------------------------------------------- ! ADD EPILOGUE ! 0 !   Writes out the final part of the share file. !  !   Globals: !	NONE !q !   Inputs:w !	NONE !d !   Outputs:, !	Xbuffer					Buffer in which to write stuff !m !   Function Return Value: !	NONE !  !   Side Effects:  !	NONE ! H ! ----------------------------------------------------------------------   PROCEDURE AddEpilogue      PutRecord("$ v=f$verify(v)");a   PutRecord("$ exit");   ENDPROCEDURE    H ! +--------------------------------------------------------------------+H ! +                                                                    +H ! +            F I L E   P A C K A G I N G   R O U T I N E S           +H ! +                                                                    +H ! +   Each file taken from the parameter list is read into a buffer and+H ! +   encoded. The encoded buffer, together with a file header and     +H ! +   trailer, is then added to the existing part buffer.              +H ! +                                                                    +H ! +                                                                    +H ! +   8.5                Andy Harper                         Jun 1994  +H ! +                                                                    +H ! +                                                                    +H ! +                                                                    +H ! +                 R O U T I N E   S U M M A R Y                      +H ! +                                                                    +H ! +                                                                    +H ! +   AddFileHeader          Generate the DCL prolog for the file      +H ! +                          which copies the data to a scratch file   +H ! +                                                                    +H ! +   CreateFile             Gets the file into a buffer and encodes   +H ! +                          the data.                                 +H ! +                                                                    +H ! +   AddFileTrailer         Generates the DCL epilog for the file     +H ! +                          which generates the call to the unpacker  +H ! +                                                                    +H ! +                                                                    +H ! +   PackageFile            Master routine called to deal with a      +H ! +                          single file                               +H ! +                                                                    +H ! +--------------------------------------------------------------------+  H ! ---------------------------------------------------------------------- ! ADD FILE HEADER- !-K !   Create the initial DCL code that copies the encoded data from the shareT !   file into a temporary file.d !e !   Globals: !	NONE !o !   Inputs:  !e !   Outputs:, !	Xbuffer					Buffer in which to write stuff !  !   Function Return Value: !	NONE !  !   Side Effects:o !	NONE !iH ! ----------------------------------------------------------------------   PROCEDURE AddFileHeadero     PutRecord("$!");   PutRecord("$ create 'f'");   ENDPROCEDURE      H ! ----------------------------------------------------------------------
 ! CREATE FILEl ! G !   Get the named file into the named buffer; give up on any failure toa !   get the file.  !N !   Globals: !	NONE !r !   Inputs:r3 !	Xbuffer				Buffer in which to place file contentsA$ !	Filename			Name of file to be read !_ !   Outputs: !	NONE !  !   Function Return Value: !	NONE !r !   Side Effects:N !	NONE ! H ! ----------------------------------------------------------------------  ' PROCEDURE CreateFile(Xbuffer, Filename)Z  
   ON_ERROR?     Inform("E","FILRDERR", FAO("Error reading !AS", FileName)); 
     ABORT;   ENDON_ERROR;     ReuseBuffer(Xbuffer);s   READ_FILE(FileName);  
 ENDPROCEDURE;b iH ! ---------------------------------------------------------------------- ! ADD FILE TRAILER !TK !   Add the DCL trailer line to the file. If the resultant parameters would-J !   make the line longer than the maximum share file line length, then useL !   normal DCL continuation flags to indicate this and continue onto several	 !   linesh !,I !   NOTE: stuff generated by this routine should not be split by the part  !   buffer management routines !s !   Globals: !	NONE !  !   Inputs:s. !	Xbuffer					Buffer in which to write trailer! !	File					Name of file in buffert  !	FileAttr				Attributes of file& !	FileSize				Size of file (in blocks)! !	FileNum					Current file number	# !	FileCnt					Total number of files  !n !   Outputs: !	NONE !a !   Function Return Value: !	NONE !L !   Side Effects:n !	NONE !rH ! ----------------------------------------------------------------------  D PROCEDURE AddFileTrailer(FileName,FileAttr,FileSize,FileNum,FileCnt) LOCAL File, NewRecord;      SetKeepTogether(1);$    File      := StripFile(FileName);     NewRecord := "$ call unpack";  1  ! Add the filename, start new record if too longH2    IF LENGTH(NewRecord+File+" ")> Max_share_length	      THEN,#        PutRecord(NewRecord + " -");-        NewRecord := "";-	    ENDIF;-&    NewRecord := NewRecord +" " + File;  8  ! Add the file attributes, start new record if too long6    IF LENGTH(NewRecord+FileAttr+" ")> Max_share_length	      THENE#        PutRecord(NewRecord + " -");"        NewRecord := "";;	    ENDIF;r*    NewRecord := NewRecord +" " + FileAttr;  2  ! Add the file size, start new record if too long;    IF LENGTH(NewRecord+STR(FileSize)+" ")> Max_share_lengthL	      THENF#        PutRecord(NewRecord + " -");r        NewRecord := "";"	    ENDIF;s/    NewRecord := NewRecord +" " + STR(FileSize);   4  ! Add the file number, start new record if too long;    IF LENGTH(NewRecord+STR(FileNum)+" ") > Max_share_length:	      THENR#        PutRecord(NewRecord + " -");r        NewRecord := ""; 	    ENDIF;S.    NewRecord := NewRecord +" " + STR(FileNum);  9  ! Add the total file count, start new record if too longc:    IF LENGTH(NewRecord+STR(FileCnt)+" ")> Max_share_length	      THENi#        PutRecord(NewRecord + " -");         NewRecord := ""; 	    ENDIF; .    NewRecord := NewRecord +" " + STR(FileCnt);      PutRecord(NewRecord);    SetKeepTogether(0); ENDPROCEDURE   cH ! ---------------------------------------------------------------------- ! PACKAGE FILE !aG !   Input the contents of the specified file, encode the buffer and addiI !   it to the share file surrounded by the appropriate header and trailerE !   unpacking code.= ! E !   If the /SPLIT[=nnn] parameter has been given, then the named filelE !   is read multiple times, each time processing only as much as will;C !   fit into roughly the amount of space specified by nnn (blocks). K !   This helps to keep the amount of virtual memory usage small and reducesDI !   paging dramatically, thus speeding up the packaging process for large!H !   files. Of course, that large file is read multiple times but this is !   much faster. !" !   Globals:. !	WorkBuffer				Temp buffer used for packaging, !	Split					Max size of part being processed !h !   Inputs:t/ !	FileDetails				Details of file to be packagedh !l !   Outputs: !	NONE !m !   Function Return Value: !	NONE !e !   Side Effects:w !	NONE !nH ! ----------------------------------------------------------------------  * PROCEDURE PackageFile(FileDetails,FileNum)V LOCAL Separator,FileAttr,FileName,MaxVirtM,FileSegment,StartLine,FileBlocks,LineCount;  '    Separator := INDEX(FileDetails,' ');"2    FileName  := SUBSTR(FileDetails,1,separator-1);N    FileAttr  := SUBSTR(FileDetails,separator+1,LENGTH(FileDetails)-separator);      IF Logging >= LOG_ShowFilef	      THENKA        Inform("I","PACKFILE",FAO("Packaging file !AS",FileName));n	    ENDIF;       AddFileHeader;"    ! Initialize Globals"    OutputRecords := 0;    OutputBytes   := 0;    InputRecords  := 0;    InputBytes    := 0;    ! Initialize Segment Counters    FileSegment   := 0;    StartLine     := 0;      LOOP"&       CreateFile(WorkBuffer,FileName);=       OrigFileRecords := GET_INFO(WorkBuffer,"RECORD_COUNT");t0       OrigFileBytes   := BufferSize(WorkBuffer);  '     ! How much should we keep in memoryr       IF Split = 0&         THEN MaxVirtM := OrigFileBytes#         ELSE MaxVirtm := Split*512;s       ENDIF;    *     ! Find next file segment and encode it%       FileSegment := FileSegment + 1;uI       LineCount := GetSegment(WorkBuffer,FileSegment,StartLine,MaxVirtM);        EncodeBuffer(WorkBuffer);i    2     ! Update how much we've done; exit if complete)       StartLine := StartLine + LineCount;(+       EXITIF StartLine > OrigFileRecords-1;R    ENDLOOP;               ! Add file packaging"J    FileBlocks := (OrigFileBytes + OrigFileRecords*(EOL-1) + 511) / 512 ;  B    AddFileTrailer(FileName,FileAttr,FileBlocks,FileNum,FileCount);  
 ENDPROCEDURE;d )H ! +--------------------------------------------------------------------+H ! +   MAIN PROGRAM                                                     +H ! +                                                                    +H ! +   This is the main control loop of the program, responsible for    +H ! +   picking up the parameters, creating the prologue and epilogue of +H ! +   the share file, setting up global constants and variables etc.   +H ! +                                                                    +H ! +   It also contains the main loop which goes around each of the     +H ! +   specified files to be packed into the share file.                +H ! +                                                                    +H ! +--------------------------------------------------------------------+   ! Initialisation2   SET(SUCCESS,OFF);		! Suppress non-error messages   SET(INFORMATIONAL,OFF);"   InitializeGlobalConstants;   CreateGlobalBuffers;   FetchPackagingOptions;  <   SET(FACILITY_NAME, Facility);	! identify ourself in errorsC   IF SpaceEnc THEN Quoteable_Chars := Quoteable_Chars + " "; ENDIF;t6   MaxBytes := 512 * PartSize  -  LENGTH(FAO_end_part);    # ! Initialize miscellaneous counterso   PartNo        := 0;    OutputBytes   := 0;d   OutputRecords := 0;   & ! Create the initial share file header   InitializePartBuffer;p?   AddPrologueHeader(Archive, IdentHeader, PartSize, ParamBuff);r   AddPrologueTPUUnpacker;	   AddPrologueTrailer;     ; ! Loop around, filling the part buffer with data from files    FileNumber := 0;   LOOP3      EXITIF GET_INFO(ParamBuff,"RECORD_COUNT") = 0;k'      POSITION(BEGINNING_OF(ParamBuff));	"      FileNumber := FileNumber + 1;(      PackageFile(ERASE_LINE,FileNumber);
   ENDLOOP;    G ! Add the share file epilogue to exit cleanly, then flush the last parte   AddEpilogue;   FlushPart;    ; ! Finalize the contents of the first part and write it out.    FixUpFirstPart;I    ( ! Return part count to DCL code and exit   LogTotalParts;   QUIT;c$ $ if .not. $status then $ goto abort $ return