/*****************************************************************************
 *                                                                           *
 * xbclock.c: C-Programm Hauptmodul (X-Applikation)                          *
 *                                                                           *
 * author: -- jd --                                                          *
 * version: 040990 fuer cc auf hp 9000/300 WS                                *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * modifiziert: 240394 - stark vereinfacht und den Bug des X-Window-Absturz  *
 *                       im Monochrom-Modus beim Stundenwechsel endlich per  *
 *                       Hammer plattgemacht!                                *
 * modifiziert: 210694 - Peinlich! In Monochrom lief es so schoen, aber in   *
 *                       in Farbe nicht mehr! Jetzt hoffentlich in allen     *
 *                       Aufloesungen.                                       *
 *                                                                           *
 * Realisiert die Berlin Uhr in Farbe und in Schwarz Weiss.                  *
 * In Farbe koennen die einzelnen Farben auch per Parameter explizit         *
 * ausgewaehlt werden, sofern Windowmanager/Display Farben per Name          *
 * alloziieren laesst.                                                       *
 *                                                                           *
 *****************************************************************************
 *                                                                           *
 * $Header: xbclock.c,v 1.1 1994/03/24 12:17:38 jensd Exp jensd $            *
 *                                                                           *
 * Copyright (C) 1990, 1994 by Jens Dengler                                  *
 *                                                                           *
 * Permission to use, copy, modify, and distribute this software and its     *
 * documentation for any purpose and without fee is hereby granted, provided *
 * that the above copyright notice appear in all copies and that both that   *
 * copyright notice and this permission notice appear in supporting          *
 * documentation.  This software is provided "as is" without express or      *
 * implied warranty.                                                         *
 *                                                                           *
 *****************************************************************************/

/*** X-Konstanten, Strukturen und Variablen ***/

#include <ctype.h>
#include <stdio.h>
#include <time.h>
#include <X11/X.h>
#include <signal.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#define forever while(1)
#define MIN(a,b)((a < b)? a : b )
#define NO_WINDOW -1
#define FALSE 0
#define TRUE -1

Display    *mydisplay;
Window     mywindow;
GC         mygc;
XGCValues  GCset;
XEvent     myevent;
KeySym     mykey;
XSizeHints myhint;
int        myscreen;
Colormap   cmap;
Status     result;

/*** Eigene Konstanten, Strukturen und globale Variablen ***/

char fgcolorname[80],bgcolorname[80],bdcolorname[80],
     hoff[80],hon[80],moff[80],mon[80];
unsigned long pixels[6],fgbgbd[3];

#define HOUR_OFF (pixels[1])
#define HOUR_ON  (pixels[2])
#define MIN_OFF  (pixels[3])
#define MIN_ON   (pixels[4])

#define PATTERN_SIZE 8
static char hour_off[] = { 0x11, 0x44, 0x11, 0x44, 0x11, 0x44, 0x11, 0x44 };
static char hour_on[] = { 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55 };
static char min_on[] = { 0xff, 0x55, 0xff, 0x55, 0xff, 0x55, 0xff, 0x55 };
static char min_off[] = { 0x00, 0x55, 0x00, 0x55, 0x00, 0x55, 0x00, 0x55 };
Pixmap Hour_Off,Hour_On,Min_Off,Min_On;

unsigned long colorcount;
int bitsperRGB,verbose,regular;
char **globav;
int globac;

/******************************************************************************/
sdraw(s)
/******************************************************************************/
int s;
{  int x,y,r;

   if (colorcount < 8)
   {  XSetStipple(mydisplay,mygc,(s == 0)? Min_Off : Min_On);
   }
   else
   {  GCset.foreground = (s == 0)? MIN_OFF : MIN_ON;
      XChangeGC(mydisplay,mygc,GCForeground,&GCset);
   }
   r = MIN(myhint.width,myhint.height) / 6 - 2;
   x = myhint.x + (myhint.width / 2) - (r / 2);
   y = 0 + (myhint.height / 18);
   XFillArc(mydisplay,mywindow,mygc,x,y,r,r,0,23040);
}

/******************************************************************************/
iniclocking()
/******************************************************************************/
{  long tim; 
   int m,h,i,x,y;
   char wholetxt[48],subtxt[32];
  
   signal(SIGALRM,SIG_IGN); /* Hier wird viel gemalt, deshalb abschotten! */
   tim = time((long *) 0);
   strcpy(wholetxt,ctime(&tim));
   strcpy(subtxt,&wholetxt[11]);
   subtxt[5] = '\0';
   if (regular && tim % 60)
   {  sdraw((int) tim % 2);
   }
   else {
      XSetIconName(mydisplay,mywindow,subtxt);
      XClearWindow(mydisplay,mywindow);
  
      sdraw((int) (tim % 2));
      m = (tim / 60) % 60;
      h = atoi(subtxt);
      y = (myhint.height * 3 / 12);
      for (i = 1; i < 5; i++)
      {  if (colorcount < 8)
         {  if (h-5 >= 0)
            {  XSetStipple(mydisplay,mygc,Hour_On); h -= 5;
            }
            else XSetStipple(mydisplay,mygc,Hour_Off);
         }
         else
         {  if (h-5 >= 0)
            {  GCset.foreground = HOUR_ON; h -= 5;
            } 
            else GCset.foreground = HOUR_OFF;
            XChangeGC(mydisplay,mygc,GCForeground,&GCset);
         }
         x = myhint.x + i * (myhint.width / 6);
         XFillRectangle(mydisplay,mywindow,mygc,x,y,myhint.width / 6 - 1,myhint.height / 6 - 4);
      }
      y = (myhint.height * 5 / 12);
      for (i = 1; i < 5; i++)
      {  if (colorcount < 8)
         {  XSetStipple(mydisplay,mygc,(h > 0)? Hour_On : Hour_Off);
         }
         else
         {  GCset.foreground = (h > 0)? HOUR_ON : HOUR_OFF;
            XChangeGC(mydisplay,mygc,GCForeground,&GCset);
         }
         h--;
         x = myhint.x + i * (myhint.width / 6);
         XFillRectangle(mydisplay,mywindow,mygc,x,y,myhint.width / 6 - 1,myhint.height / 6 - 4);
      }
      y = (myhint.height * 7 / 12);
      for (i = 1; i < 12; i++)
      {  x = myhint.x + (myhint.width / 6) + i * (myhint.width / 18) - (myhint.width / 36);
         if (colorcount < 8)
         {  if (m-5 >= 0)
            {  XSetStipple(mydisplay,mygc,((i % 3) == 0)? Hour_On : Min_On); m -= 5;
            }
            else XSetStipple(mydisplay,mygc,((i % 3) == 0)? Hour_Off : Min_Off);
         }
         else
         {  if (m-5 >= 0)
            {  GCset.foreground = ((i % 3) == 0)? HOUR_ON : MIN_ON; m -= 5;
            }
            else GCset.foreground = ((i % 3) == 0)? HOUR_OFF : MIN_OFF;
            XChangeGC(mydisplay,mygc,GCForeground,&GCset);
         }
         XFillRectangle(mydisplay,mywindow,mygc,x,y,myhint.width / 18 - 1,myhint.height / 6 - 4);
      }
      y = (myhint.height * 9 / 12);
      for (i = 1; i < 5; i++)
      {  x = myhint.x + i * (myhint.width / 6);
         if (colorcount < 8)
         {  XSetStipple(mydisplay,mygc,(m > 0)? Min_On : Min_Off);
         }
         else
         {  GCset.foreground = (m > 0)? MIN_ON : MIN_OFF;
            XChangeGC(mydisplay,mygc,GCForeground,&GCset);
         }
         m--;
         XFillRectangle(mydisplay,mywindow,mygc,x,y,myhint.width / 6 - 1,myhint.height / 6 - 4);
      }
   }
   regular = TRUE;
   XFlush(mydisplay);
   signal(SIGALRM,iniclocking);
   alarm(1);
}


/*** Hauptprogramm ***/

/******************************************************************************/
main(ac,av)
/******************************************************************************/
int ac; char **av;
{  int borderlen,reverse;
   char defgeometry[80],displayname[80],globstr[80];
   unsigned int oldw,oldh,i;
   Window rootofroot;
   XWindowAttributes wind;
   Visual *visual;
   Status status;
   int flags = {DoRed | DoBlue | DoGreen};

   globav = av; globac = ac;
   strcpy(displayname,"");
   while (--ac > 0)
      if (!strcmp(*++av,"-display") && ac > 0)
      {  ac--; strcpy(displayname,*++av);
      }
   
   mydisplay = XOpenDisplay(displayname);
   if (!mydisplay)
   {  fprintf(stderr,"%s: Cannot open display: %s\n",globav[0],displayname); exit(1);
   }
   myscreen = DefaultScreen(mydisplay);

   reverse = verbose = FALSE; borderlen = 1;
   XGetWindowAttributes(mydisplay,XRootWindow(mydisplay,myscreen),&wind);
   strcpy(fgcolorname,"Black"); strcpy(bgcolorname,"White"); strcpy(bdcolorname,"Black");
   strcpy(hoff,"Red"); strcpy(hon,"Pink"); strcpy(moff,"Orange"); strcpy(mon,"Yellow");
   oldh = myhint.height = 100;
   oldw = myhint.width = 150;
   myhint.x = wind.x + (wind.width - myhint.width) / 2;
   myhint.y = wind.y + (wind.height - myhint.height) / 2;
   sprintf(defgeometry,"%dx%d+%d+%d",myhint.width,myhint.height,myhint.x,myhint.y);
   av = globav; ac = globac;
   while (--ac > 0)
   {  ++av;
      if (!strcmp(*av,"-rv")) reverse = TRUE;
      else if (!strcmp(*av,"-bg") && ac > 0)
      {  ac--; strcpy(bgcolorname,*++av); 
      }
      else if (!strcmp(*av,"-fg") && ac > 0)
      {  ac--; strcpy(fgcolorname,*++av);
      }
      else if (!strcmp(*av,"-bd") && ac > 0)
      {  ac--; strcpy(bdcolorname,*++av);
      }
      else if (!strcmp(*av,"-hour_off") && ac > 0)
      {  ac--; strcpy(hoff,*++av);
      }
      else if (!strcmp(*av,"-hour_on") && ac > 0)
      {  ac--; strcpy(hon,*++av);
      }
      else if (!strcmp(*av,"-min_off") && ac > 0)
      {  ac--; strcpy(moff,*++av);
      }
      else if (!strcmp(*av,"-min_on") && ac > 0)
      {  ac--; strcpy(mon,*++av);
      }
      else if (!strcmp(*av,"-bw") && ac > 0)
      {  ac--; borderlen = atoi(*++av);
      }
      else if (!strcmp(*av,"-geometry") && ac > 0)
      {  ac--; strcpy(globstr,*++av);
         XGeometry(mydisplay,myscreen,globstr,defgeometry,borderlen,
                   1,1,0,0,&myhint.x,&myhint.y,&myhint.width,&myhint.height);
      }
      else if (!strcmp(*av,"-verbose") || !strcmp(*av,"-h")) verbose = TRUE;
   }
   if (verbose)
   {  printf("\nThe D.Binninger Berlin clock for X displays\nSee man-page for interpretation and further options.\n\nPress any key with mouse in clock window to quit.\n\n");
   }
   visual = XDefaultVisual(mydisplay,myscreen);
   colorcount = visual->map_entries;
   if (verbose)
      fprintf(stderr,"Display shall provide %ld colors\n",colorcount);
   if (visual->class == GrayScale)
   {  fprintf(stderr,"But only in grey shades!\n");
   }
   else if (visual->class == TrueColor)
   {  fprintf(stderr,"Sorry, colormap not changeable\n");
   }
   bitsperRGB = visual->bits_per_rgb;
   if (verbose) fprintf(stderr,"Colordepth is %d bits\n",bitsperRGB);
   cmap = DefaultColormap(mydisplay,myscreen);

   if (colorcount > 8)
   {  result = XAllocColorCells(mydisplay,cmap,FALSE,NULL,0,pixels,6);
      if (verbose) fprintf(stderr,"AllocColorCells returns %d.\n",result);
      if (result)
      {  XStoreNamedColor(mydisplay,cmap,hoff,HOUR_OFF,flags);
         XStoreNamedColor(mydisplay,cmap,hon,HOUR_ON,flags);
         XStoreNamedColor(mydisplay,cmap,moff,MIN_OFF,flags);
         XStoreNamedColor(mydisplay,cmap,mon,MIN_ON,flags);
      }
   }
   XFlush(mydisplay);
   if (colorcount > 8 && (strcmp(fgcolorname,"Black") || strcmp(bgcolorname,"White") || strcmp(bdcolorname,"Black")))
   {  result = XAllocColorCells(mydisplay,cmap,FALSE,NULL,0,fgbgbd,3);
      if (!result) fprintf(stderr,"%s: Can't allocate additional color cells\n",globav[0]);
   }
   else result = FALSE;
   
   if (!result)
   {  fgbgbd[0] = (reverse? (WhitePixel(mydisplay,myscreen)) : (BlackPixel(mydisplay,myscreen)));
      fgbgbd[1] = (reverse? (BlackPixel(mydisplay,myscreen)) : (WhitePixel(mydisplay,myscreen)));
      fgbgbd[2] = (reverse? (WhitePixel(mydisplay,myscreen)) : (BlackPixel(mydisplay,myscreen)));
   }
   else
   {  XStoreNamedColor(mydisplay,cmap,(reverse? bgcolorname : fgcolorname),fgbgbd[0],flags);
      XStoreNamedColor(mydisplay,cmap,(reverse? fgcolorname : bgcolorname),fgbgbd[1],flags);
      XStoreNamedColor(mydisplay,cmap,bdcolorname,fgbgbd[2],flags);
   }

   if (verbose) fprintf(stderr,"Window specification: fg=%ld bg=%ld bd=%ld bw=%d\n",fgbgbd[0],fgbgbd[1],fgbgbd[2],borderlen);
   mywindow = XCreateSimpleWindow(mydisplay,DefaultRootWindow(mydisplay),
                                  myhint.x,myhint.y,myhint.width,myhint.height,
                                  borderlen,fgbgbd[0],fgbgbd[1]);
   XSetWindowBorder(mydisplay,mywindow,fgbgbd[2]);
   
   myhint.flags = PPosition | PSize;
   XSetStandardProperties(mydisplay,mywindow,"bclock","bclock",None,globav,globac,&myhint);
   mygc = XCreateGC(mydisplay,mywindow,0,0);
   XSetBackground(mydisplay,mygc,fgbgbd[1]);
   XSetForeground(mydisplay,mygc,fgbgbd[0]);
   if (colorcount <= 8)
   {  Hour_Off = XCreateBitmapFromData(mydisplay,mywindow,hour_off,PATTERN_SIZE,PATTERN_SIZE);
      Hour_On = XCreateBitmapFromData(mydisplay,mywindow,hour_on,PATTERN_SIZE,PATTERN_SIZE);
      Min_Off = XCreateBitmapFromData(mydisplay,mywindow,min_off,PATTERN_SIZE,PATTERN_SIZE);
      Min_On = XCreateBitmapFromData(mydisplay,mywindow,min_on,PATTERN_SIZE,PATTERN_SIZE);
      XSetFillStyle(mydisplay,mygc,FillOpaqueStippled);
   }

   XSelectInput(mydisplay,mywindow,ExposureMask|ButtonPressMask|KeyPressMask);

   XMapRaised(mydisplay,mywindow); /* Jetzt wird das Fenster angezeigt */

   XGetGeometry(mydisplay,mywindow,&rootofroot,
                 &wind.x,&wind.y,&wind.width,&wind.height,
                 &wind.border_width,&wind.depth);
   myhint.x = 0;
   myhint.y = 0;
   myhint.width = oldw = wind.width;
   myhint.height = oldh = wind.height;
   iniclocking();
   rootofroot = DefaultRootWindow(mydisplay);
   forever
   {  regular = FALSE;
      XNextEvent(mydisplay,&myevent);
      switch(myevent.type)
      {  case Expose:
            XGetGeometry(mydisplay,mywindow,&rootofroot,
                          &wind.x,&wind.y,&wind.width,&wind.height,
                          &wind.border_width,&wind.depth);
            if (oldw == wind.width || oldh == wind.height)
            {  iniclocking(); break;
            }
            myhint.x = wind.x;
            myhint.y = wind.y;
            myhint.width = oldw = wind.width;
            myhint.height = oldh = wind.height;

            XResizeWindow(mydisplay,mywindow,wind.width,wind.height);
            sprintf(globstr,"%dx%d+%d+%d",wind.width,wind.height,wind.x,wind.y);
            if (verbose) fprintf(stderr,"Geometry: %s\n",globstr);
            XGeometry(mydisplay,myscreen,globstr,defgeometry,borderlen,
                      1,1,0,0,&wind.x,&wind.y,&wind.width,&wind.height);
            iniclocking();
            break;
         case ButtonPress:
            iniclocking();
            break;
         case KeyPress:
            goto bye;
      }
   }
   bye:
   XFreeGC(mydisplay,mygc);
   XDestroyWindow(mydisplay,mywindow);
   XCloseDisplay(mydisplay);
   exit(0);
}
