.TH XBCLOCK 1 "March 24th, 1994" "X Version 11"
.SH NAME
xbclock - D. Binninger's Berlin clock for X displays
.SH SYNOPSIS
.B xbclock
 [options]
.SH DESCRIPTION
The
.I xbclock 
program displays the time in algebraic form. The seconds are represented with
the round pump at the top of the clock. Each of the four rectangles below the
pump representing 5 hours. Each of the four rectangles below this representing
1 hour. To get the actual 24 hour time you must add the litted rectangles
(i.e. the rectangles on the left with the same color/stipple).

In the row below each of the smaller rectangles represents 5 minutes. For
the terms of readability the rectangles of every quarter hour are in the same
color/stipple as the rectangles above. In the last row each of the four
rectangles represents 1 minute.

The time is continuously updated at a frequency of one second.
This clock could
also be used at black and white displays but with fixed stipples.
.SH OPTIONS
.I xbclock
accepts most of the standard X Toolkit command line options along with the 
additional options listed below:
.TP 8
.B \-min_off \fIcolorname\fP
This option let the user specify the color of the light representing
1 or 5 minutes off. The default color is orange. This option has no
effects when used on screens with less than 9 colors.
.TP 8
.B \-min_on \fIcolorname\fP
This option let the user specify the color of the light representing
1 or 5 minutes on. The default color is yellow. This option has no
effects when used on screens with less than 9 colors.
.TP 8
.B \-hour_off \fIcolorname\fP
This option let the user specify the color of the light representing
1, 5 or quarterly hours off. The default color is red. This option has no
effects when used on screens with less than 9 colors.
.TP 8
.B \-hour_on \fIcolorname\fP
This option let the user specify the color of the light representing
1, 5 or quarterly hours on. The default color is pink. This option has no
effects when used on screens with less than 9 colors.
.TP 8
.B \-verbose
This option tolds \fIxbclock\fP to print out further informations.
.TP 8
.B \-h
Same as verbose.
.PP
The following standard X Toolkit command line arguments are commonly used with 
.I xbclock:
.TP 8
.B \-bd \fIcolor\fP
This option specifies the color to use for the border of the window.  
The default is \fIBlack\fP.
.TP 8
.B \-bg \fIcolor\fP
This option specifies the color to use for the background of the window.  
The default is \fIWhite\fP.
.TP 8
.B \-bw \fInumber\fP
This option specifies the width in pixels of the border surrounding the window.
.TP 8
.B \-fg \fIcolor\fP
This option specifies the color to use for displaying text. 
The default is \fIBlack\fP.
.TP 8
.B \-rv
This option indicates that reverse video should be simulated by swapping
the foreground and background colors.
.TP 8
.B \-geometry \fIgeometry\fP
This option specifies the preferred size and position of the clock window.
.TP 8
.B \-display \fIhost\fP:\fIdisplay\fP
This option specifies the X server to contact.
.SH X DEFAULTS
This program don't uses the 
.I Clock
widget in the X Toolkit or any other Toolkit functions.
.SH "SEE ALSO"
X(1), time(3C)
.SH ENVIRONMENT
.B DISPLAY
\- the default host and display number.
.SH BUGS
.I xbclock
believes the system clock and uses ctime to generate icon title.
.PP
.I xbclock
uses XStoreNamedColor to generate colors.
.I xbclock
do not always center the 5 minute rectangles correctly. It depends on the clock dimensions.
.PP
The program don't models the original clock exactly, for instance at 00:00
the original clock actually shows 24:00 (all hour lights on) for one minute
and then switches to 00:01. The program displays 00:00 as given by time(3C).
.SH AUTHOR
Jens Dengler (TUB)

