 /* **++ **  FACILITY:	NEWSRDR  **8 **  ABSTRACT:	Build a ZIP command to make a NEWSRDR kit. ** **  MODULE DESCRIPTION:  ** **  	tbs ** **  AUTHOR: 	    M. Madison I **  	    	    COPYRIGHT  1992, MATTHEW D. MADISON.  ALL RIGHTS RESERVED.  ** **  CREATION DATE:  13-SEP-1992  ** **  MODIFICATION HISTORY:  **1 **  	13-SEP-1992 V1.0    Madison 	Initial coding.  **-- */ #include <stdio.h> #include <descrip.h> #include <string.h>  #include <stsdef.h>  #include <stdlib.h>  #include <rms.h> #include <ssdef.h>
 #ifdef __DECC  #include <starlet.h> #endif  Q #define INIT_DYNDESC(str) {str.dsc$w_length = 0; str.dsc$a_pointer = (void *) 0;\ K     	    str.dsc$b_class = DSC$K_CLASS_D; str.dsc$b_dtype = DSC$K_DTYPE_T;} Q #define INIT_SDESC(str,len,ptr) {str.dsc$w_length=(len);str.dsc$a_pointer=(ptr);\ G     	    str.dsc$b_class=DSC$K_CLASS_S; str.dsc$b_dtype=DSC$K_DTYPE_T;}        struct UNIT {      	struct FAB fab;     	struct RAB rab;     	struct NAM nam;     	struct XABFHC xabfhc;!     	char espec[256], rspec[256];      };  ;     unsigned int file_create(), file_write(), file_close();    /* **++ **  ROUTINE:	make_zip  ** **  FUNCTIONAL DESCRIPTION:  ** **  	tbs **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int make_zip() {   $     struct dsc$descriptor str, sdsc;/     char *cp, *base, rspec[256], tmp[1024], *s;      unsigned int status, unit;       INIT_DYNDESC(str);#     status = lib$get_foreign(&str); 4     if (!$VMS_STATUS_SUCCESS(status)) return status;#     s = malloc(str.dsc$w_length+1); 3     memcpy(s, str.dsc$a_pointer, str.dsc$w_length); !     *(s+str.dsc$w_length) = '\0'; I     status = file_create("SYS$SCRATCH:ZIP-NEWSRDR.COM", &unit, 0, rspec); 4     if (!$VMS_STATUS_SUCCESS(status)) return status;8     status = file_write(unit, "$ v = 'f$verify(0)", 18);2     status = file_write(unit, "$ set verify", 12);     cp = s+strlen(s);      while (*cp != ' ') cp--;/     sprintf(tmp, "$ pkzip -@ \"-V\" %s", cp+1); 0     status = file_write(unit, tmp, strlen(tmp));     *cp = '\0';   
     base = s;      while (1) {      	cp = strchr(base, ',');%     	if (!cp) cp = base+strlen(base); %     	file_write(unit, base, cp-base);      	if (!*cp) break;      	base = cp+1;      } 8     status = file_write(unit, "$ v = 'f$verify(0)", 18);'     sprintf(tmp, "$ delete %s", rspec); '     file_write(unit, tmp, strlen(tmp));      file_close(unit);      sprintf(tmp, "@%s", rspec); '     INIT_SDESC(sdsc, strlen(tmp), tmp); !     return lib$do_command(&sdsc);    } /* make_zip */   /* **++ **  ROUTINE:	file_create ** **  FUNCTIONAL DESCRIPTION:  *** **  	Creates a new file, open for writing. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	file_create (fspec, unit) ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */G unsigned int file_create(char *fspec, struct UNIT **upp, char *defspec, '     	    	    	    	    	char *rspec) {        struct UNIT *u;      unsigned int status;  $     u = malloc(sizeof(struct UNIT));     if (!u) return SS$_INSFMEM;      u->fab = cc$rms_fab;     u->rab = cc$rms_rab;     u->nam = cc$rms_nam;     u->fab.fab$l_fna = fspec; %     u->fab.fab$b_fns = strlen(fspec);      if (defspec) {      	u->fab.fab$l_dna = defspec;(     	u->fab.fab$b_dns = strlen(defspec);     } -     u->fab.fab$l_fop = FAB$M_SQO | FAB$M_DFW; !     u->fab.fab$b_fac = FAB$M_PUT;       u->fab.fab$b_rat = FAB$M_CR;!     u->fab.fab$b_rfm = FAB$C_VAR;      u->fab.fab$w_mrs = 0;       u->nam.nam$l_esa = u->espec;*     u->nam.nam$b_ess = sizeof(u->espec)-1;      u->nam.nam$l_rsa = u->rspec;*     u->nam.nam$b_rss = sizeof(u->rspec)-1;!     u->fab.fab$l_nam = &(u->nam); !     u->rab.rab$l_fab = &(u->fab); "     u->rab.rab$l_rop |= RAB$M_WBH;'     status = sys$create(&(u->fab),0,0); &     if ($VMS_STATUS_SUCCESS(status)) {'     	u->rspec[u->nam.nam$b_rsl] = '\0'; )     	status = sys$connect(&(u->rab),0,0); '     	if ($VMS_STATUS_SUCCESS(status)) {      	    *upp = u;,     	    if (rspec) strcpy(rspec, u->rspec);     	    return status;      	}#     	u->fab.fab$l_fop |= FAB$M_DLT;      	sys$close(&(u->fab),0,0);     }      free(u);     return status;   } /* file_create */    /* **++ **  ROUTINE:	file_close  ** **  FUNCTIONAL DESCRIPTION:  **6 **  	Closes a file opened by file_open or file_create. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */) unsigned int file_close(struct UNIT *u) {        unsigned int status;  "     sys$disconnect(&(u->rab),0,0);&     status = sys$close(&(u->fab),0,0);     free(u);     return status;   }    /* **++ **  ROUTINE:	file_write  ** **  FUNCTIONAL DESCRIPTION:  ** **  	Writes a record to a file.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	tbs ** **  IMPLICIT INPUTS:	None. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES:  ** ** **  SIDE EFFECTS:   	None. ** **-- */B unsigned int file_write(struct UNIT *u, char *buf, int buf_size) {       u->rab.rab$l_rbf = buf;       u->rab.rab$w_rsz = buf_size;"     return sys$put(&(u->rab),0,0);   } 