/*	simulate SHELL redirection for VAXC
	w.j.m. feb 86
	fix aug 86 wjm
	mod apr 87 wjm: allow for ">>"
	mod 26-may-1990 wjm: use "mbc=16" for efficiency (seq. I/O only!)

usage:

	main(argc,argv)
	int argc; char **argv;
	{
	#ifdef VAXC
		redirect(&argc,&argv);
	#endif
		...

bugs:
	does not handle redirection of stderr.

	overwrites argument vector (*argv).

*/

#include stdio
#include stdlib
#include perror
#include errno

static myerr(str,flag)
char *str; int flag;
{
	fprintf(stderr,"%%-F-REDIRECT, %s\n",str);
	if(flag) {
		exit(vaxc$errno);
	} else	exit(0x10000004);
}

redirect(argcp,argvp)
int *argcp; char ***argvp;
{
	char **av,**nav;
	int ac,nac;
	int inx = 0, outx = 0;

	av = nav = *argvp;
	ac = *argcp;

	if(ac <= 0) return;		/* no arg, no action */

	av++; nav++; ac--; nac = 1;	/* 1st arg untouched */

	for( ; ac > 0; av++, ac--) {
		switch(**av) {
		  case '<':
			if(inx++) myerr("double input redirection",0);
			if((stdin=freopen(*av+1,"r",stdin,"mbc=16"))==NULL)
				myerr("cannot redirect stdin",1);
			break;
		  case '>':
			if(outx++) myerr("double output redirection",0);
			if(*(*av+1) == '>') {
				if((stdout=freopen(*av+2,"a",stdout,"mbc=16"))==NULL)
					myerr("cannot redirect stdout",1);
			} else {
				if((stdout=freopen(*av+1,"w",stdout,"mbc=16"))==NULL)
					myerr("cannot redirect stdout",1);
			}
			break;
		  default:
			*nav++ = *av; nac++;
		}
	}

	/* note: K&R does not say that argv[argc] == NULL */

	*argcp = nac;
}
