/****************************************************************************/
/*
                                 HprintS.c

Hyper-PRINT-Server.

CGI-compliant script.

A simple HTTP script to allow point-and-click printing of files from within 
Hypertext documents.  This is limited to clients within the Division (for 
obvious reasons!).  Print queues available are hard-coded for efficiency and 
ease-of-implementation (HFRD's print queues are stable enough to allow this). 


BUILD DETAILS
-------------
See BUILD_HPRINTS.COM procedure.


VERSION HISTORY
---------------
13-DEC-95  MGD  v2.1.2, LAS1,LAS7 bite the dust
19-SEP-95  MGD  v2.1.1, replace <CR><LF> carriage-control with single newline
24-MAY-95  MGD  v2.1.0, minor changes for AXP compatibility
29-MAR-95  MGD  v2.0.0, modified for CGI-compliance
05-DEC-94  MGD  v1.1.0, new URL mapping functions, minor revisions
12-SEP-94  MGD  v1.0.0, initial development
*/
/****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [] = "HPRINTS AXP-2.1.2";
#else
   char SoftwareID [] = "HPRINTS VAX-2.1.2";
#endif

/* standard C header files */
#include <stdio.h>
#include <ctype.h>
#include <errno.h>

/* VMS-related header files */
#include <descrip.h>
#include <libdef.h>
#include <quidef.h>
#include <rmsdef.h>
#include <sjcdef.h>
#include <ssdef.h>
#include <stsdef.h>

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#define boolean int
#define true 1
#define false 0

#define VMSok(x) (x) & STS$M_SUCCESS
#define VMSnok(x) !((x) & STS$M_SUCCESS)

/*
The "#" symbol indicates that this print queue support the  "NUMBER_UP="
ScriptPrinter parameter and is capable of printing more than one output page
per sheet.  The "+" symbol indicates the printer supports double-sided printing
using the ScriptPrinter "SIDES=" parameter.
*/
#define TextQueueList "LAS2#+,LAS3#,LAS4#,LAS5#,LAS6#,LP1,LP2,LP3"
#define PostScriptQueueList "PSLAS2#+,PSLAS3,PSLAS4#,PSLAS5,PSLAS6"

char Http200Header [] =
"HTTP/1.0 200 Document follows.\n\
Content-Type: text/html\n\
\n";

char Http404Header [] =
"HTTP/1.0 404 Error report follows.\n\
Content-Type: text/html\n\
\n";

char  Utility [] = "HPRINTS";

boolean  Debug,
         HttpHasBeenOutput;

char  CgiPathInfo [256],
      CgiPathTranslated [256],
      CgiRemoteHost [128],
      CgiRequestMethod [32],
      CgiScriptName [256],
      FormQueue [256],
      FormPages [16],
      FormSides [16],
      FormMenu [16];
      
FILE  *HttpOut;

/****************************************************************************/
/*
*/

int main
(
int argc,
char* argv[]
)
{
   register int  acnt;
   register char  *cptr, *sptr;

   int  status;
   FILE  *PrintFile;

   /*********/
   /* begin */
   /*********/

#ifdef __DECC
   if ((HttpOut = fopen ("SYS$OUTPUT", "w", "ctx=bin")) == NULL)
      exit (vaxc$errno);
#else
   if ((HttpOut = fopen ("SYS$OUTPUT", "w", "rfm=udf")) == NULL)
      exit (vaxc$errno);
#endif

   /***********************************/
   /* get the command line parameters */
   /***********************************/

   for (acnt = 1; acnt < argc; acnt++)
   {
      if (Debug) fprintf (stdout, "argv[%d] |%s|\n", acnt, argv[acnt]);
      if (strsame (argv[acnt], "/DBUG", -1))
      {
         Debug = true;
         continue;
      }
      fprintf (stdout, "%%%s-E-IVQUAL, unrecognized qualifier\n \\%s\\\n",
               Utility, argv[acnt]+1);
      exit (STS$K_ERROR | STS$M_INHIB_MSG);
   }

   /*************************/
   /* get the CGI variables */
   /*************************/

   CgiRemoteHost[0] = '\0';
   GetCgiVariable ("WWW_REMOTE_HOST", CgiRemoteHost, sizeof(CgiRemoteHost));

   if (!AcceptClient (CgiRemoteHost)) exit (SS$_NORMAL);

   GetCgiVariable ("WWW_PATH_INFO", CgiPathInfo, sizeof(CgiPathInfo));
   GetCgiVariable ("WWW_PATH_TRANSLATED",
                   CgiPathTranslated, sizeof(CgiPathTranslated));
   GetCgiVariable ("WWW_REQUEST_METHOD", CgiRequestMethod, sizeof(CgiRequestMethod));
   GetCgiVariable ("WWW_SCRIPT_NAME", CgiScriptName, sizeof(CgiScriptName));

   FormQueue[0] = FormPages[0] = FormSides[0] = FormMenu[0] = '\0';
   GetCgiVariable ("WWW_FORM_QUEUE", FormQueue, sizeof(FormQueue));
   GetCgiVariable ("WWW_FORM_PAGES", FormPages, sizeof(FormPages));
   GetCgiVariable ("WWW_FORM_SIDES", FormSides, sizeof(FormSides));
   GetCgiVariable ("WWW_FORM_MENU", FormMenu, sizeof(FormMenu));

   /***********/
   /* process */
   /***********/

   if (!CgiPathInfo[0] || (CgiPathInfo[0] == '/' && !CgiPathInfo[1]))
   {
      ErrorGeneral ("Please specify a document path.", __FILE__, __LINE__);
      exit (SS$_NORMAL);
   }

   /* check the file exists */
   if ((PrintFile = fopen (CgiPathTranslated, "r")) == NULL)
   {
      status = vaxc$errno;
      ErrorVmsStatus (status, CgiPathInfo, CgiPathTranslated, __FILE__, __LINE__);
      exit (SS$_NORMAL);
   }
   fclose (PrintFile);

   /*
      If a print queue parameter was supplied then it is being submitted
      for printing.  If no print queue was supplied then it is requesting
      a print queue be selected.
   */
   if (FormQueue[0])
      SubmitPrintJob ();
   else
   {
      if (FormMenu[0])
      {
         ErrorGeneral ("Please select a print queue.", __FILE__, __LINE__);
         exit (SS$_NORMAL);
      }
      SelectPrinter ();
   }

   exit (SS$_NORMAL);
}

/****************************************************************************/
/*
Check if this system belongs to the HFRD domain.  Return true if it does.  
Send an explanatory message to the client if it doesn't, and return false.
*/

boolean AcceptClient (char *HostName)

{
   register char  *cptr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "AcceptClient() |%s|\n", HostName);

   for (cptr = HostName; *cptr && *cptr != '.'; cptr++);
   if (strsame (cptr, ".hfrd.dsto.gov.au", -1)) return (true);

   ErrorGeneral ("Sorry! This facility is only available to HFRD clients.",
                 __FILE__, __LINE__);
   return (false);
}

/****************************************************************************/
/*
Using the <FORM> tag provide the client with a list of print queues selectable 
for the print job.
*/ 

SelectPrinter ()

{
   register char  *cptr, *sptr, *zptr;

   boolean  NumberUpSupported = false,
            SidesTwoSupported = false;
   char  Comment [256],
         PrintQueueName [256];
   char  *QueueList;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SelectPrinter()\n");

   /* determine file extension and associated queue type */
   for (cptr = sptr = CgiPathInfo; *cptr; cptr++)
      if (*cptr == '/') sptr = cptr;
   while (*sptr && *sptr != '.') sptr++;
   if (strsame (sptr, ".PS", -1))
      QueueList = PostScriptQueueList;
   else
      QueueList = TextQueueList;

   /**************************************/
   /* HTTP header and HTML start of form */
   /**************************************/

   fprintf (HttpOut,
"%s\
<!-- SoftwareID: %s -->\n\
<TITLE>Printing %s</TITLE>\n\
<H1>Select Print Queue</H1>\n\
<H2>Printing <TT>%s</TT></H2>\n\
<FORM ACTION=\"%s%s\">\n\
<INPUT TYPE=hidden NAME=\"menu\" VALUE=\"yes\">\n",
   Http200Header, SoftwareID, CgiPathInfo, CgiPathInfo, CgiScriptName, CgiPathInfo);
   HttpHasBeenOutput = true;

   /****************************************************/
   /* check if any printer queues support fancy stuff! */
   /****************************************************/

   cptr = QueueList;
   while (*cptr)
   {
      sptr = PrintQueueName;
      while (*cptr && *cptr != ',' && *cptr != '#' && *cptr != '+')
          *sptr++ = *cptr++;
      *sptr = '\0';

      while (*cptr == '#' || *cptr == '+')
      {
         if (*cptr == '#') NumberUpSupported = true;
         if (*cptr == '+') SidesTwoSupported = true;
         cptr++;
      }

      /* step over the comma */
      if (*cptr) cptr++;
   }

   if (NumberUpSupported)
   {
      fprintf (HttpOut,
"<P>On supported printers ...\n\
<P><INPUT TYPE=checkbox NAME=\"pages\" VALUE=\"2\">\
 Check this box to <B>conserve paper</B> (2 document pages per sheet).\n");
   }

   if (NumberUpSupported && SidesTwoSupported)
      fputs ("<BR>", HttpOut);
   else
      fputs ("<P>On supported printers ...\n<P>", HttpOut);

   if (SidesTwoSupported)
   {
      fprintf (HttpOut,
"<INPUT TYPE=checkbox NAME=\"sides\" VALUE=\"2\">\
 Check this box to <B>print on both sides</B> of each sheet.\n");
   }

   fputs ("<P><HR>\n", HttpOut);

   /******************************************/
   /* provide a radio box selector of queues */
   /******************************************/

   cptr = QueueList;
   while (*cptr)
   {
      sptr = PrintQueueName;
      while (*cptr && *cptr != ',' && *cptr != '#' && *cptr != '+')
          *sptr++ = *cptr++;
      *sptr = '\0';

      if (*cptr == '#' || *cptr == '+')
      {
         strcpy (zptr = Comment, " <I>(supports ");
         while (*zptr) zptr++;
         while (*cptr == '#' || *cptr == '+')
         {
            if (Comment[14]) *zptr++ = ',';
            if (*cptr == '#')
            {
               strcpy (zptr, " multipage");
               while (*zptr) zptr++;
               cptr++;
               continue;
            }
            if (*cptr == '+')
            {
               strcpy (zptr, " double-sided");
               while (*zptr) zptr++;
               cptr++;
               continue;
            }
         }
         strcpy (zptr, ")</I>");
      }
      else
         Comment[0] = '\0';

      fprintf (HttpOut,
      "<BR><INPUT TYPE=radio NAME=\"queue\" VALUE=\"%s\"> %s%s\n",
      PrintQueueName, PrintQueueName, Comment);

      /* step over the comma */
      if (*cptr) cptr++;
   }

   /***************************/
   /* rest of HTML form, etc. */
   /***************************/

   fprintf (HttpOut,
"<P><HR>\n\
<P><INPUT TYPE=submit VALUE=\"print\"> \
(<B>to cancel</B> this print use your browser to <B>navigate backwards</B>)\n\
</FORM>\n");
}

/*****************************************************************************/
/*
Using system service $SNDJBCW, submit the job for printing.
*/

SubmitPrintJob ()

{
   unsigned short  Length; 
   int  status;
   char  JobStatusOutput [256];
   struct {
      short BufferLength;
      short ItemCode;
      void  *BufferPtr;
      void  *LengthPtr;
   } items [4], NullItem = {0,0,0,0};
   int  icnt;
   struct VMSiosb {
      int  Status;
      int  DeviceInfo;
   } IOsb;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "SubmitPrintJob() |%s|\n", CgiPathTranslated);

   icnt = 0;

   items[icnt].BufferLength = strlen(FormQueue);
   items[icnt].ItemCode = SJC$_QUEUE;
   items[icnt].BufferPtr = FormQueue;
   items[icnt++].LengthPtr = 0;

   if (FormPages[0] == '2')
   {
      items[icnt].BufferLength = 11;
      items[icnt].ItemCode = SJC$_PARAMETER_1;
      items[icnt].BufferPtr = "NUMBER_UP=2";
      items[icnt++].LengthPtr = 0;
   }

   if (FormSides[0] == '2')
   {
      items[icnt].BufferLength = 9;
      items[icnt].ItemCode = SJC$_PARAMETER_2;
      items[icnt].BufferPtr = "SIDES=TWO";
      items[icnt++].LengthPtr = 0;
   }

   items[icnt] = NullItem;

   status = sys$sndjbcw (0, SJC$_CREATE_JOB, 0, &items, &IOsb, 0, 0);

   if (VMSok (status)) status = IOsb.Status;
   if (VMSnok (status))
   {
      ErrorVmsStatus (status, CgiPathInfo, CgiPathTranslated, __FILE__, __LINE__);
      return (status);
   }

   icnt = 0;
   items[icnt].BufferLength = strlen(CgiPathTranslated);
   items[icnt].ItemCode = SJC$_FILE_SPECIFICATION;
   items[icnt].BufferPtr = CgiPathTranslated;
   items[icnt++].LengthPtr = 0;
   items[icnt] = NullItem;

   status = sys$sndjbcw (0, SJC$_ADD_FILE, 0, &items, 0, 0, 0);

   if (VMSok (status)) status = IOsb.Status;
   if (VMSnok (status))
   {
      ErrorVmsStatus (status, CgiPathInfo, CgiPathTranslated, __FILE__, __LINE__);
      return (IOsb.Status);
   }

   icnt = 0;
   items[icnt].BufferLength = sizeof(JobStatusOutput)-1;
   items[icnt].ItemCode = SJC$_JOB_STATUS_OUTPUT;
   items[icnt].BufferPtr = JobStatusOutput;
   items[icnt++].LengthPtr = &Length;
   items[icnt] = NullItem;

   status = sys$sndjbcw (0, SJC$_CLOSE_JOB, 0, &items, 0, 0, 0);

   if (VMSok (status)) status = IOsb.Status;
   if (VMSnok (status))
   {
      ErrorVmsStatus (status, CgiPathInfo, CgiPathTranslated, __FILE__, __LINE__);
      return (status);
   }

   JobStatusOutput[Length] = '\0';

   /***************************************/
   /* advise the client of the job status */
   /***************************************/

   fprintf (HttpOut,
"%s\
<TITLE>Printing %s</TITLE>\n\
<H1>Print Job Submitted</H1>\n\
<H2>Printing <TT>%s</TT> to %s</H2>\n\
<PRE>%s</PRE>\n\
<P>\n\
(Do <B>not</B> use your browser's <TT>RELOAD</TT> button/keystroke, \n\
it will cause another print to be submitted!  Use your browser's\n\
<TT>BACK</TT> button/keystroke to <B>navigate backwards</B>)\n",
   Http200Header, CgiPathInfo, CgiPathInfo, FormQueue, JobStatusOutput);
   HttpHasBeenOutput = true;

   return (status);
}

/*****************************************************************************/
/*
Get the contents of the DCL symbol corresponding to the 'VariableName'.
*/

int GetCgiVariable
(
char *VariableName,
char *VariableValue,
int VariableValueSize
)
{
   static $DESCRIPTOR (VariableNameDsc, "");
   static $DESCRIPTOR (VariableValueDsc, "");

   register int  status;

   unsigned short  Length;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "GetCgiVariable() |%s|\n", VariableName);

   VariableNameDsc.dsc$w_length = strlen(VariableName);
   VariableNameDsc.dsc$a_pointer = VariableName;
   VariableValueDsc.dsc$w_length = VariableValueSize-1;
   VariableValueDsc.dsc$a_pointer = VariableValue;

   if (VMSok (status =
       lib$get_symbol (&VariableNameDsc, &VariableValueDsc, &Length, 0)))
      VariableValue[Length] = '\0';
   else
      VariableValue[0] = '\0';

   if (status == LIB$_NOSUCHSYM) return (-1);
   if (VMSnok (status))
   {
      if (Debug) fprintf (stdout, "lib$get_symbol() %%X%08.08X\n", status);
      exit (status);
   }
   if (Debug) fprintf (stdout, "|%s|\n", VariableValue);
   return (Length);
}

/*****************************************************************************/
/*
*/

ErrorGeneral
(
char *Text,
char *SourceFileName,
int SourceLineNumber
)
{
   register char  *cptr;

   /*********/
   /* begin */
   /*********/

   /* 
      The source file format provided by the "__FILE__" macro will be
      "device:[directory]name.type;ver".  Reduce that to "name.type".
   */
   for (cptr = SourceFileName; *cptr && *cptr != ';'; cptr++);
   if (*cptr)
   {
      while (*cptr != '.') cptr--;
      *cptr-- = '\0';
   }
   while (*cptr != ']') cptr--;
   cptr++;

   if (!HttpHasBeenOutput) fputs (Http404Header, HttpOut);
   fprintf (HttpOut,
"<!-- SoftwareID: %s Module: %s Line: %d -->\n\
<H1>ERROR!</H1>\n\
<P>Reported by server.\n\
<P>%s\n",
   SoftwareID, cptr, SourceLineNumber, Text);
}

/*****************************************************************************/
/*
*/

ErrorVmsStatus
(
int StatusValue,
char *Text,
char *HiddenText,
char *SourceFileName,
int SourceLineNumber
)
{
   static char  Message [256];
   static $DESCRIPTOR (MessageDsc, Message);

   register char  *cptr;
   int  status;
   short int  Length;

   /*********/
   /* begin */
   /*********/

   if (VMSok (status = sys$getmsg (StatusValue, &Length, &MessageDsc, 1, 0))) 
   {
      Message[Length] = '\0';
      Message[0] = toupper(Message[0]);
   }
   else
      exit (status);

   /* 
      The source file format provided by the "__FILE__" macro will be
      "device:[directory]name.type;ver".  Reduce that to "name.type".
   */
   for (cptr = SourceFileName; *cptr && *cptr != ';'; cptr++);
   if (*cptr)
   {
      while (*cptr != '.') cptr--;
      *cptr-- = '\0';
   }
   while (*cptr != ']') cptr--;
   cptr++;

   if (!HttpHasBeenOutput) fputs (Http404Header, HttpOut);
   fprintf (HttpOut,
"<!-- SoftwareID: %s Module: %s Line: %d -->\n\
<H1>ERROR!</H1>\n\
<P>Reported by server.\n\
<P>%s ... <TT>%s</TT>\n\
<!-- %%X%08.08X \"%s\" -->\n",
   SoftwareID, cptr, SourceLineNumber, Message, Text, StatusValue, HiddenText);
}

/****************************************************************************/
/*
Does a case-insensitive, character-by-character string compare and returns 
true if two strings are the same, or false if not.  If a maximum number of 
characters are specified only those will be compared, if the entire strings 
should be compared then specify the number of characters as 0.
*/ 
 
boolean strsame
(
register char *sptr1,
register char *sptr2,
register int  count
)
{
   while (*sptr1 && *sptr2)
   {
      if (toupper (*sptr1++) != toupper (*sptr2++)) return (false);
      if (count)
         if (!--count) return (true);
   }
   if (*sptr1 || *sptr2)
      return (false);
   else
      return (true);
}
 
/****************************************************************************/

