/*****************************************************************************
/*
                                 HTTPd.h

Header file for HFRD VMS HTTP daemon.


VERSION HISTORY
---------------
01-DEC-95  MGD  v3.0.0, HTTPd version 3
20-DEC-94  MGD  v2.0.0, multi-threaded version
20-JUN-94  MGD  v1.0.0, single-threaded version
*/
/*****************************************************************************/

#include <descrip.h>
#include <rms.h>
#include <rmsdef.h>

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

/**********/
/* macros */
/**********/

#define boolean int
#define true 1
#define false 0

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) (!((x) & STS$M_SUCCESS))

#define HttpProtocol "HTTP/1.0"

#define ConfigFileName "HTTPD$CONFIG"
#define MapFileName "HTTPD$MAP"

#define DefaultMaxConcurrentConnections 10

#define DefaultInputTimeoutMinutes 2
#define DefaultOutputTimeoutMinutes 10

#define DefaultDclSysOutputSize 4096
#define DefaultFileBufferSize 1024
#define DefaultNetReadBufferSize 2048
#define DefaultOutputBufferSize 4096

#define DefaultDirListingLayout "I__L__R__S__D"

#define MaxRequestAccept 64

/* some constants for controlling logging */
#define LOGGING_BEGIN 1
#define LOGGING_END 2
#define LOGGING_OPEN 3
#define LOGGING_CLOSE 4
#define LOGGING_FLUSH 5
#define LOGGING_ENTRY 6

/* input/output timeout constants */
#define TIMEOUT_INITIALIZE 0
#define TIMEOUT_INPUT 1
#define TIMEOUT_OUTPUT 2

#define EncapsulateDataBegin "\n<PRE>"
#define EncapsulateDataEnd "</PRE>\n"

/*******************/
/* data structures */
/*******************/

# pragma member_alignment __save
# pragma nomember_alignment

struct VmsItem
{
   unsigned short  buf_len;
   unsigned short  item;
   unsigned char   *buf_addr;
   unsigned short  *ret_len;
};

struct AnExitHandler
{
   unsigned long  Flink;
   unsigned long  HandlerAddress;
   unsigned long  ArgCount;
   unsigned long  ExitStatusPtr;
};

struct AnIOsb
{
   unsigned short  Status;
   unsigned short  Count;
   unsigned long  Unused;
};

struct HeapStruct
{
   struct HeapStruct  *PrevPtr;
   struct HeapStruct  *NextPtr;
   unsigned int  ChunkSize;
   /* the actual data follows immediately after the length */
};

#pragma member_alignment __restore

/*
   Store these structures naturally-aligned on AXP.
   Uses a bit more storage but makes access as efficient as possible.
*/

#ifdef __ALPHA
#   pragma member_alignment __save
#   pragma member_alignment
#endif

/***********************************/
/* server configuration structures */
/***********************************/

#define MaxConfigHomePages 16
#define MaxConfigReadMeFiles 16

struct ContentTypeStruct
{
   struct ContentTypeStruct  *NextPtr;
   char  *SuffixPtr;
   char  *ContentTypePtr;
   char  *AutoScriptNamePtr;
   char  *ContentDescriptionPtr;
   boolean  BinaryEncoding;
   /* string data is stored here and pointed to by above pointers */
};

struct IconStruct
{
   struct IconStruct  *NextPtr;
   /* string data is stored here (immediately following 'NextPtr') */
};

struct ConfigStruct
{
   boolean  AuthLocalEnabled,
            DirAccess,
            DirAccessSelective,
            DirOwnerEnabled,
            DirReadMeBottom,
            DirReadMeTop,
            DirWildcardEnabled,
            DnsLookup,
            ErrorRecommend,
            IncludeCommentedInfo,
            LoggingEnabled,
            MonitorEnabled,
            ShtmlEnabled,
            ShtmlAccessesEnabled,
            ShtmlExecEnabled;

   int  AcceptHostsLength,
        Busy,
        ProblemCount,
        HomePageCount,
        InputTimeoutMinutes,
        OutputTimeoutMinutes,
        ReadMeFileCount,
        RejectHostsLength,
        ServerPort;

   char  DefaultDirLayout [32],
         KeywordSearch [128];

   char  *AcceptHostsPtr,
         *HomePageArray [MaxConfigHomePages],
         *DefaultPost,
         *HtmlContentType,
         *IsMapContentType,
         *MenuContentType,
         *PlainTextContentType,
         *ReadMeFileArray [MaxConfigReadMeFiles],
         *RejectHostsPtr,
         *ShtmlContentType;

   struct ContentTypeStruct  *ContentTypeListHeadPtr,
                             *ContentTypeListTailPtr;
   int  ContentTypeStructOverhead;

   struct IconStruct  *IconListHeadPtr,
                      *IconListTailPtr;
   int  IconStructOverhead;
};

/***********************/
/* per-server counters */
/***********************/

struct AccountingStruct
{
   /* this MUST be the first member to allow zeroing of the rest */
   unsigned long  ZeroedCount;

   unsigned long  ConnectAcceptedCount,
                  ConnectCallocFailCount,
                  ConnectCount,
                  ConnectCurrent,
                  ConnectPeak,
                  ConnectRejectedCount,
                  ConnectTooBusyCount,
                  DclExecutedCount,
                  DclExecutedMoreThanOnceCount,
                  DoAutoScriptCount,
                  DoDirectoryCount,
                  DoInternalCount,
                  DoIsMapCount,
                  DoScriptCount,
                  DoFileCount,
                  DoFileNotModifiedCount,
                  DoMenuCount,
                  DoMenuNotModifiedCount,
                  DoShtmlCount,
                  HeapCallocFailCount,
                  HeapReallocFailCount,
                  LastExitStatus,
                  MethodGetCount,
                  MethodHeadCount,
                  MethodPostCount,
                  RedirectLocalCount,
                  RedirectRemoteCount,
                  RequestErrorCount,
                  RequestForbiddenCount,
                  RequestParseCount,
                  RequestRmsErrorCount,
                  StartupCount;

   unsigned long  QuadBytesRx [2],
                  QuadBytesTx [2];

   unsigned long  ResponseStatusCodeCountArray [6];
};

/*****************************/
/* per-thread data structure */
/*****************************/

struct RequestStruct
{
   /***************************/
   /* general purpose storage */
   /***************************/

   boolean  /* file to be sent record-by-record, or binary 512 byte blocks */
            BinaryEncoding,
            /* escapes HTML-forbidden characters as sent to client */
            BufferOutputEscapeHtml,
            /* */
            MethodGet,
            /* */
            MethodHead,
            /* */
            MethodPost,
            /* generate and send an HTTP response header */
            SendHttpHeader;

   int  /* change the server count data, possible values are 0, 1, 2 */
        AdjustAccounting,
        /* processing request header, count to find first blank line */
        HeaderConsecutiveNewLineCount,
        /* length of error message */
        ErrorMessageLength,
        /* in request processing, counts number of "Accept:"s in header */
        HttpAcceptCount,
        /* size of network read buffer */
        NetReadBufferSize,
        /* size of output buffer */
        OutputBufferSize,
        /* number of characters up until the blank line */
        RequestHeaderLength,
        /* numeric equivalent of the "200", "302", etc., HTTP status code */
        ResponseStatusCode,
        /* avoid redirection loops by keeping track of the number */
        RedirectionCount;

   unsigned long  /* count of total bytes received from the client */
                  BytesRx,
                  /* count of total bytes sent to the client */
                  BytesTx,
                  /* number of bytes still available in output buffer */
                  OutputBufferRemaining;

   unsigned long  /* 64 bit VMS internal time, start of request processing */
                  BinaryTime [2],
                  /* 64 bit VMS internal time, "If-Modified-Since:" header */
                  IfModifiedSinceBinaryTime [2];

   unsigned short  /* channel to client's TCP/IP device */
                   ClientChannel;

   unsigned short  /* component equivalent of 'BinaryTime' */
                   NumericTime [7];

   unsigned char  /* pointer to file's automatic-scripting script name */
                  *AutoScriptNamePtr,
                  /* acts as a "cache" pointer for any previous match */
                  *ConfigPrevIconPtr,
                  /* acts as a "cache" pointer for any previous match */
                  *ConfigPrevContentTypePtr,
                  /* pointer to file's textual content description */
                  *ContentDescriptionPtr,
                  /* pointer to file's MIME content type */
                  *ContentTypePtr,
                  /* pointer to error message */
                  *ErrorMessagePtr,
                  /* pointer to explanation when generating error report */
                  *ErrorTextPtr,
                  /* pointer to hidden explanation (often file name) */
                  *ErrorHiddenTextPtr,
                  /* pointer to heap storage of "Authorization:" field */
                  *HttpAuthorizationPtr,
                  /* pointer to heap storage of "If-Modified-Since:" field */
                  *HttpIfModifiedSincePtr,
                  /* pointer to heap storage of "Referer:" field */
                  *HttpRefererPtr,
                  /* pointer to heap storage of "User-Agent:" field */
                  *HttpUserAgentPtr,
                  /* pointer to heap storage of redirection location path */
                  *LocationPtr,
                  /* pointer to heap storage for output buffering */
                  *OutputBufferPtr,
                  /* pointer used to point into 'Buffer' storage */
                  *OutputBufferCurrentPtr,
                  /* pointer to heap storage for output double-buffering */
                  *OutputDoubleBufferPtr,
                  /* pointer to heap storage of request path */
                  *PathInfoPtr,
                  /* stream's MIME content type */
                  *PostContentTypePtr,
                  /* pointer to heap storage of request query string */
                  *QueryStringPtr,
                  /* pointer to request header (static buffer or heap) */
                  *RequestHeaderPtr,
                  /* pointer to response header */
                  *ResponseHeaderPtr;

   unsigned char  /* pointers to heap storage of "Accept:" fields */
                  *HttpAcceptPtrArray [MaxRequestAccept],
                  /* pointer to heap storage client-read network buffering */
                  *NetReadBufferPtr;

   unsigned char  /* authorization realm name */
                  AuthRealm [17],
                  /* authorization type (e.g. "BASIC", "DIGEST", etc. */
                  AuthType [17],
                  /* internet host/domain name of client */
                  ClientHostName [128],
                  /* numeric host/domain address of client */
                  ClientInternetAddress [32],
                  /* "Content-Length:" field ... ? */
                  ContentLength [16],
                  /* sys$parse(), sys$search() storage */
                  ExpandedDirSpec [256],
                  /* sys$parse(), sys$search() storage */
                  ExpandedFileName [256],
                  /* sys$parse(), sys$search() storage */
                  FileName [256],
                  /* GMT-adjusted string equivalent of 'BinaryTime' */
                  GmDateTime [32],
                  /* the request's HTTP method */
                  Method [32],
                  /* VMS equivalent of request path */
                  PathTranslated [256],
                  /* authenticated user name from "Authorization:" */
                  RemoteUser [17],
                  /* storage when authenticating remote user */
                  RemoteUserPassword [17],
                  /* mapped script name */
                  ScriptName [64];

   /* storage for maintaining the thread's heap storage */
   struct HeapStruct  *HeapHeadPtr;
   struct HeapStruct  *HeapTailPtr;
   int  HeapSize;

   /* I/O status blocks */
   struct AnIOsb  NetReadIOsb,
                  NetWriteIOsb;

   /* pointers to functions used for specifying the next major task */
   void (*NextTaskFunction)(struct RequestStruct*);

   /* RMS structures used for various file processing purposes */
   struct FAB  FileFab;
   struct RAB  FileRab;
   struct NAM  FileNam;
   struct XABFHC  FileXabFhc;
   struct XABDAT  FileXabDat;
   struct FAB  SearchFab;
   struct NAM  SearchNam;

   /****************************************/
   /* storage specific to the DCL.c module */
   /****************************************/

   boolean  /* add a newline to each record from a script subprocess */
            DclAddNewline,
            /* when script subprocess output still within HTTP header */
            DclCheckSubprocessResponseHeader,
            /* DCL has been executed some time during request processing */
            DclHasBeenExecuting;

   int  /* count of client I/Os still to be read by subprocess */
        DclOutstandingClientRead,
        /* count of I/Os between subprocess and HTTPd still outstanding */
        DclOutstandingIO,
        /* size of DCL subprocess' SYS$OUTPUT buffer */
        DclSysOutputSize;
   unsigned long  /* subprocess' exit status */
                  DclSubprocessCompletionStatus,
                  /* subprocess' PID */
                  DclSubprocessPid;

   unsigned short  /* channel to subprocess' HTTP$INPUT mailbox */
                   DclHttpInputChannel,
                   /* channel to subprocess' SYS$INPUT mailbox */
                   DclSysInputChannel,
                   /* channel to subprocess' SYS$OUTPUT mailbox */
                   DclSysOutputChannel;

   unsigned char  /* heap storage for buffering subprocess' SYS$OUTPUT */
                  *DclSysOutputPtr;

   unsigned char  /* device name of subprocess' HTTP input mailbox */
                  HttpInputDevName [64],
                  /* device name of subprocess' input mailbox */
                  SysInputDevName [64],
                  /* device name of subprocess' output mailbox */
                  SysOutputDevName [64];

   struct AnIOsb  DclHttpInputIOsb,
                  DclSysInputIOsb,
                  DclSysOutputIOsb;

   /* string descriptors for the various mailbox device names */
   struct dsc$descriptor_s HttpInputDevNameDsc;
   struct dsc$descriptor_s SysInputDevNameDsc;
   struct dsc$descriptor_s SysOutputDevNameDsc;

   /**********************************************/
   /* storage specific to the Directory.c module */
   /**********************************************/

   boolean  /* disables auto-scripting appending version */
            AutoScriptEnabled,
            /* getting description from HTML, inside <TITLE></TITLE> tag */
            DirInsideDescription,
            /* a <TITLE></TITLE> description has been retrieved from HTML */
            DirDescriptionRetrieved,
            /* present a directory listing ("Index of") in a VMS-style */
            DirFormatVms;

   int  /* count of directories in listing */
        DirDirectoryCount,
        /* internal description, number of lines checked from each file */
        DirDescriptionLineCount,
        /* */
        DirFieldWidthCdt,
        /* */
        DirFieldWidthName,
        /* */
        DirFieldWidthOwner,
        /* */
        DirFieldWidthRdt,
        /* */
        DirFieldWidthSize,
        /* */
        DirLayoutFaoLength, 
        /* */
        DirLayoutHeadingLength, 
        /* count of number of files in listing */
        DirFileCount,
        /* internal description, number of "<" encountered */
        DirClosingTagCount,
        /* internal description, number of ">" encountered */
        DirOpeningTagCount;

   unsigned long  /* for directory module, file's allocated blocks */
                  DirTotalAllocatedBlocks,
                  /* for directory module, file's used blocks */
                  DirTotalUsedBlocks;

   unsigned char  /* pointer used when generating directory listings */
                  *DirDescriptionPtr,
                  /* pointer to heap storage URL equivalent of directory */
                  *DirDirectoryPathPtr,
                  /* pointer to heap storage of dynamic record buffer */
                  *DirFileBufferPtr,
                  /* pointer to column headings string */
                  *DirLayoutHeadingPtr,
                  /* pointer to directory layout string */
                  *DirLayoutPtr,
                  /* pointer to sys$fao() directive string */
                  *DirLayoutFaoPtr,
                  /* request path for directory module */
                  *DirPathInfoPtr,
                  /* query string for directory module */
                  *DirQueryStringPtr,
                  /* space for generating file's description */
                  InternalDescription [256];

   unsigned char  /* directory part of file specification */
                  DirDirectoryPart [256],
                  /* file part of file specification */
                  DirFilePart [128],
                  /* prepended script name */
                  DirScriptName [64],
                  /* directory specification */
                  DirSpec [256];

   /******************************************/
   /* storage specific to the IsMap.c module */
   /******************************************/

   int  /* character number currently being parsed (for error information) */
        IsMapCharNumber,
        /* line number in current line (for error information) */
        IsMapLineNumber;
   double  /* keeps track of closest 'point x,y' (if any) */
           IsMapClosestPoint;
   double  /* stores the numeric equivalent of the browser x,y click point */
           IsMapClickCoord [2];
   unsigned char  /* pointer to heap storage of dynamic record buffer */
                  *IsMapBufferPtr;

   /*****************************************/
   /* storage specific to the File.c module */
   /*****************************************/

   boolean  /* when true a file's contents are enclosed in <PRE></PRE> tag */
            FileEncapsulateData,
            /* when true HTML-forbidden characters are escaped */
            FileEscapeHtml;
   int  /* size of buffer for escaping HTML */
        FileEscapeHtmlSize;
   unsigned char  /* pointer to buffer used to escape HTML-forbidden chars */
                  *FileEscapeHtmlPtr;

   /*****************************************/
   /* storage specific to the Menu.c module */
   /*****************************************/

   int  /* used to count consecutive blank lines */
        MenuBlankLineCount,
        /* used to count consecutive non-blank lines */
        MenuLineCount,
        /* used to count total number of sections */
        MenuSectionCount,
        /* used to track current section number */
        MenuSectionNumber;
   unsigned char  /* pointer to heap storage of dynamic record buffer */
                  *MenuBufferPtr;

   /******************************************/
   /* storage specific to the sHTML.c module */
   /******************************************/

   int  /* line number currently being parsed (for error information) */
        ShtmlLineNumber;

   unsigned char  /* pointer to heap storage of dynamic record buffer */
                  *ShtmlBufferPtr,
                  /* file name */
                  ShtmlFileName [256],
                  /* current character position when parsing task file lines */
                  *ShtmlParsePtr,
                  /* pointer to heap storage containing size format string */
                  *ShtmlSizeFmtPtr,
                  /* pointer to heap storage containing time format string */
                  *ShtmlTimeFmtPtr;
                                    
   struct FAB  ShtmlFileFab;
   struct NAM  ShtmlFileNam;
   struct RAB  ShtmlFileRab;
   struct XABDAT  ShtmlFileXabDat;
   struct XABPRO  ShtmlFileXabPro;
};

#ifdef __ALPHA
#   pragma member_alignment __restore
#endif

/*****************************************************************************/

