/*****************************************************************************/
/*
                                  hWP.c

CGI-compliant script to (attempt to) display WordPerfect source files as 
hypertext documents.  WordPerfect internal format does not appear to be 
document anywhere, so this rather imperfect program was created by dumping 
WordPerfect document and attempting to deduce the internal structure.  Hence 
it works (just) for simple documents but may be grossly inadequite for 
anything else!


CGI VARIABLE NAMES
------------------
WWW_PATH_INFO           the URL path component
WWW_HTTP_REFERER        the document containing the anchor to this script
WWW_SCRIPT_NAME         the name of the script being executed
WWW_SERVER_NAME         the server TCP/IP host name
WWW_SERVER_PORT         the server TCP/IP port number

WWW_FORM_DO             specifies the function
WWW_FORM_HWP            non-empty, indicates it came from DocumentNotSpecified()
WWW_FORM_REFERER        the original document containingg anchor to this script
WWW_FORM_REVEAL         reveal WP formatting "C"odes, or "D"dump codes
WWW_FORM_TOPICINDEX     if "NO" or "FALSE" then do not generate a topic index


BUILD
-----
See BUILD_HWP.COM


VERSION HISTORY
---------------
This may never get to version 1.n.n unless some technical information on the
structure of WordPerfect files comes to light!

26-SEP-95  MGD  v0.1.0, initial development
*/
/*****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [] = "HWP AXP-0.1.0";
#else
   char SoftwareID [] = "HWP VAX-0.1.0";
#endif

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <errno.h>
#include <unixio.h>
#include <file.h>

#include <descrip.h>
#include <rms.h>
#include <ssdef.h>
#include <stsdef.h>

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) !(((x) & STS$M_SUCCESS))

#define boolean int
#define true 1
#define false 0

/* macro provides NULL pointer if CGI variable does not exist */
#define GetCgiVarIfExists(CharPointer,CgiVariableName) \
   CharPointer = getenv(CgiVariableName)

/* macro provides pointer to empty string even if CGI variable does not exist */
#define GetCgiVar(CharPointer,CgiVariableName) \
   if ((CharPointer = getenv(CgiVariableName)) == NULL) \
       CharPointer = ""; \
   if (Debug) fprintf (stdout, "%s |%s|\n", CgiVariableName, CharPointer);

#define WpReadChunk 16384

char  Utility [] = "HWP";

char  Http200Header [] =
"HTTP/1.0 200 Document follows.\r\n\
Content-Type: text/html\r\n\
\r\n";

char  Http404Header [] =
"HTTP/1.0 404 Error report follows.\r\n\
Content-Type: text/html\r\n\
\r\n";

char ErrorMemoryAllocation [] = "Memory allocation failed!";

boolean  AnchorText,
         BuildTopicIndex,
         Debug,
         HttpHasBeenOutput,
         DocumentText,
         ProvideRevealCodes = false,
         RevealCodes,
         RevealDump,
         RomanPageNumbers,
         WildCardDocument;

int  AnchorTextCount,
     BoldCount,
     CentreCount,
     DocumentByteCount,
     DocumentCount,
     ItalicCount,
     MarkNumber,
     PageNumber,
     PreviousPageNumber,
     TableCount,
     SectionNumber,
     UnderlineCount,
     WpFileFd;

char  WpFileSpec [256],
      WpFileName [256],
      IconImg [256];

char  *CgiFormDoPtr,
      *CgiFormRefererPtr,
      *CgiFormRevealPtr,
      *CgiFormTopicIndexPtr,
      *CgiHttpRefererPtr,
      *CgiPathInfoPtr,
      *CgiPathTranslatedPtr,
      *CgiScriptNamePtr,
      *CgiServerNamePtr,
      *CgiServerPortPtr,
      *DocCharPtr,
      *HelpUrlPtr,
      *IconUrlPtr,
      *OriginalRefererPtr,
      *PageTitlePtr,
      *WpFileNamePtr;

unsigned char  *DocumentPtr;
      
FILE  *HttpOut;

struct FAB  WpFileFab;
struct NAM  WpFileNam;

char *CurrentPageNumber ();

/*****************************************************************************/
/*
*/

main
(
int argc,
char *argv[]
)
{
   register char  *cptr, *sptr;

   int  acnt;

   /*********/
   /* begin */
   /*********/

   /* open another output stream so that the '\r' and '\n' are not filtered */
#ifdef __DECC
   if ((HttpOut = fopen ("SYS$OUTPUT", "w", "ctx=bin")) == NULL)
      exit (vaxc$errno);
#else
   if ((HttpOut = fopen ("SYS$OUTPUT", "w", "rfm=udf")) == NULL)
      exit (vaxc$errno);
#endif

   /***********************************/
   /* get the command line parameters */
   /***********************************/

   /* doing it this way, parameters must be space separated! */
   HelpUrlPtr = IconUrlPtr = "";
   for (acnt = 1; acnt < argc; acnt++)
   {
      if (Debug) fprintf (stdout, "argv[%d] |%s|\n", acnt, argv[acnt]);
      if (strsame (argv[acnt], "/DBUG", -1))
      {
         Debug = true;
         continue;
      }
      if (strsame (argv[acnt], "/HELP=", 6))
      {
         HelpUrlPtr = argv[acnt]+6;
         continue;
      }
      if (strsame (argv[acnt], "/ICON=", 6))
      {
         IconUrlPtr = argv[acnt]+6;
         continue;
      }
      fprintf (stdout, "%%%s-E-IVQUAL, unrecognized qualifier\n \\%s\\\n",
               Utility, argv[acnt]+1);
      exit (STS$K_ERROR | STS$M_INHIB_MSG);
   }

   /*********************/
   /* get CGI variables */
   /*********************/

   GetCgiVar (CgiScriptNamePtr, "WWW_SCRIPT_NAME");
   if (CgiScriptNamePtr == NULL) CgiScriptNamePtr = "";

   /*
      Get the database file specification from path info.
      CGI variable 'database' overrides anything in the path.
   */
   GetCgiVar (CgiPathInfoPtr, "WWW_PATH_INFO");
   GetCgiVar (CgiPathTranslatedPtr, "WWW_PATH_TRANSLATED");
   if (CgiPathTranslatedPtr[0])
      cptr = CgiPathTranslatedPtr;
   else
   {
      cptr = CgiPathInfoPtr;
      if (*cptr == '/') cptr++;
   }
   sptr = WpFileSpec;
   while (*cptr)
   {
      if (*cptr == '*' || *cptr == '%') WildCardDocument = true;
      *sptr++ = toupper(*cptr++);
   }
   *sptr = '\0';
   if (sptr > WpFileSpec)
      if (sptr[-1] == ']') WildCardDocument = true;

   /*
      If a document link has a 'FORM_REFERER' CGI variable then use that
      to return to th original document (it is progated from hWP link to
      link.  If not, and a 'HTTP_REFERER' is present, use that.
      Otherwise, use nothing at all!
   */
   GetCgiVar (CgiHttpRefererPtr, "WWW_HTTP_REFERER");
   GetCgiVar (CgiFormRefererPtr, "WWW_FORM_REFERER");
   if (CgiFormRefererPtr[0])
      OriginalRefererPtr = CgiFormRefererPtr;
   else
   if (CgiHttpRefererPtr[0])
      OriginalRefererPtr = CgiHttpRefererPtr;
   else
      OriginalRefererPtr = "";

   GetCgiVar (CgiFormRevealPtr, "WWW_FORM_REVEAL");
   if (toupper(CgiFormRevealPtr[0]) == 'C')
      RevealCodes = true;
   else
   if (toupper(CgiFormRevealPtr[0]) == 'D')
      RevealCodes = RevealDump = true;
   else
      RevealCodes = RevealDump = false;

   GetCgiVar (CgiFormTopicIndexPtr, "WWW_FORM_TOPICINDEX");

   GetCgiVar (PageTitlePtr, "WWW_FORM_TITLE");

   GetCgiVar (CgiFormDoPtr, "WWW_FORM_DO");

   /***********************/
   /* execute the request */
   /***********************/

   if (IconUrlPtr[0])
      sprintf (IconImg, "<IMG SRC=\"%s?do=icon\" ALT=\"Hyper-WordPerfect, \">",
               CgiScriptNamePtr);
   else
      strcpy (IconImg, "Hyper-WordPerfect, ");

   if (toupper(CgiFormDoPtr[0]) == 'H')  /* 'H'elp */
   {
      /* redirect this request */
      GetCgiVar (CgiServerNamePtr, "WWW_SERVER_NAME");
      GetCgiVar (CgiServerPortPtr, "WWW_SERVER_PORT");
      if (!CgiServerPortPtr[0]) CgiServerPortPtr = "80";
      /*
         This allows a '#'-delimited local part of a URL to be included
         for any "do=help", specifying a location within the help document,
         using the syntax "do=help%%23local-part", etc.
      */
      if (strlen (CgiFormDoPtr) < 4) CgiFormDoPtr = "help";
      fprintf (HttpOut,
"HTTP/1.0 302 Redirection.\r\n\
Location: http://%s:%s%s%s\r\n\
\r\n",
      CgiServerNamePtr, CgiServerPortPtr, HelpUrlPtr, CgiFormDoPtr+4);
      exit (SS$_NORMAL);
   }

   if (toupper(CgiFormDoPtr[0]) == 'I')  /* 'I'con */
   {
      /* redirect this request */
      GetCgiVar (CgiServerNamePtr, "WWW_SERVER_NAME");
      GetCgiVar (CgiServerPortPtr, "WWW_SERVER_PORT");
      if (!CgiServerPortPtr[0]) CgiServerPortPtr = "80";
      fprintf (HttpOut,
"HTTP/1.0 302 Redirection.\r\n\
Location: http://%s:%s%s\r\n\
\r\n",
      CgiServerNamePtr, CgiServerPortPtr, IconUrlPtr);
      exit (SS$_NORMAL);
   }

   if (!WpFileSpec[0])
      DocumentNotSpecified ();
   else
   if (!CgiFormDoPtr[0] && WildCardDocument)
      IndexWildCardDocument ();
   else
      ProcessDocumentSpec ();

   exit (SS$_NORMAL);
}

/****************************************************************************/
/*
Parse the file specification.  This make the various components of any 
filename available.
*/ 

ProcessDocumentSpec ()

{
   int  status;
   char  ExpandedFileSpec [256];

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ProcessDocumentSpec()\n");

   /* initialize the file access block */
   WpFileFab = cc$rms_fab;
   WpFileFab.fab$l_fna = WpFileSpec;
   WpFileFab.fab$b_fns = strlen(WpFileSpec);
   WpFileFab.fab$l_dna = "*.WP;";
   WpFileFab.fab$b_dns = 5;
   WpFileFab.fab$l_fop = FAB$V_NAM;
   WpFileFab.fab$l_nam = &WpFileNam;

   /* initialize the file name block */
   WpFileNam = cc$rms_nam;
   WpFileNam.nam$l_esa = ExpandedFileSpec;
   WpFileNam.nam$b_ess = sizeof(ExpandedFileSpec)-1;
   WpFileNam.nam$l_rsa = WpFileName;
   WpFileNam.nam$b_rss = sizeof(WpFileName)-1;

   if (VMSnok (status = sys$parse (&WpFileFab, 0, 0)))
   {
      ErrorVmsStatus (status, WpFileSpec, WpFileSpec, __FILE__, __LINE__);
      return;
   }

   while (VMSok (status = sys$search (&WpFileFab, 0, 0)))
   {
      /* ignore other than ".WP;", ".WP5", ".WPD" */
      if (*(unsigned long*)WpFileNam.nam$l_type != 0x3b50572e &&
          *(unsigned long*)WpFileNam.nam$l_type != 0x3550572e &&
          *(unsigned long*)WpFileNam.nam$l_type != 0x4450572e) continue;

      DocumentCount++;
      WpFileNamePtr = WpFileNam.nam$l_name;
      if (!PageTitlePtr[0]) PageTitlePtr = WpFileNamePtr;
      *(char*)WpFileNam.nam$l_ver = '\0';
      ProcessDocumentFile ();
      *(char*)WpFileNam.nam$l_ver = ';';
   }
   if (status != RMS$_NMF)
   {
      *(char*)WpFileNam.nam$l_ver = '\0';
      ErrorVmsStatus (status, WpFileName, WpFileName, __FILE__, __LINE__);
      return;
   }
}

/*****************************************************************************/
/*
Open the specified WordPerfect file, load it into dynamic memory, close the 
file.  Document is now pointed at by 'DocumentPtr', and contains 
'DocumentByteCount' bytes.
*/ 

ProcessDocumentFile ()

{
   int  ByteCount;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ProcessDocumentFile() |%s|\n", WpFileName);

   WpFileFd = open (WpFileName, O_RDONLY, 0, "ctx=stm", "shr=get");
   if (WpFileFd == -1)
   {
       ErrorVmsStatus (vaxc$errno, PageTitlePtr, WpFileName,
                       __FILE__, __LINE__);
       exit (SS$_NORMAL);
   }

   DocumentPtr = NULL;
   DocumentByteCount = ByteCount = 0;
   for (;;)
   {
      if ((DocumentPtr =
           realloc (DocumentPtr, DocumentByteCount + WpReadChunk)) == NULL)
      {
         ErrorGeneral (ErrorMemoryAllocation, __FILE__, __LINE__);
         exit (SS$_NORMAL);
      }
      ByteCount = read (WpFileFd, DocumentPtr+DocumentByteCount, WpReadChunk);
      if (ByteCount > 0) DocumentByteCount += ByteCount;
      if (Debug)
         fprintf (stdout, "DocumentByteCount: %d ByteCount: %d\n",
                  DocumentByteCount, ByteCount);
      if (ByteCount < WpReadChunk) break;
   }

   if (ByteCount < 0)
   {
       ErrorVmsStatus (vaxc$errno, PageTitlePtr, WpFileName,
                       __FILE__, __LINE__);
       exit (SS$_NORMAL);
   }

   close (WpFileFd);

   if (Debug) fprintf (stdout, "DocumentByteCount: %d\n", DocumentByteCount);

   ProcessDocument ();

   free (DocumentPtr);

   fclose (HttpOut);
}

/*****************************************************************************/
/*
*/ 

int ProcessDocument ()

{
   register unsigned char  *dptr, *zptr;

   int  HeaderLength;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "ProcessDocument()\n");

   zptr = (dptr = DocumentPtr) + DocumentByteCount - 1;

   if (dptr[0] != 0xff || dptr[1] != 'W' || dptr[2] != 'P' || dptr[3] != 'C')
   {
      ErrorGeneral ("Does not appear to be a WordPerfect document!",
                    __FILE__, __LINE__);
      exit (SS$_NORMAL);
   }

   HeaderLength = *((unsigned long*)(dptr+4));
   if (HeaderLength)
   {
      if (DocumentPtr + HeaderLength > zptr)
      {
         ErrorGeneral ("Header does not make sense!", __FILE__, __LINE__);
         exit (SS$_NORMAL);
      }
      else
         dptr += HeaderLength;
   }

   fprintf (HttpOut,
"%s\
<!-- SoftwareID: %s -->\n\
<!-- %s -->\n\
<!-- Document: %d bytes Header: %d bytes -->\n\
<TITLE>Hyper-WordPerfect, %s</TITLE>\n\
<H1>%s%s</H1>\n\
<A HREF=\"%s?do=help\"><I>Help</I></A>; \
Get the <A HREF=\"%s;0\"><I>Source Document</I></A>",
   Http200Header,
   SoftwareID,
   WpFileName, 
   DocumentByteCount, HeaderLength,
   PageTitlePtr,
   IconImg, PageTitlePtr,
   CgiScriptNamePtr, CgiPathInfoPtr);
   HttpHasBeenOutput = true;

   if (ProvideRevealCodes)
   {
      fprintf (HttpOut,
"; <A HREF=\"%s%s?reveal=codes\"><I>Reveal</I></A> Codes; \
<A HREF=\"%s%s?reveal=dump\"><I>Dump</I></A> Codes",
      CgiScriptNamePtr, CgiPathInfoPtr, CgiScriptNamePtr, CgiPathInfoPtr); 
   }

   fputs (".<BR>\n", HttpOut);

   if (RevealCodes)
      fprintf (HttpOut, "<BR><TT>%s</TT><BR>\n", WpFileName);

   DocumentText = false;

   if (toupper(CgiFormTopicIndexPtr[0]) != 'N' &&
       toupper(CgiFormTopicIndexPtr[0]) != 'F') 
   {
      BuildTopicIndex = true;
      ProcessDocumentBody (dptr, zptr);
   }

   BuildTopicIndex = false;
   ProcessDocumentBody (dptr, zptr);
}

/*****************************************************************************/
/*
*/ 

int ProcessDocumentBody
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   static char  KludgeString [] = "?";

   register int  ccnt;

   /*********/
   /* begin */
   /*********/

   PageNumber = 1;
   MarkNumber = PreviousPageNumber = SectionNumber = 0;
   RomanPageNumbers = true;
   ccnt = 0;

   while (dptr <= zptr)
   {
      if (*dptr > 31 && *dptr < 127)
      {
         /***********************/
         /* printable character */
         /***********************/

         if (PageNumber != PreviousPageNumber) NewPage ();

         if (DocumentText || AnchorText)
         {
            if (AnchorText) AnchorTextCount++;
            switch (*dptr)
            {
               /* escape relevant HTML-forbidden characters */
               case '<' : fputs ("&lt;", HttpOut); break;
               case '>' : fputs ("&gt;", HttpOut); break;
               case '&' : fputs ("&amp;", HttpOut); break;
               default :
                  /* fputc() seems to cause problems, hence this kludge! */
                  *KludgeString = *dptr;
                  fputs (KludgeString, HttpOut);
            }
            if (ccnt++ > 80 && isspace(*dptr)) 
            {
               fputs ("\n", HttpOut);
               ccnt = 0;
            }
         }
         dptr++;
         continue;
      }
      ccnt = 0;

      switch (*dptr)
      {
         /***************************/
         /* non-printable character */
         /***************************/

         case 0x09 :

            /* tab */
            if (DocumentText)
            {
               fputs (" ", HttpOut);
               if (RevealCodes) fputs ("<TT>[tab]</TT>\n", HttpOut);
               if (RevealDump)
                  fprintf (HttpOut, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x0b :

            /* soft-page */
            PageNumber++;
            if (DocumentText)
            {
               if (RevealCodes) fputs ("<TT>[SPg]</TT>\n", HttpOut);
               if (RevealDump)
                  fprintf (HttpOut, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x0c :

            /* hard-page */
            PageNumber++;
            if (DocumentText)
            {
               if (RevealCodes) fputs ("<TT>[HPg]</TT>\n", HttpOut);
               if (RevealDump)
                  fprintf (HttpOut, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x0a :

            /* hard-return */
            if (DocumentText)
            {
               fputs ("<BR>\n", HttpOut);
               if (RevealCodes) fputs ("<TT>[HRt]</TT>\n", HttpOut);
               if (RevealDump)
                  fprintf (HttpOut, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x0d :

            /* soft-return */
            if (DocumentText)
            {
               fputs (" ", HttpOut);
               if (RevealCodes) fputs ("<TT>[SRt]</TT>\n", HttpOut);
               if (RevealDump)
                  fprintf (HttpOut, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x83 :

            /* ETX */
            if (DocumentText)
            {
               if (RevealCodes) fputs ("<TT><I>[etx]</I></TT>\n", HttpOut);
               if (RevealDump)
                  fprintf (HttpOut, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0x8c :

            /* soft-page */
            PageNumber++;
            if (DocumentText)
            {
               if (RevealCodes) fputs ("<TT>[SPg]</TT>\n", HttpOut);
               if (RevealDump)
                  fprintf (HttpOut, "<TT>{\%%%02.02x}</TT>\n", *dptr);
            }
            dptr++;
            break;

         case 0xa9 :

            /* hyphen */
            if (DocumentText)
            {
               fputs ("-", HttpOut);
               if (RevealCodes) fputs ("<TT>[-]</TT>", HttpOut);
               if (RevealDump)
                  fprintf (HttpOut, "<TT>{\%%%02.02x}</TT>", *dptr);
            }
            dptr++;
            break;

         case 0xc0 :

            dptr += Process0xc0 (dptr, zptr);
            break;

         case 0xc1 :

            dptr += Process0xc1 (dptr, zptr);
            break;

         case 0xc2 :

            dptr += Process0xc2 (dptr, zptr);
            break;

         case 0xc3 :

            dptr += Process0xc3 (dptr, zptr);
            break;

         case 0xc4 :

            dptr += Process0xc4 (dptr, zptr);
            break;

         case 0xc5 :

            dptr += Process0xc5 (dptr, zptr);
            break;

         case 0xc6 :

            dptr += Process0xc6 (dptr, zptr);
            break;

         case 0xc7 :
         case 0xc8 :
         case 0xc9 :
         case 0xca :
         case 0xcb :
         case 0xcc :
         case 0xcd :
         case 0xce :
         case 0xcf :

            dptr += Process0xcX (dptr, zptr);
            break;

         case 0xd0 :

            dptr += Process0xd0 (dptr, zptr);
            break;

         case 0xd1 :

            dptr += Process0xd1 (dptr, zptr);
            break;

         case 0xd2 :

            dptr += Process0xd2 (dptr, zptr);
            break;

         case 0xd3 :

            dptr += Process0xd3 (dptr, zptr);
            break;

         case 0xd4 :

            dptr += Process0xd4 (dptr, zptr);
            break;

         case 0xd5 :

            dptr += Process0xd5 (dptr, zptr);
            break;

         case 0xd7 :

            dptr += Process0xd7 (dptr, zptr, false);
            break;

         case 0xd8 :

            dptr += Process0xd8 (dptr, zptr);
            break;

         case 0xd9 :

            dptr += Process0xd9 (dptr, zptr);
            break;

         case 0xda :

            dptr += Process0xda (dptr, zptr);
            break;

         case 0xdb :

            dptr += Process0xdb (dptr, zptr);
            break;

         case 0xdc :

            dptr += Process0xdc (dptr, zptr);
            break;

         case 0xd6 :
         case 0xdd :
         case 0xde :
         case 0xdf :

            dptr += Process0xdX (dptr, zptr);
            break;

         default :

            if (DocumentText)
               if (RevealCodes) fprintf (HttpOut, "<TT>[%02.02x]</TT>", *dptr);
            dptr++;

      }  /* switch */

   } /* for(;;) */

   if (BuildTopicIndex)
   {
      if (MarkNumber)
         fputs ("</UL>\n<H2>Document follows:</H2>\n", HttpOut);
      else;
   }
   else
   if (DocumentText)
      fputs ("\n<P><HR>\n", HttpOut);
}

/*****************************************************************************/
/*
*/ 

NewPage ()

{
   /*********/
   /* begin */
   /*********/

   PreviousPageNumber = PageNumber;

   if (BuildTopicIndex) return;

   DocumentText = true;
   if (PageNumber == 1)
   {
      fprintf (HttpOut,
"\n\
<P><HR>\n\
<A NAME=\"Mark0\">\n\
<TT>Page %s</TT>\n\
</A>\n\
<P>\n",
      CurrentPageNumber());
   }
   else
   {
      fprintf (HttpOut,
"\n\
<P><HR>\n\
<TT>Page %s</TT>\n\
<P>\n",
      CurrentPageNumber());
   }
}

/*****************************************************************************/
/*
*/ 

char *CurrentPageNumber ()

{
   static char  *RomanUnits[] =
      { "","i","ii","iii","iv","v","vi","vii","viii","ix" };
   static char  *RomanTens[] =
      { "","x","xx","xxx","xl","l","lx","lxx","lxxx","xc" };
   static char  *RomanHundreds[] =
      { "","c","cc","ccc","cd","d","dc","dcc","dccc","cm" };
   static char  String [32];

   /*********/
   /* begin */
   /*********/

   if (SectionNumber > 1) RomanPageNumbers = false;
   if (RomanPageNumbers)
      sprintf (String, "%s%s%s",
               RomanHundreds[PageNumber/100],
               RomanTens[PageNumber/10],
               RomanUnits[PageNumber%10]);
      else
         sprintf (String, "%d", PageNumber);
   return (String);
}

/*****************************************************************************/
/*
Unknown 0xc? code.  Take a punt!  Most codes end in the same code they start
with, try and find it ... might break - but surely will otherwise!
*/ 

int Process0xcX
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   register unsigned char  *sptr;

   for (sptr = dptr; *sptr != *dptr && dptr < zptr; sptr++);
   if (!DocumentText) return (sptr - dptr);

   if (RevealCodes) fputs ("<TT>[0xdX]</TT>", HttpOut);
   if (DocumentText)
   {
      fputs ("<TT>[0xc?]</TT>", HttpOut);
      if (RevealDump) DumpCodes (dptr, sptr-dptr);
   }
   return (sptr - dptr);
}

/*****************************************************************************/
/*
*/ 

int Process0xc0
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (PageNumber != PreviousPageNumber) NewPage ();

   if (DocumentText)
   {
      switch (dptr[1])
      {
         case 0x03 :
            fputs ("* ", HttpOut);
            break;
         case 0x08 :
            fputs ("_", HttpOut);
            break;
         default :
            fputs (" ", HttpOut);
      }
      if (RevealCodes)
         fprintf (HttpOut, "<TT>[?:%d,%d]</TT>", dptr[2], dptr[1]);
      if (RevealDump) DumpCodes (dptr, 4);
   }
   return (4);
}

/*****************************************************************************/
/*
*/ 

int Process0xc1
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   switch (dptr[1])
   {
      case 0xe0 :
         if (DocumentText)
         {
            fputs (" ", HttpOut);
            if (RevealCodes) fputs ("<TT>[Centre]</TT>", HttpOut);
         }
         CentreCount++;
         break;
      default :
         if (DocumentText || AnchorText)
            fputs (" ", HttpOut);
         if (DocumentText)
            if (RevealCodes) fputs ("<TT>[spacing?]</TT>", HttpOut);
   }
   if (DocumentText && RevealDump) DumpCodes (dptr, 9);
   return (9);
}

/*****************************************************************************/
/*
*/ 

int Process0xc2
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      fputs (" ", HttpOut);
      if (RevealCodes) fputs ("<TT>[-&gt;Indent?]</TT>", HttpOut);
      if (RevealDump) DumpCodes (dptr, 11);
   }
   return (11);
}

/*****************************************************************************/
/*
*/ 

int Process0xc3
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      if (RevealCodes) fputs ("<TT>[font?]</TT>", HttpOut);
      if (RevealDump) DumpCodes (dptr, 3);
   }
   return (3);
}

/*****************************************************************************/
/*
*/ 

int Process0xc4
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      if (RevealDump) DumpCodes (dptr, 3);
      switch (dptr[1])
      {
         case 0x02 :
            if (RevealCodes) fputs ("<TT>[large]</TT>", HttpOut);
            break;
         case 0x08 :
            if (ItalicCount)
            {
               ItalicCount = 0;
               fputs ("</I> ", HttpOut);
            }
            if (RevealCodes) fputs ("<TT>[italic]</TT>", HttpOut);
            break;
         case 0x0c :
            if (BoldCount)
            {
               BoldCount = 0;
               fputs ("</B>", HttpOut);
            }
            if (RevealCodes) fputs ("<TT>[bold]</TT>", HttpOut);
            break;
         case 0x0e :
            if (UnderlineCount)
            {
               UnderlineCount = 0;
               fputs ("</U>", HttpOut);
            }
            if (RevealCodes) fputs ("<TT>[und]</TT>", HttpOut);
            break;
         default :
            if (RevealCodes) fputs ("<TT>[emphasis?]</TT>", HttpOut);
      }
   }
   return (3);
}

/*****************************************************************************/
/*
*/ 

int Process0xc5
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      fputs (" ", HttpOut);
      if (RevealCodes) fprintf (HttpOut, "<TT>[Block Pro:?]</TT>");
      if (RevealDump) DumpCodes (dptr, 5);
   }
   return (5);
}

/*****************************************************************************/
/*
*/ 

int Process0xc6
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   if (DocumentText)
   {
      fputs (" ", HttpOut);
      if (RevealCodes) fprintf (HttpOut, "<TT>[spacing]</TT>");
      if (RevealDump) DumpCodes (dptr, 6);
   }
   return (6);
}

/*****************************************************************************/
/*
An unknown 0xd? code.  Because 0xd? codes seem to have their length as the 
second short int of the structure calculate the length of this unknown one, 
then skip over it!
*/ 

int Process0xdX
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (DocumentText)
   {
      fputs ("<TT>[0xd?]</TT>", HttpOut);
      if (RevealDump)
      {
         DumpCodes (dptr, 4);
         fprintf (HttpOut, "<TT>(%d)</TT>", Length);
         DumpCodes (dptr+4, Length);
      }
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd0
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Tab Set:]</TT>", HttpOut);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (HttpOut, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd1
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Font?]</TT>", HttpOut);
   if (RevealDump)
   {
         DumpCodes (dptr, 4);
         fprintf (HttpOut, "<TT>(%d)</TT>", Length);
         DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd2
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Par Num Def:]</TT>", HttpOut);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (HttpOut, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd3
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   PageNumber = 1;
   SectionNumber++;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Page Num:]</TT>", HttpOut);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (HttpOut, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd4
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (DocumentText)
   {
      if (dptr[1])
      {
         switch (dptr[6])
         {
            case 0x7e :
               if (!UnderlineCount++) fputs ("<U>", HttpOut);
               if (RevealCodes) fputs ("<TT>[UND]</TT>", HttpOut);
               break;
            case 0x87 :
               if (!ItalicCount++) fputs (" <I>", HttpOut);
               if (RevealCodes) fputs ("<TT>[ITALIC]</TT>", HttpOut);
               break;
            case 0x85 :
            case 0xa0 :
               if (!BoldCount++) fputs ("<B>", HttpOut);
               if (RevealCodes) fputs ("<TT>[BOLD]</TT>", HttpOut);
               break;
            default :
               if (RevealCodes) fputs ("<TT>[EMPHASIS?]</TT>", HttpOut);
         }
      }
      else
         if (RevealCodes) fputs ("<TT>[EMPHASIS?]</TT>", HttpOut);

      if (RevealDump)
      {
         DumpCodes (dptr, 4);
         fprintf (HttpOut, "<TT>(%d)</TT>", Length);
         DumpCodes (dptr+4, Length);
      }
   }

   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd5
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Header/Footer]</TT>", HttpOut);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (HttpOut, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd7
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (dptr[1] == 0x00)
   {
      if (BuildTopicIndex)
      {
         if (!MarkNumber++)
         {
            fputs (
"<P><HR>\n\
<H2>Index of topics:</H2>\n\
<UL>\n\
<LI><A HREF=\"#Mark0\"><I>Start of Document</I></A>\n",
            HttpOut);
         }
         fprintf (HttpOut, "<LI><A HREF=\"#Mark%d\">", MarkNumber);
         AnchorText = true;
         AnchorTextCount = 0;
      }
      else
      {
         if (!DocumentText) return (Length+4);

         fprintf (HttpOut, "<A NAME=\"Mark%d\">", ++MarkNumber);
         if (RevealDump)
         {
            DumpCodes (dptr, 4);
            fprintf (HttpOut, "<TT>(%d)</TT>", Length);
            DumpCodes (dptr+4, Length);
         }
         else;
      }
   }
   else
   if (dptr[1] == 0x01)
   {
      if (BuildTopicIndex)
      {
         if (AnchorText)
         {
            if (AnchorTextCount)
               fprintf (HttpOut, "</A> <I>page %s</I>\n", CurrentPageNumber());
            else
               fprintf (HttpOut, 
"<I>(unknown heading)</I></A> <I>page %s</I>\n", CurrentPageNumber());
            AnchorText = false;
            AnchorTextCount = 0;
         }
         else;
      }
      else
      {
         if (!DocumentText) return (Length+4);

         fputs ("</A>", HttpOut);
         if (RevealCodes) fputs ("<TT>[Mark end]</TT>", HttpOut);
         if (RevealDump)
         {
            DumpCodes (dptr, 4);
            fprintf (HttpOut, "<TT>(%d)</TT>", Length);
            DumpCodes (dptr+4, Length);
         }
         else;
      }
   }
   else
   {
      if (!BuildTopicIndex)
      {
         if (RevealCodes) fputs ("<TT>[Mark?]</TT>", HttpOut);
         if (RevealDump)
         {
            DumpCodes (dptr, 4);
            fprintf (HttpOut, "<TT>(%d)</TT>", Length);
            DumpCodes (dptr+4, Length);
         }
      }
   }

   return (Length+4);
}

/*****************************************************************************/
/*
Automatically-numbered paragraphs (bit list a numeric list!)
*/ 

int Process0xd8
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   register unsigned char  *cptr, *sptr;

   int  Count;
   unsigned short  Length;
   unsigned char  String [256];

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Par Num:Auto]</TT>", HttpOut);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (HttpOut, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }

/*
   cptr = dptr+4;
   Count = Length;
   while (Count-- && !isdigit(*cptr)) cptr++;
   if (Count < 0) Count = 0;
   sptr = String;
   while (Count-- && *cptr != '.') *sptr++ = *cptr++;
   if (*cptr == '.') *sptr++ = *cptr;
   *sptr++ = ' ';
   *sptr = '\0';
   fputs (String, HttpOut);
*/
   cptr = dptr+4;
   Count = 0;
   while (Count++ < Length && !isdigit(*cptr)) cptr++;
   sptr = String;
   while (Count++ < Length && *cptr != '.') *sptr++ = *cptr++;
   if (*cptr == '.') *sptr++ = *cptr;
   *sptr++ = ' ';
   *sptr = '\0';
   fputs (String, HttpOut);

   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xd9
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Comment/Outline?]</TT>", HttpOut);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (HttpOut, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xda
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Fig Box:]</TT>", HttpOut);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (HttpOut, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xdb
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   if (RevealCodes) fputs ("<TT>[Style...]</TT>", HttpOut);
   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (HttpOut, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }
   return (Length+4);
}

/*****************************************************************************/
/*
*/ 

int Process0xdc
(
register unsigned char *dptr,
register unsigned char *zptr
)
{
   static int  ColumnCount = 0,
               RowCount = 0;

   unsigned short  Length;

   Length = *(unsigned short*)(dptr+2);
   if (!DocumentText) return (Length+4);

   switch (dptr[1])
   {
      case 0x00 :
         if (TableCount)
            while (ColumnCount <= dptr[5])
            {
               fputs ("<TD>", HttpOut);
               ColumnCount++;
            }
         if (RevealCodes)
            fprintf (HttpOut, "<TT>[Cell(%d)]</TT>", dptr[5]);
         break;

      case 0x01 :
         if (!TableCount++) fputs ("<TABLE BORDER NOWRAP>", HttpOut);
         if (TableCount) fputs ("<TR>", HttpOut);
         if (RevealCodes) fputs ("\n<BR><TT>[Row]</TT>", HttpOut);
         RowCount++;
         ColumnCount = 0;
         break;

      case 0x02 :
         if (TableCount)
         {
            fputs ("</TABLE>", HttpOut);
            TableCount = ColumnCount = RowCount = 0;
         }
         if (RevealCodes) fputs ("<TT>[Tbl Off]</TT>", HttpOut);
         break;

      default :
         if (RevealCodes) fputs ("<TT>[Table?]</TT>", HttpOut);
   }

   if (RevealDump)
   {
      DumpCodes (dptr, 4);
      fprintf (HttpOut, "<TT>(%d)</TT>", Length);
      DumpCodes (dptr+4, Length);
   }

   return (Length+4);
}

/*****************************************************************************/
/*
Display 'ccnt' number of bytes beginning with 'dptr', or if 'ccnt' is less 
than zero dump a null-terminated string beginning at 'dptr'.
*/ 

int DumpCodes
(
register unsigned char *dptr,
register int ccnt
)
{
   fputs ("<TT>", HttpOut);
   if (ccnt >= 0)
   {
      while (ccnt--)
      {
         fprintf (HttpOut, "{\%%%02.02x}", *dptr++);
         if (!(ccnt % 16)) fputs ("<BR>\n", HttpOut);
      }
   }
   else
   {
      ccnt = 0;
      while (*dptr)
      {
         fprintf (HttpOut, "{\%%%02.02x}", *dptr++);
         if (!(++ccnt % 16)) fputs ("<BR>\n", HttpOut);
      }
      fprintf (HttpOut, "{\%%%02.02x}", *dptr);
   }
   fputs ("</TT>", HttpOut);
}

/*****************************************************************************/
/*
The was no document specification supplied with the request, prompt for one.  
Has a check to prevent infinite looping in this type of request (i.e. if a 
user clicks on the "access" button without entering a specification!)
*/ 

DocumentNotSpecified ()

{
   char  *ScratchPtr;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "DocumentNotSpecified()\n");

   /* prevent user "looping" by not supplying a specification again! */
   GetCgiVar (ScratchPtr, "WWW_FORM_HWP");
   if (ScratchPtr[0])
   {
      ErrorGeneral ("No file specification supplied!", __FILE__, __LINE__);
      exit (SS$_NORMAL);
   }

   fprintf (HttpOut,
"%s\
<!-- SoftwareID: %s -->\n\
<TITLE>Hyper-WordPerfect, Specify Document</TITLE>\n\
<H1>%sSpecify Database</H1>\n\
<P> Other pages:\n\
<A HREF=\"%s?do=help\">Help</A>.\n\
<P><HR>\n\
<P> Provide the VMS file path to the required <TT>WordPerfect</TT>\n\
document (<TT>.WP</TT> default extension), or provide a VMS directory\n\
specification to generate an index to all <TT>.WP</TT> documents.\n\
<P>\n\
<FORM ACTION=%s>\n\
<INPUT TYPE=hidden NAME=hwp VALUE=yes>\n\
Specification: <INPUT TYPE=text NAME=document SIZE=40>\n\
<INPUT TYPE=submit VALUE=\"Access\">\n\
<INPUT TYPE=reset VALUE=\"Reset\">\n\
</FORM>\n\
<P><HR>\n",
   Http200Header,
   SoftwareID,
   IconImg,
   CgiScriptNamePtr,
   CgiScriptNamePtr);
}

/****************************************************************************/
/*
Provide anchors for all the .DBF files according to the specification provided 
in 'WpFileName'.
*/ 

IndexWildCardDocument ()

{
   int  status,
        FileCount = 0;
   char  ExpandedFileSpec [256];

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "IndexWildCardDocument()\n");

   /* initialize the file access block */
   WpFileFab = cc$rms_fab;
   WpFileFab.fab$l_fna = WpFileSpec;
   WpFileFab.fab$b_fns = strlen(WpFileSpec);
   WpFileFab.fab$l_dna = "*.WP;";
   WpFileFab.fab$b_dns = 5;
   WpFileFab.fab$l_fop = FAB$V_NAM;
   WpFileFab.fab$l_nam = &WpFileNam;

   /* initialize the file name block */
   WpFileNam = cc$rms_nam;
   WpFileNam.nam$l_esa = ExpandedFileSpec;
   WpFileNam.nam$b_ess = sizeof(ExpandedFileSpec)-1;
   WpFileNam.nam$l_rsa = WpFileName;
   WpFileNam.nam$b_rss = sizeof(WpFileName)-1;

   if (VMSnok (status = sys$parse (&WpFileFab, 0, 0)))
   {
      ErrorVmsStatus (status, PageTitlePtr, WpFileSpec, __FILE__, __LINE__);
      return;
   }

   fprintf (HttpOut,
"%s\
<!-- SoftwareID: %s -->\n\
<TITLE>Hyper-WordPerfect, Index of <TT>%s</TT></TITLE>\n\
<H1>%sIndex of <TT>%s</TT></H1>\n\
<P> Other pages:\n\
<A HREF=\"%s?do=help\">Help</A>.\n\
<P><HR>\n",
   Http200Header,
   SoftwareID,
   WpFileSpec,
   IconImg, WpFileSpec,
   CgiScriptNamePtr);

   while (VMSok (status = sys$search (&WpFileFab, 0, 0)))
   {
      /* ignore other than ".WP;", ".WP5", ".WPD" */
      if (*(unsigned long*)WpFileNam.nam$l_type != 0x3b50572e &&
          *(unsigned long*)WpFileNam.nam$l_type != 0x3550572e &&
          *(unsigned long*)WpFileNam.nam$l_type != 0x4450572e) continue;

      if (!FileCount++) fputs ("<OL>\n", HttpOut);

      *(char*)WpFileNam.nam$l_ver = '\0';
      fprintf (HttpOut, "<LI><A HREF=\"%s/%s\">%s</A>\n",
               CgiScriptNamePtr, WpFileName, (char*)WpFileNam.nam$l_name);
      *(char*)WpFileNam.nam$l_ver = ';';
   }
   if (status != RMS$_FNF && status != RMS$_NMF)
   {
      ErrorVmsStatus (status, PageTitlePtr, WpFileName,
                      __FILE__, __LINE__);
      return;
   }

   if (FileCount)
      fputs ("</OL>\n<P><HR>\n", HttpOut);
   else
      fputs ("<P>\nNo <TT>.WP</TT> files found.\n<P><HR>\n", HttpOut);
}

/*****************************************************************************/
/*
*/

ErrorGeneral
(
char *Text,
char *SourceFileName,
int SourceLineNumber
)
{
   register char  *cptr;

   /*********/
   /* begin */
   /*********/

   /* 
      The source file format provided by the "__FILE__" macro will be
      "device:[directory]name.type;ver".  Reduce that to "name.type".
   */
   for (cptr = SourceFileName; *cptr && *cptr != ';'; cptr++);
   if (*cptr)
   {
      while (*cptr != '.') cptr--;
      *cptr-- = '\0';
   }
   while (*cptr != ']') cptr--;
   cptr++;

   if (!HttpHasBeenOutput) fputs (Http404Header, HttpOut);
   fprintf (HttpOut,
"<!-- SoftwareID: %s Module: %s Line: %d -->\n\
<H1>ERROR!</H1>\n\
<P>Reported by server.\n\
<P>%s\n",
   SoftwareID, cptr, SourceLineNumber, Text);
}

/*****************************************************************************/
/*
*/

ErrorVmsStatus
(
int StatusValue,
char *Text,
char *HiddenText,
char *SourceFileName,
int SourceLineNumber
)
{
   static char  Message [256];
   static $DESCRIPTOR (MessageDsc, Message);

   register char  *cptr;
   int  status;
   short int  Length;

   /*********/
   /* begin */
   /*********/

   if (VMSok (status = sys$getmsg (StatusValue, &Length, &MessageDsc, 1, 0))) 
   {
      Message[Length] = '\0';
      Message[0] = toupper(Message[0]);
   }
   else
      exit (status);

   /* 
      The source file format provided by the "__FILE__" macro will be
      "device:[directory]name.type;ver".  Reduce that to "name.type".
   */
   for (cptr = SourceFileName; *cptr && *cptr != ';'; cptr++);
   if (*cptr)
   {
      while (*cptr != '.') cptr--;
      *cptr-- = '\0';
   }
   while (*cptr != ']') cptr--;
   cptr++;

   if (!HttpHasBeenOutput) fputs (Http404Header, HttpOut);
   fprintf (HttpOut,
"<!-- SoftwareID: %s Module: %s Line: %d -->\n\
<H1>ERROR!</H1>\n\
<P>Reported by server.\n\
<P>%s ... <TT>%s</TT>\n\
<!-- %%X%08.08X \"%s\" -->\n",
   SoftwareID, cptr, SourceLineNumber, Message, Text, StatusValue, HiddenText);
}

/****************************************************************************/
/*
Does a case-insensitive, character-by-character string compare and returns 
true if two strings are the same, or false if not.  If a maximum number of 
characters are specified only those will be compared, if the entire strings 
should be compared then specify the number of characters as 0.
*/ 

boolean strsame
(
register char *sptr1,
register char *sptr2,
register int  count
)
{
   while (*sptr1 && *sptr2)
   {
      if (toupper (*sptr1++) != toupper (*sptr2++)) return (false);
      if (count)
         if (!--count) return (true);
   }
   if (*sptr1 || *sptr2)
      return (false);
   else
      return (true);
}

/*****************************************************************************/

