/*****************************************************************************/
/*
                             HyperSpi.h

Header file for Hypertext System Performance Information facility.


VERSION HISTORY
---------------
20-JUN-95  MGD  v1.0.0, initial development
*/
/*****************************************************************************/

#define HyperSpiDataDirectory  "HYPERSPI$DATA:"
#define HyperSpiDataVersion "1"

#ifdef __ALPHA
#   pragma member_alignment __save
#   pragma nomember_alignment
#endif

/* size, as of 22-JUN-95, 54 bytes */

struct HyperSpiData
{
   unsigned char  Minute;
   unsigned char  Hour;
   unsigned char  Day;
   unsigned char  Month;
   unsigned short  Year;
   unsigned char  NumberOfCPUs;
   unsigned short  SystemMemoryMBytes;
   unsigned char  SystemMemoryPercentInUse;
   unsigned short  PageSpaceMBytes;
   unsigned char  PageSpacePercentInUse;
   unsigned short  NumberOfProcesses;
   unsigned char  PercentCPU;
   unsigned char  PeakPercentCPU;
   unsigned char  PercentUserModeCPU;
   unsigned char  PeakPercentUserModeCPU;
   unsigned long  PageFaults;
   unsigned short  PeakPageFaults;
   unsigned long  HardPageFaults;
   unsigned short  PeakHardPageFaults;
   unsigned long  BufferedIO;
   unsigned short  PeakBufferedIO;
   unsigned long  DirectIO;
   unsigned short  PeakDirectIO;
   unsigned long  MscpIO;
   unsigned short  PeakMscpIO;
};

#ifdef __ALPHA
#   pragma member_alignment __restore
#endif

/****************************************************************************/

