/*****************************************************************************/
/*
                              Authenticate.c


BUILD DETAILS
-------------
See BUILD_AUTHENTICATE.COM procedure.


VERSION HISTORY (update SoftwareID as well!)
---------------
19-SEP-95  MGD  v1.1.1, replace <CR><LF> carriage-control with single newline,
                        still acceptable for HTTP, and slightly more efficient
24-MAY-95  MGD  v1.1.0, minor changes for AXP compatibility
07-APR-95  MGD  v1.0.0, initial development
*/
/*****************************************************************************/

#ifdef __ALPHA
   char SoftwareID [] = "AUTHENTICATE AXP-1.1.1";
#else
   char SoftwareID [] = "AUTHENTICATE VAX-1.1.1";
#endif

/* standard C header files */
#include <stdio.h>
#include <ctype.h>
#include <errno.h>
#include <unixio.h>

/* VMS-related header files */
#include <descrip.h>
#include <libdef.h>
#include <ssdef.h>
#include <stsdef.h>

#ifdef __ALPHA
#   pragma nomember_alignment
#endif

#define boolean int
#define true 1
#define false 0

#define VMSok(x) ((x) & STS$M_SUCCESS)
#define VMSnok(x) (!((x) & STS$M_SUCCESS))
 
boolean  Debug;

/*****************************************************************************/
/*
*/

main (int argc, char *argv[])

{
   register char *cptr;

   char  CgiRemoteUser [256];
   FILE  *HttpOut;

   /*********/
   /* begin */
   /*********/

   if (argc == 1) exit (SS$_INSFARG);

   GetCgiVariable ("WWW_REMOTE_USER", CgiRemoteUser, sizeof(CgiRemoteUser));

   if (CgiRemoteUser[0]) exit (SS$_NORMAL);

   /* open another output stream so that the "\n" are not filtered */
#ifdef __DECC
   if ((HttpOut = fopen ("SYS$OUTPUT", "w", "ctx=bin")) == NULL)
      exit (vaxc$errno);
#else
   if ((HttpOut = fopen ("SYS$OUTPUT", "w", "rfm=udf")) == NULL)
      exit (vaxc$errno);
#endif

   for (cptr = __FILE__; *cptr && *cptr != ';'; cptr++);
   if (*cptr)
   {
      while (*cptr != '.') cptr--;
      *cptr-- = '\0';
   }
   while (*cptr != ']') cptr--;
   cptr++;

   fprintf (HttpOut,
"HTTP/1.0 401 Authentication failure.\n\
WWW-Authenticate: Basic realm=\"%s\"\n\
Content-Type: text/html\n\
\n\
<!-- SoftwareID: %s Module: %s Line: %d -->\n\
<H1>ERROR!</H1>\n\
<P>Reported by server.\n\
<P>Authentication failure.\n",
   argv[1], SoftwareID, cptr, __LINE__);

   fclose (HttpOut);

   sys$delprc (0, 0);
}

/*****************************************************************************/
/*
*/

boolean GetCgiVariable
(
char *VariableName,
char *VariableValue,
int VariableValueSize
)
{
   static $DESCRIPTOR (VariableNameDsc, "");
   static $DESCRIPTOR (VariableValueDsc, "");

   register int  status;

   unsigned short  Length;

   /*********/
   /* begin */
   /*********/

   if (Debug) fprintf (stdout, "GetCgiVariable() |%s|\n", VariableName);

   VariableNameDsc.dsc$w_length = strlen(VariableName);
   VariableNameDsc.dsc$a_pointer = VariableName;
   VariableValueDsc.dsc$w_length = VariableValueSize-1;
   VariableValueDsc.dsc$a_pointer = VariableValue;

   if (VMSok (status =
       lib$get_symbol (&VariableNameDsc, &VariableValueDsc, &Length, 0)))
      VariableValue[Length] = '\0';
   else
      VariableValue[0] = '\0';

   if (status == LIB$_NOSUCHSYM) return (false);
   if (VMSnok (status))
   {
      if (Debug) fprintf (stdout, "lib$get_symbol() %%X%08.08X\n", status);
      exit (status);
   }
   if (Debug) fprintf (stdout, "|%s|\n", VariableValue);
   return (true);
}

/*****************************************************************************/

