C	Video display command program. Calling sequence is
C	CALL UVT100(CMD,N1,N2), where CMD is one of the commands in
C	the parameter list below, and N1 and N2 are optional parameters
C	depending upon CMD. See the UVT100 user's manual for more details.
C
C Screen independent (SMG) variant for AnalytIcalc ONLY. UVT100 compatible
C (more or less). If the terminal does not have reverse video, it uses
C the leftmost column of a cell to hold a special character (">" in this
C case) to indicate one's position on the screen. By main force &
C awkwardness it will move this around wherever needed. Only entries
C called by AnalytIcalc are supported here, many as no-ops.
C This version may be used only on VMS; its output is strictly SMG I/O to
C virtual display DISPLY.
C
C	Author:	Glenn Everhart
C		Larry W. Finger - screen independent version
C		Chris Doran, Sira, 10-Oct-90, SMG version
C
	SUBROUTINE UVT100 ( CMD, N1, N2 )
	IMPLICIT INTEGER ( A - Z )
	INCLUDE '($DCDEF)'
	INCLUDE '($SMGDEF)'
	INCLUDE '($SMGTRMPTR)'
	INCLUDE '($TTDEF)'
	INCLUDE '($TT2DEF)'
	INCLUDE 'VKLUGPRM.FTN'
	PARAMETER CUP = 1, CUU = 2, CUD = 3, CUF = 4, CUB = 5, DECDWL = 6
     $, DECDHL = 7, DECRC = 8, DECSC = 9, DECSWL = 10, ED = 11, EL = 12
     $, SGR = 13, NEL = 14, SCS = 15, SM = 16, RM = 17, ANSI = 18
     $, DECKPAM = 0, DECKPNM = 0, DECCOLM = 3
	LOGICAL*1 FVLD
	DIMENSION FVLD(RRW,RCL)
	RECORD /SMG$R_ATTRIBUTE_INFO_BLOCK/PBDINF
	COMMON /FVLDC/FVLD
	InTEgeR*4 PROW,PCOL,DROW,DCOL,DRWV,DCLV
	InTEgeR*4 LLCMD,LLDSP
	COMMON/DCTL/PROW,PCOL,DROW,DCOL,DRWV,DCLV,LLCMD,LLDSP
	InTEgeR*4 S7FLG,SCFG
	INTEGER*4 SMG$ERASE_LINE,TTABLE
	INTEGER*4 PASTE,DISPLY,KEYBD,KEYTBL,RENDIT,TTYPE,DEVDP2
	COMMON /SMG/PASTE,DISPLY,KEYBD,KEYTBL,RENDIT,TTYPE,DEVDP2
	INTEGER*4 SCROW,SCCOL,SCREND
	DATA SCROW,SCCOL,SCREND/1,1,0/
	DATA IFIRST/0/
C
	IF(IFIRST.EQ.0)THEN
C Set no of display columns to 7 for 80-character screen width, 12 for 132
	  CALL SMG$CREATE_PASTEBOARD(PASTE,,,DRWV)
	  DRWV=(DRWV-6)/10
C Get terminal information and set KVTINC nonzero if reverse video is available
	  CALL SMG$GET_PASTEBOARD_ATTRIBUTES(PASTE,PBDINF,
     1		SMG$C_PASTEBOARD_INFO_BLOCK)
	  IF (PBDINF.SMG$B_DEV_CLASS .EQ. DC$_TERM) THEN
	    TTYPE = PBDINF.SMG$B_DEV_TYPE
	  ELSE
	    TTYPE = TT$_UNKNOWN
	  ENDIF
	  DEVDP2 = PBDINF.SMG$L_DEV_DEPEND2
	  KVTINC=0
	  CALL SMG$INIT_TERM_TABLE_BY_TYPE(TTYPE,TTABLE)
	  CALL SMG$GET_TERM_DATA(TTABLE,SMG$K_BEGIN_REVERSE,10,
     1		KVTINC,WRK)
	  IF(KVTINC.NE.0) KVTINC=1
	  CALL SMG$CREATE_VIRTUAL_DISPLAY(24,132,DISPLY)
	  CALL SMG$SET_DISPLAY_SCROLL_REGION(DISPLY)
	  CALL SMG$PASTE_VIRTUAL_DISPLAY(DISPLY,PASTE,1,1)
	  CALL SMG$CREATE_VIRTUAL_KEYBOARD(KEYBD,'SYS$COMMAND')
	  IFIRST=1
	END IF
C
	IF(.NOT.((CMD.EQ.SCS).OR.(CMD.EQ.ANSI))) GO TO 1000
C
C IGNORE SELECT CHARACTER SET, AND ANSI ENTRIES
C
	SCFG=0
	RETURN
1000	IF(CMD.NE.CUP)GO TO 1010
C POSITION CURSOR
	CALL SMG$SET_CURSOR_ABS(DISPLY, MAX0(1,N1), MAX0(1,N2))
C SAVE COORDINATES
	SAVELINE=N1
	SAVECOLUMN=N2
	SCFG=1
	RETURN
1010	IF(CMD.NE.ED)GO TO 1020
C ERASE ENTIRE DISPLAY
	CALL SMG$ERASE_DISPLAY(DISPLY)
	SCFG=0
	RETURN
1020	IF(CMD.NE.EL)GO TO 1030
C ERASE LINE
	IF(N1.EQ.2) CALL SMG$SET_CURSOR_ABS(DISPLY,,1)
	CALL SMG$ERASE_LINE(DISPLY)
	SCFG=0
	RETURN
1030	IF(CMD.NE.SGR)GO TO 1060
C SET GRAPHICS RENDITION
	IF(KVTINC.NE.0)GO TO 1050
C
C NOT ANSI
	IF(N1.NE.7)GO TO 1040
	IF(SCFG.NE.1)RETURN
	IF(PROW.LE.0.OR.PCOL.LE.0)RETURN
	IF(PROW.GT.RRW.OR.PCOL.GT.RCL)RETURN
	IF(FVLD(PROW,PCOL).EQ.0)RETURN
C LOCATION VALID
	CSAVE=SAVECOLUMN
	RSAVE=SAVELINE
	S7FLG=1
	RETURN
C SGR ARGUMENT NOT 7
1040	IF(SCFG.NE.1)RETURN
	IF(S7FLG.NE.1)RETURN
C REPOSITION CURSOR
	CALL SMG$PUT_CHARS(DISPLY,'>',RSAVE,CSAVE)
	CALL SMG$SET_CURSOR_ABS(SAVELINE,SAVECOLUMN)
	S7FLG=0
	RETURN
C Set renditions: CLEAR ALL IF N1 = 0
C		  OR IN BOLD IF N1 = 1
C		  OR IN UNDERLINE IF N1 = 4
C		  OR IN BLINK IF N1 = 5
C		  OR IN REVERSE IF N1 = 7
1050	IF(N1.EQ.0)THEN
	  RENDIT=0
	ELSE IF (N1.EQ.7) THEN
	  RENDIT=RENDIT.OR.SMG$M_REVERSE
	ELSE IF (N1.EQ.4) THEN
	  RENDIT=RENDIT.OR.SMG$M_UNDERLINE
	ELSE IF (N1.EQ.1) THEN
	  RENDIT=RENDIT.OR.SMG$M_BOLD
	ELSE IF (N1.EQ.5) THEN
	  RENDIT=RENDIT.OR.SMG$M_BLINK
	END IF
	RETURN
C SM/RM -- ONLY SUPPORT: DECCOLM = 3, SET WIDTH 132/80
C	   AND (A FAKE)	 DECKPAM/DECKPNM = 0, SET APPLICATION/NUMERIC KEYPAD
1060	IF(CMD.NE.SM) GOTO 1070
	IF (N1.EQ.DECKPAM) THEN
	  CALL SMG$SET_KEYPAD_MODE(KEYBD,SMG$M_KEYPAD_APPLICATION)
	ELSE IF (N1.EQ.DECCOLM) THEN
	  CALL SMG$CHANGE_PBD_CHARACTERISTICS(PASTE,132)
	ENDIF
	RETURN
1070	IF(CMD.NE.RM) GOTO 1080
	IF (N1.EQ.DECKPNM) THEN
	  CALL SMG$SET_KEYPAD_MODE(KEYBD,0)
	ELSE IF (N1.EQ.DECCOLM) THEN
	  CALL SMG$CHANGE_PBD_CHARACTERISTICS(PASTE,80)
	ENDIF
	RETURN
C NEL -- CR/LF, scrolling if necessary (used by interactive CALC)
1080	IF(CMD.NE.NEL) GOTO 1090
	CALL LCRLF(6)
C DECSC -- Save current cursor position and rendition
1090	IF (CMD.NE.DECSC) GOTO 1100
	CALL SMG$RETURN_CURSOR_POS(DISPLY,SCROW,SCCOL)
	SCREND = RENDIT
	RETURN
C DECRC -- Restore current cursor position and rendition
1100	IF (CMD.NE.DECRC) GOTO 1110
	CALL SMG$SET_CURSOR_ABS(DISPLY,SCROW,SCCOL)
	RENDIT = SCREND
	RETURN
C IGNORE ALL OTHER CODES
1110	RETURN
	END
